/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.9/Clib/foreign.c            */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Oct 19 08:45:22 1993                          */
/*    Last change :  Thu Jul 18 12:00:08 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    La gestion de l'interface etrangere                              */
/*=====================================================================*/
#include <bigloo2.0a.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    cobj_to_foreign ...                                              */
/*---------------------------------------------------------------------*/
obj_t
cobj_to_foreign( id, cobj )
obj_t          id;
unsigned long  cobj;
{
   obj_t handle;

   handle = GC_MALLOC( FOREIGN_SIZE );
   
   handle->foreign_t.header = MAKE_HEADER( FOREIGN_TYPE, FOREIGN_SIZE );
   handle->foreign_t.cobj   = (void *)cobj;
   handle->foreign_t.id     = id;

   return BREF( handle );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    obj_to_cobj ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
obj_to_cobj( obj )
obj_t obj;
{
   if( INTEGERP( obj ) )
      return (obj_t)CINT( obj );
   if( BOOLEANP( obj ) )
      return (obj_t)((long)CBOOL( obj ));
   if( STRINGP( obj ) )
      return (obj_t)BSTRING_TO_STRING( obj );
   if( CHARP( obj ) )
      return (obj_t)((long)CCHAR( obj ));
   if( FOREIGNP( obj ) )
      return (obj_t)FOREIGN_TO_COBJ( obj );
   if( REALP( obj ) )
      return the_failure( string_to_bstring( "obj->cobj" ),
			  string_to_bstring( "Can't cast a real to foreign" ),
			  obj);
   else
      return the_failure( string_to_bstring( "obj->cobj" ),
			  string_to_bstring( "Illegal object type" ),
			  obj);
}
 
