/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.8/Clib/eval.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Sep 24 10:20:30 1993                          */
/*    Last change :  Tue May 16 13:50:34 1995 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Quelques petites fonctions pour l'interprete (principalement     */
/*    des fonctions de debug et de trace)                              */
/*=====================================================================*/
#include <bigloo2.0a.h>

/*---------------------------------------------------------------------*/
/*    Des variables de controle                                        */
/*---------------------------------------------------------------------*/
static obj_t eval_name, wrong_number, not_a_proc;

/*---------------------------------------------------------------------*/
/*    Une recup ...                                                    */
/*---------------------------------------------------------------------*/
extern long  list_length();
extern obj_t string_to_bstring();

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    init_eval_cnst ...                                               */
/*---------------------------------------------------------------------*/
void
init_eval_cnst()
{
   eval_name    = string_to_bstring( "eval" );
   wrong_number = string_to_bstring( "wrong number of argument for" );
   not_a_proc   = string_to_bstring( "Not a procedure" );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_0 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_0( name, fun )
obj_t name, fun;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 0 ) )
         return PROCEDURE_ENTRY( fun )( fun, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_1 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_1( name, fun, a0 )
obj_t name, fun, a0;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 1 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}
       
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_2 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_2( name, fun, a0, a1 )
obj_t name, fun, a0, a1;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 2 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, a1, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}
       
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_3 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_3( name, fun, a0, a1, a2 )
obj_t name, fun, a0, a1, a2;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 3 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, a1, a2, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_4 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_4( name, fun, a0, a1, a2, a3 )
obj_t name, fun, a0, a1, a2, a3;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 4 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, a1, a2, a3, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    eval_apply ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
eval_apply( name, fun, list )
obj_t name, fun, list;
{
   if( PROCEDUREP( fun ) )
   {
      long len = list_length( list );

      if( PROCEDURE_CORRECT_ARITYP( fun, len ) )
         return apply( fun, list );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}
      





