/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cdsssl.c                */
/*    -------------------------------------------------------------    */
/*    Author      :  SERRANO Manuel                                    */
/*    Creation    :  Thu Apr  3 11:37:14 1997                          */
/*    Last change :  Sun Nov 29 19:16:04 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    C Dsssl support.                                                 */
/*=====================================================================*/
#include <string.h>
#include <bigloo2.0a.h>

/*---------------------------------------------------------------------*/
/*    Some prototypes                                                  */
/*---------------------------------------------------------------------*/
extern obj_t string_to_keyword();
static obj_t make_keyword();
extern obj_t make_vector();

/*---------------------------------------------------------------------*/
/*    Global Keyword table                                             */
/*---------------------------------------------------------------------*/
static obj_t c_keytab;

/*---------------------------------------------------------------------*/
/*    init_keyword_table ...                                           */
/*---------------------------------------------------------------------*/
init_keyword_table()
{
   c_keytab = make_vector( KEYWORD_HASH_TABLE_SIZE, BNIL );
}
           
/*---------------------------------------------------------------------*/
/*    make_keyword ...                                                 */
/*---------------------------------------------------------------------*/
static obj_t
make_keyword( char *name )
{
   obj_t keyword;

   keyword = GC_MALLOC( KEYWORD_SIZE );
   
   keyword->symbol_t.header = MAKE_HEADER( KEYWORD_TYPE, KEYWORD_SIZE );
   keyword->symbol_t.string = string_to_bstring( name );
   keyword->symbol_t.cval   = BNIL;
   
   return BREF( keyword );
}
   
/*---------------------------------------------------------------------*/
/*    string_to_keyword ...                                            */
/*    char * --> obj_t                                                 */
/*---------------------------------------------------------------------*/
obj_t
string_to_keyword( char *name )
{
   long hash_number;
   obj_t bucket;

   hash_number = get_hash_power_number( name, KEYWORD_HASH_TABLE_SIZE_SHIFT );
   bucket = VECTOR_REF( c_keytab, hash_number );
   
   if( NULLP( bucket ) )
   {
      obj_t keyword = make_keyword( name );
      obj_t pair    = MAKE_PAIR( keyword, BNIL );
      
      VECTOR_SET( c_keytab, hash_number, pair );
      
      return keyword;
   }
   else
   {
      obj_t run = bucket, back = bucket;
      
      while( !NULLP( run ) &&
	     strcmp( BSTRING_TO_STRING( KEYWORD(CAR( run )).string ), name ) )
         back = run, run = CDR( run );
      
      if( !NULLP( run ) )
         return CAR( run );
      else
      {
         obj_t keyword = make_keyword( name );
	 obj_t pair    = MAKE_PAIR( keyword, BNIL );
	 
         SET_CDR( back, pair );

         return keyword;
      }
   }
}


