/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cbinary.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Jun  7 09:02:35 1994                          */
/*    Last change :  Sun Oct  4 13:51:46 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    La gestion des ports binaire d'entree et de sortie.              */
/*=====================================================================*/
#include <stdio.h>
#include <errno.h>
#if( !(defined( NeXT ) && (defined( mc68000 ) || defined( i386 ))) )
#   include <termio.h>
#endif
#if( !defined( sony_news ) && \
     !(defined( NeXT ) && (defined( mc68000 ) || defined( i386 ))) )
#   include <unistd.h>
#endif
#include <sys/file.h>
/*---------------------------------------------------------------------*/
/*    On definit cette macros pour que le fichier `gc_private.h' ne    */
/*    soit pas inclus. Il faut faire ca car ce fichier declare un      */
/*    prototype de `sbrk' qui n'est pas compatible avec le prototype   */
/*    quelque fois present (sur linux, par exemple) dans `unisys.h'    */
/*---------------------------------------------------------------------*/
#if( defined( i386 ) )
#   define GC_PRIVATE_H
#endif
#include <bigloo2.0a.h>
#if( !defined( __alpha ) && !defined( sony_news ) && \
	  !(defined( NeXT ) && defined( mc68000 )) )
#   include <ctype.h>
#endif

/*---------------------------------------------------------------------*/
/*    MAGIC_WORD ...                                                   */
/*---------------------------------------------------------------------*/
#if defined( MAGIC_WORD )
#   undef MAGIC_WORD
#endif

#define MAGIC_WORD "1966"

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t obj_to_string(), string_to_obj();
extern obj_t c_constant_string_to_string();
extern obj_t string_to_symbol();

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    make_binary_port ...                                             */
/*    -------------------------------------------------------------    */
/*    Cette procedure alloue tous les ports binaires. Qu'ils soient    */
/*    en sortie ou en entree.                                          */
/*---------------------------------------------------------------------*/
static obj_t
make_binary_port( name, file, io )
char   *name;
FILE   *file;
bool_t  io;
{
   obj_t binary_port;

   binary_port = GC_MALLOC( BINARY_PORT_SIZE );

   binary_port->binary_port_t.header = MAKE_HEADER( BINARY_PORT_TYPE, 0 );
   binary_port->binary_port_t.file   = file;
   binary_port->binary_port_t.name   = name;
   binary_port->binary_port_t.io     = io;
   
   return BREF( binary_port );
}

/*---------------------------------------------------------------------*/
/*    open_output_binary_file ...                                      */
/*---------------------------------------------------------------------*/
obj_t
open_output_binary_file( name )
obj_t name;
{
   FILE *file;
   
   if( !(file = fopen( BSTRING_TO_STRING( name ), "w" )) )
      return BFALSE;

   return make_binary_port( BSTRING_TO_STRING( name ),
			    file,
			    BINARY_PORT_OUT );
}

/*---------------------------------------------------------------------*/
/*    append_output_binary_file ...                                    */
/*---------------------------------------------------------------------*/
obj_t
append_output_binary_file( name )
obj_t name;
{
   FILE *file;
   
   if( !(file = fopen( BSTRING_TO_STRING( name ), "a+" )) )
      return BFALSE;

   return make_binary_port( BSTRING_TO_STRING( name ),
			    file,
			    BINARY_PORT_OUT );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    close_binary_port ...                                            */
/*---------------------------------------------------------------------*/
obj_t
close_binary_port( port )
obj_t port;
{
   fclose( BINARY_PORT( port ).file );

   return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    open_input_binary_file ...                                       */
/*---------------------------------------------------------------------*/
obj_t
open_input_binary_file( name )
obj_t name;
{
   FILE *file;
   obj_t binary_port;

   if( !(file = fopen( BSTRING_TO_STRING( name ), "r" )) )
      return BFALSE;
   else
   { 
      binary_port = make_binary_port( BSTRING_TO_STRING( name ),
				      file,
				      BINARY_PORT_IN );
      return BREF( binary_port );
   }
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    output_obj ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
output_obj( port, obj )
obj_t port, obj;
{
   FILE          *file = BINARY_PORT( port ).file;
   obj_t          string;
   unsigned char  slen[ 4 ];
   long           clen;

   /* Le calcul de la chaine a dumper */
   string = obj_to_string( obj );

   /* Le mot magique */
   fwrite( MAGIC_WORD, 4, 1, file );

   /* La longueur de la chaine */
   clen = STRING_LENGTH( string );
	
   slen[ 0 ] = (unsigned char)clen;
   slen[ 1 ] = (unsigned char)(clen>>8);
   slen[ 2 ] = (unsigned char)(clen>>16);
   slen[ 3 ] = (unsigned char)(clen>>24);
	
   fwrite( slen, 4, 1, file );
	
   /* La chaine elle meme */
   fwrite( BSTRING_TO_STRING( string ), clen, 1, file );
   
   return obj;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    input_obj ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
input_obj( port )
obj_t port;
{
   FILE           *file = BINARY_PORT( port ).file;
   unsigned char   slen[ 4 ];
   long            clen;
   char            magic[ 4 ];
#if( defined( BIGLOO_DEBUG ) )
   PUSH_TRACE( string_to_symbol( "input_obj" ) );
#endif
	
   /* la cle magique */
   fread( magic, 4, 1, file );

   if( memcmp( magic, MAGIC_WORD, 4 ) )
      FAILURE( c_constant_string_to_string( "input_obj" ),
	       c_constant_string_to_string( "corrupted file" ),
	       port );

   /* la longueur */
   fread( slen, 4, 1, file );

   clen = ((long)slen[ 0 ]) + (((long)slen[ 1 ]) << 8) +
          (((long)slen[ 2 ]) << 16) + (((long)slen[ 3 ]) << 24);

   /* On fait deux cas en fonction de la taille de l'objet a lire */
   if( clen < 1024 )
   {
      char  string[ 1024 + STRING_SIZE ];
      obj_t res;

#if( !defined( TAG_STRING ) || defined( BUMPY_GC ) )
      ((obj_t)string)->string_t.header = MAKE_HEADER( STRING_TYPE, 0 );
#endif		
      ((obj_t)string)->string_t.length = clen;
      
      fread( BSTRING_TO_STRING( BSTRING( string ) ), clen, 1, file );

      res = string_to_obj( BSTRING( string ) );

#if( defined( BIGLOO_DEBUG ) )
      POP_TRACE();
#endif
      return res;
   }
   else
   {
      char  *string;
      obj_t  res;

      string = (char *)malloc( STRING_SIZE + clen );

      if( !string )
         FAILURE( c_constant_string_to_string( "input_obj" ),
		  c_constant_string_to_string( "can't allocate string" ),
		  port );

#if( !defined( TAG_STRING ) || defined( BUMPY_GC ) )
      ((obj_t)string)->string_t.header = MAKE_HEADER( STRING_TYPE, 0 );
#endif		
      ((obj_t)string)->string_t.length = clen;
		
      fread( BSTRING_TO_STRING( BSTRING( string ) ), clen, 1, file );
      
      res = string_to_obj( BSTRING( string ) );

      free( string );
		
#if( defined( BIGLOO_DEBUG ) )
      POP_TRACE(); 
#endif
		
      return res;
   }
}
		

	
