/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.8/Clib/apply.c              */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Mar 20 11:26:29 1992                          */
/*    Last change :  Tue Sep  5 09:41:46 1995 (serrano)                */
/*                                                                     */
/*    Le apply qui a lieu a runtime.                                   */
/*---------------------------------------------------------------------*/
#include <bigloo2.0a.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern void c_error();

/*---------------------------------------------------------------------*/
/*    apply ...                                                        */
/*    -------------------------------------------------------------    */
/*    Tous les tests d'arite ont ete expanses `inline'. On n'a plus    */
/*    qu'a faire l'appel.                                              */
/*---------------------------------------------------------------------*/
obj_t
apply( function, args_list )
obj_t function, args_list;
{
   long arity = PROCEDURE_ARITY(function);

   if (arity < 0)
   {
      long require;
      obj_t arg[16];
      obj_t runner = args_list;
      long i = 0;

      require = -arity - 1;

      while (i < require)
      {
	 arg[i++] = CAR(runner);
         runner = CDR( runner );
      }
#define CALL( proc ) ((obj_t (*)())PROCEDURE_VA_ENTRY( proc ))
      switch (arity)
      {
         case -1:
            return CALL( function )(function, runner);
         
         case -2:
	    return CALL( function )(function, arg[ 0 ], runner);
         
         case -3:
	    return CALL( function )(function, arg[ 0 ], arg[ 1 ], runner);
         
		    
          case -4:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   runner);
		    
          case -5:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], runner);
		    
          case -6:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], runner);
		    
          case -7:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   runner);
		    
          case -8:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], runner);
		    
          case -9:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], runner);
		    
          case -10:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   runner);
		    
          case -11:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   arg[9], runner);
		    
          case -12:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   arg[9], arg[10], runner);
		    
          case -13:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   arg[9], arg[10], arg[11],
				   runner);
		    
          case -14:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   arg[9], arg[10], arg[11],
				   arg[12], runner);
		    
          case -15:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   arg[9], arg[10], arg[11],
				   arg[12], arg[13], runner);
		    
          case -16:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   arg[9], arg[10], arg[11],
				   arg[12], arg[13], arg[14],
				   runner);
		    
          case -17:
	    return CALL(function) (function, arg[0], arg[1], arg[2],
				   arg[3], arg[4], arg[5],
				   arg[6], arg[7], arg[8],
				   arg[9], arg[10], arg[11],
				   arg[12], arg[13], arg[14],
				   arg[15], runner);

          default: 
	    c_error("too many arguments provided in funcall",
		    "",
		    -6);
	 }
   }
   else
   {
      obj_t arg[16];
      obj_t runner = args_list;
      long i = 0;
      
      while (i < arity)
      {
	 arg[i++] = CAR(runner);
	 runner = CDR(runner);
      }

#define APPLY( f ) ((obj_t (*)())PROCEDURE_ENTRY( f ))

      switch (i)
      {
         case 0:
	    return APPLY(function) (function);

         case 1:
	    return APPLY(function) (function, arg[0]);

         case 2:
	    return APPLY(function) (function, arg[0],
				    arg[1]);

         case 3:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2]);

         case 4:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3]);

         case 5:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4]);

         case 6:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5]);

         case 7:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6]);

         case 8:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7]);

         case 9:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7], arg[8]);

         case 10:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7], arg[8], arg[9]);

         case 11:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7], arg[8], arg[9],
				    arg[10]);

         case 12:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7], arg[8], arg[9],
				    arg[10], arg[11]);

         case 13:
	      return APPLY(function) (function, arg[0],
				      arg[1], arg[2], arg[3],
				      arg[4], arg[5], arg[6],
				      arg[7], arg[8], arg[9],
				      arg[10], arg[11], arg[12]);

         case 14:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7], arg[8], arg[9],
				    arg[10], arg[11], arg[12],
				    arg[13]);

         case 15:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7], arg[8], arg[9],
				    arg[10], arg[11], arg[12],
				    arg[13], arg[14]);

         case 16:
	    return APPLY(function) (function, arg[0],
				    arg[1], arg[2], arg[3],
				    arg[4], arg[5], arg[6],
				    arg[7], arg[8], arg[9],
				    arg[10], arg[11], arg[12],
				    arg[13], arg[14], arg[15]);

         default:
	    c_error("too many arguments provided in apply",
		    "",
		    -6);
      }
   }
}
