/*===========================================================================*/
/*   (Rgc/rgc-rules.scm)                                                     */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t expand_out_127___rgc_rules(long, obj_t, obj_t, obj_t);
extern obj_t string_to_symbol(char *);
extern obj_t append_2_18___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern bool_t rgc_alphabetic__209___rgc_config(obj_t);
static bool_t _submatch___246___rgc_rules;
extern obj_t rules__regular_tree_149___rgc_rules(obj_t, obj_t);
static obj_t _special_char_match__222___rgc_rules(obj_t, obj_t);
static long _submatch_count__40___rgc_rules;
static bool_t rgc_char__84___rgc_rules(obj_t);
static obj_t add_predicate_match__153___rgc_rules(long, obj_t);
extern obj_t vector__list_155___r4_vectors_6_8(obj_t);
static obj_t expand_sequence_153___rgc_rules(long, obj_t, obj_t);
static obj_t expand_string_57___rgc_rules(obj_t, obj_t);
static obj_t expand___7___rgc_rules(long, obj_t, obj_t);
static obj_t expand___73___rgc_rules(long, obj_t, obj_t, obj_t, obj_t);
extern obj_t assq___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t toplevel_init_63___rgc_rules();
static obj_t expand___233___rgc_rules(long, obj_t, obj_t);
static obj_t expand___27___rgc_rules(long, obj_t, obj_t);
extern obj_t rgc_downcase_36___rgc_config(obj_t);
extern obj_t tree_max_char_216___rgc_rules();
static obj_t expand_rule_234___rgc_rules(long, obj_t, obj_t);
static long special_char_num_223___rgc_rules;
extern obj_t _res3__194___r5_control_features_6_4;
extern obj_t _res2__167___r5_control_features_6_4;
extern obj_t _res1__155___r5_control_features_6_4;
static obj_t _tree_max_char_38___rgc_rules(obj_t);
static obj_t expand_atom_167___rgc_rules(long, obj_t, obj_t);
static obj_t explode_sequence_86___rgc_rules(obj_t);
extern obj_t rgc_upcase_160___rgc_config(obj_t);
static obj_t expand_uncase_186___rgc_rules(long, obj_t, obj_t);
static obj_t make_variable_env_15___rgc_rules(obj_t);
static obj_t _predicate_match_187___rgc_rules(obj_t, obj_t);
static obj_t loop___rgc_rules(obj_t, obj_t);
extern obj_t posix__rgc_86___rgc_posix(obj_t);
static obj_t expand_or_72___rgc_rules(long, obj_t, obj_t);
static obj_t expand_in_193___rgc_rules(long, obj_t, obj_t, obj_t);
static obj_t expand_match_rule_209___rgc_rules(long, obj_t, obj_t);
static obj_t expand_____85___rgc_rules(long, obj_t, obj_t, obj_t, obj_t);
static obj_t expand____190___rgc_rules(long, obj_t, obj_t, obj_t, obj_t);
static obj_t expand_but_245___rgc_rules(long, obj_t, obj_t, obj_t, obj_t);
extern obj_t reset_special_match_char__38___rgc_rules();
extern obj_t rgcset__list_240___rgc_set(obj_t);
static obj_t expand_submatch_201___rgc_rules(long, obj_t, obj_t);
extern obj_t module_initialization_70___rgc_rules(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t module_initialization_70___rgc_config(long, char *);
extern obj_t module_initialization_70___rgc_set(long, char *);
extern obj_t module_initialization_70___rgc_posix(long, char *);
static obj_t _predicates__85___rgc_rules = BUNSPEC;
extern obj_t _res_number__75___r5_control_features_6_4;
static obj_t _rules__regular_tree_240___rgc_rules(obj_t, obj_t, obj_t);
static obj_t _reset_special_match_char__42___rgc_rules(obj_t);
static obj_t _special_match_char__rule_number_41___rgc_rules(obj_t, obj_t);
static obj_t string_range_42___rgc_rules(obj_t, obj_t);
static obj_t char_range_115___rgc_rules(obj_t, obj_t, obj_t);
extern bool_t special_char_match__17___rgc_rules(int);
static obj_t expand_and_10___rgc_rules(long, obj_t, obj_t, obj_t, obj_t);
extern obj_t rgcset_and__23___rgc_set(obj_t, obj_t);
static obj_t expand____181___rgc_rules(long, obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t make_sequence_237___rgc_rules(obj_t);
extern obj_t rgc_env_91___rgc_config();
extern bool_t _2___235___r4_numbers_6_5(obj_t, obj_t);
static obj_t _special_match_char__51___rgc_rules = BUNSPEC;
static long get_new_submatch_255___rgc_rules();
extern bool_t _2__206___r4_numbers_6_5(obj_t, obj_t);
extern obj_t list__rgcset_152___rgc_set(obj_t, int);
extern bool_t _2__116___r4_numbers_6_5(obj_t, obj_t);
extern obj_t _2__79___r4_numbers_6_5(obj_t, obj_t);
extern obj_t _2__168___r4_numbers_6_5(obj_t, obj_t);
static obj_t _special_start_match_char__216___rgc_rules = BUNSPEC;
extern obj_t cons__138___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t symbol2073___rgc_rules = BUNSPEC;
static obj_t symbol2071___rgc_rules = BUNSPEC;
static obj_t symbol2068___rgc_rules = BUNSPEC;
static obj_t symbol2067___rgc_rules = BUNSPEC;
static obj_t symbol2066___rgc_rules = BUNSPEC;
static obj_t symbol2065___rgc_rules = BUNSPEC;
static obj_t symbol2064___rgc_rules = BUNSPEC;
static obj_t symbol2063___rgc_rules = BUNSPEC;
static obj_t symbol2062___rgc_rules = BUNSPEC;
static obj_t symbol2061___rgc_rules = BUNSPEC;
static obj_t symbol2059___rgc_rules = BUNSPEC;
static obj_t symbol2060___rgc_rules = BUNSPEC;
static obj_t symbol2058___rgc_rules = BUNSPEC;
static obj_t symbol2057___rgc_rules = BUNSPEC;
static obj_t symbol2056___rgc_rules = BUNSPEC;
static obj_t symbol2055___rgc_rules = BUNSPEC;
static obj_t symbol2053___rgc_rules = BUNSPEC;
static obj_t symbol2052___rgc_rules = BUNSPEC;
static obj_t symbol2051___rgc_rules = BUNSPEC;
static obj_t symbol2049___rgc_rules = BUNSPEC;
static obj_t symbol2048___rgc_rules = BUNSPEC;
static obj_t symbol2046___rgc_rules = BUNSPEC;
static obj_t symbol2045___rgc_rules = BUNSPEC;
static obj_t symbol2043___rgc_rules = BUNSPEC;
static obj_t symbol2042___rgc_rules = BUNSPEC;
static obj_t symbol2041___rgc_rules = BUNSPEC;
static obj_t symbol2039___rgc_rules = BUNSPEC;
extern bool_t special_char__16___rgc_rules(int);
static obj_t symbol2038___rgc_rules = BUNSPEC;
static obj_t symbol2037___rgc_rules = BUNSPEC;
static obj_t symbol2036___rgc_rules = BUNSPEC;
static obj_t symbol2035___rgc_rules = BUNSPEC;
static obj_t symbol2031___rgc_rules = BUNSPEC;
static obj_t symbol2029___rgc_rules = BUNSPEC;
static obj_t symbol2028___rgc_rules = BUNSPEC;
static obj_t symbol2027___rgc_rules = BUNSPEC;
static obj_t symbol2026___rgc_rules = BUNSPEC;
static obj_t _special_stop_match_char__242___rgc_rules = BUNSPEC;
static obj_t imported_modules_init_94___rgc_rules();
extern int special_match_char__rule_number_1___rgc_rules(int);
extern obj_t rgc_max_char_237___rgc_config();
static obj_t list2050___rgc_rules = BUNSPEC;
static obj_t list2047___rgc_rules = BUNSPEC;
static obj_t list2044___rgc_rules = BUNSPEC;
static obj_t list2040___rgc_rules = BUNSPEC;
extern obj_t rgcset_not__199___rgc_set(obj_t);
static obj_t list2030___rgc_rules = BUNSPEC;
static obj_t _special_char__201___rgc_rules(obj_t, obj_t);
static obj_t require_initialization_114___rgc_rules = BUNSPEC;
extern obj_t string__list_125___r4_strings_6_7(obj_t);
extern obj_t rgcset_but__159___rgc_set(obj_t, obj_t);
extern obj_t predicate_match_30___rgc_rules(int);
static obj_t cnst_init_137___rgc_rules();
extern obj_t reverse__39___r4_pairs_and_lists_6_3(obj_t);
extern obj_t make_vector(long, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( special_char_match__env_195___rgc_rules, _special_char_match__222___rgc_rules2077, _special_char_match__222___rgc_rules, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( reset_special_match_char__env_162___rgc_rules, _reset_special_match_char__42___rgc_rules2078, _reset_special_match_char__42___rgc_rules, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( rules__regular_tree_env_191___rgc_rules, _rules__regular_tree_240___rgc_rules2079, _rules__regular_tree_240___rgc_rules, 0L, 2 );
DEFINE_STRING( string2075___rgc_rules, string2075___rgc_rules2080, "RGC:Illegal range", 17 );
DEFINE_STRING( string2074___rgc_rules, string2074___rgc_rules2081, "RGC:Illegal range string", 24 );
DEFINE_STRING( string2072___rgc_rules, string2072___rgc_rules2082, "RGC:Illegal regular range", 25 );
DEFINE_STRING( string2069___rgc_rules, string2069___rgc_rules2083, "RGC:regular variable unbound", 28 );
DEFINE_STRING( string2070___rgc_rules, string2070___rgc_rules2084, "RGC:illegal regular expression", 30 );
DEFINE_STRING( string2054___rgc_rules, string2054___rgc_rules2085, "RGC:Illegal construction", 24 );
DEFINE_EXPORT_PROCEDURE( predicate_match_env_193___rgc_rules, _predicate_match_187___rgc_rules2086, _predicate_match_187___rgc_rules, 0L, 1 );
DEFINE_STRING( string2034___rgc_rules, string2034___rgc_rules2087, "RGC:Illegal regular variable definition", 39 );
DEFINE_STRING( string2033___rgc_rules, string2033___rgc_rules2088, "RGC:Illegal clause", 18 );
DEFINE_STRING( string2032___rgc_rules, string2032___rgc_rules2089, "RGC:Illegal else clause", 23 );
DEFINE_STRING( string2025___rgc_rules, string2025___rgc_rules2090, "RGC:Illegal clauses", 19 );
DEFINE_EXPORT_PROCEDURE( tree_max_char_env_213___rgc_rules, _tree_max_char_38___rgc_rules2091, _tree_max_char_38___rgc_rules, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( special_char__env_165___rgc_rules, _special_char__201___rgc_rules2092, _special_char__201___rgc_rules, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( special_match_char__rule_number_env_233___rgc_rules, _special_match_char__rule_number_41___rgc_rules2093, _special_match_char__rule_number_41___rgc_rules, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___rgc_rules(long checksum_2813, char * from_2814)
{
if(CBOOL(require_initialization_114___rgc_rules)){
require_initialization_114___rgc_rules = BBOOL(((bool_t)0));
cnst_init_137___rgc_rules();
imported_modules_init_94___rgc_rules();
toplevel_init_63___rgc_rules();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___rgc_rules()
{
symbol2026___rgc_rules = string_to_symbol("IN");
symbol2027___rgc_rules = string_to_symbol("BEGIN");
symbol2028___rgc_rules = string_to_symbol("ELSE");
symbol2029___rgc_rules = string_to_symbol("OR");
symbol2031___rgc_rules = string_to_symbol("THE-FAILURE");
list2030___rgc_rules = MAKE_PAIR(symbol2031___rgc_rules, BNIL);
symbol2035___rgc_rules = string_to_symbol("RGC-CONTEXT?");
symbol2036___rgc_rules = string_to_symbol("QUOTE");
symbol2037___rgc_rules = string_to_symbol("WHEN");
symbol2038___rgc_rules = string_to_symbol("CONTEXT");
symbol2039___rgc_rules = string_to_symbol("BOL");
symbol2041___rgc_rules = string_to_symbol("RGC-BUFFER-BOL?");
symbol2042___rgc_rules = string_to_symbol("INPUT-PORT");
{
obj_t aux_2834;
aux_2834 = MAKE_PAIR(symbol2042___rgc_rules, BNIL);
list2040___rgc_rules = MAKE_PAIR(symbol2041___rgc_rules, aux_2834);
}
symbol2043___rgc_rules = string_to_symbol("EOL");
symbol2045___rgc_rules = string_to_symbol("RGC-BUFFER-EOL?");
{
obj_t aux_2839;
aux_2839 = MAKE_PAIR(symbol2042___rgc_rules, BNIL);
list2044___rgc_rules = MAKE_PAIR(symbol2045___rgc_rules, aux_2839);
}
symbol2046___rgc_rules = string_to_symbol("BOF");
symbol2048___rgc_rules = string_to_symbol("RGC-BUFFER-BOF?");
{
obj_t aux_2844;
aux_2844 = MAKE_PAIR(symbol2042___rgc_rules, BNIL);
list2047___rgc_rules = MAKE_PAIR(symbol2048___rgc_rules, aux_2844);
}
symbol2049___rgc_rules = string_to_symbol("EOF");
symbol2051___rgc_rules = string_to_symbol("RGC-BUFFER-EOF?");
{
obj_t aux_2849;
aux_2849 = MAKE_PAIR(symbol2042___rgc_rules, BNIL);
list2050___rgc_rules = MAKE_PAIR(symbol2051___rgc_rules, aux_2849);
}
symbol2052___rgc_rules = string_to_symbol("...");
symbol2053___rgc_rules = string_to_symbol("RULE");
symbol2055___rgc_rules = string_to_symbol("UNCASE");
symbol2056___rgc_rules = string_to_symbol("*");
symbol2057___rgc_rules = string_to_symbol("+");
symbol2058___rgc_rules = string_to_symbol("?");
symbol2059___rgc_rules = string_to_symbol("=");
symbol2060___rgc_rules = string_to_symbol(">=");
symbol2061___rgc_rules = string_to_symbol("**");
symbol2062___rgc_rules = string_to_symbol("OUT");
symbol2063___rgc_rules = string_to_symbol("AND");
symbol2064___rgc_rules = string_to_symbol("BUT");
symbol2065___rgc_rules = string_to_symbol("SUBMATCH");
symbol2066___rgc_rules = string_to_symbol(":");
symbol2067___rgc_rules = string_to_symbol("SEQ");
symbol2068___rgc_rules = string_to_symbol("POSIX");
symbol2071___rgc_rules = string_to_symbol("SEQUENCE");
return (symbol2073___rgc_rules = string_to_symbol("EPSILON"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___rgc_rules()
{
{
obj_t arg1042_401;
arg1042_401 = rgc_max_char_237___rgc_config();
{
long aux_2871;
aux_2871 = (long)CINT(arg1042_401);
special_char_num_223___rgc_rules = (aux_2871-((long)1));
}
}
_special_match_char__51___rgc_rules = BNIL;
_special_start_match_char__216___rgc_rules = BNIL;
_special_stop_match_char__242___rgc_rules = BNIL;
_predicates__85___rgc_rules = BNIL;
_submatch___246___rgc_rules = ((bool_t)0);
return (_submatch_count__40___rgc_rules = ((long)0),
BUNSPEC);
}


/* rules->regular-tree */obj_t rules__regular_tree_149___rgc_rules(obj_t user_env_137_1, obj_t clauses_2)
{
reset_special_match_char__38___rgc_rules();
if(NULLP(clauses_2)){
FAILURE(BFALSE,string2025___rgc_rules,clauses_2);}
 else {
obj_t env_404;
obj_t dflt_405;
{
obj_t arg1099_477;
{
obj_t arg1100_478;
arg1100_478 = rgc_env_91___rgc_config();
arg1099_477 = append_2_18___r4_pairs_and_lists_6_3(user_env_137_1, arg1100_478);
}
env_404 = make_variable_env_15___rgc_rules(arg1099_477);
}
{
obj_t arg1101_479;
obj_t arg1102_480;
arg1101_479 = symbol2026___rgc_rules;
{
obj_t arg1108_486;
{
obj_t arg1113_491;
arg1113_491 = rgc_max_char_237___rgc_config();
arg1108_486 = _2__79___r4_numbers_6_5(arg1113_491, BINT(((long)1)));
}
{
obj_t list1110_488;
{
obj_t arg1111_489;
arg1111_489 = MAKE_PAIR(BNIL, BNIL);
list1110_488 = MAKE_PAIR(arg1108_486, arg1111_489);
}
arg1102_480 = cons__138___r4_pairs_and_lists_6_3(BINT(((long)0)), list1110_488);
}
}
{
obj_t list1104_482;
{
obj_t arg1105_483;
arg1105_483 = MAKE_PAIR(BNIL, BNIL);
list1104_482 = MAKE_PAIR(arg1102_480, arg1105_483);
}
dflt_405 = cons__138___r4_pairs_and_lists_6_3(arg1101_479, list1104_482);
}
}
{
obj_t clauses_406;
long match_407;
obj_t branches_408;
obj_t actions_409;
clauses_406 = clauses_2;
match_407 = ((long)0);
branches_408 = BNIL;
actions_409 = BNIL;
loop_410:
{
obj_t rule_414;
obj_t acts_415;
{
obj_t e_103_175_418;
e_103_175_418 = CAR(clauses_406);
if(PAIRP(e_103_175_418)){
obj_t cdr_109_69_420;
cdr_109_69_420 = CDR(e_103_175_418);
if(PAIRP(cdr_109_69_420)){
rule_414 = CAR(e_103_175_418);
acts_415 = cdr_109_69_420;
{
obj_t act_423;
{
obj_t arg1092_470;
obj_t arg1093_471;
arg1092_470 = symbol2027___rgc_rules;
{
obj_t arg1096_474;
arg1096_474 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1093_471 = append_2_18___r4_pairs_and_lists_6_3(acts_415, arg1096_474);
}
{
obj_t list1094_472;
list1094_472 = MAKE_PAIR(arg1093_471, BNIL);
act_423 = cons__138___r4_pairs_and_lists_6_3(arg1092_470, list1094_472);
}
}
{
bool_t test_2901;
{
obj_t aux_2902;
aux_2902 = CDR(clauses_406);
test_2901 = NULLP(aux_2902);
}
if(test_2901){
if((rule_414==symbol2028___rgc_rules)){
obj_t val0_1002_426;
obj_t val1_1003_427;
bool_t val3_1005_429;
{
obj_t arg1053_430;
obj_t arg1054_431;
obj_t arg1055_432;
arg1053_430 = symbol2029___rgc_rules;
arg1054_431 = expand_match_rule_209___rgc_rules(match_407, env_404, dflt_405);
{
obj_t arg1059_436;
arg1059_436 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1055_432 = append_2_18___r4_pairs_and_lists_6_3(branches_408, arg1059_436);
}
{
obj_t list1056_433;
{
obj_t arg1057_434;
arg1057_434 = MAKE_PAIR(arg1055_432, BNIL);
list1056_433 = MAKE_PAIR(arg1054_431, arg1057_434);
}
val0_1002_426 = cons__138___r4_pairs_and_lists_6_3(arg1053_430, list1056_433);
}
}
{
obj_t arg1062_439;
arg1062_439 = MAKE_PAIR(act_423, actions_409);
val1_1003_427 = reverse__39___r4_pairs_and_lists_6_3(arg1062_439);
}
val3_1005_429 = _submatch___246___rgc_rules;
_res_number__75___r5_control_features_6_4 = BINT(((long)4));
_res1__155___r5_control_features_6_4 = val1_1003_427;
_res2__167___r5_control_features_6_4 = BINT(match_407);
_res3__194___r5_control_features_6_4 = BBOOL(val3_1005_429);
return val0_1002_426;
}
 else {
obj_t val0_1006_440;
obj_t val1_1007_441;
long val2_1008_442;
bool_t val3_1009_443;
{
obj_t arg1063_444;
obj_t arg1065_445;
obj_t arg1066_446;
obj_t arg1067_447;
arg1063_444 = symbol2029___rgc_rules;
arg1065_445 = expand_match_rule_209___rgc_rules((match_407+((long)1)), env_404, dflt_405);
arg1066_446 = expand_match_rule_209___rgc_rules(match_407, env_404, rule_414);
{
obj_t arg1076_453;
arg1076_453 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1067_447 = append_2_18___r4_pairs_and_lists_6_3(branches_408, arg1076_453);
}
{
obj_t list1068_448;
{
obj_t arg1069_449;
{
obj_t arg1070_450;
arg1070_450 = MAKE_PAIR(arg1067_447, BNIL);
arg1069_449 = MAKE_PAIR(arg1066_446, arg1070_450);
}
list1068_448 = MAKE_PAIR(arg1065_445, arg1069_449);
}
val0_1006_440 = cons__138___r4_pairs_and_lists_6_3(arg1063_444, list1068_448);
}
}
{
obj_t arg1079_456;
{
obj_t arg1080_457;
arg1080_457 = list2030___rgc_rules;
{
obj_t list1081_458;
{
obj_t arg1082_459;
arg1082_459 = MAKE_PAIR(actions_409, BNIL);
list1081_458 = MAKE_PAIR(act_423, arg1082_459);
}
arg1079_456 = cons__138___r4_pairs_and_lists_6_3(arg1080_457, list1081_458);
}
}
val1_1007_441 = reverse__39___r4_pairs_and_lists_6_3(arg1079_456);
}
val2_1008_442 = (((long)1)+match_407);
val3_1009_443 = _submatch___246___rgc_rules;
_res_number__75___r5_control_features_6_4 = BINT(((long)4));
_res1__155___r5_control_features_6_4 = val1_1007_441;
_res2__167___r5_control_features_6_4 = BINT(val2_1008_442);
_res3__194___r5_control_features_6_4 = BBOOL(val3_1009_443);
return val0_1006_440;
}
}
 else {
if((rule_414==symbol2028___rgc_rules)){
FAILURE(BFALSE,string2032___rgc_rules,clauses_406);}
 else {
obj_t erule_463;
erule_463 = expand_match_rule_209___rgc_rules(match_407, env_404, rule_414);
{
obj_t arg1086_464;
long arg1087_465;
obj_t arg1088_466;
obj_t arg1089_467;
arg1086_464 = CDR(clauses_406);
arg1087_465 = (match_407+((long)1));
arg1088_466 = MAKE_PAIR(erule_463, branches_408);
arg1089_467 = MAKE_PAIR(act_423, actions_409);
{
obj_t actions_2946;
obj_t branches_2945;
long match_2944;
obj_t clauses_2943;
clauses_2943 = arg1086_464;
match_2944 = arg1087_465;
branches_2945 = arg1088_466;
actions_2946 = arg1089_467;
actions_409 = actions_2946;
branches_408 = branches_2945;
match_407 = match_2944;
clauses_406 = clauses_2943;
goto loop_410;
}
}
}
}
}
}
}
 else {
FAILURE(BFALSE,string2033___rgc_rules,clauses_406);}
}
 else {
FAILURE(BFALSE,string2033___rgc_rules,clauses_406);}
}
}
}
}
}


/* _rules->regular-tree */obj_t _rules__regular_tree_240___rgc_rules(obj_t env_2798, obj_t user_env_137_2799, obj_t clauses_2800)
{
return rules__regular_tree_149___rgc_rules(user_env_137_2799, clauses_2800);
}


/* make-variable-env */obj_t make_variable_env_15___rgc_rules(obj_t bindings_3)
{
if(NULLP(bindings_3)){
return BNIL;
}
 else {
obj_t e_116_142_498;
e_116_142_498 = CAR(bindings_3);
if(PAIRP(e_116_142_498)){
obj_t car_121_84_500;
obj_t cdr_122_80_501;
car_121_84_500 = CAR(e_116_142_498);
cdr_122_80_501 = CDR(e_116_142_498);
if(SYMBOLP(car_121_84_500)){
if(PAIRP(cdr_122_80_501)){
bool_t test_2962;
{
obj_t aux_2963;
aux_2963 = CDR(cdr_122_80_501);
test_2962 = (aux_2963==BNIL);
}
if(test_2962){
obj_t arg1120_505;
arg1120_505 = CAR(cdr_122_80_501);
{
obj_t env_1583;
env_1583 = make_variable_env_15___rgc_rules(CDR(bindings_3));
{
obj_t arg1123_1585;
arg1123_1585 = MAKE_PAIR(car_121_84_500, arg1120_505);
return MAKE_PAIR(arg1123_1585, env_1583);
}
}
}
 else {
FAILURE(BFALSE,string2034___rgc_rules,e_116_142_498);}
}
 else {
FAILURE(BFALSE,string2034___rgc_rules,e_116_142_498);}
}
 else {
FAILURE(BFALSE,string2034___rgc_rules,e_116_142_498);}
}
 else {
FAILURE(BFALSE,string2034___rgc_rules,e_116_142_498);}
}
}


/* special-char? */bool_t special_char__16___rgc_rules(int char_4)
{
{
obj_t arg1127_1631;
arg1127_1631 = rgc_max_char_237___rgc_config();
{
long aux_2978;
long aux_2976;
aux_2978 = (long)CINT(arg1127_1631);
aux_2976 = (long)(char_4);
return (aux_2976>=aux_2978);
}
}
}


/* _special-char? */obj_t _special_char__201___rgc_rules(obj_t env_2801, obj_t char_2802)
{
{
bool_t aux_2981;
aux_2981 = special_char__16___rgc_rules(CINT(char_2802));
return BBOOL(aux_2981);
}
}


/* tree-max-char */obj_t tree_max_char_216___rgc_rules()
{
{
long z2_1635;
z2_1635 = special_char_num_223___rgc_rules;
{
long aux_2985;
aux_2985 = (((long)1)+z2_1635);
return BINT(aux_2985);
}
}
}


/* _tree-max-char */obj_t _tree_max_char_38___rgc_rules(obj_t env_2803)
{
return tree_max_char_216___rgc_rules();
}


/* reset-special-match-char! */obj_t reset_special_match_char__38___rgc_rules()
{
_submatch___246___rgc_rules = ((bool_t)0);
_predicates__85___rgc_rules = BNIL;
return (_special_match_char__51___rgc_rules = BNIL,
BUNSPEC);
}


/* _reset-special-match-char! */obj_t _reset_special_match_char__42___rgc_rules(obj_t env_2804)
{
return reset_special_match_char__38___rgc_rules();
}


/* special-char-match? */bool_t special_char_match__17___rgc_rules(int char_7)
{
{
obj_t arg1129_1641;
arg1129_1641 = assq___r4_pairs_and_lists_6_3(BINT(char_7), _special_match_char__51___rgc_rules);
return PAIRP(arg1129_1641);
}
}


/* _special-char-match? */obj_t _special_char_match__222___rgc_rules(obj_t env_2805, obj_t char_2806)
{
{
bool_t aux_2993;
aux_2993 = special_char_match__17___rgc_rules(CINT(char_2806));
return BBOOL(aux_2993);
}
}


/* special-match-char->rule-number */int special_match_char__rule_number_1___rgc_rules(int char_8)
{
{
obj_t arg1130_1643;
arg1130_1643 = assq___r4_pairs_and_lists_6_3(BINT(char_8), _special_match_char__51___rgc_rules);
{
obj_t aux_2999;
aux_2999 = CDR(arg1130_1643);
return CINT(aux_2999);
}
}
}


/* _special-match-char->rule-number */obj_t _special_match_char__rule_number_41___rgc_rules(obj_t env_2807, obj_t char_2808)
{
{
int aux_3002;
aux_3002 = special_match_char__rule_number_1___rgc_rules(CINT(char_2808));
return BINT(aux_3002);
}
}


/* get-new-submatch */long get_new_submatch_255___rgc_rules()
{
_submatch___246___rgc_rules = ((bool_t)1);
{
long z2_1646;
z2_1646 = _submatch_count__40___rgc_rules;
_submatch_count__40___rgc_rules = (((long)1)+z2_1646);
}
return _submatch_count__40___rgc_rules;
}


/* add-predicate-match! */obj_t add_predicate_match__153___rgc_rules(long match_9, obj_t predicate_10)
{
{
obj_t cell_517;
cell_517 = assq___r4_pairs_and_lists_6_3(BINT(match_9), _predicates__85___rgc_rules);
if(PAIRP(cell_517)){
obj_t arg1132_519;
{
obj_t aux_3011;
aux_3011 = CDR(cell_517);
arg1132_519 = MAKE_PAIR(predicate_10, aux_3011);
}
return SET_CDR(cell_517, arg1132_519);
}
 else {
obj_t arg1134_521;
{
obj_t arg1135_522;
{
obj_t list1136_523;
list1136_523 = MAKE_PAIR(predicate_10, BNIL);
arg1135_522 = list1136_523;
}
{
obj_t aux_3016;
aux_3016 = BINT(match_9);
arg1134_521 = MAKE_PAIR(aux_3016, arg1135_522);
}
}
{
obj_t obj2_1657;
obj2_1657 = _predicates__85___rgc_rules;
return (_predicates__85___rgc_rules = MAKE_PAIR(arg1134_521, obj2_1657),
BUNSPEC);
}
}
}
}


/* predicate-match */obj_t predicate_match_30___rgc_rules(int match_11)
{
{
obj_t cell_1658;
cell_1658 = assq___r4_pairs_and_lists_6_3(BINT(match_11), _predicates__85___rgc_rules);
if(PAIRP(cell_1658)){
return CDR(cell_1658);
}
 else {
return BFALSE;
}
}
}


/* _predicate-match */obj_t _predicate_match_187___rgc_rules(obj_t env_2809, obj_t match_2810)
{
return predicate_match_30___rgc_rules(CINT(match_2810));
}


/* expand-match-rule */obj_t expand_match_rule_209___rgc_rules(long match_12, obj_t env_13, obj_t rule_14)
{
_submatch_count__40___rgc_rules = ((long)0);
{
long special_char_69_527;
{
long z2_1663;
z2_1663 = special_char_num_223___rgc_rules;
special_char_num_223___rgc_rules = (((long)1)+z2_1663);
}
special_char_69_527 = special_char_num_223___rgc_rules;
{
obj_t arg1128_1666;
{
obj_t aux_3030;
obj_t aux_3028;
aux_3030 = BINT(match_12);
aux_3028 = BINT(special_char_69_527);
arg1128_1666 = MAKE_PAIR(aux_3028, aux_3030);
}
{
obj_t obj2_1670;
obj2_1670 = _special_match_char__51___rgc_rules;
_special_match_char__51___rgc_rules = MAKE_PAIR(arg1128_1666, obj2_1670);
}
}
{
obj_t rule_528;
rule_528 = rule_14;
{
obj_t arg1139_530;
{
obj_t arg1140_531;
{
obj_t rule_535;
rule_535 = rule_528;
loop_536:
{
obj_t context_540;
obj_t rule_541;
if(PAIRP(rule_535)){
obj_t cdr_144_157_554;
cdr_144_157_554 = CDR(rule_535);
{
bool_t test_3037;
{
obj_t aux_3038;
aux_3038 = CAR(rule_535);
test_3037 = (aux_3038==symbol2037___rgc_rules);
}
if(test_3037){
if(PAIRP(cdr_144_157_554)){
obj_t cdr_148_78_557;
cdr_148_78_557 = CDR(cdr_144_157_554);
if(PAIRP(cdr_148_78_557)){
bool_t test_3046;
{
obj_t aux_3047;
aux_3047 = CDR(cdr_148_78_557);
test_3046 = (aux_3047==BNIL);
}
if(test_3046){
obj_t arg1151_561;
arg1151_561 = CAR(cdr_148_78_557);
add_predicate_match__153___rgc_rules(match_12, CAR(cdr_144_157_554));
{
obj_t rule_3053;
rule_3053 = arg1151_561;
rule_535 = rule_3053;
goto loop_536;
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
bool_t test_3057;
{
obj_t aux_3058;
aux_3058 = CAR(rule_535);
test_3057 = (aux_3058==symbol2038___rgc_rules);
}
if(test_3057){
if(PAIRP(cdr_144_157_554)){
obj_t cdr_199_216_567;
cdr_199_216_567 = CDR(cdr_144_157_554);
if(PAIRP(cdr_199_216_567)){
bool_t test_3066;
{
obj_t aux_3067;
aux_3067 = CDR(cdr_199_216_567);
test_3066 = (aux_3067==BNIL);
}
if(test_3066){
context_540 = CAR(cdr_144_157_554);
rule_541 = CAR(cdr_199_216_567);
{
obj_t arg1200_614;
{
obj_t arg1201_615;
obj_t arg1202_616;
arg1201_615 = symbol2035___rgc_rules;
{
obj_t arg1207_621;
arg1207_621 = symbol2036___rgc_rules;
{
obj_t list1210_623;
{
obj_t arg1211_624;
arg1211_624 = MAKE_PAIR(BNIL, BNIL);
list1210_623 = MAKE_PAIR(context_540, arg1211_624);
}
arg1202_616 = cons__138___r4_pairs_and_lists_6_3(arg1207_621, list1210_623);
}
}
{
obj_t list1204_618;
{
obj_t arg1205_619;
arg1205_619 = MAKE_PAIR(BNIL, BNIL);
list1204_618 = MAKE_PAIR(arg1202_616, arg1205_619);
}
arg1200_614 = cons__138___r4_pairs_and_lists_6_3(arg1201_615, list1204_618);
}
}
add_predicate_match__153___rgc_rules(match_12, arg1200_614);
}
{
obj_t rule_3077;
rule_3077 = rule_541;
rule_535 = rule_3077;
goto loop_536;
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
bool_t test_3083;
{
obj_t aux_3084;
aux_3084 = CAR(rule_535);
test_3083 = (aux_3084==symbol2039___rgc_rules);
}
if(test_3083){
if(PAIRP(cdr_144_157_554)){
bool_t test_3089;
{
obj_t aux_3090;
aux_3090 = CDR(cdr_144_157_554);
test_3089 = (aux_3090==BNIL);
}
if(test_3089){
obj_t arg1166_578;
arg1166_578 = CAR(cdr_144_157_554);
add_predicate_match__153___rgc_rules(match_12, list2040___rgc_rules);
{
obj_t rule_3095;
rule_3095 = arg1166_578;
rule_535 = rule_3095;
goto loop_536;
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
bool_t test_3098;
{
obj_t aux_3099;
aux_3099 = CAR(rule_535);
test_3098 = (aux_3099==symbol2043___rgc_rules);
}
if(test_3098){
if(PAIRP(cdr_144_157_554)){
bool_t test_3104;
{
obj_t aux_3105;
aux_3105 = CDR(cdr_144_157_554);
test_3104 = (aux_3105==BNIL);
}
if(test_3104){
obj_t arg1172_585;
arg1172_585 = CAR(cdr_144_157_554);
add_predicate_match__153___rgc_rules(match_12, list2044___rgc_rules);
{
obj_t rule_3110;
rule_3110 = arg1172_585;
rule_535 = rule_3110;
goto loop_536;
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
bool_t test_3113;
{
obj_t aux_3114;
aux_3114 = CAR(rule_535);
test_3113 = (aux_3114==symbol2046___rgc_rules);
}
if(test_3113){
if(PAIRP(cdr_144_157_554)){
bool_t test_3119;
{
obj_t aux_3120;
aux_3120 = CDR(cdr_144_157_554);
test_3119 = (aux_3120==BNIL);
}
if(test_3119){
obj_t arg1178_592;
arg1178_592 = CAR(cdr_144_157_554);
add_predicate_match__153___rgc_rules(match_12, list2047___rgc_rules);
{
obj_t rule_3125;
rule_3125 = arg1178_592;
rule_535 = rule_3125;
goto loop_536;
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
bool_t test_3128;
{
obj_t aux_3129;
aux_3129 = CAR(rule_535);
test_3128 = (aux_3129==symbol2049___rgc_rules);
}
if(test_3128){
if(PAIRP(cdr_144_157_554)){
bool_t test_3134;
{
obj_t aux_3135;
aux_3135 = CDR(cdr_144_157_554);
test_3134 = (aux_3135==BNIL);
}
if(test_3134){
obj_t arg1184_599;
arg1184_599 = CAR(cdr_144_157_554);
add_predicate_match__153___rgc_rules(match_12, list2050___rgc_rules);
{
obj_t rule_3140;
rule_3140 = arg1184_599;
rule_535 = rule_3140;
goto loop_536;
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
}
}
}
}
}
}
 else {
arg1140_531 = expand_rule_234___rgc_rules(match_12, env_13, rule_535);
}
}
}
{
obj_t list1141_532;
{
obj_t arg1142_533;
{
obj_t aux_3145;
aux_3145 = BINT(special_char_69_527);
arg1142_533 = MAKE_PAIR(aux_3145, BNIL);
}
list1141_532 = MAKE_PAIR(arg1140_531, arg1142_533);
}
arg1139_530 = list1141_532;
}
}
return make_sequence_237___rgc_rules(arg1139_530);
}
}
}
}


/* expand-rule */obj_t expand_rule_234___rgc_rules(long match_15, obj_t env_16, obj_t rule_17)
{
expand_rule_234___rgc_rules:
{
bool_t test1221_630;
test1221_630 = PAIRP(rule_17);
if(test1221_630){
if(test1221_630){
obj_t cdr_328_214_673;
cdr_328_214_673 = CDR(rule_17);
{
bool_t test_3154;
{
obj_t aux_3155;
aux_3155 = CAR(rule_17);
test_3154 = (aux_3155==symbol2052___rgc_rules);
}
if(test_3154){
if(PAIRP(cdr_328_214_673)){
obj_t cdr_332_160_676;
cdr_332_160_676 = CDR(cdr_328_214_673);
if(PAIRP(cdr_332_160_676)){
obj_t cdr_336_47_678;
cdr_336_47_678 = CDR(cdr_332_160_676);
if(PAIRP(cdr_336_47_678)){
bool_t test_3166;
{
obj_t aux_3167;
aux_3167 = CAR(cdr_336_47_678);
test_3166 = (aux_3167==symbol2053___rgc_rules);
}
if(test_3166){
bool_t test_3170;
{
obj_t aux_3171;
aux_3171 = CDR(cdr_336_47_678);
test_3170 = (aux_3171==BNIL);
}
if(test_3170){
return expand_____85___rgc_rules(match_15, env_16, CAR(cdr_328_214_673), CAR(cdr_332_160_676), rule_17);
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3182;
{
obj_t aux_3183;
aux_3183 = CAR(rule_17);
test_3182 = (aux_3183==symbol2055___rgc_rules);
}
if(test_3182){
if(PAIRP(cdr_328_214_673)){
bool_t test_3188;
{
obj_t aux_3189;
aux_3189 = CDR(cdr_328_214_673);
test_3188 = (aux_3189==BNIL);
}
if(test_3188){
return expand_uncase_186___rgc_rules(match_15, env_16, CAR(cdr_328_214_673));
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3196;
{
obj_t aux_3197;
aux_3197 = CAR(rule_17);
test_3196 = (aux_3197==symbol2056___rgc_rules);
}
if(test_3196){
if(PAIRP(cdr_328_214_673)){
bool_t test_3202;
{
obj_t aux_3203;
aux_3203 = CDR(cdr_328_214_673);
test_3202 = (aux_3203==BNIL);
}
if(test_3202){
return expand___27___rgc_rules(match_15, env_16, CAR(cdr_328_214_673));
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3210;
{
obj_t aux_3211;
aux_3211 = CAR(rule_17);
test_3210 = (aux_3211==symbol2057___rgc_rules);
}
if(test_3210){
if(PAIRP(cdr_328_214_673)){
bool_t test_3216;
{
obj_t aux_3217;
aux_3217 = CDR(cdr_328_214_673);
test_3216 = (aux_3217==BNIL);
}
if(test_3216){
return expand___233___rgc_rules(match_15, env_16, CAR(cdr_328_214_673));
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3224;
{
obj_t aux_3225;
aux_3225 = CAR(rule_17);
test_3224 = (aux_3225==symbol2058___rgc_rules);
}
if(test_3224){
if(PAIRP(cdr_328_214_673)){
bool_t test_3230;
{
obj_t aux_3231;
aux_3231 = CDR(cdr_328_214_673);
test_3230 = (aux_3231==BNIL);
}
if(test_3230){
return expand___7___rgc_rules(match_15, env_16, CAR(cdr_328_214_673));
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3238;
{
obj_t aux_3239;
aux_3239 = CAR(rule_17);
test_3238 = (aux_3239==symbol2029___rgc_rules);
}
if(test_3238){
return expand_or_72___rgc_rules(match_15, env_16, cdr_328_214_673);
}
 else {
bool_t test_3243;
{
obj_t aux_3244;
aux_3244 = CAR(rule_17);
test_3243 = (aux_3244==symbol2059___rgc_rules);
}
if(test_3243){
if(PAIRP(cdr_328_214_673)){
obj_t cdr_1935_177_747;
cdr_1935_177_747 = CDR(cdr_328_214_673);
if(PAIRP(cdr_1935_177_747)){
bool_t test_3252;
{
obj_t aux_3253;
aux_3253 = CDR(cdr_1935_177_747);
test_3252 = (aux_3253==BNIL);
}
if(test_3252){
return expand___73___rgc_rules(match_15, env_16, CAR(cdr_328_214_673), CAR(cdr_1935_177_747), rule_17);
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3262;
{
obj_t aux_3263;
aux_3263 = CAR(rule_17);
test_3262 = (aux_3263==symbol2060___rgc_rules);
}
if(test_3262){
if(PAIRP(cdr_328_214_673)){
obj_t cdr_2153_28_763;
cdr_2153_28_763 = CDR(cdr_328_214_673);
if(PAIRP(cdr_2153_28_763)){
bool_t test_3271;
{
obj_t aux_3272;
aux_3272 = CDR(cdr_2153_28_763);
test_3271 = (aux_3272==BNIL);
}
if(test_3271){
return expand____190___rgc_rules(match_15, env_16, CAR(cdr_328_214_673), CAR(cdr_2153_28_763), rule_17);
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3281;
{
obj_t aux_3282;
aux_3282 = CAR(rule_17);
test_3281 = (aux_3282==symbol2061___rgc_rules);
}
if(test_3281){
if(PAIRP(cdr_328_214_673)){
obj_t cdr_2336_143_779;
cdr_2336_143_779 = CDR(cdr_328_214_673);
if(PAIRP(cdr_2336_143_779)){
obj_t cdr_2341_138_781;
cdr_2341_138_781 = CDR(cdr_2336_143_779);
if(PAIRP(cdr_2341_138_781)){
bool_t test_3293;
{
obj_t aux_3294;
aux_3294 = CDR(cdr_2341_138_781);
test_3293 = (aux_3294==BNIL);
}
if(test_3293){
return expand____181___rgc_rules(match_15, env_16, CAR(cdr_328_214_673), CAR(cdr_2336_143_779), CAR(cdr_2341_138_781), rule_17);
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3305;
{
obj_t aux_3306;
aux_3306 = CAR(rule_17);
test_3305 = (aux_3306==symbol2026___rgc_rules);
}
if(test_3305){
return expand_in_193___rgc_rules(match_15, env_16, cdr_328_214_673, rule_17);
}
 else {
bool_t test_3310;
{
obj_t aux_3311;
aux_3311 = CAR(rule_17);
test_3310 = (aux_3311==symbol2062___rgc_rules);
}
if(test_3310){
return expand_out_127___rgc_rules(match_15, env_16, cdr_328_214_673, rule_17);
}
 else {
bool_t test_3315;
{
obj_t aux_3316;
aux_3316 = CAR(rule_17);
test_3315 = (aux_3316==symbol2063___rgc_rules);
}
if(test_3315){
if(PAIRP(cdr_328_214_673)){
obj_t cdr_2543_144_804;
cdr_2543_144_804 = CDR(cdr_328_214_673);
if(PAIRP(cdr_2543_144_804)){
bool_t test_3324;
{
obj_t aux_3325;
aux_3325 = CDR(cdr_2543_144_804);
test_3324 = (aux_3325==BNIL);
}
if(test_3324){
return expand_and_10___rgc_rules(match_15, env_16, CAR(cdr_328_214_673), CAR(cdr_2543_144_804), rule_17);
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3334;
{
obj_t aux_3335;
aux_3335 = CAR(rule_17);
test_3334 = (aux_3335==symbol2064___rgc_rules);
}
if(test_3334){
if(PAIRP(cdr_328_214_673)){
obj_t cdr_2621_235_820;
cdr_2621_235_820 = CDR(cdr_328_214_673);
if(PAIRP(cdr_2621_235_820)){
bool_t test_3343;
{
obj_t aux_3344;
aux_3344 = CDR(cdr_2621_235_820);
test_3343 = (aux_3344==BNIL);
}
if(test_3343){
return expand_but_245___rgc_rules(match_15, env_16, CAR(cdr_328_214_673), CAR(cdr_2621_235_820), rule_17);
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
bool_t test_3353;
{
obj_t aux_3354;
aux_3354 = CAR(rule_17);
test_3353 = (aux_3354==symbol2065___rgc_rules);
}
if(test_3353){
if(PAIRP(cdr_328_214_673)){
bool_t test_3359;
{
obj_t aux_3360;
aux_3360 = CDR(cdr_328_214_673);
test_3359 = (aux_3360==BNIL);
}
if(test_3359){
return expand_submatch_201___rgc_rules(match_15, env_16, CAR(cdr_328_214_673));
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
obj_t car_2697_42_844;
car_2697_42_844 = CAR(rule_17);
if((car_2697_42_844==symbol2066___rgc_rules)){
return expand_sequence_153___rgc_rules(match_15, env_16, cdr_328_214_673);
}
 else {
if((car_2697_42_844==symbol2067___rgc_rules)){
return expand_sequence_153___rgc_rules(match_15, env_16, cdr_328_214_673);
}
 else {
if((car_2697_42_844==symbol2068___rgc_rules)){
if(PAIRP(cdr_328_214_673)){
bool_t test_3378;
{
obj_t aux_3379;
aux_3379 = CDR(cdr_328_214_673);
test_3378 = (aux_3379==BNIL);
}
if(test_3378){
obj_t arg1373_852;
arg1373_852 = CAR(cdr_328_214_673);
if(STRINGP(arg1373_852)){
obj_t arg1883_2026;
arg1883_2026 = posix__rgc_86___rgc_posix(arg1373_852);
{
obj_t rule_3386;
rule_3386 = arg1883_2026;
rule_17 = rule_3386;
goto expand_rule_234___rgc_rules;
}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,rule_17);}
}
 else {
return expand_atom_167___rgc_rules(match_15, env_16, rule_17);
}
}
}


/* expand-atom */obj_t expand_atom_167___rgc_rules(long match_18, obj_t env_19, obj_t rule_20)
{
if(CHARP(rule_20)){
{
long aux_3395;
{
unsigned char aux_3396;
aux_3396 = (unsigned char)CCHAR(rule_20);
aux_3395 = (aux_3396);
}
return BINT(aux_3395);
}
}
 else {
bool_t test1423_889;
if(INTEGERP(rule_20)){
if(_2___235___r4_numbers_6_5(rule_20, BINT(((long)0)))){
obj_t arg1431_897;
arg1431_897 = rgc_max_char_237___rgc_config();
test1423_889 = _2__116___r4_numbers_6_5(rule_20, arg1431_897);
}
 else {
test1423_889 = ((bool_t)0);
}
}
 else {
test1423_889 = ((bool_t)0);
}
if(test1423_889){
return rule_20;
}
 else {
if(STRINGP(rule_20)){
return expand_string_57___rgc_rules(env_19, rule_20);
}
 else {
if(SYMBOLP(rule_20)){
{
obj_t cell_892;
cell_892 = assq___r4_pairs_and_lists_6_3(rule_20, env_19);
if(PAIRP(cell_892)){
return expand_rule_234___rgc_rules(match_18, env_19, CDR(cell_892));
}
 else {
FAILURE(BFALSE,string2069___rgc_rules,rule_20);}
}
}
 else {
FAILURE(BFALSE,string2070___rgc_rules,rule_20);}
}
}
}
}


/* expand-string */obj_t expand_string_57___rgc_rules(obj_t env_21, obj_t rule_22)
{
{
obj_t arg1432_898;
{
obj_t l1010_899;
l1010_899 = string__list_125___r4_strings_6_7(rule_22);
if(NULLP(l1010_899)){
arg1432_898 = BNIL;
}
 else {
obj_t head1012_901;
{
obj_t aux_3423;
{
long aux_3424;
{
unsigned char aux_3425;
{
obj_t aux_3426;
aux_3426 = CAR(l1010_899);
aux_3425 = (unsigned char)CCHAR(aux_3426);
}
aux_3424 = (aux_3425);
}
aux_3423 = BINT(aux_3424);
}
head1012_901 = MAKE_PAIR(aux_3423, BNIL);
}
{
obj_t l1010_2194;
obj_t tail1013_2195;
l1010_2194 = CDR(l1010_899);
tail1013_2195 = head1012_901;
lname1011_2193:
if(NULLP(l1010_2194)){
arg1432_898 = head1012_901;
}
 else {
obj_t newtail1014_2203;
{
obj_t aux_3434;
{
long aux_3435;
{
unsigned char aux_3436;
{
obj_t aux_3437;
aux_3437 = CAR(l1010_2194);
aux_3436 = (unsigned char)CCHAR(aux_3437);
}
aux_3435 = (aux_3436);
}
aux_3434 = BINT(aux_3435);
}
newtail1014_2203 = MAKE_PAIR(aux_3434, BNIL);
}
SET_CDR(tail1013_2195, newtail1014_2203);
{
obj_t tail1013_3446;
obj_t l1010_3444;
l1010_3444 = CDR(l1010_2194);
tail1013_3446 = newtail1014_2203;
tail1013_2195 = tail1013_3446;
l1010_2194 = l1010_3444;
goto lname1011_2193;
}
}
}
}
}
return make_sequence_237___rgc_rules(arg1432_898);
}
}


/* expand-... */obj_t expand_____85___rgc_rules(long match_23, obj_t env_24, obj_t num_25, obj_t rule_26, obj_t err_27)
{
{
bool_t test_3449;
if(INTEGERP(num_25)){
test_3449 = _2__206___r4_numbers_6_5(num_25, BINT(((long)0)));
}
 else {
test_3449 = ((bool_t)0);
}
if(test_3449){
obj_t rules_917;
{
obj_t e_2839_16_920;
e_2839_16_920 = expand_rule_234___rgc_rules(match_23, env_24, rule_26);
if(PAIRP(e_2839_16_920)){
bool_t test_3457;
{
obj_t aux_3458;
aux_3458 = CAR(e_2839_16_920);
test_3457 = (aux_3458==symbol2071___rgc_rules);
}
if(test_3457){
rules_917 = CDR(e_2839_16_920);
{
obj_t arg1456_926;
obj_t arg1458_927;
arg1456_926 = symbol2029___rgc_rules;
{
obj_t arg1461_930;
obj_t arg1463_931;
{
obj_t l1020_932;
l1020_932 = explode_sequence_86___rgc_rules(rules_917);
if(NULLP(l1020_932)){
arg1461_930 = BNIL;
}
 else {
obj_t head1022_934;
{
obj_t arg1471_945;
arg1471_945 = make_sequence_237___rgc_rules(CAR(l1020_932));
head1022_934 = MAKE_PAIR(arg1471_945, BNIL);
}
{
obj_t l1020_2264;
obj_t tail1023_2265;
l1020_2264 = CDR(l1020_932);
tail1023_2265 = head1022_934;
lname1021_2263:
if(NULLP(l1020_2264)){
arg1461_930 = head1022_934;
}
 else {
obj_t newtail1024_2273;
{
obj_t arg1468_2274;
arg1468_2274 = make_sequence_237___rgc_rules(CAR(l1020_2264));
newtail1024_2273 = MAKE_PAIR(arg1468_2274, BNIL);
}
SET_CDR(tail1023_2265, newtail1024_2273);
{
obj_t tail1023_3475;
obj_t l1020_3473;
l1020_3473 = CDR(l1020_2264);
tail1023_3475 = newtail1024_2273;
tail1023_2265 = tail1023_3475;
l1020_2264 = l1020_3473;
goto lname1021_2263;
}
}
}
}
}
arg1463_931 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1458_927 = append_2_18___r4_pairs_and_lists_6_3(arg1461_930, arg1463_931);
}
{
obj_t list1459_928;
list1459_928 = MAKE_PAIR(arg1458_927, BNIL);
return cons__138___r4_pairs_and_lists_6_3(arg1456_926, list1459_928);
}
}
}
 else {
FAILURE(BFALSE,string2070___rgc_rules,err_27);}
}
 else {
FAILURE(BFALSE,string2070___rgc_rules,err_27);}
}
}
 else {
FAILURE(BFALSE,string2072___rgc_rules,err_27);}
}
}


/* explode-sequence */obj_t explode_sequence_86___rgc_rules(obj_t rules_951)
{
if(NULLP(rules_951)){
return BNIL;
}
 else {
obj_t first_954;
first_954 = CAR(rules_951);
{
obj_t arg1480_955;
obj_t arg1481_956;
{
obj_t list1482_957;
list1482_957 = MAKE_PAIR(first_954, BNIL);
arg1480_955 = list1482_957;
}
{
obj_t l1015_959;
l1015_959 = explode_sequence_86___rgc_rules(CDR(rules_951));
if(NULLP(l1015_959)){
arg1481_956 = BNIL;
}
 else {
obj_t head1017_961;
head1017_961 = MAKE_PAIR(BNIL, BNIL);
{
obj_t l1015_2327;
obj_t tail1018_2328;
l1015_2327 = l1015_959;
tail1018_2328 = head1017_961;
lname1016_2326:
if(NULLP(l1015_2327)){
arg1481_956 = CDR(head1017_961);
}
 else {
obj_t newtail1019_2336;
{
obj_t arg1487_2337;
{
obj_t aux_3497;
aux_3497 = CAR(l1015_2327);
arg1487_2337 = MAKE_PAIR(first_954, aux_3497);
}
newtail1019_2336 = MAKE_PAIR(arg1487_2337, BNIL);
}
SET_CDR(tail1018_2328, newtail1019_2336);
{
obj_t tail1018_3504;
obj_t l1015_3502;
l1015_3502 = CDR(l1015_2327);
tail1018_3504 = newtail1019_2336;
tail1018_2328 = tail1018_3504;
l1015_2327 = l1015_3502;
goto lname1016_2326;
}
}
}
}
}
return MAKE_PAIR(arg1480_955, arg1481_956);
}
}
}


/* expand-uncase */obj_t expand_uncase_186___rgc_rules(long match_28, obj_t env_29, obj_t rule_30)
{
{
obj_t arg1494_978;
arg1494_978 = expand_rule_234___rgc_rules(match_28, env_29, rule_30);
return loop___rgc_rules(arg1494_978, BNIL);
}
}


/* loop */obj_t loop___rgc_rules(obj_t rule_975, obj_t res_976)
{
loop___rgc_rules:
if(NULLP(rule_975)){
return reverse__39___r4_pairs_and_lists_6_3(res_976);
}
 else {
if(PAIRP(rule_975)){
bool_t test_3513;
{
obj_t aux_3514;
aux_3514 = CAR(rule_975);
test_3513 = PAIRP(aux_3514);
}
if(test_3513){
{
obj_t arg1500_983;
obj_t arg1501_984;
arg1500_983 = CDR(rule_975);
{
obj_t arg1502_985;
arg1502_985 = loop___rgc_rules(CAR(rule_975), BNIL);
arg1501_984 = MAKE_PAIR(arg1502_985, res_976);
}
{
obj_t res_3522;
obj_t rule_3521;
rule_3521 = arg1500_983;
res_3522 = arg1501_984;
res_976 = res_3522;
rule_975 = rule_3521;
goto loop___rgc_rules;
}
}
}
 else {
bool_t test_3523;
{
obj_t aux_3524;
aux_3524 = CAR(rule_975);
test_3523 = INTEGERP(aux_3524);
}
if(test_3523){
{
bool_t test1506_989;
test1506_989 = rgc_alphabetic__209___rgc_config(CAR(rule_975));
if(test1506_989){
obj_t arg1507_990;
obj_t arg1510_991;
arg1507_990 = CDR(rule_975);
{
obj_t arg1511_992;
{
obj_t arg1513_993;
obj_t arg1514_994;
obj_t arg1515_995;
arg1513_993 = symbol2029___rgc_rules;
arg1514_994 = rgc_upcase_160___rgc_config(CAR(rule_975));
arg1515_995 = rgc_downcase_36___rgc_config(CAR(rule_975));
{
obj_t list1517_997;
{
obj_t arg1518_998;
{
obj_t arg1519_999;
arg1519_999 = MAKE_PAIR(BNIL, BNIL);
arg1518_998 = MAKE_PAIR(arg1515_995, arg1519_999);
}
list1517_997 = MAKE_PAIR(arg1514_994, arg1518_998);
}
arg1511_992 = cons__138___r4_pairs_and_lists_6_3(arg1513_993, list1517_997);
}
}
arg1510_991 = MAKE_PAIR(arg1511_992, res_976);
}
{
obj_t res_3541;
obj_t rule_3540;
rule_3540 = arg1507_990;
res_3541 = arg1510_991;
res_976 = res_3541;
rule_975 = rule_3540;
goto loop___rgc_rules;
}
}
 else {
obj_t arg1526_1003;
obj_t arg1527_1004;
arg1526_1003 = CDR(rule_975);
{
obj_t aux_3543;
aux_3543 = CAR(rule_975);
arg1527_1004 = MAKE_PAIR(aux_3543, res_976);
}
{
obj_t res_3547;
obj_t rule_3546;
rule_3546 = arg1526_1003;
res_3547 = arg1527_1004;
res_976 = res_3547;
rule_975 = rule_3546;
goto loop___rgc_rules;
}
}
}
}
 else {
{
obj_t arg1530_1007;
obj_t arg1531_1008;
arg1530_1007 = CDR(rule_975);
{
obj_t aux_3549;
aux_3549 = CAR(rule_975);
arg1531_1008 = MAKE_PAIR(aux_3549, res_976);
}
{
obj_t res_3553;
obj_t rule_3552;
rule_3552 = arg1530_1007;
res_3553 = arg1531_1008;
res_976 = res_3553;
rule_975 = rule_3552;
goto loop___rgc_rules;
}
}
}
}
}
 else {
if(INTEGERP(rule_975)){
bool_t test1536_1013;
test1536_1013 = rgc_alphabetic__209___rgc_config(rule_975);
if(test1536_1013){
obj_t arg1537_1014;
obj_t arg1539_1015;
obj_t arg1540_1016;
obj_t arg1542_1017;
arg1537_1014 = symbol2029___rgc_rules;
arg1539_1015 = rgc_upcase_160___rgc_config(rule_975);
arg1540_1016 = rgc_downcase_36___rgc_config(rule_975);
{
obj_t arg1550_1022;
arg1550_1022 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1542_1017 = append_2_18___r4_pairs_and_lists_6_3(res_976, arg1550_1022);
}
{
obj_t list1543_1018;
{
obj_t arg1545_1019;
{
obj_t arg1548_1020;
arg1548_1020 = MAKE_PAIR(arg1542_1017, BNIL);
arg1545_1019 = MAKE_PAIR(arg1540_1016, arg1548_1020);
}
list1543_1018 = MAKE_PAIR(arg1539_1015, arg1545_1019);
}
return cons__138___r4_pairs_and_lists_6_3(arg1537_1014, list1543_1018);
}
}
 else {
return rule_975;
}
}
 else {
return rule_975;
}
}
}
}


/* expand-* */obj_t expand___27___rgc_rules(long match_31, obj_t env_32, obj_t rule_33)
{
{
obj_t arg1554_2412;
obj_t arg1555_2413;
arg1554_2412 = symbol2056___rgc_rules;
arg1555_2413 = expand_rule_234___rgc_rules(match_31, env_32, rule_33);
{
obj_t list1557_2415;
{
obj_t arg1558_2416;
arg1558_2416 = MAKE_PAIR(BNIL, BNIL);
list1557_2415 = MAKE_PAIR(arg1555_2413, arg1558_2416);
}
return cons__138___r4_pairs_and_lists_6_3(arg1554_2412, list1557_2415);
}
}
}


/* expand-+ */obj_t expand___233___rgc_rules(long match_34, obj_t env_35, obj_t rule_36)
{
{
obj_t erule_2418;
erule_2418 = expand_rule_234___rgc_rules(match_34, env_35, rule_36);
{
obj_t arg1560_2419;
obj_t arg1561_2420;
arg1560_2419 = symbol2071___rgc_rules;
{
obj_t arg1568_2422;
arg1568_2422 = symbol2056___rgc_rules;
{
obj_t list1570_2424;
{
obj_t arg1572_2425;
arg1572_2425 = MAKE_PAIR(BNIL, BNIL);
list1570_2424 = MAKE_PAIR(erule_2418, arg1572_2425);
}
arg1561_2420 = cons__138___r4_pairs_and_lists_6_3(arg1568_2422, list1570_2424);
}
}
{
obj_t list1563_2427;
{
obj_t arg1564_2428;
{
obj_t arg1565_2429;
arg1565_2429 = MAKE_PAIR(BNIL, BNIL);
arg1564_2428 = MAKE_PAIR(arg1561_2420, arg1565_2429);
}
list1563_2427 = MAKE_PAIR(erule_2418, arg1564_2428);
}
return cons__138___r4_pairs_and_lists_6_3(arg1560_2419, list1563_2427);
}
}
}
}


/* expand-? */obj_t expand___7___rgc_rules(long match_37, obj_t env_38, obj_t rule_39)
{
{
obj_t arg1575_2431;
obj_t arg1578_2432;
obj_t arg1580_2433;
arg1575_2431 = symbol2029___rgc_rules;
arg1578_2432 = symbol2073___rgc_rules;
arg1580_2433 = expand_rule_234___rgc_rules(match_37, env_38, rule_39);
{
obj_t list1582_2435;
{
obj_t arg1583_2436;
{
obj_t arg1584_2437;
arg1584_2437 = MAKE_PAIR(BNIL, BNIL);
arg1583_2436 = MAKE_PAIR(arg1580_2433, arg1584_2437);
}
list1582_2435 = MAKE_PAIR(arg1578_2432, arg1583_2436);
}
return cons__138___r4_pairs_and_lists_6_3(arg1575_2431, list1582_2435);
}
}
}


/* expand-or */obj_t expand_or_72___rgc_rules(long match_40, obj_t env_41, obj_t rules_42)
{
{
obj_t rules_1052;
obj_t res_1053;
rules_1052 = rules_42;
res_1053 = BNIL;
loop_1054:
if(NULLP(rules_1052)){
obj_t arg1588_1057;
obj_t arg1589_1058;
arg1588_1057 = symbol2029___rgc_rules;
{
obj_t arg1593_1061;
obj_t arg1594_1062;
arg1593_1061 = reverse__39___r4_pairs_and_lists_6_3(res_1053);
arg1594_1062 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1589_1058 = append_2_18___r4_pairs_and_lists_6_3(arg1593_1061, arg1594_1062);
}
{
obj_t list1590_1059;
list1590_1059 = MAKE_PAIR(arg1589_1058, BNIL);
return cons__138___r4_pairs_and_lists_6_3(arg1588_1057, list1590_1059);
}
}
 else {
obj_t rule_1065;
rule_1065 = expand_rule_234___rgc_rules(match_40, env_41, CAR(rules_1052));
{
bool_t test_3592;
if(PAIRP(rule_1065)){
obj_t aux_3595;
aux_3595 = CAR(rule_1065);
test_3592 = (aux_3595==symbol2029___rgc_rules);
}
 else {
test_3592 = ((bool_t)0);
}
if(test_3592){
obj_t arg1598_1067;
obj_t arg1600_1068;
arg1598_1067 = CDR(rules_1052);
{
obj_t arg1602_1069;
arg1602_1069 = reverse__39___r4_pairs_and_lists_6_3(CDR(rule_1065));
arg1600_1068 = append_2_18___r4_pairs_and_lists_6_3(arg1602_1069, res_1053);
}
{
obj_t res_3603;
obj_t rules_3602;
rules_3602 = arg1598_1067;
res_3603 = arg1600_1068;
res_1053 = res_3603;
rules_1052 = rules_3602;
goto loop_1054;
}
}
 else {
obj_t arg1605_1071;
obj_t arg1606_1072;
arg1605_1071 = CDR(rules_1052);
arg1606_1072 = MAKE_PAIR(rule_1065, res_1053);
{
obj_t res_3607;
obj_t rules_3606;
rules_3606 = arg1605_1071;
res_3607 = arg1606_1072;
res_1053 = res_3607;
rules_1052 = rules_3606;
goto loop_1054;
}
}
}
}
}
}


/* expand-= */obj_t expand___73___rgc_rules(long match_43, obj_t env_44, obj_t num_45, obj_t rule_46, obj_t err_47)
{
{
bool_t test_3608;
if(INTEGERP(num_45)){
test_3608 = _2__206___r4_numbers_6_5(num_45, BINT(((long)0)));
}
 else {
test_3608 = ((bool_t)0);
}
if(test_3608){
obj_t erule_2452;
erule_2452 = expand_rule_234___rgc_rules(match_43, env_44, rule_46);
{
obj_t arg1612_2453;
{
obj_t arg1613_2454;
{
long aux_3614;
aux_3614 = (long)CINT(num_45);
arg1613_2454 = make_vector(aux_3614, erule_2452);
}
arg1612_2453 = vector__list_155___r4_vectors_6_8(arg1613_2454);
}
return make_sequence_237___rgc_rules(arg1612_2453);
}
}
 else {
FAILURE(BFALSE,string2072___rgc_rules,err_47);}
}
}


/* expand->= */obj_t expand____190___rgc_rules(long match_48, obj_t env_49, obj_t num_50, obj_t rule_51, obj_t err_52)
{
{
bool_t test_3620;
if(INTEGERP(num_50)){
test_3620 = _2__206___r4_numbers_6_5(num_50, BINT(((long)0)));
}
 else {
test_3620 = ((bool_t)0);
}
if(test_3620){
obj_t erule_1083;
erule_1083 = expand_rule_234___rgc_rules(match_48, env_49, rule_51);
{
obj_t arg1617_1084;
{
obj_t arg1618_1085;
obj_t arg1620_1086;
{
obj_t arg1621_1087;
{
long aux_3626;
aux_3626 = (long)CINT(num_50);
arg1621_1087 = make_vector(aux_3626, erule_1083);
}
arg1618_1085 = vector__list_155___r4_vectors_6_8(arg1621_1087);
}
{
obj_t arg1622_1088;
{
obj_t arg1627_1092;
arg1627_1092 = symbol2056___rgc_rules;
{
obj_t list1629_1094;
{
obj_t arg1630_1095;
arg1630_1095 = MAKE_PAIR(BNIL, BNIL);
list1629_1094 = MAKE_PAIR(erule_1083, arg1630_1095);
}
arg1622_1088 = cons__138___r4_pairs_and_lists_6_3(arg1627_1092, list1629_1094);
}
}
{
obj_t list1624_1090;
list1624_1090 = MAKE_PAIR(BNIL, BNIL);
arg1620_1086 = cons__138___r4_pairs_and_lists_6_3(arg1622_1088, list1624_1090);
}
}
arg1617_1084 = append_2_18___r4_pairs_and_lists_6_3(arg1618_1085, arg1620_1086);
}
return make_sequence_237___rgc_rules(arg1617_1084);
}
}
 else {
FAILURE(BFALSE,string2072___rgc_rules,err_52);}
}
}


/* expand-** */obj_t expand____181___rgc_rules(long match_53, obj_t env_54, obj_t min_55, obj_t max_56, obj_t rule_57, obj_t err_58)
{
{
bool_t test_3638;
if(INTEGERP(min_55)){
if(_2__206___r4_numbers_6_5(min_55, BINT(((long)0)))){
if(INTEGERP(max_56)){
test_3638 = _2__206___r4_numbers_6_5(max_56, min_55);
}
 else {
test_3638 = ((bool_t)0);
}
}
 else {
test_3638 = ((bool_t)0);
}
}
 else {
test_3638 = ((bool_t)0);
}
if(test_3638){
obj_t erule_1099;
erule_1099 = expand_rule_234___rgc_rules(match_53, env_54, rule_57);
{
obj_t min_1100;
obj_t res_1101;
min_1100 = min_55;
res_1101 = BNIL;
loop_1102:
if(_2__206___r4_numbers_6_5(min_1100, max_56)){
obj_t arg1638_1105;
obj_t arg1639_1106;
arg1638_1105 = symbol2029___rgc_rules;
arg1639_1106 = reverse__39___r4_pairs_and_lists_6_3(res_1101);
{
obj_t list1641_1108;
{
obj_t arg1645_1109;
arg1645_1109 = MAKE_PAIR(BNIL, BNIL);
list1641_1108 = MAKE_PAIR(arg1639_1106, arg1645_1109);
}
return cons__138___r4_pairs_and_lists_6_3(arg1638_1105, list1641_1108);
}
}
 else {
obj_t arg1647_1111;
obj_t arg1648_1112;
arg1647_1111 = _2__168___r4_numbers_6_5(min_1100, BINT(((long)1)));
{
obj_t arg1649_1113;
{
obj_t arg1650_1114;
{
obj_t arg1652_1115;
{
long aux_3656;
aux_3656 = (long)CINT(min_1100);
arg1652_1115 = make_vector(aux_3656, erule_1099);
}
arg1650_1114 = vector__list_155___r4_vectors_6_8(arg1652_1115);
}
arg1649_1113 = make_sequence_237___rgc_rules(arg1650_1114);
}
arg1648_1112 = MAKE_PAIR(arg1649_1113, res_1101);
}
{
obj_t res_3663;
obj_t min_3662;
min_3662 = arg1647_1111;
res_3663 = arg1648_1112;
res_1101 = res_3663;
min_1100 = min_3662;
goto loop_1102;
}
}
}
}
 else {
FAILURE(BFALSE,string2072___rgc_rules,err_58);}
}
}


/* expand-in */obj_t expand_in_193___rgc_rules(long match_59, obj_t env_60, obj_t values_61, obj_t err_62)
{
{
obj_t values_1122;
obj_t chars_1123;
values_1122 = values_61;
chars_1123 = BNIL;
loop_1124:
if(NULLP(values_1122)){
obj_t arg1658_1127;
obj_t arg1659_1128;
arg1658_1127 = symbol2029___rgc_rules;
{
obj_t arg1663_1131;
arg1663_1131 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1659_1128 = append_2_18___r4_pairs_and_lists_6_3(chars_1123, arg1663_1131);
}
{
obj_t list1660_1129;
list1660_1129 = MAKE_PAIR(arg1659_1128, BNIL);
return cons__138___r4_pairs_and_lists_6_3(arg1658_1127, list1660_1129);
}
}
 else {
obj_t value_1134;
value_1134 = CAR(values_1122);
{
obj_t or_chars_181_1142;
{
bool_t test1667_1146;
test1667_1146 = rgc_char__84___rgc_rules(value_1134);
if(test1667_1146){
{
obj_t arg1711_1192;
obj_t arg1712_1193;
arg1711_1192 = CDR(values_1122);
{
obj_t aux_3675;
if(CHARP(value_1134)){
long aux_3678;
{
unsigned char aux_3679;
aux_3679 = (unsigned char)CCHAR(value_1134);
aux_3678 = (aux_3679);
}
aux_3675 = BINT(aux_3678);
}
 else {
aux_3675 = value_1134;
}
arg1712_1193 = MAKE_PAIR(aux_3675, chars_1123);
}
{
obj_t chars_3685;
obj_t values_3684;
values_3684 = arg1711_1192;
chars_3685 = arg1712_1193;
chars_1123 = chars_3685;
values_1122 = values_3684;
goto loop_1124;
}
}
}
 else {
if(STRINGP(value_1134)){
{
obj_t arg1716_1196;
obj_t arg1717_1197;
arg1716_1196 = CDR(values_1122);
{
obj_t arg1718_1198;
{
obj_t l1028_1199;
l1028_1199 = string__list_125___r4_strings_6_7(value_1134);
if(NULLP(l1028_1199)){
arg1718_1198 = BNIL;
}
 else {
obj_t head1030_1201;
{
obj_t aux_3692;
{
long aux_3693;
{
unsigned char aux_3694;
{
obj_t aux_3695;
aux_3695 = CAR(l1028_1199);
aux_3694 = (unsigned char)CCHAR(aux_3695);
}
aux_3693 = (aux_3694);
}
aux_3692 = BINT(aux_3693);
}
head1030_1201 = MAKE_PAIR(aux_3692, BNIL);
}
{
obj_t l1028_2544;
obj_t tail1031_2545;
l1028_2544 = CDR(l1028_1199);
tail1031_2545 = head1030_1201;
lname1029_2543:
if(NULLP(l1028_2544)){
arg1718_1198 = head1030_1201;
}
 else {
obj_t newtail1032_2553;
{
obj_t aux_3703;
{
long aux_3704;
{
unsigned char aux_3705;
{
obj_t aux_3706;
aux_3706 = CAR(l1028_2544);
aux_3705 = (unsigned char)CCHAR(aux_3706);
}
aux_3704 = (aux_3705);
}
aux_3703 = BINT(aux_3704);
}
newtail1032_2553 = MAKE_PAIR(aux_3703, BNIL);
}
SET_CDR(tail1031_2545, newtail1032_2553);
{
obj_t tail1031_3715;
obj_t l1028_3713;
l1028_3713 = CDR(l1028_2544);
tail1031_3715 = newtail1032_2553;
tail1031_2545 = tail1031_3715;
l1028_2544 = l1028_3713;
goto lname1029_2543;
}
}
}
}
}
arg1717_1197 = append_2_18___r4_pairs_and_lists_6_3(arg1718_1198, chars_1123);
}
{
obj_t chars_3719;
obj_t values_3718;
values_3718 = arg1716_1196;
chars_3719 = arg1717_1197;
chars_1123 = chars_3719;
values_1122 = values_3718;
goto loop_1124;
}
}
}
 else {
if(PAIRP(value_1134)){
obj_t car_2866_208_1149;
obj_t cdr_2867_151_1150;
car_2866_208_1149 = CAR(value_1134);
cdr_2867_151_1150 = CDR(value_1134);
{
bool_t test1670_1151;
test1670_1151 = rgc_char__84___rgc_rules(car_2866_208_1149);
if(test1670_1151){
if(PAIRP(cdr_2867_151_1150)){
obj_t car_2872_201_1153;
car_2872_201_1153 = CAR(cdr_2867_151_1150);
{
bool_t test1672_1154;
test1672_1154 = rgc_char__84___rgc_rules(car_2872_201_1153);
if(test1672_1154){
bool_t test_3731;
{
obj_t aux_3732;
aux_3732 = CDR(cdr_2867_151_1150);
test_3731 = (aux_3732==BNIL);
}
if(test_3731){
obj_t arg1729_2483;
obj_t arg1730_2484;
arg1729_2483 = CDR(values_1122);
{
obj_t arg1731_2485;
arg1731_2485 = char_range_115___rgc_rules(err_62, car_2866_208_1149, car_2872_201_1153);
arg1730_2484 = append_2_18___r4_pairs_and_lists_6_3(arg1731_2485, chars_1123);
}
{
obj_t chars_3739;
obj_t values_3738;
values_3738 = arg1729_2483;
chars_3739 = arg1730_2484;
chars_1123 = chars_3739;
values_1122 = values_3738;
goto loop_1124;
}
}
 else {
if((car_2866_208_1149==symbol2029___rgc_rules)){
or_chars_181_1142 = cdr_2867_151_1150;
tag_2849_132_1143:
{
obj_t cs_1221;
obj_t res_1222;
cs_1221 = or_chars_181_1142;
res_1222 = BNIL;
laap_1223:
if(NULLP(cs_1221)){
{
obj_t chars_3746;
obj_t values_3744;
values_3744 = CDR(values_1122);
chars_3746 = append_2_18___r4_pairs_and_lists_6_3(res_1222, chars_1123);
chars_1123 = chars_3746;
values_1122 = values_3744;
goto loop_1124;
}
}
 else {
bool_t test1745_1228;
test1745_1228 = rgc_char__84___rgc_rules(CAR(cs_1221));
if(test1745_1228){
{
obj_t arg1746_1229;
obj_t arg1747_1230;
arg1746_1229 = CDR(cs_1221);
{
obj_t aux_3752;
aux_3752 = CAR(cs_1221);
arg1747_1230 = MAKE_PAIR(aux_3752, res_1222);
}
{
obj_t res_3756;
obj_t cs_3755;
cs_3755 = arg1746_1229;
res_3756 = arg1747_1230;
res_1222 = res_3756;
cs_1221 = cs_3755;
goto laap_1223;
}
}
}
 else {
bool_t test_3757;
{
bool_t test_3758;
{
obj_t aux_3759;
aux_3759 = CAR(cs_1221);
test_3758 = PAIRP(aux_3759);
}
if(test_3758){
obj_t aux_3762;
{
obj_t aux_3763;
aux_3763 = CAR(cs_1221);
aux_3762 = CAR(aux_3763);
}
test_3757 = (aux_3762==symbol2029___rgc_rules);
}
 else {
test_3757 = ((bool_t)0);
}
}
if(test_3757){
{
obj_t cs_3767;
{
obj_t aux_3768;
{
obj_t aux_3769;
aux_3769 = CAR(cs_1221);
aux_3768 = CDR(aux_3769);
}
cs_3767 = append_2_18___r4_pairs_and_lists_6_3(aux_3768, CDR(cs_1221));
}
cs_1221 = cs_3767;
goto laap_1223;
}
}
 else {
FAILURE(BFALSE,string2054___rgc_rules,err_62);}
}
}
}
}
 else {
tag_2850_223_1144:
{
obj_t arg1766_1241;
{
obj_t arg1767_1242;
obj_t arg1768_1243;
arg1767_1242 = expand_rule_234___rgc_rules(match_59, env_60, CAR(values_1122));
arg1768_1243 = CDR(values_1122);
arg1766_1241 = MAKE_PAIR(arg1767_1242, arg1768_1243);
}
{
obj_t values_3779;
values_3779 = arg1766_1241;
values_1122 = values_3779;
goto loop_1124;
}
}
}
}
}
 else {
if((car_2866_208_1149==symbol2029___rgc_rules)){
obj_t or_chars_181_3782;
or_chars_181_3782 = cdr_2867_151_1150;
or_chars_181_1142 = or_chars_181_3782;
goto tag_2849_132_1143;
}
 else {
goto tag_2850_223_1144;
}
}
}
}
 else {
if(STRINGP(car_2866_208_1149)){
if((cdr_2867_151_1150==BNIL)){
obj_t arg1732_2501;
obj_t arg1733_2502;
arg1732_2501 = CDR(values_1122);
{
obj_t arg1738_2503;
arg1738_2503 = string_range_42___rgc_rules(err_62, car_2866_208_1149);
arg1733_2502 = append_2_18___r4_pairs_and_lists_6_3(arg1738_2503, chars_1123);
}
{
obj_t chars_3791;
obj_t values_3790;
values_3790 = arg1732_2501;
chars_3791 = arg1733_2502;
chars_1123 = chars_3791;
values_1122 = values_3790;
goto loop_1124;
}
}
 else {
if((car_2866_208_1149==symbol2029___rgc_rules)){
obj_t or_chars_181_3794;
or_chars_181_3794 = cdr_2867_151_1150;
or_chars_181_1142 = or_chars_181_3794;
goto tag_2849_132_1143;
}
 else {
goto tag_2850_223_1144;
}
}
}
 else {
if((car_2866_208_1149==symbol2029___rgc_rules)){
obj_t or_chars_181_3797;
or_chars_181_3797 = cdr_2867_151_1150;
or_chars_181_1142 = or_chars_181_3797;
goto tag_2849_132_1143;
}
 else {
goto tag_2850_223_1144;
}
}
}
}
 else {
if(STRINGP(car_2866_208_1149)){
if((cdr_2867_151_1150==BNIL)){
obj_t arg1732_2519;
obj_t arg1733_2520;
arg1732_2519 = CDR(values_1122);
{
obj_t arg1738_2521;
arg1738_2521 = string_range_42___rgc_rules(err_62, car_2866_208_1149);
arg1733_2520 = append_2_18___r4_pairs_and_lists_6_3(arg1738_2521, chars_1123);
}
{
obj_t chars_3806;
obj_t values_3805;
values_3805 = arg1732_2519;
chars_3806 = arg1733_2520;
chars_1123 = chars_3806;
values_1122 = values_3805;
goto loop_1124;
}
}
 else {
if((car_2866_208_1149==symbol2029___rgc_rules)){
obj_t or_chars_181_3809;
or_chars_181_3809 = cdr_2867_151_1150;
or_chars_181_1142 = or_chars_181_3809;
goto tag_2849_132_1143;
}
 else {
goto tag_2850_223_1144;
}
}
}
 else {
if((car_2866_208_1149==symbol2029___rgc_rules)){
obj_t or_chars_181_3812;
or_chars_181_3812 = cdr_2867_151_1150;
or_chars_181_1142 = or_chars_181_3812;
goto tag_2849_132_1143;
}
 else {
goto tag_2850_223_1144;
}
}
}
}
}
 else {
goto tag_2850_223_1144;
}
}
}
}
}
}
}
}


/* string-range */obj_t string_range_42___rgc_rules(obj_t err_2811, obj_t string_1245)
{
{
long len_1247;
len_1247 = STRING_LENGTH(string_1245);
{
bool_t test1771_1248;
{
long arg1783_1261;
arg1783_1261 = (len_1247%((long)2));
test1771_1248 = _2__206___r4_numbers_6_5(BINT(arg1783_1261), BINT(((long)0)));
}
if(test1771_1248){
FAILURE(BFALSE,string2074___rgc_rules,err_2811);}
 else {
long i_1249;
obj_t res_1250;
i_1249 = ((long)0);
res_1250 = BNIL;
loop_1251:
if((i_1249==len_1247)){
return res_1250;
}
 else {
long arg1776_1255;
obj_t arg1777_1256;
arg1776_1255 = (i_1249+((long)2));
{
obj_t arg1778_1257;
{
obj_t aux_3827;
obj_t aux_3823;
{
unsigned char aux_3828;
{
long aux_3829;
aux_3829 = (i_1249+((long)1));
aux_3828 = STRING_REF(string_1245, aux_3829);
}
aux_3827 = BCHAR(aux_3828);
}
{
unsigned char aux_3824;
aux_3824 = STRING_REF(string_1245, i_1249);
aux_3823 = BCHAR(aux_3824);
}
arg1778_1257 = char_range_115___rgc_rules(err_2811, aux_3823, aux_3827);
}
arg1777_1256 = append_2_18___r4_pairs_and_lists_6_3(arg1778_1257, res_1250);
}
{
obj_t res_3836;
long i_3835;
i_3835 = arg1776_1255;
res_3836 = arg1777_1256;
res_1250 = res_3836;
i_1249 = i_3835;
goto loop_1251;
}
}
}
}
}
}


/* rgc-char? */bool_t rgc_char__84___rgc_rules(obj_t x_1278)
{
{
bool_t _ortest_1025_1280;
_ortest_1025_1280 = CHARP(x_1278);
if(_ortest_1025_1280){
return _ortest_1025_1280;
}
 else {
if(INTEGERP(x_1278)){
bool_t test_3841;
{
long aux_3842;
aux_3842 = (long)CINT(x_1278);
test_3841 = (aux_3842>=((long)0));
}
if(test_3841){
obj_t arg1797_1283;
arg1797_1283 = rgc_max_char_237___rgc_config();
{
long aux_3848;
long aux_3846;
aux_3848 = (long)CINT(arg1797_1283);
aux_3846 = (long)CINT(x_1278);
return (aux_3846<aux_3848);
}
}
 else {
return ((bool_t)0);
}
}
 else {
return ((bool_t)0);
}
}
}
}


/* char-range */obj_t char_range_115___rgc_rules(obj_t err_2812, obj_t min_1263, obj_t max_1264)
{
{
obj_t min_1266;
obj_t max_1267;
if(CHARP(min_1263)){
long aux_3853;
{
unsigned char aux_3854;
aux_3854 = (unsigned char)CCHAR(min_1263);
aux_3853 = (aux_3854);
}
min_1266 = BINT(aux_3853);
}
 else {
min_1266 = min_1263;
}
if(CHARP(max_1264)){
long aux_3860;
{
unsigned char aux_3861;
aux_3861 = (unsigned char)CCHAR(max_1264);
aux_3860 = (aux_3861);
}
max_1267 = BINT(aux_3860);
}
 else {
max_1267 = max_1264;
}
{
bool_t test_3865;
{
long aux_3868;
long aux_3866;
aux_3868 = (long)CINT(min_1266);
aux_3866 = (long)CINT(max_1267);
test_3865 = (aux_3866>=aux_3868);
}
if(test_3865){
{
obj_t max_2654;
obj_t res_2655;
max_2654 = max_1267;
res_2655 = BNIL;
loop_2653:
{
bool_t test_3871;
{
long aux_3874;
long aux_3872;
aux_3874 = (long)CINT(min_1266);
aux_3872 = (long)CINT(max_2654);
test_3871 = (aux_3872==aux_3874);
}
if(test_3871){
return MAKE_PAIR(min_1266, res_2655);
}
 else {
long arg1792_2660;
obj_t arg1793_2661;
{
long aux_3878;
aux_3878 = (long)CINT(max_2654);
arg1792_2660 = (aux_3878-((long)1));
}
arg1793_2661 = MAKE_PAIR(max_2654, res_2655);
{
obj_t res_3884;
obj_t max_3882;
max_3882 = BINT(arg1792_2660);
res_3884 = arg1793_2661;
res_2655 = res_3884;
max_2654 = max_3882;
goto loop_2653;
}
}
}
}
}
 else {
FAILURE(BFALSE,string2075___rgc_rules,err_2812);}
}
}
}


/* expand-out */obj_t expand_out_127___rgc_rules(long match_63, obj_t env_64, obj_t values_65, obj_t err_66)
{
{
obj_t in_2703;
in_2703 = expand_in_193___rgc_rules(match_63, env_64, values_65, err_66);
{
obj_t bc_2704;
{
obj_t arg1807_2705;
obj_t arg1808_2706;
arg1807_2705 = CDR(in_2703);
arg1808_2706 = rgc_max_char_237___rgc_config();
bc_2704 = list__rgcset_152___rgc_set(arg1807_2705, CINT(arg1808_2706));
}
{
rgcset_not__199___rgc_set(bc_2704);
{
obj_t arg1799_2707;
obj_t arg1800_2708;
arg1799_2707 = symbol2029___rgc_rules;
{
obj_t arg1803_2709;
obj_t arg1804_2710;
arg1803_2709 = rgcset__list_240___rgc_set(bc_2704);
arg1804_2710 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1800_2708 = append_2_18___r4_pairs_and_lists_6_3(arg1803_2709, arg1804_2710);
}
{
obj_t list1801_2713;
list1801_2713 = MAKE_PAIR(arg1800_2708, BNIL);
return cons__138___r4_pairs_and_lists_6_3(arg1799_2707, list1801_2713);
}
}
}
}
}
}


/* expand-and */obj_t expand_and_10___rgc_rules(long match_67, obj_t env_68, obj_t val1_69, obj_t val2_70, obj_t err_71)
{
{
obj_t in1_2716;
in1_2716 = expand_in_193___rgc_rules(match_67, env_68, val1_69, err_71);
{
obj_t in2_2717;
in2_2717 = expand_in_193___rgc_rules(match_67, env_68, val2_70, err_71);
{
obj_t bc1_2718;
{
obj_t arg1817_2719;
arg1817_2719 = rgc_max_char_237___rgc_config();
bc1_2718 = list__rgcset_152___rgc_set(in1_2716, CINT(arg1817_2719));
}
{
obj_t bc2_2720;
{
obj_t arg1816_2721;
arg1816_2721 = rgc_max_char_237___rgc_config();
bc2_2720 = list__rgcset_152___rgc_set(in2_2717, CINT(arg1816_2721));
}
{
{
obj_t arg1809_2722;
obj_t arg1810_2723;
arg1809_2722 = symbol2029___rgc_rules;
{
obj_t arg1815_2725;
arg1815_2725 = rgcset_and__23___rgc_set(bc1_2718, bc2_2720);
arg1810_2723 = rgcset__list_240___rgc_set(arg1815_2725);
}
{
obj_t list1812_2726;
{
obj_t arg1813_2727;
arg1813_2727 = MAKE_PAIR(BNIL, BNIL);
list1812_2726 = MAKE_PAIR(arg1810_2723, arg1813_2727);
}
return cons__138___r4_pairs_and_lists_6_3(arg1809_2722, list1812_2726);
}
}
}
}
}
}
}
}


/* expand-but */obj_t expand_but_245___rgc_rules(long match_72, obj_t env_73, obj_t val1_74, obj_t val2_75, obj_t err_76)
{
{
obj_t in1_2729;
in1_2729 = expand_in_193___rgc_rules(match_72, env_73, val1_74, err_76);
{
obj_t in2_2730;
in2_2730 = expand_in_193___rgc_rules(match_72, env_73, val2_75, err_76);
{
obj_t bc1_2731;
{
obj_t arg1829_2732;
arg1829_2732 = rgc_max_char_237___rgc_config();
bc1_2731 = list__rgcset_152___rgc_set(in1_2729, CINT(arg1829_2732));
}
{
obj_t bc2_2733;
{
obj_t arg1827_2734;
arg1827_2734 = rgc_max_char_237___rgc_config();
bc2_2733 = list__rgcset_152___rgc_set(in2_2730, CINT(arg1827_2734));
}
{
{
obj_t arg1818_2735;
obj_t arg1820_2736;
arg1818_2735 = symbol2029___rgc_rules;
{
obj_t arg1826_2738;
arg1826_2738 = rgcset_but__159___rgc_set(bc1_2731, bc2_2733);
arg1820_2736 = rgcset__list_240___rgc_set(arg1826_2738);
}
{
obj_t list1822_2739;
{
obj_t arg1823_2740;
arg1823_2740 = MAKE_PAIR(BNIL, BNIL);
list1822_2739 = MAKE_PAIR(arg1820_2736, arg1823_2740);
}
return cons__138___r4_pairs_and_lists_6_3(arg1818_2735, list1822_2739);
}
}
}
}
}
}
}
}


/* expand-submatch */obj_t expand_submatch_201___rgc_rules(long match_77, obj_t env_78, obj_t rule_79)
{
{
long submatch_2742;
submatch_2742 = get_new_submatch_255___rgc_rules();
{
obj_t arg1830_2743;
obj_t arg1831_2744;
arg1830_2743 = symbol2065___rgc_rules;
arg1831_2744 = expand_rule_234___rgc_rules(match_77, env_78, rule_79);
{
obj_t list1833_2746;
{
obj_t arg1834_2747;
{
obj_t arg1835_2748;
{
obj_t arg1836_2749;
arg1836_2749 = MAKE_PAIR(BNIL, BNIL);
arg1835_2748 = MAKE_PAIR(arg1831_2744, arg1836_2749);
}
{
obj_t aux_3927;
aux_3927 = BINT(submatch_2742);
arg1834_2747 = MAKE_PAIR(aux_3927, arg1835_2748);
}
}
{
obj_t aux_3930;
aux_3930 = BINT(match_77);
list1833_2746 = MAKE_PAIR(aux_3930, arg1834_2747);
}
}
return cons__138___r4_pairs_and_lists_6_3(arg1830_2743, list1833_2746);
}
}
}
}


/* expand-sequence */obj_t expand_sequence_153___rgc_rules(long match_84, obj_t env_85, obj_t rules_86)
{
{
obj_t arg1847_1339;
{
obj_t head1035_1342;
head1035_1342 = MAKE_PAIR(BNIL, BNIL);
{
obj_t l1033_1343;
obj_t tail1036_1344;
l1033_1343 = rules_86;
tail1036_1344 = head1035_1342;
lname1034_1345:
if(NULLP(l1033_1343)){
arg1847_1339 = CDR(head1035_1342);
}
 else {
obj_t newtail1037_1347;
{
obj_t arg1851_1349;
arg1851_1349 = expand_rule_234___rgc_rules(match_84, env_85, CAR(l1033_1343));
newtail1037_1347 = MAKE_PAIR(arg1851_1349, BNIL);
}
SET_CDR(tail1036_1344, newtail1037_1347);
{
obj_t tail1036_3944;
obj_t l1033_3942;
l1033_3942 = CDR(l1033_1343);
tail1036_3944 = newtail1037_1347;
tail1036_1344 = tail1036_3944;
l1033_1343 = l1033_3942;
goto lname1034_1345;
}
}
}
}
return make_sequence_237___rgc_rules(arg1847_1339);
}
}


/* make-sequence */obj_t make_sequence_237___rgc_rules(obj_t rules_87)
{
{
obj_t rules_1354;
obj_t res_1355;
rules_1354 = rules_87;
res_1355 = BNIL;
loop_1356:
{
if((rules_1354==BNIL)){
{
obj_t arg1867_1374;
obj_t arg1868_1375;
arg1867_1374 = symbol2071___rgc_rules;
{
obj_t arg1871_1378;
obj_t arg1874_1379;
arg1871_1378 = reverse__39___r4_pairs_and_lists_6_3(res_1355);
arg1874_1379 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1868_1375 = append_2_18___r4_pairs_and_lists_6_3(arg1871_1378, arg1874_1379);
}
{
obj_t list1869_1376;
list1869_1376 = MAKE_PAIR(arg1868_1375, BNIL);
return cons__138___r4_pairs_and_lists_6_3(arg1867_1374, list1869_1376);
}
}
}
 else {
if(PAIRP(rules_1354)){
obj_t car_2947_17_1366;
car_2947_17_1366 = CAR(rules_1354);
if(PAIRP(car_2947_17_1366)){
bool_t test_3958;
{
obj_t aux_3959;
aux_3959 = CAR(car_2947_17_1366);
test_3958 = (aux_3959==symbol2071___rgc_rules);
}
if(test_3958){
obj_t arg1863_1370;
arg1863_1370 = CDR(rules_1354);
{
obj_t arg1877_2774;
{
obj_t arg1878_2775;
arg1878_2775 = reverse__39___r4_pairs_and_lists_6_3(CDR(car_2947_17_1366));
arg1877_2774 = append_2_18___r4_pairs_and_lists_6_3(arg1878_2775, res_1355);
}
{
obj_t res_3967;
obj_t rules_3966;
rules_3966 = arg1863_1370;
res_3967 = arg1877_2774;
res_1355 = res_3967;
rules_1354 = rules_3966;
goto loop_1356;
}
}
}
 else {
tag_2939_81_1362:
{
obj_t arg1879_1384;
obj_t arg1880_1385;
arg1879_1384 = CDR(rules_1354);
{
obj_t aux_3969;
aux_3969 = CAR(rules_1354);
arg1880_1385 = MAKE_PAIR(aux_3969, res_1355);
}
{
obj_t res_3973;
obj_t rules_3972;
rules_3972 = arg1879_1384;
res_3973 = arg1880_1385;
res_1355 = res_3973;
rules_1354 = rules_3972;
goto loop_1356;
}
}
}
}
 else {
goto tag_2939_81_1362;
}
}
 else {
goto tag_2939_81_1362;
}
}
}
}
}


/* imported-modules-init */obj_t imported_modules_init_94___rgc_rules()
{
module_initialization_70___rgc_config(((long)0), "__RGC_RULES");
module_initialization_70___rgc_set(((long)0), "__RGC_RULES");
module_initialization_70___rgc_posix(((long)0), "__RGC_RULES");
return module_initialization_70___error(((long)0), "__RGC_RULES");
}

