/*===========================================================================*/
/*   (Rgc/rgc-posix.scm)                                                     */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

extern obj_t string_to_symbol(char *);
extern obj_t append_2_18___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t symbol1399___rgc_posix = BUNSPEC;
static obj_t symbol1409___rgc_posix = BUNSPEC;
static obj_t symbol1398___rgc_posix = BUNSPEC;
static obj_t symbol1408___rgc_posix = BUNSPEC;
static obj_t symbol1396___rgc_posix = BUNSPEC;
static obj_t symbol1395___rgc_posix = BUNSPEC;
static obj_t symbol1394___rgc_posix = BUNSPEC;
static obj_t symbol1393___rgc_posix = BUNSPEC;
static obj_t symbol1403___rgc_posix = BUNSPEC;
static obj_t symbol1392___rgc_posix = BUNSPEC;
static obj_t symbol1402___rgc_posix = BUNSPEC;
static obj_t _posix__rgc_69___rgc_posix(obj_t, obj_t);
static obj_t list1406___rgc_posix = BUNSPEC;
static obj_t toplevel_init_63___rgc_posix();
static obj_t parse_posix_exp_254___rgc_posix(obj_t, long);
extern obj_t _res2__167___r5_control_features_6_4;
extern obj_t _res1__155___r5_control_features_6_4;
extern obj_t list__string_78___r4_strings_6_7(obj_t);
static obj_t parse_posix_branch_174___rgc_posix(obj_t, long);
static obj_t make_rgc_or_156___rgc_posix(obj_t);
extern obj_t posix__rgc_86___rgc_posix(obj_t);
extern obj_t reverse___r4_pairs_and_lists_6_3(obj_t);
extern obj_t memq___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t parse_posix_atom_99___rgc_posix(obj_t, obj_t);
extern obj_t module_initialization_70___rgc_posix(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t string__number_104___r4_numbers_6_5(obj_t, obj_t);
static obj_t parse_posix_bracket_232___rgc_posix(obj_t, long);
extern obj_t c_substring(obj_t, long, long);
extern obj_t _res_number__75___r5_control_features_6_4;
static obj_t make_rgc_repeat_123___rgc_posix(obj_t, obj_t, obj_t);
static obj_t parse_posix_piece_52___rgc_posix(obj_t, obj_t);
static obj_t _err_string__201___rgc_posix = BUNSPEC;
static obj_t parse_posix_braces_195___rgc_posix(obj_t, obj_t);
extern obj_t _2__168___r4_numbers_6_5(obj_t, obj_t);
extern obj_t cons__138___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t imported_modules_init_94___rgc_posix();
static obj_t require_initialization_114___rgc_posix = BUNSPEC;
static obj_t cnst_init_137___rgc_posix();
static obj_t make_rgc_sequence_72___rgc_posix(obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( posix__rgc_env_138___rgc_posix, _posix__rgc_69___rgc_posix1414, _posix__rgc_69___rgc_posix, 0L, 1 );
DEFINE_STRING( string1412___rgc_posix, string1412___rgc_posix1415, "Missing close brace in regexp", 29 );
DEFINE_STRING( string1411___rgc_posix, string1411___rgc_posix1416, "Missing close right bracket in regexp", 37 );
DEFINE_STRING( string1410___rgc_posix, string1410___rgc_posix1417, "Illegal - in [...] regexp", 25 );
DEFINE_STRING( string1397___rgc_posix, string1397___rgc_posix1418, "RGC:Illegal posix string", 24 );
DEFINE_STRING( string1407___rgc_posix, string1407___rgc_posix1419, "double-bracket regexps not supported.", 37 );
DEFINE_STRING( string1405___rgc_posix, string1405___rgc_posix1420, "RGC:expression may not terminate with a backslash", 49 );
DEFINE_STRING( string1404___rgc_posix, string1404___rgc_posix1421, "RGC:subexpression has no terminating close parenthesis", 54 );
DEFINE_STRING( string1391___rgc_posix, string1391___rgc_posix1422, "RGC:Illegal Posix regexp -- terminated early", 44 );
DEFINE_STRING( string1401___rgc_posix, string1401___rgc_posix1423, "RGC: `$' regexps not supported.", 31 );
DEFINE_STRING( string1400___rgc_posix, string1400___rgc_posix1424, "RGC: `^' regexps not supported.", 31 );


/* module-initialization */obj_t module_initialization_70___rgc_posix(long checksum_1070, char * from_1071)
{
if(CBOOL(require_initialization_114___rgc_posix)){
require_initialization_114___rgc_posix = BBOOL(((bool_t)0));
cnst_init_137___rgc_posix();
imported_modules_init_94___rgc_posix();
toplevel_init_63___rgc_posix();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___rgc_posix()
{
symbol1392___rgc_posix = string_to_symbol("*");
symbol1393___rgc_posix = string_to_symbol("+");
symbol1394___rgc_posix = string_to_symbol("?");
symbol1395___rgc_posix = string_to_symbol("**");
symbol1396___rgc_posix = string_to_symbol(">=");
symbol1398___rgc_posix = string_to_symbol("OR");
symbol1399___rgc_posix = string_to_symbol(":");
symbol1402___rgc_posix = string_to_symbol("ALL");
symbol1403___rgc_posix = string_to_symbol("SUBMATCH");
{
obj_t aux_1089;
obj_t aux_1087;
{
obj_t aux_1092;
obj_t aux_1090;
{
obj_t aux_1093;
aux_1093 = BCHAR(((unsigned char)':'));
aux_1092 = MAKE_PAIR(aux_1093, BNIL);
}
aux_1090 = BCHAR(((unsigned char)'='));
aux_1089 = MAKE_PAIR(aux_1090, aux_1092);
}
aux_1087 = BCHAR(((unsigned char)'.'));
list1406___rgc_posix = MAKE_PAIR(aux_1087, aux_1089);
}
symbol1408___rgc_posix = string_to_symbol("OUT");
return (symbol1409___rgc_posix = string_to_symbol("IN"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___rgc_posix()
{
return (_err_string__201___rgc_posix = BUNSPEC,
BUNSPEC);
}


/* posix->rgc */obj_t posix__rgc_86___rgc_posix(obj_t s_1)
{
_err_string__201___rgc_posix = s_1;
{
obj_t rgc_329;
rgc_329 = parse_posix_exp_254___rgc_posix(s_1, ((long)0));
{
obj_t i_330;
i_330 = _res1__155___r5_control_features_6_4;
{
bool_t test_1101;
{
long aux_1104;
long aux_1102;
aux_1104 = STRING_LENGTH(s_1);
aux_1102 = (long)CINT(i_330);
test_1101 = (aux_1102==aux_1104);
}
if(test_1101){
return rgc_329;
}
 else {
obj_t object_745;
object_745 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1391___rgc_posix,object_745);}
}
}
}
}


/* _posix->rgc */obj_t _posix__rgc_69___rgc_posix(obj_t env_1068, obj_t s_1069)
{
return posix__rgc_86___rgc_posix(s_1069);
}


/* make-rgc-repeat */obj_t make_rgc_repeat_123___rgc_posix(obj_t min_3, obj_t max_4, obj_t rgc_5)
{
{
bool_t test_1109;
{
bool_t test_1110;
{
obj_t aux_1111;
aux_1111 = BINT(((long)0));
test_1110 = (min_3==aux_1111);
}
if(test_1110){
if(CBOOL(max_4)){
test_1109 = ((bool_t)0);
}
 else {
test_1109 = ((bool_t)1);
}
}
 else {
test_1109 = ((bool_t)0);
}
}
if(test_1109){
{
obj_t arg1072_334;
arg1072_334 = symbol1392___rgc_posix;
{
obj_t list1074_336;
{
obj_t arg1076_337;
arg1076_337 = MAKE_PAIR(BNIL, BNIL);
list1074_336 = MAKE_PAIR(rgc_5, arg1076_337);
}
return cons__138___r4_pairs_and_lists_6_3(arg1072_334, list1074_336);
}
}
}
 else {
bool_t test_1119;
{
bool_t test_1120;
{
obj_t aux_1121;
aux_1121 = BINT(((long)1));
test_1120 = (min_3==aux_1121);
}
if(test_1120){
if(CBOOL(max_4)){
test_1119 = ((bool_t)0);
}
 else {
test_1119 = ((bool_t)1);
}
}
 else {
test_1119 = ((bool_t)0);
}
}
if(test_1119){
{
obj_t arg1079_340;
arg1079_340 = symbol1393___rgc_posix;
{
obj_t list1081_342;
{
obj_t arg1082_343;
arg1082_343 = MAKE_PAIR(BNIL, BNIL);
list1081_342 = MAKE_PAIR(rgc_5, arg1082_343);
}
return cons__138___r4_pairs_and_lists_6_3(arg1079_340, list1081_342);
}
}
}
 else {
bool_t test_1129;
{
bool_t test_1130;
{
obj_t aux_1131;
aux_1131 = BINT(((long)0));
test_1130 = (min_3==aux_1131);
}
if(test_1130){
obj_t aux_1134;
aux_1134 = BINT(((long)1));
test_1129 = (max_4==aux_1134);
}
 else {
test_1129 = ((bool_t)0);
}
}
if(test_1129){
{
obj_t arg1085_346;
arg1085_346 = symbol1394___rgc_posix;
{
obj_t list1087_348;
{
obj_t arg1088_349;
arg1088_349 = MAKE_PAIR(BNIL, BNIL);
list1087_348 = MAKE_PAIR(rgc_5, arg1088_349);
}
return cons__138___r4_pairs_and_lists_6_3(arg1085_346, list1087_348);
}
}
}
 else {
if(CBOOL(max_4)){
{
obj_t arg1090_351;
arg1090_351 = symbol1395___rgc_posix;
{
obj_t list1092_353;
{
obj_t arg1093_354;
{
obj_t arg1094_355;
{
obj_t arg1095_356;
arg1095_356 = MAKE_PAIR(BNIL, BNIL);
arg1094_355 = MAKE_PAIR(rgc_5, arg1095_356);
}
arg1093_354 = MAKE_PAIR(max_4, arg1094_355);
}
list1092_353 = MAKE_PAIR(min_3, arg1093_354);
}
return cons__138___r4_pairs_and_lists_6_3(arg1090_351, list1092_353);
}
}
}
 else {
{
obj_t arg1097_358;
arg1097_358 = symbol1396___rgc_posix;
{
obj_t list1099_360;
{
obj_t arg1100_361;
{
obj_t arg1101_362;
arg1101_362 = MAKE_PAIR(BNIL, BNIL);
arg1100_361 = MAKE_PAIR(rgc_5, arg1101_362);
}
list1099_360 = MAKE_PAIR(min_3, arg1100_361);
}
return cons__138___r4_pairs_and_lists_6_3(arg1097_358, list1099_360);
}
}
}
}
}
}
}
}


/* make-rgc-or */obj_t make_rgc_or_156___rgc_posix(obj_t rgcs_6)
{
if(NULLP(rgcs_6)){
{
obj_t object_761;
object_761 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1397___rgc_posix,object_761);}
}
 else {
bool_t test_1154;
{
obj_t aux_1155;
aux_1155 = CDR(rgcs_6);
test_1154 = NULLP(aux_1155);
}
if(test_1154){
return CAR(rgcs_6);
}
 else {
{
obj_t arg1108_369;
obj_t arg1109_370;
arg1108_369 = symbol1398___rgc_posix;
{
obj_t arg1112_373;
arg1112_373 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1109_370 = append_2_18___r4_pairs_and_lists_6_3(rgcs_6, arg1112_373);
}
{
obj_t list1110_371;
list1110_371 = MAKE_PAIR(arg1109_370, BNIL);
return cons__138___r4_pairs_and_lists_6_3(arg1108_369, list1110_371);
}
}
}
}
}


/* make-rgc-sequence */obj_t make_rgc_sequence_72___rgc_posix(obj_t rgcs_7)
{
if(NULLP(rgcs_7)){
{
obj_t object_769;
object_769 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1397___rgc_posix,object_769);}
}
 else {
bool_t test_1166;
{
obj_t aux_1167;
aux_1167 = CDR(rgcs_7);
test_1166 = NULLP(aux_1167);
}
if(test_1166){
return CAR(rgcs_7);
}
 else {
{
obj_t arg1118_379;
obj_t arg1119_380;
arg1118_379 = symbol1399___rgc_posix;
{
obj_t arg1122_383;
arg1122_383 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1119_380 = append_2_18___r4_pairs_and_lists_6_3(rgcs_7, arg1122_383);
}
{
obj_t list1120_381;
list1120_381 = MAKE_PAIR(arg1119_380, BNIL);
return cons__138___r4_pairs_and_lists_6_3(arg1118_379, list1120_381);
}
}
}
}
}


/* parse-posix-exp */obj_t parse_posix_exp_254___rgc_posix(obj_t s_8, long i_9)
{
{
long len_387;
len_387 = STRING_LENGTH(s_8);
if((i_9<len_387)){
long i_389;
obj_t branches_390;
i_389 = i_9;
branches_390 = BNIL;
loop_391:
{
obj_t branch_393;
branch_393 = parse_posix_branch_174___rgc_posix(s_8, i_389);
{
obj_t i_394;
i_394 = _res1__155___r5_control_features_6_4;
{
obj_t branches_395;
branches_395 = MAKE_PAIR(branch_393, branches_390);
{
bool_t test_1180;
{
bool_t test_1181;
{
long aux_1182;
aux_1182 = (long)CINT(i_394);
test_1181 = (aux_1182<len_387);
}
if(test_1181){
unsigned char aux_1185;
{
long aux_1186;
aux_1186 = (long)CINT(i_394);
aux_1185 = STRING_REF(s_8, aux_1186);
}
test_1180 = (((unsigned char)'|')==aux_1185);
}
 else {
test_1180 = ((bool_t)0);
}
}
if(test_1180){
obj_t branches_1194;
long i_1190;
{
long aux_1191;
aux_1191 = (long)CINT(i_394);
i_1190 = (aux_1191+((long)1));
}
branches_1194 = branches_395;
branches_390 = branches_1194;
i_389 = i_1190;
goto loop_391;
}
 else {
obj_t val0_1002_398;
val0_1002_398 = make_rgc_or_156___rgc_posix(reverse___r4_pairs_and_lists_6_3(branches_395));
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_394;
return val0_1002_398;
}
}
}
}
}
}
 else {
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(i_9);
return BNIL;
}
}
}


/* parse-posix-branch */obj_t parse_posix_branch_174___rgc_posix(obj_t s_10, long i_11)
{
{
long len_405;
len_405 = STRING_LENGTH(s_10);
{
obj_t i_406;
obj_t pieces_407;
i_406 = BINT(i_11);
pieces_407 = BNIL;
loop_408:
{
bool_t test_1201;
{
long aux_1202;
aux_1202 = (long)CINT(i_406);
test_1201 = (aux_1202<len_405);
}
if(test_1201){
obj_t piece_411;
piece_411 = parse_posix_piece_52___rgc_posix(s_10, i_406);
{
obj_t i_412;
i_412 = _res1__155___r5_control_features_6_4;
{
obj_t pieces_413;
pieces_413 = MAKE_PAIR(piece_411, pieces_407);
{
bool_t test_1207;
{
long aux_1208;
aux_1208 = (long)CINT(i_412);
test_1207 = (aux_1208<len_405);
}
if(test_1207){
unsigned char aux_1216;
{
long aux_1217;
aux_1217 = (long)CINT(i_412);
aux_1216 = STRING_REF(s_10, aux_1217);
}
switch (aux_1216){
case ((unsigned char)')') : 
case ((unsigned char)'|') : 
{
obj_t val0_1008_418;
val0_1008_418 = make_rgc_sequence_72___rgc_posix(reverse___r4_pairs_and_lists_6_3(pieces_413));
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_412;
return val0_1008_418;
}
break;
default: 
{
obj_t pieces_1215;
obj_t i_1214;
i_1214 = i_412;
pieces_1215 = pieces_413;
pieces_407 = pieces_1215;
i_406 = i_1214;
goto loop_408;
}
}
}
 else {
obj_t val0_1010_421;
val0_1010_421 = make_rgc_sequence_72___rgc_posix(reverse___r4_pairs_and_lists_6_3(pieces_413));
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_412;
return val0_1010_421;
}
}
}
}
}
 else {
obj_t val0_1012_424;
val0_1012_424 = make_rgc_sequence_72___rgc_posix(reverse___r4_pairs_and_lists_6_3(pieces_407));
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_406;
return val0_1012_424;
}
}
}
}
}


/* parse-posix-piece */obj_t parse_posix_piece_52___rgc_posix(obj_t s_12, obj_t i_13)
{
{
long len_427;
len_427 = STRING_LENGTH(s_12);
{
obj_t atom_428;
atom_428 = parse_posix_atom_99___rgc_posix(s_12, i_13);
{
obj_t i_429;
i_429 = _res1__155___r5_control_features_6_4;
{
bool_t test_1229;
{
long aux_1230;
aux_1230 = (long)CINT(i_429);
test_1229 = (aux_1230<len_427);
}
if(test_1229){
{
unsigned char aux1017_432;
{
long aux_1233;
aux_1233 = (long)CINT(i_429);
aux1017_432 = STRING_REF(s_12, aux_1233);
}
switch (aux1017_432){
case ((unsigned char)'*') : 
case ((unsigned char)'+') : 
case ((unsigned char)'?') : 
{
obj_t from_434;
switch (aux1017_432){
case ((unsigned char)'*') : 
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BFALSE;
from_434 = BINT(((long)0));
break;
case ((unsigned char)'+') : 
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BFALSE;
from_434 = BINT(((long)1));
break;
case ((unsigned char)'?') : 
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(((long)1));
from_434 = BINT(((long)0));
break;
default: 
from_434 = BFALSE;
}
{
obj_t to_435;
to_435 = _res1__155___r5_control_features_6_4;
{
obj_t val0_1026_436;
long val1_1027_437;
val0_1026_436 = make_rgc_repeat_123___rgc_posix(from_434, to_435, atom_428);
{
long aux_1245;
aux_1245 = (long)CINT(i_429);
val1_1027_437 = (aux_1245+((long)1));
}
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(val1_1027_437);
return val0_1026_436;
}
}
}
break;
case ((unsigned char)'{') : 
{
obj_t from_447;
from_447 = parse_posix_braces_195___rgc_posix(s_12, _2__168___r4_numbers_6_5(i_429, BINT(((long)1))));
{
obj_t to_448;
obj_t i_449;
to_448 = _res1__155___r5_control_features_6_4;
i_449 = _res2__167___r5_control_features_6_4;
{
obj_t val0_1028_450;
val0_1028_450 = make_rgc_repeat_123___rgc_posix(from_447, to_448, atom_428);
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_449;
return val0_1028_450;
}
}
}
break;
default: 
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_429;
return atom_428;
}
}
}
 else {
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_429;
return atom_428;
}
}
}
}
}
}


/* parse-posix-atom */obj_t parse_posix_atom_99___rgc_posix(obj_t s_14, obj_t i_15)
{
{
long len_457;
len_457 = STRING_LENGTH(s_14);
{
bool_t test_1259;
{
long aux_1260;
aux_1260 = (long)CINT(i_15);
test_1259 = (aux_1260<len_457);
}
if(test_1259){
unsigned char c_459;
{
long aux_1263;
aux_1263 = (long)CINT(i_15);
c_459 = STRING_REF(s_14, aux_1263);
}
{
switch (c_459){
case ((unsigned char)'^') : 
{
obj_t object_813;
object_813 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1400___rgc_posix,object_813);}
break;
case ((unsigned char)'$') : 
{
obj_t object_817;
object_817 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1401___rgc_posix,object_817);}
break;
case ((unsigned char)'.') : 
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
{
long aux_1269;
{
long aux_1270;
aux_1270 = (long)CINT(i_15);
aux_1269 = (aux_1270+((long)1));
}
_res1__155___r5_control_features_6_4 = BINT(aux_1269);
}
return symbol1402___rgc_posix;
break;
case ((unsigned char)'[') : 
{
long aux_1274;
{
long aux_1275;
aux_1275 = (long)CINT(i_15);
aux_1274 = (aux_1275+((long)1));
}
return parse_posix_bracket_232___rgc_posix(s_14, aux_1274);
}
break;
case ((unsigned char)'(') : 
{
obj_t re_466;
{
long aux_1279;
{
long aux_1280;
aux_1280 = (long)CINT(i_15);
aux_1279 = (aux_1280+((long)1));
}
re_466 = parse_posix_exp_254___rgc_posix(s_14, aux_1279);
}
{
obj_t i_467;
i_467 = _res1__155___r5_control_features_6_4;
{
bool_t test_1284;
{
bool_t test_1285;
{
long aux_1286;
aux_1286 = (long)CINT(i_467);
test_1285 = (aux_1286<len_457);
}
if(test_1285){
unsigned char aux_1289;
{
long aux_1290;
aux_1290 = (long)CINT(i_467);
aux_1289 = STRING_REF(s_14, aux_1290);
}
test_1284 = (((unsigned char)')')==aux_1289);
}
 else {
test_1284 = ((bool_t)0);
}
}
if(test_1284){
obj_t val0_1038_469;
long val1_1039_470;
{
obj_t arg1150_471;
arg1150_471 = symbol1403___rgc_posix;
{
obj_t list1152_473;
{
obj_t arg1153_474;
arg1153_474 = MAKE_PAIR(BNIL, BNIL);
list1152_473 = MAKE_PAIR(re_466, arg1153_474);
}
val0_1038_469 = cons__138___r4_pairs_and_lists_6_3(arg1150_471, list1152_473);
}
}
{
long aux_1297;
aux_1297 = (long)CINT(i_467);
val1_1039_470 = (aux_1297+((long)1));
}
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(val1_1039_470);
return val0_1038_469;
}
 else {
obj_t object_835;
object_835 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1404___rgc_posix,object_835);}
}
}
}
break;
case ((unsigned char)'\\') : 
{
long i_479;
{
long aux_1303;
aux_1303 = (long)CINT(i_15);
i_479 = (aux_1303+((long)1));
}
if((i_479<len_457)){
obj_t val0_1040_481;
long val1_1041_482;
{
obj_t list1161_484;
{
obj_t aux_1308;
{
unsigned char aux_1309;
aux_1309 = STRING_REF(s_14, i_479);
aux_1308 = BCHAR(aux_1309);
}
list1161_484 = MAKE_PAIR(aux_1308, BNIL);
}
val0_1040_481 = list__string_78___r4_strings_6_7(list1161_484);
}
val1_1041_482 = (i_479+((long)1));
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(val1_1041_482);
return val0_1040_481;
}
 else {
obj_t object_848;
object_848 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1405___rgc_posix,object_848);}
}
break;
case ((unsigned char)')') : 
case ((unsigned char)'|') : 
case ((unsigned char)'*') : 
case ((unsigned char)'+') : 
case ((unsigned char)'?') : 
case ((unsigned char)'{') : 
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_15;
return BNIL;
break;
default: 
{
obj_t val0_1032_488;
long val1_1033_489;
{
obj_t list1163_490;
{
obj_t aux_1319;
aux_1319 = BCHAR(c_459);
list1163_490 = MAKE_PAIR(aux_1319, BNIL);
}
val0_1032_488 = list__string_78___r4_strings_6_7(list1163_490);
}
{
long aux_1323;
aux_1323 = (long)CINT(i_15);
val1_1033_489 = (aux_1323+((long)1));
}
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(val1_1033_489);
return val0_1032_488;
}
}
}
}
 else {
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = i_15;
return BNIL;
}
}
}
}


/* parse-posix-bracket */obj_t parse_posix_bracket_232___rgc_posix(obj_t s_16, long i_17)
{
{
long len_495;
len_495 = STRING_LENGTH(s_16);
if((i_17<len_495)){
bool_t negate__237_497;
{
bool_t test_1333;
{
unsigned char aux_1334;
aux_1334 = STRING_REF(s_16, i_17);
test_1333 = (aux_1334==((unsigned char)'^'));
}
if(test_1333){
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
{
long aux_1338;
aux_1338 = (i_17+((long)1));
_res1__155___r5_control_features_6_4 = BINT(aux_1338);
}
negate__237_497 = ((bool_t)1);
}
 else {
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(i_17);
negate__237_497 = ((bool_t)0);
}
}
{
obj_t i0_498;
i0_498 = _res1__155___r5_control_features_6_4;
{
obj_t i_499;
obj_t cset_500;
i_499 = i0_498;
cset_500 = BNIL;
loop_501:
{
bool_t test_1343;
{
long aux_1344;
aux_1344 = (long)CINT(i_499);
test_1343 = (aux_1344<len_495);
}
if(test_1343){
unsigned char c_504;
{
long aux_1347;
aux_1347 = (long)CINT(i_499);
c_504 = STRING_REF(s_16, aux_1347);
}
{
switch (c_504){
case ((unsigned char)'[') : 
{
long i1_508;
{
long aux_1350;
aux_1350 = (long)CINT(i_499);
i1_508 = (aux_1350+((long)1));
}
{
bool_t test_1353;
if((i1_508<len_495)){
obj_t aux_1356;
{
obj_t aux_1357;
{
unsigned char aux_1358;
aux_1358 = STRING_REF(s_16, i1_508);
aux_1357 = BCHAR(aux_1358);
}
aux_1356 = memq___r4_pairs_and_lists_6_3(aux_1357, list1406___rgc_posix);
}
test_1353 = CBOOL(aux_1356);
}
 else {
test_1353 = ((bool_t)0);
}
if(test_1353){
{
obj_t object_874;
object_874 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1407___rgc_posix,object_874);}
}
 else {
{
obj_t arg1171_510;
{
obj_t aux_1364;
aux_1364 = BCHAR(((unsigned char)'['));
arg1171_510 = MAKE_PAIR(aux_1364, cset_500);
}
{
obj_t cset_1369;
obj_t i_1367;
i_1367 = BINT(i1_508);
cset_1369 = arg1171_510;
cset_500 = cset_1369;
i_499 = i_1367;
goto loop_501;
}
}
}
}
}
break;
case ((unsigned char)']') : 
{
bool_t test_1370;
{
long aux_1373;
long aux_1371;
aux_1373 = (long)CINT(i0_498);
aux_1371 = (long)CINT(i_499);
test_1370 = (aux_1371==aux_1373);
}
if(test_1370){
{
long arg1176_515;
obj_t arg1177_516;
{
long aux_1376;
aux_1376 = (long)CINT(i_499);
arg1176_515 = (aux_1376+((long)1));
}
{
obj_t aux_1379;
aux_1379 = BCHAR(((unsigned char)']'));
arg1177_516 = MAKE_PAIR(aux_1379, cset_500);
}
{
obj_t cset_1384;
obj_t i_1382;
i_1382 = BINT(arg1176_515);
cset_1384 = arg1177_516;
cset_500 = cset_1384;
i_499 = i_1382;
goto loop_501;
}
}
}
 else {
if(negate__237_497){
obj_t val0_1052_517;
long val1_1053_518;
{
obj_t arg1178_519;
obj_t arg1179_520;
arg1178_519 = symbol1408___rgc_posix;
{
obj_t arg1182_523;
arg1182_523 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1179_520 = append_2_18___r4_pairs_and_lists_6_3(cset_500, arg1182_523);
}
{
obj_t list1180_521;
list1180_521 = MAKE_PAIR(arg1179_520, BNIL);
val0_1052_517 = cons__138___r4_pairs_and_lists_6_3(arg1178_519, list1180_521);
}
}
{
long aux_1390;
aux_1390 = (long)CINT(i_499);
val1_1053_518 = (aux_1390+((long)1));
}
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(val1_1053_518);
return val0_1052_517;
}
 else {
obj_t val0_1054_526;
long val1_1055_527;
{
obj_t arg1185_528;
obj_t arg1186_529;
arg1185_528 = symbol1409___rgc_posix;
{
obj_t arg1189_532;
arg1189_532 = cons__138___r4_pairs_and_lists_6_3(BNIL, BNIL);
arg1186_529 = append_2_18___r4_pairs_and_lists_6_3(cset_500, arg1189_532);
}
{
obj_t list1187_530;
list1187_530 = MAKE_PAIR(arg1186_529, BNIL);
val0_1054_526 = cons__138___r4_pairs_and_lists_6_3(arg1185_528, list1187_530);
}
}
{
long aux_1399;
aux_1399 = (long)CINT(i_499);
val1_1055_527 = (aux_1399+((long)1));
}
_res_number__75___r5_control_features_6_4 = BINT(((long)2));
_res1__155___r5_control_features_6_4 = BINT(val1_1055_527);
return val0_1054_526;
}
}
}
break;
case ((unsigned char)'-') : 
{
bool_t test_1404;
{
bool_t test_1405;
{
long aux_1408;
long aux_1406;
aux_1408 = (long)CINT(i0_498);
aux_1406 = (long)CINT(i_499);
test_1405 = (aux_1406==aux_1408);
}
if(test_1405){
test_1404 = ((bool_t)1);
}
 else {
bool_t test_1411;
{
long aux_1412;
{
long aux_1413;
aux_1413 = (long)CINT(i_499);
aux_1412 = (aux_1413+((long)1));
}
test_1411 = (aux_1412<len_495);
}
if(test_1411){
unsigned char aux_1417;
{
long aux_1418;
{
long aux_1419;
aux_1419 = (long)CINT(i_499);
aux_1418 = (aux_1419+((long)1));
}
aux_1417 = STRING_REF(s_16, aux_1418);
}
test_1404 = (((unsigned char)']')==aux_1417);
}
 else {
test_1404 = ((bool_t)0);
}
}
}
if(test_1404){
{
long arg1193_536;
obj_t arg1194_537;
{
long aux_1424;
aux_1424 = (long)CINT(i_499);
arg1193_536 = (aux_1424+((long)1));
}
{
obj_t aux_1427;
aux_1427 = BCHAR(((unsigned char)'-'));
arg1194_537 = MAKE_PAIR(aux_1427, cset_500);
}
{
obj_t cset_1432;
obj_t i_1430;
i_1430 = BINT(arg1193_536);
cset_1432 = arg1194_537;
cset_500 = cset_1432;
i_499 = i_1430;
goto loop_501;
}
}
}
 else {
{
obj_t object_906;
object_906 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1410___rgc_posix,object_906);}
}
}
break;
default: 
{
long i_543;
{
long aux_1434;
aux_1434 = (long)CINT(i_499);
i_543 = (aux_1434+((long)1));
}
{
bool_t test_1437;
{
bool_t test_1438;
{
long aux_1439;
aux_1439 = (i_543+((long)1));
test_1438 = (aux_1439<len_495);
}
if(test_1438){
unsigned char aux_1442;
aux_1442 = STRING_REF(s_16, i_543);
test_1437 = (((unsigned char)'-')==aux_1442);
}
 else {
test_1437 = ((bool_t)0);
}
}
if(test_1437){
long i_545;
i_545 = (i_543+((long)1));
{
long to_546;
{
unsigned char aux_1446;
aux_1446 = STRING_REF(s_16, i_545);
to_546 = (aux_1446);
}
{
{
long j_924;
obj_t cset_925;
j_924 = (c_504);
cset_925 = cset_500;
laap_923:
if((j_924>to_546)){
obj_t cset_1455;
obj_t i_1451;
{
long aux_1452;
aux_1452 = (i_545+((long)1));
i_1451 = BINT(aux_1452);
}
cset_1455 = cset_925;
cset_500 = cset_1455;
i_499 = i_1451;
goto loop_501;
}
 else {
long arg1204_933;
obj_t arg1205_934;
arg1204_933 = (j_924+((long)1));
{
obj_t aux_1457;
{
unsigned char aux_1458;
aux_1458 = (j_924);
aux_1457 = BCHAR(aux_1458);
}
arg1205_934 = MAKE_PAIR(aux_1457, cset_925);
}
{
obj_t cset_1463;
long j_1462;
j_1462 = arg1204_933;
cset_1463 = arg1205_934;
cset_925 = cset_1463;
j_924 = j_1462;
goto laap_923;
}
}
}
}
}
}
 else {
obj_t arg1209_557;
{
obj_t aux_1465;
aux_1465 = BCHAR(c_504);
arg1209_557 = MAKE_PAIR(aux_1465, cset_500);
}
{
obj_t cset_1470;
obj_t i_1468;
i_1468 = BINT(i_543);
cset_1470 = arg1209_557;
cset_500 = cset_1470;
i_499 = i_1468;
goto loop_501;
}
}
}
}
}
}
}
 else {
obj_t object_980;
object_980 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1411___rgc_posix,object_980);}
}
}
}
}
 else {
obj_t object_984;
object_984 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1411___rgc_posix,object_984);}
}
}


/* parse-posix-braces */obj_t parse_posix_braces_195___rgc_posix(obj_t s_18, obj_t i_19)
{
{
obj_t comma_568;
obj_t rb_569;
{
long len_988;
len_988 = STRING_LENGTH(s_18);
{
obj_t offset_990;
offset_990 = i_19;
loop_989:
{
bool_t test_1475;
{
long aux_1476;
aux_1476 = (long)CINT(offset_990);
test_1475 = (aux_1476>=len_988);
}
if(test_1475){
comma_568 = BFALSE;
}
 else {
bool_t test_1479;
{
unsigned char aux_1480;
{
long aux_1481;
aux_1481 = (long)CINT(offset_990);
aux_1480 = STRING_REF(s_18, aux_1481);
}
test_1479 = (aux_1480==((unsigned char)','));
}
if(test_1479){
comma_568 = offset_990;
}
 else {
{
obj_t offset_1485;
{
long aux_1486;
{
long aux_1487;
aux_1487 = (long)CINT(offset_990);
aux_1486 = (aux_1487+((long)1));
}
offset_1485 = BINT(aux_1486);
}
offset_990 = offset_1485;
goto loop_989;
}
}
}
}
}
}
{
long len_1007;
len_1007 = STRING_LENGTH(s_18);
{
obj_t offset_1009;
offset_1009 = i_19;
loop_1008:
{
bool_t test_1492;
{
long aux_1493;
aux_1493 = (long)CINT(offset_1009);
test_1492 = (aux_1493>=len_1007);
}
if(test_1492){
rb_569 = BFALSE;
}
 else {
bool_t test_1496;
{
unsigned char aux_1497;
{
long aux_1498;
aux_1498 = (long)CINT(offset_1009);
aux_1497 = STRING_REF(s_18, aux_1498);
}
test_1496 = (aux_1497==((unsigned char)'}'));
}
if(test_1496){
rb_569 = offset_1009;
}
 else {
{
obj_t offset_1502;
{
long aux_1503;
{
long aux_1504;
aux_1504 = (long)CINT(offset_1009);
aux_1503 = (aux_1504+((long)1));
}
offset_1502 = BINT(aux_1503);
}
offset_1009 = offset_1502;
goto loop_1008;
}
}
}
}
}
}
if(CBOOL(rb_569)){
bool_t test_1510;
if(CBOOL(comma_568)){
long aux_1515;
long aux_1513;
aux_1515 = (long)CINT(rb_569);
aux_1513 = (long)CINT(comma_568);
test_1510 = (aux_1513<aux_1515);
}
 else {
test_1510 = ((bool_t)0);
}
if(test_1510){
obj_t val0_1057_571;
obj_t val1_1058_572;
long val2_1059_573;
{
obj_t arg1216_574;
{
long aux_1520;
long aux_1518;
aux_1520 = (long)CINT(comma_568);
aux_1518 = (long)CINT(i_19);
arg1216_574 = c_substring(s_18, aux_1518, aux_1520);
}
val0_1057_571 = string__number_104___r4_numbers_6_5(arg1216_574, BNIL);
}
{
bool_t test_1524;
{
bool_t test_1525;
{
long aux_1530;
long aux_1526;
aux_1530 = (long)CINT(rb_569);
{
long aux_1527;
aux_1527 = (long)CINT(comma_568);
aux_1526 = (aux_1527+((long)1));
}
test_1525 = (aux_1526==aux_1530);
}
if(test_1525){
test_1524 = ((bool_t)0);
}
 else {
test_1524 = ((bool_t)1);
}
}
if(test_1524){
obj_t arg1219_577;
{
long aux_1537;
long aux_1533;
aux_1537 = (long)CINT(rb_569);
{
long aux_1534;
aux_1534 = (long)CINT(comma_568);
aux_1533 = (aux_1534+((long)1));
}
arg1219_577 = c_substring(s_18, aux_1533, aux_1537);
}
val1_1058_572 = string__number_104___r4_numbers_6_5(arg1219_577, BNIL);
}
 else {
val1_1058_572 = BFALSE;
}
}
{
long aux_1541;
aux_1541 = (long)CINT(rb_569);
val2_1059_573 = (aux_1541+((long)1));
}
_res_number__75___r5_control_features_6_4 = BINT(((long)3));
_res1__155___r5_control_features_6_4 = val1_1058_572;
_res2__167___r5_control_features_6_4 = BINT(val2_1059_573);
return val0_1057_571;
}
 else {
obj_t m_582;
{
obj_t arg1225_586;
{
long aux_1548;
long aux_1546;
aux_1548 = (long)CINT(rb_569);
aux_1546 = (long)CINT(i_19);
arg1225_586 = c_substring(s_18, aux_1546, aux_1548);
}
m_582 = string__number_104___r4_numbers_6_5(arg1225_586, BNIL);
}
_res_number__75___r5_control_features_6_4 = BINT(((long)3));
_res1__155___r5_control_features_6_4 = m_582;
{
long aux_1553;
{
long aux_1554;
aux_1554 = (long)CINT(rb_569);
aux_1553 = (aux_1554+((long)1));
}
_res2__167___r5_control_features_6_4 = BINT(aux_1553);
}
return m_582;
}
}
 else {
obj_t object_1047;
object_1047 = _err_string__201___rgc_posix;
FAILURE(BFALSE,string1412___rgc_posix,object_1047);}
}
}


/* imported-modules-init */obj_t imported_modules_init_94___rgc_posix()
{
return module_initialization_70___error(((long)0), "__RGC_POSIX");
}

