/*===========================================================================*/
/*   (Match/descr.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

extern obj_t isvector_end__41___match_descriptions(obj_t);
static obj_t loop_1821___match_descriptions(obj_t);
extern obj_t isnot__52___match_descriptions(obj_t);
extern obj_t pattern_plus_250___match_descriptions(obj_t, obj_t);
extern obj_t string_to_symbol(char *);
extern obj_t istagged_or__239___match_descriptions(obj_t);
static obj_t _ist_or__100___match_descriptions(obj_t, obj_t);
extern obj_t isacons__251___match_descriptions(obj_t);
static obj_t _isvector_end__197___match_descriptions(obj_t, obj_t);
extern obj_t isor__51___match_descriptions(obj_t);
static obj_t _compatible__139___match_descriptions(obj_t, obj_t, obj_t);
extern obj_t istimes__212___match_descriptions(obj_t);
static obj_t _issuccess__90___match_descriptions(obj_t, obj_t);
static obj_t compare___match_descriptions(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t _istop__15___match_descriptions(obj_t, obj_t);
extern obj_t pattern_cdr_48___match_descriptions(obj_t);
extern obj_t vector_plus_240___match_descriptions(obj_t, obj_t, obj_t);
extern obj_t pattern_car_218___match_descriptions(obj_t);
extern obj_t containshole__101___match_descriptions(obj_t);
extern obj_t vector__list_155___r4_vectors_6_8(obj_t);
static obj_t _isvector_begin__0___match_descriptions(obj_t, obj_t);
extern obj_t extend_vector_160___match_descriptions(obj_t, obj_t, obj_t);
static obj_t _containshole__39___match_descriptions(obj_t, obj_t);
static obj_t _isnot__30___match_descriptions(obj_t, obj_t);
static bool_t may_be_a_cons_83___match_descriptions(obj_t);
extern obj_t compatible__222___match_descriptions(obj_t, obj_t);
extern obj_t pattern_minus_154___match_descriptions(obj_t, obj_t);
static obj_t _extend_vector_251___match_descriptions(obj_t, obj_t, obj_t, obj_t);
static obj_t _ischeck__24___match_descriptions(obj_t, obj_t);
extern obj_t ist_or__144___match_descriptions(obj_t);
static obj_t lambda1460___match_descriptions(obj_t, obj_t);
static obj_t lambda1443___match_descriptions(obj_t, obj_t);
extern obj_t more_precise__220___match_descriptions(obj_t, obj_t);
static obj_t _pattern_minus_27___match_descriptions(obj_t, obj_t, obj_t);
static obj_t _istree__196___match_descriptions(obj_t, obj_t);
static obj_t _more_precise__183___match_descriptions(obj_t, obj_t, obj_t);
static obj_t _pattern_variables_154___match_descriptions(obj_t, obj_t);
extern obj_t ischeck__51___match_descriptions(obj_t);
static obj_t loop___match_descriptions(obj_t, obj_t, obj_t);
static obj_t rewrite_not_212___match_descriptions(obj_t);
extern obj_t issuccess__169___match_descriptions(obj_t);
static obj_t _iscons__14___match_descriptions(obj_t, obj_t);
static obj_t lambda1074___match_descriptions(obj_t, obj_t);
static obj_t arg1519___match_descriptions(obj_t, obj_t, obj_t);
static obj_t arg1516___match_descriptions(obj_t, obj_t, obj_t);
static obj_t arg1483___match_descriptions(obj_t, obj_t, obj_t);
extern obj_t memq___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern obj_t member___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t arg1481___match_descriptions(obj_t, obj_t);
static obj_t lambda1074_1819___match_descriptions(obj_t, obj_t);
static obj_t lambda1074_1820___match_descriptions(obj_t, obj_t);
static obj_t lambda1074_1818___match_descriptions(obj_t, obj_t);
static obj_t lambda1074_1817___match_descriptions(obj_t, obj_t);
extern obj_t pattern_variables_45___match_descriptions(obj_t);
static obj_t lambda1074_1816___match_descriptions(obj_t, obj_t);
static obj_t lambda1074_1815___match_descriptions(obj_t, obj_t);
static obj_t lambda1074_1814___match_descriptions(obj_t, obj_t);
static obj_t lambda1074_1813___match_descriptions(obj_t, obj_t);
static obj_t arg1449___match_descriptions(obj_t, obj_t);
static obj_t _vector_minus_241___match_descriptions(obj_t, obj_t, obj_t, obj_t);
static obj_t arg1396___match_descriptions(obj_t, obj_t);
static obj_t arg1403___match_descriptions(obj_t, obj_t);
static obj_t match___match_descriptions(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t arg1292___match_descriptions(obj_t, obj_t);
extern obj_t module_initialization_70___match_descriptions(long, char *);
extern obj_t module_initialization_70___match_s2cfun(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t arg1285___match_descriptions(obj_t, obj_t);
static obj_t arg1278___match_descriptions(obj_t, obj_t);
static obj_t arg1277___match_descriptions(obj_t, obj_t);
static obj_t arg1274___match_descriptions(obj_t, obj_t);
static obj_t _ishole__253___match_descriptions(obj_t, obj_t);
extern obj_t istree__46___match_descriptions(obj_t);
static obj_t _pattern_plus_115___match_descriptions(obj_t, obj_t, obj_t);
static obj_t _istagged_or__215___match_descriptions(obj_t, obj_t);
static obj_t _isvector__152___match_descriptions(obj_t, obj_t);
static obj_t union_3___match_descriptions(obj_t, obj_t);
extern obj_t isany__223___match_descriptions(obj_t);
extern obj_t jim_gensym_58___match_s2cfun;
extern obj_t iscons__156___match_descriptions(obj_t);
extern long list_length(obj_t);
static obj_t norm___match_descriptions(obj_t, obj_t);
extern obj_t isvector_begin__5___match_descriptions(obj_t);
static obj_t _isbottom__80___match_descriptions(obj_t, obj_t);
extern obj_t list__vector_101___r4_vectors_6_8(obj_t);
extern obj_t isvar__187___match_descriptions(obj_t);
static obj_t _isquote__33___match_descriptions(obj_t, obj_t);
static bool_t isnegation__119___match_descriptions(obj_t);
extern obj_t cons__138___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern obj_t isand__129___match_descriptions(obj_t);
static obj_t _isxcons__204___match_descriptions(obj_t, obj_t);
extern obj_t ishole__108___match_descriptions(obj_t);
static obj_t alpha_convert_60___match_descriptions(obj_t);
extern bool_t eqv__112___r4_equivalence_6_2(obj_t, obj_t);
static obj_t imported_modules_init_94___match_descriptions();
static obj_t symbol1859___match_descriptions = BUNSPEC;
static obj_t symbol1858___match_descriptions = BUNSPEC;
static obj_t symbol1855___match_descriptions = BUNSPEC;
static obj_t symbol1851___match_descriptions = BUNSPEC;
static obj_t symbol1849___match_descriptions = BUNSPEC;
static obj_t symbol1850___match_descriptions = BUNSPEC;
static obj_t symbol1845___match_descriptions = BUNSPEC;
extern bool_t equal__25___r4_equivalence_6_2(obj_t, obj_t);
static obj_t symbol1844___match_descriptions = BUNSPEC;
static obj_t symbol1842___match_descriptions = BUNSPEC;
static obj_t symbol1841___match_descriptions = BUNSPEC;
static obj_t symbol1839___match_descriptions = BUNSPEC;
static obj_t symbol1838___match_descriptions = BUNSPEC;
static obj_t symbol1837___match_descriptions = BUNSPEC;
static obj_t symbol1836___match_descriptions = BUNSPEC;
static obj_t symbol1835___match_descriptions = BUNSPEC;
static obj_t symbol1834___match_descriptions = BUNSPEC;
static obj_t symbol1833___match_descriptions = BUNSPEC;
static obj_t symbol1832___match_descriptions = BUNSPEC;
static obj_t symbol1831___match_descriptions = BUNSPEC;
static obj_t _isany__3___match_descriptions(obj_t, obj_t);
static obj_t symbol1829___match_descriptions = BUNSPEC;
static obj_t symbol1830___match_descriptions = BUNSPEC;
static obj_t symbol1827___match_descriptions = BUNSPEC;
static obj_t symbol1826___match_descriptions = BUNSPEC;
static obj_t symbol1824___match_descriptions = BUNSPEC;
static obj_t symbol1823___match_descriptions = BUNSPEC;
static obj_t symbol1822___match_descriptions = BUNSPEC;
static obj_t require_initialization_114___match_descriptions = BUNSPEC;
extern obj_t isquote__86___match_descriptions(obj_t);
extern obj_t isvector__54___match_descriptions(obj_t);
extern obj_t isxcons__163___match_descriptions(obj_t);
extern obj_t istop__3___match_descriptions(obj_t);
static obj_t _isacons__206___match_descriptions(obj_t, obj_t);
static obj_t list1853___match_descriptions = BUNSPEC;
static obj_t list1852___match_descriptions = BUNSPEC;
static obj_t list1843___match_descriptions = BUNSPEC;
static obj_t list1840___match_descriptions = BUNSPEC;
static obj_t list1828___match_descriptions = BUNSPEC;
static obj_t list1825___match_descriptions = BUNSPEC;
extern obj_t vector_minus_162___match_descriptions(obj_t, obj_t, obj_t);
static obj_t _isvar__142___match_descriptions(obj_t, obj_t);
static obj_t _istimes__40___match_descriptions(obj_t, obj_t);
static obj_t _pattern_cdr_121___match_descriptions(obj_t, obj_t);
static obj_t _vector_plus_248___match_descriptions(obj_t, obj_t, obj_t, obj_t);
static obj_t rewrite_and_150___match_descriptions(obj_t, obj_t);
static obj_t _pattern_car_27___match_descriptions(obj_t, obj_t);
static obj_t _isand__170___match_descriptions(obj_t, obj_t);
static obj_t cnst_init_137___match_descriptions();
static obj_t _isor__138___match_descriptions(obj_t, obj_t);
extern obj_t make_vector(long, obj_t);
extern obj_t isbottom__165___match_descriptions(obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( more_precise__env_155___match_descriptions, _more_precise__183___match_descriptions1861, _more_precise__183___match_descriptions, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( compatible__env_97___match_descriptions, _compatible__139___match_descriptions1862, _compatible__139___match_descriptions, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( istop__env_221___match_descriptions, _istop__15___match_descriptions1863, _istop__15___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isvector_end__env_66___match_descriptions, _isvector_end__197___match_descriptions1864, _isvector_end__197___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isacons__env_173___match_descriptions, _isacons__206___match_descriptions1865, _isacons__206___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isvector__env_19___match_descriptions, _isvector__152___match_descriptions1866, _isvector__152___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( pattern_minus_env_58___match_descriptions, _pattern_minus_27___match_descriptions1867, _pattern_minus_27___match_descriptions, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( isbottom__env_35___match_descriptions, _isbottom__80___match_descriptions1868, _isbottom__80___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_minus_env_197___match_descriptions, _vector_minus_241___match_descriptions1869, _vector_minus_241___match_descriptions, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( ist_or__env_243___match_descriptions, _ist_or__100___match_descriptions1870, _ist_or__100___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( extend_vector_env_157___match_descriptions, _extend_vector_251___match_descriptions1871, _extend_vector_251___match_descriptions, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( isany__env_126___match_descriptions, _isany__3___match_descriptions1872, _isany__3___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isnot__env_59___match_descriptions, _isnot__30___match_descriptions1873, _isnot__30___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( pattern_plus_env_150___match_descriptions, _pattern_plus_115___match_descriptions1874, _pattern_plus_115___match_descriptions, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( issuccess__env_182___match_descriptions, _issuccess__90___match_descriptions1875, _issuccess__90___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( pattern_car_env_12___match_descriptions, _pattern_car_27___match_descriptions1876, _pattern_car_27___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isvar__env_151___match_descriptions, _isvar__142___match_descriptions1877, _isvar__142___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isxcons__env_255___match_descriptions, _isxcons__204___match_descriptions1878, _isxcons__204___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isvector_begin__env_185___match_descriptions, _isvector_begin__0___match_descriptions1879, _isvector_begin__0___match_descriptions, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1857___match_descriptions, arg1481___match_descriptions1880, arg1481___match_descriptions, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1856___match_descriptions, arg1483___match_descriptions1881, arg1483___match_descriptions, 0L, 2 );
DEFINE_STATIC_PROCEDURE( proc1848___match_descriptions, arg1274___match_descriptions1882, arg1274___match_descriptions, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1847___match_descriptions, arg1277___match_descriptions1883, arg1277___match_descriptions, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1846___match_descriptions, arg1278___match_descriptions1884, arg1278___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( iscons__env_108___match_descriptions, _iscons__14___match_descriptions1885, _iscons__14___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isor__env_181___match_descriptions, _isor__138___match_descriptions1886, _isor__138___match_descriptions, 0L, 1 );
DEFINE_STRING( string1854___match_descriptions, string1854___match_descriptions1887, "VAR-", 4 );
DEFINE_EXPORT_PROCEDURE( istagged_or__env_251___match_descriptions, _istagged_or__215___match_descriptions1888, _istagged_or__215___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( containshole__env_25___match_descriptions, _containshole__39___match_descriptions1889, _containshole__39___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ishole__env_26___match_descriptions, _ishole__253___match_descriptions1890, _ishole__253___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ischeck__env_181___match_descriptions, _ischeck__24___match_descriptions1891, _ischeck__24___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isand__env_10___match_descriptions, _isand__170___match_descriptions1892, _isand__170___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( pattern_cdr_env_164___match_descriptions, _pattern_cdr_121___match_descriptions1893, _pattern_cdr_121___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_plus_env_95___match_descriptions, _vector_plus_248___match_descriptions1894, _vector_plus_248___match_descriptions, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( pattern_variables_env_125___match_descriptions, _pattern_variables_154___match_descriptions1895, _pattern_variables_154___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( isquote__env_138___match_descriptions, _isquote__33___match_descriptions1896, _isquote__33___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( istimes__env_145___match_descriptions, _istimes__40___match_descriptions1897, _istimes__40___match_descriptions, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( istree__env_28___match_descriptions, _istree__196___match_descriptions1898, _istree__196___match_descriptions, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___match_descriptions(long checksum_2658, char * from_2659)
{
if(CBOOL(require_initialization_114___match_descriptions)){
require_initialization_114___match_descriptions = BBOOL(((bool_t)0));
cnst_init_137___match_descriptions();
imported_modules_init_94___match_descriptions();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___match_descriptions()
{
symbol1822___match_descriptions = string_to_symbol("OR");
symbol1823___match_descriptions = string_to_symbol("T-OR");
symbol1824___match_descriptions = string_to_symbol("AND");
symbol1826___match_descriptions = string_to_symbol("CONS");
symbol1827___match_descriptions = string_to_symbol("VECTOR-CONS");
{
obj_t aux_2670;
aux_2670 = MAKE_PAIR(symbol1827___match_descriptions, BNIL);
list1825___match_descriptions = MAKE_PAIR(symbol1826___match_descriptions, aux_2670);
}
symbol1829___match_descriptions = string_to_symbol("TREE");
symbol1830___match_descriptions = string_to_symbol("TIMES");
{
obj_t aux_2675;
aux_2675 = MAKE_PAIR(symbol1830___match_descriptions, BNIL);
list1828___match_descriptions = MAKE_PAIR(symbol1829___match_descriptions, aux_2675);
}
symbol1831___match_descriptions = string_to_symbol("VAR");
symbol1832___match_descriptions = string_to_symbol("VECTOR-BEGIN");
symbol1833___match_descriptions = string_to_symbol("VECTOR-END");
symbol1834___match_descriptions = string_to_symbol("STRUCT-PAT");
symbol1835___match_descriptions = string_to_symbol("ANY");
symbol1836___match_descriptions = string_to_symbol("CHECK");
symbol1837___match_descriptions = string_to_symbol("FOO");
symbol1838___match_descriptions = string_to_symbol("BOTTOM");
symbol1839___match_descriptions = string_to_symbol("NOT");
list1840___match_descriptions = MAKE_PAIR(symbol1835___match_descriptions, BNIL);
symbol1841___match_descriptions = string_to_symbol("SUCCESS");
symbol1842___match_descriptions = string_to_symbol("QUOTE");
symbol1844___match_descriptions = string_to_symbol("ACONS");
symbol1845___match_descriptions = string_to_symbol("XCONS");
{
obj_t aux_2692;
{
obj_t aux_2693;
aux_2693 = MAKE_PAIR(symbol1845___match_descriptions, BNIL);
aux_2692 = MAKE_PAIR(symbol1844___match_descriptions, aux_2693);
}
list1843___match_descriptions = MAKE_PAIR(symbol1826___match_descriptions, aux_2692);
}
symbol1849___match_descriptions = string_to_symbol("UNBOUND");
symbol1850___match_descriptions = string_to_symbol("TAGGED-OR");
symbol1851___match_descriptions = string_to_symbol("VECTOR");
{
obj_t aux_2700;
{
obj_t aux_2701;
aux_2701 = MAKE_PAIR(list1840___match_descriptions, BNIL);
aux_2700 = MAKE_PAIR(list1840___match_descriptions, aux_2701);
}
list1853___match_descriptions = MAKE_PAIR(symbol1826___match_descriptions, aux_2700);
}
{
obj_t aux_2705;
aux_2705 = MAKE_PAIR(list1853___match_descriptions, BNIL);
list1852___match_descriptions = MAKE_PAIR(symbol1839___match_descriptions, aux_2705);
}
symbol1855___match_descriptions = string_to_symbol("S");
symbol1858___match_descriptions = string_to_symbol("TOP");
return (symbol1859___match_descriptions = string_to_symbol("HOLE"),
BUNSPEC);
}


/* pattern-variables */obj_t pattern_variables_45___match_descriptions(obj_t f_1)
{
pattern_variables_45___match_descriptions:
{
bool_t test_2711;
{
obj_t aux_2712;
aux_2712 = CAR(f_1);
test_2711 = (aux_2712==symbol1822___match_descriptions);
}
if(test_2711){
{
obj_t f_2715;
{
obj_t aux_2716;
aux_2716 = CDR(f_1);
f_2715 = CAR(aux_2716);
}
f_1 = f_2715;
goto pattern_variables_45___match_descriptions;
}
}
 else {
bool_t test_2719;
{
obj_t aux_2720;
aux_2720 = CAR(f_1);
test_2719 = (aux_2720==symbol1823___match_descriptions);
}
if(test_2719){
{
obj_t f_2723;
{
obj_t aux_2724;
aux_2724 = CDR(f_1);
f_2723 = CAR(aux_2724);
}
f_1 = f_2723;
goto pattern_variables_45___match_descriptions;
}
}
 else {
bool_t test_2727;
{
obj_t aux_2728;
aux_2728 = CAR(f_1);
test_2727 = (aux_2728==symbol1824___match_descriptions);
}
if(test_2727){
{
obj_t arg1020_392;
obj_t arg1021_393;
{
obj_t aux_2731;
{
obj_t aux_2732;
aux_2732 = CDR(f_1);
aux_2731 = CAR(aux_2732);
}
arg1020_392 = pattern_variables_45___match_descriptions(aux_2731);
}
{
obj_t aux_2736;
{
obj_t aux_2737;
{
obj_t aux_2738;
aux_2738 = CDR(f_1);
aux_2737 = CDR(aux_2738);
}
aux_2736 = CAR(aux_2737);
}
arg1021_393 = pattern_variables_45___match_descriptions(aux_2736);
}
return union_3___match_descriptions(arg1020_392, arg1021_393);
}
}
 else {
bool_t test_2744;
{
obj_t aux_2745;
aux_2745 = memq___r4_pairs_and_lists_6_3(CAR(f_1), list1825___match_descriptions);
test_2744 = CBOOL(aux_2745);
}
if(test_2744){
{
obj_t arg1025_397;
obj_t arg1026_398;
{
obj_t aux_2749;
{
obj_t aux_2750;
aux_2750 = CDR(f_1);
aux_2749 = CAR(aux_2750);
}
arg1025_397 = pattern_variables_45___match_descriptions(aux_2749);
}
{
obj_t aux_2754;
{
obj_t aux_2755;
{
obj_t aux_2756;
aux_2756 = CDR(f_1);
aux_2755 = CDR(aux_2756);
}
aux_2754 = CAR(aux_2755);
}
arg1026_398 = pattern_variables_45___match_descriptions(aux_2754);
}
return union_3___match_descriptions(arg1025_397, arg1026_398);
}
}
 else {
bool_t test_2762;
{
obj_t aux_2763;
aux_2763 = memq___r4_pairs_and_lists_6_3(CAR(f_1), list1828___match_descriptions);
test_2762 = CBOOL(aux_2763);
}
if(test_2762){
{
obj_t arg1030_402;
obj_t arg1031_403;
{
obj_t aux_2767;
{
obj_t aux_2768;
{
obj_t aux_2769;
aux_2769 = CDR(f_1);
aux_2768 = CDR(aux_2769);
}
aux_2767 = CAR(aux_2768);
}
arg1030_402 = pattern_variables_45___match_descriptions(aux_2767);
}
{
obj_t aux_2774;
{
obj_t aux_2775;
{
obj_t aux_2776;
{
obj_t aux_2777;
aux_2777 = CDR(f_1);
aux_2776 = CDR(aux_2777);
}
aux_2775 = CDR(aux_2776);
}
aux_2774 = CAR(aux_2775);
}
arg1031_403 = pattern_variables_45___match_descriptions(aux_2774);
}
return union_3___match_descriptions(arg1030_402, arg1031_403);
}
}
 else {
bool_t test_2784;
{
obj_t aux_2785;
aux_2785 = CAR(f_1);
test_2784 = (aux_2785==symbol1831___match_descriptions);
}
if(test_2784){
return CDR(f_1);
}
 else {
bool_t test_2789;
{
obj_t aux_2790;
aux_2790 = CAR(f_1);
test_2789 = (aux_2790==symbol1832___match_descriptions);
}
if(test_2789){
{
obj_t f_2793;
{
obj_t aux_2794;
{
obj_t aux_2795;
aux_2795 = CDR(f_1);
aux_2794 = CDR(aux_2795);
}
f_2793 = CAR(aux_2794);
}
f_1 = f_2793;
goto pattern_variables_45___match_descriptions;
}
}
 else {
bool_t test_2799;
{
obj_t aux_2800;
aux_2800 = CAR(f_1);
test_2799 = (aux_2800==symbol1833___match_descriptions);
}
if(test_2799){
return BNIL;
}
 else {
bool_t test_2803;
{
obj_t aux_2804;
aux_2804 = CAR(f_1);
test_2803 = (aux_2804==symbol1834___match_descriptions);
}
if(test_2803){
{
obj_t aux_2807;
{
obj_t aux_2808;
aux_2808 = CDR(f_1);
aux_2807 = CDR(aux_2808);
}
return loop_1821___match_descriptions(aux_2807);
}
}
 else {
return BNIL;
}
}
}
}
}
}
}
}
}
}
}


/* loop_1821 */obj_t loop_1821___match_descriptions(obj_t p__29_411)
{
if(NULLP(p__29_411)){
return BNIL;
}
 else {
obj_t arg1042_415;
obj_t arg1043_416;
arg1042_415 = pattern_variables_45___match_descriptions(CAR(p__29_411));
arg1043_416 = loop_1821___match_descriptions(CDR(p__29_411));
return union_3___match_descriptions(arg1042_415, arg1043_416);
}
}


/* _pattern-variables */obj_t _pattern_variables_154___match_descriptions(obj_t env_2424, obj_t f_2425)
{
return pattern_variables_45___match_descriptions(f_2425);
}


/* union */obj_t union_3___match_descriptions(obj_t l1_2, obj_t l2_3)
{
union_3___match_descriptions:
if(NULLP(l1_2)){
return l2_3;
}
 else {
bool_t test_2822;
{
obj_t aux_2823;
aux_2823 = member___r4_pairs_and_lists_6_3(CAR(l1_2), l2_3);
test_2822 = CBOOL(aux_2823);
}
if(test_2822){
obj_t l1_2827;
l1_2827 = CDR(l1_2);
l1_2 = l1_2827;
goto union_3___match_descriptions;
}
 else {
obj_t arg1069_440;
obj_t arg1070_441;
arg1069_440 = CAR(l1_2);
arg1070_441 = union_3___match_descriptions(CDR(l1_2), l2_3);
return MAKE_PAIR(arg1069_440, arg1070_441);
}
}
}


/* pattern-plus */obj_t pattern_plus_250___match_descriptions(obj_t old_7, obj_t new_8)
{
{
bool_t test_2833;
{
bool_t test_2834;
{
obj_t aux_2835;
aux_2835 = CAR(new_8);
test_2834 = (aux_2835==symbol1829___match_descriptions);
}
if(test_2834){
test_2833 = ((bool_t)1);
}
 else {
obj_t aux_2838;
aux_2838 = CAR(new_8);
test_2833 = (aux_2838==symbol1830___match_descriptions);
}
}
if(test_2833){
return old_7;
}
 else {
bool_t test_2841;
{
bool_t test_2842;
{
obj_t aux_2843;
aux_2843 = CAR(old_7);
test_2842 = (aux_2843==symbol1835___match_descriptions);
}
if(test_2842){
test_2841 = ((bool_t)1);
}
 else {
obj_t aux_2846;
aux_2846 = CAR(old_7);
test_2841 = (aux_2846==symbol1836___match_descriptions);
}
}
if(test_2841){
return new_8;
}
 else {
bool_t test_2849;
{
bool_t test_2850;
{
obj_t aux_2851;
aux_2851 = CAR(new_8);
test_2850 = (aux_2851==symbol1835___match_descriptions);
}
if(test_2850){
test_2849 = ((bool_t)1);
}
 else {
obj_t aux_2854;
aux_2854 = CAR(new_8);
test_2849 = (aux_2854==symbol1836___match_descriptions);
}
}
if(test_2849){
return old_7;
}
 else {
bool_t test1079_450;
test1079_450 = isnegation__119___match_descriptions(old_7);
if(test1079_450){
return norm___match_descriptions(new_8, symbol1837___match_descriptions);
}
 else {
obj_t arg1080_451;
{
bool_t test_2860;
{
obj_t aux_2861;
aux_2861 = CAR(new_8);
test_2860 = (aux_2861==symbol1831___match_descriptions);
}
if(test_2860){
obj_t arg1082_453;
arg1082_453 = symbol1824___match_descriptions;
{
obj_t list1083_454;
{
obj_t arg1084_455;
{
obj_t arg1085_456;
arg1085_456 = MAKE_PAIR(old_7, BNIL);
arg1084_455 = MAKE_PAIR(new_8, arg1085_456);
}
list1083_454 = MAKE_PAIR(arg1082_453, arg1084_455);
}
arg1080_451 = list1083_454;
}
}
 else {
obj_t arg1087_458;
arg1087_458 = symbol1824___match_descriptions;
{
obj_t list1088_459;
{
obj_t arg1089_460;
{
obj_t arg1090_461;
arg1090_461 = MAKE_PAIR(new_8, BNIL);
arg1089_460 = MAKE_PAIR(old_7, arg1090_461);
}
list1088_459 = MAKE_PAIR(arg1087_458, arg1089_460);
}
arg1080_451 = list1088_459;
}
}
}
return norm___match_descriptions(arg1080_451, symbol1837___match_descriptions);
}
}
}
}
}
}


/* _pattern-plus */obj_t _pattern_plus_115___match_descriptions(obj_t env_2426, obj_t old_2427, obj_t new_2428)
{
return pattern_plus_250___match_descriptions(old_2427, new_2428);
}


/* pattern-minus */obj_t pattern_minus_154___match_descriptions(obj_t p1_9, obj_t p2_10)
{
{
bool_t test1093_464;
{
bool_t test1110_481;
{
bool_t test1112_483;
test1112_483 = isnegation__119___match_descriptions(p1_9);
if(test1112_483){
test1110_481 = ((bool_t)1);
}
 else {
bool_t test_2874;
{
bool_t test_2875;
{
obj_t aux_2876;
aux_2876 = CAR(p1_9);
test_2875 = (aux_2876==symbol1835___match_descriptions);
}
if(test_2875){
test_2874 = ((bool_t)1);
}
 else {
obj_t aux_2879;
aux_2879 = CAR(p1_9);
test_2874 = (aux_2879==symbol1836___match_descriptions);
}
}
if(test_2874){
test1110_481 = ((bool_t)1);
}
 else {
obj_t aux_2882;
aux_2882 = CAR(p1_9);
test1110_481 = (aux_2882==symbol1838___match_descriptions);
}
}
}
if(test1110_481){
bool_t test_2886;
{
obj_t aux_2887;
aux_2887 = CAR(p2_10);
test_2886 = (aux_2887==symbol1830___match_descriptions);
}
if(test_2886){
test1093_464 = ((bool_t)1);
}
 else {
obj_t aux_2890;
aux_2890 = CAR(p2_10);
test1093_464 = (aux_2890==symbol1829___match_descriptions);
}
}
 else {
test1093_464 = ((bool_t)1);
}
}
if(test1093_464){
return p1_9;
}
 else {
bool_t test_2894;
{
bool_t test_2895;
{
obj_t aux_2896;
aux_2896 = CAR(p1_9);
test_2895 = (aux_2896==symbol1835___match_descriptions);
}
if(test_2895){
test_2894 = ((bool_t)1);
}
 else {
obj_t aux_2899;
aux_2899 = CAR(p1_9);
test_2894 = (aux_2899==symbol1836___match_descriptions);
}
}
if(test_2894){
obj_t arg1095_466;
arg1095_466 = symbol1839___match_descriptions;
{
obj_t list1096_467;
{
obj_t arg1097_468;
arg1097_468 = MAKE_PAIR(p2_10, BNIL);
list1096_467 = MAKE_PAIR(arg1095_466, arg1097_468);
}
return list1096_467;
}
}
 else {
obj_t arg1099_470;
{
obj_t arg1100_471;
obj_t arg1101_472;
arg1100_471 = symbol1824___match_descriptions;
{
obj_t arg1106_477;
arg1106_477 = symbol1839___match_descriptions;
{
obj_t list1107_478;
{
obj_t arg1108_479;
arg1108_479 = MAKE_PAIR(p2_10, BNIL);
list1107_478 = MAKE_PAIR(arg1106_477, arg1108_479);
}
arg1101_472 = list1107_478;
}
}
{
obj_t list1102_473;
{
obj_t arg1103_474;
{
obj_t arg1104_475;
arg1104_475 = MAKE_PAIR(arg1101_472, BNIL);
arg1103_474 = MAKE_PAIR(p1_9, arg1104_475);
}
list1102_473 = MAKE_PAIR(arg1100_471, arg1103_474);
}
arg1099_470 = list1102_473;
}
}
return norm___match_descriptions(arg1099_470, symbol1837___match_descriptions);
}
}
}
}


/* _pattern-minus */obj_t _pattern_minus_27___match_descriptions(obj_t env_2429, obj_t p1_2430, obj_t p2_2431)
{
return pattern_minus_154___match_descriptions(p1_2430, p2_2431);
}


/* isnegation? */bool_t isnegation__119___match_descriptions(obj_t c_11)
{
{
bool_t _ortest_1002_485;
{
bool_t test_2911;
{
obj_t aux_2912;
aux_2912 = CAR(c_11);
test_2911 = (aux_2912==symbol1824___match_descriptions);
}
if(test_2911){
obj_t aux_2915;
{
obj_t aux_2916;
aux_2916 = CDR(c_11);
aux_2915 = CAR(aux_2916);
}
_ortest_1002_485 = isnegation__119___match_descriptions(aux_2915);
}
 else {
_ortest_1002_485 = ((bool_t)0);
}
}
if(_ortest_1002_485){
return _ortest_1002_485;
}
 else {
obj_t aux_2921;
aux_2921 = CAR(c_11);
return (aux_2921==symbol1839___match_descriptions);
}
}
}


/* pattern-car */obj_t pattern_car_218___match_descriptions(obj_t c_12)
{
{
bool_t test_2924;
{
obj_t aux_2925;
aux_2925 = CAR(c_12);
test_2924 = (aux_2925==symbol1826___match_descriptions);
}
if(test_2924){
obj_t aux_2928;
aux_2928 = CDR(c_12);
return CAR(aux_2928);
}
 else {
return list1840___match_descriptions;
}
}
}


/* _pattern-car */obj_t _pattern_car_27___match_descriptions(obj_t env_2432, obj_t c_2433)
{
return pattern_car_218___match_descriptions(c_2433);
}


/* pattern-cdr */obj_t pattern_cdr_48___match_descriptions(obj_t c_13)
{
{
bool_t test_2932;
{
obj_t aux_2933;
aux_2933 = CAR(c_13);
test_2932 = (aux_2933==symbol1826___match_descriptions);
}
if(test_2932){
obj_t aux_2936;
{
obj_t aux_2937;
aux_2937 = CDR(c_13);
aux_2936 = CDR(aux_2937);
}
return CAR(aux_2936);
}
 else {
return list1840___match_descriptions;
}
}
}


/* _pattern-cdr */obj_t _pattern_cdr_121___match_descriptions(obj_t env_2434, obj_t c_2435)
{
return pattern_cdr_48___match_descriptions(c_2435);
}


/* norm */obj_t norm___match_descriptions(obj_t c_15, obj_t anc_16)
{
norm___match_descriptions:
if(equal__25___r4_equivalence_6_2(anc_16, c_15)){
return anc_16;
}
 else {
bool_t test_2944;
{
obj_t aux_2945;
aux_2945 = CAR(c_15);
test_2944 = (aux_2945==symbol1839___match_descriptions);
}
if(test_2944){
{
obj_t arg1128_501;
{
obj_t aux_2948;
aux_2948 = CDR(c_15);
arg1128_501 = CAR(aux_2948);
}
{
obj_t arg1142_1356;
obj_t arg1143_1357;
arg1142_1356 = rewrite_not_212___match_descriptions(arg1128_501);
{
obj_t arg1144_1358;
arg1144_1358 = symbol1839___match_descriptions;
{
obj_t list1145_1359;
{
obj_t arg1146_1360;
arg1146_1360 = MAKE_PAIR(arg1128_501, BNIL);
list1145_1359 = MAKE_PAIR(arg1144_1358, arg1146_1360);
}
arg1143_1357 = list1145_1359;
}
}
{
obj_t anc_2955;
obj_t c_2954;
c_2954 = arg1142_1356;
anc_2955 = arg1143_1357;
anc_16 = anc_2955;
c_15 = c_2954;
goto norm___match_descriptions;
}
}
}
}
 else {
bool_t test_2956;
{
obj_t aux_2957;
aux_2957 = CAR(c_15);
test_2956 = (aux_2957==symbol1824___match_descriptions);
}
if(test_2956){
{
obj_t arg1130_503;
obj_t arg1131_504;
{
obj_t aux_2960;
aux_2960 = CDR(c_15);
arg1130_503 = CAR(aux_2960);
}
{
obj_t aux_2963;
{
obj_t aux_2964;
aux_2964 = CDR(c_15);
aux_2963 = CDR(aux_2964);
}
arg1131_504 = CAR(aux_2963);
}
{
obj_t arg1157_1378;
obj_t arg1158_1379;
arg1157_1378 = rewrite_and_150___match_descriptions(arg1130_503, arg1131_504);
{
obj_t arg1160_1380;
arg1160_1380 = symbol1824___match_descriptions;
{
obj_t list1161_1381;
{
obj_t arg1162_1382;
{
obj_t arg1163_1383;
arg1163_1383 = MAKE_PAIR(arg1131_504, BNIL);
arg1162_1382 = MAKE_PAIR(arg1130_503, arg1163_1383);
}
list1161_1381 = MAKE_PAIR(arg1160_1380, arg1162_1382);
}
arg1158_1379 = list1161_1381;
}
}
{
obj_t anc_2973;
obj_t c_2972;
c_2972 = arg1157_1378;
anc_2973 = arg1158_1379;
anc_16 = anc_2973;
c_15 = c_2972;
goto norm___match_descriptions;
}
}
}
}
 else {
bool_t test_2974;
{
obj_t aux_2975;
aux_2975 = CAR(c_15);
test_2974 = (aux_2975==symbol1826___match_descriptions);
}
if(test_2974){
{
obj_t arg1219_1401;
obj_t arg1220_1402;
obj_t arg1221_1403;
arg1219_1401 = symbol1826___match_descriptions;
{
obj_t aux_2978;
{
obj_t aux_2979;
aux_2979 = CDR(c_15);
aux_2978 = CAR(aux_2979);
}
arg1220_1402 = norm___match_descriptions(aux_2978, symbol1837___match_descriptions);
}
{
obj_t aux_2983;
{
obj_t aux_2984;
{
obj_t aux_2985;
aux_2985 = CDR(c_15);
aux_2984 = CDR(aux_2985);
}
aux_2983 = CAR(aux_2984);
}
arg1221_1403 = norm___match_descriptions(aux_2983, symbol1837___match_descriptions);
}
{
obj_t list1222_1404;
{
obj_t arg1224_1405;
{
obj_t arg1225_1406;
arg1225_1406 = MAKE_PAIR(arg1221_1403, BNIL);
arg1224_1405 = MAKE_PAIR(arg1220_1402, arg1225_1406);
}
list1222_1404 = MAKE_PAIR(arg1219_1401, arg1224_1405);
}
return list1222_1404;
}
}
}
 else {
return c_15;
}
}
}
}
}


/* rewrite-not */obj_t rewrite_not_212___match_descriptions(obj_t c_18)
{
{
bool_t test_2993;
{
obj_t aux_2994;
aux_2994 = CAR(c_18);
test_2993 = (aux_2994==symbol1839___match_descriptions);
}
if(test_2993){
obj_t aux_2997;
aux_2997 = CDR(c_18);
return CAR(aux_2997);
}
 else {
obj_t arg1150_521;
obj_t arg1151_522;
arg1150_521 = symbol1839___match_descriptions;
arg1151_522 = norm___match_descriptions(c_18, symbol1837___match_descriptions);
{
obj_t list1152_523;
{
obj_t arg1153_524;
arg1153_524 = MAKE_PAIR(arg1151_522, BNIL);
list1152_523 = MAKE_PAIR(arg1150_521, arg1153_524);
}
return list1152_523;
}
}
}
}


/* rewrite-and */obj_t rewrite_and_150___match_descriptions(obj_t c1_21, obj_t c2_22)
{
if(equal__25___r4_equivalence_6_2(c1_21, c2_22)){
return c1_21;
}
 else {
bool_t test_3005;
{
obj_t aux_3006;
aux_3006 = CAR(c1_21);
test_3005 = (aux_3006==symbol1824___match_descriptions);
}
if(test_3005){
{
obj_t arg1167_537;
obj_t arg1168_538;
obj_t arg1169_539;
arg1167_537 = symbol1824___match_descriptions;
{
obj_t aux_3009;
aux_3009 = CDR(c1_21);
arg1168_538 = CAR(aux_3009);
}
{
obj_t arg1174_544;
obj_t arg1175_545;
arg1174_544 = symbol1824___match_descriptions;
{
obj_t aux_3012;
{
obj_t aux_3013;
aux_3013 = CDR(c1_21);
aux_3012 = CDR(aux_3013);
}
arg1175_545 = CAR(aux_3012);
}
{
obj_t list1176_546;
{
obj_t arg1177_547;
{
obj_t arg1178_548;
arg1178_548 = MAKE_PAIR(c2_22, BNIL);
arg1177_547 = MAKE_PAIR(arg1175_545, arg1178_548);
}
list1176_546 = MAKE_PAIR(arg1174_544, arg1177_547);
}
arg1169_539 = list1176_546;
}
}
{
obj_t list1170_540;
{
obj_t arg1171_541;
{
obj_t arg1172_542;
arg1172_542 = MAKE_PAIR(arg1169_539, BNIL);
arg1171_541 = MAKE_PAIR(arg1168_538, arg1172_542);
}
list1170_540 = MAKE_PAIR(arg1167_537, arg1171_541);
}
return list1170_540;
}
}
}
 else {
bool_t test_3023;
{
bool_t test_3024;
{
obj_t aux_3025;
aux_3025 = CAR(c1_21);
test_3024 = (aux_3025==symbol1826___match_descriptions);
}
if(test_3024){
obj_t aux_3028;
aux_3028 = CAR(c2_22);
test_3023 = (aux_3028==symbol1826___match_descriptions);
}
 else {
test_3023 = ((bool_t)0);
}
}
if(test_3023){
{
obj_t arg1181_551;
obj_t arg1182_552;
obj_t arg1183_553;
arg1181_551 = symbol1826___match_descriptions;
{
obj_t arg1188_558;
obj_t arg1189_559;
arg1188_558 = symbol1824___match_descriptions;
{
obj_t aux_3031;
aux_3031 = CDR(c1_21);
arg1189_559 = CAR(aux_3031);
}
{
obj_t list1191_561;
{
obj_t arg1192_562;
{
obj_t arg1193_563;
{
obj_t aux_3034;
{
obj_t aux_3035;
aux_3035 = CDR(c2_22);
aux_3034 = CAR(aux_3035);
}
arg1193_563 = MAKE_PAIR(aux_3034, BNIL);
}
arg1192_562 = MAKE_PAIR(arg1189_559, arg1193_563);
}
list1191_561 = MAKE_PAIR(arg1188_558, arg1192_562);
}
arg1182_552 = list1191_561;
}
}
{
obj_t arg1195_565;
obj_t arg1196_566;
arg1195_565 = symbol1824___match_descriptions;
{
obj_t aux_3041;
{
obj_t aux_3042;
aux_3042 = CDR(c1_21);
aux_3041 = CDR(aux_3042);
}
arg1196_566 = CAR(aux_3041);
}
{
obj_t list1198_568;
{
obj_t arg1199_569;
{
obj_t arg1200_570;
{
obj_t aux_3046;
{
obj_t aux_3047;
{
obj_t aux_3048;
aux_3048 = CDR(c2_22);
aux_3047 = CDR(aux_3048);
}
aux_3046 = CAR(aux_3047);
}
arg1200_570 = MAKE_PAIR(aux_3046, BNIL);
}
arg1199_569 = MAKE_PAIR(arg1196_566, arg1200_570);
}
list1198_568 = MAKE_PAIR(arg1195_565, arg1199_569);
}
arg1183_553 = list1198_568;
}
}
{
obj_t list1184_554;
{
obj_t arg1185_555;
{
obj_t arg1186_556;
arg1186_556 = MAKE_PAIR(arg1183_553, BNIL);
arg1185_555 = MAKE_PAIR(arg1182_552, arg1186_556);
}
list1184_554 = MAKE_PAIR(arg1181_551, arg1185_555);
}
return list1184_554;
}
}
}
 else {
{
obj_t arg1202_572;
arg1202_572 = symbol1824___match_descriptions;
{
obj_t list1203_573;
{
obj_t arg1204_574;
{
obj_t arg1205_575;
arg1205_575 = MAKE_PAIR(c2_22, BNIL);
arg1204_574 = MAKE_PAIR(c1_21, arg1205_575);
}
list1203_573 = MAKE_PAIR(arg1202_572, arg1204_574);
}
return list1203_573;
}
}
}
}
}
}


/* more-precise? */obj_t more_precise__220___match_descriptions(obj_t descr_25, obj_t f_26)
{
more_precise__220___match_descriptions:
{
bool_t test_3061;
{
bool_t test_3062;
{
obj_t aux_3063;
aux_3063 = CAR(descr_25);
test_3062 = (aux_3063==symbol1835___match_descriptions);
}
if(test_3062){
test_3061 = ((bool_t)1);
}
 else {
obj_t aux_3066;
aux_3066 = CAR(descr_25);
test_3061 = (aux_3066==symbol1836___match_descriptions);
}
}
if(test_3061){
return BFALSE;
}
 else {
if(eqv__112___r4_equivalence_6_2(CAR(f_26), symbol1835___match_descriptions)){
return BTRUE;
}
 else {
if(eqv__112___r4_equivalence_6_2(CAR(f_26), symbol1841___match_descriptions)){
return BFALSE;
}
 else {
if(eqv__112___r4_equivalence_6_2(CAR(f_26), symbol1842___match_descriptions)){
{
bool_t test_3078;
{
obj_t aux_3079;
aux_3079 = CAR(descr_25);
test_3078 = (aux_3079==symbol1842___match_descriptions);
}
if(test_3078){
bool_t aux_3082;
{
obj_t aux_3087;
obj_t aux_3083;
{
obj_t aux_3088;
aux_3088 = CDR(f_26);
aux_3087 = CAR(aux_3088);
}
{
obj_t aux_3084;
aux_3084 = CDR(descr_25);
aux_3083 = CAR(aux_3084);
}
aux_3082 = equal__25___r4_equivalence_6_2(aux_3083, aux_3087);
}
return BBOOL(aux_3082);
}
 else {
return BFALSE;
}
}
}
 else {
if(eqv__112___r4_equivalence_6_2(CAR(f_26), symbol1824___match_descriptions)){
{
obj_t _andtest_1005_599;
{
obj_t aux_3096;
{
obj_t aux_3097;
aux_3097 = CDR(f_26);
aux_3096 = CAR(aux_3097);
}
_andtest_1005_599 = more_precise__220___match_descriptions(descr_25, aux_3096);
}
if(CBOOL(_andtest_1005_599)){
obj_t f_3103;
{
obj_t aux_3104;
{
obj_t aux_3105;
aux_3105 = CDR(f_26);
aux_3104 = CDR(aux_3105);
}
f_3103 = CAR(aux_3104);
}
f_26 = f_3103;
goto more_precise__220___match_descriptions;
}
 else {
return BFALSE;
}
}
}
 else {
if(eqv__112___r4_equivalence_6_2(CAR(f_26), symbol1822___match_descriptions)){
{
obj_t _ortest_1006_603;
{
obj_t aux_3112;
{
obj_t aux_3113;
aux_3113 = CDR(f_26);
aux_3112 = CAR(aux_3113);
}
_ortest_1006_603 = more_precise__220___match_descriptions(descr_25, aux_3112);
}
if(CBOOL(_ortest_1006_603)){
return _ortest_1006_603;
}
 else {
obj_t f_3119;
{
obj_t aux_3120;
{
obj_t aux_3121;
aux_3121 = CDR(f_26);
aux_3120 = CDR(aux_3121);
}
f_3119 = CAR(aux_3120);
}
f_26 = f_3119;
goto more_precise__220___match_descriptions;
}
}
}
 else {
if(eqv__112___r4_equivalence_6_2(CAR(f_26), symbol1823___match_descriptions)){
return BFALSE;
}
 else {
bool_t test_3128;
{
obj_t aux_3129;
aux_3129 = memq___r4_pairs_and_lists_6_3(CAR(f_26), list1843___match_descriptions);
test_3128 = CBOOL(aux_3129);
}
if(test_3128){
{
bool_t test_3133;
{
obj_t aux_3134;
aux_3134 = CAR(descr_25);
test_3133 = (aux_3134==symbol1826___match_descriptions);
}
if(test_3133){
obj_t _andtest_1008_609;
{
obj_t aux_3141;
obj_t aux_3137;
{
obj_t aux_3142;
aux_3142 = CDR(f_26);
aux_3141 = CAR(aux_3142);
}
{
obj_t aux_3138;
aux_3138 = CDR(descr_25);
aux_3137 = CAR(aux_3138);
}
_andtest_1008_609 = more_precise__220___match_descriptions(aux_3137, aux_3141);
}
if(CBOOL(_andtest_1008_609)){
obj_t f_3154;
obj_t descr_3148;
{
obj_t aux_3149;
{
obj_t aux_3150;
aux_3150 = CDR(descr_25);
aux_3149 = CDR(aux_3150);
}
descr_3148 = CAR(aux_3149);
}
{
obj_t aux_3155;
{
obj_t aux_3156;
aux_3156 = CDR(f_26);
aux_3155 = CDR(aux_3156);
}
f_3154 = CAR(aux_3155);
}
f_26 = f_3154;
descr_25 = descr_3148;
goto more_precise__220___match_descriptions;
}
 else {
return BFALSE;
}
}
 else {
return BFALSE;
}
}
}
 else {
if(eqv__112___r4_equivalence_6_2(CAR(f_26), symbol1832___match_descriptions)){
return BFALSE;
}
 else {
return BFALSE;
}
}
}
}
}
}
}
}
}
}
}


/* _more-precise? */obj_t _more_precise__183___match_descriptions(obj_t env_2436, obj_t descr_2437, obj_t f_2438)
{
return more_precise__220___match_descriptions(descr_2437, f_2438);
}


/* compatible? */obj_t compatible__222___match_descriptions(obj_t descr_27, obj_t pattern_28)
{
{
obj_t res_631;
{
bool_t test_3164;
{
obj_t aux_3165;
aux_3165 = CAR(pattern_28);
test_3164 = (aux_3165==symbol1824___match_descriptions);
}
if(test_3164){
obj_t _andtest_1009_633;
{
obj_t aux_3168;
{
obj_t aux_3169;
aux_3169 = CDR(pattern_28);
aux_3168 = CAR(aux_3169);
}
_andtest_1009_633 = compatible__222___match_descriptions(descr_27, aux_3168);
}
if(CBOOL(_andtest_1009_633)){
obj_t aux_3175;
{
obj_t aux_3176;
{
obj_t aux_3177;
aux_3177 = CDR(pattern_28);
aux_3176 = CDR(aux_3177);
}
aux_3175 = CAR(aux_3176);
}
res_631 = compatible__222___match_descriptions(descr_27, aux_3175);
}
 else {
res_631 = BFALSE;
}
}
 else {
obj_t arg1273_636;
arg1273_636 = alpha_convert_60___match_descriptions(pattern_28);
{
obj_t arg1278_2439;
obj_t arg1277_2440;
obj_t arg1274_2441;
arg1278_2439 = proc1846___match_descriptions;
arg1277_2440 = proc1847___match_descriptions;
arg1274_2441 = proc1848___match_descriptions;
res_631 = compare___match_descriptions(descr_27, arg1273_636, arg1274_2441, arg1277_2440, arg1278_2439);
}
}
}
return res_631;
}
}


/* _compatible? */obj_t _compatible__139___match_descriptions(obj_t env_2442, obj_t descr_2443, obj_t pattern_2444)
{
return compatible__222___match_descriptions(descr_2443, pattern_2444);
}


/* arg1278 */obj_t arg1278___match_descriptions(obj_t env_2445, obj_t x_2446)
{
return BBOOL(((bool_t)0));
}


/* arg1277 */obj_t arg1277___match_descriptions(obj_t env_2447, obj_t x_2448)
{
return BBOOL(((bool_t)1));
}


/* arg1274 */obj_t arg1274___match_descriptions(obj_t env_2449, obj_t x_2450)
{
return symbol1849___match_descriptions;
}


/* compare */obj_t compare___match_descriptions(obj_t descr_29, obj_t pat_30, obj_t env_31, obj_t k_32, obj_t z_33)
{
compare___match_descriptions:
{
bool_t test_3187;
{
bool_t test_3188;
{
bool_t test_3189;
{
obj_t aux_3190;
aux_3190 = CAR(descr_29);
test_3189 = (aux_3190==symbol1835___match_descriptions);
}
if(test_3189){
test_3188 = ((bool_t)1);
}
 else {
obj_t aux_3193;
aux_3193 = CAR(descr_29);
test_3188 = (aux_3193==symbol1836___match_descriptions);
}
}
if(test_3188){
test_3187 = ((bool_t)1);
}
 else {
bool_t test_3196;
{
bool_t test_3197;
{
obj_t aux_3198;
aux_3198 = CAR(pat_30);
test_3197 = (aux_3198==symbol1835___match_descriptions);
}
if(test_3197){
test_3196 = ((bool_t)1);
}
 else {
obj_t aux_3201;
aux_3201 = CAR(pat_30);
test_3196 = (aux_3201==symbol1836___match_descriptions);
}
}
if(test_3196){
test_3187 = ((bool_t)1);
}
 else {
bool_t test_3204;
{
obj_t aux_3205;
aux_3205 = CAR(pat_30);
test_3204 = (aux_3205==symbol1822___match_descriptions);
}
if(test_3204){
test_3187 = ((bool_t)1);
}
 else {
bool_t test_3208;
{
obj_t aux_3209;
aux_3209 = CAR(pat_30);
test_3208 = (aux_3209==symbol1823___match_descriptions);
}
if(test_3208){
test_3187 = ((bool_t)1);
}
 else {
bool_t test_3212;
{
obj_t aux_3213;
aux_3213 = CAR(pat_30);
test_3212 = (aux_3213==symbol1850___match_descriptions);
}
if(test_3212){
test_3187 = ((bool_t)1);
}
 else {
bool_t test_3216;
{
obj_t aux_3217;
aux_3217 = CAR(pat_30);
test_3216 = (aux_3217==symbol1841___match_descriptions);
}
if(test_3216){
test_3187 = ((bool_t)1);
}
 else {
bool_t test_3220;
{
obj_t aux_3221;
aux_3221 = CAR(pat_30);
test_3220 = (aux_3221==symbol1836___match_descriptions);
}
if(test_3220){
test_3187 = ((bool_t)1);
}
 else {
bool_t test_3224;
{
obj_t aux_3225;
aux_3225 = CAR(pat_30);
test_3224 = (aux_3225==symbol1830___match_descriptions);
}
if(test_3224){
test_3187 = ((bool_t)1);
}
 else {
obj_t aux_3228;
aux_3228 = CAR(pat_30);
test_3187 = (aux_3228==symbol1829___match_descriptions);
}
}
}
}
}
}
}
}
}
if(test_3187){
return PROCEDURE_ENTRY(k_32)(k_32, env_31, BEOA);
}
 else {
bool_t test_3233;
{
obj_t aux_3234;
aux_3234 = CAR(pat_30);
test_3233 = (aux_3234==symbol1824___match_descriptions);
}
if(test_3233){
{
obj_t arg1284_651;
{
obj_t aux_3237;
aux_3237 = CDR(pat_30);
arg1284_651 = CAR(aux_3237);
}
{
obj_t arg1285_2451;
arg1285_2451 = make_fx_procedure(arg1285___match_descriptions, ((long)1), ((long)4));
PROCEDURE_SET(arg1285_2451, ((long)0), pat_30);
PROCEDURE_SET(arg1285_2451, ((long)1), descr_29);
PROCEDURE_SET(arg1285_2451, ((long)2), k_32);
PROCEDURE_SET(arg1285_2451, ((long)3), z_33);
{
obj_t k_3246;
obj_t pat_3245;
pat_3245 = arg1284_651;
k_3246 = arg1285_2451;
k_32 = k_3246;
pat_30 = pat_3245;
goto compare___match_descriptions;
}
}
}
}
 else {
bool_t test_3247;
{
obj_t aux_3248;
aux_3248 = CAR(pat_30);
test_3247 = (aux_3248==symbol1826___match_descriptions);
}
if(test_3247){
{
bool_t test1289_658;
test1289_658 = may_be_a_cons_83___match_descriptions(descr_29);
if(test1289_658){
obj_t arg1290_659;
obj_t arg1291_660;
{
bool_t test_3253;
{
obj_t aux_3254;
aux_3254 = CAR(descr_29);
test_3253 = (aux_3254==symbol1826___match_descriptions);
}
if(test_3253){
obj_t aux_3257;
aux_3257 = CDR(descr_29);
arg1290_659 = CAR(aux_3257);
}
 else {
arg1290_659 = list1840___match_descriptions;
}
}
{
obj_t aux_3260;
aux_3260 = CDR(pat_30);
arg1291_660 = CAR(aux_3260);
}
{
obj_t arg1292_2452;
arg1292_2452 = make_fx_procedure(arg1292___match_descriptions, ((long)1), ((long)4));
PROCEDURE_SET(arg1292_2452, ((long)0), descr_29);
PROCEDURE_SET(arg1292_2452, ((long)1), pat_30);
PROCEDURE_SET(arg1292_2452, ((long)2), k_32);
PROCEDURE_SET(arg1292_2452, ((long)3), z_33);
{
obj_t k_3270;
obj_t pat_3269;
obj_t descr_3268;
descr_3268 = arg1290_659;
pat_3269 = arg1291_660;
k_3270 = arg1292_2452;
k_32 = k_3270;
pat_30 = pat_3269;
descr_29 = descr_3268;
goto compare___match_descriptions;
}
}
}
 else {
return PROCEDURE_ENTRY(z_33)(z_33, env_31, BEOA);
}
}
}
 else {
bool_t test_3273;
{
obj_t aux_3274;
aux_3274 = CAR(pat_30);
test_3273 = (aux_3274==symbol1842___match_descriptions);
}
if(test_3273){
{
obj_t aux_3277;
{
obj_t aux_3278;
aux_3278 = CDR(pat_30);
aux_3277 = CAR(aux_3278);
}
return match___match_descriptions(descr_29, aux_3277, env_31, k_32, z_33);
}
}
 else {
bool_t test_3282;
{
bool_t test_3283;
{
obj_t aux_3284;
aux_3284 = CAR(descr_29);
test_3283 = (aux_3284==symbol1831___match_descriptions);
}
if(test_3283){
obj_t aux_3287;
aux_3287 = CAR(pat_30);
test_3282 = (aux_3287==symbol1831___match_descriptions);
}
 else {
test_3282 = ((bool_t)0);
}
}
if(test_3282){
{
bool_t test1299_670;
{
obj_t arg1342_701;
{
obj_t aux_3290;
{
obj_t aux_3291;
aux_3291 = CDR(descr_29);
aux_3290 = CAR(aux_3291);
}
arg1342_701 = PROCEDURE_ENTRY(env_31)(env_31, aux_3290, BEOA);
}
test1299_670 = (arg1342_701==symbol1849___match_descriptions);
}
if(test1299_670){
bool_t test1300_671;
{
obj_t arg1321_686;
{
obj_t aux_3298;
{
obj_t aux_3299;
aux_3299 = CDR(pat_30);
aux_3298 = CAR(aux_3299);
}
arg1321_686 = PROCEDURE_ENTRY(env_31)(env_31, aux_3298, BEOA);
}
test1300_671 = (arg1321_686==symbol1849___match_descriptions);
}
if(test1300_671){
obj_t s_672;
{
obj_t arg1307_677;
obj_t arg1308_678;
arg1307_677 = symbol1842___match_descriptions;
arg1308_678 = PROCEDURE_ENTRY(jim_gensym_58___match_s2cfun)(jim_gensym_58___match_s2cfun, BEOA);
{
obj_t list1309_679;
{
obj_t arg1310_680;
arg1310_680 = MAKE_PAIR(arg1308_678, BNIL);
list1309_679 = MAKE_PAIR(arg1307_677, arg1310_680);
}
s_672 = list1309_679;
}
}
{
obj_t arg1301_673;
{
obj_t arg1302_674;
obj_t arg1303_675;
{
obj_t arg1304_676;
{
obj_t aux_3310;
aux_3310 = CDR(descr_29);
arg1304_676 = CAR(aux_3310);
}
{
obj_t lambda1074_2454;
lambda1074_2454 = make_fx_procedure(lambda1074_1813___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2454, ((long)0), arg1304_676);
PROCEDURE_SET(lambda1074_2454, ((long)1), env_31);
PROCEDURE_SET(lambda1074_2454, ((long)2), s_672);
arg1302_674 = lambda1074_2454;
}
}
{
obj_t aux_3317;
aux_3317 = CDR(pat_30);
arg1303_675 = CAR(aux_3317);
}
{
obj_t lambda1074_2453;
lambda1074_2453 = make_fx_procedure(lambda1074___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2453, ((long)0), arg1303_675);
PROCEDURE_SET(lambda1074_2453, ((long)1), arg1302_674);
PROCEDURE_SET(lambda1074_2453, ((long)2), s_672);
arg1301_673 = lambda1074_2453;
}
}
return PROCEDURE_ENTRY(k_32)(k_32, arg1301_673, BEOA);
}
}
 else {
obj_t arg1313_682;
{
obj_t arg1315_683;
obj_t arg1316_684;
{
obj_t aux_3326;
aux_3326 = CDR(descr_29);
arg1315_683 = CAR(aux_3326);
}
{
obj_t aux_3329;
{
obj_t aux_3330;
aux_3330 = CDR(pat_30);
aux_3329 = CAR(aux_3330);
}
arg1316_684 = PROCEDURE_ENTRY(env_31)(env_31, aux_3329, BEOA);
}
{
obj_t lambda1074_2455;
lambda1074_2455 = make_fx_procedure(lambda1074_1814___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2455, ((long)0), arg1315_683);
PROCEDURE_SET(lambda1074_2455, ((long)1), env_31);
PROCEDURE_SET(lambda1074_2455, ((long)2), arg1316_684);
arg1313_682 = lambda1074_2455;
}
}
return PROCEDURE_ENTRY(k_32)(k_32, arg1313_682, BEOA);
}
}
 else {
bool_t test1324_689;
{
obj_t arg1337_698;
{
obj_t aux_3341;
{
obj_t aux_3342;
aux_3342 = CDR(pat_30);
aux_3341 = CAR(aux_3342);
}
arg1337_698 = PROCEDURE_ENTRY(env_31)(env_31, aux_3341, BEOA);
}
test1324_689 = (arg1337_698==symbol1849___match_descriptions);
}
if(test1324_689){
obj_t arg1325_690;
{
obj_t arg1326_691;
obj_t arg1328_692;
{
obj_t aux_3349;
aux_3349 = CDR(pat_30);
arg1326_691 = CAR(aux_3349);
}
{
obj_t aux_3352;
{
obj_t aux_3353;
aux_3353 = CDR(descr_29);
aux_3352 = CAR(aux_3353);
}
arg1328_692 = PROCEDURE_ENTRY(env_31)(env_31, aux_3352, BEOA);
}
{
obj_t lambda1074_2456;
lambda1074_2456 = make_fx_procedure(lambda1074_1815___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2456, ((long)0), arg1326_691);
PROCEDURE_SET(lambda1074_2456, ((long)1), env_31);
PROCEDURE_SET(lambda1074_2456, ((long)2), arg1328_692);
arg1325_690 = lambda1074_2456;
}
}
return PROCEDURE_ENTRY(k_32)(k_32, arg1325_690, BEOA);
}
 else {
obj_t arg1331_694;
obj_t arg1332_695;
{
obj_t aux_3364;
{
obj_t aux_3365;
aux_3365 = CDR(descr_29);
aux_3364 = CAR(aux_3365);
}
arg1331_694 = PROCEDURE_ENTRY(env_31)(env_31, aux_3364, BEOA);
}
{
obj_t aux_3370;
{
obj_t aux_3371;
aux_3371 = CDR(pat_30);
aux_3370 = CAR(aux_3371);
}
arg1332_695 = PROCEDURE_ENTRY(env_31)(env_31, aux_3370, BEOA);
}
{
obj_t pat_3377;
obj_t descr_3376;
descr_3376 = arg1331_694;
pat_3377 = arg1332_695;
pat_30 = pat_3377;
descr_29 = descr_3376;
goto compare___match_descriptions;
}
}
}
}
}
 else {
bool_t test_3378;
{
obj_t aux_3379;
aux_3379 = CAR(pat_30);
test_3378 = (aux_3379==symbol1831___match_descriptions);
}
if(test_3378){
{
bool_t test1346_705;
{
obj_t arg1352_710;
{
obj_t aux_3382;
{
obj_t aux_3383;
aux_3383 = CDR(pat_30);
aux_3382 = CAR(aux_3383);
}
arg1352_710 = PROCEDURE_ENTRY(env_31)(env_31, aux_3382, BEOA);
}
test1346_705 = (arg1352_710==symbol1849___match_descriptions);
}
if(test1346_705){
obj_t arg1347_706;
{
obj_t arg1349_707;
{
obj_t aux_3390;
aux_3390 = CDR(pat_30);
arg1349_707 = CAR(aux_3390);
}
{
obj_t lambda1074_2457;
lambda1074_2457 = make_fx_procedure(lambda1074_1816___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2457, ((long)0), arg1349_707);
PROCEDURE_SET(lambda1074_2457, ((long)1), env_31);
PROCEDURE_SET(lambda1074_2457, ((long)2), descr_29);
arg1347_706 = lambda1074_2457;
}
}
return PROCEDURE_ENTRY(k_32)(k_32, arg1347_706, BEOA);
}
 else {
obj_t arg1350_708;
{
obj_t aux_3399;
{
obj_t aux_3400;
aux_3400 = CDR(pat_30);
aux_3399 = CAR(aux_3400);
}
arg1350_708 = PROCEDURE_ENTRY(env_31)(env_31, aux_3399, BEOA);
}
{
obj_t pat_3405;
pat_3405 = arg1350_708;
pat_30 = pat_3405;
goto compare___match_descriptions;
}
}
}
}
 else {
bool_t test_3406;
{
obj_t aux_3407;
aux_3407 = CAR(descr_29);
test_3406 = (aux_3407==symbol1831___match_descriptions);
}
if(test_3406){
{
bool_t test1357_714;
{
obj_t arg1367_719;
{
obj_t aux_3410;
{
obj_t aux_3411;
aux_3411 = CDR(descr_29);
aux_3410 = CAR(aux_3411);
}
arg1367_719 = PROCEDURE_ENTRY(env_31)(env_31, aux_3410, BEOA);
}
test1357_714 = (arg1367_719==symbol1849___match_descriptions);
}
if(test1357_714){
obj_t arg1361_715;
{
obj_t arg1363_716;
{
obj_t aux_3418;
aux_3418 = CDR(descr_29);
arg1363_716 = CAR(aux_3418);
}
{
obj_t lambda1074_2458;
lambda1074_2458 = make_fx_procedure(lambda1074_1817___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2458, ((long)0), arg1363_716);
PROCEDURE_SET(lambda1074_2458, ((long)1), env_31);
PROCEDURE_SET(lambda1074_2458, ((long)2), pat_30);
arg1361_715 = lambda1074_2458;
}
}
return PROCEDURE_ENTRY(k_32)(k_32, arg1361_715, BEOA);
}
 else {
obj_t arg1364_717;
{
obj_t aux_3427;
{
obj_t aux_3428;
aux_3428 = CDR(descr_29);
aux_3427 = CAR(aux_3428);
}
arg1364_717 = PROCEDURE_ENTRY(env_31)(env_31, aux_3427, BEOA);
}
{
obj_t pat_3433;
pat_3433 = arg1364_717;
pat_30 = pat_3433;
goto compare___match_descriptions;
}
}
}
}
 else {
bool_t test_3434;
{
obj_t aux_3435;
aux_3435 = CAR(pat_30);
test_3434 = (aux_3435==symbol1839___match_descriptions);
}
if(test_3434){
{
bool_t test1371_723;
{
obj_t aux_3438;
{
obj_t aux_3439;
{
obj_t aux_3440;
aux_3440 = CDR(pat_30);
aux_3439 = CAR(aux_3440);
}
aux_3438 = more_precise__220___match_descriptions(aux_3439, descr_29);
}
test1371_723 = CBOOL(aux_3438);
}
if(test1371_723){
return PROCEDURE_ENTRY(z_33)(z_33, env_31, BEOA);
}
 else {
return PROCEDURE_ENTRY(k_32)(k_32, env_31, BEOA);
}
}
}
 else {
bool_t test_3450;
{
obj_t aux_3451;
aux_3451 = CAR(pat_30);
test_3450 = (aux_3451==symbol1832___match_descriptions);
}
if(test_3450){
{
bool_t test_3454;
{
bool_t test_3455;
{
obj_t aux_3456;
aux_3456 = CAR(descr_29);
test_3455 = (aux_3456==symbol1835___match_descriptions);
}
if(test_3455){
test_3454 = ((bool_t)1);
}
 else {
obj_t aux_3459;
aux_3459 = CAR(descr_29);
test_3454 = (aux_3459==symbol1836___match_descriptions);
}
}
if(test_3454){
return BTRUE;
}
 else {
bool_t test_3462;
{
obj_t aux_3463;
aux_3463 = CAR(descr_29);
test_3462 = (aux_3463==symbol1851___match_descriptions);
}
if(test_3462){
return match___match_descriptions(pat_30, descr_29, env_31, k_32, z_33);
}
 else {
return BFALSE;
}
}
}
}
 else {
return PROCEDURE_ENTRY(k_32)(k_32, env_31, BEOA);
}
}
}
}
}
}
}
}
}
}
}


/* arg1285 */obj_t arg1285___match_descriptions(obj_t env_2459, obj_t env_2464)
{
{
obj_t pat_2460;
obj_t descr_2461;
obj_t k_2462;
obj_t z_2463;
pat_2460 = PROCEDURE_REF(env_2459, ((long)0));
descr_2461 = PROCEDURE_REF(env_2459, ((long)1));
k_2462 = PROCEDURE_REF(env_2459, ((long)2));
z_2463 = PROCEDURE_REF(env_2459, ((long)3));
{
obj_t env_653;
env_653 = env_2464;
{
obj_t aux_3473;
{
obj_t aux_3474;
{
obj_t aux_3475;
aux_3475 = CDR(pat_2460);
aux_3474 = CDR(aux_3475);
}
aux_3473 = CAR(aux_3474);
}
return compare___match_descriptions(descr_2461, aux_3473, env_653, k_2462, z_2463);
}
}
}
}


/* arg1292 */obj_t arg1292___match_descriptions(obj_t env_2465, obj_t env_2470)
{
{
obj_t descr_2466;
obj_t pat_2467;
obj_t k_2468;
obj_t z_2469;
descr_2466 = PROCEDURE_REF(env_2465, ((long)0));
pat_2467 = PROCEDURE_REF(env_2465, ((long)1));
k_2468 = PROCEDURE_REF(env_2465, ((long)2));
z_2469 = PROCEDURE_REF(env_2465, ((long)3));
{
obj_t env_662;
env_662 = env_2470;
{
obj_t aux_3494;
obj_t aux_3484;
{
obj_t aux_3495;
{
obj_t aux_3496;
aux_3496 = CDR(pat_2467);
aux_3495 = CDR(aux_3496);
}
aux_3494 = CAR(aux_3495);
}
{
bool_t test_3485;
{
obj_t aux_3486;
aux_3486 = CAR(descr_2466);
test_3485 = (aux_3486==symbol1826___match_descriptions);
}
if(test_3485){
obj_t aux_3489;
{
obj_t aux_3490;
aux_3490 = CDR(descr_2466);
aux_3489 = CDR(aux_3490);
}
aux_3484 = CAR(aux_3489);
}
 else {
aux_3484 = list1840___match_descriptions;
}
}
return compare___match_descriptions(aux_3484, aux_3494, env_662, k_2468, z_2469);
}
}
}
}


/* lambda1074 */obj_t lambda1074___match_descriptions(obj_t env_2471, obj_t x_2475)
{
{
obj_t pt_2472;
obj_t fn_2473;
obj_t im_2474;
pt_2472 = PROCEDURE_REF(env_2471, ((long)0));
fn_2473 = PROCEDURE_REF(env_2471, ((long)1));
im_2474 = PROCEDURE_REF(env_2471, ((long)2));
{
obj_t x_1772;
x_1772 = x_2475;
if((x_1772==pt_2472)){
return im_2474;
}
 else {
return PROCEDURE_ENTRY(fn_2473)(fn_2473, x_1772, BEOA);
}
}
}
}


/* lambda1074_1813 */obj_t lambda1074_1813___match_descriptions(obj_t env_2476, obj_t x_2480)
{
{
obj_t pt_2477;
obj_t fn_2478;
obj_t im_2479;
pt_2477 = PROCEDURE_REF(env_2476, ((long)0));
fn_2478 = PROCEDURE_REF(env_2476, ((long)1));
im_2479 = PROCEDURE_REF(env_2476, ((long)2));
{
obj_t x_1759;
x_1759 = x_2480;
if((x_1759==pt_2477)){
return im_2479;
}
 else {
return PROCEDURE_ENTRY(fn_2478)(fn_2478, x_1759, BEOA);
}
}
}
}


/* lambda1074_1814 */obj_t lambda1074_1814___match_descriptions(obj_t env_2481, obj_t x_2485)
{
{
obj_t pt_2482;
obj_t fn_2483;
obj_t im_2484;
pt_2482 = PROCEDURE_REF(env_2481, ((long)0));
fn_2483 = PROCEDURE_REF(env_2481, ((long)1));
im_2484 = PROCEDURE_REF(env_2481, ((long)2));
{
obj_t x_1789;
x_1789 = x_2485;
if((x_1789==pt_2482)){
return im_2484;
}
 else {
return PROCEDURE_ENTRY(fn_2483)(fn_2483, x_1789, BEOA);
}
}
}
}


/* lambda1074_1815 */obj_t lambda1074_1815___match_descriptions(obj_t env_2486, obj_t x_2490)
{
{
obj_t pt_2487;
obj_t fn_2488;
obj_t im_2489;
pt_2487 = PROCEDURE_REF(env_2486, ((long)0));
fn_2488 = PROCEDURE_REF(env_2486, ((long)1));
im_2489 = PROCEDURE_REF(env_2486, ((long)2));
{
obj_t x_1812;
x_1812 = x_2490;
if((x_1812==pt_2487)){
return im_2489;
}
 else {
return PROCEDURE_ENTRY(fn_2488)(fn_2488, x_1812, BEOA);
}
}
}
}


/* lambda1074_1816 */obj_t lambda1074_1816___match_descriptions(obj_t env_2491, obj_t x_2495)
{
{
obj_t pt_2492;
obj_t fn_2493;
obj_t im_2494;
pt_2492 = PROCEDURE_REF(env_2491, ((long)0));
fn_2493 = PROCEDURE_REF(env_2491, ((long)1));
im_2494 = PROCEDURE_REF(env_2491, ((long)2));
{
obj_t x_1845;
x_1845 = x_2495;
if((x_1845==pt_2492)){
return im_2494;
}
 else {
return PROCEDURE_ENTRY(fn_2493)(fn_2493, x_1845, BEOA);
}
}
}
}


/* lambda1074_1817 */obj_t lambda1074_1817___match_descriptions(obj_t env_2496, obj_t x_2500)
{
{
obj_t pt_2497;
obj_t fn_2498;
obj_t im_2499;
pt_2497 = PROCEDURE_REF(env_2496, ((long)0));
fn_2498 = PROCEDURE_REF(env_2496, ((long)1));
im_2499 = PROCEDURE_REF(env_2496, ((long)2));
{
obj_t x_1874;
x_1874 = x_2500;
if((x_1874==pt_2497)){
return im_2499;
}
 else {
return PROCEDURE_ENTRY(fn_2498)(fn_2498, x_1874, BEOA);
}
}
}
}


/* may-be-a-cons */bool_t may_be_a_cons_83___match_descriptions(obj_t descr_34)
{
may_be_a_cons_83___match_descriptions:
if(equal__25___r4_equivalence_6_2(descr_34, list1852___match_descriptions)){
return ((bool_t)0);
}
 else {
bool_t test_3545;
{
obj_t aux_3546;
aux_3546 = CAR(descr_34);
test_3545 = (aux_3546==symbol1824___match_descriptions);
}
if(test_3545){
bool_t _andtest_1010_739;
{
obj_t aux_3549;
{
obj_t aux_3550;
aux_3550 = CDR(descr_34);
aux_3549 = CAR(aux_3550);
}
_andtest_1010_739 = may_be_a_cons_83___match_descriptions(aux_3549);
}
if(_andtest_1010_739){
obj_t descr_3555;
{
obj_t aux_3556;
{
obj_t aux_3557;
aux_3557 = CDR(descr_34);
aux_3556 = CDR(aux_3557);
}
descr_3555 = CAR(aux_3556);
}
descr_34 = descr_3555;
goto may_be_a_cons_83___match_descriptions;
}
 else {
return ((bool_t)0);
}
}
 else {
return ((bool_t)1);
}
}
}


/* match */obj_t match___match_descriptions(obj_t d_35, obj_t e_36, obj_t env_37, obj_t k_38, obj_t z_39)
{
match___match_descriptions:
{
obj_t case_value_58_743;
case_value_58_743 = CAR(d_35);
if((case_value_58_743==symbol1835___match_descriptions)){
return PROCEDURE_ENTRY(k_38)(k_38, env_37, BEOA);
}
 else {
if((case_value_58_743==symbol1842___match_descriptions)){
bool_t test_3568;
{
obj_t aux_3569;
{
obj_t aux_3570;
aux_3570 = CDR(d_35);
aux_3569 = CAR(aux_3570);
}
test_3568 = (e_36==aux_3569);
}
if(test_3568){
return PROCEDURE_ENTRY(k_38)(k_38, env_37, BEOA);
}
 else {
return PROCEDURE_ENTRY(z_39)(z_39, env_37, BEOA);
}
}
 else {
if((case_value_58_743==symbol1824___match_descriptions)){
obj_t arg1395_749;
{
obj_t aux_3580;
aux_3580 = CDR(d_35);
arg1395_749 = CAR(aux_3580);
}
{
obj_t arg1396_2501;
arg1396_2501 = make_fx_procedure(arg1396___match_descriptions, ((long)1), ((long)4));
PROCEDURE_SET(arg1396_2501, ((long)0), d_35);
PROCEDURE_SET(arg1396_2501, ((long)1), e_36);
PROCEDURE_SET(arg1396_2501, ((long)2), k_38);
PROCEDURE_SET(arg1396_2501, ((long)3), z_39);
{
obj_t k_3589;
obj_t d_3588;
d_3588 = arg1395_749;
k_3589 = arg1396_2501;
k_38 = k_3589;
d_35 = d_3588;
goto match___match_descriptions;
}
}
}
 else {
if((case_value_58_743==symbol1826___match_descriptions)){
if(PAIRP(e_36)){
obj_t arg1401_757;
obj_t arg1402_758;
{
obj_t aux_3594;
aux_3594 = CDR(d_35);
arg1401_757 = CAR(aux_3594);
}
arg1402_758 = CAR(e_36);
{
obj_t arg1403_2502;
arg1403_2502 = make_fx_procedure(arg1403___match_descriptions, ((long)1), ((long)4));
PROCEDURE_SET(arg1403_2502, ((long)0), d_35);
PROCEDURE_SET(arg1403_2502, ((long)1), e_36);
PROCEDURE_SET(arg1403_2502, ((long)2), k_38);
PROCEDURE_SET(arg1403_2502, ((long)3), z_39);
{
obj_t k_3605;
obj_t e_3604;
obj_t d_3603;
d_3603 = arg1401_757;
e_3604 = arg1402_758;
k_3605 = arg1403_2502;
k_38 = k_3605;
e_36 = e_3604;
d_35 = d_3603;
goto match___match_descriptions;
}
}
}
 else {
return PROCEDURE_ENTRY(z_39)(z_39, env_37, BEOA);
}
}
 else {
if((case_value_58_743==symbol1839___match_descriptions)){
bool_t test_3610;
{
obj_t aux_3611;
{
obj_t aux_3612;
{
obj_t aux_3613;
aux_3613 = CDR(d_35);
aux_3612 = CAR(aux_3613);
}
aux_3611 = CAR(aux_3612);
}
test_3610 = (aux_3611==symbol1831___match_descriptions);
}
if(test_3610){
obj_t s_767;
s_767 = PROCEDURE_ENTRY(jim_gensym_58___match_s2cfun)(jim_gensym_58___match_s2cfun, string1854___match_descriptions, BEOA);
{
obj_t arg1410_768;
{
obj_t arg1411_769;
obj_t arg1413_770;
{
obj_t aux_3620;
{
obj_t aux_3621;
{
obj_t aux_3622;
aux_3622 = CDR(d_35);
aux_3621 = CAR(aux_3622);
}
aux_3620 = CDR(aux_3621);
}
arg1411_769 = CAR(aux_3620);
}
{
obj_t arg1414_771;
obj_t arg1415_772;
arg1414_771 = symbol1839___match_descriptions;
{
obj_t arg1421_777;
obj_t arg1423_778;
arg1421_777 = symbol1842___match_descriptions;
arg1423_778 = symbol1855___match_descriptions;
{
obj_t list1427_780;
{
obj_t arg1428_781;
arg1428_781 = MAKE_PAIR(BNIL, BNIL);
list1427_780 = MAKE_PAIR(arg1423_778, arg1428_781);
}
arg1415_772 = cons__138___r4_pairs_and_lists_6_3(arg1421_777, list1427_780);
}
}
{
obj_t list1417_774;
{
obj_t arg1418_775;
arg1418_775 = MAKE_PAIR(BNIL, BNIL);
list1417_774 = MAKE_PAIR(arg1415_772, arg1418_775);
}
arg1413_770 = cons__138___r4_pairs_and_lists_6_3(arg1414_771, list1417_774);
}
}
{
obj_t lambda1074_2503;
lambda1074_2503 = make_fx_procedure(lambda1074_1818___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2503, ((long)0), arg1411_769);
PROCEDURE_SET(lambda1074_2503, ((long)1), env_37);
PROCEDURE_SET(lambda1074_2503, ((long)2), arg1413_770);
arg1410_768 = lambda1074_2503;
}
}
return PROCEDURE_ENTRY(k_38)(k_38, arg1410_768, BEOA);
}
}
 else {
obj_t z_3644;
obj_t k_3643;
obj_t d_3639;
{
obj_t aux_3640;
aux_3640 = CDR(d_35);
d_3639 = CAR(aux_3640);
}
k_3643 = z_39;
z_3644 = k_38;
z_39 = z_3644;
k_38 = k_3643;
d_35 = d_3639;
goto match___match_descriptions;
}
}
 else {
if((case_value_58_743==symbol1832___match_descriptions)){
obj_t fun1439_788;
{
obj_t aux_3653;
obj_t aux_3647;
{
obj_t aux_3654;
{
obj_t aux_3655;
aux_3655 = CDR(e_36);
aux_3654 = CDR(aux_3655);
}
aux_3653 = CAR(aux_3654);
}
{
obj_t aux_3648;
{
obj_t aux_3649;
aux_3649 = CDR(d_35);
aux_3648 = CDR(aux_3649);
}
aux_3647 = CAR(aux_3648);
}
fun1439_788 = match___match_descriptions(aux_3647, aux_3653, env_37, k_38, z_39);
}
return PROCEDURE_ENTRY(fun1439_788)(fun1439_788, BINT(((long)0)), BEOA);
}
 else {
if((case_value_58_743==symbol1827___match_descriptions)){
obj_t lambda1443_2505;
lambda1443_2505 = make_fx_procedure(lambda1443___match_descriptions, ((long)1), ((long)5));
PROCEDURE_SET(lambda1443_2505, ((long)0), e_36);
PROCEDURE_SET(lambda1443_2505, ((long)1), d_35);
PROCEDURE_SET(lambda1443_2505, ((long)2), k_38);
PROCEDURE_SET(lambda1443_2505, ((long)3), z_39);
PROCEDURE_SET(lambda1443_2505, ((long)4), env_37);
return lambda1443_2505;
}
 else {
if((case_value_58_743==symbol1833___match_descriptions)){
obj_t lambda1460_2506;
lambda1460_2506 = make_fx_procedure(lambda1460___match_descriptions, ((long)1), ((long)2));
PROCEDURE_SET(lambda1460_2506, ((long)0), k_38);
PROCEDURE_SET(lambda1460_2506, ((long)1), env_37);
return lambda1460_2506;
}
 else {
if((case_value_58_743==symbol1831___match_descriptions)){
bool_t test1462_811;
{
obj_t arg1468_817;
{
obj_t aux_3678;
{
obj_t aux_3679;
aux_3679 = CDR(d_35);
aux_3678 = CAR(aux_3679);
}
arg1468_817 = PROCEDURE_ENTRY(env_37)(env_37, aux_3678, BEOA);
}
test1462_811 = (arg1468_817==symbol1849___match_descriptions);
}
if(test1462_811){
obj_t arg1463_812;
{
obj_t arg1464_813;
{
obj_t aux_3686;
aux_3686 = CDR(d_35);
arg1464_813 = CAR(aux_3686);
}
{
obj_t lambda1074_2507;
lambda1074_2507 = make_fx_procedure(lambda1074_1819___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2507, ((long)0), arg1464_813);
PROCEDURE_SET(lambda1074_2507, ((long)1), env_37);
PROCEDURE_SET(lambda1074_2507, ((long)2), e_36);
arg1463_812 = lambda1074_2507;
}
}
return PROCEDURE_ENTRY(k_38)(k_38, arg1463_812, BEOA);
}
 else {
bool_t test1465_814;
{
obj_t arg1466_815;
{
obj_t aux_3695;
{
obj_t aux_3696;
aux_3696 = CDR(d_35);
aux_3695 = CAR(aux_3696);
}
arg1466_815 = PROCEDURE_ENTRY(env_37)(env_37, aux_3695, BEOA);
}
test1465_814 = (arg1466_815==e_36);
}
if(test1465_814){
return PROCEDURE_ENTRY(k_38)(k_38, env_37, BEOA);
}
 else {
return PROCEDURE_ENTRY(z_39)(z_39, env_37, BEOA);
}
}
}
 else {
return BFALSE;
}
}
}
}
}
}
}
}
}
}
}


/* arg1396 */obj_t arg1396___match_descriptions(obj_t env_2508, obj_t env_2513)
{
{
obj_t d_2509;
obj_t e_2510;
obj_t k_2511;
obj_t z_2512;
d_2509 = PROCEDURE_REF(env_2508, ((long)0));
e_2510 = PROCEDURE_REF(env_2508, ((long)1));
k_2511 = PROCEDURE_REF(env_2508, ((long)2));
z_2512 = PROCEDURE_REF(env_2508, ((long)3));
{
obj_t env_751;
env_751 = env_2513;
{
obj_t aux_3711;
{
obj_t aux_3712;
{
obj_t aux_3713;
aux_3713 = CDR(d_2509);
aux_3712 = CDR(aux_3713);
}
aux_3711 = CAR(aux_3712);
}
return match___match_descriptions(aux_3711, e_2510, env_751, k_2511, z_2512);
}
}
}
}


/* arg1403 */obj_t arg1403___match_descriptions(obj_t env_2514, obj_t env_2519)
{
{
obj_t d_2515;
obj_t e_2516;
obj_t k_2517;
obj_t z_2518;
d_2515 = PROCEDURE_REF(env_2514, ((long)0));
e_2516 = PROCEDURE_REF(env_2514, ((long)1));
k_2517 = PROCEDURE_REF(env_2514, ((long)2));
z_2518 = PROCEDURE_REF(env_2514, ((long)3));
{
obj_t env_760;
env_760 = env_2519;
{
obj_t aux_3722;
{
obj_t aux_3723;
{
obj_t aux_3724;
aux_3724 = CDR(d_2515);
aux_3723 = CDR(aux_3724);
}
aux_3722 = CAR(aux_3723);
}
return match___match_descriptions(aux_3722, CDR(e_2516), env_760, k_2517, z_2518);
}
}
}
}


/* lambda1074_1818 */obj_t lambda1074_1818___match_descriptions(obj_t env_2520, obj_t x_2524)
{
{
obj_t pt_2521;
obj_t fn_2522;
obj_t im_2523;
pt_2521 = PROCEDURE_REF(env_2520, ((long)0));
fn_2522 = PROCEDURE_REF(env_2520, ((long)1));
im_2523 = PROCEDURE_REF(env_2520, ((long)2));
{
obj_t x_1998;
x_1998 = x_2524;
if((x_1998==pt_2521)){
return im_2523;
}
 else {
return PROCEDURE_ENTRY(fn_2522)(fn_2522, x_1998, BEOA);
}
}
}
}


/* lambda1443 */obj_t lambda1443___match_descriptions(obj_t env_2525, obj_t i_2531)
{
{
obj_t e_2526;
obj_t d_2527;
obj_t k_2528;
obj_t z_2529;
obj_t env_2530;
e_2526 = PROCEDURE_REF(env_2525, ((long)0));
d_2527 = PROCEDURE_REF(env_2525, ((long)1));
k_2528 = PROCEDURE_REF(env_2525, ((long)2));
z_2529 = PROCEDURE_REF(env_2525, ((long)3));
env_2530 = PROCEDURE_REF(env_2525, ((long)4));
{
obj_t i_793;
i_793 = i_2531;
{
bool_t test_3742;
{
long aux_3745;
long aux_3743;
aux_3745 = VECTOR_LENGTH(e_2526);
aux_3743 = (long)CINT(i_793);
test_3742 = (aux_3743>=aux_3745);
}
if(test_3742){
return PROCEDURE_ENTRY(k_2528)(k_2528, env_2530, BEOA);
}
 else {
obj_t arg1446_796;
obj_t arg1448_797;
{
obj_t aux_3750;
aux_3750 = CDR(d_2527);
arg1446_796 = CAR(aux_3750);
}
{
long aux_3753;
aux_3753 = (long)CINT(i_793);
arg1448_797 = VECTOR_REF(e_2526, aux_3753);
}
{
obj_t arg1449_2504;
arg1449_2504 = make_fx_procedure(arg1449___match_descriptions, ((long)1), ((long)5));
PROCEDURE_SET(arg1449_2504, ((long)0), d_2527);
PROCEDURE_SET(arg1449_2504, ((long)1), e_2526);
PROCEDURE_SET(arg1449_2504, ((long)2), k_2528);
PROCEDURE_SET(arg1449_2504, ((long)3), z_2529);
PROCEDURE_SET(arg1449_2504, ((long)4), i_793);
return compare___match_descriptions(arg1446_796, arg1448_797, env_2530, arg1449_2504, z_2529);
}
}
}
}
}
}


/* arg1449 */obj_t arg1449___match_descriptions(obj_t env_2532, obj_t env_2538)
{
{
obj_t d_2533;
obj_t e_2534;
obj_t k_2535;
obj_t z_2536;
obj_t i_2537;
d_2533 = PROCEDURE_REF(env_2532, ((long)0));
e_2534 = PROCEDURE_REF(env_2532, ((long)1));
k_2535 = PROCEDURE_REF(env_2532, ((long)2));
z_2536 = PROCEDURE_REF(env_2532, ((long)3));
i_2537 = PROCEDURE_REF(env_2532, ((long)4));
{
obj_t env_799;
env_799 = env_2538;
{
obj_t fun1455_2032;
{
obj_t aux_3768;
{
obj_t aux_3769;
{
obj_t aux_3770;
aux_3770 = CDR(d_2533);
aux_3769 = CDR(aux_3770);
}
aux_3768 = CAR(aux_3769);
}
fun1455_2032 = match___match_descriptions(aux_3768, e_2534, env_799, k_2535, z_2536);
}
{
obj_t aux_3775;
{
long aux_3776;
{
long aux_3777;
aux_3777 = (long)CINT(i_2537);
aux_3776 = (aux_3777+((long)1));
}
aux_3775 = BINT(aux_3776);
}
return PROCEDURE_ENTRY(fun1455_2032)(fun1455_2032, aux_3775, BEOA);
}
}
}
}
}


/* lambda1460 */obj_t lambda1460___match_descriptions(obj_t env_2539, obj_t i_2542)
{
{
obj_t k_2540;
obj_t env_2541;
k_2540 = PROCEDURE_REF(env_2539, ((long)0));
env_2541 = PROCEDURE_REF(env_2539, ((long)1));
{
obj_t i_808;
i_808 = i_2542;
return PROCEDURE_ENTRY(k_2540)(k_2540, env_2541, BEOA);
}
}
}


/* lambda1074_1819 */obj_t lambda1074_1819___match_descriptions(obj_t env_2543, obj_t x_2547)
{
{
obj_t pt_2544;
obj_t fn_2545;
obj_t im_2546;
pt_2544 = PROCEDURE_REF(env_2543, ((long)0));
fn_2545 = PROCEDURE_REF(env_2543, ((long)1));
im_2546 = PROCEDURE_REF(env_2543, ((long)2));
{
obj_t x_2061;
x_2061 = x_2547;
if((x_2061==pt_2544)){
return im_2546;
}
 else {
return PROCEDURE_ENTRY(fn_2545)(fn_2545, x_2061, BEOA);
}
}
}
}


/* alpha-convert */obj_t alpha_convert_60___match_descriptions(obj_t f_40)
{
{
obj_t arg1483_2552;
obj_t arg1481_2553;
arg1483_2552 = proc1856___match_descriptions;
arg1481_2553 = proc1857___match_descriptions;
return loop___match_descriptions(f_40, arg1481_2553, arg1483_2552);
}
}


/* loop */obj_t loop___match_descriptions(obj_t f_829, obj_t env_830, obj_t k_831)
{
loop___match_descriptions:
{
bool_t test_3795;
if(BOOLEANP(f_829)){
test_3795 = ((bool_t)1);
}
 else {
if(SYMBOLP(f_829)){
test_3795 = ((bool_t)1);
}
 else {
if(STRINGP(f_829)){
test_3795 = ((bool_t)1);
}
 else {
test_3795 = INTEGERP(f_829);
}
}
}
if(test_3795){
return PROCEDURE_ENTRY(k_831)(k_831, f_829, env_830, BEOA);
}
 else {
if(NULLP(f_829)){
return PROCEDURE_ENTRY(k_831)(k_831, f_829, env_830, BEOA);
}
 else {
bool_t test_3809;
{
obj_t aux_3810;
aux_3810 = CAR(f_829);
test_3809 = (aux_3810==symbol1842___match_descriptions);
}
if(test_3809){
return PROCEDURE_ENTRY(k_831)(k_831, f_829, env_830, BEOA);
}
 else {
bool_t test_3815;
{
obj_t aux_3816;
aux_3816 = CAR(f_829);
test_3815 = (aux_3816==symbol1831___match_descriptions);
}
if(test_3815){
{
bool_t test1490_846;
{
obj_t arg1511_862;
{
obj_t aux_3819;
{
obj_t aux_3820;
aux_3820 = CDR(f_829);
aux_3819 = CAR(aux_3820);
}
arg1511_862 = PROCEDURE_ENTRY(env_830)(env_830, aux_3819, BEOA);
}
test1490_846 = (arg1511_862==symbol1849___match_descriptions);
}
if(test1490_846){
obj_t s_847;
s_847 = PROCEDURE_ENTRY(jim_gensym_58___match_s2cfun)(jim_gensym_58___match_s2cfun, BEOA);
{
obj_t arg1491_848;
obj_t arg1494_849;
{
obj_t arg1496_850;
arg1496_850 = symbol1831___match_descriptions;
{
obj_t list1497_851;
{
obj_t arg1498_852;
arg1498_852 = MAKE_PAIR(s_847, BNIL);
list1497_851 = MAKE_PAIR(arg1496_850, arg1498_852);
}
arg1491_848 = list1497_851;
}
}
{
obj_t arg1500_854;
{
obj_t aux_3831;
aux_3831 = CDR(f_829);
arg1500_854 = CAR(aux_3831);
}
{
obj_t lambda1074_2548;
lambda1074_2548 = make_fx_procedure(lambda1074_1820___match_descriptions, ((long)1), ((long)3));
PROCEDURE_SET(lambda1074_2548, ((long)0), arg1500_854);
PROCEDURE_SET(lambda1074_2548, ((long)1), env_830);
PROCEDURE_SET(lambda1074_2548, ((long)2), s_847);
arg1494_849 = lambda1074_2548;
}
}
return PROCEDURE_ENTRY(k_831)(k_831, arg1491_848, arg1494_849, BEOA);
}
}
 else {
obj_t arg1501_855;
{
obj_t arg1502_856;
obj_t arg1503_857;
arg1502_856 = symbol1831___match_descriptions;
{
obj_t aux_3840;
{
obj_t aux_3841;
aux_3841 = CDR(f_829);
aux_3840 = CAR(aux_3841);
}
arg1503_857 = PROCEDURE_ENTRY(env_830)(env_830, aux_3840, BEOA);
}
{
obj_t list1504_858;
{
obj_t arg1505_859;
arg1505_859 = MAKE_PAIR(arg1503_857, BNIL);
list1504_858 = MAKE_PAIR(arg1502_856, arg1505_859);
}
arg1501_855 = list1504_858;
}
}
return PROCEDURE_ENTRY(k_831)(k_831, arg1501_855, env_830, BEOA);
}
}
}
 else {
{
obj_t arg1515_865;
arg1515_865 = CAR(f_829);
{
obj_t arg1516_2550;
arg1516_2550 = make_fx_procedure(arg1516___match_descriptions, ((long)2), ((long)2));
PROCEDURE_SET(arg1516_2550, ((long)0), f_829);
PROCEDURE_SET(arg1516_2550, ((long)1), k_831);
{
obj_t k_3855;
obj_t f_3854;
f_3854 = arg1515_865;
k_3855 = arg1516_2550;
k_831 = k_3855;
f_829 = f_3854;
goto loop___match_descriptions;
}
}
}
}
}
}
}
}
}


/* arg1483 */obj_t arg1483___match_descriptions(obj_t env_2554, obj_t f_2555, obj_t e_2556)
{
{
obj_t f_2633;
f_2633 = f_2555;
return f_2633;
}
}


/* arg1481 */obj_t arg1481___match_descriptions(obj_t env_2557, obj_t x_2558)
{
return symbol1849___match_descriptions;
}


/* lambda1074_1820 */obj_t lambda1074_1820___match_descriptions(obj_t env_2559, obj_t x_2563)
{
{
obj_t pt_2560;
obj_t fn_2561;
obj_t im_2562;
pt_2560 = PROCEDURE_REF(env_2559, ((long)0));
fn_2561 = PROCEDURE_REF(env_2559, ((long)1));
im_2562 = PROCEDURE_REF(env_2559, ((long)2));
{
obj_t x_2098;
x_2098 = x_2563;
if((x_2098==pt_2560)){
return im_2562;
}
 else {
return PROCEDURE_ENTRY(fn_2561)(fn_2561, x_2098, BEOA);
}
}
}
}


/* arg1516 */obj_t arg1516___match_descriptions(obj_t env_2564, obj_t fcar_2567, obj_t e_2568)
{
{
obj_t f_2565;
obj_t k_2566;
f_2565 = PROCEDURE_REF(env_2564, ((long)0));
k_2566 = PROCEDURE_REF(env_2564, ((long)1));
{
obj_t fcar_867;
obj_t e_868;
fcar_867 = fcar_2567;
e_868 = e_2568;
{
obj_t arg1518_2109;
arg1518_2109 = CDR(f_2565);
{
obj_t arg1519_2549;
arg1519_2549 = make_fx_procedure(arg1519___match_descriptions, ((long)2), ((long)2));
PROCEDURE_SET(arg1519_2549, ((long)0), fcar_867);
PROCEDURE_SET(arg1519_2549, ((long)1), k_2566);
return loop___match_descriptions(arg1518_2109, e_868, arg1519_2549);
}
}
}
}
}


/* arg1519 */obj_t arg1519___match_descriptions(obj_t env_2569, obj_t fcdr_2572, obj_t e_2573)
{
{
obj_t fcar_2570;
obj_t k_2571;
fcar_2570 = PROCEDURE_REF(env_2569, ((long)0));
k_2571 = PROCEDURE_REF(env_2569, ((long)1));
{
obj_t fcdr_2111;
obj_t e_2112;
fcdr_2111 = fcdr_2572;
e_2112 = e_2573;
{
obj_t arg1522_2115;
arg1522_2115 = MAKE_PAIR(fcar_2570, fcdr_2111);
return PROCEDURE_ENTRY(k_2571)(k_2571, arg1522_2115, e_2112, BEOA);
}
}
}
}


/* isany? */obj_t isany__223___match_descriptions(obj_t c_41)
{
{
bool_t test_3875;
{
obj_t aux_3876;
aux_3876 = CAR(c_41);
test_3875 = (aux_3876==symbol1835___match_descriptions);
}
if(test_3875){
return BTRUE;
}
 else {
bool_t aux_3879;
{
obj_t aux_3880;
aux_3880 = CAR(c_41);
aux_3879 = (aux_3880==symbol1836___match_descriptions);
}
return BBOOL(aux_3879);
}
}
}


/* _isany? */obj_t _isany__3___match_descriptions(obj_t env_2574, obj_t c_2575)
{
{
obj_t c_2636;
c_2636 = c_2575;
{
bool_t test_3884;
{
obj_t aux_3885;
aux_3885 = CAR(c_2636);
test_3884 = (aux_3885==symbol1835___match_descriptions);
}
if(test_3884){
return BTRUE;
}
 else {
bool_t aux_3888;
{
obj_t aux_3889;
aux_3889 = CAR(c_2636);
aux_3888 = (aux_3889==symbol1836___match_descriptions);
}
return BBOOL(aux_3888);
}
}
}
}


/* ischeck? */obj_t ischeck__51___match_descriptions(obj_t c_42)
{
{
bool_t aux_3893;
{
obj_t aux_3894;
aux_3894 = CAR(c_42);
aux_3893 = (aux_3894==symbol1836___match_descriptions);
}
return BBOOL(aux_3893);
}
}


/* _ischeck? */obj_t _ischeck__24___match_descriptions(obj_t env_2576, obj_t c_2577)
{
{
obj_t c_2637;
c_2637 = c_2577;
{
bool_t aux_3898;
{
obj_t aux_3899;
aux_3899 = CAR(c_2637);
aux_3898 = (aux_3899==symbol1836___match_descriptions);
}
return BBOOL(aux_3898);
}
}
}


/* issuccess? */obj_t issuccess__169___match_descriptions(obj_t c_43)
{
{
bool_t aux_3903;
{
obj_t aux_3904;
aux_3904 = CAR(c_43);
aux_3903 = (aux_3904==symbol1841___match_descriptions);
}
return BBOOL(aux_3903);
}
}


/* _issuccess? */obj_t _issuccess__90___match_descriptions(obj_t env_2578, obj_t c_2579)
{
{
obj_t c_2638;
c_2638 = c_2579;
{
bool_t aux_3908;
{
obj_t aux_3909;
aux_3909 = CAR(c_2638);
aux_3908 = (aux_3909==symbol1841___match_descriptions);
}
return BBOOL(aux_3908);
}
}
}


/* istop? */obj_t istop__3___match_descriptions(obj_t c_44)
{
{
bool_t aux_3913;
{
obj_t aux_3914;
aux_3914 = CAR(c_44);
aux_3913 = (aux_3914==symbol1858___match_descriptions);
}
return BBOOL(aux_3913);
}
}


/* _istop? */obj_t _istop__15___match_descriptions(obj_t env_2580, obj_t c_2581)
{
{
obj_t c_2639;
c_2639 = c_2581;
{
bool_t aux_3918;
{
obj_t aux_3919;
aux_3919 = CAR(c_2639);
aux_3918 = (aux_3919==symbol1858___match_descriptions);
}
return BBOOL(aux_3918);
}
}
}


/* isbottom? */obj_t isbottom__165___match_descriptions(obj_t c_45)
{
{
bool_t aux_3923;
{
obj_t aux_3924;
aux_3924 = CAR(c_45);
aux_3923 = (aux_3924==symbol1838___match_descriptions);
}
return BBOOL(aux_3923);
}
}


/* _isbottom? */obj_t _isbottom__80___match_descriptions(obj_t env_2582, obj_t c_2583)
{
{
obj_t c_2640;
c_2640 = c_2583;
{
bool_t aux_3928;
{
obj_t aux_3929;
aux_3929 = CAR(c_2640);
aux_3928 = (aux_3929==symbol1838___match_descriptions);
}
return BBOOL(aux_3928);
}
}
}


/* isquote? */obj_t isquote__86___match_descriptions(obj_t c_46)
{
{
bool_t aux_3933;
{
obj_t aux_3934;
aux_3934 = CAR(c_46);
aux_3933 = (aux_3934==symbol1842___match_descriptions);
}
return BBOOL(aux_3933);
}
}


/* _isquote? */obj_t _isquote__33___match_descriptions(obj_t env_2584, obj_t c_2585)
{
{
obj_t c_2641;
c_2641 = c_2585;
{
bool_t aux_3938;
{
obj_t aux_3939;
aux_3939 = CAR(c_2641);
aux_3938 = (aux_3939==symbol1842___match_descriptions);
}
return BBOOL(aux_3938);
}
}
}


/* isvar? */obj_t isvar__187___match_descriptions(obj_t c_47)
{
{
bool_t aux_3943;
{
obj_t aux_3944;
aux_3944 = CAR(c_47);
aux_3943 = (aux_3944==symbol1831___match_descriptions);
}
return BBOOL(aux_3943);
}
}


/* _isvar? */obj_t _isvar__142___match_descriptions(obj_t env_2586, obj_t c_2587)
{
{
obj_t c_2642;
c_2642 = c_2587;
{
bool_t aux_3948;
{
obj_t aux_3949;
aux_3949 = CAR(c_2642);
aux_3948 = (aux_3949==symbol1831___match_descriptions);
}
return BBOOL(aux_3948);
}
}
}


/* isnot? */obj_t isnot__52___match_descriptions(obj_t c_48)
{
{
bool_t aux_3953;
{
obj_t aux_3954;
aux_3954 = CAR(c_48);
aux_3953 = (aux_3954==symbol1839___match_descriptions);
}
return BBOOL(aux_3953);
}
}


/* _isnot? */obj_t _isnot__30___match_descriptions(obj_t env_2588, obj_t c_2589)
{
{
obj_t c_2643;
c_2643 = c_2589;
{
bool_t aux_3958;
{
obj_t aux_3959;
aux_3959 = CAR(c_2643);
aux_3958 = (aux_3959==symbol1839___match_descriptions);
}
return BBOOL(aux_3958);
}
}
}


/* isand? */obj_t isand__129___match_descriptions(obj_t c_49)
{
{
bool_t aux_3963;
{
obj_t aux_3964;
aux_3964 = CAR(c_49);
aux_3963 = (aux_3964==symbol1824___match_descriptions);
}
return BBOOL(aux_3963);
}
}


/* _isand? */obj_t _isand__170___match_descriptions(obj_t env_2590, obj_t c_2591)
{
{
obj_t c_2644;
c_2644 = c_2591;
{
bool_t aux_3968;
{
obj_t aux_3969;
aux_3969 = CAR(c_2644);
aux_3968 = (aux_3969==symbol1824___match_descriptions);
}
return BBOOL(aux_3968);
}
}
}


/* isor? */obj_t isor__51___match_descriptions(obj_t c_50)
{
{
bool_t aux_3973;
{
obj_t aux_3974;
aux_3974 = CAR(c_50);
aux_3973 = (aux_3974==symbol1822___match_descriptions);
}
return BBOOL(aux_3973);
}
}


/* _isor? */obj_t _isor__138___match_descriptions(obj_t env_2592, obj_t c_2593)
{
{
obj_t c_2645;
c_2645 = c_2593;
{
bool_t aux_3978;
{
obj_t aux_3979;
aux_3979 = CAR(c_2645);
aux_3978 = (aux_3979==symbol1822___match_descriptions);
}
return BBOOL(aux_3978);
}
}
}


/* ist-or? */obj_t ist_or__144___match_descriptions(obj_t c_51)
{
{
bool_t aux_3983;
{
obj_t aux_3984;
aux_3984 = CAR(c_51);
aux_3983 = (aux_3984==symbol1823___match_descriptions);
}
return BBOOL(aux_3983);
}
}


/* _ist-or? */obj_t _ist_or__100___match_descriptions(obj_t env_2594, obj_t c_2595)
{
{
obj_t c_2646;
c_2646 = c_2595;
{
bool_t aux_3988;
{
obj_t aux_3989;
aux_3989 = CAR(c_2646);
aux_3988 = (aux_3989==symbol1823___match_descriptions);
}
return BBOOL(aux_3988);
}
}
}


/* istagged-or? */obj_t istagged_or__239___match_descriptions(obj_t c_52)
{
{
bool_t aux_3993;
{
obj_t aux_3994;
aux_3994 = CAR(c_52);
aux_3993 = (aux_3994==symbol1850___match_descriptions);
}
return BBOOL(aux_3993);
}
}


/* _istagged-or? */obj_t _istagged_or__215___match_descriptions(obj_t env_2596, obj_t c_2597)
{
{
obj_t c_2647;
c_2647 = c_2597;
{
bool_t aux_3998;
{
obj_t aux_3999;
aux_3999 = CAR(c_2647);
aux_3998 = (aux_3999==symbol1850___match_descriptions);
}
return BBOOL(aux_3998);
}
}
}


/* iscons? */obj_t iscons__156___match_descriptions(obj_t c_53)
{
{
bool_t aux_4003;
{
obj_t aux_4004;
aux_4004 = CAR(c_53);
aux_4003 = (aux_4004==symbol1826___match_descriptions);
}
return BBOOL(aux_4003);
}
}


/* _iscons? */obj_t _iscons__14___match_descriptions(obj_t env_2598, obj_t c_2599)
{
{
obj_t c_2648;
c_2648 = c_2599;
{
bool_t aux_4008;
{
obj_t aux_4009;
aux_4009 = CAR(c_2648);
aux_4008 = (aux_4009==symbol1826___match_descriptions);
}
return BBOOL(aux_4008);
}
}
}


/* isacons? */obj_t isacons__251___match_descriptions(obj_t c_54)
{
{
bool_t aux_4013;
{
obj_t aux_4014;
aux_4014 = CAR(c_54);
aux_4013 = (aux_4014==symbol1844___match_descriptions);
}
return BBOOL(aux_4013);
}
}


/* _isacons? */obj_t _isacons__206___match_descriptions(obj_t env_2600, obj_t c_2601)
{
{
obj_t c_2649;
c_2649 = c_2601;
{
bool_t aux_4018;
{
obj_t aux_4019;
aux_4019 = CAR(c_2649);
aux_4018 = (aux_4019==symbol1844___match_descriptions);
}
return BBOOL(aux_4018);
}
}
}


/* isxcons? */obj_t isxcons__163___match_descriptions(obj_t c_55)
{
{
bool_t aux_4023;
{
obj_t aux_4024;
aux_4024 = CAR(c_55);
aux_4023 = (aux_4024==symbol1845___match_descriptions);
}
return BBOOL(aux_4023);
}
}


/* _isxcons? */obj_t _isxcons__204___match_descriptions(obj_t env_2602, obj_t c_2603)
{
{
obj_t c_2650;
c_2650 = c_2603;
{
bool_t aux_4028;
{
obj_t aux_4029;
aux_4029 = CAR(c_2650);
aux_4028 = (aux_4029==symbol1845___match_descriptions);
}
return BBOOL(aux_4028);
}
}
}


/* istimes? */obj_t istimes__212___match_descriptions(obj_t c_56)
{
{
bool_t aux_4033;
{
obj_t aux_4034;
aux_4034 = CAR(c_56);
aux_4033 = (aux_4034==symbol1830___match_descriptions);
}
return BBOOL(aux_4033);
}
}


/* _istimes? */obj_t _istimes__40___match_descriptions(obj_t env_2604, obj_t c_2605)
{
{
obj_t c_2651;
c_2651 = c_2605;
{
bool_t aux_4038;
{
obj_t aux_4039;
aux_4039 = CAR(c_2651);
aux_4038 = (aux_4039==symbol1830___match_descriptions);
}
return BBOOL(aux_4038);
}
}
}


/* containshole? */obj_t containshole__101___match_descriptions(obj_t c_57)
{
{
bool_t aux_4043;
{
obj_t aux_4044;
aux_4044 = CAR(c_57);
aux_4043 = (aux_4044==symbol1859___match_descriptions);
}
return BBOOL(aux_4043);
}
}


/* _containshole? */obj_t _containshole__39___match_descriptions(obj_t env_2606, obj_t c_2607)
{
{
obj_t c_2652;
c_2652 = c_2607;
{
bool_t aux_4048;
{
obj_t aux_4049;
aux_4049 = CAR(c_2652);
aux_4048 = (aux_4049==symbol1859___match_descriptions);
}
return BBOOL(aux_4048);
}
}
}


/* ishole? */obj_t ishole__108___match_descriptions(obj_t c_58)
{
{
bool_t aux_4053;
{
obj_t aux_4054;
aux_4054 = CAR(c_58);
aux_4053 = (aux_4054==symbol1859___match_descriptions);
}
return BBOOL(aux_4053);
}
}


/* _ishole? */obj_t _ishole__253___match_descriptions(obj_t env_2608, obj_t c_2609)
{
{
obj_t c_2653;
c_2653 = c_2609;
{
bool_t aux_4058;
{
obj_t aux_4059;
aux_4059 = CAR(c_2653);
aux_4058 = (aux_4059==symbol1859___match_descriptions);
}
return BBOOL(aux_4058);
}
}
}


/* istree? */obj_t istree__46___match_descriptions(obj_t c_59)
{
{
bool_t aux_4063;
{
obj_t aux_4064;
aux_4064 = CAR(c_59);
aux_4063 = (aux_4064==symbol1829___match_descriptions);
}
return BBOOL(aux_4063);
}
}


/* _istree? */obj_t _istree__196___match_descriptions(obj_t env_2610, obj_t c_2611)
{
{
obj_t c_2654;
c_2654 = c_2611;
{
bool_t aux_4068;
{
obj_t aux_4069;
aux_4069 = CAR(c_2654);
aux_4068 = (aux_4069==symbol1829___match_descriptions);
}
return BBOOL(aux_4068);
}
}
}


/* isvector? */obj_t isvector__54___match_descriptions(obj_t c_60)
{
{
bool_t aux_4073;
{
obj_t aux_4074;
aux_4074 = CAR(c_60);
aux_4073 = (aux_4074==symbol1851___match_descriptions);
}
return BBOOL(aux_4073);
}
}


/* _isvector? */obj_t _isvector__152___match_descriptions(obj_t env_2612, obj_t c_2613)
{
{
obj_t c_2655;
c_2655 = c_2613;
{
bool_t aux_4078;
{
obj_t aux_4079;
aux_4079 = CAR(c_2655);
aux_4078 = (aux_4079==symbol1851___match_descriptions);
}
return BBOOL(aux_4078);
}
}
}


/* isvector-begin? */obj_t isvector_begin__5___match_descriptions(obj_t c_61)
{
{
bool_t aux_4083;
{
obj_t aux_4084;
aux_4084 = CAR(c_61);
aux_4083 = (aux_4084==symbol1832___match_descriptions);
}
return BBOOL(aux_4083);
}
}


/* _isvector-begin? */obj_t _isvector_begin__0___match_descriptions(obj_t env_2614, obj_t c_2615)
{
{
obj_t c_2656;
c_2656 = c_2615;
{
bool_t aux_4088;
{
obj_t aux_4089;
aux_4089 = CAR(c_2656);
aux_4088 = (aux_4089==symbol1832___match_descriptions);
}
return BBOOL(aux_4088);
}
}
}


/* isvector-end? */obj_t isvector_end__41___match_descriptions(obj_t c_62)
{
{
bool_t aux_4093;
{
obj_t aux_4094;
aux_4094 = CAR(c_62);
aux_4093 = (aux_4094==symbol1833___match_descriptions);
}
return BBOOL(aux_4093);
}
}


/* _isvector-end? */obj_t _isvector_end__197___match_descriptions(obj_t env_2616, obj_t c_2617)
{
{
obj_t c_2657;
c_2657 = c_2617;
{
bool_t aux_4098;
{
obj_t aux_4099;
aux_4099 = CAR(c_2657);
aux_4098 = (aux_4099==symbol1833___match_descriptions);
}
return BBOOL(aux_4098);
}
}
}


/* vector-plus */obj_t vector_plus_240___match_descriptions(obj_t v_63, obj_t i_64, obj_t d_65)
{
{
bool_t test_4103;
{
long aux_4106;
long aux_4104;
{
obj_t aux_4107;
{
obj_t aux_4108;
{
obj_t aux_4109;
aux_4109 = CDR(v_63);
aux_4108 = CDR(aux_4109);
}
aux_4107 = CAR(aux_4108);
}
aux_4106 = VECTOR_LENGTH(aux_4107);
}
aux_4104 = (long)CINT(i_64);
test_4103 = (aux_4104>=aux_4106);
}
if(test_4103){
obj_t arg1594_933;
obj_t arg1595_934;
{
obj_t aux_4115;
aux_4115 = CDR(v_63);
arg1594_933 = CDR(aux_4115);
}
{
obj_t arg1598_935;
{
obj_t aux_4118;
{
obj_t aux_4119;
aux_4119 = CDR(v_63);
aux_4118 = CDR(aux_4119);
}
arg1598_935 = CAR(aux_4118);
}
{
obj_t res_2256;
{
obj_t new_vector_234_2257;
{
long aux_4123;
aux_4123 = (long)CINT(i_64);
new_vector_234_2257 = make_vector(aux_4123, list1840___match_descriptions);
}
{
long i_2259;
i_2259 = ((long)0);
loop_2258:
{
bool_t test_4126;
{
long aux_4127;
aux_4127 = VECTOR_LENGTH(arg1598_935);
test_4126 = (i_2259==aux_4127);
}
if(test_4126){
res_2256 = new_vector_234_2257;
}
 else {
{
obj_t aux_4130;
aux_4130 = VECTOR_REF(arg1598_935, i_2259);
VECTOR_SET(new_vector_234_2257, i_2259, aux_4130);
}
{
long i_4133;
i_4133 = (i_2259+((long)1));
i_2259 = i_4133;
goto loop_2258;
}
}
}
}
}
arg1595_934 = res_2256;
}
}
SET_CAR(arg1594_933, arg1595_934);
}
 else {
BTRUE;
}
}
{
obj_t res_939;
{
obj_t arg1609_944;
long arg1610_945;
obj_t arg1612_946;
arg1609_944 = symbol1851___match_descriptions;
{
obj_t aux_4136;
{
obj_t aux_4137;
{
obj_t aux_4138;
aux_4138 = CDR(v_63);
aux_4137 = CDR(aux_4138);
}
aux_4136 = CAR(aux_4137);
}
arg1610_945 = VECTOR_LENGTH(aux_4136);
}
{
obj_t arg1621_953;
{
obj_t aux_4143;
{
obj_t aux_4144;
{
obj_t aux_4145;
aux_4145 = CDR(v_63);
aux_4144 = CDR(aux_4145);
}
aux_4143 = CAR(aux_4144);
}
arg1621_953 = vector__list_155___r4_vectors_6_8(aux_4143);
}
arg1612_946 = list__vector_101___r4_vectors_6_8(arg1621_953);
}
{
obj_t list1614_948;
{
obj_t arg1615_949;
{
obj_t arg1617_950;
arg1617_950 = MAKE_PAIR(BNIL, BNIL);
arg1615_949 = MAKE_PAIR(arg1612_946, arg1617_950);
}
{
obj_t aux_4153;
aux_4153 = BINT(arg1610_945);
list1614_948 = MAKE_PAIR(aux_4153, arg1615_949);
}
}
res_939 = cons__138___r4_pairs_and_lists_6_3(arg1609_944, list1614_948);
}
}
{
obj_t arg1605_940;
obj_t arg1606_941;
{
obj_t aux_4157;
{
obj_t aux_4158;
aux_4158 = CDR(res_939);
aux_4157 = CDR(aux_4158);
}
arg1605_940 = CAR(aux_4157);
}
{
obj_t aux_4162;
{
long aux_4169;
obj_t aux_4163;
aux_4169 = (long)CINT(i_64);
{
obj_t aux_4164;
{
obj_t aux_4165;
aux_4165 = CDR(v_63);
aux_4164 = CDR(aux_4165);
}
aux_4163 = CAR(aux_4164);
}
aux_4162 = VECTOR_REF(aux_4163, aux_4169);
}
arg1606_941 = pattern_plus_250___match_descriptions(aux_4162, d_65);
}
{
long aux_4173;
aux_4173 = (long)CINT(i_64);
VECTOR_SET(arg1605_940, aux_4173, arg1606_941);
}
}
return res_939;
}
}


/* _vector-plus */obj_t _vector_plus_248___match_descriptions(obj_t env_2618, obj_t v_2619, obj_t i_2620, obj_t d_2621)
{
return vector_plus_240___match_descriptions(v_2619, i_2620, d_2621);
}


/* vector-minus */obj_t vector_minus_162___match_descriptions(obj_t v_66, obj_t i_67, obj_t d_68)
{
{
bool_t test_4177;
{
long aux_4180;
long aux_4178;
{
obj_t aux_4181;
{
obj_t aux_4182;
{
obj_t aux_4183;
aux_4183 = CDR(v_66);
aux_4182 = CDR(aux_4183);
}
aux_4181 = CAR(aux_4182);
}
aux_4180 = VECTOR_LENGTH(aux_4181);
}
aux_4178 = (long)CINT(i_67);
test_4177 = (aux_4178>=aux_4180);
}
if(test_4177){
obj_t arg1624_956;
obj_t arg1625_957;
{
obj_t aux_4189;
aux_4189 = CDR(v_66);
arg1624_956 = CDR(aux_4189);
}
{
obj_t arg1627_958;
{
obj_t aux_4192;
{
obj_t aux_4193;
aux_4193 = CDR(v_66);
aux_4192 = CDR(aux_4193);
}
arg1627_958 = CAR(aux_4192);
}
{
obj_t res_2328;
{
obj_t new_vector_234_2329;
{
long aux_4197;
aux_4197 = (long)CINT(i_67);
new_vector_234_2329 = make_vector(aux_4197, list1840___match_descriptions);
}
{
long i_2331;
i_2331 = ((long)0);
loop_2330:
{
bool_t test_4200;
{
long aux_4201;
aux_4201 = VECTOR_LENGTH(arg1627_958);
test_4200 = (i_2331==aux_4201);
}
if(test_4200){
res_2328 = new_vector_234_2329;
}
 else {
{
obj_t aux_4204;
aux_4204 = VECTOR_REF(arg1627_958, i_2331);
VECTOR_SET(new_vector_234_2329, i_2331, aux_4204);
}
{
long i_4207;
i_4207 = (i_2331+((long)1));
i_2331 = i_4207;
goto loop_2330;
}
}
}
}
}
arg1625_957 = res_2328;
}
}
SET_CAR(arg1624_956, arg1625_957);
}
 else {
BTRUE;
}
}
{
obj_t res_962;
{
obj_t arg1639_967;
long arg1640_968;
obj_t arg1641_969;
arg1639_967 = symbol1851___match_descriptions;
{
obj_t aux_4210;
{
obj_t aux_4211;
{
obj_t aux_4212;
aux_4212 = CDR(v_66);
aux_4211 = CDR(aux_4212);
}
aux_4210 = CAR(aux_4211);
}
arg1640_968 = list_length(aux_4210);
}
{
obj_t arg1652_976;
{
obj_t aux_4217;
{
obj_t aux_4218;
{
obj_t aux_4219;
aux_4219 = CDR(v_66);
aux_4218 = CDR(aux_4219);
}
aux_4217 = CAR(aux_4218);
}
arg1652_976 = vector__list_155___r4_vectors_6_8(aux_4217);
}
arg1641_969 = list__vector_101___r4_vectors_6_8(arg1652_976);
}
{
obj_t list1646_971;
{
obj_t arg1647_972;
{
obj_t arg1648_973;
arg1648_973 = MAKE_PAIR(BNIL, BNIL);
arg1647_972 = MAKE_PAIR(arg1641_969, arg1648_973);
}
{
obj_t aux_4227;
aux_4227 = BINT(arg1640_968);
list1646_971 = MAKE_PAIR(aux_4227, arg1647_972);
}
}
res_962 = cons__138___r4_pairs_and_lists_6_3(arg1639_967, list1646_971);
}
}
{
obj_t arg1633_963;
obj_t arg1634_964;
{
obj_t aux_4231;
{
obj_t aux_4232;
aux_4232 = CDR(res_962);
aux_4231 = CDR(aux_4232);
}
arg1633_963 = CAR(aux_4231);
}
{
obj_t aux_4236;
{
long aux_4243;
obj_t aux_4237;
aux_4243 = (long)CINT(i_67);
{
obj_t aux_4238;
{
obj_t aux_4239;
aux_4239 = CDR(v_66);
aux_4238 = CDR(aux_4239);
}
aux_4237 = CAR(aux_4238);
}
aux_4236 = VECTOR_REF(aux_4237, aux_4243);
}
arg1634_964 = pattern_minus_154___match_descriptions(aux_4236, d_68);
}
{
long aux_4247;
aux_4247 = (long)CINT(i_67);
VECTOR_SET(arg1633_963, aux_4247, arg1634_964);
}
}
return res_962;
}
}


/* _vector-minus */obj_t _vector_minus_241___match_descriptions(obj_t env_2622, obj_t v_2623, obj_t i_2624, obj_t d_2625)
{
return vector_minus_162___match_descriptions(v_2623, i_2624, d_2625);
}


/* extend-vector */obj_t extend_vector_160___match_descriptions(obj_t v_69, obj_t lg_70, obj_t fill_71)
{
{
obj_t res_2377;
{
obj_t new_vector_234_2378;
{
long aux_4251;
aux_4251 = (long)CINT(lg_70);
new_vector_234_2378 = make_vector(aux_4251, fill_71);
}
{
long i_2380;
i_2380 = ((long)0);
loop_2379:
{
bool_t test_4254;
{
long aux_4255;
aux_4255 = VECTOR_LENGTH(v_69);
test_4254 = (i_2380==aux_4255);
}
if(test_4254){
res_2377 = new_vector_234_2378;
}
 else {
{
obj_t aux_4258;
aux_4258 = VECTOR_REF(v_69, i_2380);
VECTOR_SET(new_vector_234_2378, i_2380, aux_4258);
}
{
long i_4261;
i_4261 = (i_2380+((long)1));
i_2380 = i_4261;
goto loop_2379;
}
}
}
}
}
return res_2377;
}
}


/* _extend-vector */obj_t _extend_vector_251___match_descriptions(obj_t env_2626, obj_t v_2627, obj_t lg_2628, obj_t fill_2629)
{
return extend_vector_160___match_descriptions(v_2627, lg_2628, fill_2629);
}


/* imported-modules-init */obj_t imported_modules_init_94___match_descriptions()
{
module_initialization_70___error(((long)0), "__MATCH_DESCRIPTIONS");
return module_initialization_70___match_s2cfun(((long)0), "__MATCH_DESCRIPTIONS");
}

