/*===========================================================================*/
/*   (Llib/unicode.scm)                                                      */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

extern obj_t make_ucs2_string(long, ucs2_t);
extern ucs2_t ucs2_string_ref_ur_85___unicode(obj_t, long);
extern obj_t ucs2_string_set__176___unicode(obj_t, long, ucs2_t);
static obj_t _subucs2_string1219_174___unicode(obj_t, obj_t, obj_t, obj_t);
extern obj_t ucs2_string_fill__51___unicode(obj_t, ucs2_t);
static obj_t _make_ucs2_string1203_102___unicode(obj_t, obj_t, obj_t);
extern long ucs2_string_length_125___unicode(obj_t);
static obj_t _subucs2_string_ur1220_182___unicode(obj_t, obj_t, obj_t, obj_t);
extern bool_t ucs2_string____135___unicode(obj_t, obj_t);
static obj_t _ucs2_string_downcase1225_245___unicode(obj_t, obj_t);
extern obj_t subucs2_string_ur_47___unicode(obj_t, long, long);
extern bool_t ucs2_string____33___unicode(obj_t, obj_t);
extern obj_t subucs2_string_27___unicode(obj_t, long, long);
extern bool_t ucs2_string_ci____43___unicode(obj_t, obj_t);
static obj_t _ucs2_string_ref1205_43___unicode(obj_t, obj_t, obj_t);
extern obj_t ucs2_string_copy_207___unicode(obj_t);
static obj_t _ucs2_string_ref_ur1207_194___unicode(obj_t, obj_t, obj_t);
static obj_t _ucs2_string_170___unicode(obj_t, obj_t);
extern obj_t ucs2_string_append(obj_t, obj_t);
static obj_t _ucs2_string_downcase_1227_242___unicode(obj_t, obj_t);
extern obj_t ucs2_string_set_ur__94___unicode(obj_t, long, ucs2_t);
extern bool_t ucs2_string_ci____210___unicode(obj_t, obj_t);
static obj_t loop___unicode(obj_t);
extern bool_t ucs2_string_cilt(obj_t, obj_t);
extern bool_t ucs2_string_cile(obj_t, obj_t);
extern bool_t ucs2_string_cigt(obj_t, obj_t);
extern bool_t ucs2_string_cige(obj_t, obj_t);
extern obj_t ucs2_string_to_utf8_string(obj_t);
extern ucs2_t ucs2_string_ref_239___unicode(obj_t, long);
static obj_t _ucs2_string_ci__1215_180___unicode(obj_t, obj_t, obj_t);
static obj_t _ucs2_string__171___unicode(obj_t, obj_t);
extern obj_t ucs2_string_append_106___unicode(obj_t);
extern obj_t ucs2_string_194___unicode(obj_t);
extern obj_t ucs2_string__utf8_string_192___unicode(obj_t);
extern obj_t module_initialization_70___unicode(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t c_ucs2_string_copy(obj_t);
static obj_t _ucs2_string_append_9___unicode(obj_t, obj_t);
extern bool_t ucs2_string___248___unicode(obj_t, obj_t);
extern bool_t ucs2_string___146___unicode(obj_t, obj_t);
extern bool_t ucs2_string___83___unicode(obj_t, obj_t);
static obj_t _ucs2_string_copy1222_146___unicode(obj_t, obj_t);
extern obj_t ucs2_string_downcase__42___unicode(obj_t);
extern obj_t utf8_string_to_ucs2_string(obj_t);
extern obj_t ucs2_string_upcase_71___unicode(obj_t);
static obj_t _ucs2_string__1211_239___unicode(obj_t, obj_t, obj_t);
static obj_t _ucs2_string_set_1206_94___unicode(obj_t, obj_t, obj_t, obj_t);
extern bool_t ucs2_strcicmp(obj_t, obj_t);
static obj_t _ucs2_string_ci__1210_131___unicode(obj_t, obj_t, obj_t);
static obj_t _ucs2_string_upcase1224_143___unicode(obj_t, obj_t);
static obj_t _list__ucs2_string_171___unicode(obj_t, obj_t);
extern long list_length(obj_t);
static obj_t _ucs2_string_ci___1217_227___unicode(obj_t, obj_t, obj_t);
extern bool_t ucs2_string_ci___60___unicode(obj_t, obj_t);
extern obj_t utf8_string__ucs2_string_53___unicode(obj_t);
extern bool_t ucs2_string_ci___247___unicode(obj_t, obj_t);
extern bool_t ucs2_string_ci___92___unicode(obj_t, obj_t);
static obj_t _ucs2_string_ci___1218_193___unicode(obj_t, obj_t, obj_t);
static obj_t _ucs2_string_fill_1223_209___unicode(obj_t, obj_t, obj_t);
static obj_t _utf8_string__ucs2_string1229_157___unicode(obj_t, obj_t);
extern obj_t ucs2_string__list_125___unicode(obj_t);
extern obj_t ucs2_string_upcase__158___unicode(obj_t);
static obj_t _ucs2_string_upcase_1226_77___unicode(obj_t, obj_t);
extern obj_t list__ucs2_string_55___unicode(obj_t);
static obj_t _ucs2_string__1209_145___unicode(obj_t, obj_t, obj_t);
extern obj_t c_subucs2_string(obj_t, long, long);
static obj_t _ucs2_string_ci__1216_26___unicode(obj_t, obj_t, obj_t);
static obj_t _ucs2_string__utf8_string1228_128___unicode(obj_t, obj_t);
static obj_t imported_modules_init_94___unicode();
extern bool_t ucs2_strcmp(obj_t, obj_t);
extern bool_t ucs2_string_lt(obj_t, obj_t);
extern obj_t make_ucs2_string_75___unicode(int, obj_t);
extern bool_t ucs2_string_le(obj_t, obj_t);
extern bool_t ucs2_string_gt(obj_t, obj_t);
static obj_t require_initialization_114___unicode = BUNSPEC;
static obj_t _ucs2_string___1213_203___unicode(obj_t, obj_t, obj_t);
extern bool_t ucs2_string_ge(obj_t, obj_t);
static obj_t _ucs2_string_set_ur_1208_200___unicode(obj_t, obj_t, obj_t, obj_t);
static obj_t _ucs2_string___1214_197___unicode(obj_t, obj_t, obj_t);
static obj_t _ucs2_string__list1221_140___unicode(obj_t, obj_t);
static obj_t _ucs2_string_length1204_39___unicode(obj_t, obj_t);
extern bool_t ucs2_string__76___unicode(obj_t);
extern obj_t ucs2_string_downcase_77___unicode(obj_t);
extern obj_t reverse__39___r4_pairs_and_lists_6_3(obj_t);
static obj_t _ucs2_string__1212_169___unicode(obj_t, obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( ucs2_string__utf8_string_env_142___unicode, _ucs2_string__utf8_string1228_128___unicode1236, _ucs2_string__utf8_string1228_128___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_ci____env_38___unicode, _ucs2_string_ci___1217_227___unicode1237, _ucs2_string_ci___1217_227___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_ci____env_37___unicode, _ucs2_string_ci___1218_193___unicode1238, _ucs2_string_ci___1218_193___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_fill__env_181___unicode, _ucs2_string_fill_1223_209___unicode1239, _ucs2_string_fill_1223_209___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_downcase_env_169___unicode, _ucs2_string_downcase1225_245___unicode1240, _ucs2_string_downcase1225_245___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_append_env_17___unicode, _ucs2_string_append_9___unicode1241, va_generic_entry, _ucs2_string_append_9___unicode, -1 );
DEFINE_EXPORT_PROCEDURE( make_ucs2_string_env_163___unicode, _make_ucs2_string1203_102___unicode1242, va_generic_entry, _make_ucs2_string1203_102___unicode, -2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_upcase_env_136___unicode, _ucs2_string_upcase1224_143___unicode1243, _ucs2_string_upcase1224_143___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string__list_env_217___unicode, _ucs2_string__list1221_140___unicode1244, _ucs2_string__list1221_140___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_upcase__env_48___unicode, _ucs2_string_upcase_1226_77___unicode1245, _ucs2_string_upcase_1226_77___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string___env_245___unicode, _ucs2_string__1211_239___unicode1246, _ucs2_string__1211_239___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_set_ur__env_0___unicode, _ucs2_string_set_ur_1208_200___unicode1247, _ucs2_string_set_ur_1208_200___unicode, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( ucs2_string____env_63___unicode, _ucs2_string___1213_203___unicode1248, _ucs2_string___1213_203___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_ref_env_251___unicode, _ucs2_string_ref1205_43___unicode1249, _ucs2_string_ref1205_43___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string____env_18___unicode, _ucs2_string___1214_197___unicode1250, _ucs2_string___1214_197___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( list__ucs2_string_env_231___unicode, _list__ucs2_string_171___unicode1251, _list__ucs2_string_171___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string___env_211___unicode, _ucs2_string__1209_145___unicode1252, _ucs2_string__1209_145___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_length_env_217___unicode, _ucs2_string_length1204_39___unicode1253, _ucs2_string_length1204_39___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( subucs2_string_ur_env_61___unicode, _subucs2_string_ur1220_182___unicode1254, _subucs2_string_ur1220_182___unicode, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_ci___env_29___unicode, _ucs2_string_ci__1215_180___unicode1255, _ucs2_string_ci__1215_180___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( subucs2_string_env_64___unicode, _subucs2_string1219_174___unicode1256, _subucs2_string1219_174___unicode, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( ucs2_string___env_124___unicode, _ucs2_string__1212_169___unicode1257, _ucs2_string__1212_169___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_copy_env_8___unicode, _ucs2_string_copy1222_146___unicode1258, _ucs2_string_copy1222_146___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_set__env_239___unicode, _ucs2_string_set_1206_94___unicode1259, _ucs2_string_set_1206_94___unicode, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_ci___env_62___unicode, _ucs2_string_ci__1210_131___unicode1260, _ucs2_string_ci__1210_131___unicode, 0L, 2 );
DEFINE_STRING( string1234___unicode, string1234___unicode1261, "Illegal index", 13 );
DEFINE_STRING( string1233___unicode, string1233___unicode1262, "subucs2-string", 14 );
DEFINE_STRING( string1232___unicode, string1232___unicode1263, "ucs2-string-set!", 16 );
DEFINE_STRING( string1231___unicode, string1231___unicode1264, "index out of range", 18 );
DEFINE_STRING( string1230___unicode, string1230___unicode1265, "ucs2-string-ref", 15 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_downcase__env_73___unicode, _ucs2_string_downcase_1227_242___unicode1266, _ucs2_string_downcase_1227_242___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_ci___env_46___unicode, _ucs2_string_ci__1216_26___unicode1267, _ucs2_string_ci__1216_26___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( utf8_string__ucs2_string_env_92___unicode, _utf8_string__ucs2_string1229_157___unicode1268, _utf8_string__ucs2_string1229_157___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_ref_ur_env_171___unicode, _ucs2_string_ref_ur1207_194___unicode1269, _ucs2_string_ref_ur1207_194___unicode, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_string__env_22___unicode, _ucs2_string__171___unicode1270, _ucs2_string__171___unicode, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_string_env_246___unicode, _ucs2_string_170___unicode1271, va_generic_entry, _ucs2_string_170___unicode, -1 );


/* module-initialization */obj_t module_initialization_70___unicode(long checksum_1012, char * from_1013)
{
if(CBOOL(require_initialization_114___unicode)){
require_initialization_114___unicode = BBOOL(((bool_t)0));
imported_modules_init_94___unicode();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* ucs2-string? */bool_t ucs2_string__76___unicode(obj_t obj_1)
{
return UCS2_STRINGP(obj_1);
}


/* _ucs2-string? */obj_t _ucs2_string__171___unicode(obj_t env_878, obj_t obj_879)
{
{
bool_t aux_1019;
{
obj_t obj_962;
obj_962 = obj_879;
aux_1019 = UCS2_STRINGP(obj_962);
}
return BBOOL(aux_1019);
}
}


/* make-ucs2-string */obj_t make_ucs2_string_75___unicode(int k_2, obj_t ucs2_3)
{
if(NULLP(ucs2_3)){
ucs2_t arg1006_963;
{
char char_964;
char_964 = (char)(((unsigned char)' '));
arg1006_963 = (ucs2_t)(char_964);
}
{
long aux_1026;
aux_1026 = (long)(k_2);
return make_ucs2_string(aux_1026, arg1006_963);
}
}
 else {
ucs2_t aux_1031;
long aux_1029;
{
obj_t aux_1032;
aux_1032 = CAR(ucs2_3);
aux_1031 = CUCS2(aux_1032);
}
aux_1029 = (long)(k_2);
return make_ucs2_string(aux_1029, aux_1031);
}
}


/* _make-ucs2-string1203 */obj_t _make_ucs2_string1203_102___unicode(obj_t env_880, obj_t k_881, obj_t ucs2_882)
{
{
int k_965;
obj_t ucs2_966;
k_965 = CINT(k_881);
ucs2_966 = ucs2_882;
if(NULLP(ucs2_966)){
ucs2_t arg1006_967;
{
char char_968;
char_968 = (char)(((unsigned char)' '));
arg1006_967 = (ucs2_t)(char_968);
}
{
long aux_1041;
aux_1041 = (long)(k_965);
return make_ucs2_string(aux_1041, arg1006_967);
}
}
 else {
ucs2_t aux_1046;
long aux_1044;
{
obj_t aux_1047;
aux_1047 = CAR(ucs2_966);
aux_1046 = CUCS2(aux_1047);
}
aux_1044 = (long)(k_965);
return make_ucs2_string(aux_1044, aux_1046);
}
}
}


/* ucs2-string */obj_t ucs2_string_194___unicode(obj_t ucs2s_4)
{
return list__ucs2_string_55___unicode(ucs2s_4);
}


/* _ucs2-string */obj_t _ucs2_string_170___unicode(obj_t env_883, obj_t ucs2s_884)
{
{
obj_t ucs2s_969;
ucs2s_969 = ucs2s_884;
return list__ucs2_string_55___unicode(ucs2s_969);
}
}


/* ucs2-string-length */long ucs2_string_length_125___unicode(obj_t ucs2_string_194_5)
{
return UCS2_STRING_LENGTH(ucs2_string_194_5);
}


/* _ucs2-string-length1204 */obj_t _ucs2_string_length1204_39___unicode(obj_t env_885, obj_t ucs2_string_194_886)
{
{
long aux_1054;
{
obj_t ucs2_string_194_970;
ucs2_string_194_970 = ucs2_string_194_886;
aux_1054 = UCS2_STRING_LENGTH(ucs2_string_194_970);
}
return BINT(aux_1054);
}
}


/* ucs2-string-ref */ucs2_t ucs2_string_ref_239___unicode(obj_t ucs2_string_194_6, long k_7)
{
{
bool_t test_1057;
{
long aux_1058;
aux_1058 = UCS2_STRING_LENGTH(ucs2_string_194_6);
test_1057 = BOUND_CHECK(k_7, aux_1058);
}
if(test_1057){
return UCS2_STRING_REF(ucs2_string_194_6, k_7);
}
 else {
FAILURE(string1230___unicode,string1231___unicode,BINT(k_7));}
}
}


/* _ucs2-string-ref1205 */obj_t _ucs2_string_ref1205_43___unicode(obj_t env_887, obj_t ucs2_string_194_888, obj_t k_889)
{
{
ucs2_t aux_1064;
{
obj_t ucs2_string_194_971;
long k_972;
ucs2_string_194_971 = ucs2_string_194_888;
k_972 = (long)CINT(k_889);
{
bool_t test_1066;
{
long aux_1067;
aux_1067 = UCS2_STRING_LENGTH(ucs2_string_194_971);
test_1066 = BOUND_CHECK(k_972, aux_1067);
}
if(test_1066){
aux_1064 = UCS2_STRING_REF(ucs2_string_194_971, k_972);
}
 else {
FAILURE(string1230___unicode,string1231___unicode,BINT(k_972));}
}
}
return BUCS2(aux_1064);
}
}


/* ucs2-string-set! */obj_t ucs2_string_set__176___unicode(obj_t ucs2_string_194_8, long k_9, ucs2_t ucs2_10)
{
{
bool_t test_1074;
{
long aux_1075;
aux_1075 = UCS2_STRING_LENGTH(ucs2_string_194_8);
test_1074 = BOUND_CHECK(k_9, aux_1075);
}
if(test_1074){
return UCS2_STRING_SET(ucs2_string_194_8, k_9, ucs2_10);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(k_9));}
}
}


/* _ucs2-string-set!1206 */obj_t _ucs2_string_set_1206_94___unicode(obj_t env_890, obj_t ucs2_string_194_891, obj_t k_892, obj_t ucs2_893)
{
{
obj_t ucs2_string_194_973;
long k_974;
ucs2_t ucs2_975;
ucs2_string_194_973 = ucs2_string_194_891;
k_974 = (long)CINT(k_892);
ucs2_975 = CUCS2(ucs2_893);
{
bool_t test_1083;
{
long aux_1084;
aux_1084 = UCS2_STRING_LENGTH(ucs2_string_194_973);
test_1083 = BOUND_CHECK(k_974, aux_1084);
}
if(test_1083){
return UCS2_STRING_SET(ucs2_string_194_973, k_974, ucs2_975);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(k_974));}
}
}
}


/* ucs2-string-ref-ur */ucs2_t ucs2_string_ref_ur_85___unicode(obj_t ucs2_string_194_11, long k_12)
{
return UCS2_STRING_REF(ucs2_string_194_11, k_12);
}


/* _ucs2-string-ref-ur1207 */obj_t _ucs2_string_ref_ur1207_194___unicode(obj_t env_894, obj_t ucs2_string_194_895, obj_t k_896)
{
{
ucs2_t aux_1091;
{
obj_t ucs2_string_194_976;
long k_977;
ucs2_string_194_976 = ucs2_string_194_895;
k_977 = (long)CINT(k_896);
aux_1091 = UCS2_STRING_REF(ucs2_string_194_976, k_977);
}
return BUCS2(aux_1091);
}
}


/* ucs2-string-set-ur! */obj_t ucs2_string_set_ur__94___unicode(obj_t ucs2_string_194_13, long k_14, ucs2_t ucs2_15)
{
return UCS2_STRING_SET(ucs2_string_194_13, k_14, ucs2_15);
}


/* _ucs2-string-set-ur!1208 */obj_t _ucs2_string_set_ur_1208_200___unicode(obj_t env_897, obj_t ucs2_string_194_898, obj_t k_899, obj_t ucs2_900)
{
{
obj_t ucs2_string_194_978;
long k_979;
ucs2_t ucs2_980;
ucs2_string_194_978 = ucs2_string_194_898;
k_979 = (long)CINT(k_899);
ucs2_980 = CUCS2(ucs2_900);
return UCS2_STRING_SET(ucs2_string_194_978, k_979, ucs2_980);
}
}


/* ucs2-string=? */bool_t ucs2_string___146___unicode(obj_t ucs2_string1_235_16, obj_t ucs2_string2_163_17)
{
return ucs2_strcmp(ucs2_string1_235_16, ucs2_string2_163_17);
}


/* _ucs2-string=?1209 */obj_t _ucs2_string__1209_145___unicode(obj_t env_901, obj_t ucs2_string1_235_902, obj_t ucs2_string2_163_903)
{
{
bool_t aux_1100;
{
obj_t ucs2_string1_235_981;
obj_t ucs2_string2_163_982;
ucs2_string1_235_981 = ucs2_string1_235_902;
ucs2_string2_163_982 = ucs2_string2_163_903;
aux_1100 = ucs2_strcmp(ucs2_string1_235_981, ucs2_string2_163_982);
}
return BBOOL(aux_1100);
}
}


/* ucs2-string-ci=? */bool_t ucs2_string_ci___247___unicode(obj_t ucs2_string1_235_18, obj_t ucs2_string2_163_19)
{
return ucs2_strcicmp(ucs2_string1_235_18, ucs2_string2_163_19);
}


/* _ucs2-string-ci=?1210 */obj_t _ucs2_string_ci__1210_131___unicode(obj_t env_904, obj_t ucs2_string1_235_905, obj_t ucs2_string2_163_906)
{
{
bool_t aux_1104;
{
obj_t ucs2_string1_235_983;
obj_t ucs2_string2_163_984;
ucs2_string1_235_983 = ucs2_string1_235_905;
ucs2_string2_163_984 = ucs2_string2_163_906;
aux_1104 = ucs2_strcicmp(ucs2_string1_235_983, ucs2_string2_163_984);
}
return BBOOL(aux_1104);
}
}


/* ucs2-string<? */bool_t ucs2_string___83___unicode(obj_t ucs2_string1_235_20, obj_t ucs2_string2_163_21)
{
return ucs2_string_lt(ucs2_string1_235_20, ucs2_string2_163_21);
}


/* _ucs2-string<?1211 */obj_t _ucs2_string__1211_239___unicode(obj_t env_907, obj_t ucs2_string1_235_908, obj_t ucs2_string2_163_909)
{
{
bool_t aux_1108;
{
obj_t ucs2_string1_235_985;
obj_t ucs2_string2_163_986;
ucs2_string1_235_985 = ucs2_string1_235_908;
ucs2_string2_163_986 = ucs2_string2_163_909;
aux_1108 = ucs2_string_lt(ucs2_string1_235_985, ucs2_string2_163_986);
}
return BBOOL(aux_1108);
}
}


/* ucs2-string>? */bool_t ucs2_string___248___unicode(obj_t ucs2_string1_235_22, obj_t ucs2_string2_163_23)
{
return ucs2_string_gt(ucs2_string1_235_22, ucs2_string2_163_23);
}


/* _ucs2-string>?1212 */obj_t _ucs2_string__1212_169___unicode(obj_t env_910, obj_t ucs2_string1_235_911, obj_t ucs2_string2_163_912)
{
{
bool_t aux_1112;
{
obj_t ucs2_string1_235_987;
obj_t ucs2_string2_163_988;
ucs2_string1_235_987 = ucs2_string1_235_911;
ucs2_string2_163_988 = ucs2_string2_163_912;
aux_1112 = ucs2_string_gt(ucs2_string1_235_987, ucs2_string2_163_988);
}
return BBOOL(aux_1112);
}
}


/* ucs2-string<=? */bool_t ucs2_string____33___unicode(obj_t ucs2_string1_235_24, obj_t ucs2_string2_163_25)
{
return ucs2_string_le(ucs2_string1_235_24, ucs2_string2_163_25);
}


/* _ucs2-string<=?1213 */obj_t _ucs2_string___1213_203___unicode(obj_t env_913, obj_t ucs2_string1_235_914, obj_t ucs2_string2_163_915)
{
{
bool_t aux_1116;
{
obj_t ucs2_string1_235_989;
obj_t ucs2_string2_163_990;
ucs2_string1_235_989 = ucs2_string1_235_914;
ucs2_string2_163_990 = ucs2_string2_163_915;
aux_1116 = ucs2_string_le(ucs2_string1_235_989, ucs2_string2_163_990);
}
return BBOOL(aux_1116);
}
}


/* ucs2-string>=? */bool_t ucs2_string____135___unicode(obj_t ucs2_string1_235_26, obj_t ucs2_string2_163_27)
{
return ucs2_string_ge(ucs2_string1_235_26, ucs2_string2_163_27);
}


/* _ucs2-string>=?1214 */obj_t _ucs2_string___1214_197___unicode(obj_t env_916, obj_t ucs2_string1_235_917, obj_t ucs2_string2_163_918)
{
{
bool_t aux_1120;
{
obj_t ucs2_string1_235_991;
obj_t ucs2_string2_163_992;
ucs2_string1_235_991 = ucs2_string1_235_917;
ucs2_string2_163_992 = ucs2_string2_163_918;
aux_1120 = ucs2_string_ge(ucs2_string1_235_991, ucs2_string2_163_992);
}
return BBOOL(aux_1120);
}
}


/* ucs2-string-ci<? */bool_t ucs2_string_ci___92___unicode(obj_t ucs2_string1_235_28, obj_t ucs2_string2_163_29)
{
return ucs2_string_cilt(ucs2_string1_235_28, ucs2_string2_163_29);
}


/* _ucs2-string-ci<?1215 */obj_t _ucs2_string_ci__1215_180___unicode(obj_t env_919, obj_t ucs2_string1_235_920, obj_t ucs2_string2_163_921)
{
{
bool_t aux_1124;
{
obj_t ucs2_string1_235_993;
obj_t ucs2_string2_163_994;
ucs2_string1_235_993 = ucs2_string1_235_920;
ucs2_string2_163_994 = ucs2_string2_163_921;
aux_1124 = ucs2_string_cilt(ucs2_string1_235_993, ucs2_string2_163_994);
}
return BBOOL(aux_1124);
}
}


/* ucs2-string-ci>? */bool_t ucs2_string_ci___60___unicode(obj_t ucs2_string1_235_30, obj_t ucs2_string2_163_31)
{
return ucs2_string_cigt(ucs2_string1_235_30, ucs2_string2_163_31);
}


/* _ucs2-string-ci>?1216 */obj_t _ucs2_string_ci__1216_26___unicode(obj_t env_922, obj_t ucs2_string1_235_923, obj_t ucs2_string2_163_924)
{
{
bool_t aux_1128;
{
obj_t ucs2_string1_235_995;
obj_t ucs2_string2_163_996;
ucs2_string1_235_995 = ucs2_string1_235_923;
ucs2_string2_163_996 = ucs2_string2_163_924;
aux_1128 = ucs2_string_cigt(ucs2_string1_235_995, ucs2_string2_163_996);
}
return BBOOL(aux_1128);
}
}


/* ucs2-string-ci<=? */bool_t ucs2_string_ci____210___unicode(obj_t ucs2_string1_235_32, obj_t ucs2_string2_163_33)
{
return ucs2_string_cile(ucs2_string1_235_32, ucs2_string2_163_33);
}


/* _ucs2-string-ci<=?1217 */obj_t _ucs2_string_ci___1217_227___unicode(obj_t env_925, obj_t ucs2_string1_235_926, obj_t ucs2_string2_163_927)
{
{
bool_t aux_1132;
{
obj_t ucs2_string1_235_997;
obj_t ucs2_string2_163_998;
ucs2_string1_235_997 = ucs2_string1_235_926;
ucs2_string2_163_998 = ucs2_string2_163_927;
aux_1132 = ucs2_string_cile(ucs2_string1_235_997, ucs2_string2_163_998);
}
return BBOOL(aux_1132);
}
}


/* ucs2-string-ci>=? */bool_t ucs2_string_ci____43___unicode(obj_t ucs2_string1_235_34, obj_t ucs2_string2_163_35)
{
return ucs2_string_cige(ucs2_string1_235_34, ucs2_string2_163_35);
}


/* _ucs2-string-ci>=?1218 */obj_t _ucs2_string_ci___1218_193___unicode(obj_t env_928, obj_t ucs2_string1_235_929, obj_t ucs2_string2_163_930)
{
{
bool_t aux_1136;
{
obj_t ucs2_string1_235_999;
obj_t ucs2_string2_163_1000;
ucs2_string1_235_999 = ucs2_string1_235_929;
ucs2_string2_163_1000 = ucs2_string2_163_930;
aux_1136 = ucs2_string_cige(ucs2_string1_235_999, ucs2_string2_163_1000);
}
return BBOOL(aux_1136);
}
}


/* subucs2-string */obj_t subucs2_string_27___unicode(obj_t ucs2_string_194_36, long start_37, long end_38)
{
{
bool_t test_1139;
if((end_38>=start_37)){
bool_t test_1142;
{
long aux_1143;
{
long aux_1144;
aux_1144 = UCS2_STRING_LENGTH(ucs2_string_194_36);
aux_1143 = (aux_1144+((long)1));
}
test_1142 = BOUND_CHECK(start_37, aux_1143);
}
if(test_1142){
long aux_1148;
{
long aux_1149;
aux_1149 = UCS2_STRING_LENGTH(ucs2_string_194_36);
aux_1148 = (aux_1149+((long)1));
}
test_1139 = BOUND_CHECK(end_38, aux_1148);
}
 else {
test_1139 = ((bool_t)0);
}
}
 else {
test_1139 = ((bool_t)0);
}
if(test_1139){
return c_subucs2_string(ucs2_string_194_36, start_37, end_38);
}
 else {
obj_t arg1015_1001;
{
obj_t aux_1156;
obj_t aux_1154;
aux_1156 = BINT(end_38);
aux_1154 = BINT(start_37);
arg1015_1001 = MAKE_PAIR(aux_1154, aux_1156);
}
FAILURE(string1233___unicode,string1234___unicode,arg1015_1001);}
}
}


/* _subucs2-string1219 */obj_t _subucs2_string1219_174___unicode(obj_t env_931, obj_t ucs2_string_194_932, obj_t start_933, obj_t end_934)
{
{
obj_t ucs2_string_194_1002;
long start_1003;
long end_1004;
ucs2_string_194_1002 = ucs2_string_194_932;
start_1003 = (long)CINT(start_933);
end_1004 = (long)CINT(end_934);
{
bool_t test_1162;
if((end_1004>=start_1003)){
bool_t test_1165;
{
long aux_1166;
{
long aux_1167;
aux_1167 = UCS2_STRING_LENGTH(ucs2_string_194_1002);
aux_1166 = (aux_1167+((long)1));
}
test_1165 = BOUND_CHECK(start_1003, aux_1166);
}
if(test_1165){
long aux_1171;
{
long aux_1172;
aux_1172 = UCS2_STRING_LENGTH(ucs2_string_194_1002);
aux_1171 = (aux_1172+((long)1));
}
test_1162 = BOUND_CHECK(end_1004, aux_1171);
}
 else {
test_1162 = ((bool_t)0);
}
}
 else {
test_1162 = ((bool_t)0);
}
if(test_1162){
return c_subucs2_string(ucs2_string_194_1002, start_1003, end_1004);
}
 else {
obj_t arg1015_1005;
{
obj_t aux_1179;
obj_t aux_1177;
aux_1179 = BINT(end_1004);
aux_1177 = BINT(start_1003);
arg1015_1005 = MAKE_PAIR(aux_1177, aux_1179);
}
FAILURE(string1233___unicode,string1234___unicode,arg1015_1005);}
}
}
}


/* subucs2-string-ur */obj_t subucs2_string_ur_47___unicode(obj_t ucs2_string_194_39, long start_40, long end_41)
{
return c_subucs2_string(ucs2_string_194_39, start_40, end_41);
}


/* _subucs2-string-ur1220 */obj_t _subucs2_string_ur1220_182___unicode(obj_t env_935, obj_t ucs2_string_194_936, obj_t start_937, obj_t end_938)
{
{
obj_t ucs2_string_194_1006;
long start_1007;
long end_1008;
ucs2_string_194_1006 = ucs2_string_194_936;
start_1007 = (long)CINT(start_937);
end_1008 = (long)CINT(end_938);
return c_subucs2_string(ucs2_string_194_1006, start_1007, end_1008);
}
}


/* ucs2-string-append */obj_t ucs2_string_append_106___unicode(obj_t list_42)
{
if(NULLP(list_42)){
obj_t res1192_560;
{
int k_552;
k_552 = (int)(((long)0));
{
ucs2_t arg1006_555;
{
char char_166_558;
char_166_558 = (char)(((unsigned char)' '));
arg1006_555 = (ucs2_t)(char_166_558);
}
{
long aux_1192;
aux_1192 = (long)(k_552);
res1192_560 = make_ucs2_string(aux_1192, arg1006_555);
}
}
}
return res1192_560;
}
 else {
return loop___unicode(list_42);
}
}


/* loop */obj_t loop___unicode(obj_t list_314)
{
{
bool_t test_1196;
{
obj_t aux_1197;
aux_1197 = CDR(list_314);
test_1196 = NULLP(aux_1197);
}
if(test_1196){
return CAR(list_314);
}
 else {
obj_t arg1027_317;
obj_t arg1028_318;
arg1027_317 = CAR(list_314);
arg1028_318 = loop___unicode(CDR(list_314));
return ucs2_string_append(arg1027_317, arg1028_318);
}
}
}


/* _ucs2-string-append */obj_t _ucs2_string_append_9___unicode(obj_t env_939, obj_t list_940)
{
return ucs2_string_append_106___unicode(list_940);
}


/* list->ucs2-string */obj_t list__ucs2_string_55___unicode(obj_t list_43)
{
{
long len_321;
len_321 = list_length(list_43);
{
obj_t ucs2_string_194_322;
{
obj_t res1193_574;
{
int k_566;
k_566 = (int)(len_321);
{
ucs2_t arg1006_569;
{
char char_166_572;
char_166_572 = (char)(((unsigned char)' '));
arg1006_569 = (ucs2_t)(char_166_572);
}
{
long aux_1210;
aux_1210 = (long)(k_566);
res1193_574 = make_ucs2_string(aux_1210, arg1006_569);
}
}
}
ucs2_string_194_322 = res1193_574;
}
{
{
long i_576;
obj_t l_577;
i_576 = ((long)0);
l_577 = list_43;
loop_575:
if((i_576==len_321)){
return ucs2_string_194_322;
}
 else {
{
bool_t test_1215;
{
long aux_1216;
aux_1216 = UCS2_STRING_LENGTH(ucs2_string_194_322);
test_1215 = BOUND_CHECK(i_576, aux_1216);
}
if(test_1215){
ucs2_t aux_1219;
{
obj_t aux_1220;
aux_1220 = CAR(l_577);
aux_1219 = CUCS2(aux_1220);
}
UCS2_STRING_SET(ucs2_string_194_322, i_576, aux_1219);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(i_576));}
}
{
obj_t l_1228;
long i_1226;
i_1226 = (i_576+((long)1));
l_1228 = CDR(l_577);
l_577 = l_1228;
i_576 = i_1226;
goto loop_575;
}
}
}
}
}
}
}


/* _list->ucs2-string */obj_t _list__ucs2_string_171___unicode(obj_t env_941, obj_t list_942)
{
return list__ucs2_string_55___unicode(list_942);
}


/* ucs2-string->list */obj_t ucs2_string__list_125___unicode(obj_t ucs2_string_194_44)
{
{
long len_331;
len_331 = UCS2_STRING_LENGTH(ucs2_string_194_44);
{
long i_643;
obj_t acc_644;
i_643 = ((long)0);
acc_644 = BNIL;
loop_642:
if((i_643==len_331)){
return reverse__39___r4_pairs_and_lists_6_3(acc_644);
}
 else {
long arg1040_650;
obj_t arg1041_651;
arg1040_650 = (i_643+((long)1));
{
ucs2_t arg1042_652;
{
ucs2_t res1194_665;
{
bool_t test_1236;
{
long aux_1237;
aux_1237 = UCS2_STRING_LENGTH(ucs2_string_194_44);
test_1236 = BOUND_CHECK(i_643, aux_1237);
}
if(test_1236){
res1194_665 = UCS2_STRING_REF(ucs2_string_194_44, i_643);
}
 else {
FAILURE(string1230___unicode,string1231___unicode,BINT(i_643));}
}
arg1042_652 = res1194_665;
}
{
obj_t aux_1243;
aux_1243 = BUCS2(arg1042_652);
arg1041_651 = MAKE_PAIR(aux_1243, acc_644);
}
}
{
obj_t acc_1247;
long i_1246;
i_1246 = arg1040_650;
acc_1247 = arg1041_651;
acc_644 = acc_1247;
i_643 = i_1246;
goto loop_642;
}
}
}
}
}


/* _ucs2-string->list1221 */obj_t _ucs2_string__list1221_140___unicode(obj_t env_943, obj_t ucs2_string_194_944)
{
return ucs2_string__list_125___unicode(ucs2_string_194_944);
}


/* ucs2-string-copy */obj_t ucs2_string_copy_207___unicode(obj_t ucs2_string_194_45)
{
return c_ucs2_string_copy(ucs2_string_194_45);
}


/* _ucs2-string-copy1222 */obj_t _ucs2_string_copy1222_146___unicode(obj_t env_945, obj_t ucs2_string_194_946)
{
{
obj_t ucs2_string_194_1009;
ucs2_string_194_1009 = ucs2_string_194_946;
return c_ucs2_string_copy(ucs2_string_194_1009);
}
}


/* ucs2-string-fill! */obj_t ucs2_string_fill__51___unicode(obj_t ucs2_string_194_46, ucs2_t ucs2_47)
{
{
long len_708;
len_708 = UCS2_STRING_LENGTH(ucs2_string_194_46);
{
long i_715;
i_715 = ((long)0);
loop_714:
if((i_715==len_708)){
return ucs2_string_194_46;
}
 else {
{
bool_t test_1254;
{
long aux_1255;
aux_1255 = UCS2_STRING_LENGTH(ucs2_string_194_46);
test_1254 = BOUND_CHECK(i_715, aux_1255);
}
if(test_1254){
UCS2_STRING_SET(ucs2_string_194_46, i_715, ucs2_47);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(i_715));}
}
{
long i_1261;
i_1261 = (i_715+((long)1));
i_715 = i_1261;
goto loop_714;
}
}
}
}
}


/* _ucs2-string-fill!1223 */obj_t _ucs2_string_fill_1223_209___unicode(obj_t env_947, obj_t ucs2_string_194_948, obj_t ucs2_949)
{
return ucs2_string_fill__51___unicode(ucs2_string_194_948, CUCS2(ucs2_949));
}


/* ucs2-string-upcase */obj_t ucs2_string_upcase_71___unicode(obj_t ucs2_string_194_48)
{
{
long len_346;
len_346 = UCS2_STRING_LENGTH(ucs2_string_194_48);
{
obj_t res_347;
{
obj_t res1197_773;
{
int k_765;
k_765 = (int)(len_346);
{
ucs2_t arg1006_768;
{
char char_166_771;
char_166_771 = (char)(((unsigned char)' '));
arg1006_768 = (ucs2_t)(char_166_771);
}
{
long aux_1269;
aux_1269 = (long)(k_765);
res1197_773 = make_ucs2_string(aux_1269, arg1006_768);
}
}
}
res_347 = res1197_773;
}
{
{
long i_348;
i_348 = ((long)0);
loop_349:
if((i_348==len_346)){
return res_347;
}
 else {
{
ucs2_t arg1046_351;
{
ucs2_t arg1047_352;
{
ucs2_t res1198_784;
{
bool_t test_1274;
{
long aux_1275;
aux_1275 = UCS2_STRING_LENGTH(ucs2_string_194_48);
test_1274 = BOUND_CHECK(i_348, aux_1275);
}
if(test_1274){
res1198_784 = UCS2_STRING_REF(ucs2_string_194_48, i_348);
}
 else {
FAILURE(string1230___unicode,string1231___unicode,BINT(i_348));}
}
arg1047_352 = res1198_784;
}
arg1046_351 = ucs2_toupper(arg1047_352);
}
{
bool_t test_1282;
{
long aux_1283;
aux_1283 = UCS2_STRING_LENGTH(res_347);
test_1282 = BOUND_CHECK(i_348, aux_1283);
}
if(test_1282){
UCS2_STRING_SET(res_347, i_348, arg1046_351);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(i_348));}
}
}
{
long i_1289;
i_1289 = (i_348+((long)1));
i_348 = i_1289;
goto loop_349;
}
}
}
}
}
}
}


/* _ucs2-string-upcase1224 */obj_t _ucs2_string_upcase1224_143___unicode(obj_t env_950, obj_t ucs2_string_194_951)
{
return ucs2_string_upcase_71___unicode(ucs2_string_194_951);
}


/* ucs2-string-downcase */obj_t ucs2_string_downcase_77___unicode(obj_t ucs2_string_194_49)
{
{
long len_355;
len_355 = UCS2_STRING_LENGTH(ucs2_string_194_49);
{
obj_t res_356;
{
obj_t res1199_806;
{
int k_798;
k_798 = (int)(len_355);
{
ucs2_t arg1006_801;
{
char char_166_804;
char_166_804 = (char)(((unsigned char)' '));
arg1006_801 = (ucs2_t)(char_166_804);
}
{
long aux_1296;
aux_1296 = (long)(k_798);
res1199_806 = make_ucs2_string(aux_1296, arg1006_801);
}
}
}
res_356 = res1199_806;
}
{
{
long i_357;
i_357 = ((long)0);
loop_358:
if((i_357==len_355)){
return res_356;
}
 else {
{
ucs2_t arg1051_360;
{
ucs2_t arg1053_361;
{
ucs2_t res1200_817;
{
bool_t test_1301;
{
long aux_1302;
aux_1302 = UCS2_STRING_LENGTH(ucs2_string_194_49);
test_1301 = BOUND_CHECK(i_357, aux_1302);
}
if(test_1301){
res1200_817 = UCS2_STRING_REF(ucs2_string_194_49, i_357);
}
 else {
FAILURE(string1230___unicode,string1231___unicode,BINT(i_357));}
}
arg1053_361 = res1200_817;
}
arg1051_360 = ucs2_tolower(arg1053_361);
}
{
bool_t test_1309;
{
long aux_1310;
aux_1310 = UCS2_STRING_LENGTH(res_356);
test_1309 = BOUND_CHECK(i_357, aux_1310);
}
if(test_1309){
UCS2_STRING_SET(res_356, i_357, arg1051_360);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(i_357));}
}
}
{
long i_1316;
i_1316 = (i_357+((long)1));
i_357 = i_1316;
goto loop_358;
}
}
}
}
}
}
}


/* _ucs2-string-downcase1225 */obj_t _ucs2_string_downcase1225_245___unicode(obj_t env_952, obj_t ucs2_string_194_953)
{
return ucs2_string_downcase_77___unicode(ucs2_string_194_953);
}


/* ucs2-string-upcase! */obj_t ucs2_string_upcase__158___unicode(obj_t ucs2_string_194_50)
{
{
long len_364;
len_364 = UCS2_STRING_LENGTH(ucs2_string_194_50);
{
{
long i_366;
i_366 = ((long)0);
loop_367:
if((i_366==len_364)){
return ucs2_string_194_50;
}
 else {
{
ucs2_t arg1057_369;
{
ucs2_t arg1058_370;
{
ucs2_t res1201_841;
{
bool_t test_1322;
{
long aux_1323;
aux_1323 = UCS2_STRING_LENGTH(ucs2_string_194_50);
test_1322 = BOUND_CHECK(i_366, aux_1323);
}
if(test_1322){
res1201_841 = UCS2_STRING_REF(ucs2_string_194_50, i_366);
}
 else {
FAILURE(string1230___unicode,string1231___unicode,BINT(i_366));}
}
arg1058_370 = res1201_841;
}
arg1057_369 = ucs2_toupper(arg1058_370);
}
{
bool_t test_1330;
{
long aux_1331;
aux_1331 = UCS2_STRING_LENGTH(ucs2_string_194_50);
test_1330 = BOUND_CHECK(i_366, aux_1331);
}
if(test_1330){
UCS2_STRING_SET(ucs2_string_194_50, i_366, arg1057_369);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(i_366));}
}
}
{
long i_1337;
i_1337 = (i_366+((long)1));
i_366 = i_1337;
goto loop_367;
}
}
}
}
}
}


/* _ucs2-string-upcase!1226 */obj_t _ucs2_string_upcase_1226_77___unicode(obj_t env_954, obj_t ucs2_string_194_955)
{
return ucs2_string_upcase__158___unicode(ucs2_string_194_955);
}


/* ucs2-string-downcase! */obj_t ucs2_string_downcase__42___unicode(obj_t ucs2_string_194_51)
{
{
long len_372;
len_372 = UCS2_STRING_LENGTH(ucs2_string_194_51);
{
{
long i_374;
i_374 = ((long)0);
loop_375:
if((i_374==len_372)){
return ucs2_string_194_51;
}
 else {
{
ucs2_t arg1061_377;
{
ucs2_t arg1062_378;
{
ucs2_t res1202_865;
{
bool_t test_1343;
{
long aux_1344;
aux_1344 = UCS2_STRING_LENGTH(ucs2_string_194_51);
test_1343 = BOUND_CHECK(i_374, aux_1344);
}
if(test_1343){
res1202_865 = UCS2_STRING_REF(ucs2_string_194_51, i_374);
}
 else {
FAILURE(string1230___unicode,string1231___unicode,BINT(i_374));}
}
arg1062_378 = res1202_865;
}
arg1061_377 = ucs2_tolower(arg1062_378);
}
{
bool_t test_1351;
{
long aux_1352;
aux_1352 = UCS2_STRING_LENGTH(ucs2_string_194_51);
test_1351 = BOUND_CHECK(i_374, aux_1352);
}
if(test_1351){
UCS2_STRING_SET(ucs2_string_194_51, i_374, arg1061_377);
}
 else {
FAILURE(string1232___unicode,string1231___unicode,BINT(i_374));}
}
}
{
long i_1358;
i_1358 = (i_374+((long)1));
i_374 = i_1358;
goto loop_375;
}
}
}
}
}
}


/* _ucs2-string-downcase!1227 */obj_t _ucs2_string_downcase_1227_242___unicode(obj_t env_956, obj_t ucs2_string_194_957)
{
return ucs2_string_downcase__42___unicode(ucs2_string_194_957);
}


/* ucs2-string->utf8-string */obj_t ucs2_string__utf8_string_192___unicode(obj_t ucs2_52)
{
return ucs2_string_to_utf8_string(ucs2_52);
}


/* _ucs2-string->utf8-string1228 */obj_t _ucs2_string__utf8_string1228_128___unicode(obj_t env_958, obj_t ucs2_959)
{
{
obj_t ucs2_1010;
ucs2_1010 = ucs2_959;
return ucs2_string_to_utf8_string(ucs2_1010);
}
}


/* utf8-string->ucs2-string */obj_t utf8_string__ucs2_string_53___unicode(obj_t utf8_53)
{
return utf8_string_to_ucs2_string(utf8_53);
}


/* _utf8-string->ucs2-string1229 */obj_t _utf8_string__ucs2_string1229_157___unicode(obj_t env_960, obj_t utf8_961)
{
{
obj_t utf8_1011;
utf8_1011 = utf8_961;
return utf8_string_to_ucs2_string(utf8_1011);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___unicode()
{
return module_initialization_70___error(((long)0), "__UNICODE");
}

