/*===========================================================================*/
/*   (Llib/ucs2.scm)                                                         */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _ucs2__integer1159_196___ucs2(obj_t, obj_t);
extern bool_t ucs2_ci____165___ucs2(ucs2_t, ucs2_t);
static obj_t _ucs2_downcase1157_63___ucs2(obj_t, obj_t);
extern bool_t ucs2_ci___239___ucs2(ucs2_t, ucs2_t);
extern bool_t ucs2_ci___212___ucs2(ucs2_t, ucs2_t);
extern bool_t ucs2_ci___156___ucs2(ucs2_t, ucs2_t);
static obj_t _ucs2_lower_case_1155_15___ucs2(obj_t, obj_t);
static obj_t _ucs2_numeric_1152_149___ucs2(obj_t, obj_t);
static obj_t _ucs2__1142_3___ucs2(obj_t, obj_t, obj_t);
extern bool_t ucs2_ci____166___ucs2(ucs2_t, ucs2_t);
static obj_t _ucs2__5___ucs2(obj_t, obj_t);
static obj_t _integer__ucs21158_101___ucs2(obj_t, obj_t);
extern bool_t ucs2__10___ucs2(obj_t);
extern bool_t ucs2_lower_case__105___ucs2(ucs2_t);
static obj_t _ucs2__1141_238___ucs2(obj_t, obj_t, obj_t);
static obj_t _ucs2_whitespace_1153_205___ucs2(obj_t, obj_t);
extern ucs2_t ucs2_upcase_130___ucs2(ucs2_t);
extern long ucs2__integer_171___ucs2(ucs2_t);
extern ucs2_t integer__ucs2_47___ucs2(long);
static obj_t _ucs2___1144_238___ucs2(obj_t, obj_t, obj_t);
static obj_t _ucs2_ci___1149_127___ucs2(obj_t, obj_t, obj_t);
static obj_t _ucs2___1145_172___ucs2(obj_t, obj_t, obj_t);
static obj_t _ucs2_ci___1150_57___ucs2(obj_t, obj_t, obj_t);
extern ucs2_t ucs2_downcase_102___ucs2(ucs2_t);
static obj_t _ucs2__char1161_111___ucs2(obj_t, obj_t);
extern bool_t ucs2_whitespace__106___ucs2(ucs2_t);
static obj_t _ucs2_alphabetic_1151_6___ucs2(obj_t, obj_t);
extern bool_t ucs2_upper_case__41___ucs2(ucs2_t);
static obj_t _ucs2__1143_100___ucs2(obj_t, obj_t, obj_t);
extern obj_t module_initialization_70___ucs2(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _ucs2_ci__1147_19___ucs2(obj_t, obj_t, obj_t);
extern bool_t ucs2_numeric__113___ucs2(ucs2_t);
extern bool_t ucs2___135___ucs2(ucs2_t, ucs2_t);
extern bool_t ucs2___19___ucs2(ucs2_t, ucs2_t);
extern bool_t ucs2___136___ucs2(ucs2_t, ucs2_t);
static obj_t _ucs2_ci__1146_46___ucs2(obj_t, obj_t, obj_t);
extern char ucs2__char_237___ucs2(ucs2_t);
static obj_t _char__ucs21160_206___ucs2(obj_t, obj_t);
static obj_t _ucs2_upper_case_1154_27___ucs2(obj_t, obj_t);
static obj_t imported_modules_init_94___ucs2();
extern bool_t ucs2_alphabetic__226___ucs2(ucs2_t);
static obj_t _ucs2_upcase1156_180___ucs2(obj_t, obj_t);
extern bool_t ucs2____52___ucs2(ucs2_t, ucs2_t);
static obj_t require_initialization_114___ucs2 = BUNSPEC;
static obj_t _ucs2_ci__1148_198___ucs2(obj_t, obj_t, obj_t);
extern ucs2_t char__ucs2_17___ucs2(char);
extern bool_t ucs2____55___ucs2(ucs2_t, ucs2_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( ucs2___env_137___ucs2, _ucs2__1142_3___ucs21168, _ucs2__1142_3___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_ci___env_108___ucs2, _ucs2_ci__1147_19___ucs21169, _ucs2_ci__1147_19___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2____env_231___ucs2, _ucs2___1144_238___ucs21170, _ucs2___1144_238___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2____env_59___ucs2, _ucs2___1145_172___ucs21171, _ucs2___1145_172___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2___env_102___ucs2, _ucs2__1141_238___ucs21172, _ucs2__1141_238___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_lower_case__env_166___ucs2, _ucs2_lower_case_1155_15___ucs21173, _ucs2_lower_case_1155_15___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_ci___env_145___ucs2, _ucs2_ci__1146_46___ucs21174, _ucs2_ci__1146_46___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_ci____env_242___ucs2, _ucs2_ci___1149_127___ucs21175, _ucs2_ci___1149_127___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_ci____env_35___ucs2, _ucs2_ci___1150_57___ucs21176, _ucs2_ci___1150_57___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2__char_env_30___ucs2, _ucs2__char1161_111___ucs21177, _ucs2__char1161_111___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2___env_18___ucs2, _ucs2__1143_100___ucs21178, _ucs2__1143_100___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2__env_71___ucs2, _ucs2__5___ucs21179, _ucs2__5___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_whitespace__env_17___ucs2, _ucs2_whitespace_1153_205___ucs21180, _ucs2_whitespace_1153_205___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_ci___env_251___ucs2, _ucs2_ci__1148_198___ucs21181, _ucs2_ci__1148_198___ucs2, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ucs2_alphabetic__env_222___ucs2, _ucs2_alphabetic_1151_6___ucs21182, _ucs2_alphabetic_1151_6___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2__integer_env_115___ucs2, _ucs2__integer1159_196___ucs21183, _ucs2__integer1159_196___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_downcase_env_153___ucs2, _ucs2_downcase1157_63___ucs21184, _ucs2_downcase1157_63___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( char__ucs2_env_195___ucs2, _char__ucs21160_206___ucs21185, _char__ucs21160_206___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_numeric__env_39___ucs2, _ucs2_numeric_1152_149___ucs21186, _ucs2_numeric_1152_149___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_upper_case__env_66___ucs2, _ucs2_upper_case_1154_27___ucs21187, _ucs2_upper_case_1154_27___ucs2, 0L, 1 );
DEFINE_STRING( string1166___ucs2, string1166___ucs21188, "UCS-2 character out of ISO-LATIN-1 range", 40 );
DEFINE_STRING( string1165___ucs2, string1165___ucs21189, "ucs2->char", 10 );
DEFINE_STRING( string1164___ucs2, string1164___ucs21190, "integer out of range or ", 24 );
DEFINE_STRING( string1163___ucs2, string1163___ucs21191, "Undefined UCS-2 character", 25 );
DEFINE_STRING( string1162___ucs2, string1162___ucs21192, "integer->ucs2", 13 );
DEFINE_EXPORT_PROCEDURE( integer__ucs2_env_61___ucs2, _integer__ucs21158_101___ucs21193, _integer__ucs21158_101___ucs2, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ucs2_upcase_env_120___ucs2, _ucs2_upcase1156_180___ucs21194, _ucs2_upcase1156_180___ucs2, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___ucs2(long checksum_528, char * from_529)
{
if(CBOOL(require_initialization_114___ucs2)){
require_initialization_114___ucs2 = BBOOL(((bool_t)0));
imported_modules_init_94___ucs2();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* ucs2? */bool_t ucs2__10___ucs2(obj_t obj_1)
{
return UCS2P(obj_1);
}


/* _ucs2? */obj_t _ucs2__5___ucs2(obj_t env_424, obj_t obj_425)
{
{
bool_t aux_535;
{
obj_t obj_478;
obj_478 = obj_425;
aux_535 = UCS2P(obj_478);
}
return BBOOL(aux_535);
}
}


/* ucs2=? */bool_t ucs2___19___ucs2(ucs2_t ucs2a_2, ucs2_t ucs2b_3)
{
return (ucs2a_2) == (ucs2b_3);
}


/* _ucs2=?1141 */obj_t _ucs2__1141_238___ucs2(obj_t env_426, obj_t ucs2a_427, obj_t ucs2b_428)
{
{
bool_t aux_539;
{
ucs2_t ucs2a_479;
ucs2_t ucs2b_480;
ucs2a_479 = CUCS2(ucs2a_427);
ucs2b_480 = CUCS2(ucs2b_428);
aux_539 = (ucs2a_479) == (ucs2b_480);
}
return BBOOL(aux_539);
}
}


/* ucs2<? */bool_t ucs2___136___ucs2(ucs2_t ucs2a_4, ucs2_t ucs2b_5)
{
return (ucs2a_4) < (ucs2b_5);
}


/* _ucs2<?1142 */obj_t _ucs2__1142_3___ucs2(obj_t env_429, obj_t ucs2a_430, obj_t ucs2b_431)
{
{
bool_t aux_545;
{
ucs2_t ucs2a_481;
ucs2_t ucs2b_482;
ucs2a_481 = CUCS2(ucs2a_430);
ucs2b_482 = CUCS2(ucs2b_431);
aux_545 = (ucs2a_481) < (ucs2b_482);
}
return BBOOL(aux_545);
}
}


/* ucs2>? */bool_t ucs2___135___ucs2(ucs2_t ucs2a_6, ucs2_t ucs2b_7)
{
return (ucs2a_6) > (ucs2b_7);
}


/* _ucs2>?1143 */obj_t _ucs2__1143_100___ucs2(obj_t env_432, obj_t ucs2a_433, obj_t ucs2b_434)
{
{
bool_t aux_551;
{
ucs2_t ucs2a_483;
ucs2_t ucs2b_484;
ucs2a_483 = CUCS2(ucs2a_433);
ucs2b_484 = CUCS2(ucs2b_434);
aux_551 = (ucs2a_483) > (ucs2b_484);
}
return BBOOL(aux_551);
}
}


/* ucs2<=? */bool_t ucs2____55___ucs2(ucs2_t ucs2a_8, ucs2_t ucs2b_9)
{
return (ucs2a_8) <= (ucs2b_9);
}


/* _ucs2<=?1144 */obj_t _ucs2___1144_238___ucs2(obj_t env_435, obj_t ucs2a_436, obj_t ucs2b_437)
{
{
bool_t aux_557;
{
ucs2_t ucs2a_485;
ucs2_t ucs2b_486;
ucs2a_485 = CUCS2(ucs2a_436);
ucs2b_486 = CUCS2(ucs2b_437);
aux_557 = (ucs2a_485) <= (ucs2b_486);
}
return BBOOL(aux_557);
}
}


/* ucs2>=? */bool_t ucs2____52___ucs2(ucs2_t ucs2a_10, ucs2_t ucs2b_11)
{
return (ucs2a_10) >= (ucs2b_11);
}


/* _ucs2>=?1145 */obj_t _ucs2___1145_172___ucs2(obj_t env_438, obj_t ucs2a_439, obj_t ucs2b_440)
{
{
bool_t aux_563;
{
ucs2_t ucs2a_487;
ucs2_t ucs2b_488;
ucs2a_487 = CUCS2(ucs2a_439);
ucs2b_488 = CUCS2(ucs2b_440);
aux_563 = (ucs2a_487) >= (ucs2b_488);
}
return BBOOL(aux_563);
}
}


/* ucs2-ci=? */bool_t ucs2_ci___212___ucs2(ucs2_t ucs2a_12, ucs2_t ucs2b_13)
{
{
ucs2_t arg1005_489;
ucs2_t arg1006_490;
arg1005_489 = ucs2_toupper(ucs2a_12);
arg1006_490 = ucs2_toupper(ucs2b_13);
return (arg1005_489) == (arg1006_490);
}
}


/* _ucs2-ci=?1146 */obj_t _ucs2_ci__1146_46___ucs2(obj_t env_441, obj_t ucs2a_442, obj_t ucs2b_443)
{
{
bool_t aux_571;
{
ucs2_t ucs2a_491;
ucs2_t ucs2b_492;
ucs2a_491 = CUCS2(ucs2a_442);
ucs2b_492 = CUCS2(ucs2b_443);
{
ucs2_t arg1005_493;
ucs2_t arg1006_494;
arg1005_493 = ucs2_toupper(ucs2a_491);
arg1006_494 = ucs2_toupper(ucs2b_492);
aux_571 = (arg1005_493) == (arg1006_494);
}
}
return BBOOL(aux_571);
}
}


/* ucs2-ci<? */bool_t ucs2_ci___156___ucs2(ucs2_t ucs2a_14, ucs2_t ucs2b_15)
{
{
ucs2_t arg1007_495;
ucs2_t arg1008_496;
arg1007_495 = ucs2_toupper(ucs2a_14);
arg1008_496 = ucs2_toupper(ucs2b_15);
return (arg1007_495) < (arg1008_496);
}
}


/* _ucs2-ci<?1147 */obj_t _ucs2_ci__1147_19___ucs2(obj_t env_444, obj_t ucs2a_445, obj_t ucs2b_446)
{
{
bool_t aux_581;
{
ucs2_t ucs2a_497;
ucs2_t ucs2b_498;
ucs2a_497 = CUCS2(ucs2a_445);
ucs2b_498 = CUCS2(ucs2b_446);
{
ucs2_t arg1007_499;
ucs2_t arg1008_500;
arg1007_499 = ucs2_toupper(ucs2a_497);
arg1008_500 = ucs2_toupper(ucs2b_498);
aux_581 = (arg1007_499) < (arg1008_500);
}
}
return BBOOL(aux_581);
}
}


/* ucs2-ci>? */bool_t ucs2_ci___239___ucs2(ucs2_t ucs2a_16, ucs2_t ucs2b_17)
{
{
ucs2_t arg1009_501;
ucs2_t arg1010_502;
arg1009_501 = ucs2_toupper(ucs2a_16);
arg1010_502 = ucs2_toupper(ucs2b_17);
return (arg1009_501) > (arg1010_502);
}
}


/* _ucs2-ci>?1148 */obj_t _ucs2_ci__1148_198___ucs2(obj_t env_447, obj_t ucs2a_448, obj_t ucs2b_449)
{
{
bool_t aux_591;
{
ucs2_t ucs2a_503;
ucs2_t ucs2b_504;
ucs2a_503 = CUCS2(ucs2a_448);
ucs2b_504 = CUCS2(ucs2b_449);
{
ucs2_t arg1009_505;
ucs2_t arg1010_506;
arg1009_505 = ucs2_toupper(ucs2a_503);
arg1010_506 = ucs2_toupper(ucs2b_504);
aux_591 = (arg1009_505) > (arg1010_506);
}
}
return BBOOL(aux_591);
}
}


/* ucs2-ci<=? */bool_t ucs2_ci____166___ucs2(ucs2_t ucs2a_18, ucs2_t ucs2b_19)
{
{
ucs2_t arg1011_507;
ucs2_t arg1012_508;
arg1011_507 = ucs2_toupper(ucs2a_18);
arg1012_508 = ucs2_toupper(ucs2b_19);
return (arg1011_507) <= (arg1012_508);
}
}


/* _ucs2-ci<=?1149 */obj_t _ucs2_ci___1149_127___ucs2(obj_t env_450, obj_t ucs2a_451, obj_t ucs2b_452)
{
{
bool_t aux_601;
{
ucs2_t ucs2a_509;
ucs2_t ucs2b_510;
ucs2a_509 = CUCS2(ucs2a_451);
ucs2b_510 = CUCS2(ucs2b_452);
{
ucs2_t arg1011_511;
ucs2_t arg1012_512;
arg1011_511 = ucs2_toupper(ucs2a_509);
arg1012_512 = ucs2_toupper(ucs2b_510);
aux_601 = (arg1011_511) <= (arg1012_512);
}
}
return BBOOL(aux_601);
}
}


/* ucs2-ci>=? */bool_t ucs2_ci____165___ucs2(ucs2_t ucs2a_20, ucs2_t ucs2b_21)
{
{
ucs2_t arg1013_513;
ucs2_t arg1014_514;
arg1013_513 = ucs2_toupper(ucs2a_20);
arg1014_514 = ucs2_toupper(ucs2b_21);
return (arg1013_513) >= (arg1014_514);
}
}


/* _ucs2-ci>=?1150 */obj_t _ucs2_ci___1150_57___ucs2(obj_t env_453, obj_t ucs2a_454, obj_t ucs2b_455)
{
{
bool_t aux_611;
{
ucs2_t ucs2a_515;
ucs2_t ucs2b_516;
ucs2a_515 = CUCS2(ucs2a_454);
ucs2b_516 = CUCS2(ucs2b_455);
{
ucs2_t arg1013_517;
ucs2_t arg1014_518;
arg1013_517 = ucs2_toupper(ucs2a_515);
arg1014_518 = ucs2_toupper(ucs2b_516);
aux_611 = (arg1013_517) >= (arg1014_518);
}
}
return BBOOL(aux_611);
}
}


/* ucs2-alphabetic? */bool_t ucs2_alphabetic__226___ucs2(ucs2_t ucs2_22)
{
return ucs2_letterp(ucs2_22);
}


/* _ucs2-alphabetic?1151 */obj_t _ucs2_alphabetic_1151_6___ucs2(obj_t env_456, obj_t ucs2_457)
{
{
bool_t aux_619;
{
ucs2_t ucs2_519;
ucs2_519 = CUCS2(ucs2_457);
aux_619 = ucs2_letterp(ucs2_519);
}
return BBOOL(aux_619);
}
}


/* ucs2-numeric? */bool_t ucs2_numeric__113___ucs2(ucs2_t ucs2_23)
{
return ucs2_digitp(ucs2_23);
}


/* _ucs2-numeric?1152 */obj_t _ucs2_numeric_1152_149___ucs2(obj_t env_458, obj_t ucs2_459)
{
{
bool_t aux_624;
{
ucs2_t ucs2_520;
ucs2_520 = CUCS2(ucs2_459);
aux_624 = ucs2_digitp(ucs2_520);
}
return BBOOL(aux_624);
}
}


/* ucs2-whitespace? */bool_t ucs2_whitespace__106___ucs2(ucs2_t ucs2_24)
{
return ucs2_whitespacep(ucs2_24);
}


/* _ucs2-whitespace?1153 */obj_t _ucs2_whitespace_1153_205___ucs2(obj_t env_460, obj_t ucs2_461)
{
{
bool_t aux_629;
{
ucs2_t ucs2_521;
ucs2_521 = CUCS2(ucs2_461);
aux_629 = ucs2_whitespacep(ucs2_521);
}
return BBOOL(aux_629);
}
}


/* ucs2-upper-case? */bool_t ucs2_upper_case__41___ucs2(ucs2_t ucs2_25)
{
return ucs2_upperp(ucs2_25);
}


/* _ucs2-upper-case?1154 */obj_t _ucs2_upper_case_1154_27___ucs2(obj_t env_462, obj_t ucs2_463)
{
{
bool_t aux_634;
{
ucs2_t ucs2_522;
ucs2_522 = CUCS2(ucs2_463);
aux_634 = ucs2_upperp(ucs2_522);
}
return BBOOL(aux_634);
}
}


/* ucs2-lower-case? */bool_t ucs2_lower_case__105___ucs2(ucs2_t ucs2_26)
{
return ucs2_lowerp(ucs2_26);
}


/* _ucs2-lower-case?1155 */obj_t _ucs2_lower_case_1155_15___ucs2(obj_t env_464, obj_t ucs2_465)
{
{
bool_t aux_639;
{
ucs2_t ucs2_523;
ucs2_523 = CUCS2(ucs2_465);
aux_639 = ucs2_lowerp(ucs2_523);
}
return BBOOL(aux_639);
}
}


/* ucs2-upcase */ucs2_t ucs2_upcase_130___ucs2(ucs2_t ucs2_27)
{
return ucs2_toupper(ucs2_27);
}


/* _ucs2-upcase1156 */obj_t _ucs2_upcase1156_180___ucs2(obj_t env_466, obj_t ucs2_467)
{
{
ucs2_t aux_644;
{
ucs2_t ucs2_524;
ucs2_524 = CUCS2(ucs2_467);
aux_644 = ucs2_toupper(ucs2_524);
}
return BUCS2(aux_644);
}
}


/* ucs2-downcase */ucs2_t ucs2_downcase_102___ucs2(ucs2_t ucs2_28)
{
return ucs2_tolower(ucs2_28);
}


/* _ucs2-downcase1157 */obj_t _ucs2_downcase1157_63___ucs2(obj_t env_468, obj_t ucs2_469)
{
{
ucs2_t aux_649;
{
ucs2_t ucs2_525;
ucs2_525 = CUCS2(ucs2_469);
aux_649 = ucs2_tolower(ucs2_525);
}
return BUCS2(aux_649);
}
}


/* integer->ucs2 */ucs2_t integer__ucs2_47___ucs2(long int_29)
{
{
bool_t test_653;
if((int_29>((long)0))){
test_653 = (int_29<((long)65536));
}
 else {
test_653 = ((bool_t)0);
}
if(test_653){
bool_t test1016_253;
{
ucs2_t arg1017_254;
arg1017_254 = (ucs2_t)(int_29);
test1016_253 = ucs2_definedp(arg1017_254);
}
if(test1016_253){
return (ucs2_t)(int_29);
}
 else {
FAILURE(string1162___ucs2,string1163___ucs2,BINT(int_29));}
}
 else {
FAILURE(string1162___ucs2,string1164___ucs2,BINT(int_29));}
}
}


/* _integer->ucs21158 */obj_t _integer__ucs21158_101___ucs2(obj_t env_470, obj_t int_471)
{
{
ucs2_t aux_665;
aux_665 = integer__ucs2_47___ucs2((long)CINT(int_471));
return BUCS2(aux_665);
}
}


/* ucs2->integer */long ucs2__integer_171___ucs2(ucs2_t ucs2_30)
{
return (long)(ucs2_30);
}


/* _ucs2->integer1159 */obj_t _ucs2__integer1159_196___ucs2(obj_t env_472, obj_t ucs2_473)
{
{
long aux_670;
{
ucs2_t ucs2_526;
ucs2_526 = CUCS2(ucs2_473);
aux_670 = (long)(ucs2_526);
}
return BINT(aux_670);
}
}


/* char->ucs2 */ucs2_t char__ucs2_17___ucs2(char char_31)
{
return (ucs2_t)(char_31);
}


/* _char->ucs21160 */obj_t _char__ucs21160_206___ucs2(obj_t env_474, obj_t char_475)
{
{
ucs2_t aux_675;
{
char char_166_527;
char_166_527 = CCHAR(char_475);
aux_675 = (ucs2_t)(char_166_527);
}
return BUCS2(aux_675);
}
}


/* ucs2->char */char ucs2__char_237___ucs2(ucs2_t ucs2_32)
{
{
long int_416;
int_416 = (long)(ucs2_32);
if((int_416<((long)256))){
return (char)(int_416);
}
 else {
FAILURE(string1165___ucs2,string1166___ucs2,BUCS2(ucs2_32));}
}
}


/* _ucs2->char1161 */obj_t _ucs2__char1161_111___ucs2(obj_t env_476, obj_t ucs2_477)
{
{
char aux_685;
aux_685 = ucs2__char_237___ucs2(CUCS2(ucs2_477));
return BCHAR(aux_685);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___ucs2()
{
return module_initialization_70___error(((long)0), "__UCS2");
}

