/*===========================================================================*/
/*   (Llib/tvector.scm)                                                      */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _get_tvector_descriptor1170_167___tvector(obj_t, obj_t);
extern obj_t string_to_symbol(char *);
static obj_t _vector__tvector1174_33___tvector(obj_t, obj_t, obj_t);
static obj_t symbol1176___tvector = BUNSPEC;
extern obj_t bigloo_case_sensitive;
static obj_t _tvector_table__47___tvector = BUNSPEC;
extern obj_t assq___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t toplevel_init_63___tvector();
extern obj_t create_vector(long);
extern obj_t tvector_id_255___tvector(obj_t);
static obj_t _tvector_id1169_179___tvector(obj_t, obj_t);
static obj_t _declare_tvector_1171_134___tvector(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t tvector__vector_99___tvector(obj_t);
extern obj_t create_struct(obj_t, long);
extern obj_t string_to_bstring(char *);
extern obj_t vector__tvector_253___tvector(obj_t, obj_t);
static obj_t _tvector_length1168_139___tvector(obj_t, obj_t);
extern obj_t get_tvector_descriptor(obj_t);
static obj_t _tvector__38___tvector(obj_t, obj_t);
extern obj_t module_initialization_70___tvector(long, char *);
extern obj_t module_initialization_70___hash(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern long tvector_length_13___tvector(obj_t);
extern obj_t tvector_ref_208___tvector(obj_t);
extern bool_t tvector__195___tvector(obj_t);
extern obj_t declare_tvector__43___tvector(char *, obj_t, obj_t, obj_t);
extern long list_length(obj_t);
static obj_t _tvector_ref1172_15___tvector(obj_t, obj_t);
static obj_t _list__tvector1173_51___tvector(obj_t, obj_t, obj_t);
static obj_t _tvector__vector1175_193___tvector(obj_t, obj_t);
static obj_t imported_modules_init_94___tvector();
static obj_t require_initialization_114___tvector = BUNSPEC;
extern obj_t list__tvector_27___tvector(obj_t, obj_t);
static obj_t cnst_init_137___tvector();
extern obj_t string_upcase_71___r4_strings_6_7(obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( get_tvector_descriptor_env_131___tvector, _get_tvector_descriptor1170_167___tvector1183, _get_tvector_descriptor1170_167___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector__tvector_env_31___tvector, _vector__tvector1174_33___tvector1184, _vector__tvector1174_33___tvector, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( tvector_id_env_194___tvector, _tvector_id1169_179___tvector1185, _tvector_id1169_179___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( tvector__env_57___tvector, _tvector__38___tvector1186, _tvector__38___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( declare_tvector__env_37___tvector, _declare_tvector_1171_134___tvector1187, _declare_tvector_1171_134___tvector, 0L, 4 );
DEFINE_EXPORT_PROCEDURE( list__tvector_env_64___tvector, _list__tvector1173_51___tvector1188, _list__tvector1173_51___tvector, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( tvector__vector_env_184___tvector, _tvector__vector1175_193___tvector1189, _tvector__vector1175_193___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( tvector_ref_env_54___tvector, _tvector_ref1172_15___tvector1190, _tvector_ref1172_15___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( tvector_length_env_34___tvector, _tvector_length1168_139___tvector1191, _tvector_length1168_139___tvector, 0L, 1 );
DEFINE_STRING( string1181___tvector, string1181___tvector1192, "tvector->vector", 15 );
DEFINE_STRING( string1179___tvector, string1179___tvector1193, "Undeclared tvector", 18 );
DEFINE_STRING( string1180___tvector, string1180___tvector1194, "vector->tvector", 15 );
DEFINE_STRING( string1178___tvector, string1178___tvector1195, "Unable to convert to such tvector", 33 );
DEFINE_STRING( string1177___tvector, string1177___tvector1196, "list->tvector", 13 );


/* module-initialization */obj_t module_initialization_70___tvector(long checksum_704, char * from_705)
{
if(CBOOL(require_initialization_114___tvector)){
require_initialization_114___tvector = BBOOL(((bool_t)0));
cnst_init_137___tvector();
imported_modules_init_94___tvector();
toplevel_init_63___tvector();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___tvector()
{
return (symbol1176___tvector = string_to_symbol("TVECT-DESCR"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___tvector()
{
return (_tvector_table__47___tvector = BNIL,
BUNSPEC);
}


/* tvector? */bool_t tvector__195___tvector(obj_t obj_1)
{
return TVECTORP(obj_1);
}


/* _tvector? */obj_t _tvector__38___tvector(obj_t env_678, obj_t obj_679)
{
{
bool_t aux_714;
{
obj_t obj_702;
obj_702 = obj_679;
aux_714 = TVECTORP(obj_702);
}
return BBOOL(aux_714);
}
}


/* tvector-length */long tvector_length_13___tvector(obj_t obj_2)
{
return TVECTOR_LENGTH(obj_2);
}


/* _tvector-length1168 */obj_t _tvector_length1168_139___tvector(obj_t env_680, obj_t obj_681)
{
{
long aux_718;
{
obj_t obj_703;
obj_703 = obj_681;
aux_718 = TVECTOR_LENGTH(obj_703);
}
return BINT(aux_718);
}
}


/* tvector-id */obj_t tvector_id_255___tvector(obj_t tvect_3)
{
{
obj_t aux_721;
aux_721 = TVECTOR_DESCR(tvect_3);
return STRUCT_REF(aux_721, ((long)0));
}
}


/* _tvector-id1169 */obj_t _tvector_id1169_179___tvector(obj_t env_682, obj_t tvect_683)
{
return tvector_id_255___tvector(tvect_683);
}


/* get-tvector-descriptor */obj_t get_tvector_descriptor(obj_t id_22)
{
{
obj_t cell_509;
cell_509 = assq___r4_pairs_and_lists_6_3(id_22, _tvector_table__47___tvector);
if(PAIRP(cell_509)){
return CDR(cell_509);
}
 else {
return BFALSE;
}
}
}


/* _get-tvector-descriptor1170 */obj_t _get_tvector_descriptor1170_167___tvector(obj_t env_684, obj_t id_685)
{
return get_tvector_descriptor(id_685);
}


/* declare-tvector! */obj_t declare_tvector__43___tvector(char * id_23, obj_t allocate_24, obj_t ref_25, obj_t set_26)
{
{
obj_t id_513;
{
obj_t arg1026_514;
{
bool_t test1027_515;
{
obj_t obj1_521;
obj1_521 = bigloo_case_sensitive;
test1027_515 = (obj1_521==BUNSPEC);
}
if(test1027_515){
arg1026_514 = string_upcase_71___r4_strings_6_7(string_to_bstring(id_23));
}
 else {
arg1026_514 = string_to_bstring(id_23);
}
}
{
char * aux_735;
aux_735 = BSTRING_TO_STRING(arg1026_514);
id_513 = string_to_symbol(aux_735);
}
}
{
obj_t old_517;
{
obj_t cell_525;
cell_525 = assq___r4_pairs_and_lists_6_3(id_513, _tvector_table__47___tvector);
if(PAIRP(cell_525)){
old_517 = CDR(cell_525);
}
 else {
old_517 = BFALSE;
}
}
{
{
bool_t test_742;
if(STRUCTP(old_517)){
obj_t aux_745;
aux_745 = STRUCT_KEY(old_517);
test_742 = (aux_745==symbol1176___tvector);
}
 else {
test_742 = ((bool_t)0);
}
if(test_742){
return old_517;
}
 else {
obj_t new_519;
{
obj_t new_541;
new_541 = create_struct(symbol1176___tvector, ((long)4));
STRUCT_SET(new_541, ((long)3), set_26);
STRUCT_SET(new_541, ((long)2), ref_25);
STRUCT_SET(new_541, ((long)1), allocate_24);
STRUCT_SET(new_541, ((long)0), id_513);
new_519 = new_541;
}
{
obj_t arg1025_520;
arg1025_520 = MAKE_PAIR(id_513, new_519);
{
obj_t obj2_567;
obj2_567 = _tvector_table__47___tvector;
_tvector_table__47___tvector = MAKE_PAIR(arg1025_520, obj2_567);
}
}
return new_519;
}
}
}
}
}
}


/* _declare-tvector!1171 */obj_t _declare_tvector_1171_134___tvector(obj_t env_686, obj_t id_687, obj_t allocate_688, obj_t ref_689, obj_t set_690)
{
return declare_tvector__43___tvector(BSTRING_TO_STRING(id_687), allocate_688, ref_689, set_690);
}


/* tvector-ref */obj_t tvector_ref_208___tvector(obj_t tvector_27)
{
{
obj_t aux_757;
aux_757 = TVECTOR_DESCR(tvector_27);
return STRUCT_REF(aux_757, ((long)2));
}
}


/* _tvector-ref1172 */obj_t _tvector_ref1172_15___tvector(obj_t env_691, obj_t tvector_692)
{
return tvector_ref_208___tvector(tvector_692);
}


/* list->tvector */obj_t list__tvector_27___tvector(obj_t id_28, obj_t l_29)
{
{
obj_t descr_296;
{
obj_t cell_573;
cell_573 = assq___r4_pairs_and_lists_6_3(id_28, _tvector_table__47___tvector);
if(PAIRP(cell_573)){
descr_296 = CDR(cell_573);
}
 else {
descr_296 = BFALSE;
}
}
if(CBOOL(descr_296)){
obj_t allocate_297;
obj_t set_298;
allocate_297 = STRUCT_REF(descr_296, ((long)1));
set_298 = STRUCT_REF(descr_296, ((long)3));
if(PROCEDUREP(set_298)){
obj_t tvec_301;
{
obj_t aux_771;
{
long aux_772;
aux_772 = list_length(l_29);
aux_771 = BINT(aux_772);
}
tvec_301 = PROCEDURE_ENTRY(allocate_297)(allocate_297, aux_771, BEOA);
}
{
{
obj_t l_585;
long i_586;
l_585 = l_29;
i_586 = ((long)0);
loop_584:
if(NULLP(l_585)){
return tvec_301;
}
 else {
PROCEDURE_ENTRY(set_298)(set_298, tvec_301, BINT(i_586), CAR(l_585), BEOA);
{
long i_785;
obj_t l_783;
l_783 = CDR(l_585);
i_785 = (i_586+((long)1));
i_586 = i_785;
l_585 = l_783;
goto loop_584;
}
}
}
}
}
 else {
FAILURE(string1177___tvector,string1178___tvector,id_28);}
}
 else {
FAILURE(string1177___tvector,string1179___tvector,id_28);}
}
}


/* _list->tvector1173 */obj_t _list__tvector1173_51___tvector(obj_t env_693, obj_t id_694, obj_t l_695)
{
return list__tvector_27___tvector(id_694, l_695);
}


/* vector->tvector */obj_t vector__tvector_253___tvector(obj_t id_30, obj_t v_31)
{
{
obj_t descr_309;
{
obj_t cell_627;
cell_627 = assq___r4_pairs_and_lists_6_3(id_30, _tvector_table__47___tvector);
if(PAIRP(cell_627)){
descr_309 = CDR(cell_627);
}
 else {
descr_309 = BFALSE;
}
}
if(CBOOL(descr_309)){
obj_t allocate_310;
obj_t set_311;
allocate_310 = STRUCT_REF(descr_309, ((long)1));
set_311 = STRUCT_REF(descr_309, ((long)3));
if(PROCEDUREP(set_311)){
long len_313;
len_313 = VECTOR_LENGTH(v_31);
{
obj_t tvec_314;
tvec_314 = PROCEDURE_ENTRY(allocate_310)(allocate_310, BINT(len_313), BEOA);
{
{
long i_315;
i_315 = (len_313-((long)1));
loop_316:
if((i_315==((long)-1))){
return tvec_314;
}
 else {
PROCEDURE_ENTRY(set_311)(set_311, tvec_314, BINT(i_315), VECTOR_REF(v_31, i_315), BEOA);
{
long i_810;
i_810 = (i_315-((long)1));
i_315 = i_810;
goto loop_316;
}
}
}
}
}
}
 else {
FAILURE(string1180___tvector,string1178___tvector,id_30);}
}
 else {
FAILURE(string1180___tvector,string1179___tvector,id_30);}
}
}


/* _vector->tvector1174 */obj_t _vector__tvector1174_33___tvector(obj_t env_696, obj_t id_697, obj_t v_698)
{
return vector__tvector_253___tvector(id_697, v_698);
}


/* tvector->vector */obj_t tvector__vector_99___tvector(obj_t tv_32)
{
{
obj_t descr_321;
descr_321 = TVECTOR_DESCR(tv_32);
{
obj_t ref_323;
ref_323 = STRUCT_REF(descr_321, ((long)2));
if(PROCEDUREP(ref_323)){
long len_325;
len_325 = TVECTOR_LENGTH(tv_32);
{
obj_t vec_326;
vec_326 = create_vector(len_325);
{
{
long i_327;
i_327 = (len_325-((long)1));
loop_328:
if((i_327==((long)-1))){
return vec_326;
}
 else {
{
obj_t arg1044_331;
arg1044_331 = PROCEDURE_ENTRY(ref_323)(ref_323, tv_32, BINT(i_327), BEOA);
VECTOR_SET(vec_326, i_327, arg1044_331);
}
{
long i_828;
i_828 = (i_327-((long)1));
i_327 = i_828;
goto loop_328;
}
}
}
}
}
}
 else {
FAILURE(string1181___tvector,string1178___tvector,STRUCT_REF(descr_321, ((long)0)));}
}
}
}


/* _tvector->vector1175 */obj_t _tvector__vector1175_193___tvector(obj_t env_699, obj_t tv_700)
{
return tvector__vector_99___tvector(tv_700);
}


/* imported-modules-init */obj_t imported_modules_init_94___tvector()
{
module_initialization_70___error(((long)0), "__TVECTOR");
return module_initialization_70___hash(((long)0), "__TVECTOR");
}

