/*===========================================================================*/
/*   (Llib/socket.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _socket_down_1147_217___socket(obj_t, obj_t);
extern obj_t socket_host_address_114___socket(obj_t);
extern obj_t socket_port_number_142___socket(obj_t);
static obj_t _socket_output1150_42___socket(obj_t, obj_t);
static obj_t _socket_shutdown1155_85___socket(obj_t, obj_t, obj_t);
static obj_t _socket_hostname1145_250___socket(obj_t, obj_t);
extern obj_t socket_output_115___socket(obj_t);
static obj_t _socket_input1149_229___socket(obj_t, obj_t);
extern obj_t socket_shutdown(obj_t, bool_t);
extern obj_t make_server_socket(int);
extern obj_t socket_dup_120___socket(obj_t);
static obj_t _socket_port_number1148_97___socket(obj_t, obj_t);
extern bool_t socket_down__159___socket(obj_t);
extern obj_t socket_local_addr(obj_t);
extern obj_t make_server_socket_214___socket(obj_t);
extern obj_t socket_dup(obj_t);
static obj_t _make_server_socket_127___socket(obj_t, obj_t);
extern obj_t module_initialization_70___socket(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _make_client_socket1151_162___socket(obj_t, obj_t, obj_t);
static obj_t _socket_local_address1153_224___socket(obj_t, obj_t);
static obj_t _socket_dup1154_244___socket(obj_t, obj_t);
static obj_t _socket_accept_connection1152_52___socket(obj_t, obj_t);
static obj_t _socket__179___socket(obj_t, obj_t);
extern obj_t make_client_socket(obj_t, int);
extern obj_t socket_accept_connection(obj_t);
extern obj_t socket_shutdown_97___socket(obj_t, obj_t);
extern obj_t make_client_socket_228___socket(obj_t, int);
extern obj_t socket_hostname_170___socket(obj_t);
static obj_t imported_modules_init_94___socket();
extern bool_t socket__65___socket(obj_t);
extern obj_t socket_accept_connection_52___socket(obj_t);
extern obj_t socket_local_address_209___socket(obj_t);
static obj_t require_initialization_114___socket = BUNSPEC;
static obj_t _socket_host_address1146_186___socket(obj_t, obj_t);
extern obj_t socket_input_208___socket(obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( socket_input_env_54___socket, _socket_input1149_229___socket1157, _socket_input1149_229___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_client_socket_env_140___socket, _make_client_socket1151_162___socket1158, _make_client_socket1151_162___socket, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( socket__env_32___socket, _socket__179___socket1159, _socket__179___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_shutdown_env_247___socket, _socket_shutdown1155_85___socket1160, va_generic_entry, _socket_shutdown1155_85___socket, -2 );
DEFINE_EXPORT_PROCEDURE( socket_hostname_env_89___socket, _socket_hostname1145_250___socket1161, _socket_hostname1145_250___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_host_address_env_16___socket, _socket_host_address1146_186___socket1162, _socket_host_address1146_186___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_local_address_env_78___socket, _socket_local_address1153_224___socket1163, _socket_local_address1153_224___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_dup_env_192___socket, _socket_dup1154_244___socket1164, _socket_dup1154_244___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_output_env_172___socket, _socket_output1150_42___socket1165, _socket_output1150_42___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_accept_connection_env_59___socket, _socket_accept_connection1152_52___socket1166, _socket_accept_connection1152_52___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_down__env_139___socket, _socket_down_1147_217___socket1167, _socket_down_1147_217___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_server_socket_env_103___socket, _make_server_socket_127___socket1168, va_generic_entry, _make_server_socket_127___socket, -1 );
DEFINE_EXPORT_PROCEDURE( socket_port_number_env_160___socket, _socket_port_number1148_97___socket1169, _socket_port_number1148_97___socket, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___socket(long checksum_465, char * from_466)
{
if(CBOOL(require_initialization_114___socket)){
require_initialization_114___socket = BBOOL(((bool_t)0));
imported_modules_init_94___socket();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* socket? */bool_t socket__65___socket(obj_t obj_1)
{
return SOCKETP(obj_1);
}


/* _socket? */obj_t _socket__179___socket(obj_t env_422, obj_t obj_423)
{
{
bool_t aux_472;
{
obj_t obj_450;
obj_450 = obj_423;
aux_472 = SOCKETP(obj_450);
}
return BBOOL(aux_472);
}
}


/* socket-hostname */obj_t socket_hostname_170___socket(obj_t socket_2)
{
return SOCKET_HOSTNAME(socket_2);
}


/* _socket-hostname1145 */obj_t _socket_hostname1145_250___socket(obj_t env_424, obj_t socket_425)
{
{
obj_t socket_451;
socket_451 = socket_425;
return SOCKET_HOSTNAME(socket_451);
}
}


/* socket-host-address */obj_t socket_host_address_114___socket(obj_t socket_3)
{
return SOCKET_HOSTIP(socket_3);
}


/* _socket-host-address1146 */obj_t _socket_host_address1146_186___socket(obj_t env_426, obj_t socket_427)
{
{
obj_t socket_452;
socket_452 = socket_427;
return SOCKET_HOSTIP(socket_452);
}
}


/* socket-down? */bool_t socket_down__159___socket(obj_t socket_4)
{
return SOCKET_DOWNP(socket_4);
}


/* _socket-down?1147 */obj_t _socket_down_1147_217___socket(obj_t env_428, obj_t socket_429)
{
{
bool_t aux_480;
{
obj_t socket_453;
socket_453 = socket_429;
aux_480 = SOCKET_DOWNP(socket_453);
}
return BBOOL(aux_480);
}
}


/* socket-port-number */obj_t socket_port_number_142___socket(obj_t socket_5)
{
{
int aux_483;
aux_483 = SOCKET_PORT(socket_5);
return BINT(aux_483);
}
}


/* _socket-port-number1148 */obj_t _socket_port_number1148_97___socket(obj_t env_430, obj_t socket_431)
{
{
obj_t socket_454;
socket_454 = socket_431;
{
int aux_486;
aux_486 = SOCKET_PORT(socket_454);
return BINT(aux_486);
}
}
}


/* socket-input */obj_t socket_input_208___socket(obj_t socket_6)
{
return SOCKET_INPUT(socket_6);
}


/* _socket-input1149 */obj_t _socket_input1149_229___socket(obj_t env_432, obj_t socket_433)
{
{
obj_t socket_455;
socket_455 = socket_433;
return SOCKET_INPUT(socket_455);
}
}


/* socket-output */obj_t socket_output_115___socket(obj_t socket_7)
{
return SOCKET_OUTPUT(socket_7);
}


/* _socket-output1150 */obj_t _socket_output1150_42___socket(obj_t env_434, obj_t socket_435)
{
{
obj_t socket_456;
socket_456 = socket_435;
return SOCKET_OUTPUT(socket_456);
}
}


/* make-client-socket */obj_t make_client_socket_228___socket(obj_t hostname_8, int port_number_220_9)
{
return make_client_socket(hostname_8, port_number_220_9);
}


/* _make-client-socket1151 */obj_t _make_client_socket1151_162___socket(obj_t env_436, obj_t hostname_437, obj_t port_number_220_438)
{
{
obj_t hostname_457;
int port_number_220_458;
hostname_457 = hostname_437;
port_number_220_458 = CINT(port_number_220_438);
return make_client_socket(hostname_457, port_number_220_458);
}
}


/* make-server-socket */obj_t make_server_socket_214___socket(obj_t port_number_220_10)
{
{
int aux_496;
{
obj_t aux_497;
if(NULLP(port_number_220_10)){
aux_497 = BINT(((long)0));
}
 else {
aux_497 = CAR(port_number_220_10);
}
aux_496 = CINT(aux_497);
}
return make_server_socket(aux_496);
}
}


/* _make-server-socket */obj_t _make_server_socket_127___socket(obj_t env_439, obj_t port_number_220_440)
{
{
obj_t port_number_220_459;
port_number_220_459 = port_number_220_440;
{
int aux_504;
{
obj_t aux_505;
if(NULLP(port_number_220_459)){
aux_505 = BINT(((long)0));
}
 else {
aux_505 = CAR(port_number_220_459);
}
aux_504 = CINT(aux_505);
}
return make_server_socket(aux_504);
}
}
}


/* socket-accept-connection */obj_t socket_accept_connection_52___socket(obj_t socket_11)
{
return socket_accept_connection(socket_11);
}


/* _socket-accept-connection1152 */obj_t _socket_accept_connection1152_52___socket(obj_t env_441, obj_t socket_442)
{
{
obj_t socket_460;
socket_460 = socket_442;
return socket_accept_connection(socket_460);
}
}


/* socket-local-address */obj_t socket_local_address_209___socket(obj_t socket_12)
{
return socket_local_addr(socket_12);
}


/* _socket-local-address1153 */obj_t _socket_local_address1153_224___socket(obj_t env_443, obj_t socket_444)
{
{
obj_t socket_461;
socket_461 = socket_444;
return socket_local_addr(socket_461);
}
}


/* socket-dup */obj_t socket_dup_120___socket(obj_t socket_13)
{
return socket_dup(socket_13);
}


/* _socket-dup1154 */obj_t _socket_dup1154_244___socket(obj_t env_445, obj_t socket_446)
{
{
obj_t socket_462;
socket_462 = socket_446;
return socket_dup(socket_462);
}
}


/* socket-shutdown */obj_t socket_shutdown_97___socket(obj_t socket_14, obj_t close_15)
{
{
bool_t aux_518;
{
obj_t aux_519;
if(PAIRP(close_15)){
aux_519 = CAR(close_15);
}
 else {
aux_519 = BTRUE;
}
aux_518 = CBOOL(aux_519);
}
return socket_shutdown(socket_14, aux_518);
}
}


/* _socket-shutdown1155 */obj_t _socket_shutdown1155_85___socket(obj_t env_447, obj_t socket_448, obj_t close_449)
{
{
obj_t socket_463;
obj_t close_464;
socket_463 = socket_448;
close_464 = close_449;
{
bool_t aux_525;
{
obj_t aux_526;
if(PAIRP(close_464)){
aux_526 = CAR(close_464);
}
 else {
aux_526 = BTRUE;
}
aux_525 = CBOOL(aux_526);
}
return socket_shutdown(socket_463, aux_525);
}
}
}


/* imported-modules-init */obj_t imported_modules_init_94___socket()
{
return module_initialization_70___error(((long)0), "__SOCKET");
}

