/*===========================================================================*/
/*   (Llib/os.scm)                                                           */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

extern obj_t prefix___os(obj_t);
extern obj_t make_static_library_name_134___os(obj_t);
static obj_t _suffix1207___os(obj_t, obj_t);
extern obj_t command_line_67___os();
extern obj_t c_signal(int, obj_t);
static obj_t _chdir1203___os(obj_t, obj_t);
obj_t os_arch_255___os = BUNSPEC;
obj_t os_name_233___os = BUNSPEC;
static obj_t _getenv1201___os(obj_t, obj_t);
obj_t path_separator_174___os = BUNSPEC;
static obj_t toplevel_init_63___os();
obj_t os_version_65___os = BUNSPEC;
static obj_t _basename1204___os(obj_t, obj_t);
static obj_t _executable_name_113___os(obj_t);
static obj_t _make_static_library_name1209_26___os(obj_t, obj_t);
extern obj_t dirname___os(obj_t);
extern obj_t signal___os(int, obj_t);
extern obj_t string_to_bstring(char *);
static obj_t _make_shared_library_name1210_174___os(obj_t, obj_t);
extern obj_t pwd___os();
static obj_t _system1202___os(obj_t, obj_t);
extern obj_t basename___os(obj_t);
static obj_t _make_file_name1208_108___os(obj_t, obj_t, obj_t);
static obj_t _date___os(obj_t);
static obj_t lambda1013___os(obj_t);
static obj_t lambda1012___os(obj_t);
static obj_t lambda1011___os(obj_t);
static obj_t lambda1009___os(obj_t);
static obj_t lambda1008___os(obj_t);
static obj_t lambda1007___os(obj_t);
static obj_t lambda1005___os(obj_t);
extern obj_t make_string(long, unsigned char);
extern obj_t suffix___os(obj_t);
extern obj_t module_initialization_70___os(long, char *);
extern obj_t module_initialization_70___error(long, char *);
obj_t file_separator_81___os = BUNSPEC;
extern obj_t system___os(char *);
extern obj_t c_substring(obj_t, long, long);
extern obj_t get_signal_handler(int);
static obj_t _command_line_112___os(obj_t);
static obj_t _pwd___os(obj_t);
extern obj_t make_shared_library_name_78___os(obj_t);
obj_t os_tmp_175___os = BUNSPEC;
static obj_t _signal1199___os(obj_t, obj_t, obj_t);
static obj_t _prefix1205___os(obj_t, obj_t);
extern obj_t chdir___os(char *);
obj_t os_class_179___os = BUNSPEC;
extern obj_t command_line;
extern obj_t get_signal_handler_120___os(int);
static obj_t _get_signal_handler1200_233___os(obj_t, obj_t);
static obj_t _dirname1206___os(obj_t, obj_t);
extern char * date___os();
extern obj_t getenv___os(char *);
extern char * executable_name_99___os();
extern char * executable_name;
static obj_t imported_modules_init_94___os();
extern obj_t string_append_106___r4_strings_6_7(obj_t);
extern char * c_date();
static obj_t require_initialization_114___os = BUNSPEC;
extern obj_t make_file_name_203___os(obj_t, obj_t);
extern obj_t blit_string(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( basename_env_222___os, _basename1204___os1224, _basename1204___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( pwd_env_121___os, _pwd___os1225, _pwd___os, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( get_signal_handler_env_192___os, _get_signal_handler1200_233___os1226, _get_signal_handler1200_233___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( system_env_221___os, _system1202___os1227, _system1202___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( date_env_128___os, _date___os1228, _date___os, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( make_static_library_name_env_199___os, _make_static_library_name1209_26___os1229, _make_static_library_name1209_26___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( dirname_env_218___os, _dirname1206___os1230, _dirname1206___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( signal_env_180___os, _signal1199___os1231, _signal1199___os, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( prefix_env_157___os, _prefix1205___os1232, _prefix1205___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_shared_library_name_env_249___os, _make_shared_library_name1210_174___os1233, _make_shared_library_name1210_174___os, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1217___os, lambda1013___os1234, lambda1013___os, 0L, 0 );
DEFINE_STATIC_PROCEDURE( proc1216___os, lambda1012___os1235, lambda1012___os, 0L, 0 );
DEFINE_STATIC_PROCEDURE( proc1215___os, lambda1011___os1236, lambda1011___os, 0L, 0 );
DEFINE_STATIC_PROCEDURE( proc1214___os, lambda1009___os1237, lambda1009___os, 0L, 0 );
DEFINE_STATIC_PROCEDURE( proc1213___os, lambda1008___os1238, lambda1008___os, 0L, 0 );
DEFINE_STATIC_PROCEDURE( proc1212___os, lambda1007___os1239, lambda1007___os, 0L, 0 );
DEFINE_STATIC_PROCEDURE( proc1211___os, lambda1005___os1240, lambda1005___os, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( executable_name_env_184___os, _executable_name_113___os1241, _executable_name_113___os, 0L, 0 );
DEFINE_STRING( string1222___os, string1222___os1242, "", 0 );
DEFINE_STRING( string1221___os, string1221___os1243, ".", 1 );
DEFINE_STRING( string1219___os, string1219___os1244, "Illegal signal", 14 );
DEFINE_STRING( string1220___os, string1220___os1245, "Wrong number of arguments", 25 );
DEFINE_STRING( string1218___os, string1218___os1246, "signal", 6 );
DEFINE_EXPORT_PROCEDURE( chdir_env_87___os, _chdir1203___os1247, _chdir1203___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( suffix_env_109___os, _suffix1207___os1248, _suffix1207___os, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_file_name_env_223___os, _make_file_name1208_108___os1249, _make_file_name1208_108___os, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( command_line_env_109___os, _command_line_112___os1250, _command_line_112___os, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( getenv_env_98___os, _getenv1201___os1251, _getenv1201___os, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___os(long checksum_632, char * from_633)
{
if(CBOOL(require_initialization_114___os)){
require_initialization_114___os = BBOOL(((bool_t)0));
imported_modules_init_94___os();
toplevel_init_63___os();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* toplevel-init */obj_t toplevel_init_63___os()
{
{
obj_t lambda1005_588;
lambda1005_588 = proc1211___os;
os_class_179___os = lambda1005_588;
}
{
obj_t lambda1007_587;
lambda1007_587 = proc1212___os;
os_name_233___os = lambda1007_587;
}
{
obj_t lambda1008_586;
lambda1008_586 = proc1213___os;
os_arch_255___os = lambda1008_586;
}
{
obj_t lambda1009_585;
lambda1009_585 = proc1214___os;
os_version_65___os = lambda1009_585;
}
{
obj_t lambda1011_584;
lambda1011_584 = proc1215___os;
os_tmp_175___os = lambda1011_584;
}
{
obj_t lambda1012_583;
lambda1012_583 = proc1216___os;
file_separator_81___os = lambda1012_583;
}
{
obj_t lambda1013_582;
lambda1013_582 = proc1217___os;
return (path_separator_174___os = lambda1013_582,
BUNSPEC);
}
}


/* lambda1013 */obj_t lambda1013___os(obj_t env_589)
{
return BCHAR(PATH_SEPARATOR);
}


/* lambda1012 */obj_t lambda1012___os(obj_t env_590)
{
return BCHAR(FILE_SEPARATOR);
}


/* lambda1011 */obj_t lambda1011___os(obj_t env_591)
{
return string_to_bstring(OS_TMP);
}


/* lambda1009 */obj_t lambda1009___os(obj_t env_592)
{
return string_to_bstring(OS_VERSION);
}


/* lambda1008 */obj_t lambda1008___os(obj_t env_593)
{
return string_to_bstring(OS_ARCH);
}


/* lambda1007 */obj_t lambda1007___os(obj_t env_594)
{
return string_to_bstring(OS_NAME);
}


/* lambda1005 */obj_t lambda1005___os(obj_t env_595)
{
return string_to_bstring(OS_CLASS);
}


/* command-line */obj_t command_line_67___os()
{
return command_line;
}


/* _command-line */obj_t _command_line_112___os(obj_t env_596)
{
return command_line;
}


/* executable-name */char * executable_name_99___os()
{
return executable_name;
}


/* _executable-name */obj_t _executable_name_113___os(obj_t env_597)
{
return string_to_bstring(executable_name);
}


/* signal */obj_t signal___os(int num_1, obj_t proc_2)
{
{
bool_t test1014_238;
{
long arg1017_241;
arg1017_241 = PROCEDURE_ARITY(proc_2);
test1014_238 = (arg1017_241==((long)1));
}
if(test1014_238){
bool_t test_650;
{
bool_t test_651;
{
long aux_652;
aux_652 = (long)(num_1);
test_651 = (aux_652<((long)0));
}
if(test_651){
test_650 = ((bool_t)1);
}
 else {
long aux_655;
aux_655 = (long)(num_1);
test_650 = (aux_655>((long)31));
}
}
if(test_650){
FAILURE(string1218___os,string1219___os,BINT(num_1));}
 else {
return c_signal(num_1, proc_2);
}
}
 else {
FAILURE(string1218___os,string1220___os,proc_2);}
}
}


/* _signal1199 */obj_t _signal1199___os(obj_t env_598, obj_t num_599, obj_t proc_600)
{
return signal___os(CINT(num_599), proc_600);
}


/* get-signal-handler */obj_t get_signal_handler_120___os(int num_3)
{
return get_signal_handler(num_3);
}


/* _get-signal-handler1200 */obj_t _get_signal_handler1200_233___os(obj_t env_601, obj_t num_602)
{
{
int num_626;
num_626 = CINT(num_602);
return get_signal_handler(num_626);
}
}


/* getenv */obj_t getenv___os(char * string_4)
{
{
bool_t test1019_627;
test1019_627 = (long)getenv(string_4);
if(test1019_627){
char * aux_669;
aux_669 = (char *)getenv(string_4);
return string_to_bstring(aux_669);
}
 else {
return BFALSE;
}
}
}


/* _getenv1201 */obj_t _getenv1201___os(obj_t env_603, obj_t string_604)
{
{
char * string_628;
string_628 = BSTRING_TO_STRING(string_604);
{
bool_t test1019_629;
test1019_629 = (long)getenv(string_628);
if(test1019_629){
char * aux_675;
aux_675 = (char *)getenv(string_628);
return string_to_bstring(aux_675);
}
 else {
return BFALSE;
}
}
}
}


/* system */obj_t system___os(char * string_5)
{
{
int aux_678;
aux_678 = system(string_5);
return BINT(aux_678);
}
}


/* _system1202 */obj_t _system1202___os(obj_t env_605, obj_t string_606)
{
{
char * string_630;
string_630 = BSTRING_TO_STRING(string_606);
{
int aux_682;
aux_682 = system(string_630);
return BINT(aux_682);
}
}
}


/* date */char * date___os()
{
return c_date();
}


/* _date */obj_t _date___os(obj_t env_607)
{
{
char * aux_686;
aux_686 = c_date();
return string_to_bstring(aux_686);
}
}


/* chdir */obj_t chdir___os(char * dirname_6)
{
{
int aux_689;
aux_689 = chdir(dirname_6);
return BINT(aux_689);
}
}


/* _chdir1203 */obj_t _chdir1203___os(obj_t env_608, obj_t dirname_609)
{
{
char * dirname_631;
dirname_631 = BSTRING_TO_STRING(dirname_609);
{
int aux_693;
aux_693 = chdir(dirname_631);
return BINT(aux_693);
}
}
}


/* pwd */obj_t pwd___os()
{
{
obj_t string_448;
{
obj_t res1196_456;
{
long aux_696;
{
int aux_697;
aux_697 = (int)(((long)1021));
aux_696 = (long)(aux_697);
}
res1196_456 = make_string(aux_696, ((unsigned char)' '));
}
string_448 = res1196_456;
}
{
char * aux_701;
{
int aux_704;
char * aux_702;
aux_704 = (int)(((long)1024));
aux_702 = BSTRING_TO_STRING(string_448);
aux_701 = (char *)(long)getcwd(aux_702, aux_704);
}
return string_to_bstring(aux_701);
}
}
}


/* _pwd */obj_t _pwd___os(obj_t env_610)
{
return pwd___os();
}


/* basename */obj_t basename___os(obj_t string_7)
{
{
long index_246;
{
long aux_724;
aux_724 = STRING_LENGTH(string_7);
index_246 = (aux_724-((long)1));
}
loop_247:
if((index_246==((long)-1))){
return string_7;
}
 else {
bool_t test_711;
{
unsigned char aux_714;
unsigned char aux_712;
aux_714 = (unsigned char)(FILE_SEPARATOR);
aux_712 = STRING_REF(string_7, index_246);
test_711 = (aux_712==aux_714);
}
if(test_711){
{
long aux_719;
long aux_717;
aux_719 = STRING_LENGTH(string_7);
aux_717 = (index_246+((long)1));
return c_substring(string_7, aux_717, aux_719);
}
}
 else {
{
long index_722;
index_722 = (index_246-((long)1));
index_246 = index_722;
goto loop_247;
}
}
}
}
}


/* _basename1204 */obj_t _basename1204___os(obj_t env_611, obj_t string_612)
{
return basename___os(string_612);
}


/* prefix */obj_t prefix___os(obj_t string_8)
{
{
long len_257;
{
long aux_728;
aux_728 = STRING_LENGTH(string_8);
len_257 = (aux_728-((long)1));
}
{
long e_258;
long s_259;
e_258 = len_257;
s_259 = len_257;
loop_260:
if((s_259<=((long)0))){
{
long aux_733;
aux_733 = (((long)1)+e_258);
return c_substring(string_8, ((long)0), aux_733);
}
}
 else {
{
bool_t test_736;
{
bool_t test_737;
{
obj_t aux_742;
obj_t aux_738;
aux_742 = BCHAR(((unsigned char)'.'));
{
unsigned char aux_739;
aux_739 = STRING_REF(string_8, s_259);
aux_738 = BCHAR(aux_739);
}
test_737 = (aux_738==aux_742);
}
if(test_737){
test_736 = (e_258==len_257);
}
 else {
test_736 = ((bool_t)0);
}
}
if(test_736){
long s_748;
long e_746;
e_746 = (s_259-((long)1));
s_748 = (s_259-((long)1));
s_259 = s_748;
e_258 = e_746;
goto loop_260;
}
 else {
long s_750;
s_750 = (s_259-((long)1));
s_259 = s_750;
goto loop_260;
}
}
}
}
}
}


/* _prefix1205 */obj_t _prefix1205___os(obj_t env_613, obj_t string_614)
{
return prefix___os(string_614);
}


/* dirname */obj_t dirname___os(obj_t string_9)
{
{
long read_273;
{
long aux_782;
aux_782 = STRING_LENGTH(string_9);
read_273 = (aux_782-((long)1));
}
loop_274:
if((read_273<=((long)0))){
{
bool_t test_755;
{
unsigned char aux_758;
unsigned char aux_756;
aux_758 = (unsigned char)(FILE_SEPARATOR);
aux_756 = STRING_REF(string_9, read_273);
test_755 = (aux_756==aux_758);
}
if(test_755){
obj_t list1044_277;
{
obj_t aux_761;
aux_761 = BCHAR(FILE_SEPARATOR);
list1044_277 = MAKE_PAIR(aux_761, BNIL);
}
{
obj_t res1197_511;
{
unsigned char aux_768;
long aux_764;
{
obj_t aux_769;
aux_769 = CAR(list1044_277);
aux_768 = (unsigned char)CCHAR(aux_769);
}
{
int aux_765;
aux_765 = (int)(((long)1));
aux_764 = (long)(aux_765);
}
res1197_511 = make_string(aux_764, aux_768);
}
return res1197_511;
}
}
 else {
return string1221___os;
}
}
}
 else {
bool_t test_773;
{
unsigned char aux_776;
unsigned char aux_774;
aux_776 = (unsigned char)(FILE_SEPARATOR);
aux_774 = STRING_REF(string_9, read_273);
test_773 = (aux_774==aux_776);
}
if(test_773){
return c_substring(string_9, ((long)0), read_273);
}
 else {
{
long read_780;
read_780 = (read_273-((long)1));
read_273 = read_780;
goto loop_274;
}
}
}
}
}


/* _dirname1206 */obj_t _dirname1206___os(obj_t env_615, obj_t string_616)
{
return dirname___os(string_616);
}


/* suffix */obj_t suffix___os(obj_t string_10)
{
{
long len_285;
len_285 = STRING_LENGTH(string_10);
{
long len_1_56_286;
len_1_56_286 = (len_285-((long)1));
{
{
long read_287;
read_287 = len_1_56_286;
loop_288:
if((read_287<((long)0))){
return string1222___os;
}
 else {
bool_t test_790;
{
unsigned char aux_793;
unsigned char aux_791;
aux_793 = (unsigned char)(FILE_SEPARATOR);
aux_791 = STRING_REF(string_10, read_287);
test_790 = (aux_791==aux_793);
}
if(test_790){
return string1222___os;
}
 else {
bool_t test_796;
{
unsigned char aux_797;
aux_797 = STRING_REF(string_10, read_287);
test_796 = (aux_797==((unsigned char)'.'));
}
if(test_796){
if((read_287==len_1_56_286)){
return string1222___os;
}
 else {
{
long aux_802;
aux_802 = (read_287+((long)1));
return c_substring(string_10, aux_802, len_285);
}
}
}
 else {
{
long read_805;
read_805 = (read_287-((long)1));
read_287 = read_805;
goto loop_288;
}
}
}
}
}
}
}
}
}


/* _suffix1207 */obj_t _suffix1207___os(obj_t env_617, obj_t string_618)
{
return suffix___os(string_618);
}


/* make-file-name */obj_t make_file_name_203___os(obj_t directory_11, obj_t file_12)
{
{
long ldir_297;
ldir_297 = STRING_LENGTH(directory_11);
{
long lfile_298;
lfile_298 = STRING_LENGTH(file_12);
{
long len_299;
{
long aux_810;
aux_810 = (lfile_298+((long)1));
len_299 = (ldir_297+aux_810);
}
{
obj_t str_300;
{
obj_t list1062_303;
{
obj_t aux_813;
aux_813 = BCHAR(FILE_SEPARATOR);
list1062_303 = MAKE_PAIR(aux_813, BNIL);
}
{
obj_t res1198_555;
{
unsigned char aux_820;
long aux_816;
{
obj_t aux_821;
aux_821 = CAR(list1062_303);
aux_820 = (unsigned char)CCHAR(aux_821);
}
{
int aux_817;
aux_817 = (int)(len_299);
aux_816 = (long)(aux_817);
}
res1198_555 = make_string(aux_816, aux_820);
}
str_300 = res1198_555;
}
}
{
{
obj_t aux_829;
obj_t aux_827;
obj_t aux_825;
aux_829 = BINT(ldir_297);
aux_827 = BINT(((long)0));
aux_825 = BINT(((long)0));
blit_string(directory_11, aux_825, str_300, aux_827, aux_829);
}
{
obj_t aux_838;
obj_t aux_834;
obj_t aux_832;
aux_838 = BINT(lfile_298);
{
long aux_835;
aux_835 = (((long)1)+ldir_297);
aux_834 = BINT(aux_835);
}
aux_832 = BINT(((long)0));
blit_string(file_12, aux_832, str_300, aux_834, aux_838);
}
return str_300;
}
}
}
}
}
}


/* _make-file-name1208 */obj_t _make_file_name1208_108___os(obj_t env_619, obj_t directory_620, obj_t file_621)
{
return make_file_name_203___os(directory_620, file_621);
}


/* make-static-library-name */obj_t make_static_library_name_134___os(obj_t libname_13)
{
{
obj_t list1066_568;
{
obj_t arg1067_569;
{
obj_t arg1069_571;
{
obj_t aux_842;
aux_842 = string_to_bstring(STATIC_LIB_SUFFIX);
arg1069_571 = MAKE_PAIR(aux_842, BNIL);
}
arg1067_569 = MAKE_PAIR(string1221___os, arg1069_571);
}
list1066_568 = MAKE_PAIR(libname_13, arg1067_569);
}
return string_append_106___r4_strings_6_7(list1066_568);
}
}


/* _make-static-library-name1209 */obj_t _make_static_library_name1209_26___os(obj_t env_622, obj_t libname_623)
{
return make_static_library_name_134___os(libname_623);
}


/* make-shared-library-name */obj_t make_shared_library_name_78___os(obj_t libname_14)
{
{
obj_t list1071_573;
{
obj_t arg1072_574;
{
obj_t arg1076_576;
{
obj_t aux_849;
aux_849 = string_to_bstring(SHARED_LIB_SUFFIX);
arg1076_576 = MAKE_PAIR(aux_849, BNIL);
}
arg1072_574 = MAKE_PAIR(string1221___os, arg1076_576);
}
list1071_573 = MAKE_PAIR(libname_14, arg1072_574);
}
return string_append_106___r4_strings_6_7(list1071_573);
}
}


/* _make-shared-library-name1210 */obj_t _make_shared_library_name1210_174___os(obj_t env_624, obj_t libname_625)
{
return make_shared_library_name_78___os(libname_625);
}


/* imported-modules-init */obj_t imported_modules_init_94___os()
{
return module_initialization_70___error(((long)0), "__OS");
}

