/*===========================================================================*/
/*   (Llib/intext.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>


/* Object type definitions */

extern obj_t set_obj_string_mode__22___intext(obj_t);
static obj_t method_init_76___intext();
extern obj_t string_to_symbol(char *);
static obj_t read_string_238___intext(obj_t);
static obj_t _string__obj_110___intext(obj_t, obj_t);
static obj_t _defining__224___intext = BUNSPEC;
static long _pointeur__164___intext;
static obj_t _obj__string_80___intext(obj_t, obj_t);
static obj_t print_di_101___intext(obj_t, obj_t, obj_t);
extern obj_t string_to_obj(obj_t);
static obj_t pair_mark__18___intext(obj_t);
static obj_t _string_mark_table__203___intext = BUNSPEC;
static obj_t ucs2_string_mark__64___intext(obj_t);
static obj_t print_marqueur_131___intext(obj_t, obj_t, unsigned char);
extern obj_t remprop__243___r4_symbols_6_4(obj_t, obj_t);
extern obj_t obj_to_string(obj_t);
extern object_t struct_object__object_93___object(object_t, obj_t);
extern ucs2_t integer__ucs2_47___ucs2(long);
static bool_t _epair___65___intext;
static obj_t string_mark__64___intext(obj_t);
static obj_t tvector_mark__214___intext(obj_t, obj_t);
extern obj_t get_hash_29___hash(obj_t, obj_t);
extern object_t allocate_instance_244___object(obj_t);
extern obj_t module_initialization_70___intext(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t utf8_string_to_ucs2_string(obj_t);
extern obj_t make_hash_table_174___hash(long, obj_t, obj_t, obj_t, obj_t);
extern obj_t list__vector_101___r4_vectors_6_8(obj_t);
static obj_t pair_mark_gc__141___intext(obj_t);
static obj_t imported_modules_init_94___intext();
extern char * real_to_string(double);
extern obj_t string_to_keyword(char *);
static obj_t _car1828___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern obj_t make_struct(obj_t, long, obj_t);
extern obj_t make_real(double);
static obj_t toplevel_init_63___intext();
static long _ref__195___intext;
static long read_taille_23___intext(obj_t);
extern obj_t create_vector(long);
extern obj_t tvector_id_255___tvector(obj_t);
static obj_t read_item_156___intext(obj_t);
extern obj_t tvector__vector_99___tvector(obj_t);
static obj_t print_struct_142___intext(obj_t, obj_t, unsigned char, obj_t);
extern obj_t put_hash__129___hash(obj_t, obj_t);
static long marked_pair_length_178___intext(obj_t);
static obj_t verifie_taille_buffer__99___intext(obj_t, obj_t, obj_t);
extern long class_hash_237___object(obj_t);
extern obj_t string_to_bstring(char *);
extern obj_t getprop___r4_symbols_6_4(obj_t, obj_t);
static obj_t cell_mark__177___intext(obj_t);
extern obj_t vector__tvector_253___tvector(obj_t, obj_t);
static obj_t print_mot_68___intext(obj_t, obj_t, obj_t);
static obj_t loop___intext(obj_t);
static obj_t _set_obj_string_mode__37___intext(obj_t, obj_t);
extern obj_t ucs2_string_to_utf8_string(obj_t);
static obj_t symbol_mark__15___intext(obj_t);
extern obj_t putprop__88___r4_symbols_6_4(obj_t, obj_t, obj_t);
extern obj_t make_string(long, unsigned char);
extern obj_t c_substring(obj_t, long, long);
static obj_t arg1207___intext(obj_t, obj_t, obj_t);
static obj_t arg1206___intext(obj_t, obj_t);
static obj_t vector_mark__202___intext(obj_t);
extern obj_t _classes__134___object;
extern bool_t _2__206___r4_numbers_6_5(obj_t, obj_t);
static obj_t vector1831___intext = BUNSPEC;
static long taille_du_mot_75___intext(obj_t);
static obj_t object_mark__221___intext(obj_t, obj_t);
static obj_t symbol1839___intext = BUNSPEC;
extern obj_t object__struct_50___object(object_t);
static obj_t symbol1834___intext = BUNSPEC;
static obj_t symbol1833___intext = BUNSPEC;
static obj_t symbol1832___intext = BUNSPEC;
static long _taille_du_mot_maximum__8___intext;
static obj_t require_initialization_114___intext = BUNSPEC;
static obj_t get_ucs2_string_mark_32___intext(obj_t);
static obj_t print_item_54___intext(obj_t, obj_t, obj_t);
static obj_t struct_mark__56___intext(obj_t);
static obj_t cnst_init_137___intext();
extern obj_t blit_string(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t _ref_vector__211___intext = BUNSPEC;
static long _nb_ref__249___intext;
extern obj_t make_vector(long, obj_t);
static obj_t *__cnst;

extern obj_t car_env_2___r4_pairs_and_lists_6_3;
DEFINE_EXPORT_PROCEDURE( set_obj_string_mode__env_98___intext, _set_obj_string_mode__37___intext1850, _set_obj_string_mode__37___intext, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1843___intext, arg1206___intext1851, arg1206___intext, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1842___intext, arg1207___intext1852, arg1207___intext, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__obj_env_38___intext, _string__obj_110___intext1853, _string__obj_110___intext, 0L, 1 );
DEFINE_STRING( string1848___intext, string1848___intext1854, "Unknown object", 14 );
DEFINE_STRING( string1847___intext, string1847___intext1855, "can't extern process", 20 );
DEFINE_STRING( string1846___intext, string1846___intext1856, "can't extern procedure", 22 );
DEFINE_STRING( string1845___intext, string1845___intext1857, "Illegal string", 14 );
DEFINE_STRING( string1844___intext, string1844___intext1858, "cer", 3 );
DEFINE_STRING( string1841___intext, string1841___intext1859, "Illegal ucs2-string", 19 );
DEFINE_STRING( string1840___intext, string1840___intext1860, "obj->string", 11 );
DEFINE_STRING( string1838___intext, string1838___intext1861, "corrupted class", 15 );
DEFINE_STRING( string1837___intext, string1837___intext1862, "string->obj", 11 );
DEFINE_STRING( string1836___intext, string1836___intext1863, "Type `extended pair' expected for expression", 44 );
DEFINE_STRING( string1835___intext, string1835___intext1864, "set-cer!", 8 );
DEFINE_EXPORT_PROCEDURE( obj__string_env_242___intext, _obj__string_80___intext1865, _obj__string_80___intext, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___intext(long checksum_4408, char * from_4409)
{
if(CBOOL(require_initialization_114___intext)){
require_initialization_114___intext = BBOOL(((bool_t)0));
cnst_init_137___intext();
imported_modules_init_94___intext();
method_init_76___intext();
toplevel_init_63___intext();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___intext()
{
{
obj_t var_4404;
var_4404 = list__vector_101___r4_vectors_6_8(BNIL);
vector1831___intext = var_4404;
}
symbol1832___intext = string_to_symbol("EPAIR");
symbol1833___intext = string_to_symbol("PAIR");
symbol1834___intext = string_to_symbol("DONE");
return (symbol1839___intext = string_to_symbol("MARK"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___intext()
{
_ref_vector__211___intext = vector1831___intext;
_defining__224___intext = BFALSE;
_pointeur__164___intext = ((long)0);
_nb_ref__249___intext = ((long)0);
_ref__195___intext = ((long)0);
_epair___65___intext = ((bool_t)1);
_string_mark_table__203___intext = BNIL;
return (_taille_du_mot_maximum__8___intext = sizeof( long ),
BUNSPEC);
}


/* set-obj-string-mode! */obj_t set_obj_string_mode__22___intext(obj_t mode_1)
{
if((mode_1==symbol1832___intext)){
return (_epair___65___intext = ((bool_t)1),
BUNSPEC);
}
 else {
if((mode_1==symbol1833___intext)){
return (_epair___65___intext = ((bool_t)0),
BUNSPEC);
}
 else {
return BFALSE;
}
}
}


/* _set-obj-string-mode! */obj_t _set_obj_string_mode__37___intext(obj_t env_4362, obj_t mode_4363)
{
return set_obj_string_mode__22___intext(mode_4363);
}


/* string->obj */obj_t string_to_obj(obj_t s_2)
{
_pointeur__164___intext = ((long)0);
{
unsigned char d_553;
{
long k_1521;
k_1521 = _pointeur__164___intext;
d_553 = STRING_REF(s_2, k_1521);
}
if((d_553==((unsigned char)'c'))){
{
long z1_1524;
z1_1524 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1524+((long)1));
}
{
long arg1028_555;
arg1028_555 = read_taille_23___intext(s_2);
_ref_vector__211___intext = make_vector(arg1028_555, BUNSPEC);
}
}
 else {
BUNSPEC;
}
}
return read_item_156___intext(s_2);
}


/* read-item */obj_t read_item_156___intext(obj_t s_4393)
{
read_item_156___intext:
{
{
unsigned char d_558;
{
long k_1528;
k_1528 = _pointeur__164___intext;
d_558 = STRING_REF(s_4393, k_1528);
}
{
long z1_1529;
z1_1529 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1529+((long)1));
}
switch (d_558){
case ((unsigned char)'=') : 
_defining__224___intext = read_item_156___intext(s_4393);
{
goto read_item_156___intext;
}
break;
case ((unsigned char)'#') : 
{
obj_t arg1118_1531;
arg1118_1531 = read_item_156___intext(s_4393);
{
obj_t vector_1532;
vector_1532 = _ref_vector__211___intext;
{
long aux_4438;
aux_4438 = (long)CINT(arg1118_1531);
return VECTOR_REF(vector_1532, aux_4438);
}
}
}
break;
case ((unsigned char)'\'') : 
{
obj_t defining_683;
{
obj_t old_687;
old_687 = _defining__224___intext;
_defining__224___intext = BFALSE;
defining_683 = old_687;
}
{
obj_t res_684;
{
obj_t arg1116_686;
arg1116_686 = read_string_238___intext(s_4393);
{
char * aux_4442;
aux_4442 = BSTRING_TO_STRING(arg1116_686);
res_684 = string_to_symbol(aux_4442);
}
}
{
if(INTEGERP(defining_683)){
obj_t vector_1717;
vector_1717 = _ref_vector__211___intext;
{
long aux_4447;
aux_4447 = (long)CINT(defining_683);
VECTOR_SET(vector_1717, aux_4447, res_684);
}
}
 else {
BUNSPEC;
}
return res_684;
}
}
}
break;
case ((unsigned char)':') : 
{
obj_t arg1113_1534;
arg1113_1534 = read_string_238___intext(s_4393);
{
char * aux_4451;
aux_4451 = BSTRING_TO_STRING(arg1113_1534);
return string_to_keyword(aux_4451);
}
}
break;
case ((unsigned char)'a') : 
{
long arg1109_1536;
arg1109_1536 = read_taille_23___intext(s_4393);
{
unsigned char aux_4455;
aux_4455 = (arg1109_1536);
return BCHAR(aux_4455);
}
}
break;
case ((unsigned char)'u') : 
{
long arg1107_1538;
arg1107_1538 = read_taille_23___intext(s_4393);
{
ucs2_t aux_4459;
aux_4459 = integer__ucs2_47___ucs2(arg1107_1538);
return BUCS2(aux_4459);
}
}
break;
case ((unsigned char)'<') : 
{
long arg1111_1539;
arg1111_1539 = read_taille_23___intext(s_4393);
return BCNST(arg1111_1539);
}
break;
case ((unsigned char)'F') : 
return BFALSE;
break;
case ((unsigned char)'"') : 
return read_string_238___intext(s_4393);
break;
case ((unsigned char)'U') : 
{
obj_t arg1102_1540;
arg1102_1540 = read_item_156___intext(s_4393);
return utf8_string_to_ucs2_string(arg1102_1540);
}
break;
case ((unsigned char)'[') : 
{
long taille_658;
taille_658 = read_taille_23___intext(s_4393);
{
obj_t res_659;
res_659 = create_vector(taille_658);
{
{
bool_t test1096_660;
{
obj_t obj_1683;
obj_1683 = _defining__224___intext;
test1096_660 = INTEGERP(obj_1683);
}
if(test1096_660){
{
obj_t vector_1684;
long k_1685;
vector_1684 = _ref_vector__211___intext;
k_1685 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1684, k_1685, res_659);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_661;
i_661 = ((long)0);
for1007_662:
{
bool_t test_4473;
{
long aux_4474;
aux_4474 = (taille_658-((long)1));
test_4473 = (i_661<=aux_4474);
}
if(test_4473){
{
obj_t arg1098_664;
arg1098_664 = read_item_156___intext(s_4393);
VECTOR_SET(res_659, i_661, arg1098_664);
}
{
long i_4479;
i_4479 = (i_661+((long)1));
i_661 = i_4479;
goto for1007_662;
}
}
 else {
symbol1834___intext;
}
}
}
return res_659;
}
}
}
break;
case ((unsigned char)'t') : 
{
obj_t tag_647;
tag_647 = read_item_156___intext(s_4393);
{
long taille_648;
taille_648 = read_taille_23___intext(s_4393);
{
obj_t res_649;
res_649 = create_vector(taille_648);
{
{
long aux_4484;
aux_4484 = (long)CINT(tag_647);
VECTOR_TAG_SET(res_649, aux_4484);
}
{
bool_t test1090_650;
{
obj_t obj_1670;
obj_1670 = _defining__224___intext;
test1090_650 = INTEGERP(obj_1670);
}
if(test1090_650){
{
obj_t vector_1671;
long k_1672;
vector_1671 = _ref_vector__211___intext;
k_1672 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1671, k_1672, res_649);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_651;
i_651 = ((long)0);
for1008_652:
{
bool_t test_4491;
{
long aux_4492;
aux_4492 = (taille_648-((long)1));
test_4491 = (i_651<=aux_4492);
}
if(test_4491){
{
obj_t arg1092_654;
arg1092_654 = read_item_156___intext(s_4393);
VECTOR_SET(res_649, i_651, arg1092_654);
}
{
long i_4497;
i_4497 = (i_651+((long)1));
i_651 = i_4497;
goto for1008_652;
}
}
 else {
symbol1834___intext;
}
}
}
return res_649;
}
}
}
}
break;
case ((unsigned char)'V') : 
{
obj_t id_642;
id_642 = read_item_156___intext(s_4393);
{
obj_t v_643;
v_643 = read_item_156___intext(s_4393);
{
obj_t tv_644;
tv_644 = vector__tvector_253___tvector(id_642, v_643);
{
{
bool_t test1088_645;
{
obj_t obj_1664;
obj_1664 = _defining__224___intext;
test1088_645 = INTEGERP(obj_1664);
}
if(test1088_645){
{
obj_t vector_1665;
long k_1666;
vector_1665 = _ref_vector__211___intext;
k_1666 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1665, k_1666, tv_644);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
return tv_644;
}
}
}
}
break;
case ((unsigned char)'(') : 
{
long taille_623;
taille_623 = read_taille_23___intext(s_4393);
{
obj_t res_624;
res_624 = MAKE_PAIR(BNIL, BNIL);
{
{
bool_t test1074_625;
{
obj_t obj_1643;
obj_1643 = _defining__224___intext;
test1074_625 = INTEGERP(obj_1643);
}
if(test1074_625){
{
obj_t vector_1644;
long k_1645;
vector_1644 = _ref_vector__211___intext;
k_1645 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1644, k_1645, res_624);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_626;
obj_t hd_627;
i_626 = ((long)0);
hd_627 = res_624;
loop_628:
{
bool_t test_4512;
{
long aux_4513;
aux_4513 = (taille_623-((long)2));
test_4512 = (i_626==aux_4513);
}
if(test_4512){
{
obj_t arg1076_630;
arg1076_630 = read_item_156___intext(s_4393);
SET_CAR(hd_627, arg1076_630);
}
{
obj_t arg1077_631;
arg1077_631 = read_item_156___intext(s_4393);
SET_CDR(hd_627, arg1077_631);
}
}
 else {
{
obj_t arg1078_632;
arg1078_632 = read_item_156___intext(s_4393);
SET_CAR(hd_627, arg1078_632);
}
{
obj_t arg1079_633;
arg1079_633 = MAKE_PAIR(BNIL, BNIL);
SET_CDR(hd_627, arg1079_633);
}
{
obj_t hd_4526;
long i_4524;
i_4524 = (i_626+((long)1));
hd_4526 = CDR(hd_627);
hd_627 = hd_4526;
i_626 = i_4524;
goto loop_628;
}
}
}
}
return res_624;
}
}
}
break;
case ((unsigned char)'^') : 
{
long taille_602;
taille_602 = read_taille_23___intext(s_4393);
{
obj_t res_603;
res_603 = MAKE_EXTENDED_PAIR(BNIL, BNIL, BUNSPEC);
{
{
bool_t test1056_604;
{
obj_t obj_1605;
obj_1605 = _defining__224___intext;
test1056_604 = INTEGERP(obj_1605);
}
if(test1056_604){
{
obj_t vector_1606;
long k_1607;
vector_1606 = _ref_vector__211___intext;
k_1607 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1606, k_1607, res_603);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_605;
obj_t hd_606;
i_605 = ((long)0);
hd_606 = res_603;
loop_607:
{
bool_t test_4534;
{
long aux_4535;
aux_4535 = (taille_602-((long)2));
test_4534 = (i_605==aux_4535);
}
if(test_4534){
{
obj_t arg1058_609;
arg1058_609 = read_item_156___intext(s_4393);
SET_CAR(hd_606, arg1058_609);
}
{
obj_t arg1059_610;
arg1059_610 = read_item_156___intext(s_4393);
{
bool_t test1628_1617;
test1628_1617 = EXTENDED_PAIRP(hd_606);
if(test1628_1617){
SET_CER(hd_606, arg1059_610);
}
 else {
FAILURE(string1835___intext,string1836___intext,hd_606);}
}
}
{
obj_t arg1060_611;
arg1060_611 = read_item_156___intext(s_4393);
SET_CDR(hd_606, arg1060_611);
}
}
 else {
{
obj_t arg1061_612;
arg1061_612 = read_item_156___intext(s_4393);
SET_CAR(hd_606, arg1061_612);
}
{
obj_t arg1062_613;
arg1062_613 = read_item_156___intext(s_4393);
{
bool_t test1628_1628;
test1628_1628 = EXTENDED_PAIRP(hd_606);
if(test1628_1628){
SET_CER(hd_606, arg1062_613);
}
 else {
FAILURE(string1835___intext,string1836___intext,hd_606);}
}
}
{
obj_t arg1063_614;
arg1063_614 = MAKE_EXTENDED_PAIR(BNIL, BNIL, BUNSPEC);
SET_CDR(hd_606, arg1063_614);
}
{
obj_t hd_4558;
long i_4556;
i_4556 = (i_605+((long)1));
hd_4558 = CDR(hd_606);
hd_606 = hd_4558;
i_605 = i_4556;
goto loop_607;
}
}
}
}
return res_603;
}
}
}
break;
case ((unsigned char)'{') : 
{
obj_t defining_583;
{
obj_t old_595;
old_595 = _defining__224___intext;
_defining__224___intext = BFALSE;
defining_583 = old_595;
}
{
obj_t key_584;
key_584 = read_item_156___intext(s_4393);
{
long taille_585;
taille_585 = read_taille_23___intext(s_4393);
{
obj_t res_586;
res_586 = make_struct(key_584, taille_585, BUNSPEC);
{
if(INTEGERP(defining_583)){
obj_t vector_1585;
vector_1585 = _ref_vector__211___intext;
{
long aux_4565;
aux_4565 = (long)CINT(defining_583);
VECTOR_SET(vector_1585, aux_4565, res_586);
}
}
 else {
BUNSPEC;
}
{
long i_588;
i_588 = ((long)0);
for1009_589:
{
bool_t test_4568;
{
long aux_4569;
aux_4569 = (taille_585-((long)1));
test_4568 = (i_588<=aux_4569);
}
if(test_4568){
{
obj_t arg1047_591;
arg1047_591 = read_item_156___intext(s_4393);
STRUCT_SET(res_586, i_588, arg1047_591);
}
{
long i_4574;
i_4574 = (i_588+((long)1));
i_588 = i_4574;
goto for1009_589;
}
}
 else {
symbol1834___intext;
}
}
}
return res_586;
}
}
}
}
}
break;
case ((unsigned char)'|') : 
{
obj_t defining_564;
{
obj_t old_581;
old_581 = _defining__224___intext;
_defining__224___intext = BFALSE;
defining_564 = old_581;
}
{
obj_t key_565;
key_565 = read_item_156___intext(s_4393);
{
long taille_566;
taille_566 = read_taille_23___intext(s_4393);
{
obj_t struct_567;
struct_567 = make_struct(key_565, taille_566, BUNSPEC);
{
object_t object_568;
object_568 = allocate_instance_244___object(key_565);
{
if(INTEGERP(defining_564)){
obj_t vector_1554;
vector_1554 = _ref_vector__211___intext;
{
obj_t aux_4584;
long aux_4582;
aux_4584 = (obj_t)(object_568);
aux_4582 = (long)CINT(defining_564);
VECTOR_SET(vector_1554, aux_4582, aux_4584);
}
}
 else {
BUNSPEC;
}
{
long i_570;
i_570 = ((long)0);
for1010_571:
{
bool_t test_4587;
{
long aux_4588;
aux_4588 = (taille_566-((long)1));
test_4587 = (i_570<=aux_4588);
}
if(test_4587){
{
obj_t arg1037_573;
arg1037_573 = read_item_156___intext(s_4393);
STRUCT_SET(struct_567, i_570, arg1037_573);
}
{
long i_4593;
i_4593 = (i_570+((long)1));
i_570 = i_4593;
goto for1010_571;
}
}
 else {
symbol1834___intext;
}
}
}
{
obj_t hash_576;
hash_576 = read_item_156___intext(s_4393);
{
bool_t test1040_577;
{
long arg1041_578;
{
obj_t arg1042_579;
{
long arg1806_1567;
{
long arg1807_1568;
long arg1808_1569;
arg1807_1568 = TYPE( object_568 );
arg1808_1569 = OBJECT_TYPE;
arg1806_1567 = (arg1807_1568-arg1808_1569);
}
{
obj_t vector_1573;
vector_1573 = _classes__134___object;
arg1042_579 = VECTOR_REF(vector_1573, arg1806_1567);
}
}
arg1041_578 = class_hash_237___object(arg1042_579);
}
{
long aux_4601;
aux_4601 = (long)CINT(hash_576);
test1040_577 = (aux_4601==arg1041_578);
}
}
if(test1040_577){
object_t aux_4605;
aux_4605 = struct_object__object_93___object(object_568, struct_567);
return (obj_t)(aux_4605);
}
 else {
FAILURE(string1837___intext,string1838___intext,(obj_t)(object_568));}
}
}
}
}
}
}
}
}
break;
case ((unsigned char)'f') : 
{
double aux_4610;
{
long taille_692;
taille_692 = read_taille_23___intext(s_4393);
{
double res_693;
{
obj_t arg1121_694;
{
long arg1122_695;
{
long z1_1723;
z1_1723 = _pointeur__164___intext;
arg1122_695 = (z1_1723+taille_692);
}
{
long start_1726;
start_1726 = _pointeur__164___intext;
arg1121_694 = c_substring(s_4393, start_1726, arg1122_695);
}
}
{
char * aux_4614;
aux_4614 = BSTRING_TO_STRING(arg1121_694);
res_693 = strtod(aux_4614, ((long)0));
}
}
{
{
long z1_1729;
z1_1729 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1729+taille_692);
}
aux_4610 = res_693;
}
}
}
return make_real(aux_4610);
}
break;
case ((unsigned char)'-') : 
{
long arg1032_562;
arg1032_562 = read_taille_23___intext(s_4393);
{
long aux_4620;
aux_4620 = NEG(arg1032_562);
return BINT(aux_4620);
}
}
break;
case ((unsigned char)'!') : 
{
obj_t res_597;
res_597 = MAKE_CELL(BUNSPEC);
{
bool_t test1052_598;
{
obj_t obj_1598;
obj_1598 = _defining__224___intext;
test1052_598 = INTEGERP(obj_1598);
}
if(test1052_598){
{
obj_t vector_1599;
long k_1600;
vector_1599 = _ref_vector__211___intext;
k_1600 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1599, k_1600, res_597);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
obj_t arg1053_599;
arg1053_599 = read_item_156___intext(s_4393);
CELL_SET(res_597, arg1053_599);
}
return res_597;
}
break;
default: 
{
long z1_1543;
z1_1543 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1543-((long)1));
}
{
long aux_4631;
aux_4631 = read_taille_23___intext(s_4393);
return BINT(aux_4631);
}
}
}
}
}


/* read-string */obj_t read_string_238___intext(obj_t s_4394)
{
{
long taille_670;
taille_670 = read_taille_23___intext(s_4394);
{
obj_t res_671;
{
long arg1105_673;
{
long z1_1698;
z1_1698 = _pointeur__164___intext;
arg1105_673 = (z1_1698+taille_670);
}
{
long start_1701;
start_1701 = _pointeur__164___intext;
res_671 = c_substring(s_4394, start_1701, arg1105_673);
}
}
{
{
bool_t test1104_672;
{
obj_t obj_1703;
obj_1703 = _defining__224___intext;
test1104_672 = INTEGERP(obj_1703);
}
if(test1104_672){
{
obj_t vector_1704;
long k_1705;
vector_1704 = _ref_vector__211___intext;
k_1705 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1704, k_1705, res_671);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long z1_1707;
z1_1707 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1707+taille_670);
}
return res_671;
}
}
}
}


/* read-taille */long read_taille_23___intext(obj_t s_4395)
{
{
long accu_entier_43_698;
accu_entier_43_698 = ((long)0);
{
long taille_699;
{
unsigned char arg1130_708;
{
long k_1732;
k_1732 = _pointeur__164___intext;
arg1130_708 = STRING_REF(s_4395, k_1732);
}
taille_699 = (arg1130_708);
}
{
long z1_1734;
z1_1734 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1734+((long)1));
}
{
long i_700;
i_700 = ((long)0);
for1006_701:
{
bool_t test_4646;
{
long aux_4647;
aux_4647 = (taille_699-((long)1));
test_4646 = (i_700<=aux_4647);
}
if(test_4646){
{
unsigned char d_703;
{
long k_1741;
k_1741 = _pointeur__164___intext;
d_703 = STRING_REF(s_4395, k_1741);
}
{
long arg1126_704;
{
long z2_1743;
z2_1743 = accu_entier_43_698;
arg1126_704 = (((long)256)*z2_1743);
}
{
long aux_4652;
aux_4652 = (d_703);
accu_entier_43_698 = (arg1126_704+aux_4652);
}
}
{
long z1_1747;
z1_1747 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1747+((long)1));
}
}
{
long i_4656;
i_4656 = (i_700+((long)1));
i_700 = i_4656;
goto for1006_701;
}
}
 else {
symbol1834___intext;
}
}
}
return accu_entier_43_698;
}
}
}


/* _string->obj */obj_t _string__obj_110___intext(obj_t env_4364, obj_t s_4365)
{
return string_to_obj(s_4365);
}


/* pair-mark! */obj_t pair_mark__18___intext(obj_t pair_32)
{
{
obj_t new_752;
new_752 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_752, ((long)0), pair_32);
{
obj_t aux_4661;
aux_4661 = CDR(pair_32);
STRUCT_SET(new_752, ((long)1), aux_4661);
}
{
obj_t aux_4664;
aux_4664 = BINT(((long)0));
STRUCT_SET(new_752, ((long)4), aux_4664);
}
STRUCT_SET(new_752, ((long)3), BFALSE);
SET_CDR(pair_32, new_752);
return new_752;
}
}


/* cell-mark! */obj_t cell_mark__177___intext(obj_t cell_40)
{
{
obj_t new_764;
new_764 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_764, ((long)0), cell_40);
{
obj_t arg1160_765;
arg1160_765 = CELL_REF(cell_40);
STRUCT_SET(new_764, ((long)1), arg1160_765);
}
{
obj_t aux_4673;
aux_4673 = BINT(((long)0));
STRUCT_SET(new_764, ((long)4), aux_4673);
}
STRUCT_SET(new_764, ((long)3), BFALSE);
CELL_SET(cell_40, new_764);
return new_764;
}
}


/* symbol-mark! */obj_t symbol_mark__15___intext(obj_t symbol_43)
{
{
obj_t new_768;
new_768 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_768, ((long)0), symbol_43);
{
obj_t aux_4680;
aux_4680 = BINT(((long)0));
STRUCT_SET(new_768, ((long)4), aux_4680);
}
STRUCT_SET(new_768, ((long)3), BFALSE);
putprop__88___r4_symbols_6_4(symbol_43, symbol1839___intext, new_768);
return new_768;
}
}


/* string-mark! */obj_t string_mark__64___intext(obj_t ptr_48)
{
{
obj_t new_775;
new_775 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_775, ((long)0), ptr_48);
{
obj_t aux_4687;
aux_4687 = BINT(((long)0));
STRUCT_SET(new_775, ((long)4), aux_4687);
}
STRUCT_SET(new_775, ((long)3), BFALSE);
{
obj_t aux_4691;
{
long aux_4692;
aux_4692 = STRING_LENGTH(ptr_48);
aux_4691 = BINT(aux_4692);
}
STRUCT_SET(new_775, ((long)1), aux_4691);
}
{
obj_t arg1170_777;
arg1170_777 = MAKE_PAIR(ptr_48, new_775);
put_hash__129___hash(arg1170_777, _string_mark_table__203___intext);
}
INVERSE_STRING_LENGTH(ptr_48);
return new_775;
}
}


/* ucs2-string-mark! */obj_t ucs2_string_mark__64___intext(obj_t ptr_52)
{
{
obj_t new_783;
new_783 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_783, ((long)0), ptr_52);
{
obj_t aux_4701;
aux_4701 = BINT(((long)0));
STRUCT_SET(new_783, ((long)4), aux_4701);
}
STRUCT_SET(new_783, ((long)3), BFALSE);
{
obj_t aux_4705;
{
long aux_4706;
aux_4706 = UCS2_STRING_LENGTH(ptr_52);
aux_4705 = BINT(aux_4706);
}
STRUCT_SET(new_783, ((long)1), aux_4705);
}
{
obj_t arg1176_785;
arg1176_785 = ucs2_string_to_utf8_string(ptr_52);
STRUCT_SET(new_783, ((long)5), arg1176_785);
}
{
obj_t arg1177_786;
arg1177_786 = MAKE_PAIR(ptr_52, new_783);
put_hash__129___hash(arg1177_786, _string_mark_table__203___intext);
}
INVERSE_UCS2_STRING_LENGTH(ptr_52);
return new_783;
}
}


/* get-ucs2-string-mark */obj_t get_ucs2_string_mark_32___intext(obj_t ptr_54)
{
{
obj_t cell_2140;
cell_2140 = get_hash_29___hash(ptr_54, _string_mark_table__203___intext);
if(PAIRP(cell_2140)){
return CDR(cell_2140);
}
 else {
FAILURE(string1840___intext,string1841___intext,BUNSPEC);}
}
}


/* vector-mark! */obj_t vector_mark__202___intext(obj_t ptr_57)
{
{
obj_t new_795;
new_795 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_795, ((long)0), ptr_57);
{
obj_t aux_4722;
aux_4722 = VECTOR_REF(ptr_57, ((long)0));
STRUCT_SET(new_795, ((long)1), aux_4722);
}
{
obj_t aux_4725;
aux_4725 = BINT(((long)0));
STRUCT_SET(new_795, ((long)4), aux_4725);
}
STRUCT_SET(new_795, ((long)3), BFALSE);
VECTOR_SET(ptr_57, ((long)0), new_795);
return new_795;
}
}


/* tvector-mark! */obj_t tvector_mark__214___intext(obj_t ptr_61, obj_t v_62)
{
{
obj_t new_801;
new_801 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_801, ((long)0), ptr_61);
{
obj_t arg1188_802;
arg1188_802 = PEEK(ptr_61, ((long)2));
STRUCT_SET(new_801, ((long)1), arg1188_802);
}
{
obj_t aux_4734;
aux_4734 = BINT(((long)0));
STRUCT_SET(new_801, ((long)4), aux_4734);
}
STRUCT_SET(new_801, ((long)3), BFALSE);
STRUCT_SET(new_801, ((long)5), v_62);
POKE(ptr_61, ((long)2), new_801);
return new_801;
}
}


/* struct-mark! */obj_t struct_mark__56___intext(obj_t ptr_67)
{
{
obj_t new_808;
new_808 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_808, ((long)0), ptr_67);
{
obj_t arg1193_809;
arg1193_809 = PEEK(ptr_67, STRUCTURE_MARK_OFFSET);
STRUCT_SET(new_808, ((long)1), arg1193_809);
}
{
obj_t aux_4744;
aux_4744 = BINT(((long)0));
STRUCT_SET(new_808, ((long)4), aux_4744);
}
STRUCT_SET(new_808, ((long)3), BFALSE);
POKE(ptr_67, STRUCTURE_MARK_OFFSET, new_808);
return new_808;
}
}


/* object-mark! */obj_t object_mark__221___intext(obj_t ptr_70, obj_t struct_71)
{
{
obj_t new_812;
new_812 = make_struct(symbol1839___intext, ((long)6), BNIL);
STRUCT_SET(new_812, ((long)0), ptr_70);
{
obj_t aux_4751;
{
object_t aux_4752;
aux_4752 = (object_t)(ptr_70);
aux_4751 = OBJECT_WIDENING(aux_4752);
}
STRUCT_SET(new_812, ((long)1), aux_4751);
}
STRUCT_SET(new_812, ((long)5), struct_71);
{
obj_t aux_4757;
aux_4757 = BINT(((long)0));
STRUCT_SET(new_812, ((long)4), aux_4757);
}
STRUCT_SET(new_812, ((long)3), BFALSE);
{
object_t aux_4761;
aux_4761 = (object_t)(ptr_70);
OBJECT_WIDENING_SET(aux_4761, new_812);
}
return new_812;
}
}


/* taille-du-mot */long taille_du_mot_75___intext(obj_t m_76)
{
{
long taille_2468;
obj_t m_2469;
taille_2468 = ((long)0);
m_2469 = m_76;
loop_2467:
{
bool_t test_4764;
{
long aux_4765;
aux_4765 = (long)CINT(m_2469);
test_4764 = (aux_4765==((long)0));
}
if(test_4764){
return taille_2468;
}
 else {
obj_t m_4770;
long taille_4768;
taille_4768 = (taille_2468+((long)1));
{
long aux_4771;
{
long aux_4772;
aux_4772 = (long)CINT(m_2469);
aux_4771 = (aux_4772 >> ((long)8));
}
m_4770 = BINT(aux_4771);
}
m_2469 = m_4770;
taille_2468 = taille_4768;
goto loop_2467;
}
}
}
}


/* obj->string */obj_t obj_to_string(obj_t obj_77)
{
_ref__195___intext = ((long)-1);
_nb_ref__249___intext = ((long)0);
_pointeur__164___intext = ((long)0);
{
obj_t length_buffer_16_825;
{
obj_t cellval_4776;
cellval_4776 = BINT(((long)100));
length_buffer_16_825 = MAKE_CELL(cellval_4776);
}
{
obj_t buffer_826;
{
obj_t cellval_4778;
{
obj_t list1542_1245;
{
obj_t aux_4779;
aux_4779 = BCHAR(((unsigned char)' '));
list1542_1245 = MAKE_PAIR(aux_4779, BNIL);
}
{
obj_t res1818_2508;
{
int k_2502;
{
obj_t aux_4782;
aux_4782 = CELL_REF(length_buffer_16_825);
k_2502 = CINT(aux_4782);
}
{
unsigned char aux_4786;
long aux_4784;
{
obj_t aux_4787;
aux_4787 = CAR(list1542_1245);
aux_4786 = (unsigned char)CCHAR(aux_4787);
}
aux_4784 = (long)(k_2502);
res1818_2508 = make_string(aux_4784, aux_4786);
}
}
cellval_4778 = res1818_2508;
}
}
buffer_826 = MAKE_CELL(cellval_4778);
}
{
{
obj_t arg1207_4366;
obj_t arg1206_4367;
arg1207_4366 = proc1842___intext;
arg1206_4367 = proc1843___intext;
_string_mark_table__203___intext = make_hash_table_174___hash(((long)1024), arg1206_4367, car_env_2___r4_pairs_and_lists_6_3, arg1207_4366, BNIL);
}
{
obj_t obj_4405;
obj_4405 = obj_77;
loop___intext(obj_4405);
}
_pointeur__164___intext = ((long)0);
{
bool_t test1211_857;
{
long n1_2509;
n1_2509 = _nb_ref__249___intext;
test1211_857 = (n1_2509>((long)0));
}
if(test1211_857){
verifie_taille_buffer__99___intext(buffer_826, length_buffer_16_825, BINT(((long)0)));
{
obj_t string_2512;
long k_2513;
string_2512 = CELL_REF(buffer_826);
k_2513 = _pointeur__164___intext;
STRING_SET(string_2512, k_2513, ((unsigned char)'c'));
}
{
long z1_2515;
z1_2515 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2515+((long)1));
}
print_di_101___intext(buffer_826, length_buffer_16_825, BINT(_nb_ref__249___intext));
}
 else {
BUNSPEC;
}
}
print_item_54___intext(buffer_826, length_buffer_16_825, obj_77);
_string_mark_table__203___intext = BUNSPEC;
{
obj_t string_2517;
long end_2519;
string_2517 = CELL_REF(buffer_826);
end_2519 = _pointeur__164___intext;
return c_substring(string_2517, ((long)0), end_2519);
}
}
}
}
}


/* print-struct */obj_t print_struct_142___intext(obj_t buffer_4380, obj_t length_buffer_16_4379, unsigned char marqueur_1076, obj_t item_1077)
{
{
obj_t v_1160;
long len_1161;
{
bool_t test1435_1079;
{
obj_t arg1461_1103;
arg1461_1103 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
{
obj_t aux_4804;
aux_4804 = STRUCT_REF(arg1461_1103, ((long)3));
test1435_1079 = CBOOL(aux_4804);
}
}
if(test1435_1079){
verifie_taille_buffer__99___intext(buffer_4380, length_buffer_16_4379, BINT(((long)0)));
{
obj_t string_3547;
long k_3548;
string_3547 = CELL_REF(buffer_4380);
k_3548 = _pointeur__164___intext;
STRING_SET(string_3547, k_3548, ((unsigned char)'#'));
}
{
long z1_3550;
z1_3550 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3550+((long)1));
}
{
obj_t arg1436_1080;
{
obj_t arg1437_1081;
arg1437_1081 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1436_1080 = STRUCT_REF(arg1437_1081, ((long)2));
}
print_di_101___intext(buffer_4380, length_buffer_16_4379, arg1436_1080);
}
{
obj_t arg1438_1082;
long arg1440_1083;
arg1438_1082 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
{
obj_t arg1441_1084;
{
obj_t arg1444_1086;
arg1444_1086 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1441_1084 = STRUCT_REF(arg1444_1086, ((long)4));
}
{
long aux_4818;
aux_4818 = (long)CINT(arg1441_1084);
arg1440_1083 = (aux_4818-((long)1));
}
}
{
obj_t aux_4821;
aux_4821 = BINT(arg1440_1083);
STRUCT_SET(arg1438_1082, ((long)4), aux_4821);
}
}
{
bool_t test1445_1087;
{
obj_t arg1446_1088;
{
obj_t arg1449_1090;
arg1449_1090 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1446_1088 = STRUCT_REF(arg1449_1090, ((long)4));
}
{
long aux_4826;
aux_4826 = (long)CINT(arg1446_1088);
test1445_1087 = (aux_4826==((long)0));
}
}
if(test1445_1087){
obj_t old_value_175_3583;
{
obj_t arg1192_3584;
arg1192_3584 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
old_value_175_3583 = STRUCT_REF(arg1192_3584, ((long)1));
}
return POKE(item_1077, STRUCTURE_MARK_OFFSET, old_value_175_3583);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test1450_1091;
{
obj_t arg1456_1100;
{
obj_t arg1460_1102;
arg1460_1102 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1456_1100 = STRUCT_REF(arg1460_1102, ((long)4));
}
{
long aux_4835;
aux_4835 = (long)CINT(arg1456_1100);
test1450_1091 = (aux_4835==((long)0));
}
}
if(test1450_1091){
{
obj_t old_value_175_3603;
{
obj_t arg1192_3604;
arg1192_3604 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
old_value_175_3603 = STRUCT_REF(arg1192_3604, ((long)1));
}
POKE(item_1077, STRUCTURE_MARK_OFFSET, old_value_175_3603);
}
verifie_taille_buffer__99___intext(buffer_4380, length_buffer_16_4379, BINT(((long)0)));
{
obj_t string_3615;
long k_3616;
string_3615 = CELL_REF(buffer_4380);
k_3616 = _pointeur__164___intext;
STRING_SET(string_3615, k_3616, marqueur_1076);
}
{
long z1_3618;
z1_3618 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3618+((long)1));
}
print_item_54___intext(buffer_4380, length_buffer_16_4379, STRUCT_KEY(item_1077));
v_1160 = item_1077;
len_1161 = STRUCT_LENGTH(item_1077);
print_du_185_1237:
verifie_taille_buffer__99___intext(buffer_4380, length_buffer_16_4379, BINT(len_1161));
print_mot_68___intext(buffer_4380, length_buffer_16_4379, BINT(len_1161));
{
long i_1163;
i_1163 = ((long)0);
for1014_1164:
{
bool_t test_4852;
{
long aux_4853;
aux_4853 = (len_1161-((long)1));
test_4852 = (i_1163<=aux_4853);
}
if(test_4852){
print_item_54___intext(buffer_4380, length_buffer_16_4379, STRUCT_REF(v_1160, i_1163));
{
long i_4858;
i_4858 = (i_1163+((long)1));
i_1163 = i_4858;
goto for1014_1164;
}
}
 else {
return symbol1834___intext;
}
}
}
}
 else {
{
long ref_1094;
{
long z1_3622;
z1_3622 = _ref__195___intext;
_ref__195___intext = (z1_3622+((long)1));
}
ref_1094 = _ref__195___intext;
{
obj_t mark_1095;
mark_1095 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
{
long len_1096;
len_1096 = STRUCT_LENGTH(item_1077);
{
obj_t key_1097;
key_1097 = BUNSPEC;
{
{
obj_t aux_4864;
aux_4864 = STRUCT_REF(mark_1095, ((long)1));
POKE(item_1077, STRUCTURE_MARK_OFFSET, aux_4864);
}
key_1097 = STRUCT_KEY(item_1077);
POKE(item_1077, STRUCTURE_MARK_OFFSET, mark_1095);
{
obj_t aux_4869;
aux_4869 = BINT(ref_1094);
STRUCT_SET(mark_1095, ((long)2), aux_4869);
}
STRUCT_SET(mark_1095, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4380, length_buffer_16_4379, BINT(((long)0)));
{
obj_t string_3651;
long k_3652;
string_3651 = CELL_REF(buffer_4380);
k_3652 = _pointeur__164___intext;
STRING_SET(string_3651, k_3652, ((unsigned char)'='));
}
{
long z1_3654;
z1_3654 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3654+((long)1));
}
print_di_101___intext(buffer_4380, length_buffer_16_4379, BINT(ref_1094));
verifie_taille_buffer__99___intext(buffer_4380, length_buffer_16_4379, BINT(((long)0)));
{
obj_t string_3657;
long k_3658;
string_3657 = CELL_REF(buffer_4380);
k_3658 = _pointeur__164___intext;
STRING_SET(string_3657, k_3658, marqueur_1076);
}
{
long z1_3660;
z1_3660 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3660+((long)1));
}
print_item_54___intext(buffer_4380, length_buffer_16_4379, key_1097);
{
long len_4885;
obj_t v_4884;
v_4884 = item_1077;
len_4885 = len_1096;
len_1161 = len_4885;
v_1160 = v_4884;
goto print_du_185_1237;
}
}
}
}
}
}
}
}
}
}
}


/* pair-mark-gc! */obj_t pair_mark_gc__141___intext(obj_t p_1150)
{
{
obj_t mark_1152;
mark_1152 = CDR(p_1150);
{
bool_t test_4887;
{
bool_t test_4888;
{
obj_t aux_4889;
aux_4889 = STRUCT_REF(mark_1152, ((long)3));
test_4888 = CBOOL(aux_4889);
}
if(test_4888){
long aux_4892;
{
obj_t aux_4893;
aux_4893 = STRUCT_REF(mark_1152, ((long)4));
aux_4892 = (long)CINT(aux_4893);
}
test_4887 = (aux_4892>((long)0));
}
 else {
test_4887 = ((bool_t)0);
}
}
if(test_4887){
obj_t aux_4897;
{
long aux_4898;
{
long aux_4899;
{
obj_t aux_4900;
aux_4900 = STRUCT_REF(mark_1152, ((long)4));
aux_4899 = (long)CINT(aux_4900);
}
aux_4898 = (aux_4899-((long)1));
}
aux_4897 = BINT(aux_4898);
}
return STRUCT_SET(mark_1152, ((long)4), aux_4897);
}
 else {
obj_t aux_4906;
aux_4906 = STRUCT_REF(mark_1152, ((long)1));
return SET_CDR(p_1150, aux_4906);
}
}
}
}


/* print-mot */obj_t print_mot_68___intext(obj_t buffer_4382, obj_t length_buffer_16_4381, obj_t m_1196)
{
{
long taille_1198;
taille_1198 = taille_du_mot_75___intext(m_1196);
if((taille_1198==((long)0))){
return print_marqueur_131___intext(buffer_4382, length_buffer_16_4381, (((long)0)));
}
 else {
print_marqueur_131___intext(buffer_4382, length_buffer_16_4381, (taille_1198));
{
long i_1200;
i_1200 = (taille_1198-((long)1));
loop_1201:
if((i_1200==((long)-1))){
return symbol1834___intext;
}
 else {
{
unsigned char aux_4918;
{
long aux_4919;
{
long aux_4920;
{
long aux_4923;
long aux_4921;
aux_4923 = (((long)8)*i_1200);
aux_4921 = (long)CINT(m_1196);
aux_4920 = (aux_4921 >> aux_4923);
}
aux_4919 = (aux_4920 & ((long)255));
}
aux_4918 = (aux_4919);
}
print_marqueur_131___intext(buffer_4382, length_buffer_16_4381, aux_4918);
}
{
long i_4929;
i_4929 = (i_1200-((long)1));
i_1200 = i_4929;
goto loop_1201;
}
}
}
}
}
}


/* print-marqueur */obj_t print_marqueur_131___intext(obj_t buffer_4384, obj_t length_buffer_16_4383, unsigned char c_1212)
{
verifie_taille_buffer__99___intext(buffer_4384, length_buffer_16_4383, BINT(((long)0)));
{
obj_t string_3852;
long k_3853;
string_3852 = CELL_REF(buffer_4384);
k_3853 = _pointeur__164___intext;
STRING_SET(string_3852, k_3853, c_1212);
}
{
long z1_3855;
z1_3855 = _pointeur__164___intext;
return (_pointeur__164___intext = (z1_3855+((long)1)),
BUNSPEC);
}
}


/* verifie-taille-buffer! */obj_t verifie_taille_buffer__99___intext(obj_t buffer_4386, obj_t length_buffer_16_4385, obj_t taille_1214)
{
{
long l_1216;
{
long z1_3861;
z1_3861 = _pointeur__164___intext;
{
long aux_4936;
{
long aux_4939;
long aux_4937;
aux_4939 = (_taille_du_mot_maximum__8___intext+((long)1));
aux_4937 = (long)CINT(taille_1214);
aux_4936 = (aux_4937+aux_4939);
}
l_1216 = (z1_3861+aux_4936);
}
}
{
bool_t test1534_1217;
{
long n2_3864;
{
obj_t aux_4943;
aux_4943 = CELL_REF(length_buffer_16_4385);
n2_3864 = (long)CINT(aux_4943);
}
test1534_1217 = (l_1216>=n2_3864);
}
if(test1534_1217){
{
long vieille_longeur_17_1218;
obj_t vieux_buffer_172_1219;
{
obj_t aux_4947;
aux_4947 = CELL_REF(length_buffer_16_4385);
vieille_longeur_17_1218 = (long)CINT(aux_4947);
}
vieux_buffer_172_1219 = CELL_REF(buffer_4386);
{
long aux_4949;
{
long aux_4950;
aux_4950 = (l_1216+((long)100));
aux_4949 = (((long)2)*aux_4950);
}
CELL_SET(length_buffer_16_4385, BINT(aux_4949));
}
{
obj_t aux_4388;
{
obj_t res1826_3875;
{
int k_3869;
{
obj_t aux_4954;
aux_4954 = CELL_REF(length_buffer_16_4385);
k_3869 = CINT(aux_4954);
}
{
long aux_4956;
aux_4956 = (long)(k_3869);
res1826_3875 = make_string(aux_4956, ((unsigned char)' '));
}
}
aux_4388 = res1826_3875;
}
CELL_SET(buffer_4386, aux_4388);
}
{
obj_t s2_3878;
s2_3878 = CELL_REF(buffer_4386);
{
obj_t aux_4963;
obj_t aux_4961;
obj_t aux_4959;
aux_4963 = BINT(vieille_longeur_17_1218);
aux_4961 = BINT(((long)0));
aux_4959 = BINT(((long)0));
return blit_string(vieux_buffer_172_1219, aux_4959, s2_3878, aux_4961, aux_4963);
}
}
}
}
 else {
return BUNSPEC;
}
}
}
}


/* print-di */obj_t print_di_101___intext(obj_t buffer_4390, obj_t length_buffer_16_4389, obj_t i_1179)
{
verifie_taille_buffer__99___intext(buffer_4390, length_buffer_16_4389, BINT(((long)0)));
{
bool_t test_4968;
{
long aux_4969;
aux_4969 = (long)CINT(i_1179);
test_4968 = (aux_4969<((long)0));
}
if(test_4968){
{
obj_t string_3780;
long k_3781;
string_3780 = CELL_REF(buffer_4390);
k_3781 = _pointeur__164___intext;
STRING_SET(string_3780, k_3781, ((unsigned char)'-'));
}
{
long z1_3783;
z1_3783 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3783+((long)1));
}
{
obj_t aux_4974;
{
long aux_4975;
{
long aux_4976;
aux_4976 = (long)CINT(i_1179);
aux_4975 = NEG(aux_4976);
}
aux_4974 = BINT(aux_4975);
}
return print_mot_68___intext(buffer_4390, length_buffer_16_4389, aux_4974);
}
}
 else {
return print_mot_68___intext(buffer_4390, length_buffer_16_4389, i_1179);
}
}
}


/* print-item */obj_t print_item_54___intext(obj_t buffer_4392, obj_t length_buffer_16_4391, obj_t item_858)
{
print_item_54___intext:
{
unsigned char marqueur_1040;
obj_t item_1041;
unsigned char marqueur_1058;
obj_t item_1059;
obj_t p_1104;
long len_1105;
obj_t p_1129;
long len_1130;
obj_t s_1190;
obj_t len_1191;
{
bool_t test1213_860;
test1213_860 = (POINTERP( item_858 ) && (TYPE( item_858 ) >= OBJECT_TYPE));
if(test1213_860){
{
obj_t mark_861;
{
object_t aux_4984;
aux_4984 = (object_t)(item_858);
mark_861 = OBJECT_WIDENING(aux_4984);
}
{
bool_t test_4987;
{
obj_t aux_4988;
aux_4988 = STRUCT_REF(mark_861, ((long)3));
test_4987 = CBOOL(aux_4988);
}
if(test_4987){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2526;
long k_2527;
string_2526 = CELL_REF(buffer_4392);
k_2527 = _pointeur__164___intext;
STRING_SET(string_2526, k_2527, ((unsigned char)'#'));
}
{
long z1_2529;
z1_2529 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2529+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, STRUCT_REF(mark_861, ((long)2)));
{
obj_t aux_4997;
{
long aux_4998;
{
long aux_4999;
{
obj_t aux_5000;
aux_5000 = STRUCT_REF(mark_861, ((long)4));
aux_4999 = (long)CINT(aux_5000);
}
aux_4998 = (aux_4999-((long)1));
}
aux_4997 = BINT(aux_4998);
}
STRUCT_SET(mark_861, ((long)4), aux_4997);
}
{
bool_t test_5006;
{
long aux_5007;
{
obj_t aux_5008;
aux_5008 = STRUCT_REF(mark_861, ((long)4));
aux_5007 = (long)CINT(aux_5008);
}
test_5006 = (aux_5007==((long)0));
}
if(test_5006){
obj_t aux_5014;
object_t aux_5012;
{
obj_t aux_5015;
{
object_t aux_5016;
aux_5016 = (object_t)(item_858);
aux_5015 = OBJECT_WIDENING(aux_5016);
}
aux_5014 = STRUCT_REF(aux_5015, ((long)1));
}
aux_5012 = (object_t)(item_858);
return OBJECT_WIDENING_SET(aux_5012, aux_5014);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5021;
{
long aux_5022;
{
obj_t aux_5023;
aux_5023 = STRUCT_REF(mark_861, ((long)4));
aux_5022 = (long)CINT(aux_5023);
}
test_5021 = (aux_5022==((long)0));
}
if(test_5021){
{
obj_t struct_871;
struct_871 = STRUCT_REF(mark_861, ((long)5));
{
obj_t aux_5030;
object_t aux_5028;
aux_5030 = STRUCT_REF(mark_861, ((long)1));
aux_5028 = (object_t)(item_858);
OBJECT_WIDENING_SET(aux_5028, aux_5030);
}
print_struct_142___intext(buffer_4392, length_buffer_16_4391, ((unsigned char)'|'), struct_871);
{
long arg1228_872;
{
obj_t arg1231_873;
{
object_t object_2574;
object_2574 = (object_t)(item_858);
{
long arg1806_2575;
{
long arg1807_2576;
long arg1808_2577;
arg1807_2576 = TYPE( object_2574 );
arg1808_2577 = OBJECT_TYPE;
arg1806_2575 = (arg1807_2576-arg1808_2577);
}
{
obj_t vector_2581;
vector_2581 = _classes__134___object;
arg1231_873 = VECTOR_REF(vector_2581, arg1806_2575);
}
}
}
arg1228_872 = class_hash_237___object(arg1231_873);
}
{
obj_t item_5040;
item_5040 = BINT(arg1228_872);
item_858 = item_5040;
goto print_item_54___intext;
}
}
}
}
 else {
{
long ref_874;
obj_t struct_875;
{
long z1_2583;
z1_2583 = _ref__195___intext;
_ref__195___intext = (z1_2583+((long)1));
}
ref_874 = _ref__195___intext;
struct_875 = STRUCT_REF(mark_861, ((long)5));
{
obj_t aux_5044;
aux_5044 = BINT(ref_874);
STRUCT_SET(mark_861, ((long)2), aux_5044);
}
STRUCT_SET(mark_861, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2602;
long k_2603;
string_2602 = CELL_REF(buffer_4392);
k_2603 = _pointeur__164___intext;
STRING_SET(string_2602, k_2603, ((unsigned char)'='));
}
{
long z1_2605;
z1_2605 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2605+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_874));
print_struct_142___intext(buffer_4392, length_buffer_16_4391, ((unsigned char)'|'), struct_875);
{
long arg1232_876;
{
obj_t arg1233_877;
{
object_t object_2607;
object_2607 = (object_t)(item_858);
{
long arg1806_2608;
{
long arg1807_2609;
long arg1808_2610;
arg1807_2609 = TYPE( object_2607 );
arg1808_2610 = OBJECT_TYPE;
arg1806_2608 = (arg1807_2609-arg1808_2610);
}
{
obj_t vector_2614;
vector_2614 = _classes__134___object;
arg1233_877 = VECTOR_REF(vector_2614, arg1806_2608);
}
}
}
arg1232_876 = class_hash_237___object(arg1233_877);
}
{
obj_t item_5061;
item_5061 = BINT(arg1232_876);
item_858 = item_5061;
goto print_item_54___intext;
}
}
}
}
}
}
}
}
 else {
if(STRUCTP(item_858)){
return print_struct_142___intext(buffer_4392, length_buffer_16_4391, ((unsigned char)'{'), item_858);
}
 else {
if(SYMBOLP(item_858)){
{
bool_t test_5068;
{
obj_t aux_5069;
{
obj_t aux_5070;
aux_5070 = getprop___r4_symbols_6_4(item_858, symbol1839___intext);
aux_5069 = STRUCT_REF(aux_5070, ((long)3));
}
test_5068 = CBOOL(aux_5069);
}
if(test_5068){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2624;
long k_2625;
string_2624 = CELL_REF(buffer_4392);
k_2625 = _pointeur__164___intext;
STRING_SET(string_2624, k_2625, ((unsigned char)'#'));
}
{
long z1_2627;
z1_2627 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2627+((long)1));
}
{
obj_t aux_5078;
{
obj_t aux_5079;
aux_5079 = getprop___r4_symbols_6_4(item_858, symbol1839___intext);
aux_5078 = STRUCT_REF(aux_5079, ((long)2));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, aux_5078);
}
{
obj_t aux_5085;
obj_t aux_5083;
{
long aux_5086;
{
long aux_5087;
{
obj_t aux_5088;
{
obj_t aux_5089;
aux_5089 = getprop___r4_symbols_6_4(item_858, symbol1839___intext);
aux_5088 = STRUCT_REF(aux_5089, ((long)4));
}
aux_5087 = (long)CINT(aux_5088);
}
aux_5086 = (aux_5087-((long)1));
}
aux_5085 = BINT(aux_5086);
}
aux_5083 = getprop___r4_symbols_6_4(item_858, symbol1839___intext);
STRUCT_SET(aux_5083, ((long)4), aux_5085);
}
{
bool_t test_5096;
{
long aux_5097;
{
obj_t aux_5098;
{
obj_t aux_5099;
aux_5099 = getprop___r4_symbols_6_4(item_858, symbol1839___intext);
aux_5098 = STRUCT_REF(aux_5099, ((long)4));
}
aux_5097 = (long)CINT(aux_5098);
}
test_5096 = (aux_5097==((long)0));
}
if(test_5096){
return remprop__243___r4_symbols_6_4(item_858, symbol1839___intext);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5105;
{
long aux_5106;
{
obj_t aux_5107;
{
obj_t aux_5108;
aux_5108 = getprop___r4_symbols_6_4(item_858, symbol1839___intext);
aux_5107 = STRUCT_REF(aux_5108, ((long)4));
}
aux_5106 = (long)CINT(aux_5107);
}
test_5105 = (aux_5106==((long)0));
}
if(test_5105){
remprop__243___r4_symbols_6_4(item_858, symbol1839___intext);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2667;
long k_2668;
string_2667 = CELL_REF(buffer_4392);
k_2668 = _pointeur__164___intext;
STRING_SET(string_2667, k_2668, ((unsigned char)'\''));
}
{
long z1_2670;
z1_2670 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2670+((long)1));
}
{
obj_t s_895;
s_895 = SYMBOL_TO_STRING(item_858);
s_1190 = s_895;
{
long aux_5127;
aux_5127 = STRING_LENGTH(s_895);
len_1191 = BINT(aux_5127);
}
print_chars_22_1232:
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, len_1191);
print_mot_68___intext(buffer_4392, length_buffer_16_4391, len_1191);
{
obj_t o1_3815;
obj_t s2_3816;
obj_t o2_3817;
o1_3815 = BINT(((long)0));
s2_3816 = CELL_REF(buffer_4392);
o2_3817 = BINT(_pointeur__164___intext);
blit_string(s_1190, o1_3815, s2_3816, o2_3817, len_1191);
}
{
long z1_3819;
z1_3819 = _pointeur__164___intext;
{
long aux_5124;
aux_5124 = (long)CINT(len_1191);
return (_pointeur__164___intext = (z1_3819+aux_5124),
BUNSPEC);
}
}
}
}
 else {
{
long ref_897;
obj_t mark_898;
{
long z1_2676;
z1_2676 = _ref__195___intext;
_ref__195___intext = (z1_2676+((long)1));
}
ref_897 = _ref__195___intext;
mark_898 = getprop___r4_symbols_6_4(item_858, symbol1839___intext);
{
obj_t aux_5132;
aux_5132 = BINT(ref_897);
STRUCT_SET(mark_898, ((long)2), aux_5132);
}
STRUCT_SET(mark_898, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2691;
long k_2692;
string_2691 = CELL_REF(buffer_4392);
k_2692 = _pointeur__164___intext;
STRING_SET(string_2691, k_2692, ((unsigned char)'='));
}
{
long z1_2694;
z1_2694 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2694+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_897));
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2697;
long k_2698;
string_2697 = CELL_REF(buffer_4392);
k_2698 = _pointeur__164___intext;
STRING_SET(string_2697, k_2698, ((unsigned char)'\''));
}
{
long z1_2700;
z1_2700 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2700+((long)1));
}
{
obj_t s_899;
s_899 = SYMBOL_TO_STRING(item_858);
{
obj_t len_5148;
obj_t s_5147;
s_5147 = s_899;
{
long aux_5149;
aux_5149 = STRING_LENGTH(s_899);
len_5148 = BINT(aux_5149);
}
len_1191 = len_5148;
s_1190 = s_5147;
goto print_chars_22_1232;
}
}
}
}
}
}
}
 else {
if(KEYWORDP(item_858)){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2708;
long k_2709;
string_2708 = CELL_REF(buffer_4392);
k_2709 = _pointeur__164___intext;
STRING_SET(string_2708, k_2709, ((unsigned char)':'));
}
{
long z1_2711;
z1_2711 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2711+((long)1));
}
{
obj_t s_906;
s_906 = KEYWORD_TO_STRING(item_858);
{
obj_t len_5160;
obj_t s_5159;
s_5159 = s_906;
{
long aux_5161;
aux_5161 = STRING_LENGTH(s_906);
len_5160 = BINT(aux_5161);
}
len_1191 = len_5160;
s_1190 = s_5159;
goto print_chars_22_1232;
}
}
}
 else {
if(CHARP(item_858)){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2719;
long k_2720;
string_2719 = CELL_REF(buffer_4392);
k_2720 = _pointeur__164___intext;
STRING_SET(string_2719, k_2720, ((unsigned char)'a'));
}
{
long z1_2722;
z1_2722 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2722+((long)1));
}
{
obj_t aux_5170;
{
long aux_5171;
{
unsigned char aux_5172;
aux_5172 = (unsigned char)CCHAR(item_858);
aux_5171 = (aux_5172);
}
aux_5170 = BINT(aux_5171);
}
return print_di_101___intext(buffer_4392, length_buffer_16_4391, aux_5170);
}
}
 else {
if(UCS2P(item_858)){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2727;
long k_2728;
string_2727 = CELL_REF(buffer_4392);
k_2728 = _pointeur__164___intext;
STRING_SET(string_2727, k_2728, ((unsigned char)'u'));
}
{
long z1_2730;
z1_2730 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2730+((long)1));
}
{
long arg1267_911;
{
ucs2_t ucs2_2732;
ucs2_2732 = CUCS2(item_858);
arg1267_911 = (long)(ucs2_2732);
}
return print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(arg1267_911));
}
}
 else {
if(CNSTP(item_858)){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2735;
long k_2736;
string_2735 = CELL_REF(buffer_4392);
k_2736 = _pointeur__164___intext;
STRING_SET(string_2735, k_2736, ((unsigned char)'<'));
}
{
long z1_2738;
z1_2738 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2738+((long)1));
}
{
long arg1269_913;
arg1269_913 = CCNST(item_858);
return print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(arg1269_913));
}
}
 else {
if((item_858==BFALSE)){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2743;
long k_2744;
string_2743 = CELL_REF(buffer_4392);
k_2744 = _pointeur__164___intext;
STRING_SET(string_2743, k_2744, ((unsigned char)'F'));
}
{
long z1_2746;
z1_2746 = _pointeur__164___intext;
return (_pointeur__164___intext = (z1_2746+((long)1)),
BUNSPEC);
}
}
 else {
bool_t test1271_915;
test1271_915 = INTEGERP(item_858);
if(test1271_915){
return print_di_101___intext(buffer_4392, length_buffer_16_4391, item_858);
}
 else {
bool_t test_5205;
if(test1271_915){
test_5205 = ((bool_t)1);
}
 else {
test_5205 = REALP(item_858);
}
if(test_5205){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2753;
long k_2754;
string_2753 = CELL_REF(buffer_4392);
k_2754 = _pointeur__164___intext;
STRING_SET(string_2753, k_2754, ((unsigned char)'f'));
}
{
long z1_2756;
z1_2756 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2756+((long)1));
}
{
char * s_2759;
{
double aux_5212;
aux_5212 = REAL_TO_DOUBLE(item_858);
s_2759 = real_to_string(aux_5212);
}
{
obj_t len_5217;
obj_t s_5215;
s_5215 = string_to_bstring(s_2759);
{
long aux_5218;
{
obj_t aux_5219;
aux_5219 = string_to_bstring(s_2759);
aux_5218 = STRING_LENGTH(aux_5219);
}
len_5217 = BINT(aux_5218);
}
len_1191 = len_5217;
s_1190 = s_5215;
goto print_chars_22_1232;
}
}
}
 else {
if(STRINGP(item_858)){
marqueur_1058 = ((unsigned char)'"');
item_1059 = item_858;
print_string_82_1242:
{
obj_t mark_1061;
{
obj_t cell_3461;
cell_3461 = get_hash_29___hash(item_1059, _string_mark_table__203___intext);
if(PAIRP(cell_3461)){
mark_1061 = CDR(cell_3461);
}
 else {
FAILURE(string1840___intext,string1845___intext,BUNSPEC);}
}
{
bool_t test_5230;
{
obj_t aux_5231;
aux_5231 = STRUCT_REF(mark_1061, ((long)3));
test_5230 = CBOOL(aux_5231);
}
if(test_5230){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3472;
long k_3473;
string_3472 = CELL_REF(buffer_4392);
k_3473 = _pointeur__164___intext;
STRING_SET(string_3472, k_3473, ((unsigned char)'#'));
}
{
long z1_3475;
z1_3475 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3475+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, STRUCT_REF(mark_1061, ((long)2)));
{
obj_t aux_5240;
{
long aux_5241;
{
long aux_5242;
{
obj_t aux_5243;
aux_5243 = STRUCT_REF(mark_1061, ((long)4));
aux_5242 = (long)CINT(aux_5243);
}
aux_5241 = (aux_5242-((long)1));
}
aux_5240 = BINT(aux_5241);
}
STRUCT_SET(mark_1061, ((long)4), aux_5240);
}
{
bool_t test_5249;
{
long aux_5250;
{
obj_t aux_5251;
aux_5251 = STRUCT_REF(mark_1061, ((long)4));
aux_5250 = (long)CINT(aux_5251);
}
test_5249 = (aux_5250==((long)0));
}
if(test_5249){
return INVERSE_STRING_LENGTH(item_1059);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5256;
{
long aux_5257;
{
obj_t aux_5258;
aux_5258 = STRUCT_REF(mark_1061, ((long)4));
aux_5257 = (long)CINT(aux_5258);
}
test_5256 = (aux_5257==((long)0));
}
if(test_5256){
INVERSE_STRING_LENGTH(item_1059);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3503;
long k_3504;
string_3503 = CELL_REF(buffer_4392);
k_3504 = _pointeur__164___intext;
STRING_SET(string_3503, k_3504, marqueur_1058);
}
{
long z1_3506;
z1_3506 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3506+((long)1));
}
{
obj_t len_5268;
obj_t s_5267;
s_5267 = item_1059;
{
long aux_5269;
aux_5269 = STRING_LENGTH(item_1059);
len_5268 = BINT(aux_5269);
}
len_1191 = len_5268;
s_1190 = s_5267;
goto print_chars_22_1232;
}
}
 else {
{
long ref_1072;
{
long z1_3511;
z1_3511 = _ref__195___intext;
_ref__195___intext = (z1_3511+((long)1));
}
ref_1072 = _ref__195___intext;
{
obj_t aux_5273;
aux_5273 = BINT(ref_1072);
STRUCT_SET(mark_1061, ((long)2), aux_5273);
}
STRUCT_SET(mark_1061, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3524;
long k_3525;
string_3524 = CELL_REF(buffer_4392);
k_3525 = _pointeur__164___intext;
STRING_SET(string_3524, k_3525, ((unsigned char)'='));
}
{
long z1_3527;
z1_3527 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3527+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_1072));
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3530;
long k_3531;
string_3530 = CELL_REF(buffer_4392);
k_3531 = _pointeur__164___intext;
STRING_SET(string_3530, k_3531, marqueur_1058);
}
{
long z1_3533;
z1_3533 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3533+((long)1));
}
{
obj_t len_5288;
obj_t s_5287;
s_5287 = item_1059;
len_5288 = STRUCT_REF(mark_1061, ((long)1));
len_1191 = len_5288;
s_1190 = s_5287;
goto print_chars_22_1232;
}
}
}
}
}
}
}
 else {
if(UCS2_STRINGP(item_858)){
marqueur_1040 = ((unsigned char)'U');
item_1041 = item_858;
{
obj_t mark_1043;
{
obj_t cell_3391;
cell_3391 = get_hash_29___hash(item_1041, _string_mark_table__203___intext);
if(PAIRP(cell_3391)){
mark_1043 = CDR(cell_3391);
}
 else {
FAILURE(string1840___intext,string1841___intext,BUNSPEC);}
}
{
bool_t test_5297;
{
obj_t aux_5298;
aux_5298 = STRUCT_REF(mark_1043, ((long)3));
test_5297 = CBOOL(aux_5298);
}
if(test_5297){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3402;
long k_3403;
string_3402 = CELL_REF(buffer_4392);
k_3403 = _pointeur__164___intext;
STRING_SET(string_3402, k_3403, ((unsigned char)'#'));
}
{
long z1_3405;
z1_3405 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3405+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, STRUCT_REF(mark_1043, ((long)2)));
{
obj_t aux_5307;
{
long aux_5308;
{
long aux_5309;
{
obj_t aux_5310;
aux_5310 = STRUCT_REF(mark_1043, ((long)4));
aux_5309 = (long)CINT(aux_5310);
}
aux_5308 = (aux_5309-((long)1));
}
aux_5307 = BINT(aux_5308);
}
STRUCT_SET(mark_1043, ((long)4), aux_5307);
}
{
bool_t test_5316;
{
long aux_5317;
{
obj_t aux_5318;
aux_5318 = STRUCT_REF(mark_1043, ((long)4));
aux_5317 = (long)CINT(aux_5318);
}
test_5316 = (aux_5317==((long)0));
}
if(test_5316){
return INVERSE_UCS2_STRING_LENGTH(item_1041);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5323;
{
long aux_5324;
{
obj_t aux_5325;
aux_5325 = STRUCT_REF(mark_1043, ((long)4));
aux_5324 = (long)CINT(aux_5325);
}
test_5323 = (aux_5324==((long)0));
}
if(test_5323){
{
obj_t string_1053;
{
obj_t arg1182_3432;
arg1182_3432 = get_ucs2_string_mark_32___intext(item_1041);
string_1053 = STRUCT_REF(arg1182_3432, ((long)5));
}
INVERSE_UCS2_STRING_LENGTH(item_1041);
{
obj_t item_5333;
unsigned char marqueur_5332;
marqueur_5332 = ((unsigned char)'U');
item_5333 = string_1053;
item_1059 = item_5333;
marqueur_1058 = marqueur_5332;
goto print_string_82_1242;
}
}
}
 else {
{
long ref_1054;
obj_t string_1055;
{
long z1_3437;
z1_3437 = _ref__195___intext;
_ref__195___intext = (z1_3437+((long)1));
}
ref_1054 = _ref__195___intext;
{
obj_t arg1182_3440;
arg1182_3440 = get_ucs2_string_mark_32___intext(item_1041);
string_1055 = STRUCT_REF(arg1182_3440, ((long)5));
}
{
obj_t aux_5337;
aux_5337 = BINT(ref_1054);
STRUCT_SET(mark_1043, ((long)2), aux_5337);
}
STRUCT_SET(mark_1043, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3455;
long k_3456;
string_3455 = CELL_REF(buffer_4392);
k_3456 = _pointeur__164___intext;
STRING_SET(string_3455, k_3456, ((unsigned char)'='));
}
{
long z1_3458;
z1_3458 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3458+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_1054));
{
obj_t item_5348;
unsigned char marqueur_5347;
marqueur_5347 = ((unsigned char)'U');
item_5348 = string_1055;
item_1059 = item_5348;
marqueur_1058 = marqueur_5347;
goto print_string_82_1242;
}
}
}
}
}
}
}
 else {
if(CELLP(item_858)){
{
bool_t test1276_920;
{
obj_t arg1298_942;
arg1298_942 = CELL_REF(item_858);
{
obj_t aux_5352;
aux_5352 = STRUCT_REF(arg1298_942, ((long)3));
test1276_920 = CBOOL(aux_5352);
}
}
if(test1276_920){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2770;
long k_2771;
string_2770 = CELL_REF(buffer_4392);
k_2771 = _pointeur__164___intext;
STRING_SET(string_2770, k_2771, ((unsigned char)'#'));
}
{
long z1_2773;
z1_2773 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2773+((long)1));
}
{
obj_t arg1277_921;
{
obj_t arg1278_922;
arg1278_922 = CELL_REF(item_858);
arg1277_921 = STRUCT_REF(arg1278_922, ((long)2));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, arg1277_921);
}
{
obj_t arg1281_923;
long arg1282_924;
arg1281_923 = CELL_REF(item_858);
{
obj_t arg1283_925;
{
obj_t arg1285_927;
arg1285_927 = CELL_REF(item_858);
arg1283_925 = STRUCT_REF(arg1285_927, ((long)4));
}
{
long aux_5366;
aux_5366 = (long)CINT(arg1283_925);
arg1282_924 = (aux_5366-((long)1));
}
}
{
obj_t aux_5369;
aux_5369 = BINT(arg1282_924);
STRUCT_SET(arg1281_923, ((long)4), aux_5369);
}
}
{
bool_t test1286_928;
{
obj_t arg1287_929;
{
obj_t arg1290_931;
arg1290_931 = CELL_REF(item_858);
arg1287_929 = STRUCT_REF(arg1290_931, ((long)4));
}
{
long aux_5374;
aux_5374 = (long)CINT(arg1287_929);
test1286_928 = (aux_5374==((long)0));
}
}
if(test1286_928){
obj_t old_value_175_2798;
{
obj_t arg1158_2799;
arg1158_2799 = CELL_REF(item_858);
old_value_175_2798 = STRUCT_REF(arg1158_2799, ((long)1));
}
return CELL_SET(item_858, old_value_175_2798);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test1291_932;
{
obj_t arg1295_939;
{
obj_t arg1297_941;
arg1297_941 = CELL_REF(item_858);
arg1295_939 = STRUCT_REF(arg1297_941, ((long)4));
}
{
long aux_5383;
aux_5383 = (long)CINT(arg1295_939);
test1291_932 = (aux_5383==((long)0));
}
}
if(test1291_932){
{
obj_t old_value_175_2811;
{
obj_t arg1158_2812;
arg1158_2812 = CELL_REF(item_858);
old_value_175_2811 = STRUCT_REF(arg1158_2812, ((long)1));
}
CELL_SET(item_858, old_value_175_2811);
}
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2818;
long k_2819;
string_2818 = CELL_REF(buffer_4392);
k_2819 = _pointeur__164___intext;
STRING_SET(string_2818, k_2819, ((unsigned char)'!'));
}
{
long z1_2821;
z1_2821 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2821+((long)1));
}
{
obj_t arg1292_933;
arg1292_933 = CELL_REF(item_858);
{
obj_t item_5395;
item_5395 = arg1292_933;
item_858 = item_5395;
goto print_item_54___intext;
}
}
}
 else {
{
long ref_934;
{
long z1_2823;
z1_2823 = _ref__195___intext;
_ref__195___intext = (z1_2823+((long)1));
}
ref_934 = _ref__195___intext;
{
obj_t mark_935;
mark_935 = CELL_REF(item_858);
{
{
obj_t aux_5398;
aux_5398 = BINT(ref_934);
STRUCT_SET(mark_935, ((long)2), aux_5398);
}
STRUCT_SET(mark_935, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2839;
long k_2840;
string_2839 = CELL_REF(buffer_4392);
k_2840 = _pointeur__164___intext;
STRING_SET(string_2839, k_2840, ((unsigned char)'='));
}
{
long z1_2842;
z1_2842 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2842+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_934));
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2845;
long k_2846;
string_2845 = CELL_REF(buffer_4392);
k_2846 = _pointeur__164___intext;
STRING_SET(string_2845, k_2846, ((unsigned char)'!'));
}
{
long z1_2848;
z1_2848 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2848+((long)1));
}
{
obj_t item_5412;
item_5412 = STRUCT_REF(mark_935, ((long)1));
item_858 = item_5412;
goto print_item_54___intext;
}
}
}
}
}
}
}
}
 else {
bool_t test1299_943;
{
bool_t test1399_1039;
test1399_1039 = EXTENDED_PAIRP(item_858);
if(test1399_1039){
test1299_943 = _epair___65___intext;
}
 else {
test1299_943 = ((bool_t)0);
}
}
if(test1299_943){
{
bool_t test_5417;
{
obj_t aux_5418;
{
obj_t aux_5419;
aux_5419 = CDR(item_858);
aux_5418 = STRUCT_REF(aux_5419, ((long)3));
}
test_5417 = CBOOL(aux_5418);
}
if(test_5417){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2860;
long k_2861;
string_2860 = CELL_REF(buffer_4392);
k_2861 = _pointeur__164___intext;
STRING_SET(string_2860, k_2861, ((unsigned char)'#'));
}
{
long z1_2863;
z1_2863 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2863+((long)1));
}
{
obj_t aux_5427;
{
obj_t aux_5428;
aux_5428 = CDR(item_858);
aux_5427 = STRUCT_REF(aux_5428, ((long)2));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, aux_5427);
}
return pair_mark_gc__141___intext(item_858);
}
 else {
bool_t test_5433;
{
long aux_5434;
{
obj_t aux_5435;
{
obj_t aux_5436;
aux_5436 = CDR(item_858);
aux_5435 = STRUCT_REF(aux_5436, ((long)4));
}
aux_5434 = (long)CINT(aux_5435);
}
test_5433 = (aux_5434==((long)0));
}
if(test_5433){
{
long len_948;
len_948 = marked_pair_length_178___intext(item_858);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2878;
long k_2879;
string_2878 = CELL_REF(buffer_4392);
k_2879 = _pointeur__164___intext;
STRING_SET(string_2878, k_2879, ((unsigned char)'^'));
}
{
long z1_2881;
z1_2881 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2881+((long)1));
}
{
obj_t aux_5446;
aux_5446 = CDR(item_858);
STRUCT_SET(aux_5446, ((long)3), BTRUE);
}
p_1104 = item_858;
len_1105 = len_948;
print_edl_122_1240:
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(len_1105));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(len_1105));
{
long i_1107;
obj_t p_1108;
i_1107 = ((long)0);
p_1108 = p_1104;
loop_1109:
{
bool_t test_5453;
{
long aux_5454;
aux_5454 = (len_1105-((long)1));
test_5453 = (i_1107==aux_5454);
}
if(test_5453){
if(PAIRP(p_1108)){
print_item_54___intext(buffer_4392, length_buffer_16_4391, CAR(p_1108));
{
bool_t test1466_1113;
test1466_1113 = EXTENDED_PAIRP(p_1108);
if(test1466_1113){
obj_t arg1467_1114;
{
bool_t test1713_3671;
test1713_3671 = EXTENDED_PAIRP(p_1108);
if(test1713_3671){
arg1467_1114 = CER(p_1108);
}
 else {
FAILURE(string1844___intext,string1836___intext,p_1108);}
}
print_item_54___intext(buffer_4392, length_buffer_16_4391, arg1467_1114);
}
 else {
print_item_54___intext(buffer_4392, length_buffer_16_4391, BUNSPEC);
}
}
print_item_54___intext(buffer_4392, length_buffer_16_4391, BNIL);
return pair_mark_gc__141___intext(p_1108);
}
 else {
obj_t item_5471;
item_5471 = p_1108;
item_858 = item_5471;
goto print_item_54___intext;
}
}
 else {
{
obj_t vcdr_1117;
{
obj_t aux_5472;
aux_5472 = CDR(p_1108);
vcdr_1117 = STRUCT_REF(aux_5472, ((long)1));
}
{
print_item_54___intext(buffer_4392, length_buffer_16_4391, CAR(p_1108));
{
bool_t test1470_1119;
test1470_1119 = EXTENDED_PAIRP(p_1108);
if(test1470_1119){
obj_t arg1471_1120;
{
bool_t test1713_3684;
test1713_3684 = EXTENDED_PAIRP(p_1108);
if(test1713_3684){
arg1471_1120 = CER(p_1108);
}
 else {
FAILURE(string1844___intext,string1836___intext,p_1108);}
}
print_item_54___intext(buffer_4392, length_buffer_16_4391, arg1471_1120);
}
 else {
print_item_54___intext(buffer_4392, length_buffer_16_4391, BUNSPEC);
}
}
pair_mark_gc__141___intext(p_1108);
{
bool_t test_5486;
if(PAIRP(vcdr_1117)){
obj_t mark_1124;
mark_1124 = CDR(vcdr_1117);
{
bool_t _ortest_1016_1125;
_ortest_1016_1125 = _2__206___r4_numbers_6_5(STRUCT_REF(mark_1124, ((long)4)), BINT(((long)0)));
if(_ortest_1016_1125){
test_5486 = _ortest_1016_1125;
}
 else {
obj_t aux_5494;
aux_5494 = STRUCT_REF(mark_1124, ((long)3));
test_5486 = CBOOL(aux_5494);
}
}
}
 else {
test_5486 = ((bool_t)0);
}
if(test_5486){
obj_t item_5497;
item_5497 = vcdr_1117;
item_858 = item_5497;
goto print_item_54___intext;
}
 else {
obj_t p_5500;
long i_5498;
i_5498 = (i_1107+((long)1));
p_5500 = vcdr_1117;
p_1108 = p_5500;
i_1107 = i_5498;
goto loop_1109;
}
}
}
}
}
}
}
}
}
 else {
{
long ref_950;
obj_t mark_951;
long len_952;
{
long z1_2890;
z1_2890 = _ref__195___intext;
_ref__195___intext = (z1_2890+((long)1));
}
ref_950 = _ref__195___intext;
mark_951 = CDR(item_858);
len_952 = marked_pair_length_178___intext(item_858);
{
obj_t aux_5504;
aux_5504 = BINT(ref_950);
STRUCT_SET(mark_951, ((long)2), aux_5504);
}
STRUCT_SET(mark_951, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2905;
long k_2906;
string_2905 = CELL_REF(buffer_4392);
k_2906 = _pointeur__164___intext;
STRING_SET(string_2905, k_2906, ((unsigned char)'='));
}
{
long z1_2908;
z1_2908 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2908+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_950));
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2911;
long k_2912;
string_2911 = CELL_REF(buffer_4392);
k_2912 = _pointeur__164___intext;
STRING_SET(string_2911, k_2912, ((unsigned char)'^'));
}
{
long z1_2914;
z1_2914 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2914+((long)1));
}
{
long len_5519;
obj_t p_5518;
p_5518 = item_858;
len_5519 = len_952;
len_1105 = len_5519;
p_1104 = p_5518;
goto print_edl_122_1240;
}
}
}
}
}
}
 else {
if(PAIRP(item_858)){
{
bool_t test_5522;
{
obj_t aux_5523;
{
obj_t aux_5524;
aux_5524 = CDR(item_858);
aux_5523 = STRUCT_REF(aux_5524, ((long)3));
}
test_5522 = CBOOL(aux_5523);
}
if(test_5522){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2923;
long k_2924;
string_2923 = CELL_REF(buffer_4392);
k_2924 = _pointeur__164___intext;
STRING_SET(string_2923, k_2924, ((unsigned char)'#'));
}
{
long z1_2926;
z1_2926 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2926+((long)1));
}
{
obj_t aux_5532;
{
obj_t aux_5533;
aux_5533 = CDR(item_858);
aux_5532 = STRUCT_REF(aux_5533, ((long)2));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, aux_5532);
}
return pair_mark_gc__141___intext(item_858);
}
 else {
bool_t test_5538;
{
long aux_5539;
{
obj_t aux_5540;
{
obj_t aux_5541;
aux_5541 = CDR(item_858);
aux_5540 = STRUCT_REF(aux_5541, ((long)4));
}
aux_5539 = (long)CINT(aux_5540);
}
test_5538 = (aux_5539==((long)0));
}
if(test_5538){
{
long len_962;
len_962 = marked_pair_length_178___intext(item_858);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2941;
long k_2942;
string_2941 = CELL_REF(buffer_4392);
k_2942 = _pointeur__164___intext;
STRING_SET(string_2941, k_2942, ((unsigned char)'('));
}
{
long z1_2944;
z1_2944 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2944+((long)1));
}
{
obj_t aux_5551;
aux_5551 = CDR(item_858);
STRUCT_SET(aux_5551, ((long)3), BTRUE);
}
p_1129 = item_858;
len_1130 = len_962;
print_dl_11_1239:
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(len_1130));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(len_1130));
{
long i_1132;
obj_t p_1133;
i_1132 = ((long)0);
p_1133 = p_1129;
loop_1134:
{
bool_t test_5558;
{
long aux_5559;
aux_5559 = (len_1130-((long)1));
test_5558 = (i_1132==aux_5559);
}
if(test_5558){
if(PAIRP(p_1133)){
print_item_54___intext(buffer_4392, length_buffer_16_4391, CAR(p_1133));
print_item_54___intext(buffer_4392, length_buffer_16_4391, BNIL);
return pair_mark_gc__141___intext(p_1133);
}
 else {
obj_t item_5568;
item_5568 = p_1133;
item_858 = item_5568;
goto print_item_54___intext;
}
}
 else {
{
obj_t vcdr_1140;
{
obj_t aux_5569;
aux_5569 = CDR(p_1133);
vcdr_1140 = STRUCT_REF(aux_5569, ((long)1));
}
{
print_item_54___intext(buffer_4392, length_buffer_16_4391, CAR(p_1133));
pair_mark_gc__141___intext(p_1133);
{
bool_t test_5575;
if(PAIRP(vcdr_1140)){
obj_t mark_1145;
mark_1145 = CDR(vcdr_1140);
{
bool_t _ortest_1015_1146;
_ortest_1015_1146 = _2__206___r4_numbers_6_5(STRUCT_REF(mark_1145, ((long)4)), BINT(((long)0)));
if(_ortest_1015_1146){
test_5575 = _ortest_1015_1146;
}
 else {
obj_t aux_5583;
aux_5583 = STRUCT_REF(mark_1145, ((long)3));
test_5575 = CBOOL(aux_5583);
}
}
}
 else {
test_5575 = ((bool_t)0);
}
if(test_5575){
obj_t item_5586;
item_5586 = vcdr_1140;
item_858 = item_5586;
goto print_item_54___intext;
}
 else {
obj_t p_5589;
long i_5587;
i_5587 = (i_1132+((long)1));
p_5589 = vcdr_1140;
p_1133 = p_5589;
i_1132 = i_5587;
goto loop_1134;
}
}
}
}
}
}
}
}
}
 else {
{
long ref_964;
obj_t mark_965;
long len_966;
{
long z1_2953;
z1_2953 = _ref__195___intext;
_ref__195___intext = (z1_2953+((long)1));
}
ref_964 = _ref__195___intext;
mark_965 = CDR(item_858);
len_966 = marked_pair_length_178___intext(item_858);
{
obj_t aux_5593;
aux_5593 = BINT(ref_964);
STRUCT_SET(mark_965, ((long)2), aux_5593);
}
STRUCT_SET(mark_965, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2968;
long k_2969;
string_2968 = CELL_REF(buffer_4392);
k_2969 = _pointeur__164___intext;
STRING_SET(string_2968, k_2969, ((unsigned char)'='));
}
{
long z1_2971;
z1_2971 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2971+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_964));
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2974;
long k_2975;
string_2974 = CELL_REF(buffer_4392);
k_2975 = _pointeur__164___intext;
STRING_SET(string_2974, k_2975, ((unsigned char)'('));
}
{
long z1_2977;
z1_2977 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2977+((long)1));
}
{
long len_5608;
obj_t p_5607;
p_5607 = item_858;
len_5608 = len_966;
len_1130 = len_5608;
p_1129 = p_5607;
goto print_dl_11_1239;
}
}
}
}
}
}
 else {
if(VECTORP(item_858)){
{
bool_t test_5611;
{
long aux_5612;
aux_5612 = VECTOR_LENGTH(item_858);
test_5611 = (aux_5612==((long)0));
}
if(test_5611){
{
long tag_973;
tag_973 = VECTOR_TAG(item_858);
if((tag_973>((long)0))){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_2987;
long k_2988;
string_2987 = CELL_REF(buffer_4392);
k_2988 = _pointeur__164___intext;
STRING_SET(string_2987, k_2988, ((unsigned char)'t'));
}
{
long z1_2990;
z1_2990 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2990+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(tag_973));
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
print_item_54___intext(buffer_4392, length_buffer_16_4391, BNIL);
{
long i_2996;
i_2996 = ((long)1);
for1013_2995:
{
bool_t test_5629;
{
long aux_5630;
aux_5630 = (((long)0)-((long)1));
test_5629 = (i_2996<=aux_5630);
}
if(test_5629){
print_item_54___intext(buffer_4392, length_buffer_16_4391, VECTOR_REF(item_858, i_2996));
{
long i_5635;
i_5635 = (i_2996+((long)1));
i_2996 = i_5635;
goto for1013_2995;
}
}
 else {
return symbol1834___intext;
}
}
}
}
 else {
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3011;
long k_3012;
string_3011 = CELL_REF(buffer_4392);
k_3012 = _pointeur__164___intext;
STRING_SET(string_3011, k_3012, ((unsigned char)'['));
}
{
long z1_3014;
z1_3014 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3014+((long)1));
}
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
print_item_54___intext(buffer_4392, length_buffer_16_4391, BNIL);
{
long i_3020;
i_3020 = ((long)1);
for1013_3019:
{
bool_t test_5646;
{
long aux_5647;
aux_5647 = (((long)0)-((long)1));
test_5646 = (i_3020<=aux_5647);
}
if(test_5646){
print_item_54___intext(buffer_4392, length_buffer_16_4391, VECTOR_REF(item_858, i_3020));
{
long i_5652;
i_5652 = (i_3020+((long)1));
i_3020 = i_5652;
goto for1013_3019;
}
}
 else {
return symbol1834___intext;
}
}
}
}
}
}
 else {
bool_t test_5654;
{
obj_t aux_5655;
{
obj_t aux_5656;
aux_5656 = VECTOR_REF(item_858, ((long)0));
aux_5655 = STRUCT_REF(aux_5656, ((long)3));
}
test_5654 = CBOOL(aux_5655);
}
if(test_5654){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3041;
long k_3042;
string_3041 = CELL_REF(buffer_4392);
k_3042 = _pointeur__164___intext;
STRING_SET(string_3041, k_3042, ((unsigned char)'#'));
}
{
long z1_3044;
z1_3044 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3044+((long)1));
}
{
obj_t aux_5664;
{
obj_t aux_5665;
aux_5665 = VECTOR_REF(item_858, ((long)0));
aux_5664 = STRUCT_REF(aux_5665, ((long)2));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, aux_5664);
}
{
obj_t aux_5671;
obj_t aux_5669;
{
long aux_5672;
{
long aux_5673;
{
obj_t aux_5674;
{
obj_t aux_5675;
aux_5675 = VECTOR_REF(item_858, ((long)0));
aux_5674 = STRUCT_REF(aux_5675, ((long)4));
}
aux_5673 = (long)CINT(aux_5674);
}
aux_5672 = (aux_5673-((long)1));
}
aux_5671 = BINT(aux_5672);
}
aux_5669 = VECTOR_REF(item_858, ((long)0));
STRUCT_SET(aux_5669, ((long)4), aux_5671);
}
{
bool_t test_5682;
{
long aux_5683;
{
obj_t aux_5684;
{
obj_t aux_5685;
aux_5685 = VECTOR_REF(item_858, ((long)0));
aux_5684 = STRUCT_REF(aux_5685, ((long)4));
}
aux_5683 = (long)CINT(aux_5684);
}
test_5682 = (aux_5683==((long)0));
}
if(test_5682){
obj_t aux_5690;
{
obj_t aux_5691;
aux_5691 = VECTOR_REF(item_858, ((long)0));
aux_5690 = STRUCT_REF(aux_5691, ((long)1));
}
return VECTOR_SET(item_858, ((long)0), aux_5690);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5695;
{
long aux_5696;
{
obj_t aux_5697;
{
obj_t aux_5698;
aux_5698 = VECTOR_REF(item_858, ((long)0));
aux_5697 = STRUCT_REF(aux_5698, ((long)4));
}
aux_5696 = (long)CINT(aux_5697);
}
test_5695 = (aux_5696==((long)0));
}
if(test_5695){
{
obj_t aux_5703;
{
obj_t aux_5704;
aux_5704 = VECTOR_REF(item_858, ((long)0));
aux_5703 = STRUCT_REF(aux_5704, ((long)1));
}
VECTOR_SET(item_858, ((long)0), aux_5703);
}
{
long tag_992;
tag_992 = VECTOR_TAG(item_858);
if((tag_992>((long)0))){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3112;
long k_3113;
string_3112 = CELL_REF(buffer_4392);
k_3113 = _pointeur__164___intext;
STRING_SET(string_3112, k_3113, ((unsigned char)'t'));
}
{
long z1_3115;
z1_3115 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3115+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(tag_992));
{
obj_t arg1353_994;
long arg1355_995;
arg1353_994 = VECTOR_REF(item_858, ((long)0));
arg1355_995 = VECTOR_LENGTH(item_858);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(arg1355_995));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(arg1355_995));
print_item_54___intext(buffer_4392, length_buffer_16_4391, arg1353_994);
{
long i_3124;
i_3124 = ((long)1);
for1013_3123:
{
bool_t test_5724;
{
long aux_5725;
aux_5725 = (arg1355_995-((long)1));
test_5724 = (i_3124<=aux_5725);
}
if(test_5724){
print_item_54___intext(buffer_4392, length_buffer_16_4391, VECTOR_REF(item_858, i_3124));
{
long i_5730;
i_5730 = (i_3124+((long)1));
i_3124 = i_5730;
goto for1013_3123;
}
}
 else {
return symbol1834___intext;
}
}
}
}
}
 else {
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3139;
long k_3140;
string_3139 = CELL_REF(buffer_4392);
k_3140 = _pointeur__164___intext;
STRING_SET(string_3139, k_3140, ((unsigned char)'['));
}
{
long z1_3142;
z1_3142 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3142+((long)1));
}
{
obj_t arg1356_996;
long arg1357_997;
arg1356_996 = VECTOR_REF(item_858, ((long)0));
arg1357_997 = VECTOR_LENGTH(item_858);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(arg1357_997));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(arg1357_997));
print_item_54___intext(buffer_4392, length_buffer_16_4391, arg1356_996);
{
long i_3151;
i_3151 = ((long)1);
for1013_3150:
{
bool_t test_5743;
{
long aux_5744;
aux_5744 = (arg1357_997-((long)1));
test_5743 = (i_3151<=aux_5744);
}
if(test_5743){
print_item_54___intext(buffer_4392, length_buffer_16_4391, VECTOR_REF(item_858, i_3151));
{
long i_5749;
i_5749 = (i_3151+((long)1));
i_3151 = i_5749;
goto for1013_3150;
}
}
 else {
return symbol1834___intext;
}
}
}
}
}
}
}
 else {
{
long ref_998;
{
long z1_3165;
z1_3165 = _ref__195___intext;
_ref__195___intext = (z1_3165+((long)1));
}
ref_998 = _ref__195___intext;
{
obj_t mark_999;
mark_999 = VECTOR_REF(item_858, ((long)0));
{
long tag_1000;
tag_1000 = VECTOR_TAG(item_858);
{
long len_1001;
len_1001 = VECTOR_LENGTH(item_858);
{
obj_t ref0_1002;
ref0_1002 = BUNSPEC;
{
{
obj_t aux_5755;
aux_5755 = STRUCT_REF(mark_999, ((long)1));
VECTOR_SET(item_858, ((long)0), aux_5755);
}
ref0_1002 = VECTOR_REF(item_858, ((long)0));
VECTOR_SET(item_858, ((long)0), mark_999);
{
obj_t aux_5760;
aux_5760 = BINT(ref_998);
STRUCT_SET(mark_999, ((long)2), aux_5760);
}
STRUCT_SET(mark_999, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3195;
long k_3196;
string_3195 = CELL_REF(buffer_4392);
k_3196 = _pointeur__164___intext;
STRING_SET(string_3195, k_3196, ((unsigned char)'='));
}
{
long z1_3198;
z1_3198 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3198+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_998));
if((tag_1000>((long)0))){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3203;
long k_3204;
string_3203 = CELL_REF(buffer_4392);
k_3204 = _pointeur__164___intext;
STRING_SET(string_3203, k_3204, ((unsigned char)'t'));
}
{
long z1_3206;
z1_3206 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3206+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(tag_1000));
{
obj_t ref0_3209;
ref0_3209 = ref0_1002;
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(len_1001));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(len_1001));
print_item_54___intext(buffer_4392, length_buffer_16_4391, ref0_3209);
{
long i_3212;
i_3212 = ((long)1);
for1013_3211:
{
bool_t test_5783;
{
long aux_5784;
aux_5784 = (len_1001-((long)1));
test_5783 = (i_3212<=aux_5784);
}
if(test_5783){
print_item_54___intext(buffer_4392, length_buffer_16_4391, VECTOR_REF(item_858, i_3212));
{
long i_5789;
i_5789 = (i_3212+((long)1));
i_3212 = i_5789;
goto for1013_3211;
}
}
 else {
return symbol1834___intext;
}
}
}
}
}
 else {
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3227;
long k_3228;
string_3227 = CELL_REF(buffer_4392);
k_3228 = _pointeur__164___intext;
STRING_SET(string_3227, k_3228, ((unsigned char)'['));
}
{
long z1_3230;
z1_3230 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3230+((long)1));
}
{
obj_t ref0_3233;
ref0_3233 = ref0_1002;
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(len_1001));
print_mot_68___intext(buffer_4392, length_buffer_16_4391, BINT(len_1001));
print_item_54___intext(buffer_4392, length_buffer_16_4391, ref0_3233);
{
long i_3236;
i_3236 = ((long)1);
for1013_3235:
{
bool_t test_5800;
{
long aux_5801;
aux_5801 = (len_1001-((long)1));
test_5800 = (i_3236<=aux_5801);
}
if(test_5800){
print_item_54___intext(buffer_4392, length_buffer_16_4391, VECTOR_REF(item_858, i_3236));
{
long i_5806;
i_5806 = (i_3236+((long)1));
i_3236 = i_5806;
goto for1013_3235;
}
}
 else {
return symbol1834___intext;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
 else {
if(TVECTORP(item_858)){
{
obj_t mark_1013;
mark_1013 = PEEK(item_858, ((long)2));
{
bool_t test_5811;
{
obj_t aux_5812;
aux_5812 = STRUCT_REF(mark_1013, ((long)3));
test_5811 = CBOOL(aux_5812);
}
if(test_5811){
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3258;
long k_3259;
string_3258 = CELL_REF(buffer_4392);
k_3259 = _pointeur__164___intext;
STRING_SET(string_3258, k_3259, ((unsigned char)'#'));
}
{
long z1_3261;
z1_3261 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3261+((long)1));
}
{
obj_t arg1375_1015;
{
obj_t arg1378_1016;
arg1378_1016 = PEEK(item_858, ((long)2));
arg1375_1015 = STRUCT_REF(arg1378_1016, ((long)2));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, arg1375_1015);
}
{
obj_t arg1379_1017;
long arg1381_1018;
arg1379_1017 = PEEK(item_858, ((long)2));
{
obj_t arg1383_1019;
{
obj_t arg1385_1021;
arg1385_1021 = PEEK(item_858, ((long)2));
arg1383_1019 = STRUCT_REF(arg1385_1021, ((long)4));
}
{
long aux_5825;
aux_5825 = (long)CINT(arg1383_1019);
arg1381_1018 = (aux_5825-((long)1));
}
}
{
obj_t aux_5828;
aux_5828 = BINT(arg1381_1018);
STRUCT_SET(arg1379_1017, ((long)4), aux_5828);
}
}
{
bool_t test1386_1022;
{
obj_t arg1387_1023;
{
obj_t arg1389_1025;
arg1389_1025 = PEEK(item_858, ((long)2));
arg1387_1023 = STRUCT_REF(arg1389_1025, ((long)4));
}
{
long aux_5833;
aux_5833 = (long)CINT(arg1387_1023);
test1386_1022 = (aux_5833==((long)0));
}
}
if(test1386_1022){
obj_t old_value_175_3294;
{
obj_t arg1187_3295;
arg1187_3295 = PEEK(item_858, ((long)2));
old_value_175_3294 = STRUCT_REF(arg1187_3295, ((long)1));
}
return POKE(item_858, ((long)2), old_value_175_3294);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5840;
{
long aux_5841;
{
obj_t aux_5842;
aux_5842 = STRUCT_REF(mark_1013, ((long)4));
aux_5841 = (long)CINT(aux_5842);
}
test_5840 = (aux_5841==((long)0));
}
if(test_5840){
{
obj_t v_1027;
{
obj_t arg1191_3311;
arg1191_3311 = PEEK(item_858, ((long)2));
v_1027 = STRUCT_REF(arg1191_3311, ((long)5));
}
{
obj_t old_value_175_3319;
{
obj_t arg1187_3320;
arg1187_3320 = PEEK(item_858, ((long)2));
old_value_175_3319 = STRUCT_REF(arg1187_3320, ((long)1));
}
POKE(item_858, ((long)2), old_value_175_3319);
}
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3331;
long k_3332;
string_3331 = CELL_REF(buffer_4392);
k_3332 = _pointeur__164___intext;
STRING_SET(string_3331, k_3332, ((unsigned char)'V'));
}
{
long z1_3334;
z1_3334 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3334+((long)1));
}
print_item_54___intext(buffer_4392, length_buffer_16_4391, tvector_id_255___tvector(item_858));
{
obj_t item_5857;
item_5857 = v_1027;
item_858 = item_5857;
goto print_item_54___intext;
}
}
}
 else {
{
long ref_1029;
{
long z1_3336;
z1_3336 = _ref__195___intext;
_ref__195___intext = (z1_3336+((long)1));
}
ref_1029 = _ref__195___intext;
{
obj_t v_1031;
{
obj_t arg1191_3340;
arg1191_3340 = PEEK(item_858, ((long)2));
v_1031 = STRUCT_REF(arg1191_3340, ((long)5));
}
{
obj_t id_1032;
id_1032 = BUNSPEC;
{
{
obj_t aux_5861;
aux_5861 = STRUCT_REF(mark_1013, ((long)1));
POKE(item_858, ((long)2), aux_5861);
}
id_1032 = tvector_id_255___tvector(item_858);
POKE(item_858, ((long)2), mark_1013);
{
obj_t aux_5866;
aux_5866 = BINT(ref_1029);
STRUCT_SET(mark_1013, ((long)2), aux_5866);
}
STRUCT_SET(mark_1013, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3368;
long k_3369;
string_3368 = CELL_REF(buffer_4392);
k_3369 = _pointeur__164___intext;
STRING_SET(string_3368, k_3369, ((unsigned char)'='));
}
{
long z1_3371;
z1_3371 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3371+((long)1));
}
print_di_101___intext(buffer_4392, length_buffer_16_4391, BINT(ref_1029));
verifie_taille_buffer__99___intext(buffer_4392, length_buffer_16_4391, BINT(((long)0)));
{
obj_t string_3374;
long k_3375;
string_3374 = CELL_REF(buffer_4392);
k_3375 = _pointeur__164___intext;
STRING_SET(string_3374, k_3375, ((unsigned char)'V'));
}
{
long z1_3377;
z1_3377 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3377+((long)1));
}
print_item_54___intext(buffer_4392, length_buffer_16_4391, id_1032);
{
obj_t item_5881;
item_5881 = v_1031;
item_858 = item_5881;
goto print_item_54___intext;
}
}
}
}
}
}
}
}
}
}
 else {
if(PROCEDUREP(item_858)){
FAILURE(string1840___intext,string1846___intext,item_858);}
 else {
bool_t test1398_1038;
test1398_1038 = PROCESSP(item_858);
if(test1398_1038){
FAILURE(string1840___intext,string1847___intext,item_858);}
 else {
FAILURE(string1840___intext,string1848___intext,item_858);}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}


/* _obj->string */obj_t _obj__string_80___intext(obj_t env_4368, obj_t obj_4369)
{
return obj_to_string(obj_4369);
}


/* arg1207 */obj_t arg1207___intext(obj_t env_4370, obj_t x_4371, obj_t y_4372)
{
{
bool_t aux_5890;
{
obj_t x_4406;
obj_t y_4407;
x_4406 = x_4371;
y_4407 = y_4372;
aux_5890 = ((x_4406)==(y_4407));
}
return BBOOL(aux_5890);
}
}


/* arg1206 */obj_t arg1206___intext(obj_t env_4373, obj_t s_4374)
{
{
obj_t s_850;
{
long aux_5893;
s_850 = s_4374;
aux_5893 = get_hash_power_number_from_int(s_850, ((long)10));
return BINT(aux_5893);
}
}
}


/* loop */obj_t loop___intext(obj_t obj_1247)
{
loop___intext:
{
bool_t test1546_1249;
test1546_1249 = (POINTERP( obj_1247 ) && (TYPE( obj_1247 ) >= OBJECT_TYPE));
if(test1546_1249){
{
bool_t test_5898;
{
obj_t arg1200_3885;
{
object_t aux_5899;
aux_5899 = (object_t)(obj_1247);
arg1200_3885 = OBJECT_WIDENING(aux_5899);
}
if(STRUCTP(arg1200_3885)){
obj_t aux_5904;
aux_5904 = STRUCT_KEY(arg1200_3885);
test_5898 = (aux_5904==symbol1839___intext);
}
 else {
test_5898 = ((bool_t)0);
}
}
if(test_5898){
obj_t arg1548_1251;
{
object_t aux_5907;
aux_5907 = (object_t)(obj_1247);
arg1548_1251 = OBJECT_WIDENING(aux_5907);
}
{
long ref_3897;
ref_3897 = _nb_ref__249___intext;
{
obj_t old_mark_80_3898;
old_mark_80_3898 = STRUCT_REF(arg1548_1251, ((long)4));
{
obj_t aux_5911;
{
long aux_5912;
{
long aux_5913;
aux_5913 = (long)CINT(old_mark_80_3898);
aux_5912 = (((long)1)+aux_5913);
}
aux_5911 = BINT(aux_5912);
}
STRUCT_SET(arg1548_1251, ((long)4), aux_5911);
}
{
bool_t test_5918;
{
long aux_5919;
aux_5919 = (long)CINT(old_mark_80_3898);
test_5918 = (aux_5919==((long)0));
}
if(test_5918){
return (_nb_ref__249___intext = (ref_3897+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3897,
BUNSPEC);
}
}
}
}
}
 else {
obj_t struct_1252;
struct_1252 = object__struct_50___object((object_t)(obj_1247));
object_mark__221___intext(obj_1247, struct_1252);
{
obj_t obj_5926;
obj_5926 = struct_1252;
obj_1247 = obj_5926;
goto loop___intext;
}
}
}
}
 else {
if(STRUCTP(obj_1247)){
{
bool_t test1550_1254;
{
obj_t arg1195_3917;
arg1195_3917 = PEEK(obj_1247, STRUCTURE_MARK_OFFSET);
if(STRUCTP(arg1195_3917)){
obj_t aux_5932;
aux_5932 = STRUCT_KEY(arg1195_3917);
test1550_1254 = (aux_5932==symbol1839___intext);
}
 else {
test1550_1254 = ((bool_t)0);
}
}
if(test1550_1254){
obj_t arg1552_1255;
arg1552_1255 = PEEK(obj_1247, STRUCTURE_MARK_OFFSET);
{
long ref_3933;
ref_3933 = _nb_ref__249___intext;
{
obj_t old_mark_80_3934;
old_mark_80_3934 = STRUCT_REF(arg1552_1255, ((long)4));
{
obj_t aux_5938;
{
long aux_5939;
{
long aux_5940;
aux_5940 = (long)CINT(old_mark_80_3934);
aux_5939 = (((long)1)+aux_5940);
}
aux_5938 = BINT(aux_5939);
}
STRUCT_SET(arg1552_1255, ((long)4), aux_5938);
}
{
bool_t test_5945;
{
long aux_5946;
aux_5946 = (long)CINT(old_mark_80_3934);
test_5945 = (aux_5946==((long)0));
}
if(test_5945){
return (_nb_ref__249___intext = (ref_3933+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3933,
BUNSPEC);
}
}
}
}
}
 else {
long len_1257;
len_1257 = STRUCT_LENGTH(obj_1247);
loop___intext(STRUCT_KEY(obj_1247));
struct_mark__56___intext(obj_1247);
{
long i_1258;
i_1258 = ((long)0);
liip_1259:
if((i_1258==len_1257)){
return symbol1834___intext;
}
 else {
loop___intext(STRUCT_REF(obj_1247, i_1258));
{
long i_5958;
i_5958 = (i_1258+((long)1));
i_1258 = i_5958;
goto liip_1259;
}
}
}
}
}
}
 else {
bool_t test1556_1263;
{
bool_t test1599_1311;
test1599_1311 = EXTENDED_PAIRP(obj_1247);
if(test1599_1311){
test1556_1263 = _epair___65___intext;
}
 else {
test1556_1263 = ((bool_t)0);
}
}
if(test1556_1263){
{
bool_t test_5963;
{
obj_t arg1153_3961;
arg1153_3961 = CDR(obj_1247);
if(STRUCTP(arg1153_3961)){
obj_t aux_5967;
aux_5967 = STRUCT_KEY(arg1153_3961);
test_5963 = (aux_5967==symbol1839___intext);
}
 else {
test_5963 = ((bool_t)0);
}
}
if(test_5963){
obj_t arg1558_1265;
arg1558_1265 = CDR(obj_1247);
{
long ref_3974;
ref_3974 = _nb_ref__249___intext;
{
obj_t old_mark_80_3975;
old_mark_80_3975 = STRUCT_REF(arg1558_1265, ((long)4));
{
obj_t aux_5972;
{
long aux_5973;
{
long aux_5974;
aux_5974 = (long)CINT(old_mark_80_3975);
aux_5973 = (((long)1)+aux_5974);
}
aux_5972 = BINT(aux_5973);
}
STRUCT_SET(arg1558_1265, ((long)4), aux_5972);
}
{
bool_t test_5979;
{
long aux_5980;
aux_5980 = (long)CINT(old_mark_80_3975);
test_5979 = (aux_5980==((long)0));
}
if(test_5979){
return (_nb_ref__249___intext = (ref_3974+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3974,
BUNSPEC);
}
}
}
}
}
 else {
obj_t ocar_1266;
obj_t ocdr_1267;
obj_t ocer_1268;
ocar_1266 = CAR(obj_1247);
ocdr_1267 = CDR(obj_1247);
{
bool_t test1713_3995;
test1713_3995 = EXTENDED_PAIRP(obj_1247);
if(test1713_3995){
ocer_1268 = CER(obj_1247);
}
 else {
FAILURE(string1844___intext,string1836___intext,obj_1247);}
}
pair_mark__18___intext(obj_1247);
loop___intext(ocar_1266);
loop___intext(ocer_1268);
{
obj_t obj_5993;
obj_5993 = ocdr_1267;
obj_1247 = obj_5993;
goto loop___intext;
}
}
}
}
 else {
if(PAIRP(obj_1247)){
{
bool_t test_5996;
{
obj_t arg1153_4002;
arg1153_4002 = CDR(obj_1247);
if(STRUCTP(arg1153_4002)){
obj_t aux_6000;
aux_6000 = STRUCT_KEY(arg1153_4002);
test_5996 = (aux_6000==symbol1839___intext);
}
 else {
test_5996 = ((bool_t)0);
}
}
if(test_5996){
obj_t arg1561_1271;
arg1561_1271 = CDR(obj_1247);
{
long ref_4015;
ref_4015 = _nb_ref__249___intext;
{
obj_t old_mark_80_4016;
old_mark_80_4016 = STRUCT_REF(arg1561_1271, ((long)4));
{
obj_t aux_6005;
{
long aux_6006;
{
long aux_6007;
aux_6007 = (long)CINT(old_mark_80_4016);
aux_6006 = (((long)1)+aux_6007);
}
aux_6005 = BINT(aux_6006);
}
STRUCT_SET(arg1561_1271, ((long)4), aux_6005);
}
{
bool_t test_6012;
{
long aux_6013;
aux_6013 = (long)CINT(old_mark_80_4016);
test_6012 = (aux_6013==((long)0));
}
if(test_6012){
return (_nb_ref__249___intext = (ref_4015+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4015,
BUNSPEC);
}
}
}
}
}
 else {
obj_t ocar_1272;
obj_t ocdr_1273;
ocar_1272 = CAR(obj_1247);
ocdr_1273 = CDR(obj_1247);
pair_mark__18___intext(obj_1247);
loop___intext(ocar_1272);
{
obj_t obj_6021;
obj_6021 = ocdr_1273;
obj_1247 = obj_6021;
goto loop___intext;
}
}
}
}
 else {
if(CELLP(obj_1247)){
{
bool_t test1563_1275;
{
obj_t arg1162_4036;
arg1162_4036 = CELL_REF(obj_1247);
if(STRUCTP(arg1162_4036)){
obj_t aux_6027;
aux_6027 = STRUCT_KEY(arg1162_4036);
test1563_1275 = (aux_6027==symbol1839___intext);
}
 else {
test1563_1275 = ((bool_t)0);
}
}
if(test1563_1275){
obj_t arg1564_1276;
arg1564_1276 = CELL_REF(obj_1247);
{
long ref_4047;
ref_4047 = _nb_ref__249___intext;
{
obj_t old_mark_80_4048;
old_mark_80_4048 = STRUCT_REF(arg1564_1276, ((long)4));
{
obj_t aux_6033;
{
long aux_6034;
{
long aux_6035;
aux_6035 = (long)CINT(old_mark_80_4048);
aux_6034 = (((long)1)+aux_6035);
}
aux_6033 = BINT(aux_6034);
}
STRUCT_SET(arg1564_1276, ((long)4), aux_6033);
}
{
bool_t test_6040;
{
long aux_6041;
aux_6041 = (long)CINT(old_mark_80_4048);
test_6040 = (aux_6041==((long)0));
}
if(test_6040){
return (_nb_ref__249___intext = (ref_4047+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4047,
BUNSPEC);
}
}
}
}
}
 else {
obj_t oref_1277;
oref_1277 = CELL_REF(obj_1247);
cell_mark__177___intext(obj_1247);
{
obj_t obj_6047;
obj_6047 = oref_1277;
obj_1247 = obj_6047;
goto loop___intext;
}
}
}
}
 else {
if(SYMBOLP(obj_1247)){
{
bool_t test_6050;
{
obj_t arg1166_4067;
arg1166_4067 = getprop___r4_symbols_6_4(obj_1247, symbol1839___intext);
if(STRUCTP(arg1166_4067)){
obj_t aux_6054;
aux_6054 = STRUCT_KEY(arg1166_4067);
test_6050 = (aux_6054==symbol1839___intext);
}
 else {
test_6050 = ((bool_t)0);
}
}
if(test_6050){
obj_t arg1568_1280;
arg1568_1280 = getprop___r4_symbols_6_4(obj_1247, symbol1839___intext);
{
long ref_4080;
ref_4080 = _nb_ref__249___intext;
{
obj_t old_mark_80_4081;
old_mark_80_4081 = STRUCT_REF(arg1568_1280, ((long)4));
{
obj_t aux_6059;
{
long aux_6060;
{
long aux_6061;
aux_6061 = (long)CINT(old_mark_80_4081);
aux_6060 = (((long)1)+aux_6061);
}
aux_6059 = BINT(aux_6060);
}
STRUCT_SET(arg1568_1280, ((long)4), aux_6059);
}
{
bool_t test_6066;
{
long aux_6067;
aux_6067 = (long)CINT(old_mark_80_4081);
test_6066 = (aux_6067==((long)0));
}
if(test_6066){
return (_nb_ref__249___intext = (ref_4080+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4080,
BUNSPEC);
}
}
}
}
}
 else {
return symbol_mark__15___intext(obj_1247);
}
}
}
 else {
if(KEYWORDP(obj_1247)){
return symbol1834___intext;
}
 else {
bool_t test_6074;
if(INTEGERP(obj_1247)){
test_6074 = ((bool_t)1);
}
 else {
test_6074 = REALP(obj_1247);
}
if(test_6074){
return symbol1834___intext;
}
 else {
if(STRINGP(obj_1247)){
{
bool_t test_6080;
{
long aux_6081;
aux_6081 = STRING_LENGTH(obj_1247);
test_6080 = (aux_6081<((long)0));
}
if(test_6080){
obj_t arg1573_1285;
{
obj_t cell_4110;
cell_4110 = get_hash_29___hash(obj_1247, _string_mark_table__203___intext);
if(PAIRP(cell_4110)){
arg1573_1285 = CDR(cell_4110);
}
 else {
FAILURE(string1840___intext,string1845___intext,BUNSPEC);}
}
{
long ref_4118;
ref_4118 = _nb_ref__249___intext;
{
obj_t old_mark_80_4119;
old_mark_80_4119 = STRUCT_REF(arg1573_1285, ((long)4));
{
obj_t aux_6090;
{
long aux_6091;
{
long aux_6092;
aux_6092 = (long)CINT(old_mark_80_4119);
aux_6091 = (((long)1)+aux_6092);
}
aux_6090 = BINT(aux_6091);
}
STRUCT_SET(arg1573_1285, ((long)4), aux_6090);
}
{
bool_t test_6097;
{
long aux_6098;
aux_6098 = (long)CINT(old_mark_80_4119);
test_6097 = (aux_6098==((long)0));
}
if(test_6097){
return (_nb_ref__249___intext = (ref_4118+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4118,
BUNSPEC);
}
}
}
}
}
 else {
return string_mark__64___intext(obj_1247);
}
}
}
 else {
if(UCS2_STRINGP(obj_1247)){
{
bool_t test_6105;
{
long aux_6106;
aux_6106 = UCS2_STRING_LENGTH(obj_1247);
test_6105 = (aux_6106<((long)0));
}
if(test_6105){
obj_t arg1578_1288;
{
obj_t cell_4144;
cell_4144 = get_hash_29___hash(obj_1247, _string_mark_table__203___intext);
if(PAIRP(cell_4144)){
arg1578_1288 = CDR(cell_4144);
}
 else {
FAILURE(string1840___intext,string1841___intext,BUNSPEC);}
}
{
long ref_4152;
ref_4152 = _nb_ref__249___intext;
{
obj_t old_mark_80_4153;
old_mark_80_4153 = STRUCT_REF(arg1578_1288, ((long)4));
{
obj_t aux_6115;
{
long aux_6116;
{
long aux_6117;
aux_6117 = (long)CINT(old_mark_80_4153);
aux_6116 = (((long)1)+aux_6117);
}
aux_6115 = BINT(aux_6116);
}
STRUCT_SET(arg1578_1288, ((long)4), aux_6115);
}
{
bool_t test_6122;
{
long aux_6123;
aux_6123 = (long)CINT(old_mark_80_4153);
test_6122 = (aux_6123==((long)0));
}
if(test_6122){
return (_nb_ref__249___intext = (ref_4152+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4152,
BUNSPEC);
}
}
}
}
}
 else {
return ucs2_string_mark__64___intext(obj_1247);
}
}
}
 else {
if(VECTORP(obj_1247)){
{
bool_t test_6130;
{
long aux_6131;
aux_6131 = VECTOR_LENGTH(obj_1247);
test_6130 = (aux_6131==((long)0));
}
if(test_6130){
return symbol1834___intext;
}
 else {
bool_t test_6134;
{
obj_t arg1186_4175;
arg1186_4175 = VECTOR_REF(obj_1247, ((long)0));
if(STRUCTP(arg1186_4175)){
obj_t aux_6138;
aux_6138 = STRUCT_KEY(arg1186_4175);
test_6134 = (aux_6138==symbol1839___intext);
}
 else {
test_6134 = ((bool_t)0);
}
}
if(test_6134){
obj_t arg1582_1292;
arg1582_1292 = VECTOR_REF(obj_1247, ((long)0));
{
long ref_4191;
ref_4191 = _nb_ref__249___intext;
{
obj_t old_mark_80_4192;
old_mark_80_4192 = STRUCT_REF(arg1582_1292, ((long)4));
{
obj_t aux_6143;
{
long aux_6144;
{
long aux_6145;
aux_6145 = (long)CINT(old_mark_80_4192);
aux_6144 = (((long)1)+aux_6145);
}
aux_6143 = BINT(aux_6144);
}
STRUCT_SET(arg1582_1292, ((long)4), aux_6143);
}
{
bool_t test_6150;
{
long aux_6151;
aux_6151 = (long)CINT(old_mark_80_4192);
test_6150 = (aux_6151==((long)0));
}
if(test_6150){
return (_nb_ref__249___intext = (ref_4191+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4191,
BUNSPEC);
}
}
}
}
}
 else {
long len_1293;
long tag_1294;
len_1293 = VECTOR_LENGTH(obj_1247);
tag_1294 = VECTOR_TAG(obj_1247);
loop___intext(VECTOR_REF(obj_1247, ((long)0)));
vector_mark__202___intext(obj_1247);
{
long i_1296;
i_1296 = ((long)1);
liip_1297:
if((i_1296>=len_1293)){
return symbol1834___intext;
}
 else {
loop___intext(VECTOR_REF(obj_1247, i_1296));
{
long i_6164;
i_6164 = (i_1296+((long)1));
i_1296 = i_6164;
goto liip_1297;
}
}
}
}
}
}
}
 else {
if(TVECTORP(obj_1247)){
{
bool_t test1590_1304;
{
obj_t arg1190_4221;
arg1190_4221 = PEEK(obj_1247, ((long)2));
if(STRUCTP(arg1190_4221)){
obj_t aux_6171;
aux_6171 = STRUCT_KEY(arg1190_4221);
test1590_1304 = (aux_6171==symbol1839___intext);
}
 else {
test1590_1304 = ((bool_t)0);
}
}
if(test1590_1304){
obj_t arg1592_1305;
arg1592_1305 = VECTOR_REF(obj_1247, ((long)0));
{
long ref_4237;
ref_4237 = _nb_ref__249___intext;
{
obj_t old_mark_80_4238;
old_mark_80_4238 = STRUCT_REF(arg1592_1305, ((long)4));
{
obj_t aux_6177;
{
long aux_6178;
{
long aux_6179;
aux_6179 = (long)CINT(old_mark_80_4238);
aux_6178 = (((long)1)+aux_6179);
}
aux_6177 = BINT(aux_6178);
}
STRUCT_SET(arg1592_1305, ((long)4), aux_6177);
}
{
bool_t test_6184;
{
long aux_6185;
aux_6185 = (long)CINT(old_mark_80_4238);
test_6184 = (aux_6185==((long)0));
}
if(test_6184){
return (_nb_ref__249___intext = (ref_4237+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4237,
BUNSPEC);
}
}
}
}
}
 else {
obj_t v_1306;
v_1306 = tvector__vector_99___tvector(obj_1247);
loop___intext(tvector_id_255___tvector(obj_1247));
loop___intext(v_1306);
return tvector_mark__214___intext(obj_1247, v_1306);
}
}
}
 else {
bool_t test1594_1308;
test1594_1308 = POINTERP(obj_1247);
if(test1594_1308){
bool_t test1595_1309;
{
obj_t arg1157_4256;
arg1157_4256 = PEEK(obj_1247, ((long)1));
if(STRUCTP(arg1157_4256)){
obj_t aux_6199;
aux_6199 = STRUCT_KEY(arg1157_4256);
test1595_1309 = (aux_6199==symbol1839___intext);
}
 else {
test1595_1309 = ((bool_t)0);
}
}
if(test1595_1309){
{
obj_t arg1598_1310;
arg1598_1310 = PEEK(obj_1247, ((long)1));
{
long ref_4272;
ref_4272 = _nb_ref__249___intext;
{
obj_t old_mark_80_4273;
old_mark_80_4273 = STRUCT_REF(arg1598_1310, ((long)4));
{
obj_t aux_6205;
{
long aux_6206;
{
long aux_6207;
aux_6207 = (long)CINT(old_mark_80_4273);
aux_6206 = (((long)1)+aux_6207);
}
aux_6205 = BINT(aux_6206);
}
STRUCT_SET(arg1598_1310, ((long)4), aux_6205);
}
{
bool_t test_6212;
{
long aux_6213;
aux_6213 = (long)CINT(old_mark_80_4273);
test_6212 = (aux_6213==((long)0));
}
if(test_6212){
return (_nb_ref__249___intext = (ref_4272+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4272,
BUNSPEC);
}
}
}
}
}
}
 else {
return symbol1834___intext;
}
}
 else {
return symbol1834___intext;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}


/* marked-pair-length */long marked_pair_length_178___intext(obj_t l_79)
{
{
obj_t l_1312;
long r_1313;
l_1312 = l_79;
r_1313 = ((long)1);
loop_1314:
{
obj_t vcdr_1316;
{
obj_t aux_6217;
aux_6217 = CDR(l_1312);
vcdr_1316 = STRUCT_REF(aux_6217, ((long)1));
}
{
if(PAIRP(vcdr_1316)){
obj_t mark_1318;
mark_1318 = CDR(vcdr_1316);
{
bool_t test_6223;
if(_2__206___r4_numbers_6_5(STRUCT_REF(mark_1318, ((long)4)), BINT(((long)0)))){
test_6223 = ((bool_t)1);
}
 else {
obj_t aux_6228;
aux_6228 = STRUCT_REF(mark_1318, ((long)3));
test_6223 = CBOOL(aux_6228);
}
if(test_6223){
return (r_1313+((long)1));
}
 else {
long r_6233;
obj_t l_6232;
l_6232 = vcdr_1316;
r_6233 = (r_1313+((long)1));
r_1313 = r_6233;
l_1312 = l_6232;
goto loop_1314;
}
}
}
 else {
return (r_1313+((long)1));
}
}
}
}
}


/* method-init */obj_t method_init_76___intext()
{
return BUNSPEC;
}


/* imported-modules-init */obj_t imported_modules_init_94___intext()
{
return module_initialization_70___error(((long)0), "__INTEXT");
}

