/*===========================================================================*/
/*   (Llib/hash.scm)                                                         */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _put_hash__86___hash(obj_t, obj_t, obj_t);
extern obj_t string_to_symbol(char *);
static obj_t _rem_obj_hash__23___hash(obj_t, obj_t, obj_t);
static obj_t _make_hash_table1262_83___hash(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern long obj__0__255_3___hash(obj_t);
extern obj_t for_each_hash_105___hash(obj_t, obj_t);
static obj_t symbol1276___hash = BUNSPEC;
static obj_t symbol1271___hash = BUNSPEC;
extern long get_hash_number(char *);
extern obj_t hash_table__vector_145___hash(obj_t);
static obj_t _hash_table__vector_152___hash(obj_t, obj_t);
static obj_t toplevel_init_63___hash();
static bool_t _2_power__4___hash(obj_t);
extern long string__0__255_119___hash(char *);
extern obj_t put_hash__129___hash(obj_t, obj_t);
static obj_t _for_each_hash1263_77___hash(obj_t, obj_t, obj_t);
extern obj_t create_struct(obj_t, long);
static obj_t get_hash_number_100___hash(obj_t, obj_t);
static obj_t _get_hash_182___hash(obj_t, obj_t, obj_t);
static obj_t hash_table_grows__110___hash(obj_t);
extern obj_t hash_table_nb_entry_45___hash(obj_t);
extern obj_t get_hash_29___hash(obj_t, obj_t);
extern obj_t module_initialization_70___hash(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _int__0__2_x_11267_224___hash(obj_t, obj_t, obj_t);
static obj_t _hash_table__163___hash(obj_t, obj_t);
static obj_t _int__0__2551266_172___hash(obj_t, obj_t);
extern long get_hash_power_number(char *, long);
extern obj_t make_hash_table_174___hash(long, obj_t, obj_t, obj_t, obj_t);
static obj_t _string__0__2551264_239___hash(obj_t, obj_t);
extern long string__0__2_x_1_163___hash(char *, long);
extern long int__0__255_26___hash(long);
extern bool_t hash_table__21___hash(obj_t);
static obj_t _obj__0__2_x_11268_190___hash(obj_t, obj_t, obj_t);
static obj_t _string__0__2_x_11265_76___hash(obj_t, obj_t, obj_t);
static obj_t imported_modules_init_94___hash();
extern long modulo___r4_numbers_6_5_fixnum(long, long);
static obj_t require_initialization_114___hash = BUNSPEC;
static obj_t _obj__0__255_117___hash(obj_t, obj_t);
extern obj_t rem_key_hash__152___hash(obj_t, obj_t);
extern long obj__0__2_x_1_138___hash(obj_t, long);
static obj_t _hash_table_nb_entry_102___hash(obj_t, obj_t);
static obj_t cnst_init_137___hash();
extern obj_t rem_obj_hash__55___hash(obj_t, obj_t);
static obj_t _rem_key_hash__54___hash(obj_t, obj_t, obj_t);
extern obj_t make_vector(long, obj_t);
extern long int__0__2_x_1_11___hash(long, long);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( hash_table__env_123___hash, _hash_table__163___hash1278, _hash_table__163___hash, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_hash_table_env_156___hash, _make_hash_table1262_83___hash1279, va_generic_entry, _make_hash_table1262_83___hash, -5 );
DEFINE_EXPORT_PROCEDURE( string__0__255_env_51___hash, _string__0__2551264_239___hash1280, _string__0__2551264_239___hash, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( rem_key_hash__env_114___hash, _rem_key_hash__54___hash1281, _rem_key_hash__54___hash, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( int__0__2_x_1_env_186___hash, _int__0__2_x_11267_224___hash1282, _int__0__2_x_11267_224___hash, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( put_hash__env_10___hash, _put_hash__86___hash1283, _put_hash__86___hash, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( obj__0__255_env_221___hash, _obj__0__255_117___hash1284, _obj__0__255_117___hash, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( obj__0__2_x_1_env_67___hash, _obj__0__2_x_11268_190___hash1285, _obj__0__2_x_11268_190___hash, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( rem_obj_hash__env_231___hash, _rem_obj_hash__23___hash1286, _rem_obj_hash__23___hash, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( hash_table__vector_env_1___hash, _hash_table__vector_152___hash1287, _hash_table__vector_152___hash, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( int__0__255_env_252___hash, _int__0__2551266_172___hash1288, _int__0__2551266_172___hash, 0L, 1 );
DEFINE_STRING( string1275___hash, string1275___hash1289, "Illegal get-hash-function", 25 );
DEFINE_STRING( string1274___hash, string1274___hash1290, "get-hash-number", 15 );
DEFINE_STRING( string1273___hash, string1273___hash1291, "Illegal init-size (not a 2 power)", 33 );
DEFINE_STRING( string1272___hash, string1272___hash1292, "Illegal max-size (not a 2 power)", 32 );
DEFINE_STRING( string1269___hash, string1269___hash1293, "make-hash-table", 15 );
DEFINE_STRING( string1270___hash, string1270___hash1294, "init-size greater than max-size !", 33 );
DEFINE_EXPORT_PROCEDURE( string__0__2_x_1_env_255___hash, _string__0__2_x_11265_76___hash1295, _string__0__2_x_11265_76___hash, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( get_hash_env_117___hash, _get_hash_182___hash1296, _get_hash_182___hash, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( hash_table_nb_entry_env_125___hash, _hash_table_nb_entry_102___hash1297, _hash_table_nb_entry_102___hash, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( for_each_hash_env_166___hash, _for_each_hash1263_77___hash1298, _for_each_hash1263_77___hash, 0L, 2 );


/* module-initialization */obj_t module_initialization_70___hash(long checksum_1132, char * from_1133)
{
if(CBOOL(require_initialization_114___hash)){
require_initialization_114___hash = BBOOL(((bool_t)0));
cnst_init_137___hash();
imported_modules_init_94___hash();
toplevel_init_63___hash();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___hash()
{
symbol1271___hash = string_to_symbol("HASHTBL");
return (symbol1276___hash = string_to_symbol("DONE"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___hash()
{
return BUNSPEC;
}


/* make-hash-table */obj_t make_hash_table_174___hash(long max_size_171_31, obj_t get_hash_number_100_32, obj_t get_key_253_33, obj_t eq_34, obj_t init_size_5_35)
{
{
obj_t size_321;
if(NULLP(init_size_5_35)){
size_321 = BINT(max_size_171_31);
}
 else {
size_321 = CAR(init_size_5_35);
}
if(_2_power__4___hash(size_321)){
if(_2_power__4___hash(BINT(max_size_171_31))){
bool_t test_1151;
{
long aux_1152;
aux_1152 = (long)CINT(size_321);
test_1151 = (aux_1152>max_size_171_31);
}
if(test_1151){
FAILURE(string1269___hash,string1270___hash,size_321);}
 else {
{
obj_t table_326;
{
long aux_1156;
aux_1156 = (long)CINT(size_321);
table_326 = make_vector(aux_1156, BNIL);
}
{
obj_t new_696;
new_696 = create_struct(symbol1271___hash, ((long)7));
STRUCT_SET(new_696, ((long)6), table_326);
STRUCT_SET(new_696, ((long)5), eq_34);
{
obj_t aux_1162;
aux_1162 = BINT(((long)0));
STRUCT_SET(new_696, ((long)4), aux_1162);
}
STRUCT_SET(new_696, ((long)3), get_key_253_33);
STRUCT_SET(new_696, ((long)2), get_hash_number_100_32);
STRUCT_SET(new_696, ((long)1), size_321);
{
obj_t aux_1168;
aux_1168 = BINT(max_size_171_31);
STRUCT_SET(new_696, ((long)0), aux_1168);
}
return new_696;
}
}
}
}
 else {
FAILURE(string1269___hash,string1272___hash,BINT(max_size_171_31));}
}
 else {
FAILURE(string1269___hash,string1273___hash,size_321);}
}
}


/* 2^power? */bool_t _2_power__4___hash(obj_t size_329)
{
{
long n_331;
n_331 = ((long)1);
loop_332:
{
long num_333;
num_333 = (((long)1) << n_331);
{
bool_t test_1175;
{
long aux_1176;
aux_1176 = (long)CINT(size_329);
test_1175 = (num_333==aux_1176);
}
if(test_1175){
return ((bool_t)1);
}
 else {
bool_t test_1179;
{
long aux_1180;
aux_1180 = (long)CINT(size_329);
test_1179 = (num_333<aux_1180);
}
if(test_1179){
{
long n_1183;
n_1183 = (n_331+((long)1));
n_331 = n_1183;
goto loop_332;
}
}
 else {
return ((bool_t)0);
}
}
}
}
}
}


/* _make-hash-table1262 */obj_t _make_hash_table1262_83___hash(obj_t env_1083, obj_t max_size_171_1084, obj_t get_hash_number_100_1085, obj_t get_key_253_1086, obj_t eq_1087, obj_t init_size_5_1088)
{
return make_hash_table_174___hash((long)CINT(max_size_171_1084), get_hash_number_100_1085, get_key_253_1086, eq_1087, init_size_5_1088);
}


/* hash-table? */bool_t hash_table__21___hash(obj_t obj_36)
{
if(STRUCTP(obj_36)){
obj_t aux_1189;
aux_1189 = STRUCT_KEY(obj_36);
return (aux_1189==symbol1271___hash);
}
 else {
return ((bool_t)0);
}
}


/* _hash-table? */obj_t _hash_table__163___hash(obj_t env_1089, obj_t obj_1090)
{
{
bool_t aux_1192;
aux_1192 = hash_table__21___hash(obj_1090);
return BBOOL(aux_1192);
}
}


/* hash-table-nb-entry */obj_t hash_table_nb_entry_45___hash(obj_t table_37)
{
return STRUCT_REF(table_37, ((long)4));
}


/* _hash-table-nb-entry */obj_t _hash_table_nb_entry_102___hash(obj_t env_1091, obj_t table_1092)
{
return hash_table_nb_entry_45___hash(table_1092);
}


/* hash-table->vector */obj_t hash_table__vector_145___hash(obj_t table_38)
{
return STRUCT_REF(table_38, ((long)6));
}


/* _hash-table->vector */obj_t _hash_table__vector_152___hash(obj_t env_1093, obj_t table_1094)
{
return hash_table__vector_145___hash(table_1094);
}


/* get-hash-number */obj_t get_hash_number_100___hash(obj_t table_39, obj_t key_40)
{
{
obj_t hash_function_218_338;
hash_function_218_338 = STRUCT_REF(table_39, ((long)2));
{
obj_t max_size_171_339;
max_size_171_339 = STRUCT_REF(table_39, ((long)0));
{
obj_t size_340;
size_340 = STRUCT_REF(table_39, ((long)1));
{
obj_t num_341;
num_341 = PROCEDURE_ENTRY(hash_function_218_338)(hash_function_218_338, key_40, BEOA);
{
obj_t res_342;
{
bool_t test_1204;
{
long aux_1207;
long aux_1205;
aux_1207 = (long)CINT(max_size_171_339);
aux_1205 = (long)CINT(size_340);
test_1204 = (aux_1205<aux_1207);
}
if(test_1204){
long aux_1210;
aux_1210 = modulo___r4_numbers_6_5_fixnum((long)CINT(num_341), (long)CINT(size_340));
res_342 = BINT(aux_1210);
}
 else {
res_342 = num_341;
}
}
{
{
bool_t test_1215;
{
long aux_1218;
long aux_1216;
aux_1218 = (long)CINT(max_size_171_339);
aux_1216 = (long)CINT(res_342);
test_1215 = (aux_1216>=aux_1218);
}
if(test_1215){
obj_t res_344;
FAILURE(string1274___hash,string1275___hash,table_39);}
 else {
return res_342;
}
}
}
}
}
}
}
}
}


/* get-hash */obj_t get_hash_29___hash(obj_t key_41, obj_t table_42)
{
{
obj_t hash_num_11_347;
hash_num_11_347 = get_hash_number_100___hash(table_42, key_41);
{
obj_t hash_eq__126_348;
hash_eq__126_348 = STRUCT_REF(table_42, ((long)5));
{
obj_t get_key_253_350;
get_key_253_350 = STRUCT_REF(table_42, ((long)3));
{
{
obj_t bucket_351;
{
long aux_1243;
obj_t aux_1241;
aux_1243 = (long)CINT(hash_num_11_347);
aux_1241 = STRUCT_REF(table_42, ((long)6));
bucket_351 = VECTOR_REF(aux_1241, aux_1243);
}
loop_352:
if(NULLP(bucket_351)){
return BFALSE;
}
 else {
bool_t test1039_354;
{
obj_t arg1041_356;
arg1041_356 = PROCEDURE_ENTRY(get_key_253_350)(get_key_253_350, CAR(bucket_351), BEOA);
{
obj_t aux_1233;
aux_1233 = PROCEDURE_ENTRY(hash_eq__126_348)(hash_eq__126_348, arg1041_356, key_41, BEOA);
test1039_354 = CBOOL(aux_1233);
}
}
if(test1039_354){
return CAR(bucket_351);
}
 else {
{
obj_t bucket_1239;
bucket_1239 = CDR(bucket_351);
bucket_351 = bucket_1239;
goto loop_352;
}
}
}
}
}
}
}
}
}


/* _get-hash */obj_t _get_hash_182___hash(obj_t env_1095, obj_t key_1096, obj_t table_1097)
{
return get_hash_29___hash(key_1096, table_1097);
}


/* put-hash! */obj_t put_hash__129___hash(obj_t obj_43, obj_t table_44)
{
{
bool_t test_1247;
{
bool_t test_1248;
{
long aux_1253;
long aux_1249;
{
obj_t aux_1254;
aux_1254 = STRUCT_REF(table_44, ((long)0));
aux_1253 = (long)CINT(aux_1254);
}
{
obj_t aux_1250;
aux_1250 = STRUCT_REF(table_44, ((long)1));
aux_1249 = (long)CINT(aux_1250);
}
test_1248 = (aux_1249<aux_1253);
}
if(test_1248){
long aux_1262;
long aux_1258;
{
long aux_1263;
{
obj_t aux_1264;
aux_1264 = STRUCT_REF(table_44, ((long)1));
aux_1263 = (long)CINT(aux_1264);
}
aux_1262 = (aux_1263/((long)2));
}
{
obj_t aux_1259;
aux_1259 = STRUCT_REF(table_44, ((long)4));
aux_1258 = (long)CINT(aux_1259);
}
test_1247 = (aux_1258>aux_1262);
}
 else {
test_1247 = ((bool_t)0);
}
}
if(test_1247){
hash_table_grows__110___hash(table_44);
}
 else {
BUNSPEC;
}
}
{
obj_t get_key_253_367;
get_key_253_367 = STRUCT_REF(table_44, ((long)3));
{
obj_t key_368;
key_368 = PROCEDURE_ENTRY(get_key_253_367)(get_key_253_367, obj_43, BEOA);
{
obj_t hash_eq__126_369;
hash_eq__126_369 = STRUCT_REF(table_44, ((long)5));
{
obj_t hash_num_11_370;
hash_num_11_370 = get_hash_number_100___hash(table_44, key_368);
{
obj_t vec_371;
vec_371 = STRUCT_REF(table_44, ((long)6));
{
obj_t bucket_372;
{
long aux_1276;
aux_1276 = (long)CINT(hash_num_11_370);
bucket_372 = VECTOR_REF(vec_371, aux_1276);
}
{
if(NULLP(bucket_372)){
{
obj_t aux_1281;
{
long aux_1282;
{
long aux_1283;
{
obj_t aux_1284;
aux_1284 = STRUCT_REF(table_44, ((long)4));
aux_1283 = (long)CINT(aux_1284);
}
aux_1282 = (((long)1)+aux_1283);
}
aux_1281 = BINT(aux_1282);
}
STRUCT_SET(table_44, ((long)4), aux_1281);
}
{
obj_t arg1056_377;
{
obj_t list1057_378;
list1057_378 = MAKE_PAIR(obj_43, BNIL);
arg1056_377 = list1057_378;
}
{
long aux_1291;
aux_1291 = (long)CINT(hash_num_11_370);
VECTOR_SET(vec_371, aux_1291, arg1056_377);
}
}
return obj_43;
}
 else {
obj_t bucket_380;
bucket_380 = bucket_372;
loop_381:
{
bool_t test1059_382;
{
obj_t arg1070_392;
arg1070_392 = PROCEDURE_ENTRY(get_key_253_367)(get_key_253_367, CAR(bucket_380), BEOA);
{
obj_t aux_1297;
aux_1297 = PROCEDURE_ENTRY(hash_eq__126_369)(hash_eq__126_369, arg1070_392, key_368, BEOA);
test1059_382 = CBOOL(aux_1297);
}
}
if(test1059_382){
return CAR(bucket_380);
}
 else {
bool_t test_1303;
{
obj_t aux_1304;
aux_1304 = CDR(bucket_380);
test_1303 = NULLP(aux_1304);
}
if(test_1303){
{
obj_t aux_1307;
{
long aux_1308;
{
long aux_1309;
{
obj_t aux_1310;
aux_1310 = STRUCT_REF(table_44, ((long)4));
aux_1309 = (long)CINT(aux_1310);
}
aux_1308 = (((long)1)+aux_1309);
}
aux_1307 = BINT(aux_1308);
}
STRUCT_SET(table_44, ((long)4), aux_1307);
}
{
obj_t arg1065_387;
{
obj_t list1066_388;
list1066_388 = MAKE_PAIR(obj_43, BNIL);
arg1065_387 = list1066_388;
}
SET_CDR(bucket_380, arg1065_387);
}
return obj_43;
}
 else {
{
obj_t bucket_1318;
bucket_1318 = CDR(bucket_380);
bucket_380 = bucket_1318;
goto loop_381;
}
}
}
}
}
}
}
}
}
}
}
}
}


/* _put-hash! */obj_t _put_hash__86___hash(obj_t env_1098, obj_t obj_1099, obj_t table_1100)
{
return put_hash__129___hash(obj_1099, table_1100);
}


/* rem-obj-hash! */obj_t rem_obj_hash__55___hash(obj_t obj_45, obj_t table_46)
{
{
obj_t get_key_253_394;
get_key_253_394 = STRUCT_REF(table_46, ((long)3));
{
obj_t key_395;
key_395 = PROCEDURE_ENTRY(get_key_253_394)(get_key_253_394, obj_45, BEOA);
{
obj_t hash_num_11_397;
hash_num_11_397 = get_hash_number_100___hash(table_46, key_395);
{
obj_t vec_398;
vec_398 = STRUCT_REF(table_46, ((long)6));
{
obj_t bucket_399;
{
long aux_1326;
aux_1326 = (long)CINT(hash_num_11_397);
bucket_399 = VECTOR_REF(vec_398, aux_1326);
}
{
if(NULLP(bucket_399)){
return BFALSE;
}
 else {
bool_t test_1331;
{
obj_t aux_1332;
aux_1332 = CAR(bucket_399);
test_1331 = (aux_1332==obj_45);
}
if(test_1331){
{
obj_t aux_1335;
{
long aux_1336;
{
long aux_1337;
{
obj_t aux_1338;
aux_1338 = STRUCT_REF(table_46, ((long)4));
aux_1337 = (long)CINT(aux_1338);
}
aux_1336 = (aux_1337-((long)1));
}
aux_1335 = BINT(aux_1336);
}
STRUCT_SET(table_46, ((long)4), aux_1335);
}
{
obj_t aux_1346;
long aux_1344;
aux_1346 = CDR(bucket_399);
aux_1344 = (long)CINT(hash_num_11_397);
VECTOR_SET(vec_398, aux_1344, aux_1346);
}
return BTRUE;
}
 else {
{
obj_t bucket_406;
{
bool_t aux_1349;
bucket_406 = bucket_399;
loop_407:
{
bool_t test_1350;
{
obj_t aux_1351;
{
obj_t aux_1352;
aux_1352 = CDR(bucket_406);
aux_1351 = CAR(aux_1352);
}
test_1350 = (aux_1351==obj_45);
}
if(test_1350){
{
obj_t aux_1356;
{
long aux_1357;
{
long aux_1358;
{
obj_t aux_1359;
aux_1359 = STRUCT_REF(table_46, ((long)4));
aux_1358 = (long)CINT(aux_1359);
}
aux_1357 = (aux_1358-((long)1));
}
aux_1356 = BINT(aux_1357);
}
STRUCT_SET(table_46, ((long)4), aux_1356);
}
{
obj_t aux_1365;
{
obj_t aux_1366;
aux_1366 = CDR(bucket_406);
aux_1365 = CDR(aux_1366);
}
SET_CDR(bucket_406, aux_1365);
}
aux_1349 = ((bool_t)1);
}
 else {
bool_t test_1370;
{
obj_t aux_1371;
aux_1371 = CDR(bucket_406);
test_1370 = NULLP(aux_1371);
}
if(test_1370){
aux_1349 = ((bool_t)0);
}
 else {
{
obj_t bucket_1374;
bucket_1374 = CDR(bucket_406);
bucket_406 = bucket_1374;
goto loop_407;
}
}
}
}
return BBOOL(aux_1349);
}
}
}
}
}
}
}
}
}
}
}


/* _rem-obj-hash! */obj_t _rem_obj_hash__23___hash(obj_t env_1101, obj_t obj_1102, obj_t table_1103)
{
return rem_obj_hash__55___hash(obj_1102, table_1103);
}


/* rem-key-hash! */obj_t rem_key_hash__152___hash(obj_t key_47, obj_t table_48)
{
{
obj_t get_key_253_418;
get_key_253_418 = STRUCT_REF(table_48, ((long)3));
{
obj_t hash_eq__126_419;
hash_eq__126_419 = STRUCT_REF(table_48, ((long)5));
{
obj_t hash_num_11_420;
hash_num_11_420 = get_hash_number_100___hash(table_48, key_47);
{
obj_t vec_421;
vec_421 = STRUCT_REF(table_48, ((long)6));
{
obj_t bucket_422;
{
long aux_1382;
aux_1382 = (long)CINT(hash_num_11_420);
bucket_422 = VECTOR_REF(vec_421, aux_1382);
}
{
if(NULLP(bucket_422)){
return BFALSE;
}
 else {
bool_t test1091_424;
{
obj_t arg1106_441;
arg1106_441 = PROCEDURE_ENTRY(get_key_253_418)(get_key_253_418, CAR(bucket_422), BEOA);
{
obj_t aux_1390;
aux_1390 = PROCEDURE_ENTRY(hash_eq__126_419)(hash_eq__126_419, arg1106_441, key_47, BEOA);
test1091_424 = CBOOL(aux_1390);
}
}
if(test1091_424){
{
obj_t aux_1395;
{
long aux_1396;
{
long aux_1397;
{
obj_t aux_1398;
aux_1398 = STRUCT_REF(table_48, ((long)4));
aux_1397 = (long)CINT(aux_1398);
}
aux_1396 = (aux_1397-((long)1));
}
aux_1395 = BINT(aux_1396);
}
STRUCT_SET(table_48, ((long)4), aux_1395);
}
{
obj_t aux_1406;
long aux_1404;
aux_1406 = CDR(bucket_422);
aux_1404 = (long)CINT(hash_num_11_420);
VECTOR_SET(vec_421, aux_1404, aux_1406);
}
return BTRUE;
}
 else {
{
obj_t bucket_429;
{
bool_t aux_1409;
bucket_429 = bucket_422;
loop_430:
{
bool_t test1096_431;
{
obj_t arg1104_439;
{
obj_t aux_1410;
{
obj_t aux_1411;
aux_1411 = CDR(bucket_429);
aux_1410 = CAR(aux_1411);
}
arg1104_439 = PROCEDURE_ENTRY(get_key_253_418)(get_key_253_418, aux_1410, BEOA);
}
{
obj_t aux_1416;
aux_1416 = PROCEDURE_ENTRY(hash_eq__126_419)(hash_eq__126_419, arg1104_439, key_47, BEOA);
test1096_431 = CBOOL(aux_1416);
}
}
if(test1096_431){
{
obj_t aux_1421;
{
long aux_1422;
{
long aux_1423;
{
obj_t aux_1424;
aux_1424 = STRUCT_REF(table_48, ((long)4));
aux_1423 = (long)CINT(aux_1424);
}
aux_1422 = (aux_1423-((long)1));
}
aux_1421 = BINT(aux_1422);
}
STRUCT_SET(table_48, ((long)4), aux_1421);
}
{
obj_t aux_1430;
{
obj_t aux_1431;
aux_1431 = CDR(bucket_429);
aux_1430 = CDR(aux_1431);
}
SET_CDR(bucket_429, aux_1430);
}
aux_1409 = ((bool_t)1);
}
 else {
bool_t test_1435;
{
obj_t aux_1436;
aux_1436 = CDR(bucket_429);
test_1435 = NULLP(aux_1436);
}
if(test_1435){
aux_1409 = ((bool_t)0);
}
 else {
{
obj_t bucket_1439;
bucket_1439 = CDR(bucket_429);
bucket_429 = bucket_1439;
goto loop_430;
}
}
}
}
return BBOOL(aux_1409);
}
}
}
}
}
}
}
}
}
}
}


/* _rem-key-hash! */obj_t _rem_key_hash__54___hash(obj_t env_1104, obj_t key_1105, obj_t table_1106)
{
return rem_key_hash__152___hash(key_1105, table_1106);
}


/* for-each-hash */obj_t for_each_hash_105___hash(obj_t fun_49, obj_t table_50)
{
{
obj_t vec_443;
vec_443 = STRUCT_REF(table_50, ((long)6));
{
long i_444;
{
long aux_1456;
{
obj_t aux_1457;
aux_1457 = STRUCT_REF(table_50, ((long)1));
aux_1456 = (long)CINT(aux_1457);
}
i_444 = (aux_1456-((long)1));
}
loop_445:
if((i_444==((long)-1))){
return BUNSPEC;
}
 else {
{
obj_t l1002_974;
l1002_974 = VECTOR_REF(vec_443, i_444);
lname1003_973:
if(PAIRP(l1002_974)){
PROCEDURE_ENTRY(fun_49)(fun_49, CAR(l1002_974), BEOA);
{
obj_t l1002_1451;
l1002_1451 = CDR(l1002_974);
l1002_974 = l1002_1451;
goto lname1003_973;
}
}
 else {
((bool_t)1);
}
}
{
long i_1454;
i_1454 = (i_444-((long)1));
i_444 = i_1454;
goto loop_445;
}
}
}
}
}


/* _for-each-hash1263 */obj_t _for_each_hash1263_77___hash(obj_t env_1107, obj_t fun_1108, obj_t table_1109)
{
return for_each_hash_105___hash(fun_1108, table_1109);
}


/* hash-table-grows! */obj_t hash_table_grows__110___hash(obj_t table_51)
{
{
obj_t size_458;
size_458 = STRUCT_REF(table_51, ((long)1));
{
long new_size_209_459;
{
long aux_1463;
aux_1463 = (long)CINT(size_458);
new_size_209_459 = (aux_1463*((long)2));
}
{
obj_t new_table_236_460;
new_table_236_460 = make_vector(new_size_209_459, BNIL);
{
obj_t old_table_227_461;
old_table_227_461 = STRUCT_REF(table_51, ((long)6));
{
{
obj_t aux_1468;
aux_1468 = BINT(new_size_209_459);
STRUCT_SET(table_51, ((long)1), aux_1468);
}
STRUCT_SET(table_51, ((long)6), new_table_236_460);
{
obj_t aux_1472;
aux_1472 = BINT(((long)0));
STRUCT_SET(table_51, ((long)4), aux_1472);
}
{
long i_462;
i_462 = ((long)0);
loop_463:
{
bool_t test_1475;
{
long aux_1476;
aux_1476 = (long)CINT(size_458);
test_1475 = (i_462==aux_1476);
}
if(test_1475){
return symbol1276___hash;
}
 else {
{
obj_t l1004_1031;
l1004_1031 = VECTOR_REF(old_table_227_461, i_462);
lname1005_1030:
if(PAIRP(l1004_1031)){
put_hash__129___hash(CAR(l1004_1031), table_51);
{
obj_t l1004_1483;
l1004_1483 = CDR(l1004_1031);
l1004_1031 = l1004_1483;
goto lname1005_1030;
}
}
 else {
((bool_t)1);
}
}
{
long i_1486;
i_1486 = (i_462+((long)1));
i_462 = i_1486;
goto loop_463;
}
}
}
}
}
}
}
}
}
}


/* string->0..255 */long string__0__255_119___hash(char * string_52)
{
return get_hash_number(string_52);
}


/* _string->0..2551264 */obj_t _string__0__2551264_239___hash(obj_t env_1110, obj_t string_1111)
{
{
long aux_1489;
{
char * string_1126;
string_1126 = BSTRING_TO_STRING(string_1111);
aux_1489 = get_hash_number(string_1126);
}
return BINT(aux_1489);
}
}


/* string->0..2^x-1 */long string__0__2_x_1_163___hash(char * string_53, long power_54)
{
return get_hash_power_number(string_53, power_54);
}


/* _string->0..2^x-11265 */obj_t _string__0__2_x_11265_76___hash(obj_t env_1112, obj_t string_1113, obj_t power_1114)
{
{
long aux_1494;
{
char * string_1127;
long power_1128;
string_1127 = BSTRING_TO_STRING(string_1113);
power_1128 = (long)CINT(power_1114);
aux_1494 = get_hash_power_number(string_1127, power_1128);
}
return BINT(aux_1494);
}
}


/* int->0..255 */long int__0__255_26___hash(long int_55)
{
return get_hash_number_from_int(int_55);
}


/* _int->0..2551266 */obj_t _int__0__2551266_172___hash(obj_t env_1115, obj_t int_1116)
{
{
long aux_1500;
{
long int_184_1129;
int_184_1129 = (long)CINT(int_1116);
aux_1500 = get_hash_number_from_int(int_184_1129);
}
return BINT(aux_1500);
}
}


/* int->0..2^x-1 */long int__0__2_x_1_11___hash(long int_56, long power_57)
{
return get_hash_power_number_from_int(int_56, power_57);
}


/* _int->0..2^x-11267 */obj_t _int__0__2_x_11267_224___hash(obj_t env_1117, obj_t int_1118, obj_t power_1119)
{
{
long aux_1505;
{
long int_184_1130;
long power_1131;
int_184_1130 = (long)CINT(int_1118);
power_1131 = (long)CINT(power_1119);
aux_1505 = get_hash_power_number_from_int(int_184_1130, power_1131);
}
return BINT(aux_1505);
}
}


/* obj->0..255 */long obj__0__255_3___hash(obj_t obj_58)
{
if(STRINGP(obj_58)){
{
char * aux_1512;
aux_1512 = BSTRING_TO_STRING(obj_58);
return get_hash_number(aux_1512);
}
}
 else {
if(SYMBOLP(obj_58)){
{
obj_t arg1124_475;
arg1124_475 = SYMBOL_TO_STRING(obj_58);
{
char * aux_1518;
aux_1518 = BSTRING_TO_STRING(arg1124_475);
return get_hash_number(aux_1518);
}
}
}
 else {
if(INTEGERP(obj_58)){
{
long aux_1523;
aux_1523 = (long)CINT(obj_58);
return get_hash_number_from_int(aux_1523);
}
}
 else {
if(CHARP(obj_58)){
{
unsigned char aux_1528;
aux_1528 = (unsigned char)CCHAR(obj_58);
return (aux_1528);
}
}
 else {
return get_hash_number_from_int(obj_58);
}
}
}
}
}


/* _obj->0..255 */obj_t _obj__0__255_117___hash(obj_t env_1120, obj_t obj_1121)
{
{
long aux_1532;
aux_1532 = obj__0__255_3___hash(obj_1121);
return BINT(aux_1532);
}
}


/* obj->0..2^x-1 */long obj__0__2_x_1_138___hash(obj_t obj_59, long power_60)
{
if(STRINGP(obj_59)){
{
char * aux_1537;
aux_1537 = BSTRING_TO_STRING(obj_59);
return get_hash_power_number(aux_1537, power_60);
}
}
 else {
if(SYMBOLP(obj_59)){
{
obj_t arg1129_480;
arg1129_480 = SYMBOL_TO_STRING(obj_59);
{
char * aux_1543;
aux_1543 = BSTRING_TO_STRING(arg1129_480);
return get_hash_power_number(aux_1543, power_60);
}
}
}
 else {
if(INTEGERP(obj_59)){
{
long aux_1548;
aux_1548 = (long)CINT(obj_59);
return get_hash_power_number_from_int(aux_1548, power_60);
}
}
 else {
if(CHARP(obj_59)){
{
unsigned char aux_1553;
aux_1553 = (unsigned char)CCHAR(obj_59);
return (aux_1553);
}
}
 else {
return get_hash_power_number_from_int(obj_59, power_60);
}
}
}
}
}


/* _obj->0..2^x-11268 */obj_t _obj__0__2_x_11268_190___hash(obj_t env_1122, obj_t obj_1123, obj_t power_1124)
{
{
long aux_1557;
aux_1557 = obj__0__2_x_1_138___hash(obj_1123, (long)CINT(power_1124));
return BINT(aux_1557);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___hash()
{
return module_initialization_70___error(((long)0), "__HASH");
}

