/*===========================================================================*/
/*   (Llib/bit.scm)                                                          */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _bit_not1128_118___bit(obj_t, obj_t);
extern long bit_not_211___bit(long);
extern long bit_or_153___bit(long, long);
static obj_t _bit_or1125_104___bit(obj_t, obj_t, obj_t);
static obj_t _bit_lsh1131_145___bit(obj_t, obj_t, obj_t);
extern long bit_lsh_5___bit(long, long);
static obj_t _bit_rsh1129_227___bit(obj_t, obj_t, obj_t);
static obj_t _bit_ursh1130_229___bit(obj_t, obj_t, obj_t);
extern unsigned long bit_ursh_31___bit(unsigned long, unsigned long);
static obj_t _bit_xor1127_195___bit(obj_t, obj_t, obj_t);
static obj_t _bit_and1126_225___bit(obj_t, obj_t, obj_t);
extern obj_t module_initialization_70___bit(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern long bit_and_249___bit(long, long);
extern long bit_xor_189___bit(long, long);
static obj_t imported_modules_init_94___bit();
static obj_t require_initialization_114___bit = BUNSPEC;
extern long bit_rsh_14___bit(long, long);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( bit_ursh_env_99___bit, _bit_ursh1130_229___bit1133, _bit_ursh1130_229___bit, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( bit_xor_env_214___bit, _bit_xor1127_195___bit1134, _bit_xor1127_195___bit, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( bit_and_env_215___bit, _bit_and1126_225___bit1135, _bit_and1126_225___bit, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( bit_not_env_219___bit, _bit_not1128_118___bit1136, _bit_not1128_118___bit, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( bit_lsh_env_185___bit, _bit_lsh1131_145___bit1137, _bit_lsh1131_145___bit, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( bit_rsh_env_225___bit, _bit_rsh1129_227___bit1138, _bit_rsh1129_227___bit, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( bit_or_env_216___bit, _bit_or1125_104___bit1139, _bit_or1125_104___bit, 0L, 2 );


/* module-initialization */obj_t module_initialization_70___bit(long checksum_374, char * from_375)
{
if(CBOOL(require_initialization_114___bit)){
require_initialization_114___bit = BBOOL(((bool_t)0));
imported_modules_init_94___bit();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* bit-or */long bit_or_153___bit(long x_1, long y_2)
{
return (x_1 | y_2);
}


/* _bit-or1125 */obj_t _bit_or1125_104___bit(obj_t env_341, obj_t x_342, obj_t y_343)
{
{
long aux_381;
{
long x_361;
long y_362;
x_361 = (long)CINT(x_342);
y_362 = (long)CINT(y_343);
aux_381 = (x_361 | y_362);
}
return BINT(aux_381);
}
}


/* bit-and */long bit_and_249___bit(long x_3, long y_4)
{
return (x_3 & y_4);
}


/* _bit-and1126 */obj_t _bit_and1126_225___bit(obj_t env_344, obj_t x_345, obj_t y_346)
{
{
long aux_387;
{
long x_363;
long y_364;
x_363 = (long)CINT(x_345);
y_364 = (long)CINT(y_346);
aux_387 = (x_363 & y_364);
}
return BINT(aux_387);
}
}


/* bit-xor */long bit_xor_189___bit(long x_5, long y_6)
{
return (x_5 ^ y_6);
}


/* _bit-xor1127 */obj_t _bit_xor1127_195___bit(obj_t env_347, obj_t x_348, obj_t y_349)
{
{
long aux_393;
{
long x_365;
long y_366;
x_365 = (long)CINT(x_348);
y_366 = (long)CINT(y_349);
aux_393 = (x_365 ^ y_366);
}
return BINT(aux_393);
}
}


/* bit-not */long bit_not_211___bit(long x_7)
{
return ~(x_7);
}


/* _bit-not1128 */obj_t _bit_not1128_118___bit(obj_t env_350, obj_t x_351)
{
{
long aux_399;
{
long x_367;
x_367 = (long)CINT(x_351);
aux_399 = ~(x_367);
}
return BINT(aux_399);
}
}


/* bit-rsh */long bit_rsh_14___bit(long x_8, long y_9)
{
return (x_8 >> y_9);
}


/* _bit-rsh1129 */obj_t _bit_rsh1129_227___bit(obj_t env_352, obj_t x_353, obj_t y_354)
{
{
long aux_404;
{
long x_368;
long y_369;
x_368 = (long)CINT(x_353);
y_369 = (long)CINT(y_354);
aux_404 = (x_368 >> y_369);
}
return BINT(aux_404);
}
}


/* bit-ursh */unsigned long bit_ursh_31___bit(unsigned long x_10, unsigned long y_11)
{
return (x_10 >> y_11);
}


/* _bit-ursh1130 */obj_t _bit_ursh1130_229___bit(obj_t env_355, obj_t x_356, obj_t y_357)
{
{
unsigned long aux_410;
{
unsigned long x_370;
unsigned long y_371;
x_370 = (unsigned long)CINT(x_356);
y_371 = (unsigned long)CINT(y_357);
aux_410 = (x_370 >> y_371);
}
return BINT(aux_410);
}
}


/* bit-lsh */long bit_lsh_5___bit(long x_12, long y_13)
{
return (x_12 << y_13);
}


/* _bit-lsh1131 */obj_t _bit_lsh1131_145___bit(obj_t env_358, obj_t x_359, obj_t y_360)
{
{
long aux_416;
{
long x_372;
long y_373;
x_372 = (long)CINT(x_359);
y_373 = (long)CINT(y_360);
aux_416 = (x_372 << y_373);
}
return BINT(aux_416);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___bit()
{
return module_initialization_70___error(((long)0), "__BIT");
}

