/*===========================================================================*/
/*   (Ieee/vector.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _vector_set_1126_135___r4_vectors_6_8(obj_t, obj_t, obj_t, obj_t);
extern obj_t vector_fill__80___r4_vectors_6_8(obj_t, obj_t);
extern obj_t vector_ref_ur_84___r4_vectors_6_8(obj_t, long);
extern long vector_tag_145___r4_vectors_6_8(obj_t);
static obj_t _vector_fill_1130_217___r4_vectors_6_8(obj_t, obj_t, obj_t);
extern obj_t module_initialization_70___r4_vectors_6_8(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _vector_tag1131_142___r4_vectors_6_8(obj_t, obj_t);
extern obj_t vector_ref_121___r4_vectors_6_8(obj_t, long);
extern bool_t vector__172___r4_vectors_6_8(obj_t);
extern obj_t vector__list_155___r4_vectors_6_8(obj_t);
extern long vector_length_150___r4_vectors_6_8(obj_t);
static obj_t _vector_set_ur_1128_48___r4_vectors_6_8(obj_t, obj_t, obj_t, obj_t);
extern long list_length(obj_t);
static obj_t _vector__list1129_81___r4_vectors_6_8(obj_t, obj_t);
static obj_t _vector_tag_set_1132_207___r4_vectors_6_8(obj_t, obj_t, obj_t);
extern obj_t list__vector_101___r4_vectors_6_8(obj_t);
extern obj_t vector___r4_vectors_6_8(obj_t);
static obj_t _list__vector_50___r4_vectors_6_8(obj_t, obj_t);
extern obj_t fill_vector(obj_t, long, obj_t);
static obj_t _vector_ref_ur1127_201___r4_vectors_6_8(obj_t, obj_t, obj_t);
extern obj_t vector_set_ur__74___r4_vectors_6_8(obj_t, long, obj_t);
static obj_t _make_vector1123_12___r4_vectors_6_8(obj_t, obj_t, obj_t);
extern obj_t vector_set__141___r4_vectors_6_8(obj_t, long, obj_t);
static obj_t imported_modules_init_94___r4_vectors_6_8();
static obj_t _vector__62___r4_vectors_6_8(obj_t, obj_t);
static obj_t _vector_length1124_95___r4_vectors_6_8(obj_t, obj_t);
extern obj_t make_vector_110___r4_vectors_6_8(long, obj_t);
static obj_t require_initialization_114___r4_vectors_6_8 = BUNSPEC;
static obj_t _vector_ref1125_112___r4_vectors_6_8(obj_t, obj_t, obj_t);
extern obj_t vector_tag_set__158___r4_vectors_6_8(obj_t, long);
extern obj_t make_vector(long, obj_t);
static obj_t _vector___r4_vectors_6_8(obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( vector_env_233___r4_vectors_6_8, _vector___r4_vectors_6_81137, va_generic_entry, _vector___r4_vectors_6_8, -1 );
DEFINE_EXPORT_PROCEDURE( vector_set__env_232___r4_vectors_6_8, _vector_set_1126_135___r4_vectors_6_81138, _vector_set_1126_135___r4_vectors_6_8, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( list__vector_env_25___r4_vectors_6_8, _list__vector_50___r4_vectors_6_81139, _list__vector_50___r4_vectors_6_8, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_set_ur__env_52___r4_vectors_6_8, _vector_set_ur_1128_48___r4_vectors_6_81140, _vector_set_ur_1128_48___r4_vectors_6_8, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( vector__env_224___r4_vectors_6_8, _vector__62___r4_vectors_6_81141, _vector__62___r4_vectors_6_8, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_tag_set__env_48___r4_vectors_6_8, _vector_tag_set_1132_207___r4_vectors_6_81142, _vector_tag_set_1132_207___r4_vectors_6_8, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( vector_fill__env_134___r4_vectors_6_8, _vector_fill_1130_217___r4_vectors_6_81143, _vector_fill_1130_217___r4_vectors_6_8, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( vector_ref_env_100___r4_vectors_6_8, _vector_ref1125_112___r4_vectors_6_81144, _vector_ref1125_112___r4_vectors_6_8, 0L, 2 );
DEFINE_STRING( string1135___r4_vectors_6_8, string1135___r4_vectors_6_81145, "vector-set!", 11 );
DEFINE_STRING( string1134___r4_vectors_6_8, string1134___r4_vectors_6_81146, "index out of range", 18 );
DEFINE_STRING( string1133___r4_vectors_6_8, string1133___r4_vectors_6_81147, "vector-ref", 10 );
DEFINE_EXPORT_PROCEDURE( make_vector_env_128___r4_vectors_6_8, _make_vector1123_12___r4_vectors_6_81148, va_generic_entry, _make_vector1123_12___r4_vectors_6_8, -2 );
DEFINE_EXPORT_PROCEDURE( vector_ref_ur_env_72___r4_vectors_6_8, _vector_ref_ur1127_201___r4_vectors_6_81149, _vector_ref_ur1127_201___r4_vectors_6_8, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( vector_tag_env_1___r4_vectors_6_8, _vector_tag1131_142___r4_vectors_6_81150, _vector_tag1131_142___r4_vectors_6_8, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector__list_env_228___r4_vectors_6_8, _vector__list1129_81___r4_vectors_6_81151, _vector__list1129_81___r4_vectors_6_8, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_length_env_9___r4_vectors_6_8, _vector_length1124_95___r4_vectors_6_81152, _vector_length1124_95___r4_vectors_6_8, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___r4_vectors_6_8(long checksum_494, char * from_495)
{
if(CBOOL(require_initialization_114___r4_vectors_6_8)){
require_initialization_114___r4_vectors_6_8 = BBOOL(((bool_t)0));
imported_modules_init_94___r4_vectors_6_8();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* vector? */bool_t vector__172___r4_vectors_6_8(obj_t obj_1)
{
return VECTORP(obj_1);
}


/* _vector? */obj_t _vector__62___r4_vectors_6_8(obj_t env_437, obj_t obj_438)
{
{
bool_t aux_501;
{
obj_t obj_472;
obj_472 = obj_438;
aux_501 = VECTORP(obj_472);
}
return BBOOL(aux_501);
}
}


/* make-vector */obj_t make_vector_110___r4_vectors_6_8(long int_2, obj_t fill_3)
{
if(NULLP(fill_3)){
return make_vector(int_2, BUNSPEC);
}
 else {
obj_t aux_507;
aux_507 = CAR(fill_3);
return make_vector(int_2, aux_507);
}
}


/* _make-vector1123 */obj_t _make_vector1123_12___r4_vectors_6_8(obj_t env_439, obj_t int_440, obj_t fill_441)
{
{
long int_184_473;
obj_t fill_474;
int_184_473 = (long)CINT(int_440);
fill_474 = fill_441;
if(NULLP(fill_474)){
return make_vector(int_184_473, BUNSPEC);
}
 else {
obj_t aux_514;
aux_514 = CAR(fill_474);
return make_vector(int_184_473, aux_514);
}
}
}


/* vector */obj_t vector___r4_vectors_6_8(obj_t args_4)
{
return list__vector_101___r4_vectors_6_8(args_4);
}


/* _vector */obj_t _vector___r4_vectors_6_8(obj_t env_442, obj_t args_443)
{
{
obj_t args_475;
args_475 = args_443;
return list__vector_101___r4_vectors_6_8(args_475);
}
}


/* vector-length */long vector_length_150___r4_vectors_6_8(obj_t vector_5)
{
return VECTOR_LENGTH(vector_5);
}


/* _vector-length1124 */obj_t _vector_length1124_95___r4_vectors_6_8(obj_t env_444, obj_t vector_445)
{
{
long aux_520;
{
obj_t vector_476;
vector_476 = vector_445;
aux_520 = VECTOR_LENGTH(vector_476);
}
return BINT(aux_520);
}
}


/* vector-ref */obj_t vector_ref_121___r4_vectors_6_8(obj_t vector_6, long k_7)
{
{
bool_t test1004_477;
{
long aux_523;
aux_523 = VECTOR_LENGTH(vector_6);
test1004_477 = BOUND_CHECK(k_7, aux_523);
}
if(test1004_477){
return VECTOR_REF(vector_6, k_7);
}
 else {
FAILURE(string1133___r4_vectors_6_8,string1134___r4_vectors_6_8,BINT(k_7));}
}
}


/* _vector-ref1125 */obj_t _vector_ref1125_112___r4_vectors_6_8(obj_t env_446, obj_t vector_447, obj_t k_448)
{
{
obj_t vector_478;
long k_479;
vector_478 = vector_447;
k_479 = (long)CINT(k_448);
{
bool_t test1004_480;
{
long aux_531;
aux_531 = VECTOR_LENGTH(vector_478);
test1004_480 = BOUND_CHECK(k_479, aux_531);
}
if(test1004_480){
return VECTOR_REF(vector_478, k_479);
}
 else {
FAILURE(string1133___r4_vectors_6_8,string1134___r4_vectors_6_8,BINT(k_479));}
}
}
}


/* vector-set! */obj_t vector_set__141___r4_vectors_6_8(obj_t vector_8, long k_9, obj_t obj_10)
{
{
bool_t test1006_481;
{
long aux_538;
aux_538 = VECTOR_LENGTH(vector_8);
test1006_481 = BOUND_CHECK(k_9, aux_538);
}
if(test1006_481){
return VECTOR_SET(vector_8, k_9, obj_10);
}
 else {
FAILURE(string1135___r4_vectors_6_8,string1134___r4_vectors_6_8,BINT(k_9));}
}
}


/* _vector-set!1126 */obj_t _vector_set_1126_135___r4_vectors_6_8(obj_t env_449, obj_t vector_450, obj_t k_451, obj_t obj_452)
{
{
obj_t vector_482;
long k_483;
obj_t obj_484;
vector_482 = vector_450;
k_483 = (long)CINT(k_451);
obj_484 = obj_452;
{
bool_t test1006_485;
{
long aux_546;
aux_546 = VECTOR_LENGTH(vector_482);
test1006_485 = BOUND_CHECK(k_483, aux_546);
}
if(test1006_485){
return VECTOR_SET(vector_482, k_483, obj_484);
}
 else {
FAILURE(string1135___r4_vectors_6_8,string1134___r4_vectors_6_8,BINT(k_483));}
}
}
}


/* vector-ref-ur */obj_t vector_ref_ur_84___r4_vectors_6_8(obj_t vector_11, long k_12)
{
return VECTOR_REF(vector_11, k_12);
}


/* _vector-ref-ur1127 */obj_t _vector_ref_ur1127_201___r4_vectors_6_8(obj_t env_453, obj_t vector_454, obj_t k_455)
{
{
obj_t vector_486;
long k_487;
vector_486 = vector_454;
k_487 = (long)CINT(k_455);
return VECTOR_REF(vector_486, k_487);
}
}


/* vector-set-ur! */obj_t vector_set_ur__74___r4_vectors_6_8(obj_t vector_13, long k_14, obj_t obj_15)
{
return VECTOR_SET(vector_13, k_14, obj_15);
}


/* _vector-set-ur!1128 */obj_t _vector_set_ur_1128_48___r4_vectors_6_8(obj_t env_456, obj_t vector_457, obj_t k_458, obj_t obj_459)
{
{
obj_t vector_488;
long k_489;
obj_t obj_490;
vector_488 = vector_457;
k_489 = (long)CINT(k_458);
obj_490 = obj_459;
return VECTOR_SET(vector_488, k_489, obj_490);
}
}


/* vector->list */obj_t vector__list_155___r4_vectors_6_8(obj_t vector_16)
{
{
long vlen_188;
vlen_188 = VECTOR_LENGTH(vector_16);
if((vlen_188==((long)0))){
return BNIL;
}
 else {
long i_327;
obj_t acc_328;
i_327 = (vlen_188-((long)1));
acc_328 = BNIL;
loop_326:
if((i_327==((long)0))){
obj_t aux_564;
aux_564 = VECTOR_REF(vector_16, i_327);
return MAKE_PAIR(aux_564, acc_328);
}
 else {
long arg1013_336;
obj_t arg1014_337;
arg1013_336 = (i_327-((long)1));
{
obj_t aux_568;
aux_568 = VECTOR_REF(vector_16, i_327);
arg1014_337 = MAKE_PAIR(aux_568, acc_328);
}
{
obj_t acc_572;
long i_571;
i_571 = arg1013_336;
acc_572 = arg1014_337;
acc_328 = acc_572;
i_327 = i_571;
goto loop_326;
}
}
}
}
}


/* _vector->list1129 */obj_t _vector__list1129_81___r4_vectors_6_8(obj_t env_460, obj_t vector_461)
{
return vector__list_155___r4_vectors_6_8(vector_461);
}


/* list->vector */obj_t list__vector_101___r4_vectors_6_8(obj_t list_17)
{
{
long len_200;
len_200 = list_length(list_17);
{
obj_t vec_201;
vec_201 = make_vector(len_200, BNIL);
{
{
long i_388;
obj_t l_389;
i_388 = ((long)0);
l_389 = list_17;
loop_387:
if((i_388==len_200)){
return vec_201;
}
 else {
{
obj_t aux_579;
aux_579 = CAR(l_389);
VECTOR_SET(vec_201, i_388, aux_579);
}
{
obj_t l_584;
long i_582;
i_582 = (i_388+((long)1));
l_584 = CDR(l_389);
l_389 = l_584;
i_388 = i_582;
goto loop_387;
}
}
}
}
}
}
}


/* _list->vector */obj_t _list__vector_50___r4_vectors_6_8(obj_t env_462, obj_t list_463)
{
return list__vector_101___r4_vectors_6_8(list_463);
}


/* vector-fill! */obj_t vector_fill__80___r4_vectors_6_8(obj_t vector_18, obj_t fill_19)
{
{
long aux_587;
aux_587 = VECTOR_LENGTH(vector_18);
return fill_vector(vector_18, aux_587, fill_19);
}
}


/* _vector-fill!1130 */obj_t _vector_fill_1130_217___r4_vectors_6_8(obj_t env_464, obj_t vector_465, obj_t fill_466)
{
return vector_fill__80___r4_vectors_6_8(vector_465, fill_466);
}


/* vector-tag */long vector_tag_145___r4_vectors_6_8(obj_t vector_20)
{
return VECTOR_TAG(vector_20);
}


/* _vector-tag1131 */obj_t _vector_tag1131_142___r4_vectors_6_8(obj_t env_467, obj_t vector_468)
{
{
long aux_592;
{
obj_t vector_491;
vector_491 = vector_468;
aux_592 = VECTOR_TAG(vector_491);
}
return BINT(aux_592);
}
}


/* vector-tag-set! */obj_t vector_tag_set__158___r4_vectors_6_8(obj_t vector_21, long tag_22)
{
return VECTOR_TAG_SET(vector_21, tag_22);
}


/* _vector-tag-set!1132 */obj_t _vector_tag_set_1132_207___r4_vectors_6_8(obj_t env_469, obj_t vector_470, obj_t tag_471)
{
{
obj_t vector_492;
long tag_493;
vector_492 = vector_470;
tag_493 = (long)CINT(tag_471);
return VECTOR_TAG_SET(vector_492, tag_493);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___r4_vectors_6_8()
{
return module_initialization_70___error(((long)0), "__R4_VECTORS_6_8");
}

