/*===========================================================================*/
/*   (Ieee/string.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

extern bool_t bigloo_strncmp_ci(obj_t, obj_t, long);
extern bool_t bigloo_strcmp(obj_t, obj_t);
static obj_t _string_ref_ur1201_187___r4_strings_6_7(obj_t, obj_t, obj_t);
extern bool_t string__76___r4_strings_6_7(obj_t);
static obj_t _blit_string_1228_254___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern bool_t substring___218___r4_strings_6_7(obj_t, obj_t, long);
extern obj_t string_set__176___r4_strings_6_7(obj_t, long, unsigned char);
extern obj_t string_append(obj_t, obj_t);
extern bool_t bigloo_strncmp(obj_t, obj_t, long);
extern bool_t string____135___r4_strings_6_7(obj_t, obj_t);
extern obj_t blit_string_ur__74___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t substring_ur_202___r4_strings_6_7(obj_t, long, long);
static obj_t _string_capitalize_1224_194___r4_strings_6_7(obj_t, obj_t);
static obj_t _string___1209_197___r4_strings_6_7(obj_t, obj_t, obj_t);
extern bool_t string____33___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_fill__51___r4_strings_6_7(obj_t, unsigned char);
static obj_t _string___1210_254___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_downcase_1223_130___r4_strings_6_7(obj_t, obj_t);
extern obj_t list__string_78___r4_strings_6_7(obj_t);
static obj_t _string_upcase1220_173___r4_strings_6_7(obj_t, obj_t);
static obj_t _substring_ur1216_185___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern obj_t string___r4_strings_6_7(obj_t);
static obj_t _string_for_read1226_232___r4_strings_6_7(obj_t, obj_t);
static obj_t _substring1215___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
static obj_t _string_ci__1211_16___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_copy_207___r4_strings_6_7(obj_t);
extern unsigned char string_ref_ur_85___r4_strings_6_7(obj_t, long);
static obj_t loop___r4_strings_6_7(obj_t);
extern obj_t make_string_124___r4_strings_6_7(int, obj_t);
static obj_t _string__1207_24___r4_strings_6_7(obj_t, obj_t, obj_t);
extern bool_t string_cilt(obj_t, obj_t);
extern obj_t string_for_read_25___r4_strings_6_7(obj_t);
extern bool_t string_cile(obj_t, obj_t);
static obj_t _string_copy1218_52___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_to_bstring(char *);
extern bool_t string_cigt(obj_t, obj_t);
extern bool_t string_ci____43___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_cige(obj_t, obj_t);
extern bool_t substring_ci___99___r4_strings_6_7(obj_t, obj_t, long);
static obj_t _string_capitalize1225_247___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_set_ur__94___r4_strings_6_7(obj_t, long, unsigned char);
static obj_t _string_upcase_1222_36___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_capitalize__136___r4_strings_6_7(obj_t);
extern obj_t make_string(long, unsigned char);
static obj_t _string___r4_strings_6_7(obj_t, obj_t);
static obj_t _string_set_1200_24___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
static obj_t _string_ci__1206_184___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_ci___1213_213___r4_strings_6_7(obj_t, obj_t, obj_t);
extern long string_length_125___r4_strings_6_7(obj_t);
extern obj_t module_initialization_70___r4_strings_6_7(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _string_ref1199_50___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_ci___1214_7___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_fill_1219_167___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t c_substring(obj_t, long, long);
extern bool_t string_ci____210___r4_strings_6_7(obj_t, obj_t);
static obj_t _string_length1198_172___r4_strings_6_7(obj_t, obj_t);
extern bool_t string___248___r4_strings_6_7(obj_t, obj_t);
static obj_t _substring__1204_78___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern bool_t string___146___r4_strings_6_7(obj_t, obj_t);
extern bool_t string___83___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_capitalize_230___r4_strings_6_7(obj_t);
static obj_t _string__1203_124___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_set_ur_1202_12___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern bool_t strcicmp(obj_t, obj_t);
extern obj_t substring___r4_strings_6_7(obj_t, long, long);
static obj_t _make_string1197_224___r4_strings_6_7(obj_t, obj_t, obj_t);
extern long list_length(obj_t);
static obj_t _string_ci__1212_68___r4_strings_6_7(obj_t, obj_t, obj_t);
extern bool_t string_ci___60___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_ci___247___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_ci___92___r4_strings_6_7(obj_t, obj_t);
static obj_t _string__list1217_17___r4_strings_6_7(obj_t, obj_t);
static obj_t _string__1208_166___r4_strings_6_7(obj_t, obj_t, obj_t);
extern bool_t string_lt(obj_t, obj_t);
static obj_t _substring_ci__1205_28___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern bool_t string_le(obj_t, obj_t);
static obj_t _string__159___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_gt(obj_t, obj_t);
extern bool_t string_ge(obj_t, obj_t);
extern obj_t string_upcase__158___r4_strings_6_7(obj_t);
static obj_t _list__string_5___r4_strings_6_7(obj_t, obj_t);
static obj_t imported_modules_init_94___r4_strings_6_7();
extern obj_t string_append_106___r4_strings_6_7(obj_t);
extern obj_t string_downcase_77___r4_strings_6_7(obj_t);
static obj_t require_initialization_114___r4_strings_6_7 = BUNSPEC;
extern obj_t string__list_125___r4_strings_6_7(obj_t);
extern obj_t string_downcase__42___r4_strings_6_7(obj_t);
static obj_t _string_append_156___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_for_read(obj_t);
extern unsigned char string_ref_239___r4_strings_6_7(obj_t, long);
static obj_t _string_downcase1221_78___r4_strings_6_7(obj_t, obj_t);
extern obj_t blit_string__141___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t blit_string(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t _blit_string_ur_1227_132___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t string_upcase_71___r4_strings_6_7(obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( string_downcase_env_169___r4_strings_6_7, _string_downcase1221_78___r4_strings_6_71238, _string_downcase1221_78___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_upcase__env_48___r4_strings_6_7, _string_upcase_1222_36___r4_strings_6_71239, _string_upcase_1222_36___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( blit_string_ur__env_52___r4_strings_6_7, _blit_string_ur_1227_132___r4_strings_6_71240, _blit_string_ur_1227_132___r4_strings_6_7, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( substring_ur_env_69___r4_strings_6_7, _substring_ur1216_185___r4_strings_6_71241, _substring_ur1216_185___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_set_ur__env_0___r4_strings_6_7, _string_set_ur_1202_12___r4_strings_6_71242, _string_set_ur_1202_12___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_length_env_217___r4_strings_6_7, _string_length1198_172___r4_strings_6_71243, _string_length1198_172___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( substring_ci___env_184___r4_strings_6_7, _substring_ci__1205_28___r4_strings_6_71244, _substring_ci__1205_28___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_ci____env_38___r4_strings_6_7, _string_ci___1213_213___r4_strings_6_71245, _string_ci___1213_213___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci____env_37___r4_strings_6_7, _string_ci___1214_7___r4_strings_6_71246, _string_ci___1214_7___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_fill__env_181___r4_strings_6_7, _string_fill_1219_167___r4_strings_6_71247, _string_fill_1219_167___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_downcase__env_73___r4_strings_6_7, _string_downcase_1223_130___r4_strings_6_71248, _string_downcase_1223_130___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_for_read_env_47___r4_strings_6_7, _string_for_read1226_232___r4_strings_6_71249, _string_for_read1226_232___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_env_246___r4_strings_6_7, _string___r4_strings_6_71250, va_generic_entry, _string___r4_strings_6_7, -1 );
DEFINE_EXPORT_PROCEDURE( string___env_245___r4_strings_6_7, _string__1207_24___r4_strings_6_71251, _string__1207_24___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( list__string_env_249___r4_strings_6_7, _list__string_5___r4_strings_6_71252, _list__string_5___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_env_251___r4_strings_6_7, _string_ref1199_50___r4_strings_6_71253, _string_ref1199_50___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_29___r4_strings_6_7, _string_ci__1211_16___r4_strings_6_71254, _string_ci__1211_16___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__list_env_217___r4_strings_6_7, _string__list1217_17___r4_strings_6_71255, _string__list1217_17___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_copy_env_8___r4_strings_6_7, _string_copy1218_52___r4_strings_6_71256, _string_copy1218_52___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string___env_211___r4_strings_6_7, _string__1203_124___r4_strings_6_71257, _string__1203_124___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_set__env_239___r4_strings_6_7, _string_set_1200_24___r4_strings_6_71258, _string_set_1200_24___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_ref_ur_env_171___r4_strings_6_7, _string_ref_ur1201_187___r4_strings_6_71259, _string_ref_ur1201_187___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_62___r4_strings_6_7, _string_ci__1206_184___r4_strings_6_71260, _string_ci__1206_184___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( substring___env_12___r4_strings_6_7, _substring__1204_78___r4_strings_6_71261, _substring__1204_78___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string____env_63___r4_strings_6_7, _string___1209_197___r4_strings_6_71262, _string___1209_197___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string____env_18___r4_strings_6_7, _string___1210_254___r4_strings_6_71263, _string___1210_254___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string___env_124___r4_strings_6_7, _string__1208_166___r4_strings_6_71264, _string__1208_166___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( make_string_env_55___r4_strings_6_7, _make_string1197_224___r4_strings_6_71265, va_generic_entry, _make_string1197_224___r4_strings_6_7, -2 );
DEFINE_EXPORT_PROCEDURE( string_capitalize__env_137___r4_strings_6_7, _string_capitalize_1224_194___r4_strings_6_71266, _string_capitalize_1224_194___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_46___r4_strings_6_7, _string_ci__1212_68___r4_strings_6_71267, _string_ci__1212_68___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_capitalize_env_253___r4_strings_6_7, _string_capitalize1225_247___r4_strings_6_71268, _string_capitalize1225_247___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( substring_env_248___r4_strings_6_7, _substring1215___r4_strings_6_71269, _substring1215___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( blit_string__env_232___r4_strings_6_7, _blit_string_1228_254___r4_strings_6_71270, _blit_string_1228_254___r4_strings_6_7, 0L, 5 );
DEFINE_STRING( string1236___r4_strings_6_7, string1236___r4_strings_6_71271, "Index and length out of range", 29 );
DEFINE_STRING( string1235___r4_strings_6_7, string1235___r4_strings_6_71272, "blit-string!", 12 );
DEFINE_STRING( string1234___r4_strings_6_7, string1234___r4_strings_6_71273, "", 0 );
DEFINE_STRING( string1233___r4_strings_6_7, string1233___r4_strings_6_71274, "Illegal index", 13 );
DEFINE_STRING( string1232___r4_strings_6_7, string1232___r4_strings_6_71275, "substring", 9 );
DEFINE_STRING( string1231___r4_strings_6_7, string1231___r4_strings_6_71276, "string-set!", 11 );
DEFINE_STRING( string1229___r4_strings_6_7, string1229___r4_strings_6_71277, "string-ref", 10 );
DEFINE_STRING( string1230___r4_strings_6_7, string1230___r4_strings_6_71278, "index out of range", 18 );
DEFINE_EXPORT_PROCEDURE( string_append_env_17___r4_strings_6_7, _string_append_156___r4_strings_6_71279, va_generic_entry, _string_append_156___r4_strings_6_7, -1 );
DEFINE_EXPORT_PROCEDURE( string_upcase_env_136___r4_strings_6_7, _string_upcase1220_173___r4_strings_6_71280, _string_upcase1220_173___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string__env_22___r4_strings_6_7, _string__159___r4_strings_6_71281, _string__159___r4_strings_6_7, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___r4_strings_6_7(long checksum_902, char * from_903)
{
if(CBOOL(require_initialization_114___r4_strings_6_7)){
require_initialization_114___r4_strings_6_7 = BBOOL(((bool_t)0));
imported_modules_init_94___r4_strings_6_7();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* string? */bool_t string__76___r4_strings_6_7(obj_t obj_1)
{
return STRINGP(obj_1);
}


/* _string? */obj_t _string__159___r4_strings_6_7(obj_t env_740, obj_t obj_741)
{
{
bool_t aux_909;
{
obj_t obj_846;
obj_846 = obj_741;
aux_909 = STRINGP(obj_846);
}
return BBOOL(aux_909);
}
}


/* make-string */obj_t make_string_124___r4_strings_6_7(int k_2, obj_t char_3)
{
if(NULLP(char_3)){
long aux_914;
aux_914 = (long)(k_2);
return make_string(aux_914, ((unsigned char)' '));
}
 else {
unsigned char aux_919;
long aux_917;
{
obj_t aux_920;
aux_920 = CAR(char_3);
aux_919 = (unsigned char)CCHAR(aux_920);
}
aux_917 = (long)(k_2);
return make_string(aux_917, aux_919);
}
}


/* _make-string1197 */obj_t _make_string1197_224___r4_strings_6_7(obj_t env_742, obj_t k_743, obj_t char_744)
{
{
int k_847;
obj_t char_166_848;
k_847 = CINT(k_743);
char_166_848 = char_744;
if(NULLP(char_166_848)){
long aux_927;
aux_927 = (long)(k_847);
return make_string(aux_927, ((unsigned char)' '));
}
 else {
unsigned char aux_932;
long aux_930;
{
obj_t aux_933;
aux_933 = CAR(char_166_848);
aux_932 = (unsigned char)CCHAR(aux_933);
}
aux_930 = (long)(k_847);
return make_string(aux_930, aux_932);
}
}
}


/* string */obj_t string___r4_strings_6_7(obj_t chars_4)
{
return list__string_78___r4_strings_6_7(chars_4);
}


/* _string */obj_t _string___r4_strings_6_7(obj_t env_745, obj_t chars_746)
{
{
obj_t chars_849;
chars_849 = chars_746;
return list__string_78___r4_strings_6_7(chars_849);
}
}


/* string-length */long string_length_125___r4_strings_6_7(obj_t string_5)
{
return STRING_LENGTH(string_5);
}


/* _string-length1198 */obj_t _string_length1198_172___r4_strings_6_7(obj_t env_747, obj_t string_748)
{
{
long aux_940;
{
obj_t string_850;
string_850 = string_748;
aux_940 = STRING_LENGTH(string_850);
}
return BINT(aux_940);
}
}


/* string-ref */unsigned char string_ref_239___r4_strings_6_7(obj_t string_6, long k_7)
{
{
bool_t test_943;
{
long aux_944;
aux_944 = STRING_LENGTH(string_6);
test_943 = BOUND_CHECK(k_7, aux_944);
}
if(test_943){
return STRING_REF(string_6, k_7);
}
 else {
FAILURE(string1229___r4_strings_6_7,string1230___r4_strings_6_7,BINT(k_7));}
}
}


/* _string-ref1199 */obj_t _string_ref1199_50___r4_strings_6_7(obj_t env_749, obj_t string_750, obj_t k_751)
{
{
unsigned char aux_950;
{
obj_t string_851;
long k_852;
string_851 = string_750;
k_852 = (long)CINT(k_751);
{
bool_t test_952;
{
long aux_953;
aux_953 = STRING_LENGTH(string_851);
test_952 = BOUND_CHECK(k_852, aux_953);
}
if(test_952){
aux_950 = STRING_REF(string_851, k_852);
}
 else {
FAILURE(string1229___r4_strings_6_7,string1230___r4_strings_6_7,BINT(k_852));}
}
}
return BCHAR(aux_950);
}
}


/* string-set! */obj_t string_set__176___r4_strings_6_7(obj_t string_8, long k_9, unsigned char char_10)
{
{
bool_t test_960;
{
long aux_961;
aux_961 = STRING_LENGTH(string_8);
test_960 = BOUND_CHECK(k_9, aux_961);
}
if(test_960){
return STRING_SET(string_8, k_9, char_10);
}
 else {
FAILURE(string1231___r4_strings_6_7,string1230___r4_strings_6_7,BINT(k_9));}
}
}


/* _string-set!1200 */obj_t _string_set_1200_24___r4_strings_6_7(obj_t env_752, obj_t string_753, obj_t k_754, obj_t char_755)
{
{
obj_t string_853;
long k_854;
unsigned char char_166_855;
string_853 = string_753;
k_854 = (long)CINT(k_754);
char_166_855 = (unsigned char)CCHAR(char_755);
{
bool_t test_969;
{
long aux_970;
aux_970 = STRING_LENGTH(string_853);
test_969 = BOUND_CHECK(k_854, aux_970);
}
if(test_969){
return STRING_SET(string_853, k_854, char_166_855);
}
 else {
FAILURE(string1231___r4_strings_6_7,string1230___r4_strings_6_7,BINT(k_854));}
}
}
}


/* string-ref-ur */unsigned char string_ref_ur_85___r4_strings_6_7(obj_t string_11, long k_12)
{
return STRING_REF(string_11, k_12);
}


/* _string-ref-ur1201 */obj_t _string_ref_ur1201_187___r4_strings_6_7(obj_t env_756, obj_t string_757, obj_t k_758)
{
{
unsigned char aux_977;
{
obj_t string_856;
long k_857;
string_856 = string_757;
k_857 = (long)CINT(k_758);
aux_977 = STRING_REF(string_856, k_857);
}
return BCHAR(aux_977);
}
}


/* string-set-ur! */obj_t string_set_ur__94___r4_strings_6_7(obj_t string_13, long k_14, unsigned char char_15)
{
return STRING_SET(string_13, k_14, char_15);
}


/* _string-set-ur!1202 */obj_t _string_set_ur_1202_12___r4_strings_6_7(obj_t env_759, obj_t string_760, obj_t k_761, obj_t char_762)
{
{
obj_t string_858;
long k_859;
unsigned char char_166_860;
string_858 = string_760;
k_859 = (long)CINT(k_761);
char_166_860 = (unsigned char)CCHAR(char_762);
return STRING_SET(string_858, k_859, char_166_860);
}
}


/* string=? */bool_t string___146___r4_strings_6_7(obj_t string1_16, obj_t string2_17)
{
return bigloo_strcmp(string1_16, string2_17);
}


/* _string=?1203 */obj_t _string__1203_124___r4_strings_6_7(obj_t env_763, obj_t string1_764, obj_t string2_765)
{
{
bool_t aux_986;
{
obj_t string1_861;
obj_t string2_862;
string1_861 = string1_764;
string2_862 = string2_765;
aux_986 = bigloo_strcmp(string1_861, string2_862);
}
return BBOOL(aux_986);
}
}


/* substring=? */bool_t substring___218___r4_strings_6_7(obj_t string1_18, obj_t string2_19, long len_20)
{
return bigloo_strncmp(string1_18, string2_19, len_20);
}


/* _substring=?1204 */obj_t _substring__1204_78___r4_strings_6_7(obj_t env_766, obj_t string1_767, obj_t string2_768, obj_t len_769)
{
{
bool_t aux_990;
{
obj_t string1_863;
obj_t string2_864;
long len_865;
string1_863 = string1_767;
string2_864 = string2_768;
len_865 = (long)CINT(len_769);
aux_990 = bigloo_strncmp(string1_863, string2_864, len_865);
}
return BBOOL(aux_990);
}
}


/* substring-ci=? */bool_t substring_ci___99___r4_strings_6_7(obj_t string1_21, obj_t string2_22, long len_23)
{
return bigloo_strncmp_ci(string1_21, string2_22, len_23);
}


/* _substring-ci=?1205 */obj_t _substring_ci__1205_28___r4_strings_6_7(obj_t env_770, obj_t string1_771, obj_t string2_772, obj_t len_773)
{
{
bool_t aux_995;
{
obj_t string1_866;
obj_t string2_867;
long len_868;
string1_866 = string1_771;
string2_867 = string2_772;
len_868 = (long)CINT(len_773);
aux_995 = bigloo_strncmp_ci(string1_866, string2_867, len_868);
}
return BBOOL(aux_995);
}
}


/* string-ci=? */bool_t string_ci___247___r4_strings_6_7(obj_t string1_24, obj_t string2_25)
{
return strcicmp(string1_24, string2_25);
}


/* _string-ci=?1206 */obj_t _string_ci__1206_184___r4_strings_6_7(obj_t env_774, obj_t string1_775, obj_t string2_776)
{
{
bool_t aux_1000;
{
obj_t string1_869;
obj_t string2_870;
string1_869 = string1_775;
string2_870 = string2_776;
aux_1000 = strcicmp(string1_869, string2_870);
}
return BBOOL(aux_1000);
}
}


/* string<? */bool_t string___83___r4_strings_6_7(obj_t string1_26, obj_t string2_27)
{
return string_lt(string1_26, string2_27);
}


/* _string<?1207 */obj_t _string__1207_24___r4_strings_6_7(obj_t env_777, obj_t string1_778, obj_t string2_779)
{
{
bool_t aux_1004;
{
obj_t string1_871;
obj_t string2_872;
string1_871 = string1_778;
string2_872 = string2_779;
aux_1004 = string_lt(string1_871, string2_872);
}
return BBOOL(aux_1004);
}
}


/* string>? */bool_t string___248___r4_strings_6_7(obj_t string1_28, obj_t string2_29)
{
return string_gt(string1_28, string2_29);
}


/* _string>?1208 */obj_t _string__1208_166___r4_strings_6_7(obj_t env_780, obj_t string1_781, obj_t string2_782)
{
{
bool_t aux_1008;
{
obj_t string1_873;
obj_t string2_874;
string1_873 = string1_781;
string2_874 = string2_782;
aux_1008 = string_gt(string1_873, string2_874);
}
return BBOOL(aux_1008);
}
}


/* string<=? */bool_t string____33___r4_strings_6_7(obj_t string1_30, obj_t string2_31)
{
return string_le(string1_30, string2_31);
}


/* _string<=?1209 */obj_t _string___1209_197___r4_strings_6_7(obj_t env_783, obj_t string1_784, obj_t string2_785)
{
{
bool_t aux_1012;
{
obj_t string1_875;
obj_t string2_876;
string1_875 = string1_784;
string2_876 = string2_785;
aux_1012 = string_le(string1_875, string2_876);
}
return BBOOL(aux_1012);
}
}


/* string>=? */bool_t string____135___r4_strings_6_7(obj_t string1_32, obj_t string2_33)
{
return string_ge(string1_32, string2_33);
}


/* _string>=?1210 */obj_t _string___1210_254___r4_strings_6_7(obj_t env_786, obj_t string1_787, obj_t string2_788)
{
{
bool_t aux_1016;
{
obj_t string1_877;
obj_t string2_878;
string1_877 = string1_787;
string2_878 = string2_788;
aux_1016 = string_ge(string1_877, string2_878);
}
return BBOOL(aux_1016);
}
}


/* string-ci<? */bool_t string_ci___92___r4_strings_6_7(obj_t string1_34, obj_t string2_35)
{
return string_cilt(string1_34, string2_35);
}


/* _string-ci<?1211 */obj_t _string_ci__1211_16___r4_strings_6_7(obj_t env_789, obj_t string1_790, obj_t string2_791)
{
{
bool_t aux_1020;
{
obj_t string1_879;
obj_t string2_880;
string1_879 = string1_790;
string2_880 = string2_791;
aux_1020 = string_cilt(string1_879, string2_880);
}
return BBOOL(aux_1020);
}
}


/* string-ci>? */bool_t string_ci___60___r4_strings_6_7(obj_t string1_36, obj_t string2_37)
{
return string_cigt(string1_36, string2_37);
}


/* _string-ci>?1212 */obj_t _string_ci__1212_68___r4_strings_6_7(obj_t env_792, obj_t string1_793, obj_t string2_794)
{
{
bool_t aux_1024;
{
obj_t string1_881;
obj_t string2_882;
string1_881 = string1_793;
string2_882 = string2_794;
aux_1024 = string_cigt(string1_881, string2_882);
}
return BBOOL(aux_1024);
}
}


/* string-ci<=? */bool_t string_ci____210___r4_strings_6_7(obj_t string1_38, obj_t string2_39)
{
return string_cile(string1_38, string2_39);
}


/* _string-ci<=?1213 */obj_t _string_ci___1213_213___r4_strings_6_7(obj_t env_795, obj_t string1_796, obj_t string2_797)
{
{
bool_t aux_1028;
{
obj_t string1_883;
obj_t string2_884;
string1_883 = string1_796;
string2_884 = string2_797;
aux_1028 = string_cile(string1_883, string2_884);
}
return BBOOL(aux_1028);
}
}


/* string-ci>=? */bool_t string_ci____43___r4_strings_6_7(obj_t string1_40, obj_t string2_41)
{
return string_cige(string1_40, string2_41);
}


/* _string-ci>=?1214 */obj_t _string_ci___1214_7___r4_strings_6_7(obj_t env_798, obj_t string1_799, obj_t string2_800)
{
{
bool_t aux_1032;
{
obj_t string1_885;
obj_t string2_886;
string1_885 = string1_799;
string2_886 = string2_800;
aux_1032 = string_cige(string1_885, string2_886);
}
return BBOOL(aux_1032);
}
}


/* substring */obj_t substring___r4_strings_6_7(obj_t string_42, long start_43, long end_44)
{
{
bool_t test_1035;
if((end_44>=start_43)){
bool_t test_1038;
{
long aux_1039;
{
long aux_1040;
aux_1040 = STRING_LENGTH(string_42);
aux_1039 = (aux_1040+((long)1));
}
test_1038 = BOUND_CHECK(start_43, aux_1039);
}
if(test_1038){
long aux_1044;
{
long aux_1045;
aux_1045 = STRING_LENGTH(string_42);
aux_1044 = (aux_1045+((long)1));
}
test_1035 = BOUND_CHECK(end_44, aux_1044);
}
 else {
test_1035 = ((bool_t)0);
}
}
 else {
test_1035 = ((bool_t)0);
}
if(test_1035){
return c_substring(string_42, start_43, end_44);
}
 else {
obj_t arg1015_887;
{
obj_t aux_1052;
obj_t aux_1050;
aux_1052 = BINT(end_44);
aux_1050 = BINT(start_43);
arg1015_887 = MAKE_PAIR(aux_1050, aux_1052);
}
FAILURE(string1232___r4_strings_6_7,string1233___r4_strings_6_7,arg1015_887);}
}
}


/* _substring1215 */obj_t _substring1215___r4_strings_6_7(obj_t env_801, obj_t string_802, obj_t start_803, obj_t end_804)
{
{
obj_t string_888;
long start_889;
long end_890;
string_888 = string_802;
start_889 = (long)CINT(start_803);
end_890 = (long)CINT(end_804);
{
bool_t test_1058;
if((end_890>=start_889)){
bool_t test_1061;
{
long aux_1062;
{
long aux_1063;
aux_1063 = STRING_LENGTH(string_888);
aux_1062 = (aux_1063+((long)1));
}
test_1061 = BOUND_CHECK(start_889, aux_1062);
}
if(test_1061){
long aux_1067;
{
long aux_1068;
aux_1068 = STRING_LENGTH(string_888);
aux_1067 = (aux_1068+((long)1));
}
test_1058 = BOUND_CHECK(end_890, aux_1067);
}
 else {
test_1058 = ((bool_t)0);
}
}
 else {
test_1058 = ((bool_t)0);
}
if(test_1058){
return c_substring(string_888, start_889, end_890);
}
 else {
obj_t arg1015_891;
{
obj_t aux_1075;
obj_t aux_1073;
aux_1075 = BINT(end_890);
aux_1073 = BINT(start_889);
arg1015_891 = MAKE_PAIR(aux_1073, aux_1075);
}
FAILURE(string1232___r4_strings_6_7,string1233___r4_strings_6_7,arg1015_891);}
}
}
}


/* substring-ur */obj_t substring_ur_202___r4_strings_6_7(obj_t string_45, long start_46, long end_47)
{
return c_substring(string_45, start_46, end_47);
}


/* _substring-ur1216 */obj_t _substring_ur1216_185___r4_strings_6_7(obj_t env_805, obj_t string_806, obj_t start_807, obj_t end_808)
{
{
obj_t string_892;
long start_893;
long end_894;
string_892 = string_806;
start_893 = (long)CINT(start_807);
end_894 = (long)CINT(end_808);
return c_substring(string_892, start_893, end_894);
}
}


/* string-append */obj_t string_append_106___r4_strings_6_7(obj_t list_48)
{
if(NULLP(list_48)){
return string1234___r4_strings_6_7;
}
 else {
return loop___r4_strings_6_7(list_48);
}
}


/* loop */obj_t loop___r4_strings_6_7(obj_t list_245)
{
{
bool_t test_1086;
{
obj_t aux_1087;
aux_1087 = CDR(list_245);
test_1086 = NULLP(aux_1087);
}
if(test_1086){
return CAR(list_245);
}
 else {
obj_t arg1026_248;
obj_t arg1027_249;
arg1026_248 = CAR(list_245);
arg1027_249 = loop___r4_strings_6_7(CDR(list_245));
return string_append(arg1026_248, arg1027_249);
}
}
}


/* _string-append */obj_t _string_append_156___r4_strings_6_7(obj_t env_809, obj_t list_810)
{
return string_append_106___r4_strings_6_7(list_810);
}


/* list->string */obj_t list__string_78___r4_strings_6_7(obj_t list_49)
{
{
long len_252;
len_252 = list_length(list_49);
{
obj_t string_253;
{
obj_t res1193_498;
{
long aux_1097;
{
int aux_1098;
aux_1098 = (int)(len_252);
aux_1097 = (long)(aux_1098);
}
res1193_498 = make_string(aux_1097, ((unsigned char)' '));
}
string_253 = res1193_498;
}
{
{
long i_500;
obj_t l_501;
i_500 = ((long)0);
l_501 = list_49;
loop_499:
if((i_500==len_252)){
return string_253;
}
 else {
{
unsigned char aux_1104;
{
obj_t aux_1105;
aux_1105 = CAR(l_501);
aux_1104 = (unsigned char)CCHAR(aux_1105);
}
STRING_SET(string_253, i_500, aux_1104);
}
{
obj_t l_1111;
long i_1109;
i_1109 = (i_500+((long)1));
l_1111 = CDR(l_501);
l_501 = l_1111;
i_500 = i_1109;
goto loop_499;
}
}
}
}
}
}
}


/* _list->string */obj_t _list__string_5___r4_strings_6_7(obj_t env_811, obj_t list_812)
{
return list__string_78___r4_strings_6_7(list_812);
}


/* string->list */obj_t string__list_125___r4_strings_6_7(obj_t string_50)
{
{
long i_551;
obj_t res_552;
{
long aux_1124;
aux_1124 = STRING_LENGTH(string_50);
i_551 = (aux_1124-((long)1));
}
res_552 = BNIL;
loop_550:
if((i_551==((long)-1))){
return res_552;
}
 else {
long arg1039_558;
obj_t arg1040_559;
arg1039_558 = (i_551-((long)1));
{
obj_t aux_1117;
{
unsigned char aux_1118;
aux_1118 = STRING_REF(string_50, i_551);
aux_1117 = BCHAR(aux_1118);
}
arg1040_559 = MAKE_PAIR(aux_1117, res_552);
}
{
obj_t res_1123;
long i_1122;
i_1122 = arg1039_558;
res_1123 = arg1040_559;
res_552 = res_1123;
i_551 = i_1122;
goto loop_550;
}
}
}
}


/* _string->list1217 */obj_t _string__list1217_17___r4_strings_6_7(obj_t env_813, obj_t string_814)
{
return string__list_125___r4_strings_6_7(string_814);
}


/* string-copy */obj_t string_copy_207___r4_strings_6_7(obj_t string_51)
{
{
char * aux_1128;
aux_1128 = BSTRING_TO_STRING(string_51);
return string_to_bstring(aux_1128);
}
}


/* _string-copy1218 */obj_t _string_copy1218_52___r4_strings_6_7(obj_t env_815, obj_t string_816)
{
{
obj_t string_895;
string_895 = string_816;
{
char * aux_1131;
aux_1131 = BSTRING_TO_STRING(string_895);
return string_to_bstring(aux_1131);
}
}
}


/* string-fill! */obj_t string_fill__51___r4_strings_6_7(obj_t string_52, unsigned char char_53)
{
{
long len_595;
len_595 = STRING_LENGTH(string_52);
{
long i_602;
i_602 = ((long)0);
loop_601:
if((i_602==len_595)){
return string_52;
}
 else {
STRING_SET(string_52, i_602, char_53);
{
long i_1138;
i_1138 = (i_602+((long)1));
i_602 = i_1138;
goto loop_601;
}
}
}
}
}


/* _string-fill!1219 */obj_t _string_fill_1219_167___r4_strings_6_7(obj_t env_817, obj_t string_818, obj_t char_819)
{
return string_fill__51___r4_strings_6_7(string_818, (unsigned char)CCHAR(char_819));
}


/* string-upcase */obj_t string_upcase_71___r4_strings_6_7(obj_t string_54)
{
{
long len_277;
len_277 = STRING_LENGTH(string_54);
{
obj_t res_278;
{
obj_t res1194_640;
{
long aux_1143;
{
int aux_1144;
aux_1144 = (int)(len_277);
aux_1143 = (long)(aux_1144);
}
res1194_640 = make_string(aux_1143, ((unsigned char)' '));
}
res_278 = res1194_640;
}
{
{
long i_279;
i_279 = ((long)0);
loop_280:
if((i_279==len_277)){
return res_278;
}
 else {
{
unsigned char aux_1150;
{
unsigned char aux_1151;
aux_1151 = STRING_REF(string_54, i_279);
aux_1150 = toupper(aux_1151);
}
STRING_SET(res_278, i_279, aux_1150);
}
{
long i_1155;
i_1155 = (i_279+((long)1));
i_279 = i_1155;
goto loop_280;
}
}
}
}
}
}
}


/* _string-upcase1220 */obj_t _string_upcase1220_173___r4_strings_6_7(obj_t env_820, obj_t string_821)
{
return string_upcase_71___r4_strings_6_7(string_821);
}


/* string-downcase */obj_t string_downcase_77___r4_strings_6_7(obj_t string_55)
{
{
long len_286;
len_286 = STRING_LENGTH(string_55);
{
obj_t res_287;
{
obj_t res1195_658;
{
long aux_1159;
{
int aux_1160;
aux_1160 = (int)(len_286);
aux_1159 = (long)(aux_1160);
}
res1195_658 = make_string(aux_1159, ((unsigned char)' '));
}
res_287 = res1195_658;
}
{
{
long i_288;
i_288 = ((long)0);
loop_289:
if((i_288==len_286)){
return res_287;
}
 else {
{
unsigned char aux_1166;
{
unsigned char aux_1167;
aux_1167 = STRING_REF(string_55, i_288);
aux_1166 = tolower(aux_1167);
}
STRING_SET(res_287, i_288, aux_1166);
}
{
long i_1171;
i_1171 = (i_288+((long)1));
i_288 = i_1171;
goto loop_289;
}
}
}
}
}
}
}


/* _string-downcase1221 */obj_t _string_downcase1221_78___r4_strings_6_7(obj_t env_822, obj_t string_823)
{
return string_downcase_77___r4_strings_6_7(string_823);
}


/* string-upcase! */obj_t string_upcase__158___r4_strings_6_7(obj_t string_56)
{
{
long len_295;
len_295 = STRING_LENGTH(string_56);
{
{
long i_297;
i_297 = ((long)0);
loop_298:
if((i_297==len_295)){
return string_56;
}
 else {
{
unsigned char aux_1177;
{
unsigned char aux_1178;
aux_1178 = STRING_REF(string_56, i_297);
aux_1177 = toupper(aux_1178);
}
STRING_SET(string_56, i_297, aux_1177);
}
{
long i_1182;
i_1182 = (i_297+((long)1));
i_297 = i_1182;
goto loop_298;
}
}
}
}
}
}


/* _string-upcase!1222 */obj_t _string_upcase_1222_36___r4_strings_6_7(obj_t env_824, obj_t string_825)
{
return string_upcase__158___r4_strings_6_7(string_825);
}


/* string-downcase! */obj_t string_downcase__42___r4_strings_6_7(obj_t string_57)
{
{
long len_303;
len_303 = STRING_LENGTH(string_57);
{
{
long i_305;
i_305 = ((long)0);
loop_306:
if((i_305==len_303)){
return string_57;
}
 else {
{
unsigned char aux_1188;
{
unsigned char aux_1189;
aux_1189 = STRING_REF(string_57, i_305);
aux_1188 = tolower(aux_1189);
}
STRING_SET(string_57, i_305, aux_1188);
}
{
long i_1193;
i_1193 = (i_305+((long)1));
i_305 = i_1193;
goto loop_306;
}
}
}
}
}
}


/* _string-downcase!1223 */obj_t _string_downcase_1223_130___r4_strings_6_7(obj_t env_826, obj_t string_827)
{
return string_downcase__42___r4_strings_6_7(string_827);
}


/* string-capitalize! */obj_t string_capitalize__136___r4_strings_6_7(obj_t string_58)
{
{
bool_t non_first_alpha_60_311;
long string_len_173_312;
non_first_alpha_60_311 = ((bool_t)0);
string_len_173_312 = STRING_LENGTH(string_58);
{
long i_314;
i_314 = ((long)0);
do_loop__1002_81_322:
if((i_314==string_len_173_312)){
return string_58;
}
 else {
{
unsigned char c_317;
c_317 = STRING_REF(string_58, i_314);
{
bool_t test_1200;
{
unsigned char c_697;
c_697 = toupper(c_317);
if((c_697>=((unsigned char)'A'))){
test_1200 = (c_697<=((unsigned char)'Z'));
}
 else {
test_1200 = ((bool_t)0);
}
}
if(test_1200){
if(non_first_alpha_60_311){
unsigned char aux_1206;
aux_1206 = tolower(c_317);
STRING_SET(string_58, i_314, aux_1206);
}
 else {
non_first_alpha_60_311 = ((bool_t)1);
{
unsigned char aux_1209;
aux_1209 = toupper(c_317);
STRING_SET(string_58, i_314, aux_1209);
}
}
}
 else {
non_first_alpha_60_311 = ((bool_t)0);
}
}
}
{
long i_1212;
i_1212 = (i_314+((long)1));
i_314 = i_1212;
goto do_loop__1002_81_322;
}
}
}
}
}


/* _string-capitalize!1224 */obj_t _string_capitalize_1224_194___r4_strings_6_7(obj_t env_828, obj_t string_829)
{
return string_capitalize__136___r4_strings_6_7(string_829);
}


/* string-capitalize */obj_t string_capitalize_230___r4_strings_6_7(obj_t string_59)
{
{
obj_t arg1069_715;
{
char * aux_1215;
aux_1215 = BSTRING_TO_STRING(string_59);
arg1069_715 = string_to_bstring(aux_1215);
}
return string_capitalize__136___r4_strings_6_7(arg1069_715);
}
}


/* _string-capitalize1225 */obj_t _string_capitalize1225_247___r4_strings_6_7(obj_t env_830, obj_t string_831)
{
return string_capitalize_230___r4_strings_6_7(string_831);
}


/* string-for-read */obj_t string_for_read_25___r4_strings_6_7(obj_t string_60)
{
return string_for_read(string_60);
}


/* _string-for-read1226 */obj_t _string_for_read1226_232___r4_strings_6_7(obj_t env_832, obj_t string_833)
{
{
obj_t string_896;
string_896 = string_833;
return string_for_read(string_896);
}
}


/* blit-string-ur! */obj_t blit_string_ur__74___r4_strings_6_7(obj_t s1_61, obj_t o1_62, obj_t s2_63, obj_t o2_64, obj_t l_65)
{
return blit_string(s1_61, o1_62, s2_63, o2_64, l_65);
}


/* _blit-string-ur!1227 */obj_t _blit_string_ur_1227_132___r4_strings_6_7(obj_t env_834, obj_t s1_835, obj_t o1_836, obj_t s2_837, obj_t o2_838, obj_t l_839)
{
{
obj_t s1_897;
obj_t o1_898;
obj_t s2_899;
obj_t o2_900;
obj_t l_901;
s1_897 = s1_835;
o1_898 = o1_836;
s2_899 = s2_837;
o2_900 = o2_838;
l_901 = l_839;
return blit_string(s1_897, o1_898, s2_899, o2_900, l_901);
}
}


/* blit-string! */obj_t blit_string__141___r4_strings_6_7(obj_t s1_66, obj_t o1_67, obj_t s2_68, obj_t o2_69, obj_t l_70)
{
{
bool_t test_1224;
{
bool_t test_1225;
{
long aux_1232;
long aux_1226;
{
long aux_1233;
aux_1233 = STRING_LENGTH(s1_66);
aux_1232 = (aux_1233+((long)1));
}
{
long aux_1229;
long aux_1227;
aux_1229 = (long)CINT(o1_67);
aux_1227 = (long)CINT(l_70);
aux_1226 = (aux_1227+aux_1229);
}
test_1225 = BOUND_CHECK(aux_1226, aux_1232);
}
if(test_1225){
long aux_1243;
long aux_1237;
{
long aux_1244;
aux_1244 = STRING_LENGTH(s2_68);
aux_1243 = (aux_1244+((long)1));
}
{
long aux_1240;
long aux_1238;
aux_1240 = (long)CINT(o2_69);
aux_1238 = (long)CINT(l_70);
aux_1237 = (aux_1238+aux_1240);
}
test_1224 = BOUND_CHECK(aux_1237, aux_1243);
}
 else {
test_1224 = ((bool_t)0);
}
}
if(test_1224){
return blit_string(s1_66, o1_67, s2_68, o2_69, l_70);
}
 else {
obj_t arg1076_327;
{
long arg1077_328;
long arg1078_329;
arg1077_328 = STRING_LENGTH(s1_66);
arg1078_329 = STRING_LENGTH(s2_68);
{
obj_t list1079_330;
{
obj_t arg1080_331;
{
obj_t arg1081_332;
{
obj_t arg1082_333;
{
obj_t arg1083_334;
arg1083_334 = MAKE_PAIR(l_70, BNIL);
arg1082_333 = MAKE_PAIR(o2_69, arg1083_334);
}
{
obj_t aux_1253;
aux_1253 = BINT(arg1078_329);
arg1081_332 = MAKE_PAIR(aux_1253, arg1082_333);
}
}
arg1080_331 = MAKE_PAIR(o1_67, arg1081_332);
}
{
obj_t aux_1257;
aux_1257 = BINT(arg1077_328);
list1079_330 = MAKE_PAIR(aux_1257, arg1080_331);
}
}
arg1076_327 = list1079_330;
}
}
FAILURE(string1235___r4_strings_6_7,string1236___r4_strings_6_7,arg1076_327);}
}
}


/* _blit-string!1228 */obj_t _blit_string_1228_254___r4_strings_6_7(obj_t env_840, obj_t s1_841, obj_t o1_842, obj_t s2_843, obj_t o2_844, obj_t l_845)
{
return blit_string__141___r4_strings_6_7(s1_841, o1_842, s2_843, o2_844, l_845);
}


/* imported-modules-init */obj_t imported_modules_init_94___r4_strings_6_7()
{
return module_initialization_70___error(((long)0), "__R4_STRINGS_6_7");
}

