/*===========================================================================*/
/*   (Ieee/port.scm)                                                         */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

extern obj_t unwind_until__178___bexit(obj_t, obj_t);
extern obj_t call_with_input_file_94___r4_ports_6_10_1(obj_t, obj_t);
extern bool_t reset_eof(obj_t);
static obj_t _open_input_string1188_201___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _with_output_to_port1184_216___r4_ports_6_10_1(obj_t, obj_t, obj_t);
static obj_t _call_with_output_file1180_160___r4_ports_6_10_1(obj_t, obj_t, obj_t);
extern obj_t append_output_file_247___r4_ports_6_10_1(obj_t);
extern obj_t with_error_to_file_201___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t current_output_port;
extern bool_t directoryp(char *);
extern bool_t reset_eof_236___r4_ports_6_10_1(obj_t);
extern obj_t call_with_output_file_65___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _close_input_port1191_156___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t current_error_port;
extern obj_t directory_to_list(char *);
static obj_t _append_output_file1198_254___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _input_port_position1195_70___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _delete_file1199_115___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t open_input_string(obj_t);
extern obj_t current_output_port_239___r4_ports_6_10_1();
extern obj_t with_error_to_port_5___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t current_error_port_17___r4_ports_6_10_1();
static obj_t _with_error_to_file1185_230___r4_ports_6_10_1(obj_t, obj_t, obj_t);
extern obj_t output_port__47___r4_ports_6_10_1(obj_t);
static obj_t _current_error_port_229___r4_ports_6_10_1(obj_t);
extern obj_t close_input_port_142___r4_ports_6_10_1(obj_t);
extern obj_t close_output_port(obj_t);
extern obj_t string_to_bstring(char *);
static obj_t _open_output_file1190_189___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t current_input_port;
static obj_t _with_output_to_file1183_152___r4_ports_6_10_1(obj_t, obj_t, obj_t);
static obj_t _directory_1202_153___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _input_port__169___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t open_input_file(obj_t, obj_t);
static obj_t _close_output_port1192_168___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _file_exists_1197_155___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t with_output_to_file_237___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t current_input_port_104___r4_ports_6_10_1();
extern obj_t close_input_port(obj_t);
extern long default_io_bufsiz;
static obj_t handling_function1055___r4_ports_6_10_1(obj_t, obj_t);
static obj_t handling_function1050___r4_ports_6_10_1(obj_t, obj_t);
static obj_t handling_function1045___r4_ports_6_10_1(obj_t, obj_t);
static obj_t handling_function1041___r4_ports_6_10_1(obj_t, obj_t);
static obj_t handling_function1036___r4_ports_6_10_1(obj_t, obj_t);
static obj_t handling_function1031___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t flush_output_port_36___r4_ports_6_10_1(obj_t);
static obj_t _input_port_name1196_16___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t module_initialization_70___r4_ports_6_10_1(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _current_input_port_198___r4_ports_6_10_1(obj_t);
extern obj_t delete_file_114___r4_ports_6_10_1(char *);
extern obj_t open_output_string();
extern obj_t open_input_string_20___r4_ports_6_10_1(obj_t);
static obj_t _rename_file1201_157___r4_ports_6_10_1(obj_t, obj_t, obj_t);
extern obj_t input_port__135___r4_ports_6_10_1(obj_t);
static obj_t _open_input_c_string1189_6___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _directory__list1203_124___r4_ports_6_10_1(obj_t, obj_t);
extern bool_t directory__80___r4_ports_6_10_1(char *);
static obj_t _with_input_from_port1182_160___r4_ports_6_10_1(obj_t, obj_t, obj_t);
extern bool_t fexists(char *);
extern obj_t with_output_to_port_151___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t open_output_file_240___r4_ports_6_10_1(obj_t);
extern obj_t rename_file_185___r4_ports_6_10_1(char *, char *);
extern obj_t open_output_string_81___r4_ports_6_10_1();
extern obj_t close_output_port_77___r4_ports_6_10_1(obj_t);
extern char * input_port_name_249___r4_ports_6_10_1(obj_t);
static obj_t _current_output_port_118___r4_ports_6_10_1(obj_t);
static obj_t _call_with_input_file1179_230___r4_ports_6_10_1(obj_t, obj_t, obj_t);
extern obj_t with_input_from_file_180___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _delete_directory1200_12___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t open_input_c_string(char *);
static obj_t _reset_eof1194_236___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _open_output_string_243___r4_ports_6_10_1(obj_t);
extern obj_t delete_directory_248___r4_ports_6_10_1(char *);
static obj_t _flush_output_port1193_67___r4_ports_6_10_1(obj_t, obj_t);
static obj_t _port__120___r4_ports_6_10_1(obj_t, obj_t);
static obj_t imported_modules_init_94___r4_ports_6_10_1();
static obj_t _output_port__133___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t open_output_file(obj_t);
extern obj_t val_from_exit__100___bexit(obj_t);
static obj_t require_initialization_114___r4_ports_6_10_1 = BUNSPEC;
extern obj_t file_exists__238___r4_ports_6_10_1(char *);
extern obj_t open_input_c_string_190___r4_ports_6_10_1(char *);
extern obj_t with_input_from_port_242___r4_ports_6_10_1(obj_t, obj_t);
extern obj_t append_output_file(obj_t);
extern bool_t port__25___r4_ports_6_10_1(obj_t);
static obj_t _with_error_to_port1186_92___r4_ports_6_10_1(obj_t, obj_t, obj_t);
extern obj_t open_input_file_61___r4_ports_6_10_1(obj_t, obj_t);
extern int input_port_position_149___r4_ports_6_10_1(obj_t);
extern obj_t directory__list_196___r4_ports_6_10_1(char *);
static obj_t _with_input_from_file1181_179___r4_ports_6_10_1(obj_t, obj_t, obj_t);
static obj_t _open_input_file1187_98___r4_ports_6_10_1(obj_t, obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( open_input_file_env_205___r4_ports_6_10_1, _open_input_file1187_98___r4_ports_6_10_11213, va_generic_entry, _open_input_file1187_98___r4_ports_6_10_1, -2 );
DEFINE_EXPORT_PROCEDURE( open_input_c_string_env_188___r4_ports_6_10_1, _open_input_c_string1189_6___r4_ports_6_10_11214, _open_input_c_string1189_6___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( flush_output_port_env_174___r4_ports_6_10_1, _flush_output_port1193_67___r4_ports_6_10_11215, _flush_output_port1193_67___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( close_input_port_env_160___r4_ports_6_10_1, _close_input_port1191_156___r4_ports_6_10_11216, _close_input_port1191_156___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( reset_eof_env_94___r4_ports_6_10_1, _reset_eof1194_236___r4_ports_6_10_11217, _reset_eof1194_236___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( file_exists__env_75___r4_ports_6_10_1, _file_exists_1197_155___r4_ports_6_10_11218, _file_exists_1197_155___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( directory__env_134___r4_ports_6_10_1, _directory_1202_153___r4_ports_6_10_11219, _directory_1202_153___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( delete_file_env_16___r4_ports_6_10_1, _delete_file1199_115___r4_ports_6_10_11220, _delete_file1199_115___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( current_error_port_env_195___r4_ports_6_10_1, _current_error_port_229___r4_ports_6_10_11221, _current_error_port_229___r4_ports_6_10_1, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( open_input_string_env_49___r4_ports_6_10_1, _open_input_string1188_201___r4_ports_6_10_11222, _open_input_string1188_201___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( open_output_file_env_95___r4_ports_6_10_1, _open_output_file1190_189___r4_ports_6_10_11223, _open_output_file1190_189___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( with_error_to_port_env_185___r4_ports_6_10_1, _with_error_to_port1186_92___r4_ports_6_10_11224, _with_error_to_port1186_92___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( with_input_from_port_env_200___r4_ports_6_10_1, _with_input_from_port1182_160___r4_ports_6_10_11225, _with_input_from_port1182_160___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( with_output_to_port_env_101___r4_ports_6_10_1, _with_output_to_port1184_216___r4_ports_6_10_11226, _with_output_to_port1184_216___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( call_with_output_file_env_32___r4_ports_6_10_1, _call_with_output_file1180_160___r4_ports_6_10_11227, _call_with_output_file1180_160___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( input_port_name_env_215___r4_ports_6_10_1, _input_port_name1196_16___r4_ports_6_10_11228, _input_port_name1196_16___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( call_with_input_file_env_0___r4_ports_6_10_1, _call_with_input_file1179_230___r4_ports_6_10_11229, _call_with_input_file1179_230___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( current_output_port_env_251___r4_ports_6_10_1, _current_output_port_118___r4_ports_6_10_11230, _current_output_port_118___r4_ports_6_10_1, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( input_port__env_18___r4_ports_6_10_1, _input_port__169___r4_ports_6_10_11231, _input_port__169___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( input_port_position_env_191___r4_ports_6_10_1, _input_port_position1195_70___r4_ports_6_10_11232, _input_port_position1195_70___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( directory__list_env_105___r4_ports_6_10_1, _directory__list1203_124___r4_ports_6_10_11233, _directory__list1203_124___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( rename_file_env_203___r4_ports_6_10_1, _rename_file1201_157___r4_ports_6_10_11234, _rename_file1201_157___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( append_output_file_env_62___r4_ports_6_10_1, _append_output_file1198_254___r4_ports_6_10_11235, _append_output_file1198_254___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( close_output_port_env_169___r4_ports_6_10_1, _close_output_port1192_168___r4_ports_6_10_11236, _close_output_port1192_168___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( output_port__env_61___r4_ports_6_10_1, _output_port__133___r4_ports_6_10_11237, _output_port__133___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( delete_directory_env_124___r4_ports_6_10_1, _delete_directory1200_12___r4_ports_6_10_11238, _delete_directory1200_12___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( with_error_to_file_env_148___r4_ports_6_10_1, _with_error_to_file1185_230___r4_ports_6_10_11239, _with_error_to_file1185_230___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( with_input_from_file_env_154___r4_ports_6_10_1, _with_input_from_file1181_179___r4_ports_6_10_11240, _with_input_from_file1181_179___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( with_output_to_file_env_30___r4_ports_6_10_1, _with_output_to_file1183_152___r4_ports_6_10_11241, _with_output_to_file1183_152___r4_ports_6_10_1, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( current_input_port_env_5___r4_ports_6_10_1, _current_input_port_198___r4_ports_6_10_11242, _current_input_port_198___r4_ports_6_10_1, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( port__env_47___r4_ports_6_10_1, _port__120___r4_ports_6_10_11243, _port__120___r4_ports_6_10_1, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( open_output_string_env_226___r4_ports_6_10_1, _open_output_string_243___r4_ports_6_10_11244, _open_output_string_243___r4_ports_6_10_1, 0L, 0 );
DEFINE_STRING( string1211___r4_ports_6_10_1, string1211___r4_ports_6_10_11245, "with-error-to-file", 18 );
DEFINE_STRING( string1209___r4_ports_6_10_1, string1209___r4_ports_6_10_11246, "with-input-from-file", 20 );
DEFINE_STRING( string1210___r4_ports_6_10_1, string1210___r4_ports_6_10_11247, "with-output-to-file", 19 );
DEFINE_STRING( string1208___r4_ports_6_10_1, string1208___r4_ports_6_10_11248, "call-with-output-file", 21 );
DEFINE_STRING( string1207___r4_ports_6_10_1, string1207___r4_ports_6_10_11249, "can't open file", 15 );
DEFINE_STRING( string1206___r4_ports_6_10_1, string1206___r4_ports_6_10_11250, "call-with-input-file", 20 );
DEFINE_STRING( string1205___r4_ports_6_10_1, string1205___r4_ports_6_10_11251, "not a number", 12 );
DEFINE_STRING( string1204___r4_ports_6_10_1, string1204___r4_ports_6_10_11252, "open-input-file", 15 );


/* module-initialization */obj_t module_initialization_70___r4_ports_6_10_1(long checksum_632, char * from_633)
{
if(CBOOL(require_initialization_114___r4_ports_6_10_1)){
require_initialization_114___r4_ports_6_10_1 = BBOOL(((bool_t)0));
imported_modules_init_94___r4_ports_6_10_1();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* call-with-input-file */obj_t call_with_input_file_94___r4_ports_6_10_1(obj_t string_1, obj_t proc_2)
{
{
obj_t port_438;
{
obj_t size_444;
size_444 = BINT(default_io_bufsiz);
if(INTEGERP(size_444)){
port_438 = open_input_file(string_1, size_444);
}
 else {
FAILURE(string1204___r4_ports_6_10_1,string1205___r4_ports_6_10_1,size_444);}
}
if(INPUT_PORTP(port_438)){
obj_t res_441;
res_441 = PROCEDURE_ENTRY(proc_2)(proc_2, port_438, BEOA);
close_input_port(port_438);
return res_441;
}
 else {
FAILURE(string1206___r4_ports_6_10_1,string1207___r4_ports_6_10_1,string_1);}
}
}


/* _call-with-input-file1179 */obj_t _call_with_input_file1179_230___r4_ports_6_10_1(obj_t env_524, obj_t string_525, obj_t proc_526)
{
return call_with_input_file_94___r4_ports_6_10_1(string_525, proc_526);
}


/* call-with-output-file */obj_t call_with_output_file_65___r4_ports_6_10_1(obj_t string_3, obj_t proc_4)
{
{
obj_t port_458;
port_458 = open_output_file(string_3);
if(OUTPUT_PORTP(port_458)){
obj_t res_460;
res_460 = PROCEDURE_ENTRY(proc_4)(proc_4, port_458, BEOA);
close_output_port(port_458);
return res_460;
}
 else {
FAILURE(string1208___r4_ports_6_10_1,string1207___r4_ports_6_10_1,string_3);}
}
}


/* _call-with-output-file1180 */obj_t _call_with_output_file1180_160___r4_ports_6_10_1(obj_t env_527, obj_t string_528, obj_t proc_529)
{
return call_with_output_file_65___r4_ports_6_10_1(string_528, proc_529);
}


/* input-port? */obj_t input_port__135___r4_ports_6_10_1(obj_t obj_5)
{
{
bool_t aux_658;
aux_658 = INPUT_PORTP(obj_5);
return BBOOL(aux_658);
}
}


/* _input-port? */obj_t _input_port__169___r4_ports_6_10_1(obj_t env_530, obj_t obj_531)
{
{
obj_t obj_606;
obj_606 = obj_531;
{
bool_t aux_661;
aux_661 = INPUT_PORTP(obj_606);
return BBOOL(aux_661);
}
}
}


/* output-port? */obj_t output_port__47___r4_ports_6_10_1(obj_t obj_6)
{
{
bool_t aux_664;
aux_664 = OUTPUT_PORTP(obj_6);
return BBOOL(aux_664);
}
}


/* _output-port? */obj_t _output_port__133___r4_ports_6_10_1(obj_t env_532, obj_t obj_533)
{
{
obj_t obj_607;
obj_607 = obj_533;
{
bool_t aux_667;
aux_667 = OUTPUT_PORTP(obj_607);
return BBOOL(aux_667);
}
}
}


/* current-input-port */obj_t current_input_port_104___r4_ports_6_10_1()
{
return current_input_port;
}


/* _current-input-port */obj_t _current_input_port_198___r4_ports_6_10_1(obj_t env_534)
{
return current_input_port;
}


/* current-output-port */obj_t current_output_port_239___r4_ports_6_10_1()
{
return current_output_port;
}


/* _current-output-port */obj_t _current_output_port_118___r4_ports_6_10_1(obj_t env_535)
{
return current_output_port;
}


/* current-error-port */obj_t current_error_port_17___r4_ports_6_10_1()
{
return current_error_port;
}


/* _current-error-port */obj_t _current_error_port_229___r4_ports_6_10_1(obj_t env_536)
{
return current_error_port;
}


/* with-input-from-file */obj_t with_input_from_file_180___r4_ports_6_10_1(obj_t string_7, obj_t thunk_8)
{
{
obj_t port_258;
{
obj_t size_469;
size_469 = BINT(default_io_bufsiz);
if(INTEGERP(size_469)){
port_258 = open_input_file(string_7, size_469);
}
 else {
FAILURE(string1204___r4_ports_6_10_1,string1205___r4_ports_6_10_1,size_469);}
}
if(INPUT_PORTP(port_258)){
obj_t old_input_port_89_260;
old_input_port_89_260 = current_input_port;
{
obj_t val1002_261;
val1002_261 = handling_function1031___r4_ports_6_10_1(thunk_8, port_258);
current_input_port = old_input_port_89_260;
close_input_port(port_258);
{
bool_t test1028_262;
{
obj_t aux_679;
aux_679 = val_from_exit__100___bexit(val1002_261);
test1028_262 = CBOOL(aux_679);
}
if(test1028_262){
return unwind_until__178___bexit(CAR(val1002_261), CDR(val1002_261));
}
 else {
return val1002_261;
}
}
}
}
 else {
FAILURE(string1209___r4_ports_6_10_1,string1207___r4_ports_6_10_1,string_7);}
}
}


/* handling_function1031 */obj_t handling_function1031___r4_ports_6_10_1(obj_t thunk_605, obj_t port_604)
{
jmp_buf jmpbuf;
obj_t an_exit1003_266;
if( SET_EXIT(an_exit1003_266) ) {RESTORE_TRACE(); return _exit_value_;
} else {an_exit1003_266 = (obj_t)jmpbuf;
{
PUSH_EXIT(an_exit1003_266, ((bool_t)0));
{
obj_t val1004_267;
current_input_port = port_604;
val1004_267 = PROCEDURE_ENTRY(thunk_605)(thunk_605, BEOA);
POP_EXIT();
return val1004_267;
}
}
}
}


/* _with-input-from-file1181 */obj_t _with_input_from_file1181_179___r4_ports_6_10_1(obj_t env_537, obj_t string_538, obj_t thunk_539)
{
return with_input_from_file_180___r4_ports_6_10_1(string_538, thunk_539);
}


/* with-input-from-port */obj_t with_input_from_port_242___r4_ports_6_10_1(obj_t port_9, obj_t thunk_10)
{
{
obj_t old_input_port_89_269;
old_input_port_89_269 = current_input_port;
{
obj_t val1005_270;
val1005_270 = handling_function1036___r4_ports_6_10_1(thunk_10, port_9);
current_input_port = old_input_port_89_269;
{
bool_t test1033_271;
{
obj_t aux_695;
aux_695 = val_from_exit__100___bexit(val1005_270);
test1033_271 = CBOOL(aux_695);
}
if(test1033_271){
return unwind_until__178___bexit(CAR(val1005_270), CDR(val1005_270));
}
 else {
return val1005_270;
}
}
}
}
}


/* handling_function1036 */obj_t handling_function1036___r4_ports_6_10_1(obj_t thunk_603, obj_t port_602)
{
jmp_buf jmpbuf;
obj_t an_exit1006_275;
if( SET_EXIT(an_exit1006_275) ) {RESTORE_TRACE(); return _exit_value_;
} else {an_exit1006_275 = (obj_t)jmpbuf;
{
PUSH_EXIT(an_exit1006_275, ((bool_t)0));
{
obj_t val1007_276;
current_input_port = port_602;
val1007_276 = PROCEDURE_ENTRY(thunk_603)(thunk_603, BEOA);
POP_EXIT();
return val1007_276;
}
}
}
}


/* _with-input-from-port1182 */obj_t _with_input_from_port1182_160___r4_ports_6_10_1(obj_t env_540, obj_t port_541, obj_t thunk_542)
{
return with_input_from_port_242___r4_ports_6_10_1(port_541, thunk_542);
}


/* with-output-to-file */obj_t with_output_to_file_237___r4_ports_6_10_1(obj_t string_11, obj_t thunk_12)
{
{
obj_t port_277;
port_277 = open_output_file(string_11);
if(OUTPUT_PORTP(port_277)){
obj_t old_output_port_232_279;
old_output_port_232_279 = current_output_port;
{
obj_t val1008_280;
val1008_280 = handling_function1041___r4_ports_6_10_1(thunk_12, port_277);
current_output_port = old_output_port_232_279;
close_output_port(port_277);
{
bool_t test1038_281;
{
obj_t aux_714;
aux_714 = val_from_exit__100___bexit(val1008_280);
test1038_281 = CBOOL(aux_714);
}
if(test1038_281){
return unwind_until__178___bexit(CAR(val1008_280), CDR(val1008_280));
}
 else {
return val1008_280;
}
}
}
}
 else {
FAILURE(string1210___r4_ports_6_10_1,string1207___r4_ports_6_10_1,string_11);}
}
}


/* handling_function1041 */obj_t handling_function1041___r4_ports_6_10_1(obj_t thunk_601, obj_t port_600)
{
jmp_buf jmpbuf;
obj_t an_exit1009_285;
if( SET_EXIT(an_exit1009_285) ) {RESTORE_TRACE(); return _exit_value_;
} else {an_exit1009_285 = (obj_t)jmpbuf;
{
PUSH_EXIT(an_exit1009_285, ((bool_t)0));
{
obj_t val1010_286;
current_output_port = port_600;
val1010_286 = PROCEDURE_ENTRY(thunk_601)(thunk_601, BEOA);
POP_EXIT();
return val1010_286;
}
}
}
}


/* _with-output-to-file1183 */obj_t _with_output_to_file1183_152___r4_ports_6_10_1(obj_t env_543, obj_t string_544, obj_t thunk_545)
{
return with_output_to_file_237___r4_ports_6_10_1(string_544, thunk_545);
}


/* with-output-to-port */obj_t with_output_to_port_151___r4_ports_6_10_1(obj_t port_13, obj_t thunk_14)
{
{
obj_t old_output_port_232_287;
old_output_port_232_287 = current_output_port;
{
obj_t val1011_288;
val1011_288 = handling_function1045___r4_ports_6_10_1(thunk_14, port_13);
current_output_port = old_output_port_232_287;
{
bool_t test1042_289;
{
obj_t aux_730;
aux_730 = val_from_exit__100___bexit(val1011_288);
test1042_289 = CBOOL(aux_730);
}
if(test1042_289){
return unwind_until__178___bexit(CAR(val1011_288), CDR(val1011_288));
}
 else {
return val1011_288;
}
}
}
}
}


/* handling_function1045 */obj_t handling_function1045___r4_ports_6_10_1(obj_t thunk_599, obj_t port_598)
{
jmp_buf jmpbuf;
obj_t an_exit1012_293;
if( SET_EXIT(an_exit1012_293) ) {RESTORE_TRACE(); return _exit_value_;
} else {an_exit1012_293 = (obj_t)jmpbuf;
{
PUSH_EXIT(an_exit1012_293, ((bool_t)0));
{
obj_t val1013_294;
current_output_port = port_598;
val1013_294 = PROCEDURE_ENTRY(thunk_599)(thunk_599, BEOA);
POP_EXIT();
return val1013_294;
}
}
}
}


/* _with-output-to-port1184 */obj_t _with_output_to_port1184_216___r4_ports_6_10_1(obj_t env_546, obj_t port_547, obj_t thunk_548)
{
return with_output_to_port_151___r4_ports_6_10_1(port_547, thunk_548);
}


/* with-error-to-file */obj_t with_error_to_file_201___r4_ports_6_10_1(obj_t string_15, obj_t thunk_16)
{
{
obj_t port_295;
port_295 = open_output_file(string_15);
if(OUTPUT_PORTP(port_295)){
obj_t old_output_port_232_297;
old_output_port_232_297 = current_error_port;
{
obj_t val1014_298;
val1014_298 = handling_function1050___r4_ports_6_10_1(thunk_16, port_295);
current_error_port = old_output_port_232_297;
close_output_port(port_295);
{
bool_t test1047_299;
{
obj_t aux_749;
aux_749 = val_from_exit__100___bexit(val1014_298);
test1047_299 = CBOOL(aux_749);
}
if(test1047_299){
return unwind_until__178___bexit(CAR(val1014_298), CDR(val1014_298));
}
 else {
return val1014_298;
}
}
}
}
 else {
FAILURE(string1211___r4_ports_6_10_1,string1207___r4_ports_6_10_1,string_15);}
}
}


/* handling_function1050 */obj_t handling_function1050___r4_ports_6_10_1(obj_t thunk_597, obj_t port_596)
{
jmp_buf jmpbuf;
obj_t an_exit1015_303;
if( SET_EXIT(an_exit1015_303) ) {RESTORE_TRACE(); return _exit_value_;
} else {an_exit1015_303 = (obj_t)jmpbuf;
{
PUSH_EXIT(an_exit1015_303, ((bool_t)0));
{
obj_t val1016_304;
current_error_port = port_596;
val1016_304 = PROCEDURE_ENTRY(thunk_597)(thunk_597, BEOA);
POP_EXIT();
return val1016_304;
}
}
}
}


/* _with-error-to-file1185 */obj_t _with_error_to_file1185_230___r4_ports_6_10_1(obj_t env_549, obj_t string_550, obj_t thunk_551)
{
return with_error_to_file_201___r4_ports_6_10_1(string_550, thunk_551);
}


/* with-error-to-port */obj_t with_error_to_port_5___r4_ports_6_10_1(obj_t port_17, obj_t thunk_18)
{
{
obj_t old_output_port_232_305;
old_output_port_232_305 = current_error_port;
{
obj_t val1017_306;
val1017_306 = handling_function1055___r4_ports_6_10_1(thunk_18, port_17);
current_error_port = old_output_port_232_305;
{
bool_t test1051_307;
{
obj_t aux_765;
aux_765 = val_from_exit__100___bexit(val1017_306);
test1051_307 = CBOOL(aux_765);
}
if(test1051_307){
return unwind_until__178___bexit(CAR(val1017_306), CDR(val1017_306));
}
 else {
return val1017_306;
}
}
}
}
}


/* handling_function1055 */obj_t handling_function1055___r4_ports_6_10_1(obj_t thunk_595, obj_t port_594)
{
jmp_buf jmpbuf;
obj_t an_exit1018_311;
if( SET_EXIT(an_exit1018_311) ) {RESTORE_TRACE(); return _exit_value_;
} else {an_exit1018_311 = (obj_t)jmpbuf;
{
PUSH_EXIT(an_exit1018_311, ((bool_t)0));
{
obj_t val1019_312;
current_error_port = port_594;
val1019_312 = PROCEDURE_ENTRY(thunk_595)(thunk_595, BEOA);
POP_EXIT();
return val1019_312;
}
}
}
}


/* _with-error-to-port1186 */obj_t _with_error_to_port1186_92___r4_ports_6_10_1(obj_t env_552, obj_t port_553, obj_t thunk_554)
{
return with_error_to_port_5___r4_ports_6_10_1(port_553, thunk_554);
}


/* open-input-file */obj_t open_input_file_61___r4_ports_6_10_1(obj_t string_19, obj_t bufsiz_20)
{
{
obj_t size_507;
if(NULLP(bufsiz_20)){
size_507 = BINT(default_io_bufsiz);
}
 else {
size_507 = CAR(bufsiz_20);
}
if(INTEGERP(size_507)){
return open_input_file(string_19, size_507);
}
 else {
FAILURE(string1204___r4_ports_6_10_1,string1205___r4_ports_6_10_1,size_507);}
}
}


/* _open-input-file1187 */obj_t _open_input_file1187_98___r4_ports_6_10_1(obj_t env_555, obj_t string_556, obj_t bufsiz_557)
{
return open_input_file_61___r4_ports_6_10_1(string_556, bufsiz_557);
}


/* open-input-string */obj_t open_input_string_20___r4_ports_6_10_1(obj_t string_21)
{
return open_input_string(string_21);
}


/* _open-input-string1188 */obj_t _open_input_string1188_201___r4_ports_6_10_1(obj_t env_558, obj_t string_559)
{
{
obj_t string_608;
string_608 = string_559;
return open_input_string(string_608);
}
}


/* open-input-c-string */obj_t open_input_c_string_190___r4_ports_6_10_1(char * string_22)
{
return open_input_c_string(string_22);
}


/* _open-input-c-string1189 */obj_t _open_input_c_string1189_6___r4_ports_6_10_1(obj_t env_560, obj_t string_561)
{
{
char * string_609;
string_609 = BSTRING_TO_STRING(string_561);
return open_input_c_string(string_609);
}
}


/* open-output-file */obj_t open_output_file_240___r4_ports_6_10_1(obj_t string_23)
{
return open_output_file(string_23);
}


/* _open-output-file1190 */obj_t _open_output_file1190_189___r4_ports_6_10_1(obj_t env_562, obj_t string_563)
{
{
obj_t string_610;
string_610 = string_563;
return open_output_file(string_610);
}
}


/* open-output-string */obj_t open_output_string_81___r4_ports_6_10_1()
{
return open_output_string();
}


/* _open-output-string */obj_t _open_output_string_243___r4_ports_6_10_1(obj_t env_564)
{
return open_output_string();
}


/* close-input-port */obj_t close_input_port_142___r4_ports_6_10_1(obj_t port_24)
{
return close_input_port(port_24);
}


/* _close-input-port1191 */obj_t _close_input_port1191_156___r4_ports_6_10_1(obj_t env_565, obj_t port_566)
{
{
obj_t port_611;
port_611 = port_566;
return close_input_port(port_611);
}
}


/* close-output-port */obj_t close_output_port_77___r4_ports_6_10_1(obj_t port_25)
{
return close_output_port(port_25);
}


/* _close-output-port1192 */obj_t _close_output_port1192_168___r4_ports_6_10_1(obj_t env_567, obj_t port_568)
{
{
obj_t port_612;
port_612 = port_568;
return close_output_port(port_612);
}
}


/* flush-output-port */obj_t flush_output_port_36___r4_ports_6_10_1(obj_t port_26)
{
return FLUSH_OUTPUT_PORT(port_26);
}


/* _flush-output-port1193 */obj_t _flush_output_port1193_67___r4_ports_6_10_1(obj_t env_569, obj_t port_570)
{
{
obj_t port_613;
port_613 = port_570;
return FLUSH_OUTPUT_PORT(port_613);
}
}


/* reset-eof */bool_t reset_eof_236___r4_ports_6_10_1(obj_t port_27)
{
return reset_eof(port_27);
}


/* _reset-eof1194 */obj_t _reset_eof1194_236___r4_ports_6_10_1(obj_t env_571, obj_t port_572)
{
{
bool_t aux_804;
{
obj_t port_614;
port_614 = port_572;
aux_804 = reset_eof(port_614);
}
return BBOOL(aux_804);
}
}


/* input-port-position */int input_port_position_149___r4_ports_6_10_1(obj_t port_28)
{
{
long aux_807;
aux_807 = INPUT_PORT_FILEPOS(port_28);
return (int)(aux_807);
}
}


/* _input-port-position1195 */obj_t _input_port_position1195_70___r4_ports_6_10_1(obj_t env_573, obj_t port_574)
{
{
int aux_810;
{
obj_t port_615;
port_615 = port_574;
{
long aux_811;
aux_811 = INPUT_PORT_FILEPOS(port_615);
aux_810 = (int)(aux_811);
}
}
return BINT(aux_810);
}
}


/* input-port-name */char * input_port_name_249___r4_ports_6_10_1(obj_t port_29)
{
return INPUT_PORT_NAME(port_29);
}


/* _input-port-name1196 */obj_t _input_port_name1196_16___r4_ports_6_10_1(obj_t env_575, obj_t port_576)
{
{
char * aux_816;
{
obj_t port_616;
port_616 = port_576;
aux_816 = INPUT_PORT_NAME(port_616);
}
return string_to_bstring(aux_816);
}
}


/* file-exists? */obj_t file_exists__238___r4_ports_6_10_1(char * name_30)
{
{
bool_t aux_819;
aux_819 = fexists(name_30);
return BBOOL(aux_819);
}
}


/* _file-exists?1197 */obj_t _file_exists_1197_155___r4_ports_6_10_1(obj_t env_577, obj_t name_578)
{
{
char * name_617;
name_617 = BSTRING_TO_STRING(name_578);
{
bool_t aux_823;
aux_823 = fexists(name_617);
return BBOOL(aux_823);
}
}
}


/* append-output-file */obj_t append_output_file_247___r4_ports_6_10_1(obj_t string_31)
{
return append_output_file(string_31);
}


/* _append-output-file1198 */obj_t _append_output_file1198_254___r4_ports_6_10_1(obj_t env_579, obj_t string_580)
{
{
obj_t string_618;
string_618 = string_580;
return append_output_file(string_618);
}
}


/* delete-file */obj_t delete_file_114___r4_ports_6_10_1(char * string_32)
{
{
bool_t aux_828;
aux_828 = unlink(string_32);
return BBOOL(aux_828);
}
}


/* _delete-file1199 */obj_t _delete_file1199_115___r4_ports_6_10_1(obj_t env_581, obj_t string_582)
{
{
char * string_619;
string_619 = BSTRING_TO_STRING(string_582);
{
bool_t aux_832;
aux_832 = unlink(string_619);
return BBOOL(aux_832);
}
}
}


/* delete-directory */obj_t delete_directory_248___r4_ports_6_10_1(char * string_33)
{
{
bool_t aux_835;
aux_835 = rmdir(string_33);
return BBOOL(aux_835);
}
}


/* _delete-directory1200 */obj_t _delete_directory1200_12___r4_ports_6_10_1(obj_t env_583, obj_t string_584)
{
{
char * string_620;
string_620 = BSTRING_TO_STRING(string_584);
{
bool_t aux_839;
aux_839 = rmdir(string_620);
return BBOOL(aux_839);
}
}
}


/* rename-file */obj_t rename_file_185___r4_ports_6_10_1(char * string1_34, char * string2_35)
{
{
bool_t test1058_621;
{
int arg1059_622;
arg1059_622 = rename(string1_34, string2_35);
{
obj_t aux_845;
obj_t aux_843;
aux_845 = BINT(((long)0));
aux_843 = BINT(arg1059_622);
test1058_621 = (aux_843==aux_845);
}
}
if(test1058_621){
return BTRUE;
}
 else {
return BFALSE;
}
}
}


/* _rename-file1201 */obj_t _rename_file1201_157___r4_ports_6_10_1(obj_t env_585, obj_t string1_586, obj_t string2_587)
{
{
char * string1_623;
char * string2_624;
string1_623 = BSTRING_TO_STRING(string1_586);
string2_624 = BSTRING_TO_STRING(string2_587);
{
bool_t test1058_625;
{
int arg1059_626;
arg1059_626 = rename(string1_623, string2_624);
{
obj_t aux_854;
obj_t aux_852;
aux_854 = BINT(((long)0));
aux_852 = BINT(arg1059_626);
test1058_625 = (aux_852==aux_854);
}
}
if(test1058_625){
return BTRUE;
}
 else {
return BFALSE;
}
}
}
}


/* port? */bool_t port__25___r4_ports_6_10_1(obj_t obj_36)
{
{
bool_t _ortest_1020_627;
_ortest_1020_627 = OUTPUT_PORTP(obj_36);
if(_ortest_1020_627){
return _ortest_1020_627;
}
 else {
return INPUT_PORTP(obj_36);
}
}
}


/* _port? */obj_t _port__120___r4_ports_6_10_1(obj_t env_588, obj_t obj_589)
{
{
bool_t aux_861;
{
obj_t obj_628;
obj_628 = obj_589;
{
bool_t _ortest_1020_629;
_ortest_1020_629 = OUTPUT_PORTP(obj_628);
if(_ortest_1020_629){
aux_861 = _ortest_1020_629;
}
 else {
aux_861 = INPUT_PORTP(obj_628);
}
}
}
return BBOOL(aux_861);
}
}


/* directory? */bool_t directory__80___r4_ports_6_10_1(char * string_37)
{
return directoryp(string_37);
}


/* _directory?1202 */obj_t _directory_1202_153___r4_ports_6_10_1(obj_t env_590, obj_t string_591)
{
{
bool_t aux_867;
{
char * string_630;
string_630 = BSTRING_TO_STRING(string_591);
aux_867 = directoryp(string_630);
}
return BBOOL(aux_867);
}
}


/* directory->list */obj_t directory__list_196___r4_ports_6_10_1(char * string_38)
{
return directory_to_list(string_38);
}


/* _directory->list1203 */obj_t _directory__list1203_124___r4_ports_6_10_1(obj_t env_592, obj_t string_593)
{
{
char * string_631;
string_631 = BSTRING_TO_STRING(string_593);
return directory_to_list(string_631);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___r4_ports_6_10_1()
{
return module_initialization_70___error(((long)0), "__R4_PORTS_6_10_1");
}

