/*===========================================================================*/
/*   (Ieee/flonum.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _atan_2fl_ur1178_155___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern double string__real_248___r4_numbers_6_5_flonum(char *);
static obj_t _positivefl_1152_183___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double atan_2fl_180___r4_numbers_6_5_flonum(double, double);
extern double min_2fl_9___r4_numbers_6_5_flonum(double, double);
static obj_t _atan_1fl1176_23___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double atan_1fl_210___r4_numbers_6_5_flonum(double);
extern double expfl___r4_numbers_6_5_flonum(double);
extern obj_t make_real(double);
extern char * real__string_120___r4_numbers_6_5_flonum(double);
static obj_t _negativefl_1153_159___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _logfl1169___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _expfl1168___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _sqrtfl_ur1180_42___r4_numbers_6_5_flonum(obj_t, obj_t);
extern bool_t __fl_116___r4_numbers_6_5_flonum(double, double);
static obj_t _truncatefl1166___r4_numbers_6_5_flonum(obj_t, obj_t);
extern bool_t negativefl__17___r4_numbers_6_5_flonum(double);
static obj_t __fl1154_212___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
static obj_t __fl1155_74___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern bool_t _fl_187___r4_numbers_6_5_flonum(double, double);
extern double atanfl___r4_numbers_6_5_flonum(double, obj_t);
static obj_t __fl1157_23___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern bool_t _fl_139___r4_numbers_6_5_flonum(double, double);
extern double logfl___r4_numbers_6_5_flonum(double);
static obj_t _exptfl1181___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern bool_t zerofl__232___r4_numbers_6_5_flonum(double);
extern double ceilingfl___r4_numbers_6_5_flonum(double);
extern bool_t _fl_236___r4_numbers_6_5_flonum(double, double);
static obj_t __fl1146_116___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern double tanfl___r4_numbers_6_5_flonum(double);
extern bool_t positivefl__131___r4_numbers_6_5_flonum(double);
extern double maxfl___r4_numbers_6_5_flonum(double, obj_t);
extern obj_t string_to_bstring(char *);
static obj_t ___fl1149_59___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern double negfl___r4_numbers_6_5_flonum(double);
static obj_t _cosfl1171___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _minfl1162___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
static obj_t _real__string1183_229___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _flonum__86___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _asinfl1173___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double atan_2fl_ur_116___r4_numbers_6_5_flonum(double, double);
extern double floorfl___r4_numbers_6_5_flonum(double);
static obj_t _sqrtfl1179___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double exptfl___r4_numbers_6_5_flonum(double, double);
extern double acosfl___r4_numbers_6_5_flonum(double);
static obj_t _min_2fl1161_113___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
static obj_t ___fl1150_133___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
static obj_t _tanfl1172___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double sqrtfl___r4_numbers_6_5_flonum(double);
extern obj_t module_initialization_70___r4_numbers_6_5_flonum(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern double asinfl___r4_numbers_6_5_flonum(double);
static obj_t _atan_2fl1177_21___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern double cosfl___r4_numbers_6_5_flonum(double);
extern double absfl___r4_numbers_6_5_flonum(double);
extern bool_t flonum__164___r4_numbers_6_5_flonum(obj_t);
static obj_t __fl1156_249___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern double sinfl___r4_numbers_6_5_flonum(double);
static obj_t _ceilingfl1165___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _negfl1158___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double max_2fl_226___r4_numbers_6_5_flonum(double, double);
static obj_t _floorfl1164___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _real__79___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _max_2fl1160_230___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern double roundfl___r4_numbers_6_5_flonum(double);
extern double sqrtfl_ur_118___r4_numbers_6_5_flonum(double);
static obj_t _zerofl_1151_199___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _roundfl1167___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _string__real1182_108___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double _fl_4___r4_numbers_6_5_flonum(double, double);
extern bool_t real__243___r4_numbers_6_5_flonum(obj_t);
static obj_t __fl1147_90___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
static obj_t __fl1148_229___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern double truncatefl___r4_numbers_6_5_flonum(double);
static obj_t imported_modules_init_94___r4_numbers_6_5_flonum();
static obj_t _absfl1163___r4_numbers_6_5_flonum(obj_t, obj_t);
static obj_t _acosfl1174___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double _fl_24___r4_numbers_6_5_flonum(double, double);
extern bool_t __fl_135___r4_numbers_6_5_flonum(double, double);
static obj_t require_initialization_114___r4_numbers_6_5_flonum = BUNSPEC;
extern double minfl___r4_numbers_6_5_flonum(double, obj_t);
extern double _fl_172___r4_numbers_6_5_flonum(double, double);
static obj_t _maxfl1159___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
extern char * real_to_string(double);
static obj_t _sinfl1170___r4_numbers_6_5_flonum(obj_t, obj_t);
extern double _fl_93___r4_numbers_6_5_flonum(double, double);
static obj_t _atanfl1175___r4_numbers_6_5_flonum(obj_t, obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( __fl_env_18___r4_numbers_6_5_flonum, ___fl1149_59___r4_numbers_6_5_flonum1189, ___fl1149_59___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( atan_1fl_env_38___r4_numbers_6_5_flonum, _atan_1fl1176_23___r4_numbers_6_5_flonum1190, _atan_1fl1176_23___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( _fl_env_116___r4_numbers_6_5_flonum, __fl1146_116___r4_numbers_6_5_flonum1191, __fl1146_116___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( truncatefl_env_152___r4_numbers_6_5_flonum, _truncatefl1166___r4_numbers_6_5_flonum1192, _truncatefl1166___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( atan_2fl_ur_env_159___r4_numbers_6_5_flonum, _atan_2fl_ur1178_155___r4_numbers_6_5_flonum1193, _atan_2fl_ur1178_155___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( exptfl_env_131___r4_numbers_6_5_flonum, _exptfl1181___r4_numbers_6_5_flonum1194, _exptfl1181___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ceilingfl_env_56___r4_numbers_6_5_flonum, _ceilingfl1165___r4_numbers_6_5_flonum1195, _ceilingfl1165___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( positivefl__env_91___r4_numbers_6_5_flonum, _positivefl_1152_183___r4_numbers_6_5_flonum1196, _positivefl_1152_183___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( __fl_env_159___r4_numbers_6_5_flonum, ___fl1150_133___r4_numbers_6_5_flonum1197, ___fl1150_133___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( flonum__env_208___r4_numbers_6_5_flonum, _flonum__86___r4_numbers_6_5_flonum1198, _flonum__86___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_REAL( real1186___r4_numbers_6_5_flonum, real1186___r4_numbers_6_5_flonum1199, 0.0 );
DEFINE_EXPORT_PROCEDURE( min_2fl_env_107___r4_numbers_6_5_flonum, _min_2fl1161_113___r4_numbers_6_5_flonum1200, _min_2fl1161_113___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( real__string_env_192___r4_numbers_6_5_flonum, _real__string1183_229___r4_numbers_6_5_flonum1201, _real__string1183_229___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( cosfl_env_144___r4_numbers_6_5_flonum, _cosfl1171___r4_numbers_6_5_flonum1202, _cosfl1171___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( minfl_env_220___r4_numbers_6_5_flonum, _minfl1162___r4_numbers_6_5_flonum1203, va_generic_entry, _minfl1162___r4_numbers_6_5_flonum, -2 );
DEFINE_EXPORT_PROCEDURE( negativefl__env_195___r4_numbers_6_5_flonum, _negativefl_1153_159___r4_numbers_6_5_flonum1204, _negativefl_1153_159___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( asinfl_env_147___r4_numbers_6_5_flonum, _asinfl1173___r4_numbers_6_5_flonum1205, _asinfl1173___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( tanfl_env_187___r4_numbers_6_5_flonum, _tanfl1172___r4_numbers_6_5_flonum1206, _tanfl1172___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( sqrtfl_env_132___r4_numbers_6_5_flonum, _sqrtfl1179___r4_numbers_6_5_flonum1207, _sqrtfl1179___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( floorfl_env_65___r4_numbers_6_5_flonum, _floorfl1164___r4_numbers_6_5_flonum1208, _floorfl1164___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( max_2fl_env_222___r4_numbers_6_5_flonum, _max_2fl1160_230___r4_numbers_6_5_flonum1209, _max_2fl1160_230___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( _fl_env_209___r4_numbers_6_5_flonum, __fl1156_249___r4_numbers_6_5_flonum1210, __fl1156_249___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( zerofl__env_96___r4_numbers_6_5_flonum, _zerofl_1151_199___r4_numbers_6_5_flonum1211, _zerofl_1151_199___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( roundfl_env_120___r4_numbers_6_5_flonum, _roundfl1167___r4_numbers_6_5_flonum1212, _roundfl1167___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( real__env_20___r4_numbers_6_5_flonum, _real__79___r4_numbers_6_5_flonum1213, _real__79___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( negfl_env_102___r4_numbers_6_5_flonum, _negfl1158___r4_numbers_6_5_flonum1214, _negfl1158___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string__real_env_124___r4_numbers_6_5_flonum, _string__real1182_108___r4_numbers_6_5_flonum1215, _string__real1182_108___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( atan_2fl_env_154___r4_numbers_6_5_flonum, _atan_2fl1177_21___r4_numbers_6_5_flonum1216, _atan_2fl1177_21___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( _fl_env_94___r4_numbers_6_5_flonum, __fl1147_90___r4_numbers_6_5_flonum1217, __fl1147_90___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( _fl_env_151___r4_numbers_6_5_flonum, __fl1148_229___r4_numbers_6_5_flonum1218, __fl1148_229___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( sqrtfl_ur_env_220___r4_numbers_6_5_flonum, _sqrtfl_ur1180_42___r4_numbers_6_5_flonum1219, _sqrtfl_ur1180_42___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( absfl_env_6___r4_numbers_6_5_flonum, _absfl1163___r4_numbers_6_5_flonum1220, _absfl1163___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( maxfl_env_160___r4_numbers_6_5_flonum, _maxfl1159___r4_numbers_6_5_flonum1221, va_generic_entry, _maxfl1159___r4_numbers_6_5_flonum, -2 );
DEFINE_EXPORT_PROCEDURE( acosfl_env_181___r4_numbers_6_5_flonum, _acosfl1174___r4_numbers_6_5_flonum1222, _acosfl1174___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( sinfl_env_77___r4_numbers_6_5_flonum, _sinfl1170___r4_numbers_6_5_flonum1223, _sinfl1170___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( atanfl_env_100___r4_numbers_6_5_flonum, _atanfl1175___r4_numbers_6_5_flonum1224, va_generic_entry, _atanfl1175___r4_numbers_6_5_flonum, -2 );
DEFINE_STRING( string1187___r4_numbers_6_5_flonum, string1187___r4_numbers_6_5_flonum1225, "sqrtfl", 6 );
DEFINE_STRING( string1185___r4_numbers_6_5_flonum, string1185___r4_numbers_6_5_flonum1226, "Domain error", 12 );
DEFINE_STRING( string1184___r4_numbers_6_5_flonum, string1184___r4_numbers_6_5_flonum1227, "atanfl", 6 );
DEFINE_EXPORT_PROCEDURE( _fl_env_224___r4_numbers_6_5_flonum, __fl1154_212___r4_numbers_6_5_flonum1228, __fl1154_212___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( logfl_env_16___r4_numbers_6_5_flonum, _logfl1169___r4_numbers_6_5_flonum1229, _logfl1169___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( expfl_env_156___r4_numbers_6_5_flonum, _expfl1168___r4_numbers_6_5_flonum1230, _expfl1168___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( _fl_env_6___r4_numbers_6_5_flonum, __fl1155_74___r4_numbers_6_5_flonum1231, __fl1155_74___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( _fl_env_235___r4_numbers_6_5_flonum, __fl1157_23___r4_numbers_6_5_flonum1232, __fl1157_23___r4_numbers_6_5_flonum, 0L, 2 );


/* module-initialization */obj_t module_initialization_70___r4_numbers_6_5_flonum(long checksum_634, char * from_635)
{
if(CBOOL(require_initialization_114___r4_numbers_6_5_flonum)){
require_initialization_114___r4_numbers_6_5_flonum = BBOOL(((bool_t)0));
imported_modules_init_94___r4_numbers_6_5_flonum();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* real? */bool_t real__243___r4_numbers_6_5_flonum(obj_t obj_1)
{
if(INTEGERP(obj_1)){
return ((bool_t)1);
}
 else {
return REALP(obj_1);
}
}


/* _real? */obj_t _real__79___r4_numbers_6_5_flonum(obj_t env_486, obj_t obj_487)
{
{
bool_t aux_643;
{
obj_t obj_583;
obj_583 = obj_487;
if(INTEGERP(obj_583)){
aux_643 = ((bool_t)1);
}
 else {
aux_643 = REALP(obj_583);
}
}
return BBOOL(aux_643);
}
}


/* flonum? */bool_t flonum__164___r4_numbers_6_5_flonum(obj_t obj_2)
{
return REALP(obj_2);
}


/* _flonum? */obj_t _flonum__86___r4_numbers_6_5_flonum(obj_t env_488, obj_t obj_489)
{
{
bool_t aux_649;
{
obj_t obj_584;
obj_584 = obj_489;
aux_649 = REALP(obj_584);
}
return BBOOL(aux_649);
}
}


/* =fl */bool_t _fl_139___r4_numbers_6_5_flonum(double r1_3, double r2_4)
{
return (r1_3==r2_4);
}


/* _=fl1146 */obj_t __fl1146_116___r4_numbers_6_5_flonum(obj_t env_490, obj_t r1_491, obj_t r2_492)
{
{
bool_t aux_653;
{
double r1_585;
double r2_586;
r1_585 = REAL_TO_DOUBLE(r1_491);
r2_586 = REAL_TO_DOUBLE(r2_492);
aux_653 = (r1_585==r2_586);
}
return BBOOL(aux_653);
}
}


/* <fl */bool_t _fl_236___r4_numbers_6_5_flonum(double r1_5, double r2_6)
{
return (r1_5<r2_6);
}


/* _<fl1147 */obj_t __fl1147_90___r4_numbers_6_5_flonum(obj_t env_493, obj_t r1_494, obj_t r2_495)
{
{
bool_t aux_659;
{
double r1_587;
double r2_588;
r1_587 = REAL_TO_DOUBLE(r1_494);
r2_588 = REAL_TO_DOUBLE(r2_495);
aux_659 = (r1_587<r2_588);
}
return BBOOL(aux_659);
}
}


/* >fl */bool_t _fl_187___r4_numbers_6_5_flonum(double r1_7, double r2_8)
{
return (r1_7>r2_8);
}


/* _>fl1148 */obj_t __fl1148_229___r4_numbers_6_5_flonum(obj_t env_496, obj_t r1_497, obj_t r2_498)
{
{
bool_t aux_665;
{
double r1_589;
double r2_590;
r1_589 = REAL_TO_DOUBLE(r1_497);
r2_590 = REAL_TO_DOUBLE(r2_498);
aux_665 = (r1_589>r2_590);
}
return BBOOL(aux_665);
}
}


/* <=fl */bool_t __fl_135___r4_numbers_6_5_flonum(double r1_9, double r2_10)
{
return (r1_9<=r2_10);
}


/* _<=fl1149 */obj_t ___fl1149_59___r4_numbers_6_5_flonum(obj_t env_499, obj_t r1_500, obj_t r2_501)
{
{
bool_t aux_671;
{
double r1_591;
double r2_592;
r1_591 = REAL_TO_DOUBLE(r1_500);
r2_592 = REAL_TO_DOUBLE(r2_501);
aux_671 = (r1_591<=r2_592);
}
return BBOOL(aux_671);
}
}


/* >=fl */bool_t __fl_116___r4_numbers_6_5_flonum(double r1_11, double r2_12)
{
return (r1_11>=r2_12);
}


/* _>=fl1150 */obj_t ___fl1150_133___r4_numbers_6_5_flonum(obj_t env_502, obj_t r1_503, obj_t r2_504)
{
{
bool_t aux_677;
{
double r1_593;
double r2_594;
r1_593 = REAL_TO_DOUBLE(r1_503);
r2_594 = REAL_TO_DOUBLE(r2_504);
aux_677 = (r1_593>=r2_594);
}
return BBOOL(aux_677);
}
}


/* zerofl? */bool_t zerofl__232___r4_numbers_6_5_flonum(double r_13)
{
return (r_13==((double)0.0));
}


/* _zerofl?1151 */obj_t _zerofl_1151_199___r4_numbers_6_5_flonum(obj_t env_505, obj_t r_506)
{
{
bool_t aux_683;
{
double r_595;
r_595 = REAL_TO_DOUBLE(r_506);
aux_683 = (r_595==((double)0.0));
}
return BBOOL(aux_683);
}
}


/* positivefl? */bool_t positivefl__131___r4_numbers_6_5_flonum(double r_14)
{
return (r_14>((double)0.0));
}


/* _positivefl?1152 */obj_t _positivefl_1152_183___r4_numbers_6_5_flonum(obj_t env_507, obj_t r_508)
{
{
bool_t aux_688;
{
double r_596;
r_596 = REAL_TO_DOUBLE(r_508);
aux_688 = (r_596>((double)0.0));
}
return BBOOL(aux_688);
}
}


/* negativefl? */bool_t negativefl__17___r4_numbers_6_5_flonum(double r_15)
{
return (r_15<((double)0.0));
}


/* _negativefl?1153 */obj_t _negativefl_1153_159___r4_numbers_6_5_flonum(obj_t env_509, obj_t r_510)
{
{
bool_t aux_693;
{
double r_597;
r_597 = REAL_TO_DOUBLE(r_510);
aux_693 = (r_597<((double)0.0));
}
return BBOOL(aux_693);
}
}


/* +fl */double _fl_172___r4_numbers_6_5_flonum(double r1_16, double r2_17)
{
return (r1_16+r2_17);
}


/* _+fl1154 */obj_t __fl1154_212___r4_numbers_6_5_flonum(obj_t env_511, obj_t r1_512, obj_t r2_513)
{
{
double aux_698;
{
double r1_598;
double r2_599;
r1_598 = REAL_TO_DOUBLE(r1_512);
r2_599 = REAL_TO_DOUBLE(r2_513);
aux_698 = (r1_598+r2_599);
}
return make_real(aux_698);
}
}


/* -fl */double _fl_24___r4_numbers_6_5_flonum(double r1_18, double r2_19)
{
return (r1_18-r2_19);
}


/* _-fl1155 */obj_t __fl1155_74___r4_numbers_6_5_flonum(obj_t env_514, obj_t r1_515, obj_t r2_516)
{
{
double aux_704;
{
double r1_600;
double r2_601;
r1_600 = REAL_TO_DOUBLE(r1_515);
r2_601 = REAL_TO_DOUBLE(r2_516);
aux_704 = (r1_600-r2_601);
}
return make_real(aux_704);
}
}


/* *fl */double _fl_93___r4_numbers_6_5_flonum(double r1_20, double r2_21)
{
return (r1_20*r2_21);
}


/* _*fl1156 */obj_t __fl1156_249___r4_numbers_6_5_flonum(obj_t env_517, obj_t r1_518, obj_t r2_519)
{
{
double aux_710;
{
double r1_602;
double r2_603;
r1_602 = REAL_TO_DOUBLE(r1_518);
r2_603 = REAL_TO_DOUBLE(r2_519);
aux_710 = (r1_602*r2_603);
}
return make_real(aux_710);
}
}


/* /fl */double _fl_4___r4_numbers_6_5_flonum(double r1_22, double r2_23)
{
return (r1_22/r2_23);
}


/* _/fl1157 */obj_t __fl1157_23___r4_numbers_6_5_flonum(obj_t env_520, obj_t r1_521, obj_t r2_522)
{
{
double aux_716;
{
double r1_604;
double r2_605;
r1_604 = REAL_TO_DOUBLE(r1_521);
r2_605 = REAL_TO_DOUBLE(r2_522);
aux_716 = (r1_604/r2_605);
}
return make_real(aux_716);
}
}


/* negfl */double negfl___r4_numbers_6_5_flonum(double r1_24)
{
return NEG(r1_24);
}


/* _negfl1158 */obj_t _negfl1158___r4_numbers_6_5_flonum(obj_t env_523, obj_t r1_524)
{
{
double aux_722;
{
double r1_606;
r1_606 = REAL_TO_DOUBLE(r1_524);
aux_722 = NEG(r1_606);
}
return make_real(aux_722);
}
}


/* maxfl */double maxfl___r4_numbers_6_5_flonum(double r1_25, obj_t rn_26)
{
{
obj_t max_266;
obj_t rn_267;
{
obj_t aux_726;
max_266 = make_real(r1_25);
rn_267 = rn_26;
loop_268:
if(NULLP(rn_267)){
aux_726 = max_266;
}
 else {
bool_t test_729;
{
double aux_734;
double aux_730;
aux_734 = REAL_TO_DOUBLE(max_266);
{
obj_t aux_731;
aux_731 = CAR(rn_267);
aux_730 = REAL_TO_DOUBLE(aux_731);
}
test_729 = (aux_730>aux_734);
}
if(test_729){
obj_t rn_739;
obj_t max_737;
max_737 = CAR(rn_267);
rn_739 = CDR(rn_267);
rn_267 = rn_739;
max_266 = max_737;
goto loop_268;
}
 else {
obj_t rn_741;
rn_741 = CDR(rn_267);
rn_267 = rn_741;
goto loop_268;
}
}
return REAL_TO_DOUBLE(aux_726);
}
}
}


/* _maxfl1159 */obj_t _maxfl1159___r4_numbers_6_5_flonum(obj_t env_525, obj_t r1_526, obj_t rn_527)
{
{
double aux_745;
aux_745 = maxfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r1_526), rn_527);
return make_real(aux_745);
}
}


/* max-2fl */double max_2fl_226___r4_numbers_6_5_flonum(double r1_27, double r2_28)
{
if((r1_27>r2_28)){
return r1_27;
}
 else {
return r2_28;
}
}


/* _max-2fl1160 */obj_t _max_2fl1160_230___r4_numbers_6_5_flonum(obj_t env_528, obj_t r1_529, obj_t r2_530)
{
{
double aux_751;
{
double r1_607;
double r2_608;
r1_607 = REAL_TO_DOUBLE(r1_529);
r2_608 = REAL_TO_DOUBLE(r2_530);
if((r1_607>r2_608)){
aux_751 = r1_607;
}
 else {
aux_751 = r2_608;
}
}
return make_real(aux_751);
}
}


/* min-2fl */double min_2fl_9___r4_numbers_6_5_flonum(double r1_29, double r2_30)
{
if((r1_29>r2_30)){
return r2_30;
}
 else {
return r1_29;
}
}


/* _min-2fl1161 */obj_t _min_2fl1161_113___r4_numbers_6_5_flonum(obj_t env_531, obj_t r1_532, obj_t r2_533)
{
{
double aux_759;
{
double r1_609;
double r2_610;
r1_609 = REAL_TO_DOUBLE(r1_532);
r2_610 = REAL_TO_DOUBLE(r2_533);
if((r1_609>r2_610)){
aux_759 = r2_610;
}
 else {
aux_759 = r1_609;
}
}
return make_real(aux_759);
}
}


/* minfl */double minfl___r4_numbers_6_5_flonum(double r1_31, obj_t rn_32)
{
{
obj_t min_277;
obj_t rn_278;
{
obj_t aux_765;
min_277 = make_real(r1_31);
rn_278 = rn_32;
loop_279:
if(NULLP(rn_278)){
aux_765 = min_277;
}
 else {
bool_t test_768;
{
double aux_773;
double aux_769;
aux_773 = REAL_TO_DOUBLE(min_277);
{
obj_t aux_770;
aux_770 = CAR(rn_278);
aux_769 = REAL_TO_DOUBLE(aux_770);
}
test_768 = (aux_769<aux_773);
}
if(test_768){
obj_t rn_778;
obj_t min_776;
min_776 = CAR(rn_278);
rn_778 = CDR(rn_278);
rn_278 = rn_778;
min_277 = min_776;
goto loop_279;
}
 else {
obj_t rn_780;
rn_780 = CDR(rn_278);
rn_278 = rn_780;
goto loop_279;
}
}
return REAL_TO_DOUBLE(aux_765);
}
}
}


/* _minfl1162 */obj_t _minfl1162___r4_numbers_6_5_flonum(obj_t env_534, obj_t r1_535, obj_t rn_536)
{
{
double aux_784;
aux_784 = minfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r1_535), rn_536);
return make_real(aux_784);
}
}


/* absfl */double absfl___r4_numbers_6_5_flonum(double r_33)
{
if((r_33<((double)0.0))){
return NEG(r_33);
}
 else {
return r_33;
}
}


/* _absfl1163 */obj_t _absfl1163___r4_numbers_6_5_flonum(obj_t env_537, obj_t r_538)
{
{
double aux_791;
{
double r_611;
r_611 = REAL_TO_DOUBLE(r_538);
if((r_611<((double)0.0))){
aux_791 = NEG(r_611);
}
 else {
aux_791 = r_611;
}
}
return make_real(aux_791);
}
}


/* floorfl */double floorfl___r4_numbers_6_5_flonum(double r_34)
{
return floor(r_34);
}


/* _floorfl1164 */obj_t _floorfl1164___r4_numbers_6_5_flonum(obj_t env_539, obj_t r_540)
{
{
double aux_798;
{
double r_612;
r_612 = REAL_TO_DOUBLE(r_540);
aux_798 = floor(r_612);
}
return make_real(aux_798);
}
}


/* ceilingfl */double ceilingfl___r4_numbers_6_5_flonum(double r_35)
{
return ceil(r_35);
}


/* _ceilingfl1165 */obj_t _ceilingfl1165___r4_numbers_6_5_flonum(obj_t env_541, obj_t r_542)
{
{
double aux_803;
{
double r_613;
r_613 = REAL_TO_DOUBLE(r_542);
aux_803 = ceil(r_613);
}
return make_real(aux_803);
}
}


/* truncatefl */double truncatefl___r4_numbers_6_5_flonum(double r_36)
{
if((r_36<((double)0.0))){
return ceil(r_36);
}
 else {
return floor(r_36);
}
}


/* _truncatefl1166 */obj_t _truncatefl1166___r4_numbers_6_5_flonum(obj_t env_543, obj_t r_544)
{
{
double aux_811;
{
double r_614;
r_614 = REAL_TO_DOUBLE(r_544);
if((r_614<((double)0.0))){
aux_811 = ceil(r_614);
}
 else {
aux_811 = floor(r_614);
}
}
return make_real(aux_811);
}
}


/* roundfl */double roundfl___r4_numbers_6_5_flonum(double r_37)
{
{
double aux_818;
aux_818 = (r_37+((double)0.5));
return floor(aux_818);
}
}


/* _roundfl1167 */obj_t _roundfl1167___r4_numbers_6_5_flonum(obj_t env_545, obj_t r_546)
{
{
double aux_821;
{
double r_615;
r_615 = REAL_TO_DOUBLE(r_546);
{
double aux_823;
aux_823 = (r_615+((double)0.5));
aux_821 = floor(aux_823);
}
}
return make_real(aux_821);
}
}


/* expfl */double expfl___r4_numbers_6_5_flonum(double x_38)
{
return exp(x_38);
}


/* _expfl1168 */obj_t _expfl1168___r4_numbers_6_5_flonum(obj_t env_547, obj_t x_548)
{
{
double aux_828;
{
double x_616;
x_616 = REAL_TO_DOUBLE(x_548);
aux_828 = exp(x_616);
}
return make_real(aux_828);
}
}


/* logfl */double logfl___r4_numbers_6_5_flonum(double x_39)
{
return log(x_39);
}


/* _logfl1169 */obj_t _logfl1169___r4_numbers_6_5_flonum(obj_t env_549, obj_t x_550)
{
{
double aux_833;
{
double x_617;
x_617 = REAL_TO_DOUBLE(x_550);
aux_833 = log(x_617);
}
return make_real(aux_833);
}
}


/* sinfl */double sinfl___r4_numbers_6_5_flonum(double x_40)
{
return sin(x_40);
}


/* _sinfl1170 */obj_t _sinfl1170___r4_numbers_6_5_flonum(obj_t env_551, obj_t x_552)
{
{
double aux_838;
{
double x_618;
x_618 = REAL_TO_DOUBLE(x_552);
aux_838 = sin(x_618);
}
return make_real(aux_838);
}
}


/* cosfl */double cosfl___r4_numbers_6_5_flonum(double x_41)
{
return cos(x_41);
}


/* _cosfl1171 */obj_t _cosfl1171___r4_numbers_6_5_flonum(obj_t env_553, obj_t x_554)
{
{
double aux_843;
{
double x_619;
x_619 = REAL_TO_DOUBLE(x_554);
aux_843 = cos(x_619);
}
return make_real(aux_843);
}
}


/* tanfl */double tanfl___r4_numbers_6_5_flonum(double x_42)
{
return tan(x_42);
}


/* _tanfl1172 */obj_t _tanfl1172___r4_numbers_6_5_flonum(obj_t env_555, obj_t x_556)
{
{
double aux_848;
{
double x_620;
x_620 = REAL_TO_DOUBLE(x_556);
aux_848 = tan(x_620);
}
return make_real(aux_848);
}
}


/* asinfl */double asinfl___r4_numbers_6_5_flonum(double x_43)
{
return asin(x_43);
}


/* _asinfl1173 */obj_t _asinfl1173___r4_numbers_6_5_flonum(obj_t env_557, obj_t x_558)
{
{
double aux_853;
{
double x_621;
x_621 = REAL_TO_DOUBLE(x_558);
aux_853 = asin(x_621);
}
return make_real(aux_853);
}
}


/* acosfl */double acosfl___r4_numbers_6_5_flonum(double x_44)
{
return acos(x_44);
}


/* _acosfl1174 */obj_t _acosfl1174___r4_numbers_6_5_flonum(obj_t env_559, obj_t x_560)
{
{
double aux_858;
{
double x_622;
x_622 = REAL_TO_DOUBLE(x_560);
aux_858 = acos(x_622);
}
return make_real(aux_858);
}
}


/* atanfl */double atanfl___r4_numbers_6_5_flonum(double x_45, obj_t y_46)
{
if(NULLP(y_46)){
return atan(x_45);
}
 else {
double aux_865;
{
obj_t aux_866;
aux_866 = CAR(y_46);
aux_865 = REAL_TO_DOUBLE(aux_866);
}
return atan2(x_45, aux_865);
}
}


/* _atanfl1175 */obj_t _atanfl1175___r4_numbers_6_5_flonum(obj_t env_561, obj_t x_562, obj_t y_563)
{
{
double aux_870;
aux_870 = atanfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_562), y_563);
return make_real(aux_870);
}
}


/* atan-1fl */double atan_1fl_210___r4_numbers_6_5_flonum(double x_47)
{
return atan(x_47);
}


/* _atan-1fl1176 */obj_t _atan_1fl1176_23___r4_numbers_6_5_flonum(obj_t env_564, obj_t x_565)
{
{
double aux_875;
{
double x_623;
x_623 = REAL_TO_DOUBLE(x_565);
aux_875 = atan(x_623);
}
return make_real(aux_875);
}
}


/* atan-2fl */double atan_2fl_180___r4_numbers_6_5_flonum(double x_48, double y_49)
{
{
bool_t test_879;
if((x_48==((double)0.0))){
test_879 = (y_49==((double)0.0));
}
 else {
test_879 = ((bool_t)0);
}
if(test_879){
FAILURE(string1184___r4_numbers_6_5_flonum,string1185___r4_numbers_6_5_flonum,real1186___r4_numbers_6_5_flonum);}
 else {
return atan2(x_48, y_49);
}
}
}


/* _atan-2fl1177 */obj_t _atan_2fl1177_21___r4_numbers_6_5_flonum(obj_t env_566, obj_t x_567, obj_t y_568)
{
{
double aux_885;
{
double x_624;
double y_625;
x_624 = REAL_TO_DOUBLE(x_567);
y_625 = REAL_TO_DOUBLE(y_568);
{
bool_t test_888;
if((x_624==((double)0.0))){
test_888 = (y_625==((double)0.0));
}
 else {
test_888 = ((bool_t)0);
}
if(test_888){
FAILURE(string1184___r4_numbers_6_5_flonum,string1185___r4_numbers_6_5_flonum,real1186___r4_numbers_6_5_flonum);}
 else {
aux_885 = atan2(x_624, y_625);
}
}
}
return make_real(aux_885);
}
}


/* atan-2fl-ur */double atan_2fl_ur_116___r4_numbers_6_5_flonum(double x_50, double y_51)
{
return atan2(x_50, y_51);
}


/* _atan-2fl-ur1178 */obj_t _atan_2fl_ur1178_155___r4_numbers_6_5_flonum(obj_t env_569, obj_t x_570, obj_t y_571)
{
{
double aux_896;
{
double x_626;
double y_627;
x_626 = REAL_TO_DOUBLE(x_570);
y_627 = REAL_TO_DOUBLE(y_571);
aux_896 = atan2(x_626, y_627);
}
return make_real(aux_896);
}
}


/* sqrtfl */double sqrtfl___r4_numbers_6_5_flonum(double r_52)
{
if((r_52<((double)0.0))){
FAILURE(string1187___r4_numbers_6_5_flonum,string1185___r4_numbers_6_5_flonum,make_real(r_52));}
 else {
return sqrt(r_52);
}
}


/* _sqrtfl1179 */obj_t _sqrtfl1179___r4_numbers_6_5_flonum(obj_t env_572, obj_t r_573)
{
{
double aux_906;
{
double r_628;
r_628 = REAL_TO_DOUBLE(r_573);
if((r_628<((double)0.0))){
FAILURE(string1187___r4_numbers_6_5_flonum,string1185___r4_numbers_6_5_flonum,make_real(r_628));}
 else {
aux_906 = sqrt(r_628);
}
}
return make_real(aux_906);
}
}


/* sqrtfl-ur */double sqrtfl_ur_118___r4_numbers_6_5_flonum(double r_53)
{
return sqrt(r_53);
}


/* _sqrtfl-ur1180 */obj_t _sqrtfl_ur1180_42___r4_numbers_6_5_flonum(obj_t env_574, obj_t r_575)
{
{
double aux_915;
{
double r_629;
r_629 = REAL_TO_DOUBLE(r_575);
aux_915 = sqrt(r_629);
}
return make_real(aux_915);
}
}


/* exptfl */double exptfl___r4_numbers_6_5_flonum(double r1_54, double r2_55)
{
return pow(r1_54, r2_55);
}


/* _exptfl1181 */obj_t _exptfl1181___r4_numbers_6_5_flonum(obj_t env_576, obj_t r1_577, obj_t r2_578)
{
{
double aux_920;
{
double r1_630;
double r2_631;
r1_630 = REAL_TO_DOUBLE(r1_577);
r2_631 = REAL_TO_DOUBLE(r2_578);
aux_920 = pow(r1_630, r2_631);
}
return make_real(aux_920);
}
}


/* string->real */double string__real_248___r4_numbers_6_5_flonum(char * string_56)
{
return strtod(string_56, ((long)0));
}


/* _string->real1182 */obj_t _string__real1182_108___r4_numbers_6_5_flonum(obj_t env_579, obj_t string_580)
{
{
double aux_926;
{
char * string_632;
string_632 = BSTRING_TO_STRING(string_580);
aux_926 = strtod(string_632, ((long)0));
}
return make_real(aux_926);
}
}


/* real->string */char * real__string_120___r4_numbers_6_5_flonum(double real_57)
{
return real_to_string(real_57);
}


/* _real->string1183 */obj_t _real__string1183_229___r4_numbers_6_5_flonum(obj_t env_581, obj_t real_582)
{
{
char * aux_931;
{
double real_633;
real_633 = REAL_TO_DOUBLE(real_582);
aux_931 = real_to_string(real_633);
}
return string_to_bstring(aux_931);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___r4_numbers_6_5_flonum()
{
return module_initialization_70___error(((long)0), "__R4_NUMBERS_6_5_FLONUM");
}

