/*===========================================================================*/
/*   (Ieee/fixnum.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _positivefx_1224_77___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t ___fx1222_22___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static obj_t _gcd___r4_numbers_6_5_fixnum(obj_t, obj_t);
extern obj_t make_elong_201___r4_numbers_6_5_fixnum(long);
static obj_t _remainder1237___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static obj_t _fixnum__233___r4_numbers_6_5_fixnum(obj_t, obj_t);
extern char * integer_to_string(long, long);
extern bool_t negativefx__232___r4_numbers_6_5_fixnum(long);
static obj_t _negativefx_1225_197___r4_numbers_6_5_fixnum(obj_t, obj_t);
extern bool_t __fx_254___r4_numbers_6_5_fixnum(long, long);
extern bool_t _fx_24___r4_numbers_6_5_fixnum(long, long);
static obj_t __fx1232_37___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern obj_t string__llong_61___r4_numbers_6_5_fixnum(char *, obj_t);
extern bool_t zerofx__17___r4_numbers_6_5_fixnum(long);
static obj_t _negfx1234___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t _modulo1238___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern bool_t even__46___r4_numbers_6_5_fixnum(long);
extern bool_t _fx_134___r4_numbers_6_5_fixnum(long, long);
extern bool_t _fx_179___r4_numbers_6_5_fixnum(long, long);
extern bool_t positivefx__200___r4_numbers_6_5_fixnum(long);
extern bool_t fixnum__102___r4_numbers_6_5_fixnum(obj_t);
static obj_t __fx1219_241___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern long maxfx___r4_numbers_6_5_fixnum(long, obj_t);
extern char * integer__string_135___r4_numbers_6_5_fixnum(long, obj_t);
static obj_t __fx1220_209___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern obj_t string_to_bstring(char *);
static obj_t _integer__27___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t _absfx1235___r4_numbers_6_5_fixnum(obj_t, obj_t);
extern long negfx___r4_numbers_6_5_fixnum(long);
static obj_t _even_1227_181___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t _quotient1236___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static obj_t _maxfx1228___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern bool_t integer__108___r4_numbers_6_5_fixnum(obj_t);
extern bool_t elong__154___r4_numbers_6_5_fixnum(obj_t);
extern obj_t module_initialization_70___r4_numbers_6_5_fixnum(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _string__llong1242_115___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern obj_t string__elong_120___r4_numbers_6_5_fixnum(char *, obj_t);
extern long absfx___r4_numbers_6_5_fixnum(long);
extern long lcm___r4_numbers_6_5_fixnum(obj_t);
static obj_t _integer__string1239_82___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern long list_length(obj_t);
extern bool_t llong__230___r4_numbers_6_5_fixnum(obj_t);
static obj_t __fx1230_170___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static obj_t _elong__107___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t __fx1231_165___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static obj_t __fx1233_11___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static obj_t _zerofx_1223_33___r4_numbers_6_5_fixnum(obj_t, obj_t);
extern long _fx_61___r4_numbers_6_5_fixnum(long, long);
extern long string__integer_39___r4_numbers_6_5_fixnum(char *, obj_t);
static obj_t _lcm___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t __fx1218_227___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern bool_t odd__202___r4_numbers_6_5_fixnum(long);
static obj_t imported_modules_init_94___r4_numbers_6_5_fixnum();
extern long gcd___r4_numbers_6_5_fixnum(obj_t);
extern long _fx_187___r4_numbers_6_5_fixnum(long, long);
extern long modulo___r4_numbers_6_5_fixnum(long, long);
extern bool_t __fx_163___r4_numbers_6_5_fixnum(long, long);
static obj_t _make_elong1217_162___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t _string__integer1240_104___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern long minfx___r4_numbers_6_5_fixnum(long, obj_t);
static obj_t _llong__245___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t require_initialization_114___r4_numbers_6_5_fixnum = BUNSPEC;
static obj_t ___fx1221_166___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static long lcm2___r4_numbers_6_5_fixnum(obj_t, obj_t);
static obj_t _string__elong1241_141___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
static obj_t _minfx1229___r4_numbers_6_5_fixnum(obj_t, obj_t, obj_t);
extern long _fx_15___r4_numbers_6_5_fixnum(long, long);
static obj_t _odd_1226_156___r4_numbers_6_5_fixnum(obj_t, obj_t);
extern long remainder___r4_numbers_6_5_fixnum(long, long);
extern long _fx_145___r4_numbers_6_5_fixnum(long, long);
extern long quotient___r4_numbers_6_5_fixnum(long, long);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( negfx_env_197___r4_numbers_6_5_fixnum, _negfx1234___r4_numbers_6_5_fixnum1246, _negfx1234___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( llong__env_253___r4_numbers_6_5_fixnum, _llong__245___r4_numbers_6_5_fixnum1247, _llong__245___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( _fx_env_112___r4_numbers_6_5_fixnum, __fx1219_241___r4_numbers_6_5_fixnum1248, __fx1219_241___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( modulo_env_48___r4_numbers_6_5_fixnum, _modulo1238___r4_numbers_6_5_fixnum1249, _modulo1238___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( _fx_env_6___r4_numbers_6_5_fixnum, __fx1220_209___r4_numbers_6_5_fixnum1250, __fx1220_209___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( positivefx__env_68___r4_numbers_6_5_fixnum, _positivefx_1224_77___r4_numbers_6_5_fixnum1251, _positivefx_1224_77___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( absfx_env_151___r4_numbers_6_5_fixnum, _absfx1235___r4_numbers_6_5_fixnum1252, _absfx1235___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( even__env_28___r4_numbers_6_5_fixnum, _even_1227_181___r4_numbers_6_5_fixnum1253, _even_1227_181___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( elong__env_58___r4_numbers_6_5_fixnum, _elong__107___r4_numbers_6_5_fixnum1254, _elong__107___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string__llong_env_205___r4_numbers_6_5_fixnum, _string__llong1242_115___r4_numbers_6_5_fixnum1255, va_generic_entry, _string__llong1242_115___r4_numbers_6_5_fixnum, -2 );
DEFINE_EXPORT_PROCEDURE( integer__env_26___r4_numbers_6_5_fixnum, _integer__27___r4_numbers_6_5_fixnum1256, _integer__27___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( negativefx__env_96___r4_numbers_6_5_fixnum, _negativefx_1225_197___r4_numbers_6_5_fixnum1257, _negativefx_1225_197___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( gcd_env_113___r4_numbers_6_5_fixnum, _gcd___r4_numbers_6_5_fixnum1258, va_generic_entry, _gcd___r4_numbers_6_5_fixnum, -1 );
DEFINE_EXPORT_PROCEDURE( maxfx_env_127___r4_numbers_6_5_fixnum, _maxfx1228___r4_numbers_6_5_fixnum1259, va_generic_entry, _maxfx1228___r4_numbers_6_5_fixnum, -2 );
DEFINE_EXPORT_PROCEDURE( quotient_env_77___r4_numbers_6_5_fixnum, _quotient1236___r4_numbers_6_5_fixnum1260, _quotient1236___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( zerofx__env_195___r4_numbers_6_5_fixnum, _zerofx_1223_33___r4_numbers_6_5_fixnum1261, _zerofx_1223_33___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( fixnum__env_153___r4_numbers_6_5_fixnum, _fixnum__233___r4_numbers_6_5_fixnum1262, _fixnum__233___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( _fx_env_27___r4_numbers_6_5_fixnum, __fx1230_170___r4_numbers_6_5_fixnum1263, __fx1230_170___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( _fx_env_151___r4_numbers_6_5_fixnum, __fx1231_165___r4_numbers_6_5_fixnum1264, __fx1231_165___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( _fx_env_205___r4_numbers_6_5_fixnum, __fx1233_11___r4_numbers_6_5_fixnum1265, __fx1233_11___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( remainder_env_228___r4_numbers_6_5_fixnum, _remainder1237___r4_numbers_6_5_fixnum1266, _remainder1237___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( __fx_env_255___r4_numbers_6_5_fixnum, ___fx1221_166___r4_numbers_6_5_fixnum1267, ___fx1221_166___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__elong_env_192___r4_numbers_6_5_fixnum, _string__elong1241_141___r4_numbers_6_5_fixnum1268, va_generic_entry, _string__elong1241_141___r4_numbers_6_5_fixnum, -2 );
DEFINE_EXPORT_PROCEDURE( _fx_env_199___r4_numbers_6_5_fixnum, __fx1218_227___r4_numbers_6_5_fixnum1269, __fx1218_227___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( odd__env_69___r4_numbers_6_5_fixnum, _odd_1226_156___r4_numbers_6_5_fixnum1270, _odd_1226_156___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( __fx_env_85___r4_numbers_6_5_fixnum, ___fx1222_22___r4_numbers_6_5_fixnum1271, ___fx1222_22___r4_numbers_6_5_fixnum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( integer__string_env_18___r4_numbers_6_5_fixnum, _integer__string1239_82___r4_numbers_6_5_fixnum1272, va_generic_entry, _integer__string1239_82___r4_numbers_6_5_fixnum, -2 );
DEFINE_EXPORT_PROCEDURE( minfx_env_32___r4_numbers_6_5_fixnum, _minfx1229___r4_numbers_6_5_fixnum1273, va_generic_entry, _minfx1229___r4_numbers_6_5_fixnum, -2 );
DEFINE_EXPORT_PROCEDURE( make_elong_env_148___r4_numbers_6_5_fixnum, _make_elong1217_162___r4_numbers_6_5_fixnum1274, _make_elong1217_162___r4_numbers_6_5_fixnum, 0L, 1 );
DEFINE_STRING( string1244___r4_numbers_6_5_fixnum, string1244___r4_numbers_6_5_fixnum1275, "Illegal radix", 13 );
DEFINE_STRING( string1243___r4_numbers_6_5_fixnum, string1243___r4_numbers_6_5_fixnum1276, "integer->string", 15 );
DEFINE_EXPORT_PROCEDURE( string__integer_env_230___r4_numbers_6_5_fixnum, _string__integer1240_104___r4_numbers_6_5_fixnum1277, va_generic_entry, _string__integer1240_104___r4_numbers_6_5_fixnum, -2 );
DEFINE_EXPORT_PROCEDURE( lcm_env_26___r4_numbers_6_5_fixnum, _lcm___r4_numbers_6_5_fixnum1278, va_generic_entry, _lcm___r4_numbers_6_5_fixnum, -1 );
DEFINE_EXPORT_PROCEDURE( _fx_env_1___r4_numbers_6_5_fixnum, __fx1232_37___r4_numbers_6_5_fixnum1279, __fx1232_37___r4_numbers_6_5_fixnum, 0L, 2 );


/* module-initialization */obj_t module_initialization_70___r4_numbers_6_5_fixnum(long checksum_870, char * from_871)
{
if(CBOOL(require_initialization_114___r4_numbers_6_5_fixnum)){
require_initialization_114___r4_numbers_6_5_fixnum = BBOOL(((bool_t)0));
imported_modules_init_94___r4_numbers_6_5_fixnum();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* integer? */bool_t integer__108___r4_numbers_6_5_fixnum(obj_t obj_1)
{
return INTEGERP(obj_1);
}


/* _integer? */obj_t _integer__27___r4_numbers_6_5_fixnum(obj_t env_754, obj_t obj_755)
{
{
bool_t aux_877;
{
obj_t obj_836;
obj_836 = obj_755;
aux_877 = INTEGERP(obj_836);
}
return BBOOL(aux_877);
}
}


/* fixnum? */bool_t fixnum__102___r4_numbers_6_5_fixnum(obj_t obj_2)
{
return INTEGERP(obj_2);
}


/* _fixnum? */obj_t _fixnum__233___r4_numbers_6_5_fixnum(obj_t env_756, obj_t obj_757)
{
{
bool_t aux_881;
{
obj_t obj_837;
obj_837 = obj_757;
aux_881 = INTEGERP(obj_837);
}
return BBOOL(aux_881);
}
}


/* elong? */bool_t elong__154___r4_numbers_6_5_fixnum(obj_t obj_3)
{
return ELONGP(obj_3);
}


/* _elong? */obj_t _elong__107___r4_numbers_6_5_fixnum(obj_t env_758, obj_t obj_759)
{
{
bool_t aux_885;
{
obj_t obj_838;
obj_838 = obj_759;
aux_885 = ELONGP(obj_838);
}
return BBOOL(aux_885);
}
}


/* llong? */bool_t llong__230___r4_numbers_6_5_fixnum(obj_t obj_4)
{
return LLONGP(obj_4);
}


/* _llong? */obj_t _llong__245___r4_numbers_6_5_fixnum(obj_t env_760, obj_t obj_761)
{
{
bool_t aux_889;
{
obj_t obj_839;
obj_839 = obj_761;
aux_889 = LLONGP(obj_839);
}
return BBOOL(aux_889);
}
}


/* make-elong */obj_t make_elong_201___r4_numbers_6_5_fixnum(long long_5)
{
return LONG_TO_BELONG(long_5);
}


/* _make-elong1217 */obj_t _make_elong1217_162___r4_numbers_6_5_fixnum(obj_t env_762, obj_t long_763)
{
{
long long_57_840;
long_57_840 = (long)CINT(long_763);
return LONG_TO_BELONG(long_57_840);
}
}


/* =fx */bool_t _fx_134___r4_numbers_6_5_fixnum(long n1_6, long n2_7)
{
return (n1_6==n2_7);
}


/* _=fx1218 */obj_t __fx1218_227___r4_numbers_6_5_fixnum(obj_t env_764, obj_t n1_765, obj_t n2_766)
{
{
bool_t aux_896;
{
long n1_841;
long n2_842;
n1_841 = (long)CINT(n1_765);
n2_842 = (long)CINT(n2_766);
aux_896 = (n1_841==n2_842);
}
return BBOOL(aux_896);
}
}


/* <fx */bool_t _fx_179___r4_numbers_6_5_fixnum(long n1_8, long n2_9)
{
return (n1_8<n2_9);
}


/* _<fx1219 */obj_t __fx1219_241___r4_numbers_6_5_fixnum(obj_t env_767, obj_t n1_768, obj_t n2_769)
{
{
bool_t aux_902;
{
long n1_843;
long n2_844;
n1_843 = (long)CINT(n1_768);
n2_844 = (long)CINT(n2_769);
aux_902 = (n1_843<n2_844);
}
return BBOOL(aux_902);
}
}


/* >fx */bool_t _fx_24___r4_numbers_6_5_fixnum(long n1_10, long n2_11)
{
return (n1_10>n2_11);
}


/* _>fx1220 */obj_t __fx1220_209___r4_numbers_6_5_fixnum(obj_t env_770, obj_t n1_771, obj_t n2_772)
{
{
bool_t aux_908;
{
long n1_845;
long n2_846;
n1_845 = (long)CINT(n1_771);
n2_846 = (long)CINT(n2_772);
aux_908 = (n1_845>n2_846);
}
return BBOOL(aux_908);
}
}


/* <=fx */bool_t __fx_163___r4_numbers_6_5_fixnum(long n1_12, long n2_13)
{
return (n1_12<=n2_13);
}


/* _<=fx1221 */obj_t ___fx1221_166___r4_numbers_6_5_fixnum(obj_t env_773, obj_t n1_774, obj_t n2_775)
{
{
bool_t aux_914;
{
long n1_847;
long n2_848;
n1_847 = (long)CINT(n1_774);
n2_848 = (long)CINT(n2_775);
aux_914 = (n1_847<=n2_848);
}
return BBOOL(aux_914);
}
}


/* >=fx */bool_t __fx_254___r4_numbers_6_5_fixnum(long n1_14, long n2_15)
{
return (n1_14>=n2_15);
}


/* _>=fx1222 */obj_t ___fx1222_22___r4_numbers_6_5_fixnum(obj_t env_776, obj_t n1_777, obj_t n2_778)
{
{
bool_t aux_920;
{
long n1_849;
long n2_850;
n1_849 = (long)CINT(n1_777);
n2_850 = (long)CINT(n2_778);
aux_920 = (n1_849>=n2_850);
}
return BBOOL(aux_920);
}
}


/* zerofx? */bool_t zerofx__17___r4_numbers_6_5_fixnum(long n_16)
{
return (n_16==((long)0));
}


/* _zerofx?1223 */obj_t _zerofx_1223_33___r4_numbers_6_5_fixnum(obj_t env_779, obj_t n_780)
{
{
bool_t aux_926;
{
long n_851;
n_851 = (long)CINT(n_780);
aux_926 = (n_851==((long)0));
}
return BBOOL(aux_926);
}
}


/* positivefx? */bool_t positivefx__200___r4_numbers_6_5_fixnum(long n_17)
{
return (n_17>((long)0));
}


/* _positivefx?1224 */obj_t _positivefx_1224_77___r4_numbers_6_5_fixnum(obj_t env_781, obj_t n_782)
{
{
bool_t aux_931;
{
long n_852;
n_852 = (long)CINT(n_782);
aux_931 = (n_852>((long)0));
}
return BBOOL(aux_931);
}
}


/* negativefx? */bool_t negativefx__232___r4_numbers_6_5_fixnum(long n_18)
{
return (n_18<((long)0));
}


/* _negativefx?1225 */obj_t _negativefx_1225_197___r4_numbers_6_5_fixnum(obj_t env_783, obj_t n_784)
{
{
bool_t aux_936;
{
long n_853;
n_853 = (long)CINT(n_784);
aux_936 = (n_853<((long)0));
}
return BBOOL(aux_936);
}
}


/* odd? */bool_t odd__202___r4_numbers_6_5_fixnum(long x_19)
{
return ODDP_FX(x_19);
}


/* _odd?1226 */obj_t _odd_1226_156___r4_numbers_6_5_fixnum(obj_t env_785, obj_t x_786)
{
{
bool_t aux_941;
{
long x_854;
x_854 = (long)CINT(x_786);
aux_941 = ODDP_FX(x_854);
}
return BBOOL(aux_941);
}
}


/* even? */bool_t even__46___r4_numbers_6_5_fixnum(long x_20)
{
return EVENP_FX(x_20);
}


/* _even?1227 */obj_t _even_1227_181___r4_numbers_6_5_fixnum(obj_t env_787, obj_t x_788)
{
{
bool_t aux_946;
{
long x_855;
x_855 = (long)CINT(x_788);
aux_946 = EVENP_FX(x_855);
}
return BBOOL(aux_946);
}
}


/* maxfx */long maxfx___r4_numbers_6_5_fixnum(long n1_21, obj_t nn_22)
{
{
obj_t max_224;
obj_t nn_225;
{
obj_t aux_950;
max_224 = BINT(n1_21);
nn_225 = nn_22;
loop_226:
if(NULLP(nn_225)){
aux_950 = max_224;
}
 else {
bool_t test_953;
{
long aux_958;
long aux_954;
aux_958 = (long)CINT(max_224);
{
obj_t aux_955;
aux_955 = CAR(nn_225);
aux_954 = (long)CINT(aux_955);
}
test_953 = (aux_954>aux_958);
}
if(test_953){
obj_t nn_963;
obj_t max_961;
max_961 = CAR(nn_225);
nn_963 = CDR(nn_225);
nn_225 = nn_963;
max_224 = max_961;
goto loop_226;
}
 else {
obj_t nn_965;
nn_965 = CDR(nn_225);
nn_225 = nn_965;
goto loop_226;
}
}
return (long)CINT(aux_950);
}
}
}


/* _maxfx1228 */obj_t _maxfx1228___r4_numbers_6_5_fixnum(obj_t env_789, obj_t n1_790, obj_t nn_791)
{
{
long aux_969;
aux_969 = maxfx___r4_numbers_6_5_fixnum((long)CINT(n1_790), nn_791);
return BINT(aux_969);
}
}


/* minfx */long minfx___r4_numbers_6_5_fixnum(long n1_23, obj_t nn_24)
{
{
obj_t min_233;
obj_t nn_234;
{
obj_t aux_973;
min_233 = BINT(n1_23);
nn_234 = nn_24;
loop_235:
if(NULLP(nn_234)){
aux_973 = min_233;
}
 else {
bool_t test_976;
{
long aux_981;
long aux_977;
aux_981 = (long)CINT(min_233);
{
obj_t aux_978;
aux_978 = CAR(nn_234);
aux_977 = (long)CINT(aux_978);
}
test_976 = (aux_977<aux_981);
}
if(test_976){
obj_t nn_986;
obj_t min_984;
min_984 = CAR(nn_234);
nn_986 = CDR(nn_234);
nn_234 = nn_986;
min_233 = min_984;
goto loop_235;
}
 else {
obj_t nn_988;
nn_988 = CDR(nn_234);
nn_234 = nn_988;
goto loop_235;
}
}
return (long)CINT(aux_973);
}
}
}


/* _minfx1229 */obj_t _minfx1229___r4_numbers_6_5_fixnum(obj_t env_792, obj_t n1_793, obj_t nn_794)
{
{
long aux_992;
aux_992 = minfx___r4_numbers_6_5_fixnum((long)CINT(n1_793), nn_794);
return BINT(aux_992);
}
}


/* +fx */long _fx_15___r4_numbers_6_5_fixnum(long z1_25, long z2_26)
{
return (z1_25+z2_26);
}


/* _+fx1230 */obj_t __fx1230_170___r4_numbers_6_5_fixnum(obj_t env_795, obj_t z1_796, obj_t z2_797)
{
{
long aux_997;
{
long z1_856;
long z2_857;
z1_856 = (long)CINT(z1_796);
z2_857 = (long)CINT(z2_797);
aux_997 = (z1_856+z2_857);
}
return BINT(aux_997);
}
}


/* -fx */long _fx_187___r4_numbers_6_5_fixnum(long z1_27, long z2_28)
{
return (z1_27-z2_28);
}


/* _-fx1231 */obj_t __fx1231_165___r4_numbers_6_5_fixnum(obj_t env_798, obj_t z1_799, obj_t z2_800)
{
{
long aux_1003;
{
long z1_858;
long z2_859;
z1_858 = (long)CINT(z1_799);
z2_859 = (long)CINT(z2_800);
aux_1003 = (z1_858-z2_859);
}
return BINT(aux_1003);
}
}


/* *fx */long _fx_145___r4_numbers_6_5_fixnum(long z1_29, long z2_30)
{
return (z1_29*z2_30);
}


/* _*fx1232 */obj_t __fx1232_37___r4_numbers_6_5_fixnum(obj_t env_801, obj_t z1_802, obj_t z2_803)
{
{
long aux_1009;
{
long z1_860;
long z2_861;
z1_860 = (long)CINT(z1_802);
z2_861 = (long)CINT(z2_803);
aux_1009 = (z1_860*z2_861);
}
return BINT(aux_1009);
}
}


/* /fx */long _fx_61___r4_numbers_6_5_fixnum(long z1_31, long z2_32)
{
return (z1_31/z2_32);
}


/* _/fx1233 */obj_t __fx1233_11___r4_numbers_6_5_fixnum(obj_t env_804, obj_t z1_805, obj_t z2_806)
{
{
long aux_1015;
{
long z1_862;
long z2_863;
z1_862 = (long)CINT(z1_805);
z2_863 = (long)CINT(z2_806);
aux_1015 = (z1_862/z2_863);
}
return BINT(aux_1015);
}
}


/* negfx */long negfx___r4_numbers_6_5_fixnum(long n1_33)
{
return NEG(n1_33);
}


/* _negfx1234 */obj_t _negfx1234___r4_numbers_6_5_fixnum(obj_t env_807, obj_t n1_808)
{
{
long aux_1021;
{
long n1_864;
n1_864 = (long)CINT(n1_808);
aux_1021 = NEG(n1_864);
}
return BINT(aux_1021);
}
}


/* absfx */long absfx___r4_numbers_6_5_fixnum(long n_34)
{
if((n_34<((long)0))){
return NEG(n_34);
}
 else {
return n_34;
}
}


/* _absfx1235 */obj_t _absfx1235___r4_numbers_6_5_fixnum(obj_t env_809, obj_t n_810)
{
{
long aux_1028;
{
long n_865;
n_865 = (long)CINT(n_810);
if((n_865<((long)0))){
aux_1028 = NEG(n_865);
}
 else {
aux_1028 = n_865;
}
}
return BINT(aux_1028);
}
}


/* quotient */long quotient___r4_numbers_6_5_fixnum(long n1_35, long n2_36)
{
return (n1_35/n2_36);
}


/* _quotient1236 */obj_t _quotient1236___r4_numbers_6_5_fixnum(obj_t env_811, obj_t n1_812, obj_t n2_813)
{
{
long aux_1035;
{
long n1_866;
long n2_867;
n1_866 = (long)CINT(n1_812);
n2_867 = (long)CINT(n2_813);
aux_1035 = (n1_866/n2_867);
}
return BINT(aux_1035);
}
}


/* remainder */long remainder___r4_numbers_6_5_fixnum(long n1_37, long n2_38)
{
return (n1_37%n2_38);
}


/* _remainder1237 */obj_t _remainder1237___r4_numbers_6_5_fixnum(obj_t env_814, obj_t n1_815, obj_t n2_816)
{
{
long aux_1041;
{
long n1_868;
long n2_869;
n1_868 = (long)CINT(n1_815);
n2_869 = (long)CINT(n2_816);
aux_1041 = (n1_868%n2_869);
}
return BINT(aux_1041);
}
}


/* modulo */long modulo___r4_numbers_6_5_fixnum(long x_39, long y_40)
{
{
long r_243;
r_243 = (x_39%y_40);
if((r_243==((long)0))){
return r_243;
}
 else {
if((y_40>((long)0))){
if((r_243>((long)0))){
return r_243;
}
 else {
return (y_40+r_243);
}
}
 else {
if((r_243<((long)0))){
return r_243;
}
 else {
return (y_40+r_243);
}
}
}
}
}


/* _modulo1238 */obj_t _modulo1238___r4_numbers_6_5_fixnum(obj_t env_817, obj_t x_818, obj_t y_819)
{
{
long aux_1057;
aux_1057 = modulo___r4_numbers_6_5_fixnum((long)CINT(x_818), (long)CINT(y_819));
return BINT(aux_1057);
}
}


/* gcd */long gcd___r4_numbers_6_5_fixnum(obj_t x_41)
{
{
long m_267;
long n_268;
{
switch (list_length(x_41)){
case ((long)0) : 
return ((long)0);
break;
case ((long)1) : 
{
long n_487;
{
obj_t aux_1062;
aux_1062 = CAR(x_41);
n_487 = (long)CINT(aux_1062);
}
if((n_487<((long)0))){
return NEG(n_487);
}
 else {
return n_487;
}
}
break;
default: 
{
long arg1030_256;
obj_t arg1031_257;
{
long m_511;
long n_512;
{
long n_494;
{
obj_t aux_1075;
aux_1075 = CAR(x_41);
n_494 = (long)CINT(aux_1075);
}
if((n_494<((long)0))){
m_511 = NEG(n_494);
}
 else {
m_511 = n_494;
}
}
{
long n_504;
{
obj_t aux_1081;
{
obj_t aux_1082;
aux_1082 = CDR(x_41);
aux_1081 = CAR(aux_1082);
}
n_504 = (long)CINT(aux_1081);
}
if((n_504<((long)0))){
n_512 = NEG(n_504);
}
 else {
n_512 = n_504;
}
}
gcd2_510:
if((n_512==((long)0))){
arg1030_256 = m_511;
}
 else {
long r_517;
r_517 = (m_511%n_512);
if((r_517==((long)0))){
arg1030_256 = n_512;
}
 else {
long n_1074;
long m_1073;
m_1073 = n_512;
n_1074 = r_517;
n_512 = n_1074;
m_511 = m_1073;
goto gcd2_510;
}
}
}
{
obj_t aux_1089;
aux_1089 = CDR(x_41);
arg1031_257 = CDR(aux_1089);
}
{
long result_531;
obj_t left_532;
result_531 = arg1030_256;
left_532 = arg1031_257;
loop_530:
if(PAIRP(left_532)){
long arg1037_539;
obj_t arg1038_540;
m_267 = result_531;
{
long n_545;
{
obj_t aux_1105;
aux_1105 = CAR(left_532);
n_545 = (long)CINT(aux_1105);
}
if((n_545<((long)0))){
n_268 = NEG(n_545);
}
 else {
n_268 = n_545;
}
}
gcd2_273:
if((n_268==((long)0))){
arg1037_539 = m_267;
}
 else {
long r_599;
r_599 = (m_267%n_268);
{
bool_t test1043_600;
test1043_600 = (r_599==((long)0));
if(test1043_600){
arg1037_539 = n_268;
}
 else {
if(test1043_600){
arg1037_539 = n_268;
}
 else {
long r_611;
r_611 = (n_268%r_599);
if((r_611==((long)0))){
arg1037_539 = r_599;
}
 else {
long n_1104;
long m_1103;
m_1103 = r_599;
n_1104 = r_611;
n_268 = n_1104;
m_267 = m_1103;
goto gcd2_273;
}
}
}
}
}
arg1038_540 = CDR(left_532);
{
obj_t left_1113;
long result_1112;
result_1112 = arg1037_539;
left_1113 = arg1038_540;
left_532 = left_1113;
result_531 = result_1112;
goto loop_530;
}
}
 else {
return result_531;
}
}
}
}
}
}
}


/* _gcd */obj_t _gcd___r4_numbers_6_5_fixnum(obj_t env_820, obj_t x_821)
{
{
long aux_1116;
aux_1116 = gcd___r4_numbers_6_5_fixnum(x_821);
return BINT(aux_1116);
}
}


/* lcm */long lcm___r4_numbers_6_5_fixnum(obj_t x_42)
{
{
switch (list_length(x_42)){
case ((long)0) : 
return ((long)1);
break;
case ((long)1) : 
{
long n_621;
{
obj_t aux_1119;
aux_1119 = CAR(x_42);
n_621 = (long)CINT(aux_1119);
}
if((n_621<((long)0))){
return NEG(n_621);
}
 else {
return n_621;
}
}
break;
default: 
{
long arg1046_282;
obj_t arg1047_283;
{
obj_t aux_1125;
{
obj_t aux_1127;
aux_1127 = CDR(x_42);
aux_1125 = CAR(aux_1127);
}
arg1046_282 = lcm2___r4_numbers_6_5_fixnum(CAR(x_42), aux_1125);
}
{
obj_t aux_1131;
aux_1131 = CDR(x_42);
arg1047_283 = CDR(aux_1131);
}
{
long result_637;
obj_t left_638;
result_637 = arg1046_282;
left_638 = arg1047_283;
loop_636:
if(PAIRP(left_638)){
long arg1051_644;
obj_t arg1053_645;
arg1051_644 = lcm2___r4_numbers_6_5_fixnum(BINT(result_637), CAR(left_638));
arg1053_645 = CDR(left_638);
{
obj_t left_1141;
long result_1140;
result_1140 = arg1051_644;
left_1141 = arg1053_645;
left_638 = left_1141;
result_637 = result_1140;
goto loop_636;
}
}
 else {
return result_637;
}
}
}
}
}
}


/* lcm2 */long lcm2___r4_numbers_6_5_fixnum(obj_t m_290, obj_t n_291)
{
{
long m_293;
long n_294;
{
long n_666;
n_666 = (long)CINT(m_290);
if((n_666<((long)0))){
m_293 = NEG(n_666);
}
 else {
m_293 = n_666;
}
}
{
long n_672;
n_672 = (long)CINT(n_291);
if((n_672<((long)0))){
n_294 = NEG(n_672);
}
 else {
n_294 = n_672;
}
}
if((m_293==n_294)){
return m_293;
}
 else {
bool_t test1057_296;
{
long arg1067_305;
arg1067_305 = (m_293%n_294);
test1057_296 = (arg1067_305==((long)0));
}
if(test1057_296){
return m_293;
}
 else {
bool_t test1058_297;
{
long arg1065_303;
arg1065_303 = (n_294%m_293);
test1058_297 = (arg1065_303==((long)0));
}
if(test1058_297){
return n_294;
}
 else {
{
long arg1059_298;
{
long arg1060_299;
{
obj_t list1061_300;
{
obj_t arg1062_301;
{
obj_t aux_1160;
aux_1160 = BINT(n_294);
arg1062_301 = MAKE_PAIR(aux_1160, BNIL);
}
{
obj_t aux_1163;
aux_1163 = BINT(m_293);
list1061_300 = MAKE_PAIR(aux_1163, arg1062_301);
}
}
arg1060_299 = gcd___r4_numbers_6_5_fixnum(list1061_300);
}
arg1059_298 = (m_293/arg1060_299);
}
return (arg1059_298*n_294);
}
}
}
}
}
}


/* _lcm */obj_t _lcm___r4_numbers_6_5_fixnum(obj_t env_822, obj_t x_823)
{
{
long aux_1169;
aux_1169 = lcm___r4_numbers_6_5_fixnum(x_823);
return BINT(aux_1169);
}
}


/* integer->string */char * integer__string_135___r4_numbers_6_5_fixnum(long x_43, obj_t radix_44)
{
{
bool_t test1069_308;
{
obj_t obj_692;
obj_692 = radix_44;
test1069_308 = NULLP(obj_692);
}
if(test1069_308){
radix_44 = BINT(((long)10));
}
 else {
obj_t pair_693;
pair_693 = radix_44;
radix_44 = CAR(pair_693);
}
}
{
obj_t aux1007_310;
aux1007_310 = radix_44;
if(INTEGERP(aux1007_310)){
switch ((long)CINT(aux1007_310)){
case ((long)2) : 
case ((long)8) : 
case ((long)10) : 
case ((long)16) : 
{
long aux_1178;
aux_1178 = (long)CINT(radix_44);
return integer_to_string(x_43, aux_1178);
}
break;
default: 
{
obj_t object_696;
object_696 = radix_44;
FAILURE(string1243___r4_numbers_6_5_fixnum,string1244___r4_numbers_6_5_fixnum,object_696);}
}
}
 else {
obj_t object_699;
object_699 = radix_44;
FAILURE(string1243___r4_numbers_6_5_fixnum,string1244___r4_numbers_6_5_fixnum,object_699);}
}
}


/* _integer->string1239 */obj_t _integer__string1239_82___r4_numbers_6_5_fixnum(obj_t env_824, obj_t x_825, obj_t radix_826)
{
{
char * aux_1185;
aux_1185 = integer__string_135___r4_numbers_6_5_fixnum((long)CINT(x_825), radix_826);
return string_to_bstring(aux_1185);
}
}


/* string->integer */long string__integer_39___r4_numbers_6_5_fixnum(char * string_45, obj_t radix_46)
{
{
bool_t test1071_703;
{
obj_t obj_704;
obj_704 = radix_46;
test1071_703 = NULLP(obj_704);
}
if(test1071_703){
radix_46 = BINT(((long)10));
}
 else {
obj_t pair_705;
pair_705 = radix_46;
radix_46 = CAR(pair_705);
}
}
{
long aux_1193;
aux_1193 = (long)CINT(radix_46);
return strtol(string_45, ((long)0), aux_1193);
}
}


/* _string->integer1240 */obj_t _string__integer1240_104___r4_numbers_6_5_fixnum(obj_t env_827, obj_t string_828, obj_t radix_829)
{
{
long aux_1196;
aux_1196 = string__integer_39___r4_numbers_6_5_fixnum(BSTRING_TO_STRING(string_828), radix_829);
return BINT(aux_1196);
}
}


/* string->elong */obj_t string__elong_120___r4_numbers_6_5_fixnum(char * string_47, obj_t radix_48)
{
if(PAIRP(radix_48)){
long arg1073_707;
{
obj_t list1077_709;
{
obj_t aux_1202;
aux_1202 = CAR(radix_48);
list1077_709 = MAKE_PAIR(aux_1202, BNIL);
}
{
long res1213_720;
{
obj_t radix_716;
radix_716 = list1077_709;
{
bool_t test1071_717;
{
obj_t obj_718;
obj_718 = radix_716;
test1071_717 = NULLP(obj_718);
}
if(test1071_717){
radix_716 = BINT(((long)10));
}
 else {
obj_t pair_719;
pair_719 = radix_716;
radix_716 = CAR(pair_719);
}
}
{
long aux_1209;
aux_1209 = (long)CINT(radix_716);
res1213_720 = strtol(string_47, ((long)0), aux_1209);
}
}
arg1073_707 = res1213_720;
}
}
return LONG_TO_BELONG(arg1073_707);
}
 else {
long arg1079_711;
{
long res1214_726;
{
obj_t radix_722;
radix_722 = BNIL;
{
bool_t test1071_723;
{
obj_t obj_724;
obj_724 = radix_722;
test1071_723 = NULLP(obj_724);
}
if(test1071_723){
radix_722 = BINT(((long)10));
}
 else {
obj_t pair_725;
pair_725 = radix_722;
radix_722 = CAR(pair_725);
}
}
{
long aux_1217;
aux_1217 = (long)CINT(radix_722);
res1214_726 = strtol(string_47, ((long)0), aux_1217);
}
}
arg1079_711 = res1214_726;
}
return LONG_TO_BELONG(arg1079_711);
}
}


/* _string->elong1241 */obj_t _string__elong1241_141___r4_numbers_6_5_fixnum(obj_t env_830, obj_t string_831, obj_t radix_832)
{
return string__elong_120___r4_numbers_6_5_fixnum(BSTRING_TO_STRING(string_831), radix_832);
}


/* string->llong */obj_t string__llong_61___r4_numbers_6_5_fixnum(char * string_49, obj_t radix_50)
{
if(PAIRP(radix_50)){
long arg1082_728;
{
obj_t list1084_730;
{
obj_t aux_1225;
aux_1225 = CAR(radix_50);
list1084_730 = MAKE_PAIR(aux_1225, BNIL);
}
{
long res1215_741;
{
obj_t radix_737;
radix_737 = list1084_730;
{
bool_t test1071_738;
{
obj_t obj_739;
obj_739 = radix_737;
test1071_738 = NULLP(obj_739);
}
if(test1071_738){
radix_737 = BINT(((long)10));
}
 else {
obj_t pair_740;
pair_740 = radix_737;
radix_737 = CAR(pair_740);
}
}
{
long aux_1232;
aux_1232 = (long)CINT(radix_737);
res1215_741 = strtol(string_49, ((long)0), aux_1232);
}
}
arg1082_728 = res1215_741;
}
}
return LLONG_TO_BLLONG(arg1082_728);
}
 else {
long arg1086_732;
{
long res1216_747;
{
obj_t radix_743;
radix_743 = BNIL;
{
bool_t test1071_744;
{
obj_t obj_745;
obj_745 = radix_743;
test1071_744 = NULLP(obj_745);
}
if(test1071_744){
radix_743 = BINT(((long)10));
}
 else {
obj_t pair_746;
pair_746 = radix_743;
radix_743 = CAR(pair_746);
}
}
{
long aux_1240;
aux_1240 = (long)CINT(radix_743);
res1216_747 = strtol(string_49, ((long)0), aux_1240);
}
}
arg1086_732 = res1216_747;
}
return LLONG_TO_BLLONG(arg1086_732);
}
}


/* _string->llong1242 */obj_t _string__llong1242_115___r4_numbers_6_5_fixnum(obj_t env_833, obj_t string_834, obj_t radix_835)
{
return string__llong_61___r4_numbers_6_5_fixnum(BSTRING_TO_STRING(string_834), radix_835);
}


/* imported-modules-init */obj_t imported_modules_init_94___r4_numbers_6_5_fixnum()
{
return module_initialization_70___error(((long)0), "__R4_NUMBERS_6_5_FIXNUM");
}

