/*===========================================================================*/
/*   (Llib/tvector.scm)                                                      */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

/* debug mode */
#define BIGLOO_DEBUG 1

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t symbol1520___tvector = BUNSPEC;
static obj_t symbol1518___tvector = BUNSPEC;
static obj_t symbol1517___tvector = BUNSPEC;
static obj_t symbol1513___tvector = BUNSPEC;
static obj_t symbol1511___tvector = BUNSPEC;
static obj_t symbol1508___tvector = BUNSPEC;
static obj_t symbol1507___tvector = BUNSPEC;
static obj_t symbol1506___tvector = BUNSPEC;
static obj_t symbol1505___tvector = BUNSPEC;
static obj_t _get_tvector_descriptor1219_87___tvector(obj_t, obj_t);
extern obj_t string_to_symbol(char *);
static obj_t list1556___tvector = BUNSPEC;
static obj_t list1549___tvector = BUNSPEC;
static obj_t list1536___tvector = BUNSPEC;
static obj_t list1531___tvector = BUNSPEC;
static obj_t _vector__tvector1223_93___tvector(obj_t, obj_t, obj_t);
extern obj_t bigloo_case_sensitive;
static obj_t _tvector_table__47___tvector = BUNSPEC;
extern obj_t assq___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t toplevel_init_63___tvector();
static obj_t _tvector_id1218_171___tvector(obj_t, obj_t);
static obj_t _declare_tvector_1220_57___tvector(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t create_vector(long);
extern obj_t tvector_id_255___tvector(obj_t);
extern obj_t tvector__vector_99___tvector(obj_t);
extern obj_t create_struct(obj_t, long);
extern obj_t string_to_bstring(char *);
extern obj_t vector__tvector_253___tvector(obj_t, obj_t);
static obj_t _tvector_length1217_224___tvector(obj_t, obj_t);
extern obj_t bigloo_type_error_location_103___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t get_tvector_descriptor(obj_t);
static obj_t _tvector__38___tvector(obj_t, obj_t);
extern obj_t debug_error_location_199___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t module_initialization_70___tvector(long, char *);
extern obj_t module_initialization_70___hash(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern long tvector_length_13___tvector(obj_t);
extern obj_t tvector_ref_208___tvector(obj_t);
extern obj_t error_location_112___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern bool_t tvector__195___tvector(obj_t);
extern obj_t declare_tvector__43___tvector(char *, obj_t, obj_t, obj_t);
static obj_t _tvector_ref1221_206___tvector(obj_t, obj_t);
extern long list_length(obj_t);
static obj_t _list__tvector1222_24___tvector(obj_t, obj_t, obj_t);
static obj_t _tvector__vector1224_155___tvector(obj_t, obj_t);
static obj_t imported_modules_init_94___tvector();
static obj_t require_initialization_114___tvector = BUNSPEC;
extern obj_t list__tvector_27___tvector(obj_t, obj_t);
static obj_t cnst_init_137___tvector();
static obj_t symbol1562___tvector = BUNSPEC;
static obj_t symbol1561___tvector = BUNSPEC;
static obj_t symbol1558___tvector = BUNSPEC;
static obj_t symbol1557___tvector = BUNSPEC;
extern obj_t string_upcase_71___r4_strings_6_7(obj_t);
static obj_t symbol1554___tvector = BUNSPEC;
static obj_t symbol1552___tvector = BUNSPEC;
static obj_t symbol1550___tvector = BUNSPEC;
static obj_t symbol1545___tvector = BUNSPEC;
static obj_t symbol1544___tvector = BUNSPEC;
static obj_t symbol1539___tvector = BUNSPEC;
static obj_t symbol1540___tvector = BUNSPEC;
static obj_t symbol1538___tvector = BUNSPEC;
static obj_t symbol1537___tvector = BUNSPEC;
static obj_t symbol1535___tvector = BUNSPEC;
static obj_t symbol1534___tvector = BUNSPEC;
static obj_t symbol1533___tvector = BUNSPEC;
static obj_t symbol1532___tvector = BUNSPEC;
static obj_t symbol1529___tvector = BUNSPEC;
static obj_t symbol1528___tvector = BUNSPEC;
static obj_t symbol1527___tvector = BUNSPEC;
static obj_t symbol1524___tvector = BUNSPEC;
static obj_t symbol1522___tvector = BUNSPEC;
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( get_tvector_descriptor_env_131___tvector, _get_tvector_descriptor1219_87___tvector1564, _get_tvector_descriptor1219_87___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector__tvector_env_31___tvector, _vector__tvector1223_93___tvector1565, _vector__tvector1223_93___tvector, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( tvector_id_env_194___tvector, _tvector_id1218_171___tvector1566, _tvector_id1218_171___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( tvector__env_57___tvector, _tvector__38___tvector1567, _tvector__38___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( declare_tvector__env_37___tvector, _declare_tvector_1220_57___tvector1568, _declare_tvector_1220_57___tvector, 0L, 4 );
DEFINE_EXPORT_PROCEDURE( list__tvector_env_64___tvector, _list__tvector1222_24___tvector1569, _list__tvector1222_24___tvector, 0L, 2 );
DEFINE_STRING( string1559___tvector, string1559___tvector1570, "vector-set!", 11 );
DEFINE_STRING( string1560___tvector, string1560___tvector1571, "tvector->vector", 15 );
DEFINE_STRING( string1555___tvector, string1555___tvector1572, "TVECTOR->VECTOR:Wrong number of arguments", 41 );
DEFINE_STRING( string1553___tvector, string1553___tvector1573, "VECTOR", 6 );
DEFINE_STRING( string1551___tvector, string1551___tvector1574, "vector->tvector", 15 );
DEFINE_STRING( string1548___tvector, string1548___tvector1575, "index out of range", 18 );
DEFINE_STRING( string1547___tvector, string1547___tvector1576, "vector-ref", 10 );
DEFINE_STRING( string1546___tvector, string1546___tvector1577, "VECTOR->TVECTOR:Wrong number of arguments", 41 );
DEFINE_STRING( string1543___tvector, string1543___tvector1578, "Undeclared tvector", 18 );
DEFINE_STRING( string1542___tvector, string1542___tvector1579, "Unable to convert to such tvector", 33 );
DEFINE_STRING( string1541___tvector, string1541___tvector1580, "list->tvector", 13 );
DEFINE_EXPORT_PROCEDURE( tvector__vector_env_184___tvector, _tvector__vector1224_155___tvector1581, _tvector__vector1224_155___tvector, 0L, 1 );
DEFINE_STRING( string1530___tvector, string1530___tvector1582, "LIST->TVECTOR:Wrong number of arguments", 39 );
DEFINE_STRING( string1526___tvector, string1526___tvector1583, "PROCEDURE", 9 );
DEFINE_STRING( string1525___tvector, string1525___tvector1584, "STRING", 6 );
DEFINE_STRING( string1523___tvector, string1523___tvector1585, "struct-set!:not an instance of", 30 );
DEFINE_STRING( string1521___tvector, string1521___tvector1586, "SYMBOL", 6 );
DEFINE_STRING( string1519___tvector, string1519___tvector1587, "PAIR", 4 );
DEFINE_STRING( string1516___tvector, string1516___tvector1588, "/home/tahoe/serrano/trashcan/bigloo/runtime/Llib/error.scm", 58 );
DEFINE_STRING( string1515___tvector, string1515___tvector1589, "TVECT-DESCR", 11 );
DEFINE_STRING( string1514___tvector, string1514___tvector1590, "struct-ref:not an instance of", 29 );
DEFINE_STRING( string1512___tvector, string1512___tvector1591, "STRUCT", 6 );
DEFINE_STRING( string1509___tvector, string1509___tvector1592, "TVECTOR", 7 );
DEFINE_STRING( string1510___tvector, string1510___tvector1593, "/home/tahoe/serrano/trashcan/bigloo/runtime/Llib/tvector.scm", 60 );
DEFINE_EXPORT_PROCEDURE( tvector_ref_env_54___tvector, _tvector_ref1221_206___tvector1594, _tvector_ref1221_206___tvector, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( tvector_length_env_34___tvector, _tvector_length1217_224___tvector1595, _tvector_length1217_224___tvector, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___tvector(long checksum_1138, char * from_1139)
{
if(CBOOL(require_initialization_114___tvector)){
require_initialization_114___tvector = BBOOL(((bool_t)0));
cnst_init_137___tvector();
imported_modules_init_94___tvector();
toplevel_init_63___tvector();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___tvector()
{
symbol1505___tvector = string_to_symbol("TOPLEVEL-INIT");
symbol1506___tvector = string_to_symbol("TVECTOR?");
symbol1507___tvector = string_to_symbol("TVECTOR-LENGTH");
symbol1508___tvector = string_to_symbol("_TVECTOR-LENGTH1217");
symbol1511___tvector = string_to_symbol("TVECTOR-ID");
symbol1513___tvector = string_to_symbol("TVECT-DESCR");
symbol1517___tvector = string_to_symbol("_TVECTOR-ID1218");
symbol1518___tvector = string_to_symbol("GET-TVECTOR-DESCRIPTOR");
symbol1520___tvector = string_to_symbol("_GET-TVECTOR-DESCRIPTOR1219");
symbol1522___tvector = string_to_symbol("DECLARE-TVECTOR!");
symbol1524___tvector = string_to_symbol("_DECLARE-TVECTOR!1220");
symbol1527___tvector = string_to_symbol("TVECTOR-REF");
symbol1528___tvector = string_to_symbol("_TVECTOR-REF1221");
symbol1529___tvector = string_to_symbol("LIST->TVECTOR");
symbol1532___tvector = string_to_symbol("FUNCALL");
symbol1533___tvector = string_to_symbol("allocate");
symbol1534___tvector = string_to_symbol("len");
{
obj_t aux_1163;
{
obj_t aux_1164;
{
obj_t aux_1165;
aux_1165 = MAKE_PAIR(symbol1534___tvector, BNIL);
aux_1164 = MAKE_PAIR(symbol1533___tvector, aux_1165);
}
aux_1163 = MAKE_PAIR(symbol1533___tvector, aux_1164);
}
list1531___tvector = MAKE_PAIR(symbol1532___tvector, aux_1163);
}
symbol1535___tvector = string_to_symbol("_");
symbol1537___tvector = string_to_symbol("set");
symbol1538___tvector = string_to_symbol("tvec");
symbol1539___tvector = string_to_symbol("i");
symbol1540___tvector = string_to_symbol("arg1057");
{
obj_t aux_1175;
{
obj_t aux_1176;
{
obj_t aux_1177;
{
obj_t aux_1178;
{
obj_t aux_1179;
aux_1179 = MAKE_PAIR(symbol1540___tvector, BNIL);
aux_1178 = MAKE_PAIR(symbol1539___tvector, aux_1179);
}
aux_1177 = MAKE_PAIR(symbol1538___tvector, aux_1178);
}
aux_1176 = MAKE_PAIR(symbol1537___tvector, aux_1177);
}
aux_1175 = MAKE_PAIR(symbol1537___tvector, aux_1176);
}
list1536___tvector = MAKE_PAIR(symbol1532___tvector, aux_1175);
}
symbol1544___tvector = string_to_symbol("_LIST->TVECTOR1222");
symbol1545___tvector = string_to_symbol("VECTOR->TVECTOR");
symbol1550___tvector = string_to_symbol("arg1063");
{
obj_t aux_1189;
{
obj_t aux_1190;
{
obj_t aux_1191;
{
obj_t aux_1192;
{
obj_t aux_1193;
aux_1193 = MAKE_PAIR(symbol1550___tvector, BNIL);
aux_1192 = MAKE_PAIR(symbol1539___tvector, aux_1193);
}
aux_1191 = MAKE_PAIR(symbol1538___tvector, aux_1192);
}
aux_1190 = MAKE_PAIR(symbol1537___tvector, aux_1191);
}
aux_1189 = MAKE_PAIR(symbol1537___tvector, aux_1190);
}
list1549___tvector = MAKE_PAIR(symbol1532___tvector, aux_1189);
}
symbol1552___tvector = string_to_symbol("_VECTOR->TVECTOR1223");
symbol1554___tvector = string_to_symbol("TVECTOR->VECTOR");
symbol1557___tvector = string_to_symbol("ref");
symbol1558___tvector = string_to_symbol("tv");
{
obj_t aux_1204;
{
obj_t aux_1205;
{
obj_t aux_1206;
{
obj_t aux_1207;
aux_1207 = MAKE_PAIR(symbol1539___tvector, BNIL);
aux_1206 = MAKE_PAIR(symbol1558___tvector, aux_1207);
}
aux_1205 = MAKE_PAIR(symbol1557___tvector, aux_1206);
}
aux_1204 = MAKE_PAIR(symbol1557___tvector, aux_1205);
}
list1556___tvector = MAKE_PAIR(symbol1532___tvector, aux_1204);
}
symbol1561___tvector = string_to_symbol("_TVECTOR->VECTOR1224");
return (symbol1562___tvector = string_to_symbol("IMPORTED-MODULES-INIT"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___tvector()
{
{
obj_t symbol1196_850;
symbol1196_850 = symbol1505___tvector;
{
PUSH_TRACE(symbol1196_850);
BUNSPEC;
{
obj_t aux1195_851;
aux1195_851 = (_tvector_table__47___tvector = BNIL,
BUNSPEC);
POP_TRACE();
return aux1195_851;
}
}
}
}


/* tvector? */bool_t tvector__195___tvector(obj_t obj_1)
{
{
obj_t symbol1198_1128;
symbol1198_1128 = symbol1506___tvector;
{
PUSH_TRACE(symbol1198_1128);
BUNSPEC;
{
bool_t aux1197_1129;
aux1197_1129 = TVECTORP(obj_1);
POP_TRACE();
return aux1197_1129;
}
}
}
}


/* _tvector? */obj_t _tvector__38___tvector(obj_t env_872, obj_t obj_873)
{
{
bool_t aux_1220;
{
obj_t obj_1130;
obj_1130 = obj_873;
{
obj_t symbol1198_1131;
symbol1198_1131 = symbol1506___tvector;
{
PUSH_TRACE(symbol1198_1131);
BUNSPEC;
{
bool_t aux1197_1132;
aux1197_1132 = TVECTORP(obj_1130);
POP_TRACE();
aux_1220 = aux1197_1132;
}
}
}
}
return BBOOL(aux_1220);
}
}


/* tvector-length */long tvector_length_13___tvector(obj_t obj_2)
{
{
obj_t symbol1200_1133;
symbol1200_1133 = symbol1507___tvector;
{
PUSH_TRACE(symbol1200_1133);
BUNSPEC;
{
long aux1199_1134;
aux1199_1134 = TVECTOR_LENGTH(obj_2);
POP_TRACE();
return aux1199_1134;
}
}
}
}


/* _tvector-length1217 */obj_t _tvector_length1217_224___tvector(obj_t env_874, obj_t obj_875)
{
{
long aux_1228;
{
obj_t obj_1135;
if(TVECTORP(obj_875)){
obj_1135 = obj_875;
}
 else {
bigloo_type_error_location_103___error(symbol1508___tvector, string1509___tvector, obj_875, string1510___tvector, BINT(((long)3541)));
exit( -1 );}
{
obj_t symbol1200_1136;
symbol1200_1136 = symbol1507___tvector;
{
PUSH_TRACE(symbol1200_1136);
BUNSPEC;
{
long aux1199_1137;
aux1199_1137 = TVECTOR_LENGTH(obj_1135);
POP_TRACE();
aux_1228 = aux1199_1137;
}
}
}
}
return BINT(aux_1228);
}
}


/* tvector-id */obj_t tvector_id_255___tvector(obj_t tvect_3)
{
{
obj_t symbol1202_856;
symbol1202_856 = symbol1511___tvector;
{
PUSH_TRACE(symbol1202_856);
BUNSPEC;
{
obj_t aux1201_857;
{
obj_t arg1005_479;
arg1005_479 = TVECTOR_DESCR(tvect_3);
{
bool_t test1042_481;
{
obj_t arg1043_482;
obj_t arg1044_483;
{
obj_t s_484;
if(STRUCTP(arg1005_479)){
s_484 = arg1005_479;
}
 else {
bigloo_type_error_location_103___error(symbol1511___tvector, string1512___tvector, arg1005_479, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1043_482 = STRUCT_KEY(s_484);
}
arg1044_483 = symbol1513___tvector;
test1042_481 = (arg1043_482==arg1044_483);
}
if(test1042_481){
aux1201_857 = STRUCT_REF(arg1005_479, ((long)0));
}
 else {
aux1201_857 = debug_error_location_199___error(string1514___tvector, string1515___tvector, arg1005_479, string1516___tvector, BINT(((long)7610)));
}
}
}
POP_TRACE();
return aux1201_857;
}
}
}
}


/* _tvector-id1218 */obj_t _tvector_id1218_171___tvector(obj_t env_876, obj_t tvect_877)
{
{
obj_t aux_1252;
if(TVECTORP(tvect_877)){
aux_1252 = tvect_877;
}
 else {
bigloo_type_error_location_103___error(symbol1517___tvector, string1509___tvector, tvect_877, string1510___tvector, BINT(((long)3827)));
exit( -1 );}
return tvector_id_255___tvector(aux_1252);
}
}


/* get-tvector-descriptor */obj_t get_tvector_descriptor(obj_t id_22)
{
{
obj_t symbol1204_858;
symbol1204_858 = symbol1518___tvector;
{
PUSH_TRACE(symbol1204_858);
BUNSPEC;
{
obj_t aux1203_859;
{
obj_t cell_616;
cell_616 = assq___r4_pairs_and_lists_6_3(id_22, _tvector_table__47___tvector);
{
bool_t test1048_617;
test1048_617 = PAIRP(cell_616);
if(test1048_617){
obj_t pair_619;
if(test1048_617){
pair_619 = cell_616;
}
 else {
bigloo_type_error_location_103___error(symbol1518___tvector, string1519___tvector, cell_616, string1510___tvector, BINT(((long)5185)));
exit( -1 );}
aux1203_859 = CDR(pair_619);
}
 else {
aux1203_859 = BFALSE;
}
}
}
POP_TRACE();
return aux1203_859;
}
}
}
}


/* _get-tvector-descriptor1219 */obj_t _get_tvector_descriptor1219_87___tvector(obj_t env_878, obj_t id_879)
{
{
obj_t aux_1269;
if(SYMBOLP(id_879)){
aux_1269 = id_879;
}
 else {
bigloo_type_error_location_103___error(symbol1520___tvector, string1521___tvector, id_879, string1510___tvector, BINT(((long)5071)));
exit( -1 );}
return get_tvector_descriptor(aux_1269);
}
}


/* declare-tvector! */obj_t declare_tvector__43___tvector(char * id_23, obj_t allocate_24, obj_t ref_25, obj_t set_26)
{
{
obj_t symbol1206_860;
symbol1206_860 = symbol1522___tvector;
{
PUSH_TRACE(symbol1206_860);
BUNSPEC;
{
obj_t aux1205_861;
{
obj_t id_311;
{
obj_t arg1051_316;
{
bool_t test1052_317;
{
obj_t obj1_620;
obj1_620 = bigloo_case_sensitive;
test1052_317 = (obj1_620==BUNSPEC);
}
if(test1052_317){
arg1051_316 = string_upcase_71___r4_strings_6_7(string_to_bstring(id_23));
}
 else {
arg1051_316 = string_to_bstring(id_23);
}
}
{
char * aux_1282;
aux_1282 = BSTRING_TO_STRING(arg1051_316);
id_311 = string_to_symbol(aux_1282);
}
}
{
obj_t old_312;
{
obj_t cell_624;
cell_624 = assq___r4_pairs_and_lists_6_3(id_311, _tvector_table__47___tvector);
{
bool_t test1048_625;
test1048_625 = PAIRP(cell_624);
if(test1048_625){
obj_t pair_627;
if(test1048_625){
pair_627 = cell_624;
}
 else {
bigloo_type_error_location_103___error(symbol1522___tvector, string1519___tvector, cell_624, string1510___tvector, BINT(((long)5185)));
exit( -1 );}
old_312 = CDR(pair_627);
}
 else {
old_312 = BFALSE;
}
}
}
{
{
bool_t test1049_313;
{
bool_t test1019_629;
test1019_629 = STRUCTP(old_312);
if(test1019_629){
obj_t arg1020_630;
obj_t arg1021_631;
{
obj_t s_633;
if(test1019_629){
s_633 = old_312;
}
 else {
bigloo_type_error_location_103___error(symbol1522___tvector, string1512___tvector, old_312, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1020_630 = STRUCT_KEY(s_633);
}
arg1021_631 = symbol1513___tvector;
test1049_313 = (arg1020_630==arg1021_631);
}
 else {
test1049_313 = ((bool_t)0);
}
}
if(test1049_313){
aux1205_861 = old_312;
}
 else {
obj_t new_314;
{
obj_t new_640;
new_640 = create_struct(symbol1513___tvector, ((long)4));
{
bool_t test_1303;
{
obj_t aux_1304;
aux_1304 = STRUCT_KEY(new_640);
test_1303 = (aux_1304==symbol1513___tvector);
}
if(test_1303){
STRUCT_SET(new_640, ((long)3), set_26);
}
 else {
debug_error_location_199___error(string1523___tvector, string1515___tvector, new_640, string1516___tvector, BINT(((long)7610)));
}
}
{
bool_t test_1310;
{
obj_t aux_1311;
aux_1311 = STRUCT_KEY(new_640);
test_1310 = (aux_1311==symbol1513___tvector);
}
if(test_1310){
STRUCT_SET(new_640, ((long)2), ref_25);
}
 else {
debug_error_location_199___error(string1523___tvector, string1515___tvector, new_640, string1516___tvector, BINT(((long)7610)));
}
}
{
bool_t test_1317;
{
obj_t aux_1318;
aux_1318 = STRUCT_KEY(new_640);
test_1317 = (aux_1318==symbol1513___tvector);
}
if(test_1317){
STRUCT_SET(new_640, ((long)1), allocate_24);
}
 else {
debug_error_location_199___error(string1523___tvector, string1515___tvector, new_640, string1516___tvector, BINT(((long)7610)));
}
}
{
bool_t test_1324;
{
obj_t aux_1325;
aux_1325 = STRUCT_KEY(new_640);
test_1324 = (aux_1325==symbol1513___tvector);
}
if(test_1324){
STRUCT_SET(new_640, ((long)0), id_311);
}
 else {
debug_error_location_199___error(string1523___tvector, string1515___tvector, new_640, string1516___tvector, BINT(((long)7610)));
}
}
new_314 = new_640;
}
{
obj_t arg1050_315;
arg1050_315 = MAKE_PAIR(id_311, new_314);
{
obj_t obj2_690;
obj2_690 = _tvector_table__47___tvector;
_tvector_table__47___tvector = MAKE_PAIR(arg1050_315, obj2_690);
}
}
aux1205_861 = new_314;
}
}
}
}
}
POP_TRACE();
return aux1205_861;
}
}
}
}


/* _declare-tvector!1220 */obj_t _declare_tvector_1220_57___tvector(obj_t env_880, obj_t id_881, obj_t allocate_882, obj_t ref_883, obj_t set_884)
{
{
obj_t aux_1342;
char * aux_1334;
if(PROCEDUREP(allocate_882)){
aux_1342 = allocate_882;
}
 else {
bigloo_type_error_location_103___error(symbol1524___tvector, string1526___tvector, allocate_882, string1510___tvector, BINT(((long)5723)));
exit( -1 );}
{
obj_t aux_1335;
if(STRINGP(id_881)){
aux_1335 = id_881;
}
 else {
bigloo_type_error_location_103___error(symbol1524___tvector, string1525___tvector, id_881, string1510___tvector, BINT(((long)5723)));
exit( -1 );}
aux_1334 = BSTRING_TO_STRING(aux_1335);
}
return declare_tvector__43___tvector(aux_1334, aux_1342, ref_883, set_884);
}
}


/* tvector-ref */obj_t tvector_ref_208___tvector(obj_t tvector_27)
{
{
obj_t symbol1208_862;
symbol1208_862 = symbol1527___tvector;
{
PUSH_TRACE(symbol1208_862);
BUNSPEC;
{
obj_t aux1207_863;
{
obj_t arg1054_691;
arg1054_691 = TVECTOR_DESCR(tvector_27);
{
bool_t test1029_693;
{
obj_t arg1030_694;
obj_t arg1031_695;
{
obj_t s_696;
if(STRUCTP(arg1054_691)){
s_696 = arg1054_691;
}
 else {
bigloo_type_error_location_103___error(symbol1527___tvector, string1512___tvector, arg1054_691, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1030_694 = STRUCT_KEY(s_696);
}
arg1031_695 = symbol1513___tvector;
test1029_693 = (arg1030_694==arg1031_695);
}
if(test1029_693){
aux1207_863 = STRUCT_REF(arg1054_691, ((long)2));
}
 else {
aux1207_863 = debug_error_location_199___error(string1514___tvector, string1515___tvector, arg1054_691, string1516___tvector, BINT(((long)7610)));
}
}
}
POP_TRACE();
return aux1207_863;
}
}
}
}


/* _tvector-ref1221 */obj_t _tvector_ref1221_206___tvector(obj_t env_885, obj_t tvector_886)
{
{
obj_t aux_1363;
if(TVECTORP(tvector_886)){
aux_1363 = tvector_886;
}
 else {
bigloo_type_error_location_103___error(symbol1528___tvector, string1509___tvector, tvector_886, string1510___tvector, BINT(((long)6377)));
exit( -1 );}
return tvector_ref_208___tvector(aux_1363);
}
}


/* list->tvector */obj_t list__tvector_27___tvector(obj_t id_28, obj_t l_29)
{
{
obj_t symbol1210_864;
symbol1210_864 = symbol1529___tvector;
{
PUSH_TRACE(symbol1210_864);
BUNSPEC;
{
obj_t aux1209_865;
{
obj_t descr_320;
{
obj_t cell_703;
cell_703 = assq___r4_pairs_and_lists_6_3(id_28, _tvector_table__47___tvector);
{
bool_t test1048_704;
test1048_704 = PAIRP(cell_703);
if(test1048_704){
obj_t pair_706;
if(test1048_704){
pair_706 = cell_703;
}
 else {
bigloo_type_error_location_103___error(symbol1529___tvector, string1519___tvector, cell_703, string1510___tvector, BINT(((long)5185)));
exit( -1 );}
descr_320 = CDR(pair_706);
}
 else {
descr_320 = BFALSE;
}
}
}
if(CBOOL(descr_320)){
obj_t allocate_321;
obj_t set_322;
{
bool_t test1035_708;
{
obj_t arg1037_709;
obj_t arg1038_710;
{
obj_t s_711;
if(STRUCTP(descr_320)){
s_711 = descr_320;
}
 else {
bigloo_type_error_location_103___error(symbol1529___tvector, string1512___tvector, descr_320, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1037_709 = STRUCT_KEY(s_711);
}
arg1038_710 = symbol1513___tvector;
test1035_708 = (arg1037_709==arg1038_710);
}
if(test1035_708){
allocate_321 = STRUCT_REF(descr_320, ((long)1));
}
 else {
allocate_321 = debug_error_location_199___error(string1514___tvector, string1515___tvector, descr_320, string1516___tvector, BINT(((long)7610)));
}
}
{
bool_t test1022_718;
{
obj_t arg1023_719;
obj_t arg1025_720;
{
obj_t s_721;
if(STRUCTP(descr_320)){
s_721 = descr_320;
}
 else {
bigloo_type_error_location_103___error(symbol1529___tvector, string1512___tvector, descr_320, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1023_719 = STRUCT_KEY(s_721);
}
arg1025_720 = symbol1513___tvector;
test1022_718 = (arg1023_719==arg1025_720);
}
if(test1022_718){
set_322 = STRUCT_REF(descr_320, ((long)3));
}
 else {
set_322 = debug_error_location_199___error(string1514___tvector, string1515___tvector, descr_320, string1516___tvector, BINT(((long)7610)));
}
}
if(PROCEDUREP(set_322)){
long len_324;
len_324 = list_length(l_29);
{
obj_t tvec_325;
{
obj_t fun_986;
if(PROCEDUREP(allocate_321)){
fun_986 = allocate_321;
}
 else {
bigloo_type_error_location_103___error(symbol1529___tvector, string1526___tvector, allocate_321, string1510___tvector, BINT(((long)7068)));
exit( -1 );}
{
bool_t test1343_993;
test1343_993 = PROCEDURE_CORRECT_ARITYP(fun_986, ((long)1));
if(test1343_993){
tvec_325 = PROCEDURE_ENTRY(fun_986)(allocate_321, BINT(len_324), BEOA);
}
 else {
error_location_112___error(string1530___tvector, list1531___tvector, fun_986, string1510___tvector, BINT(((long)7068)));
FAILURE(symbol1535___tvector,symbol1535___tvector,symbol1535___tvector);}
}
}
{
{
obj_t l_326;
long i_327;
l_326 = l_29;
i_327 = ((long)0);
loop_328:
if(NULLP(l_326)){
aux1209_865 = tvec_325;
}
 else {
{
obj_t arg1057_330;
{
obj_t pair_729;
if(PAIRP(l_326)){
pair_729 = l_326;
}
 else {
bigloo_type_error_location_103___error(symbol1529___tvector, string1519___tvector, l_326, string1510___tvector, BINT(((long)7194)));
exit( -1 );}
arg1057_330 = CAR(pair_729);
}
{
obj_t fun_1006;
if(PROCEDUREP(set_322)){
fun_1006 = set_322;
}
 else {
bigloo_type_error_location_103___error(symbol1529___tvector, string1526___tvector, set_322, string1510___tvector, BINT(((long)7181)));
exit( -1 );}
{
bool_t test1369_1013;
test1369_1013 = PROCEDURE_CORRECT_ARITYP(fun_1006, ((long)3));
if(test1369_1013){
PROCEDURE_ENTRY(fun_1006)(set_322, tvec_325, BINT(i_327), arg1057_330, BEOA);
}
 else {
error_location_112___error(string1530___tvector, list1536___tvector, fun_1006, string1510___tvector, BINT(((long)7181)));
FAILURE(symbol1535___tvector,symbol1535___tvector,symbol1535___tvector);}
}
}
}
{
obj_t arg1058_331;
long arg1059_332;
{
obj_t pair_730;
if(PAIRP(l_326)){
pair_730 = l_326;
}
 else {
bigloo_type_error_location_103___error(symbol1529___tvector, string1519___tvector, l_326, string1510___tvector, BINT(((long)7218)));
exit( -1 );}
arg1058_331 = CDR(pair_730);
}
arg1059_332 = (i_327+((long)1));
{
long i_1448;
obj_t l_1447;
l_1447 = arg1058_331;
i_1448 = arg1059_332;
i_327 = i_1448;
l_326 = l_1447;
goto loop_328;
}
}
}
}
}
}
}
 else {
aux1209_865 = debug_error_location_199___error(string1541___tvector, string1542___tvector, id_28, string1516___tvector, BINT(((long)7610)));
}
}
 else {
aux1209_865 = debug_error_location_199___error(string1541___tvector, string1543___tvector, id_28, string1516___tvector, BINT(((long)7610)));
}
}
POP_TRACE();
return aux1209_865;
}
}
}
}


/* _list->tvector1222 */obj_t _list__tvector1222_24___tvector(obj_t env_887, obj_t id_888, obj_t l_889)
{
{
obj_t aux_1460;
obj_t aux_1454;
if(PAIRP(l_889)){
aux_1460 = l_889;
}
 else {
bigloo_type_error_location_103___error(symbol1544___tvector, string1519___tvector, l_889, string1510___tvector, BINT(((long)6677)));
exit( -1 );}
if(SYMBOLP(id_888)){
aux_1454 = id_888;
}
 else {
bigloo_type_error_location_103___error(symbol1544___tvector, string1521___tvector, id_888, string1510___tvector, BINT(((long)6677)));
exit( -1 );}
return list__tvector_27___tvector(aux_1454, aux_1460);
}
}


/* vector->tvector */obj_t vector__tvector_253___tvector(obj_t id_30, obj_t v_31)
{
{
obj_t symbol1212_866;
symbol1212_866 = symbol1545___tvector;
{
PUSH_TRACE(symbol1212_866);
BUNSPEC;
{
obj_t aux1211_867;
{
obj_t descr_333;
{
obj_t cell_740;
cell_740 = assq___r4_pairs_and_lists_6_3(id_30, _tvector_table__47___tvector);
{
bool_t test1048_741;
test1048_741 = PAIRP(cell_740);
if(test1048_741){
obj_t pair_743;
if(test1048_741){
pair_743 = cell_740;
}
 else {
bigloo_type_error_location_103___error(symbol1545___tvector, string1519___tvector, cell_740, string1510___tvector, BINT(((long)5185)));
exit( -1 );}
descr_333 = CDR(pair_743);
}
 else {
descr_333 = BFALSE;
}
}
}
if(CBOOL(descr_333)){
obj_t allocate_334;
obj_t set_335;
{
bool_t test1035_745;
{
obj_t arg1037_746;
obj_t arg1038_747;
{
obj_t s_748;
if(STRUCTP(descr_333)){
s_748 = descr_333;
}
 else {
bigloo_type_error_location_103___error(symbol1545___tvector, string1512___tvector, descr_333, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1037_746 = STRUCT_KEY(s_748);
}
arg1038_747 = symbol1513___tvector;
test1035_745 = (arg1037_746==arg1038_747);
}
if(test1035_745){
allocate_334 = STRUCT_REF(descr_333, ((long)1));
}
 else {
allocate_334 = debug_error_location_199___error(string1514___tvector, string1515___tvector, descr_333, string1516___tvector, BINT(((long)7610)));
}
}
{
bool_t test1022_755;
{
obj_t arg1023_756;
obj_t arg1025_757;
{
obj_t s_758;
if(STRUCTP(descr_333)){
s_758 = descr_333;
}
 else {
bigloo_type_error_location_103___error(symbol1545___tvector, string1512___tvector, descr_333, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1023_756 = STRUCT_KEY(s_758);
}
arg1025_757 = symbol1513___tvector;
test1022_755 = (arg1023_756==arg1025_757);
}
if(test1022_755){
set_335 = STRUCT_REF(descr_333, ((long)3));
}
 else {
set_335 = debug_error_location_199___error(string1514___tvector, string1515___tvector, descr_333, string1516___tvector, BINT(((long)7610)));
}
}
if(PROCEDUREP(set_335)){
long len_337;
len_337 = VECTOR_LENGTH(v_31);
{
obj_t tvec_338;
{
obj_t fun_1056;
if(PROCEDUREP(allocate_334)){
fun_1056 = allocate_334;
}
 else {
bigloo_type_error_location_103___error(symbol1545___tvector, string1526___tvector, allocate_334, string1510___tvector, BINT(((long)7874)));
exit( -1 );}
{
bool_t test1429_1063;
test1429_1063 = PROCEDURE_CORRECT_ARITYP(fun_1056, ((long)1));
if(test1429_1063){
tvec_338 = PROCEDURE_ENTRY(fun_1056)(allocate_334, BINT(len_337), BEOA);
}
 else {
error_location_112___error(string1546___tvector, list1531___tvector, fun_1056, string1510___tvector, BINT(((long)7874)));
FAILURE(symbol1535___tvector,symbol1535___tvector,symbol1535___tvector);}
}
}
{
{
long i_339;
i_339 = (len_337-((long)1));
loop_340:
if((i_339==((long)-1))){
aux1211_867 = tvec_338;
}
 else {
{
obj_t arg1063_343;
{
bool_t test1175_772;
{
long aux_1518;
aux_1518 = VECTOR_LENGTH(v_31);
test1175_772 = BOUND_CHECK(i_339, aux_1518);
}
if(test1175_772){
arg1063_343 = VECTOR_REF(v_31, i_339);
}
 else {
arg1063_343 = debug_error_location_199___error(string1547___tvector, string1548___tvector, BINT(i_339), string1516___tvector, BINT(((long)7610)));
}
}
{
obj_t fun_1070;
if(PROCEDUREP(set_335)){
fun_1070 = set_335;
}
 else {
bigloo_type_error_location_103___error(symbol1545___tvector, string1526___tvector, set_335, string1510___tvector, BINT(((long)7982)));
exit( -1 );}
{
bool_t test1447_1077;
test1447_1077 = PROCEDURE_CORRECT_ARITYP(fun_1070, ((long)3));
if(test1447_1077){
PROCEDURE_ENTRY(fun_1070)(set_335, tvec_338, BINT(i_339), arg1063_343, BEOA);
}
 else {
error_location_112___error(string1546___tvector, list1549___tvector, fun_1070, string1510___tvector, BINT(((long)7982)));
FAILURE(symbol1535___tvector,symbol1535___tvector,symbol1535___tvector);}
}
}
}
{
long i_1539;
i_1539 = (i_339-((long)1));
i_339 = i_1539;
goto loop_340;
}
}
}
}
}
}
 else {
aux1211_867 = debug_error_location_199___error(string1551___tvector, string1542___tvector, id_30, string1516___tvector, BINT(((long)7610)));
}
}
 else {
aux1211_867 = debug_error_location_199___error(string1551___tvector, string1543___tvector, id_30, string1516___tvector, BINT(((long)7610)));
}
}
POP_TRACE();
return aux1211_867;
}
}
}
}


/* _vector->tvector1223 */obj_t _vector__tvector1223_93___tvector(obj_t env_890, obj_t id_891, obj_t v_892)
{
{
obj_t aux_1553;
obj_t aux_1547;
if(VECTORP(v_892)){
aux_1553 = v_892;
}
 else {
bigloo_type_error_location_103___error(symbol1552___tvector, string1553___tvector, v_892, string1510___tvector, BINT(((long)7468)));
exit( -1 );}
if(SYMBOLP(id_891)){
aux_1547 = id_891;
}
 else {
bigloo_type_error_location_103___error(symbol1552___tvector, string1521___tvector, id_891, string1510___tvector, BINT(((long)7468)));
exit( -1 );}
return vector__tvector_253___tvector(aux_1547, aux_1553);
}
}


/* tvector->vector */obj_t tvector__vector_99___tvector(obj_t tv_32)
{
{
obj_t symbol1214_868;
symbol1214_868 = symbol1554___tvector;
{
PUSH_TRACE(symbol1214_868);
BUNSPEC;
{
obj_t aux1213_869;
{
obj_t descr_345;
descr_345 = TVECTOR_DESCR(tv_32);
{
obj_t allocate_346;
obj_t ref_347;
{
bool_t test1035_787;
{
obj_t arg1037_788;
obj_t arg1038_789;
{
obj_t s_790;
if(STRUCTP(descr_345)){
s_790 = descr_345;
}
 else {
bigloo_type_error_location_103___error(symbol1554___tvector, string1512___tvector, descr_345, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1037_788 = STRUCT_KEY(s_790);
}
arg1038_789 = symbol1513___tvector;
test1035_787 = (arg1037_788==arg1038_789);
}
if(test1035_787){
allocate_346 = STRUCT_REF(descr_345, ((long)1));
}
 else {
allocate_346 = debug_error_location_199___error(string1514___tvector, string1515___tvector, descr_345, string1516___tvector, BINT(((long)7610)));
}
}
{
bool_t test1029_797;
{
obj_t arg1030_798;
obj_t arg1031_799;
{
obj_t s_800;
if(STRUCTP(descr_345)){
s_800 = descr_345;
}
 else {
bigloo_type_error_location_103___error(symbol1554___tvector, string1512___tvector, descr_345, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1030_798 = STRUCT_KEY(s_800);
}
arg1031_799 = symbol1513___tvector;
test1029_797 = (arg1030_798==arg1031_799);
}
if(test1029_797){
ref_347 = STRUCT_REF(descr_345, ((long)2));
}
 else {
ref_347 = debug_error_location_199___error(string1514___tvector, string1515___tvector, descr_345, string1516___tvector, BINT(((long)7610)));
}
}
if(PROCEDUREP(ref_347)){
long len_349;
len_349 = TVECTOR_LENGTH(tv_32);
{
obj_t vec_350;
vec_350 = create_vector(len_349);
{
{
long i_351;
i_351 = (len_349-((long)1));
loop_352:
if((i_351==((long)-1))){
aux1213_869 = vec_350;
}
 else {
{
obj_t arg1069_355;
{
obj_t fun_1108;
if(PROCEDUREP(ref_347)){
fun_1108 = ref_347;
}
 else {
bigloo_type_error_location_103___error(symbol1554___tvector, string1526___tvector, ref_347, string1510___tvector, BINT(((long)8742)));
exit( -1 );}
{
bool_t test1490_1115;
test1490_1115 = PROCEDURE_CORRECT_ARITYP(fun_1108, ((long)2));
if(test1490_1115){
arg1069_355 = PROCEDURE_ENTRY(fun_1108)(ref_347, tv_32, BINT(i_351), BEOA);
}
 else {
error_location_112___error(string1555___tvector, list1556___tvector, fun_1108, string1510___tvector, BINT(((long)8742)));
FAILURE(symbol1535___tvector,symbol1535___tvector,symbol1535___tvector);}
}
}
{
bool_t test1173_815;
{
long aux_1603;
aux_1603 = VECTOR_LENGTH(vec_350);
test1173_815 = BOUND_CHECK(i_351, aux_1603);
}
if(test1173_815){
VECTOR_SET(vec_350, i_351, arg1069_355);
}
 else {
debug_error_location_199___error(string1559___tvector, string1548___tvector, BINT(i_351), string1516___tvector, BINT(((long)7610)));
}
}
}
{
long i_1611;
i_1611 = (i_351-((long)1));
i_351 = i_1611;
goto loop_352;
}
}
}
}
}
}
 else {
obj_t arg1076_359;
{
bool_t test1042_826;
{
obj_t arg1043_827;
obj_t arg1044_828;
{
obj_t s_829;
if(STRUCTP(descr_345)){
s_829 = descr_345;
}
 else {
bigloo_type_error_location_103___error(symbol1554___tvector, string1512___tvector, descr_345, string1510___tvector, BINT(((long)4342)));
exit( -1 );}
arg1043_827 = STRUCT_KEY(s_829);
}
arg1044_828 = symbol1513___tvector;
test1042_826 = (arg1043_827==arg1044_828);
}
if(test1042_826){
arg1076_359 = STRUCT_REF(descr_345, ((long)0));
}
 else {
arg1076_359 = debug_error_location_199___error(string1514___tvector, string1515___tvector, descr_345, string1516___tvector, BINT(((long)7610)));
}
}
aux1213_869 = debug_error_location_199___error(string1560___tvector, string1542___tvector, arg1076_359, string1516___tvector, BINT(((long)7610)));
}
}
}
POP_TRACE();
return aux1213_869;
}
}
}
}


/* _tvector->vector1224 */obj_t _tvector__vector1224_155___tvector(obj_t env_893, obj_t tv_894)
{
{
obj_t aux_1628;
if(TVECTORP(tv_894)){
aux_1628 = tv_894;
}
 else {
bigloo_type_error_location_103___error(symbol1561___tvector, string1509___tvector, tv_894, string1510___tvector, BINT(((long)8270)));
exit( -1 );}
return tvector__vector_99___tvector(aux_1628);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___tvector()
{
{
obj_t symbol1216_870;
symbol1216_870 = symbol1562___tvector;
{
PUSH_TRACE(symbol1216_870);
BUNSPEC;
{
obj_t aux1215_871;
module_initialization_70___error(((long)0), "__TVECTOR");
aux1215_871 = module_initialization_70___hash(((long)0), "__TVECTOR");
POP_TRACE();
return aux1215_871;
}
}
}
}

