/*===========================================================================*/
/*   (Llib/socket.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

/* debug mode */
#define BIGLOO_DEBUG 1

#include <bigloo2.0a.h>
#include <signal.h>

static obj_t _socket_down_1175_102___socket(obj_t, obj_t);
extern obj_t socket_host_address_114___socket(obj_t);
extern obj_t string_to_symbol(char *);
extern obj_t socket_port_number_142___socket(obj_t);
static obj_t _socket_output1178_115___socket(obj_t, obj_t);
static obj_t symbol1325___socket = BUNSPEC;
static obj_t symbol1324___socket = BUNSPEC;
static obj_t symbol1323___socket = BUNSPEC;
static obj_t symbol1322___socket = BUNSPEC;
static obj_t symbol1321___socket = BUNSPEC;
static obj_t symbol1319___socket = BUNSPEC;
static obj_t symbol1320___socket = BUNSPEC;
static obj_t symbol1318___socket = BUNSPEC;
static obj_t symbol1317___socket = BUNSPEC;
static obj_t symbol1315___socket = BUNSPEC;
static obj_t symbol1312___socket = BUNSPEC;
static obj_t symbol1311___socket = BUNSPEC;
static obj_t symbol1309___socket = BUNSPEC;
static obj_t symbol1310___socket = BUNSPEC;
static obj_t symbol1298___socket = BUNSPEC;
static obj_t symbol1308___socket = BUNSPEC;
static obj_t symbol1297___socket = BUNSPEC;
static obj_t symbol1307___socket = BUNSPEC;
static obj_t symbol1296___socket = BUNSPEC;
static obj_t symbol1306___socket = BUNSPEC;
static obj_t symbol1305___socket = BUNSPEC;
static obj_t symbol1304___socket = BUNSPEC;
static obj_t symbol1303___socket = BUNSPEC;
static obj_t symbol1302___socket = BUNSPEC;
static obj_t symbol1301___socket = BUNSPEC;
static obj_t _socket_shutdown1183_81___socket(obj_t, obj_t, obj_t);
static obj_t _socket_hostname1173_60___socket(obj_t, obj_t);
extern obj_t socket_output_115___socket(obj_t);
static obj_t _socket_input1177_15___socket(obj_t, obj_t);
extern obj_t socket_shutdown(obj_t, bool_t);
extern obj_t make_server_socket(int);
extern obj_t socket_dup_120___socket(obj_t);
static obj_t _socket_port_number1176_106___socket(obj_t, obj_t);
extern obj_t bigloo_type_error_location_103___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern bool_t socket_down__159___socket(obj_t);
extern obj_t socket_local_addr(obj_t);
extern obj_t make_server_socket_214___socket(obj_t);
extern obj_t socket_dup(obj_t);
static obj_t _make_server_socket_127___socket(obj_t, obj_t);
extern obj_t module_initialization_70___socket(long, char *);
extern obj_t module_initialization_70___error(long, char *);
static obj_t _make_client_socket1179_125___socket(obj_t, obj_t, obj_t);
static obj_t _socket_local_address1181_238___socket(obj_t, obj_t);
static obj_t _socket_dup1182_230___socket(obj_t, obj_t);
static obj_t _socket_accept_connection1180_34___socket(obj_t, obj_t);
static obj_t _socket__179___socket(obj_t, obj_t);
extern obj_t make_client_socket(obj_t, int);
extern obj_t socket_accept_connection(obj_t);
extern obj_t socket_shutdown_97___socket(obj_t, obj_t);
extern obj_t make_client_socket_228___socket(obj_t, int);
extern obj_t socket_hostname_170___socket(obj_t);
static obj_t imported_modules_init_94___socket();
extern bool_t socket__65___socket(obj_t);
extern obj_t socket_accept_connection_52___socket(obj_t);
extern obj_t socket_local_address_209___socket(obj_t);
static obj_t require_initialization_114___socket = BUNSPEC;
static obj_t _socket_host_address1174_119___socket(obj_t, obj_t);
static obj_t cnst_init_137___socket();
extern obj_t socket_input_208___socket(obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( socket_input_env_54___socket, _socket_input1177_15___socket1327, _socket_input1177_15___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_client_socket_env_140___socket, _make_client_socket1179_125___socket1328, _make_client_socket1179_125___socket, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( socket__env_32___socket, _socket__179___socket1329, _socket__179___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_shutdown_env_247___socket, _socket_shutdown1183_81___socket1330, va_generic_entry, _socket_shutdown1183_81___socket, -2 );
DEFINE_EXPORT_PROCEDURE( socket_hostname_env_89___socket, _socket_hostname1173_60___socket1331, _socket_hostname1173_60___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_host_address_env_16___socket, _socket_host_address1174_119___socket1332, _socket_host_address1174_119___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_local_address_env_78___socket, _socket_local_address1181_238___socket1333, _socket_local_address1181_238___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_dup_env_192___socket, _socket_dup1182_230___socket1334, _socket_dup1182_230___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_output_env_172___socket, _socket_output1178_115___socket1335, _socket_output1178_115___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_accept_connection_env_59___socket, _socket_accept_connection1180_34___socket1336, _socket_accept_connection1180_34___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( socket_down__env_139___socket, _socket_down_1175_102___socket1337, _socket_down_1175_102___socket, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_server_socket_env_103___socket, _make_server_socket_127___socket1338, va_generic_entry, _make_server_socket_127___socket, -1 );
DEFINE_EXPORT_PROCEDURE( socket_port_number_env_160___socket, _socket_port_number1176_106___socket1339, _socket_port_number1176_106___socket, 0L, 1 );
DEFINE_STRING( string1316___socket, string1316___socket1340, "PAIR", 4 );
DEFINE_STRING( string1314___socket, string1314___socket1341, "INT", 3 );
DEFINE_STRING( string1313___socket, string1313___socket1342, "BSTRING", 7 );
DEFINE_STRING( string1299___socket, string1299___socket1343, "SOCKET", 6 );
DEFINE_STRING( string1300___socket, string1300___socket1344, "/home/tahoe/serrano/trashcan/bigloo/runtime/Llib/socket.scm", 59 );


/* module-initialization */obj_t module_initialization_70___socket(long checksum_645, char * from_646)
{
if(CBOOL(require_initialization_114___socket)){
require_initialization_114___socket = BBOOL(((bool_t)0));
cnst_init_137___socket();
imported_modules_init_94___socket();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___socket()
{
symbol1296___socket = string_to_symbol("SOCKET?");
symbol1297___socket = string_to_symbol("SOCKET-HOSTNAME");
symbol1298___socket = string_to_symbol("_SOCKET-HOSTNAME1173");
symbol1301___socket = string_to_symbol("SOCKET-HOST-ADDRESS");
symbol1302___socket = string_to_symbol("_SOCKET-HOST-ADDRESS1174");
symbol1303___socket = string_to_symbol("SOCKET-DOWN?");
symbol1304___socket = string_to_symbol("_SOCKET-DOWN?1175");
symbol1305___socket = string_to_symbol("SOCKET-PORT-NUMBER");
symbol1306___socket = string_to_symbol("_SOCKET-PORT-NUMBER1176");
symbol1307___socket = string_to_symbol("SOCKET-INPUT");
symbol1308___socket = string_to_symbol("_SOCKET-INPUT1177");
symbol1309___socket = string_to_symbol("SOCKET-OUTPUT");
symbol1310___socket = string_to_symbol("_SOCKET-OUTPUT1178");
symbol1311___socket = string_to_symbol("MAKE-CLIENT-SOCKET");
symbol1312___socket = string_to_symbol("_MAKE-CLIENT-SOCKET1179");
symbol1315___socket = string_to_symbol("MAKE-SERVER-SOCKET");
symbol1317___socket = string_to_symbol("SOCKET-ACCEPT-CONNECTION");
symbol1318___socket = string_to_symbol("_SOCKET-ACCEPT-CONNECTION1180");
symbol1319___socket = string_to_symbol("SOCKET-LOCAL-ADDRESS");
symbol1320___socket = string_to_symbol("_SOCKET-LOCAL-ADDRESS1181");
symbol1321___socket = string_to_symbol("SOCKET-DUP");
symbol1322___socket = string_to_symbol("_SOCKET-DUP1182");
symbol1323___socket = string_to_symbol("SOCKET-SHUTDOWN");
symbol1324___socket = string_to_symbol("_SOCKET-SHUTDOWN1183");
return (symbol1325___socket = string_to_symbol("IMPORTED-MODULES-INIT"),
BUNSPEC);
}


/* socket? */bool_t socket__65___socket(obj_t obj_1)
{
{
obj_t symbol1146_568;
symbol1146_568 = symbol1296___socket;
{
PUSH_TRACE(symbol1146_568);
BUNSPEC;
{
bool_t aux1145_569;
aux1145_569 = SOCKETP(obj_1);
POP_TRACE();
return aux1145_569;
}
}
}
}


/* _socket? */obj_t _socket__179___socket(obj_t env_450, obj_t obj_451)
{
{
bool_t aux_680;
{
obj_t obj_570;
obj_570 = obj_451;
{
obj_t symbol1146_571;
symbol1146_571 = symbol1296___socket;
{
PUSH_TRACE(symbol1146_571);
BUNSPEC;
{
bool_t aux1145_572;
aux1145_572 = SOCKETP(obj_570);
POP_TRACE();
aux_680 = aux1145_572;
}
}
}
}
return BBOOL(aux_680);
}
}


/* socket-hostname */obj_t socket_hostname_170___socket(obj_t socket_2)
{
{
obj_t symbol1148_573;
symbol1148_573 = symbol1297___socket;
{
PUSH_TRACE(symbol1148_573);
BUNSPEC;
{
obj_t aux1147_574;
aux1147_574 = SOCKET_HOSTNAME(socket_2);
POP_TRACE();
return aux1147_574;
}
}
}
}


/* _socket-hostname1173 */obj_t _socket_hostname1173_60___socket(obj_t env_452, obj_t socket_453)
{
{
obj_t socket_575;
{
bool_t test1185_479;
test1185_479 = SOCKETP(socket_453);
if(test1185_479){
socket_575 = socket_453;
}
 else {
bigloo_type_error_location_103___error(symbol1298___socket, string1299___socket, socket_453, string1300___socket, BINT(((long)3948)));
exit( -1 );}
}
{
obj_t symbol1148_576;
symbol1148_576 = symbol1297___socket;
{
PUSH_TRACE(symbol1148_576);
BUNSPEC;
{
obj_t aux1147_577;
aux1147_577 = SOCKET_HOSTNAME(socket_575);
POP_TRACE();
return aux1147_577;
}
}
}
}
}


/* socket-host-address */obj_t socket_host_address_114___socket(obj_t socket_3)
{
{
obj_t symbol1150_578;
symbol1150_578 = symbol1301___socket;
{
PUSH_TRACE(symbol1150_578);
BUNSPEC;
{
obj_t aux1149_579;
aux1149_579 = SOCKET_HOSTIP(socket_3);
POP_TRACE();
return aux1149_579;
}
}
}
}


/* _socket-host-address1174 */obj_t _socket_host_address1174_119___socket(obj_t env_454, obj_t socket_455)
{
{
obj_t socket_580;
{
bool_t test1191_485;
test1191_485 = SOCKETP(socket_455);
if(test1191_485){
socket_580 = socket_455;
}
 else {
bigloo_type_error_location_103___error(symbol1302___socket, string1299___socket, socket_455, string1300___socket, BINT(((long)4259)));
exit( -1 );}
}
{
obj_t symbol1150_581;
symbol1150_581 = symbol1301___socket;
{
PUSH_TRACE(symbol1150_581);
BUNSPEC;
{
obj_t aux1149_582;
aux1149_582 = SOCKET_HOSTIP(socket_580);
POP_TRACE();
return aux1149_582;
}
}
}
}
}


/* socket-down? */bool_t socket_down__159___socket(obj_t socket_4)
{
{
obj_t symbol1152_583;
symbol1152_583 = symbol1303___socket;
{
PUSH_TRACE(symbol1152_583);
BUNSPEC;
{
bool_t aux1151_584;
aux1151_584 = SOCKET_DOWNP(socket_4);
POP_TRACE();
return aux1151_584;
}
}
}
}


/* _socket-down?1175 */obj_t _socket_down_1175_102___socket(obj_t env_456, obj_t socket_457)
{
{
bool_t aux_710;
{
obj_t socket_585;
{
bool_t test1197_491;
test1197_491 = SOCKETP(socket_457);
if(test1197_491){
socket_585 = socket_457;
}
 else {
bigloo_type_error_location_103___error(symbol1304___socket, string1299___socket, socket_457, string1300___socket, BINT(((long)4572)));
exit( -1 );}
}
{
obj_t symbol1152_586;
symbol1152_586 = symbol1303___socket;
{
PUSH_TRACE(symbol1152_586);
BUNSPEC;
{
bool_t aux1151_587;
aux1151_587 = SOCKET_DOWNP(socket_585);
POP_TRACE();
aux_710 = aux1151_587;
}
}
}
}
return BBOOL(aux_710);
}
}


/* socket-port-number */obj_t socket_port_number_142___socket(obj_t socket_5)
{
{
obj_t symbol1154_588;
symbol1154_588 = symbol1305___socket;
{
PUSH_TRACE(symbol1154_588);
BUNSPEC;
{
obj_t aux1153_589;
{
int aux_721;
aux_721 = SOCKET_PORT(socket_5);
aux1153_589 = BINT(aux_721);
}
POP_TRACE();
return aux1153_589;
}
}
}
}


/* _socket-port-number1176 */obj_t _socket_port_number1176_106___socket(obj_t env_458, obj_t socket_459)
{
{
obj_t socket_590;
{
bool_t test1204_497;
test1204_497 = SOCKETP(socket_459);
if(test1204_497){
socket_590 = socket_459;
}
 else {
bigloo_type_error_location_103___error(symbol1306___socket, string1299___socket, socket_459, string1300___socket, BINT(((long)4874)));
exit( -1 );}
}
{
obj_t symbol1154_591;
symbol1154_591 = symbol1305___socket;
{
PUSH_TRACE(symbol1154_591);
BUNSPEC;
{
obj_t aux1153_592;
{
int aux_731;
aux_731 = SOCKET_PORT(socket_590);
aux1153_592 = BINT(aux_731);
}
POP_TRACE();
return aux1153_592;
}
}
}
}
}


/* socket-input */obj_t socket_input_208___socket(obj_t socket_6)
{
{
obj_t symbol1156_593;
symbol1156_593 = symbol1307___socket;
{
PUSH_TRACE(symbol1156_593);
BUNSPEC;
{
obj_t aux1155_594;
aux1155_594 = SOCKET_INPUT(socket_6);
POP_TRACE();
return aux1155_594;
}
}
}
}


/* _socket-input1177 */obj_t _socket_input1177_15___socket(obj_t env_460, obj_t socket_461)
{
{
obj_t socket_595;
{
bool_t test1211_503;
test1211_503 = SOCKETP(socket_461);
if(test1211_503){
socket_595 = socket_461;
}
 else {
bigloo_type_error_location_103___error(symbol1308___socket, string1299___socket, socket_461, string1300___socket, BINT(((long)5188)));
exit( -1 );}
}
{
obj_t symbol1156_596;
symbol1156_596 = symbol1307___socket;
{
PUSH_TRACE(symbol1156_596);
BUNSPEC;
{
obj_t aux1155_597;
aux1155_597 = SOCKET_INPUT(socket_595);
POP_TRACE();
return aux1155_597;
}
}
}
}
}


/* socket-output */obj_t socket_output_115___socket(obj_t socket_7)
{
{
obj_t symbol1158_598;
symbol1158_598 = symbol1309___socket;
{
PUSH_TRACE(symbol1158_598);
BUNSPEC;
{
obj_t aux1157_599;
aux1157_599 = SOCKET_OUTPUT(socket_7);
POP_TRACE();
return aux1157_599;
}
}
}
}


/* _socket-output1178 */obj_t _socket_output1178_115___socket(obj_t env_462, obj_t socket_463)
{
{
obj_t socket_600;
{
bool_t test1221_509;
test1221_509 = SOCKETP(socket_463);
if(test1221_509){
socket_600 = socket_463;
}
 else {
bigloo_type_error_location_103___error(symbol1310___socket, string1299___socket, socket_463, string1300___socket, BINT(((long)5484)));
exit( -1 );}
}
{
obj_t symbol1158_601;
symbol1158_601 = symbol1309___socket;
{
PUSH_TRACE(symbol1158_601);
BUNSPEC;
{
obj_t aux1157_602;
aux1157_602 = SOCKET_OUTPUT(socket_600);
POP_TRACE();
return aux1157_602;
}
}
}
}
}


/* make-client-socket */obj_t make_client_socket_228___socket(obj_t hostname_8, int port_number_220_9)
{
{
obj_t symbol1160_603;
symbol1160_603 = symbol1311___socket;
{
PUSH_TRACE(symbol1160_603);
BUNSPEC;
{
obj_t aux1159_604;
aux1159_604 = make_client_socket(hostname_8, port_number_220_9);
POP_TRACE();
return aux1159_604;
}
}
}
}


/* _make-client-socket1179 */obj_t _make_client_socket1179_125___socket(obj_t env_464, obj_t hostname_465, obj_t port_number_220_466)
{
{
obj_t hostname_605;
int port_number_220_606;
if(STRINGP(hostname_465)){
hostname_605 = hostname_465;
}
 else {
bigloo_type_error_location_103___error(symbol1312___socket, string1313___socket, hostname_465, string1300___socket, BINT(((long)5782)));
exit( -1 );}
{
obj_t aux_765;
if(INTEGERP(port_number_220_466)){
aux_765 = port_number_220_466;
}
 else {
bigloo_type_error_location_103___error(symbol1312___socket, string1314___socket, port_number_220_466, string1300___socket, BINT(((long)5782)));
exit( -1 );}
port_number_220_606 = CINT(aux_765);
}
{
obj_t symbol1160_607;
symbol1160_607 = symbol1311___socket;
{
PUSH_TRACE(symbol1160_607);
BUNSPEC;
{
obj_t aux1159_608;
aux1159_608 = make_client_socket(hostname_605, port_number_220_606);
POP_TRACE();
return aux1159_608;
}
}
}
}
}


/* make-server-socket */obj_t make_server_socket_214___socket(obj_t port_number_220_10)
{
{
obj_t symbol1162_609;
symbol1162_609 = symbol1315___socket;
{
PUSH_TRACE(symbol1162_609);
BUNSPEC;
{
obj_t aux1161_610;
{
obj_t arg1006_611;
if(NULLP(port_number_220_10)){
arg1006_611 = BINT(((long)0));
}
 else {
obj_t pair_612;
if(PAIRP(port_number_220_10)){
pair_612 = port_number_220_10;
}
 else {
bigloo_type_error_location_103___error(symbol1315___socket, string1316___socket, port_number_220_10, string1300___socket, BINT(((long)6228)));
exit( -1 );}
arg1006_611 = CAR(pair_612);
}
{
int aux_785;
{
obj_t aux_786;
if(INTEGERP(arg1006_611)){
aux_786 = arg1006_611;
}
 else {
bigloo_type_error_location_103___error(symbol1315___socket, string1314___socket, arg1006_611, string1300___socket, BINT(((long)6179)));
exit( -1 );}
aux_785 = CINT(aux_786);
}
aux1161_610 = make_server_socket(aux_785);
}
}
POP_TRACE();
return aux1161_610;
}
}
}
}


/* _make-server-socket */obj_t _make_server_socket_127___socket(obj_t env_467, obj_t port_number_220_468)
{
{
obj_t port_number_220_613;
port_number_220_613 = port_number_220_468;
{
obj_t symbol1162_614;
symbol1162_614 = symbol1315___socket;
{
PUSH_TRACE(symbol1162_614);
BUNSPEC;
{
obj_t aux1161_615;
{
obj_t arg1006_616;
if(NULLP(port_number_220_613)){
arg1006_616 = BINT(((long)0));
}
 else {
obj_t pair_617;
if(PAIRP(port_number_220_613)){
pair_617 = port_number_220_613;
}
 else {
bigloo_type_error_location_103___error(symbol1315___socket, string1316___socket, port_number_220_613, string1300___socket, BINT(((long)6228)));
exit( -1 );}
arg1006_616 = CAR(pair_617);
}
{
int aux_805;
{
obj_t aux_806;
if(INTEGERP(arg1006_616)){
aux_806 = arg1006_616;
}
 else {
bigloo_type_error_location_103___error(symbol1315___socket, string1314___socket, arg1006_616, string1300___socket, BINT(((long)6179)));
exit( -1 );}
aux_805 = CINT(aux_806);
}
aux1161_615 = make_server_socket(aux_805);
}
}
POP_TRACE();
return aux1161_615;
}
}
}
}
}


/* socket-accept-connection */obj_t socket_accept_connection_52___socket(obj_t socket_11)
{
{
obj_t symbol1164_618;
symbol1164_618 = symbol1317___socket;
{
PUSH_TRACE(symbol1164_618);
BUNSPEC;
{
obj_t aux1163_619;
aux1163_619 = socket_accept_connection(socket_11);
POP_TRACE();
return aux1163_619;
}
}
}
}


/* _socket-accept-connection1180 */obj_t _socket_accept_connection1180_34___socket(obj_t env_469, obj_t socket_470)
{
{
obj_t socket_620;
{
bool_t test1260_539;
test1260_539 = SOCKETP(socket_470);
if(test1260_539){
socket_620 = socket_470;
}
 else {
bigloo_type_error_location_103___error(symbol1318___socket, string1299___socket, socket_470, string1300___socket, BINT(((long)6471)));
exit( -1 );}
}
{
obj_t symbol1164_621;
symbol1164_621 = symbol1317___socket;
{
PUSH_TRACE(symbol1164_621);
BUNSPEC;
{
obj_t aux1163_622;
aux1163_622 = socket_accept_connection(socket_620);
POP_TRACE();
return aux1163_622;
}
}
}
}
}


/* socket-local-address */obj_t socket_local_address_209___socket(obj_t socket_12)
{
{
obj_t symbol1166_623;
symbol1166_623 = symbol1319___socket;
{
PUSH_TRACE(symbol1166_623);
BUNSPEC;
{
obj_t aux1165_624;
aux1165_624 = socket_local_addr(socket_12);
POP_TRACE();
return aux1165_624;
}
}
}
}


/* _socket-local-address1181 */obj_t _socket_local_address1181_238___socket(obj_t env_471, obj_t socket_472)
{
{
obj_t socket_625;
{
bool_t test1269_545;
test1269_545 = SOCKETP(socket_472);
if(test1269_545){
socket_625 = socket_472;
}
 else {
bigloo_type_error_location_103___error(symbol1320___socket, string1299___socket, socket_472, string1300___socket, BINT(((long)6796)));
exit( -1 );}
}
{
obj_t symbol1166_626;
symbol1166_626 = symbol1319___socket;
{
PUSH_TRACE(symbol1166_626);
BUNSPEC;
{
obj_t aux1165_627;
aux1165_627 = socket_local_addr(socket_625);
POP_TRACE();
return aux1165_627;
}
}
}
}
}


/* socket-dup */obj_t socket_dup_120___socket(obj_t socket_13)
{
{
obj_t symbol1168_628;
symbol1168_628 = symbol1321___socket;
{
PUSH_TRACE(symbol1168_628);
BUNSPEC;
{
obj_t aux1167_629;
aux1167_629 = socket_dup(socket_13);
POP_TRACE();
return aux1167_629;
}
}
}
}


/* _socket-dup1182 */obj_t _socket_dup1182_230___socket(obj_t env_473, obj_t socket_474)
{
{
obj_t socket_630;
{
bool_t test1276_551;
test1276_551 = SOCKETP(socket_474);
if(test1276_551){
socket_630 = socket_474;
}
 else {
bigloo_type_error_location_103___error(symbol1322___socket, string1299___socket, socket_474, string1300___socket, BINT(((long)7105)));
exit( -1 );}
}
{
obj_t symbol1168_631;
symbol1168_631 = symbol1321___socket;
{
PUSH_TRACE(symbol1168_631);
BUNSPEC;
{
obj_t aux1167_632;
aux1167_632 = socket_dup(socket_630);
POP_TRACE();
return aux1167_632;
}
}
}
}
}


/* socket-shutdown */obj_t socket_shutdown_97___socket(obj_t socket_14, obj_t close_15)
{
{
obj_t symbol1170_633;
symbol1170_633 = symbol1323___socket;
{
PUSH_TRACE(symbol1170_633);
BUNSPEC;
{
obj_t aux1169_634;
{
obj_t arg1008_635;
{
bool_t test1009_636;
test1009_636 = PAIRP(close_15);
if(test1009_636){
obj_t pair_637;
if(test1009_636){
pair_637 = close_15;
}
 else {
bigloo_type_error_location_103___error(symbol1323___socket, string1316___socket, close_15, string1300___socket, BINT(((long)7509)));
exit( -1 );}
arg1008_635 = CAR(pair_637);
}
 else {
arg1008_635 = BTRUE;
}
}
{
bool_t aux_856;
aux_856 = CBOOL(arg1008_635);
aux1169_634 = socket_shutdown(socket_14, aux_856);
}
}
POP_TRACE();
return aux1169_634;
}
}
}
}


/* _socket-shutdown1183 */obj_t _socket_shutdown1183_81___socket(obj_t env_475, obj_t socket_476, obj_t close_477)
{
{
obj_t socket_638;
obj_t close_639;
{
bool_t test1290_563;
test1290_563 = SOCKETP(socket_476);
if(test1290_563){
socket_638 = socket_476;
}
 else {
bigloo_type_error_location_103___error(symbol1324___socket, string1299___socket, socket_476, string1300___socket, BINT(((long)7405)));
exit( -1 );}
}
close_639 = close_477;
{
obj_t symbol1170_640;
symbol1170_640 = symbol1323___socket;
{
PUSH_TRACE(symbol1170_640);
BUNSPEC;
{
obj_t aux1169_641;
{
obj_t arg1008_642;
{
bool_t test1009_643;
test1009_643 = PAIRP(close_639);
if(test1009_643){
obj_t pair_644;
if(test1009_643){
pair_644 = close_639;
}
 else {
bigloo_type_error_location_103___error(symbol1323___socket, string1316___socket, close_639, string1300___socket, BINT(((long)7509)));
exit( -1 );}
arg1008_642 = CAR(pair_644);
}
 else {
arg1008_642 = BTRUE;
}
}
{
bool_t aux_873;
aux_873 = CBOOL(arg1008_642);
aux1169_641 = socket_shutdown(socket_638, aux_873);
}
}
POP_TRACE();
return aux1169_641;
}
}
}
}
}


/* imported-modules-init */obj_t imported_modules_init_94___socket()
{
{
obj_t symbol1172_448;
symbol1172_448 = symbol1325___socket;
{
PUSH_TRACE(symbol1172_448);
BUNSPEC;
{
obj_t aux1171_449;
aux1171_449 = module_initialization_70___error(((long)0), "__SOCKET");
POP_TRACE();
return aux1171_449;
}
}
}
}

