/*===========================================================================*/
/*   (Llib/intext.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

/* debug mode */
#define BIGLOO_DEBUG 1

#include <bigloo2.0a.h>
#include <signal.h>


/* Object type definitions */

extern obj_t set_obj_string_mode__22___intext(obj_t);
static obj_t method_init_76___intext();
extern obj_t string_to_symbol(char *);
static obj_t read_string_238___intext(obj_t);
static obj_t _string__obj_110___intext(obj_t, obj_t);
static obj_t _defining__224___intext = BUNSPEC;
static long _pointeur__164___intext;
static obj_t _obj__string_80___intext(obj_t, obj_t);
static obj_t print_di_101___intext(obj_t, obj_t, obj_t);
extern obj_t string_to_obj(obj_t);
static obj_t pair_mark__18___intext(obj_t);
static obj_t _string_mark_table__203___intext = BUNSPEC;
static obj_t ucs2_string_mark__64___intext(obj_t);
static obj_t print_marqueur_131___intext(obj_t, obj_t, unsigned char);
extern obj_t remprop__243___r4_symbols_6_4(obj_t, obj_t);
extern obj_t obj_to_string(obj_t);
extern object_t struct_object__object_93___object(object_t, obj_t);
extern ucs2_t integer__ucs2_47___ucs2(long);
static bool_t _epair___65___intext;
static obj_t string_mark__64___intext(obj_t);
static obj_t tvector_mark__214___intext(obj_t, obj_t);
extern obj_t get_hash_29___hash(obj_t, obj_t);
extern object_t allocate_instance_244___object(obj_t);
extern obj_t debug_error_location_199___error(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t get_string_mark_33___intext(obj_t);
extern obj_t module_initialization_70___intext(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t utf8_string_to_ucs2_string(obj_t);
extern obj_t make_hash_table_174___hash(long, obj_t, obj_t, obj_t, obj_t);
extern obj_t list__vector_101___r4_vectors_6_8(obj_t);
static obj_t pair_mark_gc__141___intext(obj_t);
static obj_t mark_item__0___intext(obj_t);
static obj_t imported_modules_init_94___intext();
extern char * real_to_string(double);
extern obj_t string_to_keyword(char *);
static obj_t _car1868___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern obj_t make_struct(obj_t, long, obj_t);
extern obj_t make_real(double);
static obj_t toplevel_init_63___intext();
static long _ref__195___intext;
static long read_taille_23___intext(obj_t);
extern obj_t create_vector(long);
extern obj_t tvector_id_255___tvector(obj_t);
static obj_t read_item_156___intext(obj_t);
extern obj_t tvector__vector_99___tvector(obj_t);
static obj_t print_struct_142___intext(obj_t, obj_t, unsigned char, obj_t);
extern obj_t put_hash__129___hash(obj_t, obj_t);
static long marked_pair_length_178___intext(obj_t);
static obj_t verifie_taille_buffer__99___intext(obj_t, obj_t, obj_t);
extern long class_hash_237___object(obj_t);
extern obj_t string_to_bstring(char *);
extern obj_t getprop___r4_symbols_6_4(obj_t, obj_t);
static obj_t cell_mark__177___intext(obj_t);
static long get_new_ref_211___intext();
extern obj_t vector__tvector_253___tvector(obj_t, obj_t);
static obj_t print_mot_68___intext(obj_t, obj_t, obj_t);
static obj_t loop___intext(obj_t);
static obj_t _set_obj_string_mode__37___intext(obj_t, obj_t);
extern obj_t ucs2_string_to_utf8_string(obj_t);
static obj_t symbol_mark__15___intext(obj_t);
extern obj_t putprop__88___r4_symbols_6_4(obj_t, obj_t, obj_t);
extern obj_t make_string(long, unsigned char);
extern obj_t c_substring(obj_t, long, long);
static obj_t arg1207___intext(obj_t, obj_t, obj_t);
static obj_t arg1206___intext(obj_t, obj_t);
static obj_t vector_mark__202___intext(obj_t);
extern obj_t _classes__134___object;
extern bool_t _2__206___r4_numbers_6_5(obj_t, obj_t);
static obj_t vector1872___intext = BUNSPEC;
static long taille_du_mot_75___intext(obj_t);
static obj_t object_mark__221___intext(obj_t, obj_t);
static obj_t symbol1899___intext = BUNSPEC;
static obj_t symbol1909___intext = BUNSPEC;
static obj_t symbol1898___intext = BUNSPEC;
static obj_t symbol1908___intext = BUNSPEC;
static obj_t symbol1897___intext = BUNSPEC;
static obj_t symbol1907___intext = BUNSPEC;
static obj_t symbol1896___intext = BUNSPEC;
static obj_t symbol1906___intext = BUNSPEC;
static obj_t symbol1895___intext = BUNSPEC;
static obj_t symbol1894___intext = BUNSPEC;
static obj_t symbol1892___intext = BUNSPEC;
static obj_t symbol1891___intext = BUNSPEC;
static obj_t symbol1888___intext = BUNSPEC;
static obj_t symbol1887___intext = BUNSPEC;
static obj_t symbol1886___intext = BUNSPEC;
static obj_t symbol1885___intext = BUNSPEC;
static obj_t symbol1884___intext = BUNSPEC;
static obj_t symbol1883___intext = BUNSPEC;
static obj_t symbol1877___intext = BUNSPEC;
static obj_t symbol1876___intext = BUNSPEC;
static obj_t symbol1875___intext = BUNSPEC;
static obj_t symbol1874___intext = BUNSPEC;
static obj_t symbol1873___intext = BUNSPEC;
static obj_t symbol1871___intext = BUNSPEC;
extern obj_t object__struct_50___object(object_t);
static long _taille_du_mot_maximum__8___intext;
static obj_t require_initialization_114___intext = BUNSPEC;
static obj_t get_ucs2_string_mark_32___intext(obj_t);
static obj_t print_item_54___intext(obj_t, obj_t, obj_t);
static obj_t struct_mark__56___intext(obj_t);
static obj_t cnst_init_137___intext();
extern obj_t blit_string(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t _ref_vector__211___intext = BUNSPEC;
static long _nb_ref__249___intext;
extern obj_t make_vector(long, obj_t);
static obj_t *__cnst;

extern obj_t car_env_2___r4_pairs_and_lists_6_3;
DEFINE_EXPORT_PROCEDURE( set_obj_string_mode__env_98___intext, _set_obj_string_mode__37___intext1911, _set_obj_string_mode__37___intext, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1901___intext, arg1206___intext1912, arg1206___intext, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1900___intext, arg1207___intext1913, arg1207___intext, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__obj_env_38___intext, _string__obj_110___intext1914, _string__obj_110___intext, 0L, 1 );
DEFINE_STRING( string1905___intext, string1905___intext1915, "Unknown object", 14 );
DEFINE_STRING( string1904___intext, string1904___intext1916, "can't extern process", 20 );
DEFINE_STRING( string1893___intext, string1893___intext1917, "Illegal ucs2-string", 19 );
DEFINE_STRING( string1903___intext, string1903___intext1918, "can't extern procedure", 22 );
DEFINE_STRING( string1902___intext, string1902___intext1919, "cer", 3 );
DEFINE_STRING( string1889___intext, string1889___intext1920, "obj->string", 11 );
DEFINE_STRING( string1890___intext, string1890___intext1921, "Illegal string", 14 );
DEFINE_STRING( string1882___intext, string1882___intext1922, "corrupted class", 15 );
DEFINE_STRING( string1881___intext, string1881___intext1923, "string->obj", 11 );
DEFINE_STRING( string1879___intext, string1879___intext1924, "Type `extended pair' expected for expression", 44 );
DEFINE_STRING( string1880___intext, string1880___intext1925, "/home/tahoe/serrano/trashcan/bigloo/runtime/Llib/error.scm", 58 );
DEFINE_STRING( string1878___intext, string1878___intext1926, "set-cer!", 8 );
DEFINE_EXPORT_PROCEDURE( obj__string_env_242___intext, _obj__string_80___intext1927, _obj__string_80___intext, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___intext(long checksum_4265, char * from_4266)
{
if(CBOOL(require_initialization_114___intext)){
require_initialization_114___intext = BBOOL(((bool_t)0));
cnst_init_137___intext();
imported_modules_init_94___intext();
method_init_76___intext();
toplevel_init_63___intext();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___intext()
{
symbol1871___intext = string_to_symbol("TOPLEVEL-INIT");
{
obj_t var_4262;
var_4262 = list__vector_101___r4_vectors_6_8(BNIL);
vector1872___intext = var_4262;
}
symbol1873___intext = string_to_symbol("SET-OBJ-STRING-MODE!");
symbol1874___intext = string_to_symbol("EPAIR");
symbol1875___intext = string_to_symbol("PAIR");
symbol1876___intext = string_to_symbol("STRING->OBJ");
symbol1877___intext = string_to_symbol("DONE");
symbol1883___intext = string_to_symbol("PAIR-MARK!");
symbol1884___intext = string_to_symbol("MARK");
symbol1885___intext = string_to_symbol("CELL-MARK!");
symbol1886___intext = string_to_symbol("SYMBOL-MARK!");
symbol1887___intext = string_to_symbol("STRING-MARK!");
symbol1888___intext = string_to_symbol("GET-STRING-MARK");
symbol1891___intext = string_to_symbol("UCS2-STRING-MARK!");
symbol1892___intext = string_to_symbol("GET-UCS2-STRING-MARK");
symbol1894___intext = string_to_symbol("VECTOR-MARK!");
symbol1895___intext = string_to_symbol("TVECTOR-MARK!");
symbol1896___intext = string_to_symbol("STRUCT-MARK!");
symbol1897___intext = string_to_symbol("OBJECT-MARK!");
symbol1898___intext = string_to_symbol("TAILLE-DU-MOT");
symbol1899___intext = string_to_symbol("OBJ->STRING");
symbol1906___intext = string_to_symbol("MARK-ITEM!");
symbol1907___intext = string_to_symbol("MARKED-PAIR-LENGTH");
symbol1908___intext = string_to_symbol("METHOD-INIT");
return (symbol1909___intext = string_to_symbol("IMPORTED-MODULES-INIT"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___intext()
{
{
obj_t symbol1829_4180;
symbol1829_4180 = symbol1871___intext;
{
PUSH_TRACE(symbol1829_4180);
BUNSPEC;
{
obj_t aux1828_4181;
_ref_vector__211___intext = vector1872___intext;
_defining__224___intext = BFALSE;
_pointeur__164___intext = ((long)0);
_nb_ref__249___intext = ((long)0);
_ref__195___intext = ((long)0);
_epair___65___intext = ((bool_t)1);
_string_mark_table__203___intext = BNIL;
aux1828_4181 = (_taille_du_mot_maximum__8___intext = sizeof( long ),
BUNSPEC);
POP_TRACE();
return aux1828_4181;
}
}
}
}


/* set-obj-string-mode! */obj_t set_obj_string_mode__22___intext(obj_t mode_1)
{
{
obj_t symbol1831_4182;
symbol1831_4182 = symbol1873___intext;
{
PUSH_TRACE(symbol1831_4182);
BUNSPEC;
{
obj_t aux1830_4183;
if((mode_1==symbol1874___intext)){
aux1830_4183 = (_epair___65___intext = ((bool_t)1),
BUNSPEC);
}
 else {
if((mode_1==symbol1875___intext)){
aux1830_4183 = (_epair___65___intext = ((bool_t)0),
BUNSPEC);
}
 else {
aux1830_4183 = BFALSE;
}
}
POP_TRACE();
return aux1830_4183;
}
}
}
}


/* _set-obj-string-mode! */obj_t _set_obj_string_mode__37___intext(obj_t env_4220, obj_t mode_4221)
{
return set_obj_string_mode__22___intext(mode_4221);
}


/* string->obj */obj_t string_to_obj(obj_t s_2)
{
{
obj_t symbol1833_4184;
symbol1833_4184 = symbol1876___intext;
{
PUSH_TRACE(symbol1833_4184);
BUNSPEC;
{
obj_t aux1832_4185;
_pointeur__164___intext = ((long)0);
{
unsigned char d_553;
{
long k_1521;
k_1521 = _pointeur__164___intext;
d_553 = STRING_REF(s_2, k_1521);
}
if((d_553==((unsigned char)'c'))){
{
long z1_1524;
z1_1524 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1524+((long)1));
}
{
long arg1028_555;
arg1028_555 = read_taille_23___intext(s_2);
_ref_vector__211___intext = make_vector(arg1028_555, BUNSPEC);
}
}
 else {
BUNSPEC;
}
}
aux1832_4185 = read_item_156___intext(s_2);
POP_TRACE();
return aux1832_4185;
}
}
}
}


/* read-string */obj_t read_string_238___intext(obj_t s_4251)
{
{
long taille_670;
taille_670 = read_taille_23___intext(s_4251);
{
obj_t res_671;
{
long arg1105_673;
{
long z1_1694;
z1_1694 = _pointeur__164___intext;
arg1105_673 = (z1_1694+taille_670);
}
{
long start_1697;
start_1697 = _pointeur__164___intext;
res_671 = c_substring(s_4251, start_1697, arg1105_673);
}
}
{
{
bool_t test1104_672;
{
obj_t obj_1699;
obj_1699 = _defining__224___intext;
test1104_672 = INTEGERP(obj_1699);
}
if(test1104_672){
{
obj_t vector_1700;
long k_1701;
vector_1700 = _ref_vector__211___intext;
k_1701 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1700, k_1701, res_671);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long z1_1703;
z1_1703 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1703+taille_670);
}
return res_671;
}
}
}
}


/* read-taille */long read_taille_23___intext(obj_t s_4252)
{
{
long accu_entier_43_698;
accu_entier_43_698 = ((long)0);
{
long taille_699;
{
unsigned char arg1130_708;
{
long k_1728;
k_1728 = _pointeur__164___intext;
arg1130_708 = STRING_REF(s_4252, k_1728);
}
taille_699 = (arg1130_708);
}
{
long z1_1730;
z1_1730 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1730+((long)1));
}
{
long i_700;
i_700 = ((long)0);
for1006_701:
{
bool_t test_4328;
{
long aux_4329;
aux_4329 = (taille_699-((long)1));
test_4328 = (i_700<=aux_4329);
}
if(test_4328){
{
unsigned char d_703;
{
long k_1737;
k_1737 = _pointeur__164___intext;
d_703 = STRING_REF(s_4252, k_1737);
}
{
long arg1126_704;
{
long z2_1739;
z2_1739 = accu_entier_43_698;
arg1126_704 = (((long)256)*z2_1739);
}
{
long aux_4334;
aux_4334 = (d_703);
accu_entier_43_698 = (arg1126_704+aux_4334);
}
}
{
long z1_1743;
z1_1743 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1743+((long)1));
}
}
{
long i_4338;
i_4338 = (i_700+((long)1));
i_700 = i_4338;
goto for1006_701;
}
}
 else {
symbol1877___intext;
}
}
}
return accu_entier_43_698;
}
}
}


/* read-item */obj_t read_item_156___intext(obj_t s_4253)
{
read_item_156___intext:
{
{
unsigned char d_558;
{
long k_1528;
k_1528 = _pointeur__164___intext;
d_558 = STRING_REF(s_4253, k_1528);
}
{
long z1_1529;
z1_1529 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1529+((long)1));
}
{
switch (d_558){
case ((unsigned char)'=') : 
_defining__224___intext = read_item_156___intext(s_4253);
{
goto read_item_156___intext;
}
break;
case ((unsigned char)'#') : 
{
obj_t arg1118_1531;
arg1118_1531 = read_item_156___intext(s_4253);
{
obj_t vector_1532;
vector_1532 = _ref_vector__211___intext;
{
long aux_4344;
aux_4344 = (long)CINT(arg1118_1531);
return VECTOR_REF(vector_1532, aux_4344);
}
}
}
break;
case ((unsigned char)'\'') : 
{
obj_t defining_683;
{
obj_t old_687;
old_687 = _defining__224___intext;
_defining__224___intext = BFALSE;
defining_683 = old_687;
}
{
obj_t res_684;
{
obj_t arg1116_686;
arg1116_686 = read_string_238___intext(s_4253);
{
char * aux_4348;
aux_4348 = BSTRING_TO_STRING(arg1116_686);
res_684 = string_to_symbol(aux_4348);
}
}
{
if(INTEGERP(defining_683)){
obj_t vector_1713;
vector_1713 = _ref_vector__211___intext;
{
long aux_4353;
aux_4353 = (long)CINT(defining_683);
VECTOR_SET(vector_1713, aux_4353, res_684);
}
}
 else {
BUNSPEC;
}
return res_684;
}
}
}
break;
case ((unsigned char)':') : 
{
obj_t arg1113_1534;
arg1113_1534 = read_string_238___intext(s_4253);
{
char * aux_4357;
aux_4357 = BSTRING_TO_STRING(arg1113_1534);
return string_to_keyword(aux_4357);
}
}
break;
case ((unsigned char)'a') : 
{
long arg1109_1536;
arg1109_1536 = read_taille_23___intext(s_4253);
{
unsigned char aux_4361;
aux_4361 = (arg1109_1536);
return BCHAR(aux_4361);
}
}
break;
case ((unsigned char)'u') : 
{
long arg1107_1538;
arg1107_1538 = read_taille_23___intext(s_4253);
{
ucs2_t aux_4365;
aux_4365 = integer__ucs2_47___ucs2(arg1107_1538);
return BUCS2(aux_4365);
}
}
break;
case ((unsigned char)'<') : 
{
long arg1111_1539;
arg1111_1539 = read_taille_23___intext(s_4253);
return BCNST(arg1111_1539);
}
break;
case ((unsigned char)'F') : 
return BFALSE;
break;
case ((unsigned char)'"') : 
return read_string_238___intext(s_4253);
break;
case ((unsigned char)'U') : 
{
obj_t arg1102_1540;
arg1102_1540 = read_item_156___intext(s_4253);
return utf8_string_to_ucs2_string(arg1102_1540);
}
break;
case ((unsigned char)'[') : 
{
long taille_658;
taille_658 = read_taille_23___intext(s_4253);
{
obj_t res_659;
res_659 = create_vector(taille_658);
{
{
bool_t test1096_660;
{
obj_t obj_1679;
obj_1679 = _defining__224___intext;
test1096_660 = INTEGERP(obj_1679);
}
if(test1096_660){
{
obj_t vector_1680;
long k_1681;
vector_1680 = _ref_vector__211___intext;
k_1681 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1680, k_1681, res_659);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_661;
i_661 = ((long)0);
for1007_662:
{
bool_t test_4379;
{
long aux_4380;
aux_4380 = (taille_658-((long)1));
test_4379 = (i_661<=aux_4380);
}
if(test_4379){
{
obj_t arg1098_664;
arg1098_664 = read_item_156___intext(s_4253);
VECTOR_SET(res_659, i_661, arg1098_664);
}
{
long i_4385;
i_4385 = (i_661+((long)1));
i_661 = i_4385;
goto for1007_662;
}
}
 else {
symbol1877___intext;
}
}
}
return res_659;
}
}
}
break;
case ((unsigned char)'t') : 
{
obj_t tag_647;
tag_647 = read_item_156___intext(s_4253);
{
long taille_648;
taille_648 = read_taille_23___intext(s_4253);
{
obj_t res_649;
res_649 = create_vector(taille_648);
{
{
long aux_4390;
aux_4390 = (long)CINT(tag_647);
VECTOR_TAG_SET(res_649, aux_4390);
}
{
bool_t test1090_650;
{
obj_t obj_1666;
obj_1666 = _defining__224___intext;
test1090_650 = INTEGERP(obj_1666);
}
if(test1090_650){
{
obj_t vector_1667;
long k_1668;
vector_1667 = _ref_vector__211___intext;
k_1668 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1667, k_1668, res_649);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_651;
i_651 = ((long)0);
for1008_652:
{
bool_t test_4397;
{
long aux_4398;
aux_4398 = (taille_648-((long)1));
test_4397 = (i_651<=aux_4398);
}
if(test_4397){
{
obj_t arg1092_654;
arg1092_654 = read_item_156___intext(s_4253);
VECTOR_SET(res_649, i_651, arg1092_654);
}
{
long i_4403;
i_4403 = (i_651+((long)1));
i_651 = i_4403;
goto for1008_652;
}
}
 else {
symbol1877___intext;
}
}
}
return res_649;
}
}
}
}
break;
case ((unsigned char)'V') : 
{
obj_t id_642;
id_642 = read_item_156___intext(s_4253);
{
obj_t v_643;
v_643 = read_item_156___intext(s_4253);
{
obj_t tv_644;
tv_644 = vector__tvector_253___tvector(id_642, v_643);
{
{
bool_t test1088_645;
{
obj_t obj_1660;
obj_1660 = _defining__224___intext;
test1088_645 = INTEGERP(obj_1660);
}
if(test1088_645){
{
obj_t vector_1661;
long k_1662;
vector_1661 = _ref_vector__211___intext;
k_1662 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1661, k_1662, tv_644);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
return tv_644;
}
}
}
}
break;
case ((unsigned char)'(') : 
{
long taille_623;
taille_623 = read_taille_23___intext(s_4253);
{
obj_t res_624;
res_624 = MAKE_PAIR(BNIL, BNIL);
{
{
bool_t test1074_625;
{
obj_t obj_1639;
obj_1639 = _defining__224___intext;
test1074_625 = INTEGERP(obj_1639);
}
if(test1074_625){
{
obj_t vector_1640;
long k_1641;
vector_1640 = _ref_vector__211___intext;
k_1641 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1640, k_1641, res_624);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_626;
obj_t hd_627;
i_626 = ((long)0);
hd_627 = res_624;
loop_628:
{
bool_t test_4418;
{
long aux_4419;
aux_4419 = (taille_623-((long)2));
test_4418 = (i_626==aux_4419);
}
if(test_4418){
{
obj_t arg1076_630;
arg1076_630 = read_item_156___intext(s_4253);
SET_CAR(hd_627, arg1076_630);
}
{
obj_t arg1077_631;
arg1077_631 = read_item_156___intext(s_4253);
SET_CDR(hd_627, arg1077_631);
}
}
 else {
{
obj_t arg1078_632;
arg1078_632 = read_item_156___intext(s_4253);
SET_CAR(hd_627, arg1078_632);
}
{
obj_t arg1079_633;
arg1079_633 = MAKE_PAIR(BNIL, BNIL);
SET_CDR(hd_627, arg1079_633);
}
{
obj_t hd_4432;
long i_4430;
i_4430 = (i_626+((long)1));
hd_4432 = CDR(hd_627);
hd_627 = hd_4432;
i_626 = i_4430;
goto loop_628;
}
}
}
}
return res_624;
}
}
}
break;
case ((unsigned char)'^') : 
{
long taille_602;
taille_602 = read_taille_23___intext(s_4253);
{
obj_t res_603;
res_603 = MAKE_EXTENDED_PAIR(BNIL, BNIL, BUNSPEC);
{
{
bool_t test1056_604;
{
obj_t obj_1601;
obj_1601 = _defining__224___intext;
test1056_604 = INTEGERP(obj_1601);
}
if(test1056_604){
{
obj_t vector_1602;
long k_1603;
vector_1602 = _ref_vector__211___intext;
k_1603 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1602, k_1603, res_603);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
long i_605;
obj_t hd_606;
i_605 = ((long)0);
hd_606 = res_603;
loop_607:
{
bool_t test_4440;
{
long aux_4441;
aux_4441 = (taille_602-((long)2));
test_4440 = (i_605==aux_4441);
}
if(test_4440){
{
obj_t arg1058_609;
arg1058_609 = read_item_156___intext(s_4253);
SET_CAR(hd_606, arg1058_609);
}
{
obj_t arg1059_610;
arg1059_610 = read_item_156___intext(s_4253);
{
bool_t test1628_1613;
test1628_1613 = EXTENDED_PAIRP(hd_606);
if(test1628_1613){
SET_CER(hd_606, arg1059_610);
}
 else {
debug_error_location_199___error(string1878___intext, string1879___intext, hd_606, string1880___intext, BINT(((long)7610)));
}
}
}
{
obj_t arg1060_611;
arg1060_611 = read_item_156___intext(s_4253);
SET_CDR(hd_606, arg1060_611);
}
}
 else {
{
obj_t arg1061_612;
arg1061_612 = read_item_156___intext(s_4253);
SET_CAR(hd_606, arg1061_612);
}
{
obj_t arg1062_613;
arg1062_613 = read_item_156___intext(s_4253);
{
bool_t test1628_1624;
test1628_1624 = EXTENDED_PAIRP(hd_606);
if(test1628_1624){
SET_CER(hd_606, arg1062_613);
}
 else {
debug_error_location_199___error(string1878___intext, string1879___intext, hd_606, string1880___intext, BINT(((long)7610)));
}
}
}
{
obj_t arg1063_614;
arg1063_614 = MAKE_EXTENDED_PAIR(BNIL, BNIL, BUNSPEC);
SET_CDR(hd_606, arg1063_614);
}
{
obj_t hd_4466;
long i_4464;
i_4464 = (i_605+((long)1));
hd_4466 = CDR(hd_606);
hd_606 = hd_4466;
i_605 = i_4464;
goto loop_607;
}
}
}
}
return res_603;
}
}
}
break;
case ((unsigned char)'{') : 
{
obj_t defining_583;
{
obj_t old_595;
old_595 = _defining__224___intext;
_defining__224___intext = BFALSE;
defining_583 = old_595;
}
{
obj_t key_584;
key_584 = read_item_156___intext(s_4253);
{
long taille_585;
taille_585 = read_taille_23___intext(s_4253);
{
obj_t res_586;
res_586 = make_struct(key_584, taille_585, BUNSPEC);
{
if(INTEGERP(defining_583)){
obj_t vector_1581;
vector_1581 = _ref_vector__211___intext;
{
long aux_4473;
aux_4473 = (long)CINT(defining_583);
VECTOR_SET(vector_1581, aux_4473, res_586);
}
}
 else {
BUNSPEC;
}
{
long i_588;
i_588 = ((long)0);
for1009_589:
{
bool_t test_4476;
{
long aux_4477;
aux_4477 = (taille_585-((long)1));
test_4476 = (i_588<=aux_4477);
}
if(test_4476){
{
obj_t arg1047_591;
arg1047_591 = read_item_156___intext(s_4253);
STRUCT_SET(res_586, i_588, arg1047_591);
}
{
long i_4482;
i_4482 = (i_588+((long)1));
i_588 = i_4482;
goto for1009_589;
}
}
 else {
symbol1877___intext;
}
}
}
return res_586;
}
}
}
}
}
break;
case ((unsigned char)'|') : 
{
obj_t defining_564;
{
obj_t old_581;
old_581 = _defining__224___intext;
_defining__224___intext = BFALSE;
defining_564 = old_581;
}
{
obj_t key_565;
key_565 = read_item_156___intext(s_4253);
{
long taille_566;
taille_566 = read_taille_23___intext(s_4253);
{
obj_t struct_567;
struct_567 = make_struct(key_565, taille_566, BUNSPEC);
{
object_t object_568;
object_568 = allocate_instance_244___object(key_565);
{
if(INTEGERP(defining_564)){
obj_t vector_1550;
vector_1550 = _ref_vector__211___intext;
{
obj_t aux_4492;
long aux_4490;
aux_4492 = (obj_t)(object_568);
aux_4490 = (long)CINT(defining_564);
VECTOR_SET(vector_1550, aux_4490, aux_4492);
}
}
 else {
BUNSPEC;
}
{
long i_570;
i_570 = ((long)0);
for1010_571:
{
bool_t test_4495;
{
long aux_4496;
aux_4496 = (taille_566-((long)1));
test_4495 = (i_570<=aux_4496);
}
if(test_4495){
{
obj_t arg1037_573;
arg1037_573 = read_item_156___intext(s_4253);
STRUCT_SET(struct_567, i_570, arg1037_573);
}
{
long i_4501;
i_4501 = (i_570+((long)1));
i_570 = i_4501;
goto for1010_571;
}
}
 else {
symbol1877___intext;
}
}
}
{
obj_t hash_576;
hash_576 = read_item_156___intext(s_4253);
{
bool_t test1040_577;
{
long arg1041_578;
{
obj_t arg1042_579;
{
long arg1806_1563;
{
long arg1807_1564;
long arg1808_1565;
arg1807_1564 = TYPE( object_568 );
arg1808_1565 = OBJECT_TYPE;
arg1806_1563 = (arg1807_1564-arg1808_1565);
}
{
obj_t vector_1569;
vector_1569 = _classes__134___object;
arg1042_579 = VECTOR_REF(vector_1569, arg1806_1563);
}
}
arg1041_578 = class_hash_237___object(arg1042_579);
}
{
long aux_4509;
aux_4509 = (long)CINT(hash_576);
test1040_577 = (aux_4509==arg1041_578);
}
}
if(test1040_577){
object_t aux_4513;
aux_4513 = struct_object__object_93___object(object_568, struct_567);
return (obj_t)(aux_4513);
}
 else {
return debug_error_location_199___error(string1881___intext, string1882___intext, (obj_t)(object_568), string1880___intext, BINT(((long)7610)));
}
}
}
}
}
}
}
}
}
break;
case ((unsigned char)'f') : 
{
double aux_4519;
{
long taille_692;
taille_692 = read_taille_23___intext(s_4253);
{
double res_693;
{
obj_t arg1121_694;
{
long arg1122_695;
{
long z1_1719;
z1_1719 = _pointeur__164___intext;
arg1122_695 = (z1_1719+taille_692);
}
{
long start_1722;
start_1722 = _pointeur__164___intext;
arg1121_694 = c_substring(s_4253, start_1722, arg1122_695);
}
}
{
char * aux_4523;
aux_4523 = BSTRING_TO_STRING(arg1121_694);
res_693 = strtod(aux_4523, ((long)0));
}
}
{
{
long z1_1725;
z1_1725 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1725+taille_692);
}
aux_4519 = res_693;
}
}
}
return make_real(aux_4519);
}
break;
case ((unsigned char)'-') : 
{
long arg1032_562;
arg1032_562 = read_taille_23___intext(s_4253);
{
long aux_4529;
aux_4529 = NEG(arg1032_562);
return BINT(aux_4529);
}
}
break;
case ((unsigned char)'!') : 
{
obj_t res_597;
res_597 = MAKE_CELL(BUNSPEC);
{
bool_t test1052_598;
{
obj_t obj_1594;
obj_1594 = _defining__224___intext;
test1052_598 = INTEGERP(obj_1594);
}
if(test1052_598){
{
obj_t vector_1595;
long k_1596;
vector_1595 = _ref_vector__211___intext;
k_1596 = (long)CINT(_defining__224___intext);
VECTOR_SET(vector_1595, k_1596, res_597);
}
_defining__224___intext = BFALSE;
}
 else {
BUNSPEC;
}
}
{
obj_t arg1053_599;
arg1053_599 = read_item_156___intext(s_4253);
CELL_SET(res_597, arg1053_599);
}
return res_597;
}
break;
default: 
{
long aux_4539;
{
long z1_1543;
z1_1543 = _pointeur__164___intext;
_pointeur__164___intext = (z1_1543-((long)1));
}
aux_4539 = read_taille_23___intext(s_4253);
return BINT(aux_4539);
}
}
}
}
}
}


/* _string->obj */obj_t _string__obj_110___intext(obj_t env_4222, obj_t s_4223)
{
return string_to_obj(s_4223);
}


/* pair-mark! */obj_t pair_mark__18___intext(obj_t pair_32)
{
{
obj_t symbol1835_4186;
symbol1835_4186 = symbol1883___intext;
{
PUSH_TRACE(symbol1835_4186);
BUNSPEC;
{
obj_t aux1834_4187;
{
obj_t new_752;
new_752 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_752, ((long)0), pair_32);
{
obj_t aux_4548;
aux_4548 = CDR(pair_32);
STRUCT_SET(new_752, ((long)1), aux_4548);
}
{
obj_t aux_4551;
aux_4551 = BINT(((long)0));
STRUCT_SET(new_752, ((long)4), aux_4551);
}
STRUCT_SET(new_752, ((long)3), BFALSE);
SET_CDR(pair_32, new_752);
aux1834_4187 = new_752;
}
POP_TRACE();
return aux1834_4187;
}
}
}
}


/* cell-mark! */obj_t cell_mark__177___intext(obj_t cell_40)
{
{
obj_t symbol1837_4188;
symbol1837_4188 = symbol1885___intext;
{
PUSH_TRACE(symbol1837_4188);
BUNSPEC;
{
obj_t aux1836_4189;
{
obj_t new_764;
new_764 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_764, ((long)0), cell_40);
{
obj_t arg1160_765;
arg1160_765 = CELL_REF(cell_40);
STRUCT_SET(new_764, ((long)1), arg1160_765);
}
{
obj_t aux_4562;
aux_4562 = BINT(((long)0));
STRUCT_SET(new_764, ((long)4), aux_4562);
}
STRUCT_SET(new_764, ((long)3), BFALSE);
CELL_SET(cell_40, new_764);
aux1836_4189 = new_764;
}
POP_TRACE();
return aux1836_4189;
}
}
}
}


/* symbol-mark! */obj_t symbol_mark__15___intext(obj_t symbol_43)
{
{
obj_t symbol1839_4190;
symbol1839_4190 = symbol1886___intext;
{
PUSH_TRACE(symbol1839_4190);
BUNSPEC;
{
obj_t aux1838_4191;
{
obj_t new_768;
new_768 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_768, ((long)0), symbol_43);
{
obj_t aux_4571;
aux_4571 = BINT(((long)0));
STRUCT_SET(new_768, ((long)4), aux_4571);
}
STRUCT_SET(new_768, ((long)3), BFALSE);
putprop__88___r4_symbols_6_4(symbol_43, symbol1884___intext, new_768);
aux1838_4191 = new_768;
}
POP_TRACE();
return aux1838_4191;
}
}
}
}


/* string-mark! */obj_t string_mark__64___intext(obj_t ptr_48)
{
{
obj_t symbol1841_4192;
symbol1841_4192 = symbol1887___intext;
{
PUSH_TRACE(symbol1841_4192);
BUNSPEC;
{
obj_t aux1840_4193;
{
obj_t new_775;
new_775 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_775, ((long)0), ptr_48);
{
obj_t aux_4580;
aux_4580 = BINT(((long)0));
STRUCT_SET(new_775, ((long)4), aux_4580);
}
STRUCT_SET(new_775, ((long)3), BFALSE);
{
obj_t aux_4584;
{
long aux_4585;
aux_4585 = STRING_LENGTH(ptr_48);
aux_4584 = BINT(aux_4585);
}
STRUCT_SET(new_775, ((long)1), aux_4584);
}
{
obj_t arg1170_777;
arg1170_777 = MAKE_PAIR(ptr_48, new_775);
put_hash__129___hash(arg1170_777, _string_mark_table__203___intext);
}
INVERSE_STRING_LENGTH(ptr_48);
aux1840_4193 = new_775;
}
POP_TRACE();
return aux1840_4193;
}
}
}
}


/* get-string-mark */obj_t get_string_mark_33___intext(obj_t ptr_50)
{
{
obj_t symbol1843_4194;
symbol1843_4194 = symbol1888___intext;
{
PUSH_TRACE(symbol1843_4194);
BUNSPEC;
{
obj_t aux1842_4195;
{
obj_t cell_781;
cell_781 = get_hash_29___hash(ptr_50, _string_mark_table__203___intext);
if(PAIRP(cell_781)){
aux1842_4195 = CDR(cell_781);
}
 else {
aux1842_4195 = debug_error_location_199___error(string1889___intext, string1890___intext, BUNSPEC, string1880___intext, BINT(((long)7610)));
}
}
POP_TRACE();
return aux1842_4195;
}
}
}
}


/* ucs2-string-mark! */obj_t ucs2_string_mark__64___intext(obj_t ptr_52)
{
{
obj_t symbol1845_4196;
symbol1845_4196 = symbol1891___intext;
{
PUSH_TRACE(symbol1845_4196);
BUNSPEC;
{
obj_t aux1844_4197;
{
obj_t new_783;
new_783 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_783, ((long)0), ptr_52);
{
obj_t aux_4604;
aux_4604 = BINT(((long)0));
STRUCT_SET(new_783, ((long)4), aux_4604);
}
STRUCT_SET(new_783, ((long)3), BFALSE);
{
obj_t aux_4608;
{
long aux_4609;
aux_4609 = UCS2_STRING_LENGTH(ptr_52);
aux_4608 = BINT(aux_4609);
}
STRUCT_SET(new_783, ((long)1), aux_4608);
}
{
obj_t arg1176_785;
arg1176_785 = ucs2_string_to_utf8_string(ptr_52);
STRUCT_SET(new_783, ((long)5), arg1176_785);
}
{
obj_t arg1177_786;
arg1177_786 = MAKE_PAIR(ptr_52, new_783);
put_hash__129___hash(arg1177_786, _string_mark_table__203___intext);
}
INVERSE_UCS2_STRING_LENGTH(ptr_52);
aux1844_4197 = new_783;
}
POP_TRACE();
return aux1844_4197;
}
}
}
}


/* get-ucs2-string-mark */obj_t get_ucs2_string_mark_32___intext(obj_t ptr_54)
{
{
obj_t symbol1847_4198;
symbol1847_4198 = symbol1892___intext;
{
PUSH_TRACE(symbol1847_4198);
BUNSPEC;
{
obj_t aux1846_4199;
{
obj_t cell_790;
cell_790 = get_hash_29___hash(ptr_54, _string_mark_table__203___intext);
if(PAIRP(cell_790)){
aux1846_4199 = CDR(cell_790);
}
 else {
aux1846_4199 = debug_error_location_199___error(string1889___intext, string1893___intext, BUNSPEC, string1880___intext, BINT(((long)7610)));
}
}
POP_TRACE();
return aux1846_4199;
}
}
}
}


/* vector-mark! */obj_t vector_mark__202___intext(obj_t ptr_57)
{
{
obj_t symbol1849_4200;
symbol1849_4200 = symbol1894___intext;
{
PUSH_TRACE(symbol1849_4200);
BUNSPEC;
{
obj_t aux1848_4201;
{
obj_t new_795;
new_795 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_795, ((long)0), ptr_57);
{
obj_t aux_4630;
aux_4630 = VECTOR_REF(ptr_57, ((long)0));
STRUCT_SET(new_795, ((long)1), aux_4630);
}
{
obj_t aux_4633;
aux_4633 = BINT(((long)0));
STRUCT_SET(new_795, ((long)4), aux_4633);
}
STRUCT_SET(new_795, ((long)3), BFALSE);
VECTOR_SET(ptr_57, ((long)0), new_795);
aux1848_4201 = new_795;
}
POP_TRACE();
return aux1848_4201;
}
}
}
}


/* tvector-mark! */obj_t tvector_mark__214___intext(obj_t ptr_61, obj_t v_62)
{
{
obj_t symbol1851_4202;
symbol1851_4202 = symbol1895___intext;
{
PUSH_TRACE(symbol1851_4202);
BUNSPEC;
{
obj_t aux1850_4203;
{
obj_t new_801;
new_801 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_801, ((long)0), ptr_61);
{
obj_t arg1188_802;
arg1188_802 = PEEK(ptr_61, ((long)2));
STRUCT_SET(new_801, ((long)1), arg1188_802);
}
{
obj_t aux_4644;
aux_4644 = BINT(((long)0));
STRUCT_SET(new_801, ((long)4), aux_4644);
}
STRUCT_SET(new_801, ((long)3), BFALSE);
STRUCT_SET(new_801, ((long)5), v_62);
POKE(ptr_61, ((long)2), new_801);
aux1850_4203 = new_801;
}
POP_TRACE();
return aux1850_4203;
}
}
}
}


/* struct-mark! */obj_t struct_mark__56___intext(obj_t ptr_67)
{
{
obj_t symbol1853_4204;
symbol1853_4204 = symbol1896___intext;
{
PUSH_TRACE(symbol1853_4204);
BUNSPEC;
{
obj_t aux1852_4205;
{
obj_t new_808;
new_808 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_808, ((long)0), ptr_67);
{
obj_t arg1193_809;
arg1193_809 = PEEK(ptr_67, STRUCTURE_MARK_OFFSET);
STRUCT_SET(new_808, ((long)1), arg1193_809);
}
{
obj_t aux_4656;
aux_4656 = BINT(((long)0));
STRUCT_SET(new_808, ((long)4), aux_4656);
}
STRUCT_SET(new_808, ((long)3), BFALSE);
POKE(ptr_67, STRUCTURE_MARK_OFFSET, new_808);
aux1852_4205 = new_808;
}
POP_TRACE();
return aux1852_4205;
}
}
}
}


/* object-mark! */obj_t object_mark__221___intext(obj_t ptr_70, obj_t struct_71)
{
{
obj_t symbol1855_4206;
symbol1855_4206 = symbol1897___intext;
{
PUSH_TRACE(symbol1855_4206);
BUNSPEC;
{
obj_t aux1854_4207;
{
obj_t new_812;
new_812 = make_struct(symbol1884___intext, ((long)6), BNIL);
STRUCT_SET(new_812, ((long)0), ptr_70);
{
obj_t aux_4665;
{
object_t aux_4666;
aux_4666 = (object_t)(ptr_70);
aux_4665 = OBJECT_WIDENING(aux_4666);
}
STRUCT_SET(new_812, ((long)1), aux_4665);
}
STRUCT_SET(new_812, ((long)5), struct_71);
{
obj_t aux_4671;
aux_4671 = BINT(((long)0));
STRUCT_SET(new_812, ((long)4), aux_4671);
}
STRUCT_SET(new_812, ((long)3), BFALSE);
{
object_t aux_4675;
aux_4675 = (object_t)(ptr_70);
OBJECT_WIDENING_SET(aux_4675, new_812);
}
aux1854_4207 = new_812;
}
POP_TRACE();
return aux1854_4207;
}
}
}
}


/* taille-du-mot */long taille_du_mot_75___intext(obj_t m_76)
{
{
obj_t symbol1857_4208;
symbol1857_4208 = symbol1898___intext;
{
PUSH_TRACE(symbol1857_4208);
BUNSPEC;
{
long aux1856_4209;
{
long taille_2452;
obj_t m_2453;
taille_2452 = ((long)0);
m_2453 = m_76;
loop_2451:
{
bool_t test_4680;
{
long aux_4681;
aux_4681 = (long)CINT(m_2453);
test_4680 = (aux_4681==((long)0));
}
if(test_4680){
aux1856_4209 = taille_2452;
}
 else {
obj_t m_4686;
long taille_4684;
taille_4684 = (taille_2452+((long)1));
{
long aux_4687;
{
long aux_4688;
aux_4688 = (long)CINT(m_2453);
aux_4687 = (aux_4688 >> ((long)8));
}
m_4686 = BINT(aux_4687);
}
m_2453 = m_4686;
taille_2452 = taille_4684;
goto loop_2451;
}
}
}
POP_TRACE();
return aux1856_4209;
}
}
}
}


/* obj->string */obj_t obj_to_string(obj_t obj_77)
{
{
obj_t symbol1859_4210;
symbol1859_4210 = symbol1899___intext;
{
PUSH_TRACE(symbol1859_4210);
BUNSPEC;
{
obj_t aux1858_4211;
_ref__195___intext = ((long)-1);
_nb_ref__249___intext = ((long)0);
_pointeur__164___intext = ((long)0);
{
obj_t length_buffer_16_825;
{
obj_t cellval_4694;
cellval_4694 = BINT(((long)100));
length_buffer_16_825 = MAKE_CELL(cellval_4694);
}
{
obj_t buffer_826;
{
obj_t cellval_4696;
{
obj_t list1542_1245;
{
obj_t aux_4697;
aux_4697 = BCHAR(((unsigned char)' '));
list1542_1245 = MAKE_PAIR(aux_4697, BNIL);
}
{
obj_t res1818_2492;
{
int k_2486;
{
obj_t aux_4700;
aux_4700 = CELL_REF(length_buffer_16_825);
k_2486 = CINT(aux_4700);
}
{
unsigned char aux_4704;
long aux_4702;
{
obj_t aux_4705;
aux_4705 = CAR(list1542_1245);
aux_4704 = (unsigned char)CCHAR(aux_4705);
}
aux_4702 = (long)(k_2486);
res1818_2492 = make_string(aux_4702, aux_4704);
}
}
cellval_4696 = res1818_2492;
}
}
buffer_826 = MAKE_CELL(cellval_4696);
}
{
{
obj_t arg1207_4224;
obj_t arg1206_4225;
arg1207_4224 = proc1900___intext;
arg1206_4225 = proc1901___intext;
_string_mark_table__203___intext = make_hash_table_174___hash(((long)1024), arg1206_4225, car_env_2___r4_pairs_and_lists_6_3, arg1207_4224, BNIL);
}
mark_item__0___intext(obj_77);
_pointeur__164___intext = ((long)0);
{
bool_t test1211_857;
{
long n1_2493;
n1_2493 = _nb_ref__249___intext;
test1211_857 = (n1_2493>((long)0));
}
if(test1211_857){
verifie_taille_buffer__99___intext(buffer_826, length_buffer_16_825, BINT(((long)0)));
{
obj_t string_2496;
long k_2497;
string_2496 = CELL_REF(buffer_826);
k_2497 = _pointeur__164___intext;
STRING_SET(string_2496, k_2497, ((unsigned char)'c'));
}
{
long z1_2499;
z1_2499 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2499+((long)1));
}
print_di_101___intext(buffer_826, length_buffer_16_825, BINT(_nb_ref__249___intext));
}
 else {
BUNSPEC;
}
}
print_item_54___intext(buffer_826, length_buffer_16_825, obj_77);
_string_mark_table__203___intext = BUNSPEC;
{
obj_t string_2501;
long end_2503;
string_2501 = CELL_REF(buffer_826);
end_2503 = _pointeur__164___intext;
aux1858_4211 = c_substring(string_2501, ((long)0), end_2503);
}
}
}
}
POP_TRACE();
return aux1858_4211;
}
}
}
}


/* print-struct */obj_t print_struct_142___intext(obj_t buffer_4238, obj_t length_buffer_16_4237, unsigned char marqueur_1076, obj_t item_1077)
{
{
obj_t v_1160;
long len_1161;
{
bool_t test1435_1079;
{
obj_t arg1461_1103;
arg1461_1103 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
{
obj_t aux_4723;
aux_4723 = STRUCT_REF(arg1461_1103, ((long)3));
test1435_1079 = CBOOL(aux_4723);
}
}
if(test1435_1079){
verifie_taille_buffer__99___intext(buffer_4238, length_buffer_16_4237, BINT(((long)0)));
{
obj_t string_3389;
long k_3390;
string_3389 = CELL_REF(buffer_4238);
k_3390 = _pointeur__164___intext;
STRING_SET(string_3389, k_3390, ((unsigned char)'#'));
}
{
long z1_3392;
z1_3392 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3392+((long)1));
}
{
obj_t arg1436_1080;
{
obj_t arg1437_1081;
arg1437_1081 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1436_1080 = STRUCT_REF(arg1437_1081, ((long)2));
}
print_di_101___intext(buffer_4238, length_buffer_16_4237, arg1436_1080);
}
{
obj_t arg1438_1082;
long arg1440_1083;
arg1438_1082 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
{
obj_t arg1441_1084;
{
obj_t arg1444_1086;
arg1444_1086 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1441_1084 = STRUCT_REF(arg1444_1086, ((long)4));
}
{
long aux_4737;
aux_4737 = (long)CINT(arg1441_1084);
arg1440_1083 = (aux_4737-((long)1));
}
}
{
obj_t aux_4740;
aux_4740 = BINT(arg1440_1083);
STRUCT_SET(arg1438_1082, ((long)4), aux_4740);
}
}
{
bool_t test1445_1087;
{
obj_t arg1446_1088;
{
obj_t arg1449_1090;
arg1449_1090 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1446_1088 = STRUCT_REF(arg1449_1090, ((long)4));
}
{
long aux_4745;
aux_4745 = (long)CINT(arg1446_1088);
test1445_1087 = (aux_4745==((long)0));
}
}
if(test1445_1087){
obj_t old_value_175_3425;
{
obj_t arg1192_3426;
arg1192_3426 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
old_value_175_3425 = STRUCT_REF(arg1192_3426, ((long)1));
}
return POKE(item_1077, STRUCTURE_MARK_OFFSET, old_value_175_3425);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test1450_1091;
{
obj_t arg1456_1100;
{
obj_t arg1460_1102;
arg1460_1102 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
arg1456_1100 = STRUCT_REF(arg1460_1102, ((long)4));
}
{
long aux_4754;
aux_4754 = (long)CINT(arg1456_1100);
test1450_1091 = (aux_4754==((long)0));
}
}
if(test1450_1091){
{
obj_t old_value_175_3445;
{
obj_t arg1192_3446;
arg1192_3446 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
old_value_175_3445 = STRUCT_REF(arg1192_3446, ((long)1));
}
POKE(item_1077, STRUCTURE_MARK_OFFSET, old_value_175_3445);
}
verifie_taille_buffer__99___intext(buffer_4238, length_buffer_16_4237, BINT(((long)0)));
{
obj_t string_3457;
long k_3458;
string_3457 = CELL_REF(buffer_4238);
k_3458 = _pointeur__164___intext;
STRING_SET(string_3457, k_3458, marqueur_1076);
}
{
long z1_3460;
z1_3460 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3460+((long)1));
}
print_item_54___intext(buffer_4238, length_buffer_16_4237, STRUCT_KEY(item_1077));
v_1160 = item_1077;
len_1161 = STRUCT_LENGTH(item_1077);
print_du_185_1237:
verifie_taille_buffer__99___intext(buffer_4238, length_buffer_16_4237, BINT(len_1161));
print_mot_68___intext(buffer_4238, length_buffer_16_4237, BINT(len_1161));
{
long i_1163;
i_1163 = ((long)0);
for1014_1164:
{
bool_t test_4771;
{
long aux_4772;
aux_4772 = (len_1161-((long)1));
test_4771 = (i_1163<=aux_4772);
}
if(test_4771){
print_item_54___intext(buffer_4238, length_buffer_16_4237, STRUCT_REF(v_1160, i_1163));
{
long i_4777;
i_4777 = (i_1163+((long)1));
i_1163 = i_4777;
goto for1014_1164;
}
}
 else {
return symbol1877___intext;
}
}
}
}
 else {
{
long ref_1094;
ref_1094 = get_new_ref_211___intext();
{
obj_t mark_1095;
mark_1095 = PEEK(item_1077, STRUCTURE_MARK_OFFSET);
{
long len_1096;
len_1096 = STRUCT_LENGTH(item_1077);
{
obj_t key_1097;
key_1097 = BUNSPEC;
{
{
obj_t aux_4783;
aux_4783 = STRUCT_REF(mark_1095, ((long)1));
POKE(item_1077, STRUCTURE_MARK_OFFSET, aux_4783);
}
key_1097 = STRUCT_KEY(item_1077);
POKE(item_1077, STRUCTURE_MARK_OFFSET, mark_1095);
{
obj_t aux_4788;
aux_4788 = BINT(ref_1094);
STRUCT_SET(mark_1095, ((long)2), aux_4788);
}
STRUCT_SET(mark_1095, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4238, length_buffer_16_4237, BINT(((long)0)));
{
obj_t string_3491;
long k_3492;
string_3491 = CELL_REF(buffer_4238);
k_3492 = _pointeur__164___intext;
STRING_SET(string_3491, k_3492, ((unsigned char)'='));
}
{
long z1_3494;
z1_3494 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3494+((long)1));
}
print_di_101___intext(buffer_4238, length_buffer_16_4237, BINT(ref_1094));
verifie_taille_buffer__99___intext(buffer_4238, length_buffer_16_4237, BINT(((long)0)));
{
obj_t string_3497;
long k_3498;
string_3497 = CELL_REF(buffer_4238);
k_3498 = _pointeur__164___intext;
STRING_SET(string_3497, k_3498, marqueur_1076);
}
{
long z1_3500;
z1_3500 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3500+((long)1));
}
print_item_54___intext(buffer_4238, length_buffer_16_4237, key_1097);
{
long len_4804;
obj_t v_4803;
v_4803 = item_1077;
len_4804 = len_1096;
len_1161 = len_4804;
v_1160 = v_4803;
goto print_du_185_1237;
}
}
}
}
}
}
}
}
}
}
}


/* get-new-ref */long get_new_ref_211___intext()
{
{
long z1_3715;
z1_3715 = _ref__195___intext;
_ref__195___intext = (z1_3715+((long)1));
}
return _ref__195___intext;
}


/* pair-mark-gc! */obj_t pair_mark_gc__141___intext(obj_t p_1150)
{
{
obj_t mark_1152;
mark_1152 = CDR(p_1150);
{
bool_t test_4807;
{
bool_t test_4808;
{
obj_t aux_4809;
aux_4809 = STRUCT_REF(mark_1152, ((long)3));
test_4808 = CBOOL(aux_4809);
}
if(test_4808){
long aux_4812;
{
obj_t aux_4813;
aux_4813 = STRUCT_REF(mark_1152, ((long)4));
aux_4812 = (long)CINT(aux_4813);
}
test_4807 = (aux_4812>((long)0));
}
 else {
test_4807 = ((bool_t)0);
}
}
if(test_4807){
obj_t aux_4817;
{
long aux_4818;
{
long aux_4819;
{
obj_t aux_4820;
aux_4820 = STRUCT_REF(mark_1152, ((long)4));
aux_4819 = (long)CINT(aux_4820);
}
aux_4818 = (aux_4819-((long)1));
}
aux_4817 = BINT(aux_4818);
}
return STRUCT_SET(mark_1152, ((long)4), aux_4817);
}
 else {
obj_t aux_4826;
aux_4826 = STRUCT_REF(mark_1152, ((long)1));
return SET_CDR(p_1150, aux_4826);
}
}
}
}


/* print-mot */obj_t print_mot_68___intext(obj_t buffer_4240, obj_t length_buffer_16_4239, obj_t m_1196)
{
{
long taille_1198;
taille_1198 = taille_du_mot_75___intext(m_1196);
if((taille_1198==((long)0))){
return print_marqueur_131___intext(buffer_4240, length_buffer_16_4239, (((long)0)));
}
 else {
print_marqueur_131___intext(buffer_4240, length_buffer_16_4239, (taille_1198));
{
long i_1200;
i_1200 = (taille_1198-((long)1));
loop_1201:
if((i_1200==((long)-1))){
return symbol1877___intext;
}
 else {
{
unsigned char aux_4838;
{
long aux_4839;
{
long aux_4840;
{
long aux_4843;
long aux_4841;
aux_4843 = (((long)8)*i_1200);
aux_4841 = (long)CINT(m_1196);
aux_4840 = (aux_4841 >> aux_4843);
}
aux_4839 = (aux_4840 & ((long)255));
}
aux_4838 = (aux_4839);
}
print_marqueur_131___intext(buffer_4240, length_buffer_16_4239, aux_4838);
}
{
long i_4849;
i_4849 = (i_1200-((long)1));
i_1200 = i_4849;
goto loop_1201;
}
}
}
}
}
}


/* print-marqueur */obj_t print_marqueur_131___intext(obj_t buffer_4242, obj_t length_buffer_16_4241, unsigned char c_1212)
{
verifie_taille_buffer__99___intext(buffer_4242, length_buffer_16_4241, BINT(((long)0)));
{
obj_t string_3686;
long k_3687;
string_3686 = CELL_REF(buffer_4242);
k_3687 = _pointeur__164___intext;
STRING_SET(string_3686, k_3687, c_1212);
}
{
long z1_3689;
z1_3689 = _pointeur__164___intext;
return (_pointeur__164___intext = (z1_3689+((long)1)),
BUNSPEC);
}
}


/* verifie-taille-buffer! */obj_t verifie_taille_buffer__99___intext(obj_t buffer_4244, obj_t length_buffer_16_4243, obj_t taille_1214)
{
{
long l_1216;
{
long z1_3695;
z1_3695 = _pointeur__164___intext;
{
long aux_4856;
{
long aux_4859;
long aux_4857;
aux_4859 = (_taille_du_mot_maximum__8___intext+((long)1));
aux_4857 = (long)CINT(taille_1214);
aux_4856 = (aux_4857+aux_4859);
}
l_1216 = (z1_3695+aux_4856);
}
}
{
bool_t test1534_1217;
{
long n2_3698;
{
obj_t aux_4863;
aux_4863 = CELL_REF(length_buffer_16_4243);
n2_3698 = (long)CINT(aux_4863);
}
test1534_1217 = (l_1216>=n2_3698);
}
if(test1534_1217){
{
long vieille_longeur_17_1218;
obj_t vieux_buffer_172_1219;
{
obj_t aux_4867;
aux_4867 = CELL_REF(length_buffer_16_4243);
vieille_longeur_17_1218 = (long)CINT(aux_4867);
}
vieux_buffer_172_1219 = CELL_REF(buffer_4244);
{
long aux_4869;
{
long aux_4870;
aux_4870 = (l_1216+((long)100));
aux_4869 = (((long)2)*aux_4870);
}
CELL_SET(length_buffer_16_4243, BINT(aux_4869));
}
{
obj_t aux_4246;
{
obj_t res1826_3709;
{
int k_3703;
{
obj_t aux_4874;
aux_4874 = CELL_REF(length_buffer_16_4243);
k_3703 = CINT(aux_4874);
}
{
long aux_4876;
aux_4876 = (long)(k_3703);
res1826_3709 = make_string(aux_4876, ((unsigned char)' '));
}
}
aux_4246 = res1826_3709;
}
CELL_SET(buffer_4244, aux_4246);
}
{
obj_t s2_3712;
s2_3712 = CELL_REF(buffer_4244);
{
obj_t aux_4883;
obj_t aux_4881;
obj_t aux_4879;
aux_4883 = BINT(vieille_longeur_17_1218);
aux_4881 = BINT(((long)0));
aux_4879 = BINT(((long)0));
return blit_string(vieux_buffer_172_1219, aux_4879, s2_3712, aux_4881, aux_4883);
}
}
}
}
 else {
return BUNSPEC;
}
}
}
}


/* print-di */obj_t print_di_101___intext(obj_t buffer_4248, obj_t length_buffer_16_4247, obj_t i_1179)
{
verifie_taille_buffer__99___intext(buffer_4248, length_buffer_16_4247, BINT(((long)0)));
{
bool_t test_4888;
{
long aux_4889;
aux_4889 = (long)CINT(i_1179);
test_4888 = (aux_4889<((long)0));
}
if(test_4888){
{
obj_t string_3614;
long k_3615;
string_3614 = CELL_REF(buffer_4248);
k_3615 = _pointeur__164___intext;
STRING_SET(string_3614, k_3615, ((unsigned char)'-'));
}
{
long z1_3617;
z1_3617 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3617+((long)1));
}
{
obj_t aux_4894;
{
long aux_4895;
{
long aux_4896;
aux_4896 = (long)CINT(i_1179);
aux_4895 = NEG(aux_4896);
}
aux_4894 = BINT(aux_4895);
}
return print_mot_68___intext(buffer_4248, length_buffer_16_4247, aux_4894);
}
}
 else {
return print_mot_68___intext(buffer_4248, length_buffer_16_4247, i_1179);
}
}
}


/* print-item */obj_t print_item_54___intext(obj_t buffer_4250, obj_t length_buffer_16_4249, obj_t item_858)
{
print_item_54___intext:
{
unsigned char marqueur_1040;
obj_t item_1041;
unsigned char marqueur_1058;
obj_t item_1059;
obj_t p_1104;
long len_1105;
obj_t p_1129;
long len_1130;
obj_t v_1169;
obj_t ref0_1170;
long len_1171;
obj_t s_1190;
obj_t len_1191;
{
bool_t test1213_860;
test1213_860 = (POINTERP( item_858 ) && (TYPE( item_858 ) >= OBJECT_TYPE));
if(test1213_860){
{
obj_t mark_861;
{
object_t aux_4904;
aux_4904 = (object_t)(item_858);
mark_861 = OBJECT_WIDENING(aux_4904);
}
{
bool_t test_4907;
{
obj_t aux_4908;
aux_4908 = STRUCT_REF(mark_861, ((long)3));
test_4907 = CBOOL(aux_4908);
}
if(test_4907){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2510;
long k_2511;
string_2510 = CELL_REF(buffer_4250);
k_2511 = _pointeur__164___intext;
STRING_SET(string_2510, k_2511, ((unsigned char)'#'));
}
{
long z1_2513;
z1_2513 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2513+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, STRUCT_REF(mark_861, ((long)2)));
{
obj_t aux_4917;
{
long aux_4918;
{
long aux_4919;
{
obj_t aux_4920;
aux_4920 = STRUCT_REF(mark_861, ((long)4));
aux_4919 = (long)CINT(aux_4920);
}
aux_4918 = (aux_4919-((long)1));
}
aux_4917 = BINT(aux_4918);
}
STRUCT_SET(mark_861, ((long)4), aux_4917);
}
{
bool_t test_4926;
{
long aux_4927;
{
obj_t aux_4928;
aux_4928 = STRUCT_REF(mark_861, ((long)4));
aux_4927 = (long)CINT(aux_4928);
}
test_4926 = (aux_4927==((long)0));
}
if(test_4926){
obj_t aux_4934;
object_t aux_4932;
{
obj_t aux_4935;
{
object_t aux_4936;
aux_4936 = (object_t)(item_858);
aux_4935 = OBJECT_WIDENING(aux_4936);
}
aux_4934 = STRUCT_REF(aux_4935, ((long)1));
}
aux_4932 = (object_t)(item_858);
return OBJECT_WIDENING_SET(aux_4932, aux_4934);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_4941;
{
long aux_4942;
{
obj_t aux_4943;
aux_4943 = STRUCT_REF(mark_861, ((long)4));
aux_4942 = (long)CINT(aux_4943);
}
test_4941 = (aux_4942==((long)0));
}
if(test_4941){
{
obj_t struct_871;
struct_871 = STRUCT_REF(mark_861, ((long)5));
{
obj_t aux_4950;
object_t aux_4948;
aux_4950 = STRUCT_REF(mark_861, ((long)1));
aux_4948 = (object_t)(item_858);
OBJECT_WIDENING_SET(aux_4948, aux_4950);
}
print_struct_142___intext(buffer_4250, length_buffer_16_4249, ((unsigned char)'|'), struct_871);
{
long arg1228_872;
{
obj_t arg1231_873;
{
object_t object_2558;
object_2558 = (object_t)(item_858);
{
long arg1806_2559;
{
long arg1807_2560;
long arg1808_2561;
arg1807_2560 = TYPE( object_2558 );
arg1808_2561 = OBJECT_TYPE;
arg1806_2559 = (arg1807_2560-arg1808_2561);
}
{
obj_t vector_2565;
vector_2565 = _classes__134___object;
arg1231_873 = VECTOR_REF(vector_2565, arg1806_2559);
}
}
}
arg1228_872 = class_hash_237___object(arg1231_873);
}
{
obj_t item_4960;
item_4960 = BINT(arg1228_872);
item_858 = item_4960;
goto print_item_54___intext;
}
}
}
}
 else {
{
long ref_874;
obj_t struct_875;
ref_874 = get_new_ref_211___intext();
struct_875 = STRUCT_REF(mark_861, ((long)5));
{
obj_t aux_4964;
aux_4964 = BINT(ref_874);
STRUCT_SET(mark_861, ((long)2), aux_4964);
}
STRUCT_SET(mark_861, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2584;
long k_2585;
string_2584 = CELL_REF(buffer_4250);
k_2585 = _pointeur__164___intext;
STRING_SET(string_2584, k_2585, ((unsigned char)'='));
}
{
long z1_2587;
z1_2587 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2587+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_874));
print_struct_142___intext(buffer_4250, length_buffer_16_4249, ((unsigned char)'|'), struct_875);
{
long arg1232_876;
{
obj_t arg1233_877;
{
object_t object_2589;
object_2589 = (object_t)(item_858);
{
long arg1806_2590;
{
long arg1807_2591;
long arg1808_2592;
arg1807_2591 = TYPE( object_2589 );
arg1808_2592 = OBJECT_TYPE;
arg1806_2590 = (arg1807_2591-arg1808_2592);
}
{
obj_t vector_2596;
vector_2596 = _classes__134___object;
arg1233_877 = VECTOR_REF(vector_2596, arg1806_2590);
}
}
}
arg1232_876 = class_hash_237___object(arg1233_877);
}
{
obj_t item_4981;
item_4981 = BINT(arg1232_876);
item_858 = item_4981;
goto print_item_54___intext;
}
}
}
}
}
}
}
}
 else {
if(STRUCTP(item_858)){
return print_struct_142___intext(buffer_4250, length_buffer_16_4249, ((unsigned char)'{'), item_858);
}
 else {
if(SYMBOLP(item_858)){
{
bool_t test_4988;
{
obj_t aux_4989;
{
obj_t aux_4990;
aux_4990 = getprop___r4_symbols_6_4(item_858, symbol1884___intext);
aux_4989 = STRUCT_REF(aux_4990, ((long)3));
}
test_4988 = CBOOL(aux_4989);
}
if(test_4988){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2606;
long k_2607;
string_2606 = CELL_REF(buffer_4250);
k_2607 = _pointeur__164___intext;
STRING_SET(string_2606, k_2607, ((unsigned char)'#'));
}
{
long z1_2609;
z1_2609 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2609+((long)1));
}
{
obj_t aux_4998;
{
obj_t aux_4999;
aux_4999 = getprop___r4_symbols_6_4(item_858, symbol1884___intext);
aux_4998 = STRUCT_REF(aux_4999, ((long)2));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, aux_4998);
}
{
obj_t aux_5005;
obj_t aux_5003;
{
long aux_5006;
{
long aux_5007;
{
obj_t aux_5008;
{
obj_t aux_5009;
aux_5009 = getprop___r4_symbols_6_4(item_858, symbol1884___intext);
aux_5008 = STRUCT_REF(aux_5009, ((long)4));
}
aux_5007 = (long)CINT(aux_5008);
}
aux_5006 = (aux_5007-((long)1));
}
aux_5005 = BINT(aux_5006);
}
aux_5003 = getprop___r4_symbols_6_4(item_858, symbol1884___intext);
STRUCT_SET(aux_5003, ((long)4), aux_5005);
}
{
bool_t test_5016;
{
long aux_5017;
{
obj_t aux_5018;
{
obj_t aux_5019;
aux_5019 = getprop___r4_symbols_6_4(item_858, symbol1884___intext);
aux_5018 = STRUCT_REF(aux_5019, ((long)4));
}
aux_5017 = (long)CINT(aux_5018);
}
test_5016 = (aux_5017==((long)0));
}
if(test_5016){
return remprop__243___r4_symbols_6_4(item_858, symbol1884___intext);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5025;
{
long aux_5026;
{
obj_t aux_5027;
{
obj_t aux_5028;
aux_5028 = getprop___r4_symbols_6_4(item_858, symbol1884___intext);
aux_5027 = STRUCT_REF(aux_5028, ((long)4));
}
aux_5026 = (long)CINT(aux_5027);
}
test_5025 = (aux_5026==((long)0));
}
if(test_5025){
remprop__243___r4_symbols_6_4(item_858, symbol1884___intext);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2649;
long k_2650;
string_2649 = CELL_REF(buffer_4250);
k_2650 = _pointeur__164___intext;
STRING_SET(string_2649, k_2650, ((unsigned char)'\''));
}
{
long z1_2652;
z1_2652 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2652+((long)1));
}
{
obj_t s_895;
s_895 = SYMBOL_TO_STRING(item_858);
s_1190 = s_895;
{
long aux_5047;
aux_5047 = STRING_LENGTH(s_895);
len_1191 = BINT(aux_5047);
}
print_chars_22_1232:
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, len_1191);
print_mot_68___intext(buffer_4250, length_buffer_16_4249, len_1191);
{
obj_t o1_3649;
obj_t s2_3650;
obj_t o2_3651;
o1_3649 = BINT(((long)0));
s2_3650 = CELL_REF(buffer_4250);
o2_3651 = BINT(_pointeur__164___intext);
blit_string(s_1190, o1_3649, s2_3650, o2_3651, len_1191);
}
{
long z1_3653;
z1_3653 = _pointeur__164___intext;
{
long aux_5044;
aux_5044 = (long)CINT(len_1191);
return (_pointeur__164___intext = (z1_3653+aux_5044),
BUNSPEC);
}
}
}
}
 else {
{
long ref_897;
obj_t mark_898;
ref_897 = get_new_ref_211___intext();
mark_898 = getprop___r4_symbols_6_4(item_858, symbol1884___intext);
{
obj_t aux_5052;
aux_5052 = BINT(ref_897);
STRUCT_SET(mark_898, ((long)2), aux_5052);
}
STRUCT_SET(mark_898, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2671;
long k_2672;
string_2671 = CELL_REF(buffer_4250);
k_2672 = _pointeur__164___intext;
STRING_SET(string_2671, k_2672, ((unsigned char)'='));
}
{
long z1_2674;
z1_2674 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2674+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_897));
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2677;
long k_2678;
string_2677 = CELL_REF(buffer_4250);
k_2678 = _pointeur__164___intext;
STRING_SET(string_2677, k_2678, ((unsigned char)'\''));
}
{
long z1_2680;
z1_2680 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2680+((long)1));
}
{
obj_t s_899;
s_899 = SYMBOL_TO_STRING(item_858);
{
obj_t len_5068;
obj_t s_5067;
s_5067 = s_899;
{
long aux_5069;
aux_5069 = STRING_LENGTH(s_899);
len_5068 = BINT(aux_5069);
}
len_1191 = len_5068;
s_1190 = s_5067;
goto print_chars_22_1232;
}
}
}
}
}
}
}
 else {
if(KEYWORDP(item_858)){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2688;
long k_2689;
string_2688 = CELL_REF(buffer_4250);
k_2689 = _pointeur__164___intext;
STRING_SET(string_2688, k_2689, ((unsigned char)':'));
}
{
long z1_2691;
z1_2691 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2691+((long)1));
}
{
obj_t s_906;
s_906 = KEYWORD_TO_STRING(item_858);
{
obj_t len_5080;
obj_t s_5079;
s_5079 = s_906;
{
long aux_5081;
aux_5081 = STRING_LENGTH(s_906);
len_5080 = BINT(aux_5081);
}
len_1191 = len_5080;
s_1190 = s_5079;
goto print_chars_22_1232;
}
}
}
 else {
if(CHARP(item_858)){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2699;
long k_2700;
string_2699 = CELL_REF(buffer_4250);
k_2700 = _pointeur__164___intext;
STRING_SET(string_2699, k_2700, ((unsigned char)'a'));
}
{
long z1_2702;
z1_2702 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2702+((long)1));
}
{
obj_t aux_5090;
{
long aux_5091;
{
unsigned char aux_5092;
aux_5092 = (unsigned char)CCHAR(item_858);
aux_5091 = (aux_5092);
}
aux_5090 = BINT(aux_5091);
}
return print_di_101___intext(buffer_4250, length_buffer_16_4249, aux_5090);
}
}
 else {
if(UCS2P(item_858)){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2707;
long k_2708;
string_2707 = CELL_REF(buffer_4250);
k_2708 = _pointeur__164___intext;
STRING_SET(string_2707, k_2708, ((unsigned char)'u'));
}
{
long z1_2710;
z1_2710 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2710+((long)1));
}
{
long arg1267_911;
{
ucs2_t ucs2_2712;
ucs2_2712 = CUCS2(item_858);
arg1267_911 = (long)(ucs2_2712);
}
return print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(arg1267_911));
}
}
 else {
if(CNSTP(item_858)){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2715;
long k_2716;
string_2715 = CELL_REF(buffer_4250);
k_2716 = _pointeur__164___intext;
STRING_SET(string_2715, k_2716, ((unsigned char)'<'));
}
{
long z1_2718;
z1_2718 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2718+((long)1));
}
{
long arg1269_913;
arg1269_913 = CCNST(item_858);
return print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(arg1269_913));
}
}
 else {
if((item_858==BFALSE)){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2723;
long k_2724;
string_2723 = CELL_REF(buffer_4250);
k_2724 = _pointeur__164___intext;
STRING_SET(string_2723, k_2724, ((unsigned char)'F'));
}
{
long z1_2726;
z1_2726 = _pointeur__164___intext;
return (_pointeur__164___intext = (z1_2726+((long)1)),
BUNSPEC);
}
}
 else {
bool_t test1271_915;
test1271_915 = INTEGERP(item_858);
if(test1271_915){
return print_di_101___intext(buffer_4250, length_buffer_16_4249, item_858);
}
 else {
bool_t test_5125;
if(test1271_915){
test_5125 = ((bool_t)1);
}
 else {
test_5125 = REALP(item_858);
}
if(test_5125){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2733;
long k_2734;
string_2733 = CELL_REF(buffer_4250);
k_2734 = _pointeur__164___intext;
STRING_SET(string_2733, k_2734, ((unsigned char)'f'));
}
{
long z1_2736;
z1_2736 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2736+((long)1));
}
{
char * s_2739;
{
double aux_5132;
aux_5132 = REAL_TO_DOUBLE(item_858);
s_2739 = real_to_string(aux_5132);
}
{
obj_t len_5137;
obj_t s_5135;
s_5135 = string_to_bstring(s_2739);
{
long aux_5138;
{
obj_t aux_5139;
aux_5139 = string_to_bstring(s_2739);
aux_5138 = STRING_LENGTH(aux_5139);
}
len_5137 = BINT(aux_5138);
}
len_1191 = len_5137;
s_1190 = s_5135;
goto print_chars_22_1232;
}
}
}
 else {
if(STRINGP(item_858)){
marqueur_1058 = ((unsigned char)'"');
item_1059 = item_858;
print_string_82_1242:
{
obj_t mark_1061;
mark_1061 = get_string_mark_33___intext(item_1059);
{
bool_t test_5146;
{
obj_t aux_5147;
aux_5147 = STRUCT_REF(mark_1061, ((long)3));
test_5146 = CBOOL(aux_5147);
}
if(test_5146){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3316;
long k_3317;
string_3316 = CELL_REF(buffer_4250);
k_3317 = _pointeur__164___intext;
STRING_SET(string_3316, k_3317, ((unsigned char)'#'));
}
{
long z1_3319;
z1_3319 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3319+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, STRUCT_REF(mark_1061, ((long)2)));
{
obj_t aux_5156;
{
long aux_5157;
{
long aux_5158;
{
obj_t aux_5159;
aux_5159 = STRUCT_REF(mark_1061, ((long)4));
aux_5158 = (long)CINT(aux_5159);
}
aux_5157 = (aux_5158-((long)1));
}
aux_5156 = BINT(aux_5157);
}
STRUCT_SET(mark_1061, ((long)4), aux_5156);
}
{
bool_t test_5165;
{
long aux_5166;
{
obj_t aux_5167;
aux_5167 = STRUCT_REF(mark_1061, ((long)4));
aux_5166 = (long)CINT(aux_5167);
}
test_5165 = (aux_5166==((long)0));
}
if(test_5165){
return INVERSE_STRING_LENGTH(item_1059);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5172;
{
long aux_5173;
{
obj_t aux_5174;
aux_5174 = STRUCT_REF(mark_1061, ((long)4));
aux_5173 = (long)CINT(aux_5174);
}
test_5172 = (aux_5173==((long)0));
}
if(test_5172){
INVERSE_STRING_LENGTH(item_1059);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3347;
long k_3348;
string_3347 = CELL_REF(buffer_4250);
k_3348 = _pointeur__164___intext;
STRING_SET(string_3347, k_3348, marqueur_1058);
}
{
long z1_3350;
z1_3350 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3350+((long)1));
}
{
obj_t len_5184;
obj_t s_5183;
s_5183 = item_1059;
{
long aux_5185;
aux_5185 = STRING_LENGTH(item_1059);
len_5184 = BINT(aux_5185);
}
len_1191 = len_5184;
s_1190 = s_5183;
goto print_chars_22_1232;
}
}
 else {
{
long ref_1072;
ref_1072 = get_new_ref_211___intext();
{
obj_t aux_5189;
aux_5189 = BINT(ref_1072);
STRUCT_SET(mark_1061, ((long)2), aux_5189);
}
STRUCT_SET(mark_1061, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3366;
long k_3367;
string_3366 = CELL_REF(buffer_4250);
k_3367 = _pointeur__164___intext;
STRING_SET(string_3366, k_3367, ((unsigned char)'='));
}
{
long z1_3369;
z1_3369 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3369+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_1072));
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3372;
long k_3373;
string_3372 = CELL_REF(buffer_4250);
k_3373 = _pointeur__164___intext;
STRING_SET(string_3372, k_3373, marqueur_1058);
}
{
long z1_3375;
z1_3375 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3375+((long)1));
}
{
obj_t len_5204;
obj_t s_5203;
s_5203 = item_1059;
len_5204 = STRUCT_REF(mark_1061, ((long)1));
len_1191 = len_5204;
s_1190 = s_5203;
goto print_chars_22_1232;
}
}
}
}
}
}
}
 else {
if(UCS2_STRINGP(item_858)){
marqueur_1040 = ((unsigned char)'U');
item_1041 = item_858;
{
obj_t mark_1043;
mark_1043 = get_ucs2_string_mark_32___intext(item_1041);
{
bool_t test_5209;
{
obj_t aux_5210;
aux_5210 = STRUCT_REF(mark_1043, ((long)3));
test_5209 = CBOOL(aux_5210);
}
if(test_5209){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3256;
long k_3257;
string_3256 = CELL_REF(buffer_4250);
k_3257 = _pointeur__164___intext;
STRING_SET(string_3256, k_3257, ((unsigned char)'#'));
}
{
long z1_3259;
z1_3259 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3259+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, STRUCT_REF(mark_1043, ((long)2)));
{
obj_t aux_5219;
{
long aux_5220;
{
long aux_5221;
{
obj_t aux_5222;
aux_5222 = STRUCT_REF(mark_1043, ((long)4));
aux_5221 = (long)CINT(aux_5222);
}
aux_5220 = (aux_5221-((long)1));
}
aux_5219 = BINT(aux_5220);
}
STRUCT_SET(mark_1043, ((long)4), aux_5219);
}
{
bool_t test_5228;
{
long aux_5229;
{
obj_t aux_5230;
aux_5230 = STRUCT_REF(mark_1043, ((long)4));
aux_5229 = (long)CINT(aux_5230);
}
test_5228 = (aux_5229==((long)0));
}
if(test_5228){
return INVERSE_UCS2_STRING_LENGTH(item_1041);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5235;
{
long aux_5236;
{
obj_t aux_5237;
aux_5237 = STRUCT_REF(mark_1043, ((long)4));
aux_5236 = (long)CINT(aux_5237);
}
test_5235 = (aux_5236==((long)0));
}
if(test_5235){
{
obj_t string_1053;
{
obj_t arg1182_3286;
arg1182_3286 = get_ucs2_string_mark_32___intext(item_1041);
string_1053 = STRUCT_REF(arg1182_3286, ((long)5));
}
INVERSE_UCS2_STRING_LENGTH(item_1041);
{
obj_t item_5245;
unsigned char marqueur_5244;
marqueur_5244 = ((unsigned char)'U');
item_5245 = string_1053;
item_1059 = item_5245;
marqueur_1058 = marqueur_5244;
goto print_string_82_1242;
}
}
}
 else {
{
long ref_1054;
obj_t string_1055;
ref_1054 = get_new_ref_211___intext();
{
obj_t arg1182_3292;
arg1182_3292 = get_ucs2_string_mark_32___intext(item_1041);
string_1055 = STRUCT_REF(arg1182_3292, ((long)5));
}
{
obj_t aux_5249;
aux_5249 = BINT(ref_1054);
STRUCT_SET(mark_1043, ((long)2), aux_5249);
}
STRUCT_SET(mark_1043, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3307;
long k_3308;
string_3307 = CELL_REF(buffer_4250);
k_3308 = _pointeur__164___intext;
STRING_SET(string_3307, k_3308, ((unsigned char)'='));
}
{
long z1_3310;
z1_3310 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3310+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_1054));
{
obj_t item_5260;
unsigned char marqueur_5259;
marqueur_5259 = ((unsigned char)'U');
item_5260 = string_1055;
item_1059 = item_5260;
marqueur_1058 = marqueur_5259;
goto print_string_82_1242;
}
}
}
}
}
}
}
 else {
if(CELLP(item_858)){
{
bool_t test1276_920;
{
obj_t arg1298_942;
arg1298_942 = CELL_REF(item_858);
{
obj_t aux_5264;
aux_5264 = STRUCT_REF(arg1298_942, ((long)3));
test1276_920 = CBOOL(aux_5264);
}
}
if(test1276_920){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2750;
long k_2751;
string_2750 = CELL_REF(buffer_4250);
k_2751 = _pointeur__164___intext;
STRING_SET(string_2750, k_2751, ((unsigned char)'#'));
}
{
long z1_2753;
z1_2753 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2753+((long)1));
}
{
obj_t arg1277_921;
{
obj_t arg1278_922;
arg1278_922 = CELL_REF(item_858);
arg1277_921 = STRUCT_REF(arg1278_922, ((long)2));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, arg1277_921);
}
{
obj_t arg1281_923;
long arg1282_924;
arg1281_923 = CELL_REF(item_858);
{
obj_t arg1283_925;
{
obj_t arg1285_927;
arg1285_927 = CELL_REF(item_858);
arg1283_925 = STRUCT_REF(arg1285_927, ((long)4));
}
{
long aux_5278;
aux_5278 = (long)CINT(arg1283_925);
arg1282_924 = (aux_5278-((long)1));
}
}
{
obj_t aux_5281;
aux_5281 = BINT(arg1282_924);
STRUCT_SET(arg1281_923, ((long)4), aux_5281);
}
}
{
bool_t test1286_928;
{
obj_t arg1287_929;
{
obj_t arg1290_931;
arg1290_931 = CELL_REF(item_858);
arg1287_929 = STRUCT_REF(arg1290_931, ((long)4));
}
{
long aux_5286;
aux_5286 = (long)CINT(arg1287_929);
test1286_928 = (aux_5286==((long)0));
}
}
if(test1286_928){
obj_t old_value_175_2778;
{
obj_t arg1158_2779;
arg1158_2779 = CELL_REF(item_858);
old_value_175_2778 = STRUCT_REF(arg1158_2779, ((long)1));
}
return CELL_SET(item_858, old_value_175_2778);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test1291_932;
{
obj_t arg1295_939;
{
obj_t arg1297_941;
arg1297_941 = CELL_REF(item_858);
arg1295_939 = STRUCT_REF(arg1297_941, ((long)4));
}
{
long aux_5295;
aux_5295 = (long)CINT(arg1295_939);
test1291_932 = (aux_5295==((long)0));
}
}
if(test1291_932){
{
obj_t old_value_175_2791;
{
obj_t arg1158_2792;
arg1158_2792 = CELL_REF(item_858);
old_value_175_2791 = STRUCT_REF(arg1158_2792, ((long)1));
}
CELL_SET(item_858, old_value_175_2791);
}
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2798;
long k_2799;
string_2798 = CELL_REF(buffer_4250);
k_2799 = _pointeur__164___intext;
STRING_SET(string_2798, k_2799, ((unsigned char)'!'));
}
{
long z1_2801;
z1_2801 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2801+((long)1));
}
{
obj_t arg1292_933;
arg1292_933 = CELL_REF(item_858);
{
obj_t item_5307;
item_5307 = arg1292_933;
item_858 = item_5307;
goto print_item_54___intext;
}
}
}
 else {
{
long ref_934;
ref_934 = get_new_ref_211___intext();
{
obj_t mark_935;
mark_935 = CELL_REF(item_858);
{
{
obj_t aux_5310;
aux_5310 = BINT(ref_934);
STRUCT_SET(mark_935, ((long)2), aux_5310);
}
STRUCT_SET(mark_935, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2817;
long k_2818;
string_2817 = CELL_REF(buffer_4250);
k_2818 = _pointeur__164___intext;
STRING_SET(string_2817, k_2818, ((unsigned char)'='));
}
{
long z1_2820;
z1_2820 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2820+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_934));
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2823;
long k_2824;
string_2823 = CELL_REF(buffer_4250);
k_2824 = _pointeur__164___intext;
STRING_SET(string_2823, k_2824, ((unsigned char)'!'));
}
{
long z1_2826;
z1_2826 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2826+((long)1));
}
{
obj_t item_5324;
item_5324 = STRUCT_REF(mark_935, ((long)1));
item_858 = item_5324;
goto print_item_54___intext;
}
}
}
}
}
}
}
}
 else {
bool_t test1299_943;
{
bool_t test1399_1039;
test1399_1039 = EXTENDED_PAIRP(item_858);
if(test1399_1039){
test1299_943 = _epair___65___intext;
}
 else {
test1299_943 = ((bool_t)0);
}
}
if(test1299_943){
{
bool_t test_5329;
{
obj_t aux_5330;
{
obj_t aux_5331;
aux_5331 = CDR(item_858);
aux_5330 = STRUCT_REF(aux_5331, ((long)3));
}
test_5329 = CBOOL(aux_5330);
}
if(test_5329){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2838;
long k_2839;
string_2838 = CELL_REF(buffer_4250);
k_2839 = _pointeur__164___intext;
STRING_SET(string_2838, k_2839, ((unsigned char)'#'));
}
{
long z1_2841;
z1_2841 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2841+((long)1));
}
{
obj_t aux_5339;
{
obj_t aux_5340;
aux_5340 = CDR(item_858);
aux_5339 = STRUCT_REF(aux_5340, ((long)2));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, aux_5339);
}
return pair_mark_gc__141___intext(item_858);
}
 else {
bool_t test_5345;
{
long aux_5346;
{
obj_t aux_5347;
{
obj_t aux_5348;
aux_5348 = CDR(item_858);
aux_5347 = STRUCT_REF(aux_5348, ((long)4));
}
aux_5346 = (long)CINT(aux_5347);
}
test_5345 = (aux_5346==((long)0));
}
if(test_5345){
{
long len_948;
len_948 = marked_pair_length_178___intext(item_858);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2856;
long k_2857;
string_2856 = CELL_REF(buffer_4250);
k_2857 = _pointeur__164___intext;
STRING_SET(string_2856, k_2857, ((unsigned char)'^'));
}
{
long z1_2859;
z1_2859 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2859+((long)1));
}
{
obj_t aux_5358;
aux_5358 = CDR(item_858);
STRUCT_SET(aux_5358, ((long)3), BTRUE);
}
p_1104 = item_858;
len_1105 = len_948;
print_edl_122_1240:
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(len_1105));
print_mot_68___intext(buffer_4250, length_buffer_16_4249, BINT(len_1105));
{
long i_1107;
obj_t p_1108;
i_1107 = ((long)0);
p_1108 = p_1104;
loop_1109:
{
bool_t test_5365;
{
long aux_5366;
aux_5366 = (len_1105-((long)1));
test_5365 = (i_1107==aux_5366);
}
if(test_5365){
if(PAIRP(p_1108)){
print_item_54___intext(buffer_4250, length_buffer_16_4249, CAR(p_1108));
{
bool_t test1466_1113;
test1466_1113 = EXTENDED_PAIRP(p_1108);
if(test1466_1113){
obj_t arg1467_1114;
{
bool_t test1713_3511;
test1713_3511 = EXTENDED_PAIRP(p_1108);
if(test1713_3511){
arg1467_1114 = CER(p_1108);
}
 else {
arg1467_1114 = debug_error_location_199___error(string1902___intext, string1879___intext, p_1108, string1880___intext, BINT(((long)7610)));
}
}
print_item_54___intext(buffer_4250, length_buffer_16_4249, arg1467_1114);
}
 else {
print_item_54___intext(buffer_4250, length_buffer_16_4249, BUNSPEC);
}
}
print_item_54___intext(buffer_4250, length_buffer_16_4249, BNIL);
return pair_mark_gc__141___intext(p_1108);
}
 else {
obj_t item_5384;
item_5384 = p_1108;
item_858 = item_5384;
goto print_item_54___intext;
}
}
 else {
{
obj_t vcdr_1117;
{
obj_t aux_5385;
aux_5385 = CDR(p_1108);
vcdr_1117 = STRUCT_REF(aux_5385, ((long)1));
}
{
print_item_54___intext(buffer_4250, length_buffer_16_4249, CAR(p_1108));
{
bool_t test1470_1119;
test1470_1119 = EXTENDED_PAIRP(p_1108);
if(test1470_1119){
obj_t arg1471_1120;
{
bool_t test1713_3524;
test1713_3524 = EXTENDED_PAIRP(p_1108);
if(test1713_3524){
arg1471_1120 = CER(p_1108);
}
 else {
arg1471_1120 = debug_error_location_199___error(string1902___intext, string1879___intext, p_1108, string1880___intext, BINT(((long)7610)));
}
}
print_item_54___intext(buffer_4250, length_buffer_16_4249, arg1471_1120);
}
 else {
print_item_54___intext(buffer_4250, length_buffer_16_4249, BUNSPEC);
}
}
pair_mark_gc__141___intext(p_1108);
{
bool_t test_5400;
if(PAIRP(vcdr_1117)){
obj_t mark_1124;
mark_1124 = CDR(vcdr_1117);
{
bool_t _ortest_1016_1125;
_ortest_1016_1125 = _2__206___r4_numbers_6_5(STRUCT_REF(mark_1124, ((long)4)), BINT(((long)0)));
if(_ortest_1016_1125){
test_5400 = _ortest_1016_1125;
}
 else {
obj_t aux_5408;
aux_5408 = STRUCT_REF(mark_1124, ((long)3));
test_5400 = CBOOL(aux_5408);
}
}
}
 else {
test_5400 = ((bool_t)0);
}
if(test_5400){
obj_t item_5411;
item_5411 = vcdr_1117;
item_858 = item_5411;
goto print_item_54___intext;
}
 else {
obj_t p_5414;
long i_5412;
i_5412 = (i_1107+((long)1));
p_5414 = vcdr_1117;
p_1108 = p_5414;
i_1107 = i_5412;
goto loop_1109;
}
}
}
}
}
}
}
}
}
 else {
{
long ref_950;
obj_t mark_951;
long len_952;
ref_950 = get_new_ref_211___intext();
mark_951 = CDR(item_858);
len_952 = marked_pair_length_178___intext(item_858);
{
obj_t aux_5418;
aux_5418 = BINT(ref_950);
STRUCT_SET(mark_951, ((long)2), aux_5418);
}
STRUCT_SET(mark_951, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2881;
long k_2882;
string_2881 = CELL_REF(buffer_4250);
k_2882 = _pointeur__164___intext;
STRING_SET(string_2881, k_2882, ((unsigned char)'='));
}
{
long z1_2884;
z1_2884 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2884+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_950));
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2887;
long k_2888;
string_2887 = CELL_REF(buffer_4250);
k_2888 = _pointeur__164___intext;
STRING_SET(string_2887, k_2888, ((unsigned char)'^'));
}
{
long z1_2890;
z1_2890 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2890+((long)1));
}
{
long len_5433;
obj_t p_5432;
p_5432 = item_858;
len_5433 = len_952;
len_1105 = len_5433;
p_1104 = p_5432;
goto print_edl_122_1240;
}
}
}
}
}
}
 else {
if(PAIRP(item_858)){
{
bool_t test_5436;
{
obj_t aux_5437;
{
obj_t aux_5438;
aux_5438 = CDR(item_858);
aux_5437 = STRUCT_REF(aux_5438, ((long)3));
}
test_5436 = CBOOL(aux_5437);
}
if(test_5436){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2899;
long k_2900;
string_2899 = CELL_REF(buffer_4250);
k_2900 = _pointeur__164___intext;
STRING_SET(string_2899, k_2900, ((unsigned char)'#'));
}
{
long z1_2902;
z1_2902 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2902+((long)1));
}
{
obj_t aux_5446;
{
obj_t aux_5447;
aux_5447 = CDR(item_858);
aux_5446 = STRUCT_REF(aux_5447, ((long)2));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, aux_5446);
}
return pair_mark_gc__141___intext(item_858);
}
 else {
bool_t test_5452;
{
long aux_5453;
{
obj_t aux_5454;
{
obj_t aux_5455;
aux_5455 = CDR(item_858);
aux_5454 = STRUCT_REF(aux_5455, ((long)4));
}
aux_5453 = (long)CINT(aux_5454);
}
test_5452 = (aux_5453==((long)0));
}
if(test_5452){
{
long len_962;
len_962 = marked_pair_length_178___intext(item_858);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2917;
long k_2918;
string_2917 = CELL_REF(buffer_4250);
k_2918 = _pointeur__164___intext;
STRING_SET(string_2917, k_2918, ((unsigned char)'('));
}
{
long z1_2920;
z1_2920 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2920+((long)1));
}
{
obj_t aux_5465;
aux_5465 = CDR(item_858);
STRUCT_SET(aux_5465, ((long)3), BTRUE);
}
p_1129 = item_858;
len_1130 = len_962;
print_dl_11_1239:
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(len_1130));
print_mot_68___intext(buffer_4250, length_buffer_16_4249, BINT(len_1130));
{
long i_1132;
obj_t p_1133;
i_1132 = ((long)0);
p_1133 = p_1129;
loop_1134:
{
bool_t test_5472;
{
long aux_5473;
aux_5473 = (len_1130-((long)1));
test_5472 = (i_1132==aux_5473);
}
if(test_5472){
if(PAIRP(p_1133)){
print_item_54___intext(buffer_4250, length_buffer_16_4249, CAR(p_1133));
print_item_54___intext(buffer_4250, length_buffer_16_4249, BNIL);
return pair_mark_gc__141___intext(p_1133);
}
 else {
obj_t item_5482;
item_5482 = p_1133;
item_858 = item_5482;
goto print_item_54___intext;
}
}
 else {
{
obj_t vcdr_1140;
{
obj_t aux_5483;
aux_5483 = CDR(p_1133);
vcdr_1140 = STRUCT_REF(aux_5483, ((long)1));
}
{
print_item_54___intext(buffer_4250, length_buffer_16_4249, CAR(p_1133));
pair_mark_gc__141___intext(p_1133);
{
bool_t test_5489;
if(PAIRP(vcdr_1140)){
obj_t mark_1145;
mark_1145 = CDR(vcdr_1140);
{
bool_t _ortest_1015_1146;
_ortest_1015_1146 = _2__206___r4_numbers_6_5(STRUCT_REF(mark_1145, ((long)4)), BINT(((long)0)));
if(_ortest_1015_1146){
test_5489 = _ortest_1015_1146;
}
 else {
obj_t aux_5497;
aux_5497 = STRUCT_REF(mark_1145, ((long)3));
test_5489 = CBOOL(aux_5497);
}
}
}
 else {
test_5489 = ((bool_t)0);
}
if(test_5489){
obj_t item_5500;
item_5500 = vcdr_1140;
item_858 = item_5500;
goto print_item_54___intext;
}
 else {
obj_t p_5503;
long i_5501;
i_5501 = (i_1132+((long)1));
p_5503 = vcdr_1140;
p_1133 = p_5503;
i_1132 = i_5501;
goto loop_1134;
}
}
}
}
}
}
}
}
}
 else {
{
long ref_964;
obj_t mark_965;
long len_966;
ref_964 = get_new_ref_211___intext();
mark_965 = CDR(item_858);
len_966 = marked_pair_length_178___intext(item_858);
{
obj_t aux_5507;
aux_5507 = BINT(ref_964);
STRUCT_SET(mark_965, ((long)2), aux_5507);
}
STRUCT_SET(mark_965, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2942;
long k_2943;
string_2942 = CELL_REF(buffer_4250);
k_2943 = _pointeur__164___intext;
STRING_SET(string_2942, k_2943, ((unsigned char)'='));
}
{
long z1_2945;
z1_2945 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2945+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_964));
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2948;
long k_2949;
string_2948 = CELL_REF(buffer_4250);
k_2949 = _pointeur__164___intext;
STRING_SET(string_2948, k_2949, ((unsigned char)'('));
}
{
long z1_2951;
z1_2951 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2951+((long)1));
}
{
long len_5522;
obj_t p_5521;
p_5521 = item_858;
len_5522 = len_966;
len_1130 = len_5522;
p_1129 = p_5521;
goto print_dl_11_1239;
}
}
}
}
}
}
 else {
if(VECTORP(item_858)){
{
bool_t test_5525;
{
long aux_5526;
aux_5526 = VECTOR_LENGTH(item_858);
test_5525 = (aux_5526==((long)0));
}
if(test_5525){
{
long tag_973;
tag_973 = VECTOR_TAG(item_858);
if((tag_973>((long)0))){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2961;
long k_2962;
string_2961 = CELL_REF(buffer_4250);
k_2962 = _pointeur__164___intext;
STRING_SET(string_2961, k_2962, ((unsigned char)'t'));
}
{
long z1_2964;
z1_2964 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2964+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(tag_973));
v_1169 = item_858;
ref0_1170 = BNIL;
len_1171 = ((long)0);
print_dv_164_1236:
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(len_1171));
print_mot_68___intext(buffer_4250, length_buffer_16_4249, BINT(len_1171));
print_item_54___intext(buffer_4250, length_buffer_16_4249, ref0_1170);
{
long i_1173;
i_1173 = ((long)1);
for1013_1174:
{
bool_t test_5543;
{
long aux_5544;
aux_5544 = (len_1171-((long)1));
test_5543 = (i_1173<=aux_5544);
}
if(test_5543){
print_item_54___intext(buffer_4250, length_buffer_16_4249, VECTOR_REF(v_1169, i_1173));
{
long i_5549;
i_5549 = (i_1173+((long)1));
i_1173 = i_5549;
goto for1013_1174;
}
}
 else {
return symbol1877___intext;
}
}
}
}
 else {
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2967;
long k_2968;
string_2967 = CELL_REF(buffer_4250);
k_2968 = _pointeur__164___intext;
STRING_SET(string_2967, k_2968, ((unsigned char)'['));
}
{
long z1_2970;
z1_2970 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2970+((long)1));
}
{
long len_5557;
obj_t ref0_5556;
obj_t v_5555;
v_5555 = item_858;
ref0_5556 = BNIL;
len_5557 = ((long)0);
len_1171 = len_5557;
ref0_1170 = ref0_5556;
v_1169 = v_5555;
goto print_dv_164_1236;
}
}
}
}
 else {
bool_t test_5558;
{
obj_t aux_5559;
{
obj_t aux_5560;
aux_5560 = VECTOR_REF(item_858, ((long)0));
aux_5559 = STRUCT_REF(aux_5560, ((long)3));
}
test_5558 = CBOOL(aux_5559);
}
if(test_5558){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_2979;
long k_2980;
string_2979 = CELL_REF(buffer_4250);
k_2980 = _pointeur__164___intext;
STRING_SET(string_2979, k_2980, ((unsigned char)'#'));
}
{
long z1_2982;
z1_2982 = _pointeur__164___intext;
_pointeur__164___intext = (z1_2982+((long)1));
}
{
obj_t aux_5568;
{
obj_t aux_5569;
aux_5569 = VECTOR_REF(item_858, ((long)0));
aux_5568 = STRUCT_REF(aux_5569, ((long)2));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, aux_5568);
}
{
obj_t aux_5575;
obj_t aux_5573;
{
long aux_5576;
{
long aux_5577;
{
obj_t aux_5578;
{
obj_t aux_5579;
aux_5579 = VECTOR_REF(item_858, ((long)0));
aux_5578 = STRUCT_REF(aux_5579, ((long)4));
}
aux_5577 = (long)CINT(aux_5578);
}
aux_5576 = (aux_5577-((long)1));
}
aux_5575 = BINT(aux_5576);
}
aux_5573 = VECTOR_REF(item_858, ((long)0));
STRUCT_SET(aux_5573, ((long)4), aux_5575);
}
{
bool_t test_5586;
{
long aux_5587;
{
obj_t aux_5588;
{
obj_t aux_5589;
aux_5589 = VECTOR_REF(item_858, ((long)0));
aux_5588 = STRUCT_REF(aux_5589, ((long)4));
}
aux_5587 = (long)CINT(aux_5588);
}
test_5586 = (aux_5587==((long)0));
}
if(test_5586){
obj_t aux_5594;
{
obj_t aux_5595;
aux_5595 = VECTOR_REF(item_858, ((long)0));
aux_5594 = STRUCT_REF(aux_5595, ((long)1));
}
return VECTOR_SET(item_858, ((long)0), aux_5594);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5599;
{
long aux_5600;
{
obj_t aux_5601;
{
obj_t aux_5602;
aux_5602 = VECTOR_REF(item_858, ((long)0));
aux_5601 = STRUCT_REF(aux_5602, ((long)4));
}
aux_5600 = (long)CINT(aux_5601);
}
test_5599 = (aux_5600==((long)0));
}
if(test_5599){
{
obj_t aux_5607;
{
obj_t aux_5608;
aux_5608 = VECTOR_REF(item_858, ((long)0));
aux_5607 = STRUCT_REF(aux_5608, ((long)1));
}
VECTOR_SET(item_858, ((long)0), aux_5607);
}
{
long tag_992;
tag_992 = VECTOR_TAG(item_858);
if((tag_992>((long)0))){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3050;
long k_3051;
string_3050 = CELL_REF(buffer_4250);
k_3051 = _pointeur__164___intext;
STRING_SET(string_3050, k_3051, ((unsigned char)'t'));
}
{
long z1_3053;
z1_3053 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3053+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(tag_992));
{
long len_5624;
obj_t ref0_5622;
obj_t v_5621;
v_5621 = item_858;
ref0_5622 = VECTOR_REF(item_858, ((long)0));
len_5624 = VECTOR_LENGTH(item_858);
len_1171 = len_5624;
ref0_1170 = ref0_5622;
v_1169 = v_5621;
goto print_dv_164_1236;
}
}
 else {
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3059;
long k_3060;
string_3059 = CELL_REF(buffer_4250);
k_3060 = _pointeur__164___intext;
STRING_SET(string_3059, k_3060, ((unsigned char)'['));
}
{
long z1_3062;
z1_3062 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3062+((long)1));
}
{
long len_5633;
obj_t ref0_5631;
obj_t v_5630;
v_5630 = item_858;
ref0_5631 = VECTOR_REF(item_858, ((long)0));
len_5633 = VECTOR_LENGTH(item_858);
len_1171 = len_5633;
ref0_1170 = ref0_5631;
v_1169 = v_5630;
goto print_dv_164_1236;
}
}
}
}
 else {
{
long ref_998;
ref_998 = get_new_ref_211___intext();
{
obj_t mark_999;
mark_999 = VECTOR_REF(item_858, ((long)0));
{
long tag_1000;
tag_1000 = VECTOR_TAG(item_858);
{
long len_1001;
len_1001 = VECTOR_LENGTH(item_858);
{
obj_t ref0_1002;
ref0_1002 = BUNSPEC;
{
{
obj_t aux_5639;
aux_5639 = STRUCT_REF(mark_999, ((long)1));
VECTOR_SET(item_858, ((long)0), aux_5639);
}
ref0_1002 = VECTOR_REF(item_858, ((long)0));
VECTOR_SET(item_858, ((long)0), mark_999);
{
obj_t aux_5644;
aux_5644 = BINT(ref_998);
STRUCT_SET(mark_999, ((long)2), aux_5644);
}
STRUCT_SET(mark_999, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3095;
long k_3096;
string_3095 = CELL_REF(buffer_4250);
k_3096 = _pointeur__164___intext;
STRING_SET(string_3095, k_3096, ((unsigned char)'='));
}
{
long z1_3098;
z1_3098 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3098+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_998));
if((tag_1000>((long)0))){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3103;
long k_3104;
string_3103 = CELL_REF(buffer_4250);
k_3104 = _pointeur__164___intext;
STRING_SET(string_3103, k_3104, ((unsigned char)'t'));
}
{
long z1_3106;
z1_3106 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3106+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(tag_1000));
{
long len_5664;
obj_t ref0_5663;
obj_t v_5662;
v_5662 = item_858;
ref0_5663 = ref0_1002;
len_5664 = len_1001;
len_1171 = len_5664;
ref0_1170 = ref0_5663;
v_1169 = v_5662;
goto print_dv_164_1236;
}
}
 else {
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3109;
long k_3110;
string_3109 = CELL_REF(buffer_4250);
k_3110 = _pointeur__164___intext;
STRING_SET(string_3109, k_3110, ((unsigned char)'['));
}
{
long z1_3112;
z1_3112 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3112+((long)1));
}
{
long len_5671;
obj_t ref0_5670;
obj_t v_5669;
v_5669 = item_858;
ref0_5670 = ref0_1002;
len_5671 = len_1001;
len_1171 = len_5671;
ref0_1170 = ref0_5670;
v_1169 = v_5669;
goto print_dv_164_1236;
}
}
}
}
}
}
}
}
}
}
}
}
}
 else {
if(TVECTORP(item_858)){
{
obj_t mark_1013;
mark_1013 = PEEK(item_858, ((long)2));
{
bool_t test_5675;
{
obj_t aux_5676;
aux_5676 = STRUCT_REF(mark_1013, ((long)3));
test_5675 = CBOOL(aux_5676);
}
if(test_5675){
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3122;
long k_3123;
string_3122 = CELL_REF(buffer_4250);
k_3123 = _pointeur__164___intext;
STRING_SET(string_3122, k_3123, ((unsigned char)'#'));
}
{
long z1_3125;
z1_3125 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3125+((long)1));
}
{
obj_t arg1375_1015;
{
obj_t arg1378_1016;
arg1378_1016 = PEEK(item_858, ((long)2));
arg1375_1015 = STRUCT_REF(arg1378_1016, ((long)2));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, arg1375_1015);
}
{
obj_t arg1379_1017;
long arg1381_1018;
arg1379_1017 = PEEK(item_858, ((long)2));
{
obj_t arg1383_1019;
{
obj_t arg1385_1021;
arg1385_1021 = PEEK(item_858, ((long)2));
arg1383_1019 = STRUCT_REF(arg1385_1021, ((long)4));
}
{
long aux_5689;
aux_5689 = (long)CINT(arg1383_1019);
arg1381_1018 = (aux_5689-((long)1));
}
}
{
obj_t aux_5692;
aux_5692 = BINT(arg1381_1018);
STRUCT_SET(arg1379_1017, ((long)4), aux_5692);
}
}
{
bool_t test1386_1022;
{
obj_t arg1387_1023;
{
obj_t arg1389_1025;
arg1389_1025 = PEEK(item_858, ((long)2));
arg1387_1023 = STRUCT_REF(arg1389_1025, ((long)4));
}
{
long aux_5697;
aux_5697 = (long)CINT(arg1387_1023);
test1386_1022 = (aux_5697==((long)0));
}
}
if(test1386_1022){
obj_t old_value_175_3158;
{
obj_t arg1187_3159;
arg1187_3159 = PEEK(item_858, ((long)2));
old_value_175_3158 = STRUCT_REF(arg1187_3159, ((long)1));
}
return POKE(item_858, ((long)2), old_value_175_3158);
}
 else {
return BUNSPEC;
}
}
}
 else {
bool_t test_5704;
{
long aux_5705;
{
obj_t aux_5706;
aux_5706 = STRUCT_REF(mark_1013, ((long)4));
aux_5705 = (long)CINT(aux_5706);
}
test_5704 = (aux_5705==((long)0));
}
if(test_5704){
{
obj_t v_1027;
{
obj_t arg1191_3175;
arg1191_3175 = PEEK(item_858, ((long)2));
v_1027 = STRUCT_REF(arg1191_3175, ((long)5));
}
{
obj_t old_value_175_3183;
{
obj_t arg1187_3184;
arg1187_3184 = PEEK(item_858, ((long)2));
old_value_175_3183 = STRUCT_REF(arg1187_3184, ((long)1));
}
POKE(item_858, ((long)2), old_value_175_3183);
}
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3195;
long k_3196;
string_3195 = CELL_REF(buffer_4250);
k_3196 = _pointeur__164___intext;
STRING_SET(string_3195, k_3196, ((unsigned char)'V'));
}
{
long z1_3198;
z1_3198 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3198+((long)1));
}
print_item_54___intext(buffer_4250, length_buffer_16_4249, tvector_id_255___tvector(item_858));
{
obj_t item_5721;
item_5721 = v_1027;
item_858 = item_5721;
goto print_item_54___intext;
}
}
}
 else {
{
long ref_1029;
ref_1029 = get_new_ref_211___intext();
{
obj_t v_1031;
{
obj_t arg1191_3202;
arg1191_3202 = PEEK(item_858, ((long)2));
v_1031 = STRUCT_REF(arg1191_3202, ((long)5));
}
{
obj_t id_1032;
id_1032 = BUNSPEC;
{
{
obj_t aux_5725;
aux_5725 = STRUCT_REF(mark_1013, ((long)1));
POKE(item_858, ((long)2), aux_5725);
}
id_1032 = tvector_id_255___tvector(item_858);
POKE(item_858, ((long)2), mark_1013);
{
obj_t aux_5730;
aux_5730 = BINT(ref_1029);
STRUCT_SET(mark_1013, ((long)2), aux_5730);
}
STRUCT_SET(mark_1013, ((long)3), BTRUE);
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3230;
long k_3231;
string_3230 = CELL_REF(buffer_4250);
k_3231 = _pointeur__164___intext;
STRING_SET(string_3230, k_3231, ((unsigned char)'='));
}
{
long z1_3233;
z1_3233 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3233+((long)1));
}
print_di_101___intext(buffer_4250, length_buffer_16_4249, BINT(ref_1029));
verifie_taille_buffer__99___intext(buffer_4250, length_buffer_16_4249, BINT(((long)0)));
{
obj_t string_3236;
long k_3237;
string_3236 = CELL_REF(buffer_4250);
k_3237 = _pointeur__164___intext;
STRING_SET(string_3236, k_3237, ((unsigned char)'V'));
}
{
long z1_3239;
z1_3239 = _pointeur__164___intext;
_pointeur__164___intext = (z1_3239+((long)1));
}
print_item_54___intext(buffer_4250, length_buffer_16_4249, id_1032);
{
obj_t item_5745;
item_5745 = v_1031;
item_858 = item_5745;
goto print_item_54___intext;
}
}
}
}
}
}
}
}
}
}
 else {
if(PROCEDUREP(item_858)){
return debug_error_location_199___error(string1889___intext, string1903___intext, item_858, string1880___intext, BINT(((long)7610)));
}
 else {
bool_t test1398_1038;
test1398_1038 = PROCESSP(item_858);
if(test1398_1038){
return debug_error_location_199___error(string1889___intext, string1904___intext, item_858, string1880___intext, BINT(((long)7610)));
}
 else {
return debug_error_location_199___error(string1889___intext, string1905___intext, item_858, string1880___intext, BINT(((long)7610)));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}


/* _obj->string */obj_t _obj__string_80___intext(obj_t env_4226, obj_t obj_4227)
{
return obj_to_string(obj_4227);
}


/* arg1207 */obj_t arg1207___intext(obj_t env_4228, obj_t x_4229, obj_t y_4230)
{
{
bool_t aux_5757;
{
obj_t x_4263;
obj_t y_4264;
x_4263 = x_4229;
y_4264 = y_4230;
aux_5757 = ((x_4263)==(y_4264));
}
return BBOOL(aux_5757);
}
}


/* arg1206 */obj_t arg1206___intext(obj_t env_4231, obj_t s_4232)
{
{
obj_t s_850;
{
long aux_5760;
s_850 = s_4232;
aux_5760 = get_hash_power_number_from_int(s_850, ((long)10));
return BINT(aux_5760);
}
}
}


/* mark-item! */obj_t mark_item__0___intext(obj_t obj_78)
{
{
obj_t symbol1861_4212;
symbol1861_4212 = symbol1906___intext;
{
PUSH_TRACE(symbol1861_4212);
BUNSPEC;
{
obj_t aux1860_4213;
aux1860_4213 = loop___intext(obj_78);
POP_TRACE();
return aux1860_4213;
}
}
}
}


/* loop */obj_t loop___intext(obj_t obj_1247)
{
loop___intext:
{
bool_t test1546_1249;
test1546_1249 = (POINTERP( obj_1247 ) && (TYPE( obj_1247 ) >= OBJECT_TYPE));
if(test1546_1249){
{
bool_t test_5768;
{
obj_t arg1200_3719;
{
object_t aux_5769;
aux_5769 = (object_t)(obj_1247);
arg1200_3719 = OBJECT_WIDENING(aux_5769);
}
if(STRUCTP(arg1200_3719)){
obj_t aux_5774;
aux_5774 = STRUCT_KEY(arg1200_3719);
test_5768 = (aux_5774==symbol1884___intext);
}
 else {
test_5768 = ((bool_t)0);
}
}
if(test_5768){
obj_t arg1548_1251;
{
object_t aux_5777;
aux_5777 = (object_t)(obj_1247);
arg1548_1251 = OBJECT_WIDENING(aux_5777);
}
{
long ref_3731;
ref_3731 = _nb_ref__249___intext;
{
obj_t old_mark_80_3732;
old_mark_80_3732 = STRUCT_REF(arg1548_1251, ((long)4));
{
obj_t aux_5781;
{
long aux_5782;
{
long aux_5783;
aux_5783 = (long)CINT(old_mark_80_3732);
aux_5782 = (((long)1)+aux_5783);
}
aux_5781 = BINT(aux_5782);
}
STRUCT_SET(arg1548_1251, ((long)4), aux_5781);
}
{
bool_t test_5788;
{
long aux_5789;
aux_5789 = (long)CINT(old_mark_80_3732);
test_5788 = (aux_5789==((long)0));
}
if(test_5788){
return (_nb_ref__249___intext = (ref_3731+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3731,
BUNSPEC);
}
}
}
}
}
 else {
obj_t struct_1252;
struct_1252 = object__struct_50___object((object_t)(obj_1247));
object_mark__221___intext(obj_1247, struct_1252);
{
obj_t obj_5796;
obj_5796 = struct_1252;
obj_1247 = obj_5796;
goto loop___intext;
}
}
}
}
 else {
if(STRUCTP(obj_1247)){
{
bool_t test1550_1254;
{
obj_t arg1195_3751;
arg1195_3751 = PEEK(obj_1247, STRUCTURE_MARK_OFFSET);
if(STRUCTP(arg1195_3751)){
obj_t aux_5802;
aux_5802 = STRUCT_KEY(arg1195_3751);
test1550_1254 = (aux_5802==symbol1884___intext);
}
 else {
test1550_1254 = ((bool_t)0);
}
}
if(test1550_1254){
obj_t arg1552_1255;
arg1552_1255 = PEEK(obj_1247, STRUCTURE_MARK_OFFSET);
{
long ref_3767;
ref_3767 = _nb_ref__249___intext;
{
obj_t old_mark_80_3768;
old_mark_80_3768 = STRUCT_REF(arg1552_1255, ((long)4));
{
obj_t aux_5808;
{
long aux_5809;
{
long aux_5810;
aux_5810 = (long)CINT(old_mark_80_3768);
aux_5809 = (((long)1)+aux_5810);
}
aux_5808 = BINT(aux_5809);
}
STRUCT_SET(arg1552_1255, ((long)4), aux_5808);
}
{
bool_t test_5815;
{
long aux_5816;
aux_5816 = (long)CINT(old_mark_80_3768);
test_5815 = (aux_5816==((long)0));
}
if(test_5815){
return (_nb_ref__249___intext = (ref_3767+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3767,
BUNSPEC);
}
}
}
}
}
 else {
long len_1257;
len_1257 = STRUCT_LENGTH(obj_1247);
loop___intext(STRUCT_KEY(obj_1247));
struct_mark__56___intext(obj_1247);
{
long i_1258;
i_1258 = ((long)0);
liip_1259:
if((i_1258==len_1257)){
return symbol1877___intext;
}
 else {
loop___intext(STRUCT_REF(obj_1247, i_1258));
{
long i_5828;
i_5828 = (i_1258+((long)1));
i_1258 = i_5828;
goto liip_1259;
}
}
}
}
}
}
 else {
bool_t test1556_1263;
{
bool_t test1599_1311;
test1599_1311 = EXTENDED_PAIRP(obj_1247);
if(test1599_1311){
test1556_1263 = _epair___65___intext;
}
 else {
test1556_1263 = ((bool_t)0);
}
}
if(test1556_1263){
{
bool_t test_5833;
{
obj_t arg1153_3795;
arg1153_3795 = CDR(obj_1247);
if(STRUCTP(arg1153_3795)){
obj_t aux_5837;
aux_5837 = STRUCT_KEY(arg1153_3795);
test_5833 = (aux_5837==symbol1884___intext);
}
 else {
test_5833 = ((bool_t)0);
}
}
if(test_5833){
obj_t arg1558_1265;
arg1558_1265 = CDR(obj_1247);
{
long ref_3808;
ref_3808 = _nb_ref__249___intext;
{
obj_t old_mark_80_3809;
old_mark_80_3809 = STRUCT_REF(arg1558_1265, ((long)4));
{
obj_t aux_5842;
{
long aux_5843;
{
long aux_5844;
aux_5844 = (long)CINT(old_mark_80_3809);
aux_5843 = (((long)1)+aux_5844);
}
aux_5842 = BINT(aux_5843);
}
STRUCT_SET(arg1558_1265, ((long)4), aux_5842);
}
{
bool_t test_5849;
{
long aux_5850;
aux_5850 = (long)CINT(old_mark_80_3809);
test_5849 = (aux_5850==((long)0));
}
if(test_5849){
return (_nb_ref__249___intext = (ref_3808+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3808,
BUNSPEC);
}
}
}
}
}
 else {
obj_t ocar_1266;
obj_t ocdr_1267;
obj_t ocer_1268;
ocar_1266 = CAR(obj_1247);
ocdr_1267 = CDR(obj_1247);
{
bool_t test1713_3829;
test1713_3829 = EXTENDED_PAIRP(obj_1247);
if(test1713_3829){
ocer_1268 = CER(obj_1247);
}
 else {
ocer_1268 = debug_error_location_199___error(string1902___intext, string1879___intext, obj_1247, string1880___intext, BINT(((long)7610)));
}
}
pair_mark__18___intext(obj_1247);
loop___intext(ocar_1266);
loop___intext(ocer_1268);
{
obj_t obj_5864;
obj_5864 = ocdr_1267;
obj_1247 = obj_5864;
goto loop___intext;
}
}
}
}
 else {
if(PAIRP(obj_1247)){
{
bool_t test_5867;
{
obj_t arg1153_3836;
arg1153_3836 = CDR(obj_1247);
if(STRUCTP(arg1153_3836)){
obj_t aux_5871;
aux_5871 = STRUCT_KEY(arg1153_3836);
test_5867 = (aux_5871==symbol1884___intext);
}
 else {
test_5867 = ((bool_t)0);
}
}
if(test_5867){
obj_t arg1561_1271;
arg1561_1271 = CDR(obj_1247);
{
long ref_3849;
ref_3849 = _nb_ref__249___intext;
{
obj_t old_mark_80_3850;
old_mark_80_3850 = STRUCT_REF(arg1561_1271, ((long)4));
{
obj_t aux_5876;
{
long aux_5877;
{
long aux_5878;
aux_5878 = (long)CINT(old_mark_80_3850);
aux_5877 = (((long)1)+aux_5878);
}
aux_5876 = BINT(aux_5877);
}
STRUCT_SET(arg1561_1271, ((long)4), aux_5876);
}
{
bool_t test_5883;
{
long aux_5884;
aux_5884 = (long)CINT(old_mark_80_3850);
test_5883 = (aux_5884==((long)0));
}
if(test_5883){
return (_nb_ref__249___intext = (ref_3849+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3849,
BUNSPEC);
}
}
}
}
}
 else {
obj_t ocar_1272;
obj_t ocdr_1273;
ocar_1272 = CAR(obj_1247);
ocdr_1273 = CDR(obj_1247);
pair_mark__18___intext(obj_1247);
loop___intext(ocar_1272);
{
obj_t obj_5892;
obj_5892 = ocdr_1273;
obj_1247 = obj_5892;
goto loop___intext;
}
}
}
}
 else {
if(CELLP(obj_1247)){
{
bool_t test1563_1275;
{
obj_t arg1162_3870;
arg1162_3870 = CELL_REF(obj_1247);
if(STRUCTP(arg1162_3870)){
obj_t aux_5898;
aux_5898 = STRUCT_KEY(arg1162_3870);
test1563_1275 = (aux_5898==symbol1884___intext);
}
 else {
test1563_1275 = ((bool_t)0);
}
}
if(test1563_1275){
obj_t arg1564_1276;
arg1564_1276 = CELL_REF(obj_1247);
{
long ref_3881;
ref_3881 = _nb_ref__249___intext;
{
obj_t old_mark_80_3882;
old_mark_80_3882 = STRUCT_REF(arg1564_1276, ((long)4));
{
obj_t aux_5904;
{
long aux_5905;
{
long aux_5906;
aux_5906 = (long)CINT(old_mark_80_3882);
aux_5905 = (((long)1)+aux_5906);
}
aux_5904 = BINT(aux_5905);
}
STRUCT_SET(arg1564_1276, ((long)4), aux_5904);
}
{
bool_t test_5911;
{
long aux_5912;
aux_5912 = (long)CINT(old_mark_80_3882);
test_5911 = (aux_5912==((long)0));
}
if(test_5911){
return (_nb_ref__249___intext = (ref_3881+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3881,
BUNSPEC);
}
}
}
}
}
 else {
obj_t oref_1277;
oref_1277 = CELL_REF(obj_1247);
cell_mark__177___intext(obj_1247);
{
obj_t obj_5918;
obj_5918 = oref_1277;
obj_1247 = obj_5918;
goto loop___intext;
}
}
}
}
 else {
if(SYMBOLP(obj_1247)){
{
bool_t test_5921;
{
obj_t arg1166_3901;
arg1166_3901 = getprop___r4_symbols_6_4(obj_1247, symbol1884___intext);
if(STRUCTP(arg1166_3901)){
obj_t aux_5925;
aux_5925 = STRUCT_KEY(arg1166_3901);
test_5921 = (aux_5925==symbol1884___intext);
}
 else {
test_5921 = ((bool_t)0);
}
}
if(test_5921){
obj_t arg1568_1280;
arg1568_1280 = getprop___r4_symbols_6_4(obj_1247, symbol1884___intext);
{
long ref_3914;
ref_3914 = _nb_ref__249___intext;
{
obj_t old_mark_80_3915;
old_mark_80_3915 = STRUCT_REF(arg1568_1280, ((long)4));
{
obj_t aux_5930;
{
long aux_5931;
{
long aux_5932;
aux_5932 = (long)CINT(old_mark_80_3915);
aux_5931 = (((long)1)+aux_5932);
}
aux_5930 = BINT(aux_5931);
}
STRUCT_SET(arg1568_1280, ((long)4), aux_5930);
}
{
bool_t test_5937;
{
long aux_5938;
aux_5938 = (long)CINT(old_mark_80_3915);
test_5937 = (aux_5938==((long)0));
}
if(test_5937){
return (_nb_ref__249___intext = (ref_3914+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3914,
BUNSPEC);
}
}
}
}
}
 else {
return symbol_mark__15___intext(obj_1247);
}
}
}
 else {
if(KEYWORDP(obj_1247)){
return symbol1877___intext;
}
 else {
bool_t test_5945;
if(INTEGERP(obj_1247)){
test_5945 = ((bool_t)1);
}
 else {
test_5945 = REALP(obj_1247);
}
if(test_5945){
return symbol1877___intext;
}
 else {
if(STRINGP(obj_1247)){
{
bool_t test_5951;
{
long aux_5952;
aux_5952 = STRING_LENGTH(obj_1247);
test_5951 = (aux_5952<((long)0));
}
if(test_5951){
obj_t arg1573_1285;
arg1573_1285 = get_string_mark_33___intext(obj_1247);
{
long ref_3944;
ref_3944 = _nb_ref__249___intext;
{
obj_t old_mark_80_3945;
old_mark_80_3945 = STRUCT_REF(arg1573_1285, ((long)4));
{
obj_t aux_5957;
{
long aux_5958;
{
long aux_5959;
aux_5959 = (long)CINT(old_mark_80_3945);
aux_5958 = (((long)1)+aux_5959);
}
aux_5957 = BINT(aux_5958);
}
STRUCT_SET(arg1573_1285, ((long)4), aux_5957);
}
{
bool_t test_5964;
{
long aux_5965;
aux_5965 = (long)CINT(old_mark_80_3945);
test_5964 = (aux_5965==((long)0));
}
if(test_5964){
return (_nb_ref__249___intext = (ref_3944+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3944,
BUNSPEC);
}
}
}
}
}
 else {
return string_mark__64___intext(obj_1247);
}
}
}
 else {
if(UCS2_STRINGP(obj_1247)){
{
bool_t test_5972;
{
long aux_5973;
aux_5973 = UCS2_STRING_LENGTH(obj_1247);
test_5972 = (aux_5973<((long)0));
}
if(test_5972){
obj_t arg1578_1288;
arg1578_1288 = get_ucs2_string_mark_32___intext(obj_1247);
{
long ref_3970;
ref_3970 = _nb_ref__249___intext;
{
obj_t old_mark_80_3971;
old_mark_80_3971 = STRUCT_REF(arg1578_1288, ((long)4));
{
obj_t aux_5978;
{
long aux_5979;
{
long aux_5980;
aux_5980 = (long)CINT(old_mark_80_3971);
aux_5979 = (((long)1)+aux_5980);
}
aux_5978 = BINT(aux_5979);
}
STRUCT_SET(arg1578_1288, ((long)4), aux_5978);
}
{
bool_t test_5985;
{
long aux_5986;
aux_5986 = (long)CINT(old_mark_80_3971);
test_5985 = (aux_5986==((long)0));
}
if(test_5985){
return (_nb_ref__249___intext = (ref_3970+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_3970,
BUNSPEC);
}
}
}
}
}
 else {
return ucs2_string_mark__64___intext(obj_1247);
}
}
}
 else {
if(VECTORP(obj_1247)){
{
bool_t test_5993;
{
long aux_5994;
aux_5994 = VECTOR_LENGTH(obj_1247);
test_5993 = (aux_5994==((long)0));
}
if(test_5993){
return symbol1877___intext;
}
 else {
bool_t test_5997;
{
obj_t arg1186_3993;
arg1186_3993 = VECTOR_REF(obj_1247, ((long)0));
if(STRUCTP(arg1186_3993)){
obj_t aux_6001;
aux_6001 = STRUCT_KEY(arg1186_3993);
test_5997 = (aux_6001==symbol1884___intext);
}
 else {
test_5997 = ((bool_t)0);
}
}
if(test_5997){
obj_t arg1582_1292;
arg1582_1292 = VECTOR_REF(obj_1247, ((long)0));
{
long ref_4009;
ref_4009 = _nb_ref__249___intext;
{
obj_t old_mark_80_4010;
old_mark_80_4010 = STRUCT_REF(arg1582_1292, ((long)4));
{
obj_t aux_6006;
{
long aux_6007;
{
long aux_6008;
aux_6008 = (long)CINT(old_mark_80_4010);
aux_6007 = (((long)1)+aux_6008);
}
aux_6006 = BINT(aux_6007);
}
STRUCT_SET(arg1582_1292, ((long)4), aux_6006);
}
{
bool_t test_6013;
{
long aux_6014;
aux_6014 = (long)CINT(old_mark_80_4010);
test_6013 = (aux_6014==((long)0));
}
if(test_6013){
return (_nb_ref__249___intext = (ref_4009+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4009,
BUNSPEC);
}
}
}
}
}
 else {
long len_1293;
long tag_1294;
len_1293 = VECTOR_LENGTH(obj_1247);
tag_1294 = VECTOR_TAG(obj_1247);
loop___intext(VECTOR_REF(obj_1247, ((long)0)));
vector_mark__202___intext(obj_1247);
{
long i_1296;
i_1296 = ((long)1);
liip_1297:
if((i_1296>=len_1293)){
return symbol1877___intext;
}
 else {
loop___intext(VECTOR_REF(obj_1247, i_1296));
{
long i_6027;
i_6027 = (i_1296+((long)1));
i_1296 = i_6027;
goto liip_1297;
}
}
}
}
}
}
}
 else {
if(TVECTORP(obj_1247)){
{
bool_t test1590_1304;
{
obj_t arg1190_4039;
arg1190_4039 = PEEK(obj_1247, ((long)2));
if(STRUCTP(arg1190_4039)){
obj_t aux_6034;
aux_6034 = STRUCT_KEY(arg1190_4039);
test1590_1304 = (aux_6034==symbol1884___intext);
}
 else {
test1590_1304 = ((bool_t)0);
}
}
if(test1590_1304){
obj_t arg1592_1305;
arg1592_1305 = VECTOR_REF(obj_1247, ((long)0));
{
long ref_4055;
ref_4055 = _nb_ref__249___intext;
{
obj_t old_mark_80_4056;
old_mark_80_4056 = STRUCT_REF(arg1592_1305, ((long)4));
{
obj_t aux_6040;
{
long aux_6041;
{
long aux_6042;
aux_6042 = (long)CINT(old_mark_80_4056);
aux_6041 = (((long)1)+aux_6042);
}
aux_6040 = BINT(aux_6041);
}
STRUCT_SET(arg1592_1305, ((long)4), aux_6040);
}
{
bool_t test_6047;
{
long aux_6048;
aux_6048 = (long)CINT(old_mark_80_4056);
test_6047 = (aux_6048==((long)0));
}
if(test_6047){
return (_nb_ref__249___intext = (ref_4055+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4055,
BUNSPEC);
}
}
}
}
}
 else {
obj_t v_1306;
v_1306 = tvector__vector_99___tvector(obj_1247);
loop___intext(tvector_id_255___tvector(obj_1247));
loop___intext(v_1306);
return tvector_mark__214___intext(obj_1247, v_1306);
}
}
}
 else {
bool_t test1594_1308;
test1594_1308 = POINTERP(obj_1247);
if(test1594_1308){
bool_t test1595_1309;
{
obj_t arg1157_4074;
arg1157_4074 = PEEK(obj_1247, ((long)1));
if(STRUCTP(arg1157_4074)){
obj_t aux_6062;
aux_6062 = STRUCT_KEY(arg1157_4074);
test1595_1309 = (aux_6062==symbol1884___intext);
}
 else {
test1595_1309 = ((bool_t)0);
}
}
if(test1595_1309){
{
obj_t arg1598_1310;
arg1598_1310 = PEEK(obj_1247, ((long)1));
{
long ref_4090;
ref_4090 = _nb_ref__249___intext;
{
obj_t old_mark_80_4091;
old_mark_80_4091 = STRUCT_REF(arg1598_1310, ((long)4));
{
obj_t aux_6068;
{
long aux_6069;
{
long aux_6070;
aux_6070 = (long)CINT(old_mark_80_4091);
aux_6069 = (((long)1)+aux_6070);
}
aux_6068 = BINT(aux_6069);
}
STRUCT_SET(arg1598_1310, ((long)4), aux_6068);
}
{
bool_t test_6075;
{
long aux_6076;
aux_6076 = (long)CINT(old_mark_80_4091);
test_6075 = (aux_6076==((long)0));
}
if(test_6075){
return (_nb_ref__249___intext = (ref_4090+((long)1)),
BUNSPEC);
}
 else {
return (_nb_ref__249___intext = ref_4090,
BUNSPEC);
}
}
}
}
}
}
 else {
return symbol1877___intext;
}
}
 else {
return symbol1877___intext;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}


/* marked-pair-length */long marked_pair_length_178___intext(obj_t l_79)
{
{
obj_t symbol1863_4214;
symbol1863_4214 = symbol1907___intext;
{
PUSH_TRACE(symbol1863_4214);
BUNSPEC;
{
long aux1862_4215;
{
obj_t l_1312;
long r_1313;
l_1312 = l_79;
r_1313 = ((long)1);
loop_1314:
{
obj_t vcdr_1316;
{
obj_t aux_6081;
aux_6081 = CDR(l_1312);
vcdr_1316 = STRUCT_REF(aux_6081, ((long)1));
}
{
if(PAIRP(vcdr_1316)){
obj_t mark_1318;
mark_1318 = CDR(vcdr_1316);
{
bool_t test_6087;
if(_2__206___r4_numbers_6_5(STRUCT_REF(mark_1318, ((long)4)), BINT(((long)0)))){
test_6087 = ((bool_t)1);
}
 else {
obj_t aux_6092;
aux_6092 = STRUCT_REF(mark_1318, ((long)3));
test_6087 = CBOOL(aux_6092);
}
if(test_6087){
aux1862_4215 = (r_1313+((long)1));
}
 else {
long r_6097;
obj_t l_6096;
l_6096 = vcdr_1316;
r_6097 = (r_1313+((long)1));
r_1313 = r_6097;
l_1312 = l_6096;
goto loop_1314;
}
}
}
 else {
aux1862_4215 = (r_1313+((long)1));
}
}
}
}
POP_TRACE();
return aux1862_4215;
}
}
}
}


/* method-init */obj_t method_init_76___intext()
{
{
obj_t symbol1865_4216;
symbol1865_4216 = symbol1908___intext;
{
PUSH_TRACE(symbol1865_4216);
BUNSPEC;
POP_TRACE();
return BUNSPEC;
}
}
}


/* imported-modules-init */obj_t imported_modules_init_94___intext()
{
{
obj_t symbol1867_4218;
symbol1867_4218 = symbol1909___intext;
{
PUSH_TRACE(symbol1867_4218);
BUNSPEC;
{
obj_t aux1866_4219;
aux1866_4219 = module_initialization_70___error(((long)0), "__INTEXT");
POP_TRACE();
return aux1866_4219;
}
}
}
}

