/*===========================================================================*/
/*   (Llib/error.scm)                                                        */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

/* debug mode */
#define BIGLOO_DEBUG 1

#include <bigloo2.0a.h>
#include <signal.h>


/* Object type definitions */

extern obj_t display___r4_output_6_10_3(obj_t, obj_t);
extern bool_t bigloo_strcmp(obj_t, obj_t);
static obj_t sigsegv_error_handler_225___error(obj_t);
static obj_t method_init_76___error();
static obj_t _error___error(obj_t, obj_t, obj_t, obj_t);
extern obj_t string_to_symbol(char *);
static obj_t _warning_location_224___error(obj_t, obj_t, obj_t, obj_t);
static obj_t sigill_error_handler_131___error(obj_t);
static obj_t _warning___error(obj_t, obj_t);
static obj_t _error_location_file_221___error(obj_t, obj_t, obj_t);
extern obj_t current_output_port;
extern obj_t newline___r4_output_6_10_3(obj_t);
static obj_t _sigbus_error_handler_159___error(obj_t, obj_t);
extern obj_t error___error(obj_t, obj_t, obj_t);
static obj_t _notify_error_208___error(obj_t, obj_t, obj_t, obj_t);
extern obj_t string_append(obj_t, obj_t);
extern obj_t current_error_port;
static obj_t toplevel_init_63___error();
static obj_t do_warn_location_146___error(obj_t, long, obj_t, obj_t, long, obj_t);
static obj_t warning_location_file_177___error(obj_t, obj_t, obj_t);
static obj_t _sigsegv_error_handler_199___error(obj_t, obj_t);
extern obj_t class_name_139___object(obj_t);
static obj_t _exit___error(obj_t, obj_t);
static obj_t _error_location_7___error(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t warning_location_135___error(obj_t, obj_t, obj_t);
extern obj_t warning___error(obj_t);
extern obj_t dirname___os(obj_t);
extern obj_t signal___os(int, obj_t);
extern obj_t dump_trace_stack(obj_t, long);
extern obj_t string_to_bstring(char *);
extern obj_t bigloo_type_error_location_103___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t pwd___os();
static obj_t sigfpe_error_handler_194___error(obj_t);
static obj_t print_cursor_204___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t reverse___r4_pairs_and_lists_6_3(obj_t);
static obj_t lambda1118___error(obj_t, obj_t, obj_t, obj_t);
static obj_t lambda1104___error(obj_t, obj_t, obj_t, obj_t);
extern obj_t bigloo_type_error_msg_127___error(obj_t, obj_t, obj_t);
obj_t _debug__29___error = BUNSPEC;
static obj_t _find_runtime_type_101___error(obj_t, obj_t);
extern obj_t basename___os(obj_t);
obj_t _trace_stack_depth__228___error = BUNSPEC;
extern obj_t close_input_port(obj_t);
static obj_t _sigill_error_handler_76___error(obj_t, obj_t);
extern obj_t debug_error_location_199___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t make_string(long, unsigned char);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t module_initialization_70___r4_input_6_10_2(long, char *);
extern obj_t error_location_file_107___error(obj_t, obj_t);
extern obj_t find_runtime_type_96___error(obj_t);
extern obj_t c_substring(obj_t, long, long);
obj_t _warning__61___error = BUNSPEC;
extern obj_t notify_error_43___error(obj_t, obj_t, obj_t);
extern obj_t read_line_110___r4_input_6_10_2(obj_t);
static obj_t _error_handler__93___error = BUNSPEC;
extern obj_t exit___error(long);
extern obj_t the_c_failure(char *, char *, obj_t);
extern long get_write_length_193___r4_output_6_10_3();
static obj_t sigbus_error_handler_113___error(obj_t);
extern obj_t error_location_112___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t remove_error_handler__102___error();
static obj_t _the_c_failure___error(obj_t, obj_t, obj_t, obj_t);
static obj_t _bigloo_type_error_msg_141___error(obj_t, obj_t, obj_t, obj_t);
extern long list_length(obj_t);
extern obj_t _classes__134___object;
static obj_t _bigloo_type_error_184___error(obj_t, obj_t, obj_t, obj_t);
static obj_t _the_failure___error(obj_t, obj_t, obj_t, obj_t);
static obj_t nice_fname_167___error(obj_t);
static obj_t make_location_notifier_243___error(obj_t, long, obj_t, obj_t, long);
obj_t _error_notifier__99___error = BUNSPEC;
extern long string__integer_39___r4_numbers_6_5_fixnum(char *, obj_t);
extern obj_t bigloo_type_error_241___error(obj_t, obj_t, obj_t);
static obj_t path__list_117___error(obj_t);
static obj_t imported_modules_init_94___error();
extern obj_t string_append_106___r4_strings_6_7(obj_t);
static obj_t _module_init_error_73___error(obj_t, obj_t, obj_t);
extern obj_t add_error_handler__155___error(obj_t, obj_t);
static obj_t _bigloo_type_error_location_69___error(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t _remove_error_handler__20___error(obj_t);
extern obj_t set_write_length__244___r4_output_6_10_3(long);
static obj_t _sigfpe_error_handler_140___error(obj_t, obj_t);
static obj_t require_initialization_114___error = BUNSPEC;
extern obj_t the_failure(obj_t, obj_t, obj_t);
static obj_t fix_tabulation__127___error(obj_t, obj_t, obj_t);
static obj_t _add_error_handler__70___error(obj_t, obj_t, obj_t);
extern obj_t reader_reset__72___reader();
extern obj_t open_input_file_61___r4_ports_6_10_1(obj_t, obj_t);
static obj_t cnst_init_137___error();
extern obj_t reverse__39___r4_pairs_and_lists_6_3(obj_t);
extern obj_t fprint___r4_output_6_10_3(obj_t, obj_t);
static obj_t symbol1572___error = BUNSPEC;
extern obj_t module_init_error_170___error(char *, char *);
static obj_t _debug_error_location_240___error(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( warning_env_67___error, _warning___error1604, va_generic_entry, _warning___error, -1 );
DEFINE_STATIC_PROCEDURE( sigill_error_handler_env_91___error, _sigill_error_handler_76___error1605, _sigill_error_handler_76___error, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( find_runtime_type_env_158___error, _find_runtime_type_101___error1606, _find_runtime_type_101___error, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( module_init_error_env_89___error, _module_init_error_73___error1607, _module_init_error_73___error, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( debug_error_location_env_206___error, _debug_error_location_240___error1608, _debug_error_location_240___error, 0L, 5 );
DEFINE_STATIC_PROCEDURE( sigbus_error_handler_env_39___error, _sigbus_error_handler_159___error1609, _sigbus_error_handler_159___error, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( error_location_file_env_23___error, _error_location_file_221___error1610, _error_location_file_221___error, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( the_failure_env_207___error, _the_failure___error1611, _the_failure___error, 0L, 3 );
DEFINE_STATIC_PROCEDURE( sigfpe_error_handler_env_246___error, _sigfpe_error_handler_140___error1612, _sigfpe_error_handler_140___error, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( add_error_handler__env_228___error, _add_error_handler__70___error1613, _add_error_handler__70___error, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( the_c_failure_env_15___error, _the_c_failure___error1614, _the_c_failure___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( remove_error_handler__env_153___error, _remove_error_handler__20___error1615, _remove_error_handler__20___error, 0L, 0 );
DEFINE_STATIC_PROCEDURE( sigsegv_error_handler_env_118___error, _sigsegv_error_handler_199___error1616, _sigsegv_error_handler_199___error, 0L, 1 );
DEFINE_STATIC_PROCEDURE( proc1567___error, lambda1104___error1617, lambda1104___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( exit_env_50___error, _exit___error1618, _exit___error, 0L, 1 );
DEFINE_STRING( string1599___error, string1599___error1619, "BCNST", 5 );
DEFINE_STRING( string1598___error, string1598___error1620, "FOREIGN", 7 );
DEFINE_STRING( string1597___error, string1597___error1621, "CELL", 4 );
DEFINE_STRING( string1596___error, string1596___error1622, "BINARY-port", 11 );
DEFINE_STRING( string1595___error, string1595___error1623, "OUTPUT-port", 11 );
DEFINE_STRING( string1594___error, string1594___error1624, "INPUT-port", 10 );
DEFINE_STRING( string1593___error, string1593___error1625, "PROCEDURE", 9 );
DEFINE_STRING( string1592___error, string1592___error1626, "STRUCT", 6 );
DEFINE_STRING( string1602___error, string1602___error1627, "Type", 4 );
DEFINE_STRING( string1591___error, string1591___error1628, "TVECTOR", 7 );
DEFINE_STRING( string1601___error, string1601___error1629, "Inconsistent module initialization.\nAt least, one of the two modules has to be recompiled (see also -unsafev option)", 116 );
DEFINE_STRING( string1589___error, string1589___error1630, "PAIR", 4 );
DEFINE_STRING( string1590___error, string1590___error1631, "VECTOR", 6 );
DEFINE_STRING( string1600___error, string1600___error1632, "_", 1 );
DEFINE_STRING( string1588___error, string1588___error1633, "BNIL", 4 );
DEFINE_STRING( string1587___error, string1587___error1634, "BBOOL", 5 );
DEFINE_STRING( string1586___error, string1586___error1635, "BCHAR", 5 );
DEFINE_STRING( string1585___error, string1585___error1636, "KEYWORD", 7 );
DEFINE_STRING( string1584___error, string1584___error1637, "SYMBOL", 6 );
DEFINE_STRING( string1583___error, string1583___error1638, "BSTRING", 7 );
DEFINE_STRING( string1582___error, string1582___error1639, "REAL", 4 );
DEFINE_STRING( string1581___error, string1581___error1640, "BINT", 4 );
DEFINE_STRING( string1579___error, string1579___error1641, "../", 3 );
DEFINE_STRING( string1580___error, string1580___error1642, "/", 1 );
DEFINE_STRING( string1578___error, string1578___error1643, ".", 1 );
DEFINE_STRING( string1577___error, string1577___error1644, "File \"", 6 );
DEFINE_STRING( string1576___error, string1576___error1645, "\", line ", 8 );
DEFINE_STRING( string1575___error, string1575___error1646, ", character ", 12 );
DEFINE_STRING( string1574___error, string1574___error1647, "#", 1 );
DEFINE_STRING( string1573___error, string1573___error1648, "^", 1 );
DEFINE_STRING( string1571___error, string1571___error1649, "# *** WARNING:bigloo:", 21 );
DEFINE_STRING( string1569___error, string1569___error1650, "# *** ERROR:bigloo:", 19 );
DEFINE_STRING( string1570___error, string1570___error1651, "# ", 2 );
DEFINE_STRING( string1568___error, string1568___error1652, "", 0 );
DEFINE_STRING( string1566___error, string1566___error1653, "`segmentation violation' exception", 34 );
DEFINE_EXPORT_PROCEDURE( error_location_env_202___error, _error_location_7___error1654, _error_location_7___error, 0L, 5 );
DEFINE_STRING( string1565___error, string1565___error1655, "`bus error' exception", 21 );
DEFINE_STRING( string1564___error, string1564___error1656, "`illegal instruction' exception", 31 );
DEFINE_STRING( string1563___error, string1563___error1657, "bigloo", 6 );
DEFINE_STRING( string1562___error, string1562___error1658, "reached", 7 );
DEFINE_STRING( string1561___error, string1561___error1659, "`floating point' exception", 26 );
DEFINE_STRING( string1559___error, string1559___error1660, " `", 2 );
DEFINE_STRING( string1560___error, string1560___error1661, "arithmetic procedure", 20 );
DEFINE_STRING( string1558___error, string1558___error1662, "' expected, `", 13 );
DEFINE_STRING( string1557___error, string1557___error1663, "' provided", 10 );
DEFINE_STRING( string1556___error, string1556___error1664, ":", 1 );
DEFINE_STRING( string1555___error, string1555___error1665, " -- ", 4 );
DEFINE_STRING( string1554___error, string1554___error1666, "*** ERROR:bigloo:", 17 );
DEFINE_STRING( string1553___error, string1553___error1667, "Not an error handler", 20 );
DEFINE_STRING( string1552___error, string1552___error1668, "error", 5 );
DEFINE_STRING( string1551___error, string1551___error1669, "[stdin]", 7 );
DEFINE_STRING( string1549___error, string1549___error1670, "*** WARNING:bigloo:", 19 );
DEFINE_STRING( string1550___error, string1550___error1671, "[string]", 8 );
DEFINE_STRING( string1548___error, string1548___error1672, "error handler stack empty", 25 );
DEFINE_EXPORT_PROCEDURE( bigloo_type_error_location_env_21___error, _bigloo_type_error_location_69___error1673, _bigloo_type_error_location_69___error, 0L, 5 );
DEFINE_STRING( string1547___error, string1547___error1674, "Can't remove handler", 20 );
DEFINE_STRING( string1546___error, string1546___error1675, "remove-error-handler! (this is an internal error)", 49 );
DEFINE_EXPORT_PROCEDURE( bigloo_type_error_env_180___error, _bigloo_type_error_184___error1676, _bigloo_type_error_184___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( error_env_74___error, _error___error1677, _error___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( bigloo_type_error_msg_env_254___error, _bigloo_type_error_msg_141___error1678, _bigloo_type_error_msg_141___error, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( warning_location_env_18___error, _warning_location_224___error1679, va_generic_entry, _warning_location_224___error, -3 );
DEFINE_EXPORT_PROCEDURE( notify_error_env_37___error, _notify_error_208___error1680, _notify_error_208___error, 0L, 3 );


/* module-initialization */obj_t module_initialization_70___error(long checksum_1474, char * from_1475)
{
if(CBOOL(require_initialization_114___error)){
require_initialization_114___error = BBOOL(((bool_t)0));
cnst_init_137___error();
imported_modules_init_94___error();
method_init_76___error();
toplevel_init_63___error();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___error()
{
return (symbol1572___error = string_to_symbol("DONE"),
BUNSPEC);
}


/* toplevel-init */obj_t toplevel_init_63___error()
{
_debug__29___error = BINT(((long)0));
_warning__61___error = BTRUE;
{
obj_t env_value_204_449;
{
bool_t test1536_974;
test1536_974 = (long)getenv("BIGLOOSTACKDEPTH");
if(test1536_974){
char * aux_1487;
aux_1487 = (char *)getenv("BIGLOOSTACKDEPTH");
env_value_204_449 = string_to_bstring(aux_1487);
}
 else {
env_value_204_449 = BFALSE;
}
}
if(STRINGP(env_value_204_449)){
long aux_1492;
aux_1492 = string__integer_39___r4_numbers_6_5_fixnum(BSTRING_TO_STRING(env_value_204_449), BNIL);
_trace_stack_depth__228___error = BINT(aux_1492);
}
 else {
_trace_stack_depth__228___error = BINT(((long)10));
}
}
_error_handler__93___error = BNIL;
_error_notifier__99___error = BUNSPEC;
signal___os(SIGFPE, sigfpe_error_handler_env_246___error);
signal___os(SIGILL, sigill_error_handler_env_91___error);
signal___os(SIGBUS, sigbus_error_handler_env_39___error);
return signal___os(SIGSEGV, sigsegv_error_handler_env_118___error);
}


/* exit */obj_t exit___error(long n_1)
{
exit(n_1);
return BINT(n_1);
}


/* _exit */obj_t _exit___error(obj_t env_1393, obj_t n_1394)
{
{
long n_1470;
n_1470 = (long)CINT(n_1394);
exit(n_1470);
return BINT(n_1470);
}
}


/* add-error-handler! */obj_t add_error_handler__155___error(obj_t handler_2, obj_t escape_3)
{
{
obj_t arg1020_980;
arg1020_980 = MAKE_PAIR(handler_2, escape_3);
{
obj_t obj2_984;
obj2_984 = _error_handler__93___error;
return (_error_handler__93___error = MAKE_PAIR(arg1020_980, obj2_984),
BUNSPEC);
}
}
}


/* _add-error-handler! */obj_t _add_error_handler__70___error(obj_t env_1395, obj_t handler_1396, obj_t escape_1397)
{
return add_error_handler__155___error(handler_1396, escape_1397);
}


/* remove-error-handler! */obj_t remove_error_handler__102___error()
{
{
bool_t test1021_456;
{
obj_t obj_985;
obj_985 = _error_handler__93___error;
test1021_456 = PAIRP(obj_985);
}
if(test1021_456){
obj_t pair_986;
pair_986 = _error_handler__93___error;
_error_handler__93___error = CDR(pair_986);
}
 else {
notify_error_43___error(string1546___error, string1547___error, string1548___error);
{
obj_t aux_1513;
aux_1513 = BINT(((long)1));
BIGLOO_EXIT(aux_1513);
}
}
}
return _error_handler__93___error;
}


/* _remove-error-handler! */obj_t _remove_error_handler__20___error(obj_t env_1398)
{
return remove_error_handler__102___error();
}


/* error */obj_t error___error(obj_t proc_4, obj_t message_5, obj_t object_6)
{
FAILURE(proc_4,message_5,object_6);}


/* _error */obj_t _error___error(obj_t env_1399, obj_t proc_1400, obj_t message_1401, obj_t object_1402)
{
{
obj_t proc_1471;
obj_t message_1472;
obj_t object_1473;
proc_1471 = proc_1400;
message_1472 = message_1401;
object_1473 = object_1402;
FAILURE(proc_1471,message_1472,object_1473);}
}


/* warning */obj_t warning___error(obj_t args_7)
{
if(CBOOL(_warning__61___error)){
FLUSH_OUTPUT_PORT(current_output_port);
{
obj_t list1024_459;
list1024_459 = MAKE_PAIR(current_error_port, BNIL);
newline___r4_output_6_10_3(list1024_459);
}
{
obj_t list1028_463;
list1028_463 = MAKE_PAIR(current_error_port, BNIL);
display___r4_output_6_10_3(string1549___error, list1028_463);
}
if(NULLP(args_7)){
BUNSPEC;
}
 else {
{
obj_t list1033_468;
{
obj_t aux_1528;
aux_1528 = CAR(args_7);
list1033_468 = MAKE_PAIR(aux_1528, BNIL);
}
fprint___r4_output_6_10_3(current_error_port, list1033_468);
}
{
obj_t l1005_470;
{
bool_t aux_1532;
l1005_470 = CDR(args_7);
lname1006_471:
if(PAIRP(l1005_470)){
{
obj_t a_474;
a_474 = CAR(l1005_470);
{
obj_t list1038_476;
list1038_476 = MAKE_PAIR(current_error_port, BNIL);
display___r4_output_6_10_3(a_474, list1038_476);
}
}
{
obj_t l1005_1538;
l1005_1538 = CDR(l1005_470);
l1005_470 = l1005_1538;
goto lname1006_471;
}
}
 else {
aux_1532 = ((bool_t)1);
}
BBOOL(aux_1532);
}
}
}
{
obj_t list1042_480;
list1042_480 = MAKE_PAIR(current_error_port, BNIL);
newline___r4_output_6_10_3(list1042_480);
}
return FLUSH_OUTPUT_PORT(current_error_port);
}
 else {
return BUNSPEC;
}
}


/* _warning */obj_t _warning___error(obj_t env_1403, obj_t args_1404)
{
return warning___error(args_1404);
}


/* warning/location */obj_t warning_location_135___error(obj_t fname_8, obj_t location_9, obj_t args_10)
{
if(CBOOL(_warning__61___error)){
bool_t test1045_995;
test1045_995 = bigloo_strcmp(fname_8, string1550___error);
if(test1045_995){
return warning___error(args_10);
}
 else {
bool_t test1047_997;
test1047_997 = bigloo_strcmp(fname_8, string1551___error);
if(test1047_997){
return warning___error(args_10);
}
 else {
return warning_location_file_177___error(fname_8, location_9, args_10);
}
}
}
 else {
return BUNSPEC;
}
}


/* _warning/location */obj_t _warning_location_224___error(obj_t env_1405, obj_t fname_1406, obj_t location_1407, obj_t args_1408)
{
return warning_location_135___error(fname_1406, location_1407, args_1408);
}


/* the_failure */obj_t the_failure(obj_t proc_11, obj_t message_12, obj_t object_13)
{
reader_reset__72___reader();
{
bool_t test1049_487;
{
obj_t obj_1003;
obj_1003 = _error_handler__93___error;
test1049_487 = PAIRP(obj_1003);
}
if(test1049_487){
obj_t handler_488;
obj_t escape_489;
{
obj_t arg1055_494;
{
obj_t pair_1004;
pair_1004 = _error_handler__93___error;
arg1055_494 = CAR(pair_1004);
}
handler_488 = CAR(arg1055_494);
}
{
obj_t arg1056_495;
{
obj_t pair_1006;
pair_1006 = _error_handler__93___error;
arg1056_495 = CAR(pair_1006);
}
escape_489 = CDR(arg1056_495);
}
{
bool_t test1050_490;
if(PROCEDUREP(handler_488)){
long arg1053_492;
arg1053_492 = PROCEDURE_ARITY(handler_488);
test1050_490 = (arg1053_492==((long)4));
}
 else {
test1050_490 = ((bool_t)0);
}
if(test1050_490){
return PROCEDURE_ENTRY(handler_488)(handler_488, escape_489, proc_11, message_12, object_13, BEOA);
}
 else {
notify_error_43___error(string1552___error, string1553___error, handler_488);
return BINT(((long)-1));
}
}
}
 else {
notify_error_43___error(proc_11, message_12, object_13);
return BINT(((long)-1));
}
}
}


/* _the_failure */obj_t _the_failure___error(obj_t env_1409, obj_t proc_1410, obj_t message_1411, obj_t object_1412)
{
return the_failure(proc_1410, message_1411, object_1412);
}


/* the_c_failure */obj_t the_c_failure(char * proc_14, char * message_15, obj_t object_16)
{
return the_failure(string_to_bstring(proc_14), string_to_bstring(message_15), object_16);
}


/* _the_c_failure */obj_t _the_c_failure___error(obj_t env_1413, obj_t proc_1414, obj_t message_1415, obj_t object_1416)
{
return the_c_failure(BSTRING_TO_STRING(proc_1414), BSTRING_TO_STRING(message_1415), object_1416);
}


/* notify-error */obj_t notify_error_43___error(obj_t proc_17, obj_t mes_18, obj_t obj_19)
{
{
bool_t test1057_496;
{
obj_t obj_1018;
obj_1018 = _error_notifier__99___error;
test1057_496 = PROCEDUREP(obj_1018);
}
if(test1057_496){
return PROCEDURE_ENTRY(_error_notifier__99___error)(_error_notifier__99___error, proc_17, mes_18, obj_19, BEOA);
}
 else {
FLUSH_OUTPUT_PORT(current_output_port);
{
obj_t list1060_499;
list1060_499 = MAKE_PAIR(current_error_port, BNIL);
newline___r4_output_6_10_3(list1060_499);
}
{
long old_length_68_501;
old_length_68_501 = get_write_length_193___r4_output_6_10_3();
set_write_length__244___r4_output_6_10_3(((long)80));
{
obj_t list1064_504;
list1064_504 = MAKE_PAIR(current_error_port, BNIL);
display___r4_output_6_10_3(string1554___error, list1064_504);
}
{
obj_t list1069_509;
{
obj_t arg1070_510;
{
obj_t arg1072_511;
{
obj_t arg1073_512;
{
obj_t arg1076_513;
{
obj_t arg1077_514;
arg1077_514 = MAKE_PAIR(obj_19, BNIL);
arg1076_513 = MAKE_PAIR(string1555___error, arg1077_514);
}
arg1073_512 = MAKE_PAIR(mes_18, arg1076_513);
}
{
obj_t aux_1595;
aux_1595 = BCHAR(((unsigned char)'\n'));
arg1072_511 = MAKE_PAIR(aux_1595, arg1073_512);
}
}
arg1070_510 = MAKE_PAIR(string1556___error, arg1072_511);
}
list1069_509 = MAKE_PAIR(proc_17, arg1070_510);
}
fprint___r4_output_6_10_3(current_error_port, list1069_509);
}
{
bool_t test1079_516;
{
bool_t test1080_517;
{
obj_t obj_1020;
obj_1020 = _debug__29___error;
test1080_517 = INTEGERP(obj_1020);
}
if(test1080_517){
long n1_1021;
n1_1021 = (long)CINT(_debug__29___error);
test1079_516 = (n1_1021>((long)0));
}
 else {
test1079_516 = ((bool_t)0);
}
}
if(test1079_516){
obj_t depth_1023;
{
bool_t test1019_1024;
{
obj_t obj_1026;
obj_1026 = _trace_stack_depth__228___error;
test1019_1024 = INTEGERP(obj_1026);
}
if(test1019_1024){
depth_1023 = _trace_stack_depth__228___error;
}
 else {
depth_1023 = BINT(((long)10));
}
}
{
long aux_1609;
aux_1609 = (long)CINT(depth_1023);
dump_trace_stack(current_error_port, aux_1609);
}
}
 else {
BUNSPEC;
}
}
set_write_length__244___r4_output_6_10_3(old_length_68_501);
return FLUSH_OUTPUT_PORT(current_error_port);
}
}
}
}


/* _notify-error */obj_t _notify_error_208___error(obj_t env_1417, obj_t proc_1418, obj_t mes_1419, obj_t obj_1420)
{
return notify_error_43___error(proc_1418, mes_1419, obj_1420);
}


/* bigloo-type-error-msg */obj_t bigloo_type_error_msg_127___error(obj_t prefix_20, obj_t from_21, obj_t to_22)
{
{
obj_t list1082_519;
{
obj_t arg1083_520;
{
obj_t arg1085_522;
{
obj_t arg1086_523;
{
obj_t arg1088_525;
{
obj_t arg1089_526;
arg1089_526 = MAKE_PAIR(string1557___error, BNIL);
arg1088_525 = MAKE_PAIR(to_22, arg1089_526);
}
arg1086_523 = MAKE_PAIR(string1558___error, arg1088_525);
}
arg1085_522 = MAKE_PAIR(from_21, arg1086_523);
}
arg1083_520 = MAKE_PAIR(string1559___error, arg1085_522);
}
list1082_519 = MAKE_PAIR(prefix_20, arg1083_520);
}
return string_append_106___r4_strings_6_7(list1082_519);
}
}


/* _bigloo-type-error-msg */obj_t _bigloo_type_error_msg_141___error(obj_t env_1421, obj_t prefix_1422, obj_t from_1423, obj_t to_1424)
{
return bigloo_type_error_msg_127___error(prefix_1422, from_1423, to_1424);
}


/* sigfpe-error-handler */obj_t sigfpe_error_handler_194___error(obj_t n_27)
{
FAILURE(string1560___error,string1561___error,string1562___error);}


/* _sigfpe-error-handler */obj_t _sigfpe_error_handler_140___error(obj_t env_1385, obj_t n_1386)
{
return sigfpe_error_handler_194___error(n_1386);
}


/* sigill-error-handler */obj_t sigill_error_handler_131___error(obj_t n_28)
{
FAILURE(string1563___error,string1564___error,string1562___error);}


/* _sigill-error-handler */obj_t _sigill_error_handler_76___error(obj_t env_1387, obj_t n_1388)
{
return sigill_error_handler_131___error(n_1388);
}


/* sigbus-error-handler */obj_t sigbus_error_handler_113___error(obj_t n_29)
{
FAILURE(string1563___error,string1565___error,string1562___error);}


/* _sigbus-error-handler */obj_t _sigbus_error_handler_159___error(obj_t env_1389, obj_t n_1390)
{
return sigbus_error_handler_113___error(n_1390);
}


/* sigsegv-error-handler */obj_t sigsegv_error_handler_225___error(obj_t n_30)
{
FAILURE(string1563___error,string1566___error,string1562___error);}


/* _sigsegv-error-handler */obj_t _sigsegv_error_handler_199___error(obj_t env_1391, obj_t n_1392)
{
return sigsegv_error_handler_225___error(n_1392);
}


/* error/location */obj_t error_location_112___error(obj_t proc_31, obj_t message_32, obj_t object_33, obj_t fname_34, obj_t location_35)
{
if(STRINGP(fname_34)){
if(INTEGERP(location_35)){
bool_t test1094_531;
test1094_531 = bigloo_strcmp(fname_34, string1550___error);
if(test1094_531){
FAILURE(proc_31,message_32,object_33);}
 else {
bool_t test1095_532;
test1095_532 = bigloo_strcmp(fname_34, string1551___error);
if(test1095_532){
FAILURE(proc_31,message_32,object_33);}
 else {
bool_t test1096_533;
test1096_533 = bigloo_strcmp(fname_34, string1550___error);
if(test1096_533){
FAILURE(proc_31,message_32,object_33);}
 else {
_error_notifier__99___error = error_location_file_107___error(fname_34, location_35);
FAILURE(proc_31,message_32,object_33);}
}
}
}
 else {
FAILURE(proc_31,message_32,object_33);}
}
 else {
FAILURE(proc_31,message_32,object_33);}
}


/* _error/location */obj_t _error_location_7___error(obj_t env_1425, obj_t proc_1426, obj_t message_1427, obj_t object_1428, obj_t fname_1429, obj_t location_1430)
{
return error_location_112___error(proc_1426, message_1427, object_1428, fname_1429, location_1430);
}


/* debug-error/location */obj_t debug_error_location_199___error(obj_t proc_36, obj_t message_37, obj_t object_38, obj_t fname_39, obj_t location_40)
{
{
bool_t test1097_1069;
{
obj_t obj_1070;
obj_1070 = _error_notifier__99___error;
test1097_1069 = PROCEDUREP(obj_1070);
}
if(test1097_1069){
FAILURE(proc_36,message_37,object_38);}
 else {
return error_location_112___error(proc_36, message_37, object_38, fname_39, location_40);
}
}
}


/* _debug-error/location */obj_t _debug_error_location_240___error(obj_t env_1431, obj_t proc_1432, obj_t message_1433, obj_t object_1434, obj_t fname_1435, obj_t location_1436)
{
return debug_error_location_199___error(proc_1432, message_1433, object_1434, fname_1435, location_1436);
}


/* error/location-file */obj_t error_location_file_107___error(obj_t file_name_128_41, obj_t location_42)
{
{
obj_t port_535;
port_535 = open_input_file_61___r4_ports_6_10_1(file_name_128_41, BNIL);
if(INPUT_PORTP(port_535)){
obj_t line_string_28_537;
long line_num_62_538;
{
obj_t arg1099_540;
{
obj_t list1101_542;
list1101_542 = MAKE_PAIR(port_535, BNIL);
arg1099_540 = read_line_110___r4_input_6_10_2(list1101_542);
}
line_string_28_537 = arg1099_540;
line_num_62_538 = ((long)1);
loop_539:
{
bool_t test1103_544;
test1103_544 = EOF_OBJECTP(line_string_28_537);
if(test1103_544){
close_input_port(port_535);
{
obj_t lambda1104_1437;
lambda1104_1437 = proc1567___error;
return lambda1104_1437;
}
}
 else {
bool_t test1105_549;
{
long arg1114_559;
{
long arg1115_560;
int arg1116_561;
arg1115_560 = STRING_LENGTH(line_string_28_537);
{
int res1537_1079;
{
long aux_1663;
aux_1663 = INPUT_PORT_FILEPOS(port_535);
res1537_1079 = (int)(aux_1663);
}
arg1116_561 = res1537_1079;
}
{
long aux_1666;
aux_1666 = (long)(arg1116_561);
arg1114_559 = (arg1115_560+aux_1666);
}
}
{
long aux_1669;
aux_1669 = (long)CINT(location_42);
test1105_549 = (arg1114_559>=aux_1669);
}
}
if(test1105_549){
close_input_port(port_535);
{
long arg1106_550;
{
long arg1107_551;
{
int arg1109_553;
{
int res1538_1086;
{
long aux_1674;
aux_1674 = INPUT_PORT_FILEPOS(port_535);
res1538_1086 = (int)(aux_1674);
}
arg1109_553 = res1538_1086;
}
{
long aux_1679;
long aux_1677;
aux_1679 = (long)(arg1109_553);
aux_1677 = (long)CINT(location_42);
arg1107_551 = (aux_1677-aux_1679);
}
}
arg1106_550 = (arg1107_551+((long)1));
}
return make_location_notifier_243___error(file_name_128_41, line_num_62_538, location_42, line_string_28_537, arg1106_550);
}
}
 else {
int old_pos_44_554;
{
int res1539_1092;
{
long aux_1684;
aux_1684 = INPUT_PORT_FILEPOS(port_535);
res1539_1092 = (int)(aux_1684);
}
old_pos_44_554 = res1539_1092;
}
{
obj_t arg1110_555;
long arg1111_556;
{
obj_t list1112_557;
list1112_557 = MAKE_PAIR(port_535, BNIL);
arg1110_555 = read_line_110___r4_input_6_10_2(list1112_557);
}
arg1111_556 = (line_num_62_538+((long)1));
{
long line_num_62_1691;
obj_t line_string_28_1690;
line_string_28_1690 = arg1110_555;
line_num_62_1691 = arg1111_556;
line_num_62_538 = line_num_62_1691;
line_string_28_537 = line_string_28_1690;
goto loop_539;
}
}
}
}
}
}
}
 else {
return BFALSE;
}
}
}


/* _error/location-file */obj_t _error_location_file_221___error(obj_t env_1438, obj_t file_name_128_1439, obj_t location_1440)
{
return error_location_file_107___error(file_name_128_1439, location_1440);
}


/* lambda1104 */obj_t lambda1104___error(obj_t env_1441, obj_t proc_1442, obj_t msg_1443, obj_t obj_1444)
{
{
obj_t proc_545;
obj_t msg_546;
obj_t obj_547;
proc_545 = proc_1442;
msg_546 = msg_1443;
obj_547 = obj_1444;
_error_notifier__99___error = BFALSE;
return notify_error_43___error(proc_545, msg_546, obj_547);
}
}


/* make-location-notifier */obj_t make_location_notifier_243___error(obj_t fname_43, long line_44, obj_t char_45, obj_t string_46, long marker_47)
{
{
obj_t lambda1118_1445;
lambda1118_1445 = make_fx_procedure(lambda1118___error, ((long)3), ((long)5));
{
obj_t aux_1695;
aux_1695 = BINT(marker_47);
PROCEDURE_SET(lambda1118_1445, ((long)0), aux_1695);
}
PROCEDURE_SET(lambda1118_1445, ((long)1), string_46);
PROCEDURE_SET(lambda1118_1445, ((long)2), fname_43);
{
obj_t aux_1700;
aux_1700 = BINT(line_44);
PROCEDURE_SET(lambda1118_1445, ((long)3), aux_1700);
}
PROCEDURE_SET(lambda1118_1445, ((long)4), char_45);
return lambda1118_1445;
}
}


/* lambda1118 */obj_t lambda1118___error(obj_t env_1446, obj_t proc_1452, obj_t msg_1453, obj_t obj_1454)
{
{
obj_t marker_1447;
obj_t string_1448;
obj_t fname_1449;
obj_t line_1450;
obj_t char_1451;
marker_1447 = PROCEDURE_REF(env_1446, ((long)0));
string_1448 = PROCEDURE_REF(env_1446, ((long)1));
fname_1449 = PROCEDURE_REF(env_1446, ((long)2));
line_1450 = PROCEDURE_REF(env_1446, ((long)3));
char_1451 = PROCEDURE_REF(env_1446, ((long)4));
{
obj_t proc_563;
obj_t msg_564;
obj_t obj_565;
proc_563 = proc_1452;
msg_564 = msg_1453;
obj_565 = obj_1454;
_error_notifier__99___error = BFALSE;
FLUSH_OUTPUT_PORT(current_output_port);
{
obj_t list1121_569;
list1121_569 = MAKE_PAIR(current_error_port, BNIL);
newline___r4_output_6_10_3(list1121_569);
}
{
long old_length_68_571;
obj_t space_string_143_572;
old_length_68_571 = get_write_length_193___r4_output_6_10_3();
{
bool_t test_1713;
{
long aux_1714;
aux_1714 = (long)CINT(marker_1447);
test_1713 = (aux_1714>((long)0));
}
if(test_1713){
long arg1141_590;
{
long aux_1717;
aux_1717 = (long)CINT(marker_1447);
arg1141_590 = (aux_1717-((long)1));
}
{
obj_t list1142_591;
{
obj_t aux_1720;
aux_1720 = BCHAR(((unsigned char)' '));
list1142_591 = MAKE_PAIR(aux_1720, BNIL);
}
{
obj_t res1540_1106;
{
unsigned char aux_1727;
long aux_1723;
{
obj_t aux_1728;
aux_1728 = CAR(list1142_591);
aux_1727 = (unsigned char)CCHAR(aux_1728);
}
{
int aux_1724;
aux_1724 = (int)(arg1141_590);
aux_1723 = (long)(aux_1724);
}
res1540_1106 = make_string(aux_1723, aux_1727);
}
space_string_143_572 = res1540_1106;
}
}
}
 else {
space_string_143_572 = string1568___error;
}
}
fix_tabulation__127___error(marker_1447, string_1448, space_string_143_572);
print_cursor_204___error(fname_1449, line_1450, char_1451, string_1448, space_string_143_572);
set_write_length__244___r4_output_6_10_3(((long)80));
{
obj_t list1125_575;
{
obj_t arg1126_576;
arg1126_576 = MAKE_PAIR(proc_563, BNIL);
list1125_575 = MAKE_PAIR(string1569___error, arg1126_576);
}
fprint___r4_output_6_10_3(current_error_port, list1125_575);
}
{
obj_t list1131_581;
{
obj_t arg1132_582;
{
obj_t arg1133_583;
{
obj_t arg1134_584;
arg1134_584 = MAKE_PAIR(obj_565, BNIL);
arg1133_583 = MAKE_PAIR(string1555___error, arg1134_584);
}
arg1132_582 = MAKE_PAIR(msg_564, arg1133_583);
}
list1131_581 = MAKE_PAIR(string1570___error, arg1132_582);
}
fprint___r4_output_6_10_3(current_error_port, list1131_581);
}
{
bool_t test1136_586;
{
bool_t test1137_587;
{
obj_t obj_1107;
obj_1107 = _debug__29___error;
test1137_587 = INTEGERP(obj_1107);
}
if(test1137_587){
long n1_1108;
n1_1108 = (long)CINT(_debug__29___error);
test1136_586 = (n1_1108>((long)0));
}
 else {
test1136_586 = ((bool_t)0);
}
}
if(test1136_586){
obj_t depth_1110;
{
bool_t test1019_1111;
{
obj_t obj_1113;
obj_1113 = _trace_stack_depth__228___error;
test1019_1111 = INTEGERP(obj_1113);
}
if(test1019_1111){
depth_1110 = _trace_stack_depth__228___error;
}
 else {
depth_1110 = BINT(((long)10));
}
}
{
long aux_1751;
aux_1751 = (long)CINT(depth_1110);
dump_trace_stack(current_error_port, aux_1751);
}
}
 else {
BUNSPEC;
}
}
set_write_length__244___r4_output_6_10_3(old_length_68_571);
return FLUSH_OUTPUT_PORT(current_error_port);
}
}
}
}


/* warning/location-file */obj_t warning_location_file_177___error(obj_t file_name_128_48, obj_t location_49, obj_t args_50)
{
{
obj_t port_593;
port_593 = open_input_file_61___r4_ports_6_10_1(file_name_128_48, BNIL);
if(INPUT_PORTP(port_593)){
obj_t line_string_28_595;
long line_num_62_596;
{
obj_t arg1145_598;
{
obj_t list1147_600;
list1147_600 = MAKE_PAIR(port_593, BNIL);
arg1145_598 = read_line_110___r4_input_6_10_2(list1147_600);
}
line_string_28_595 = arg1145_598;
line_num_62_596 = ((long)1);
loop_597:
{
bool_t test1149_602;
test1149_602 = EOF_OBJECTP(line_string_28_595);
if(test1149_602){
close_input_port(port_593);
return warning___error(args_50);
}
 else {
bool_t test1151_604;
{
long arg1161_614;
{
long arg1162_615;
int arg1163_616;
arg1162_615 = STRING_LENGTH(line_string_28_595);
{
int res1541_1120;
{
long aux_1766;
aux_1766 = INPUT_PORT_FILEPOS(port_593);
res1541_1120 = (int)(aux_1766);
}
arg1163_616 = res1541_1120;
}
{
long aux_1769;
aux_1769 = (long)(arg1163_616);
arg1161_614 = (arg1162_615+aux_1769);
}
}
{
long aux_1772;
aux_1772 = (long)CINT(location_49);
test1151_604 = (arg1161_614>=aux_1772);
}
}
if(test1151_604){
close_input_port(port_593);
{
long arg1152_605;
{
long arg1153_606;
{
int arg1155_608;
{
int res1542_1127;
{
long aux_1777;
aux_1777 = INPUT_PORT_FILEPOS(port_593);
res1542_1127 = (int)(aux_1777);
}
arg1155_608 = res1542_1127;
}
{
long aux_1782;
long aux_1780;
aux_1782 = (long)(arg1155_608);
aux_1780 = (long)CINT(location_49);
arg1153_606 = (aux_1780-aux_1782);
}
}
arg1152_605 = (arg1153_606+((long)1));
}
return do_warn_location_146___error(file_name_128_48, line_num_62_596, location_49, line_string_28_595, arg1152_605, args_50);
}
}
 else {
int old_pos_44_609;
{
int res1543_1133;
{
long aux_1787;
aux_1787 = INPUT_PORT_FILEPOS(port_593);
res1543_1133 = (int)(aux_1787);
}
old_pos_44_609 = res1543_1133;
}
{
obj_t arg1156_610;
long arg1157_611;
{
obj_t list1158_612;
list1158_612 = MAKE_PAIR(port_593, BNIL);
arg1156_610 = read_line_110___r4_input_6_10_2(list1158_612);
}
arg1157_611 = (line_num_62_596+((long)1));
{
long line_num_62_1794;
obj_t line_string_28_1793;
line_string_28_1793 = arg1156_610;
line_num_62_1794 = arg1157_611;
line_num_62_596 = line_num_62_1794;
line_string_28_595 = line_string_28_1793;
goto loop_597;
}
}
}
}
}
}
}
 else {
return warning___error(args_50);
}
}
}


/* do-warn/location */obj_t do_warn_location_146___error(obj_t fname_51, long line_52, obj_t char_53, obj_t string_54, long marker_55, obj_t args_56)
{
FLUSH_OUTPUT_PORT(current_output_port);
{
obj_t list1168_621;
list1168_621 = MAKE_PAIR(current_error_port, BNIL);
newline___r4_output_6_10_3(list1168_621);
}
{
long old_length_68_623;
obj_t space_string_143_624;
old_length_68_623 = get_write_length_193___r4_output_6_10_3();
if((marker_55>((long)0))){
long arg1190_648;
arg1190_648 = (marker_55-((long)1));
{
obj_t list1191_649;
{
obj_t aux_1803;
aux_1803 = BCHAR(((unsigned char)' '));
list1191_649 = MAKE_PAIR(aux_1803, BNIL);
}
{
obj_t res1544_1147;
{
unsigned char aux_1810;
long aux_1806;
{
obj_t aux_1811;
aux_1811 = CAR(list1191_649);
aux_1810 = (unsigned char)CCHAR(aux_1811);
}
{
int aux_1807;
aux_1807 = (int)(arg1190_648);
aux_1806 = (long)(aux_1807);
}
res1544_1147 = make_string(aux_1806, aux_1810);
}
space_string_143_624 = res1544_1147;
}
}
}
 else {
space_string_143_624 = string1568___error;
}
fix_tabulation__127___error(BINT(marker_55), string_54, space_string_143_624);
print_cursor_204___error(fname_51, BINT(line_52), char_53, string_54, space_string_143_624);
{
obj_t list1172_627;
list1172_627 = MAKE_PAIR(current_error_port, BNIL);
display___r4_output_6_10_3(string1571___error, list1172_627);
}
if(NULLP(args_56)){
BUNSPEC;
}
 else {
{
obj_t list1177_632;
{
obj_t aux_1823;
aux_1823 = CAR(args_56);
list1177_632 = MAKE_PAIR(aux_1823, BNIL);
}
fprint___r4_output_6_10_3(current_error_port, list1177_632);
}
{
obj_t l1007_634;
{
bool_t aux_1827;
l1007_634 = CDR(args_56);
lname1008_635:
if(PAIRP(l1007_634)){
{
obj_t a_638;
a_638 = CAR(l1007_634);
{
obj_t list1182_640;
list1182_640 = MAKE_PAIR(current_error_port, BNIL);
display___r4_output_6_10_3(a_638, list1182_640);
}
}
{
obj_t l1007_1833;
l1007_1833 = CDR(l1007_634);
l1007_634 = l1007_1833;
goto lname1008_635;
}
}
 else {
aux_1827 = ((bool_t)1);
}
BBOOL(aux_1827);
}
}
}
{
obj_t list1186_644;
list1186_644 = MAKE_PAIR(current_error_port, BNIL);
newline___r4_output_6_10_3(list1186_644);
}
return FLUSH_OUTPUT_PORT(current_error_port);
}
}


/* fix-tabulation! */obj_t fix_tabulation__127___error(obj_t marker_57, obj_t src_58, obj_t dst_59)
{
{
long read_651;
{
long aux_1851;
aux_1851 = (long)CINT(marker_57);
read_651 = (aux_1851-((long)1));
}
loop_652:
if((read_651==((long)-1))){
return symbol1572___error;
}
 else {
bool_t test_1842;
{
unsigned char aux_1843;
aux_1843 = STRING_REF(src_58, read_651);
test_1842 = (aux_1843==((unsigned char)'\t'));
}
if(test_1842){
STRING_SET(dst_59, read_651, ((unsigned char)'\t'));
{
long read_1847;
read_1847 = (read_651-((long)1));
read_651 = read_1847;
goto loop_652;
}
}
 else {
{
long read_1849;
read_1849 = (read_651-((long)1));
read_651 = read_1849;
goto loop_652;
}
}
}
}
}


/* print-cursor */obj_t print_cursor_204___error(obj_t fname_60, obj_t line_61, obj_t char_62, obj_t string_63, obj_t space_string_143_64)
{
{
obj_t arg1202_661;
arg1202_661 = nice_fname_167___error(fname_60);
{
obj_t list1210_668;
{
obj_t arg1211_669;
{
obj_t arg1213_670;
{
obj_t arg1214_671;
{
obj_t arg1216_672;
{
obj_t arg1219_673;
{
obj_t arg1220_674;
{
obj_t arg1221_675;
{
obj_t arg1222_676;
{
obj_t arg1224_677;
{
obj_t arg1225_678;
{
obj_t arg1226_679;
{
obj_t arg1228_680;
{
obj_t arg1231_681;
arg1231_681 = MAKE_PAIR(string1573___error, BNIL);
arg1228_680 = MAKE_PAIR(space_string_143_64, arg1231_681);
}
arg1226_679 = MAKE_PAIR(string1574___error, arg1228_680);
}
{
obj_t aux_1858;
aux_1858 = BCHAR(((unsigned char)'\n'));
arg1225_678 = MAKE_PAIR(aux_1858, arg1226_679);
}
}
arg1224_677 = MAKE_PAIR(string_63, arg1225_678);
}
arg1222_676 = MAKE_PAIR(string1574___error, arg1224_677);
}
{
obj_t aux_1863;
aux_1863 = BCHAR(((unsigned char)'\n'));
arg1221_675 = MAKE_PAIR(aux_1863, arg1222_676);
}
}
arg1220_674 = MAKE_PAIR(string1556___error, arg1221_675);
}
arg1219_673 = MAKE_PAIR(char_62, arg1220_674);
}
arg1216_672 = MAKE_PAIR(string1575___error, arg1219_673);
}
arg1214_671 = MAKE_PAIR(line_61, arg1216_672);
}
arg1213_670 = MAKE_PAIR(string1576___error, arg1214_671);
}
arg1211_669 = MAKE_PAIR(arg1202_661, arg1213_670);
}
list1210_668 = MAKE_PAIR(string1577___error, arg1211_669);
}
return fprint___r4_output_6_10_3(current_error_port, list1210_668);
}
}
}


/* nice-fname */obj_t nice_fname_167___error(obj_t fname_65)
{
{
obj_t pwd_683;
obj_t dname_684;
{
obj_t vpwd_747;
{
bool_t test1536_1171;
test1536_1171 = (long)getenv("PWD");
if(test1536_1171){
char * aux_1876;
aux_1876 = (char *)getenv("PWD");
vpwd_747 = string_to_bstring(aux_1876);
}
 else {
vpwd_747 = BFALSE;
}
}
if(STRINGP(vpwd_747)){
pwd_683 = vpwd_747;
}
 else {
pwd_683 = pwd___os();
}
}
dname_684 = dirname___os(fname_65);
{
bool_t test1233_685;
if(STRINGP(pwd_683)){
bool_t test1287_744;
test1287_744 = bigloo_strcmp(dname_684, string1578___error);
if(test1287_744){
test1233_685 = ((bool_t)1);
}
 else {
bool_t test_1887;
{
unsigned char aux_1888;
aux_1888 = STRING_REF(fname_65, ((long)0));
test_1887 = (aux_1888==((unsigned char)'/'));
}
if(test_1887){
test1233_685 = ((bool_t)0);
}
 else {
test1233_685 = ((bool_t)1);
}
}
}
 else {
test1233_685 = ((bool_t)1);
}
if(test1233_685){
return fname_65;
}
 else {
obj_t original_cmp_path_197_686;
original_cmp_path_197_686 = path__list_117___error(dname_684);
{
obj_t cmp_path_47_687;
obj_t cur_path_204_688;
{
obj_t arg1234_690;
arg1234_690 = path__list_117___error(pwd_683);
cmp_path_47_687 = original_cmp_path_197_686;
cur_path_204_688 = arg1234_690;
loop_689:
if(NULLP(cmp_path_47_687)){
if(NULLP(cur_path_204_688)){
return basename___os(fname_65);
}
 else {
long arg1238_696;
obj_t arg1240_697;
arg1238_696 = list_length(cur_path_204_688);
arg1240_697 = basename___os(fname_65);
{
long len_1183;
obj_t res_1184;
len_1183 = arg1238_696;
res_1184 = arg1240_697;
loop_1182:
if((len_1183==((long)0))){
return res_1184;
}
 else {
long arg1243_1189;
obj_t arg1244_1190;
arg1243_1189 = (len_1183-((long)1));
arg1244_1190 = string_append(string1579___error, res_1184);
{
obj_t res_1906;
long len_1905;
len_1905 = arg1243_1189;
res_1906 = arg1244_1190;
res_1184 = res_1906;
len_1183 = len_1905;
goto loop_1182;
}
}
}
}
}
 else {
if(NULLP(cur_path_204_688)){
{
obj_t path_702;
obj_t res_703;
{
obj_t arg1247_705;
obj_t arg1248_706;
arg1247_705 = reverse__39___r4_pairs_and_lists_6_3(cmp_path_47_687);
arg1248_706 = basename___os(fname_65);
path_702 = arg1247_705;
res_703 = arg1248_706;
loop_704:
if(NULLP(path_702)){
return res_703;
}
 else {
obj_t arg1250_708;
obj_t arg1251_709;
arg1250_708 = CDR(path_702);
{
obj_t arg1252_710;
arg1252_710 = CAR(path_702);
{
obj_t list1254_712;
{
obj_t arg1255_713;
{
obj_t arg1256_714;
arg1256_714 = MAKE_PAIR(res_703, BNIL);
arg1255_713 = MAKE_PAIR(string1580___error, arg1256_714);
}
list1254_712 = MAKE_PAIR(arg1252_710, arg1255_713);
}
arg1251_709 = string_append_106___r4_strings_6_7(list1254_712);
}
}
{
obj_t res_1920;
obj_t path_1919;
path_1919 = arg1250_708;
res_1920 = arg1251_709;
res_703 = res_1920;
path_702 = path_1919;
goto loop_704;
}
}
}
}
}
 else {
bool_t test1258_716;
{
obj_t aux_1923;
obj_t aux_1921;
aux_1923 = CAR(cmp_path_47_687);
aux_1921 = CAR(cur_path_204_688);
test1258_716 = bigloo_strcmp(aux_1921, aux_1923);
}
if(test1258_716){
{
obj_t cur_path_204_1929;
obj_t cmp_path_47_1927;
cmp_path_47_1927 = CDR(cmp_path_47_687);
cur_path_204_1929 = CDR(cur_path_204_688);
cur_path_204_688 = cur_path_204_1929;
cmp_path_47_687 = cmp_path_47_1927;
goto loop_689;
}
}
 else {
{
obj_t path_719;
obj_t res_720;
{
obj_t arg1262_722;
obj_t arg1263_723;
arg1262_722 = reverse___r4_pairs_and_lists_6_3(cmp_path_47_687);
arg1263_723 = basename___os(fname_65);
path_719 = arg1262_722;
res_720 = arg1263_723;
loop_721:
if(NULLP(path_719)){
if((cmp_path_47_687==original_cmp_path_197_686)){
return string_append(string1580___error, res_720);
}
 else {
long len_1225;
obj_t res_1226;
len_1225 = list_length(cur_path_204_688);
res_1226 = res_720;
loop_1224:
if((len_1225==((long)0))){
return res_1226;
}
 else {
long arg1269_1231;
obj_t arg1270_1232;
arg1269_1231 = (len_1225-((long)1));
arg1270_1232 = string_append(string1579___error, res_1226);
{
obj_t res_1943;
long len_1942;
len_1942 = arg1269_1231;
res_1943 = arg1270_1232;
res_1226 = res_1943;
len_1225 = len_1942;
goto loop_1224;
}
}
}
}
 else {
obj_t arg1272_733;
obj_t arg1273_734;
arg1272_733 = CDR(path_719);
{
obj_t arg1274_735;
arg1274_735 = CAR(path_719);
{
obj_t list1278_737;
{
obj_t arg1281_738;
{
obj_t arg1282_739;
arg1282_739 = MAKE_PAIR(res_720, BNIL);
arg1281_738 = MAKE_PAIR(string1580___error, arg1282_739);
}
list1278_737 = MAKE_PAIR(arg1274_735, arg1281_738);
}
arg1273_734 = string_append_106___r4_strings_6_7(list1278_737);
}
}
{
obj_t res_1952;
obj_t path_1951;
path_1951 = arg1272_733;
res_1952 = arg1273_734;
res_720 = res_1952;
path_719 = path_1951;
goto loop_721;
}
}
}
}
}
}
}
}
}
}
}
}
}


/* path->list */obj_t path__list_117___error(obj_t path_66)
{
{
long len_749;
long init_750;
{
long len_767;
len_767 = STRING_LENGTH(path_66);
{
bool_t test_1954;
{
unsigned char aux_1955;
{
long aux_1956;
aux_1956 = (len_767-((long)1));
aux_1955 = STRING_REF(path_66, aux_1956);
}
test_1954 = (aux_1955==((unsigned char)'/'));
}
if(test_1954){
len_749 = (len_767-((long)1));
}
 else {
len_749 = len_767;
}
}
}
{
bool_t test_1961;
{
unsigned char aux_1962;
aux_1962 = STRING_REF(path_66, ((long)0));
test_1961 = (aux_1962==((unsigned char)'/'));
}
if(test_1961){
init_750 = ((long)1);
}
 else {
init_750 = ((long)0);
}
}
{
bool_t test1292_751;
test1292_751 = bigloo_strcmp(path_66, string1580___error);
if(test1292_751){
return BNIL;
}
 else {
long read_752;
long prev_753;
obj_t list_754;
read_752 = init_750;
prev_753 = init_750;
list_754 = BNIL;
loop_755:
if((read_752==len_749)){
{
obj_t arg1296_758;
{
obj_t arg1297_759;
arg1297_759 = c_substring(path_66, prev_753, read_752);
arg1296_758 = MAKE_PAIR(arg1297_759, list_754);
}
return reverse__39___r4_pairs_and_lists_6_3(arg1296_758);
}
}
 else {
bool_t test_1972;
{
unsigned char aux_1973;
aux_1973 = STRING_REF(path_66, read_752);
test_1972 = (aux_1973==((unsigned char)'/'));
}
if(test_1972){
{
long arg1299_761;
long arg1300_762;
obj_t arg1301_763;
arg1299_761 = (read_752+((long)1));
arg1300_762 = (read_752+((long)1));
{
obj_t arg1302_764;
arg1302_764 = c_substring(path_66, prev_753, read_752);
arg1301_763 = MAKE_PAIR(arg1302_764, list_754);
}
{
obj_t list_1982;
long prev_1981;
long read_1980;
read_1980 = arg1299_761;
prev_1981 = arg1300_762;
list_1982 = arg1301_763;
list_754 = list_1982;
prev_753 = prev_1981;
read_752 = read_1980;
goto loop_755;
}
}
}
 else {
{
long read_1983;
read_1983 = (read_752+((long)1));
read_752 = read_1983;
goto loop_755;
}
}
}
}
}
}
}


/* find-runtime-type */obj_t find_runtime_type_96___error(obj_t obj_67)
{
if(INTEGERP(obj_67)){
return string1581___error;
}
 else {
if(REALP(obj_67)){
return string1582___error;
}
 else {
if(STRINGP(obj_67)){
return string1583___error;
}
 else {
if(SYMBOLP(obj_67)){
return string1584___error;
}
 else {
if(KEYWORDP(obj_67)){
return string1585___error;
}
 else {
if(CHARP(obj_67)){
return string1586___error;
}
 else {
if(BOOLEANP(obj_67)){
return string1587___error;
}
 else {
if(NULLP(obj_67)){
return string1588___error;
}
 else {
if(PAIRP(obj_67)){
return string1589___error;
}
 else {
if(VECTORP(obj_67)){
return string1590___error;
}
 else {
if(TVECTORP(obj_67)){
return string1591___error;
}
 else {
if(STRUCTP(obj_67)){
return string1592___error;
}
 else {
if(PROCEDUREP(obj_67)){
return string1593___error;
}
 else {
if(INPUT_PORTP(obj_67)){
return string1594___error;
}
 else {
if(OUTPUT_PORTP(obj_67)){
return string1595___error;
}
 else {
if(BINARY_PORTP(obj_67)){
return string1596___error;
}
 else {
if(CELLP(obj_67)){
return string1597___error;
}
 else {
if(FOREIGNP(obj_67)){
return string1598___error;
}
 else {
if(CNSTP(obj_67)){
return string1599___error;
}
 else {
bool_t test1330_792;
test1330_792 = (POINTERP( obj_67 ) && (TYPE( obj_67 ) >= OBJECT_TYPE));
if(test1330_792){
{
obj_t class_793;
{
object_t object_1311;
object_1311 = (object_t)(obj_67);
{
long arg1526_1312;
{
long arg1527_1313;
long arg1528_1314;
arg1527_1313 = TYPE( object_1311 );
arg1528_1314 = OBJECT_TYPE;
arg1526_1312 = (arg1527_1313-arg1528_1314);
}
{
obj_t vector_1318;
vector_1318 = _classes__134___object;
class_793 = VECTOR_REF(vector_1318, arg1526_1312);
}
}
}
{
bool_t test_2030;
if(VECTORP(class_793)){
long aux_2033;
aux_2033 = VECTOR_LENGTH(class_793);
test_2030 = (aux_2033==((long)10));
}
 else {
test_2030 = ((bool_t)0);
}
if(test_2030){
obj_t aux_2036;
aux_2036 = class_name_139___object(class_793);
return SYMBOL_TO_STRING(aux_2036);
}
 else {
return string1600___error;
}
}
}
}
 else {
return string1600___error;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}


/* _find-runtime-type */obj_t _find_runtime_type_101___error(obj_t env_1455, obj_t obj_1456)
{
return find_runtime_type_96___error(obj_1456);
}


/* module-init-error */obj_t module_init_error_170___error(char * current_68, char * from_69)
{
{
obj_t list1333_1331;
{
obj_t arg1334_1332;
{
obj_t arg1339_1334;
{
obj_t aux_2040;
aux_2040 = string_to_bstring(from_69);
arg1339_1334 = MAKE_PAIR(aux_2040, BNIL);
}
arg1334_1332 = MAKE_PAIR(string1601___error, arg1339_1334);
}
{
obj_t aux_2044;
aux_2044 = string_to_bstring(current_68);
list1333_1331 = MAKE_PAIR(aux_2044, arg1334_1332);
}
}
return warning___error(list1333_1331);
}
}


/* _module-init-error */obj_t _module_init_error_73___error(obj_t env_1457, obj_t current_1458, obj_t from_1459)
{
return module_init_error_170___error(BSTRING_TO_STRING(current_1458), BSTRING_TO_STRING(from_1459));
}


/* bigloo-type-error */obj_t bigloo_type_error_241___error(obj_t proc_70, obj_t type_71, obj_t obj_72)
{
{
obj_t arg1342_1336;
{
obj_t arg1344_1338;
arg1344_1338 = find_runtime_type_96___error(obj_72);
arg1342_1336 = bigloo_type_error_msg_127___error(string1602___error, type_71, arg1344_1338);
}
FAILURE(proc_70,arg1342_1336,obj_72);}
}


/* _bigloo-type-error */obj_t _bigloo_type_error_184___error(obj_t env_1460, obj_t proc_1461, obj_t type_1462, obj_t obj_1463)
{
return bigloo_type_error_241___error(proc_1461, type_1462, obj_1463);
}


/* bigloo-type-error/location */obj_t bigloo_type_error_location_103___error(obj_t proc_73, obj_t type_74, obj_t obj_75, obj_t fname_76, obj_t location_77)
{
{
obj_t arg1345_1342;
{
obj_t arg1349_1344;
arg1349_1344 = find_runtime_type_96___error(obj_75);
arg1345_1342 = bigloo_type_error_msg_127___error(string1602___error, type_74, arg1349_1344);
}
return error_location_112___error(proc_73, arg1345_1342, obj_75, fname_76, location_77);
}
}


/* _bigloo-type-error/location */obj_t _bigloo_type_error_location_69___error(obj_t env_1464, obj_t proc_1465, obj_t type_1466, obj_t obj_1467, obj_t fname_1468, obj_t location_1469)
{
return bigloo_type_error_location_103___error(proc_1465, type_1466, obj_1467, fname_1468, location_1469);
}


/* method-init */obj_t method_init_76___error()
{
return BUNSPEC;
}


/* imported-modules-init */obj_t imported_modules_init_94___error()
{
return module_initialization_70___r4_input_6_10_2(((long)0), "__ERROR");
}

