/*===========================================================================*/
/*   (Ieee/string.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*    --------------------------------------------------------------------   */
/*      A pratical implementation for the Scheme programming language        */
/*                                                                           */
/*                                       ,--^,                               */
/*                                 _ ___/ /|/                                */
/*                             ,;'( )__, ) '                                 */
/*                            ;;  //   L__.                                  */
/*                            '   \   /  '                                   */
/*                                 ^   ^                                     */
/*                                                                           */
/*      Copyright (c) 1992-1999 Manuel Serrano                               */
/*                                                                           */
/*        Bug descriptions, use reports, comments or suggestions are         */
/*        welcome. Send them to                                              */
/*          bigloo-request@kaolin.unice.fr                                   */
/*          http://kaolin.unice.fr/bigloo                                    */
/*                                                                           */
/*      This program is free software; you can redistribute it               */
/*      and/or modify it under the terms of the GNU General Public           */
/*      License as published by the Free Software Foundation; either         */
/*      version 2 of the License, or (at your option) any later version.     */
/*                                                                           */
/*      This program is distributed in the hope that it will be useful,      */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/*      GNU General Public License for more details.                         */
/*                                                                           */
/*      You should have received a copy of the GNU General Public            */
/*      License along with this program; if not, write to the Free           */
/*      Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      */
/*      MA 02111-1307, USA.                                                  */
/*   --------------------------------------------------------------------    */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

/* debug mode */
#define BIGLOO_DEBUG 1

#include <bigloo2.0a.h>
#include <signal.h>

extern bool_t bigloo_strncmp_ci(obj_t, obj_t, long);
extern bool_t bigloo_strcmp(obj_t, obj_t);
static obj_t _blit_string_1308_192___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t string_to_symbol(char *);
extern bool_t string__76___r4_strings_6_7(obj_t);
extern bool_t substring___218___r4_strings_6_7(obj_t, obj_t, long);
extern obj_t string_set__176___r4_strings_6_7(obj_t, long, unsigned char);
extern obj_t string_append(obj_t, obj_t);
extern bool_t bigloo_strncmp(obj_t, obj_t, long);
extern bool_t string____135___r4_strings_6_7(obj_t, obj_t);
extern obj_t blit_string_ur__74___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t _string___1289_193___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_capitalize_1304_183___r4_strings_6_7(obj_t, obj_t);
static obj_t _string___1290_211___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t substring_ur_202___r4_strings_6_7(obj_t, long, long);
static obj_t _string_downcase_1303_160___r4_strings_6_7(obj_t, obj_t);
extern bool_t string____33___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_fill__51___r4_strings_6_7(obj_t, unsigned char);
extern obj_t list__string_78___r4_strings_6_7(obj_t);
static obj_t _string_upcase1300_68___r4_strings_6_7(obj_t, obj_t);
static obj_t _substring_ur1296_110___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
static obj_t _substring1295___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
static obj_t _string_for_read1306_207___r4_strings_6_7(obj_t, obj_t);
extern obj_t string___r4_strings_6_7(obj_t);
static obj_t _string_ci__1291_191___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_copy_207___r4_strings_6_7(obj_t);
extern obj_t bigloo_type_error_location_103___error(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t _string__1287_201___r4_strings_6_7(obj_t, obj_t, obj_t);
extern unsigned char string_ref_ur_85___r4_strings_6_7(obj_t, long);
static obj_t loop___r4_strings_6_7(obj_t);
static obj_t _string_copy1298_57___r4_strings_6_7(obj_t, obj_t);
extern obj_t make_string_124___r4_strings_6_7(int, obj_t);
extern bool_t string_cilt(obj_t, obj_t);
extern obj_t string_for_read_25___r4_strings_6_7(obj_t);
extern bool_t string_cile(obj_t, obj_t);
extern obj_t string_to_bstring(char *);
static obj_t _string_capitalize1305_146___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_cigt(obj_t, obj_t);
extern bool_t string_ci____43___r4_strings_6_7(obj_t, obj_t);
static obj_t _string_upcase_1302_80___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_cige(obj_t, obj_t);
static obj_t _string_set_1280_177___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
extern bool_t substring_ci___99___r4_strings_6_7(obj_t, obj_t, long);
static obj_t _string_ci__1286_73___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_ci___1293_227___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_set_ur__94___r4_strings_6_7(obj_t, long, unsigned char);
extern obj_t debug_error_location_199___error(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t string_capitalize__136___r4_strings_6_7(obj_t);
static obj_t _string_ref1279_174___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_ci___1294_117___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _string_fill_1299_168___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t make_string(long, unsigned char);
static obj_t _string___r4_strings_6_7(obj_t, obj_t);
static obj_t _substring__1284_146___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
static obj_t _string_length1278_26___r4_strings_6_7(obj_t, obj_t);
extern long string_length_125___r4_strings_6_7(obj_t);
extern obj_t module_initialization_70___r4_strings_6_7(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t c_substring(obj_t, long, long);
extern bool_t string_ci____210___r4_strings_6_7(obj_t, obj_t);
extern bool_t string___248___r4_strings_6_7(obj_t, obj_t);
extern bool_t string___146___r4_strings_6_7(obj_t, obj_t);
extern bool_t string___83___r4_strings_6_7(obj_t, obj_t);
static obj_t _string__1283_116___r4_strings_6_7(obj_t, obj_t, obj_t);
extern obj_t string_capitalize_230___r4_strings_6_7(obj_t);
static obj_t _string_set_ur_1282_29___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
static obj_t _make_string1277_163___r4_strings_6_7(obj_t, obj_t, obj_t);
extern bool_t strcicmp(obj_t, obj_t);
extern obj_t substring___r4_strings_6_7(obj_t, long, long);
static obj_t _string_ci__1292_186___r4_strings_6_7(obj_t, obj_t, obj_t);
extern long list_length(obj_t);
extern bool_t string_ci___60___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_ci___247___r4_strings_6_7(obj_t, obj_t);
extern bool_t string_ci___92___r4_strings_6_7(obj_t, obj_t);
static obj_t _string__list1297_184___r4_strings_6_7(obj_t, obj_t);
static obj_t _string__1288_196___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t _substring_ci__1285_242___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t);
static obj_t symbol1999___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1998___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1997___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1996___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1995___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1994___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1993___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1992___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1991___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1989___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1990___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1988___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1987___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1986___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1985___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1984___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1983___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1981___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1979___r4_strings_6_7 = BUNSPEC;
extern bool_t string_lt(obj_t, obj_t);
static obj_t symbol1975___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1973___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1972___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1971___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1969___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1965___r4_strings_6_7 = BUNSPEC;
static obj_t symbol1964___r4_strings_6_7 = BUNSPEC;
extern bool_t string_le(obj_t, obj_t);
static obj_t _string__159___r4_strings_6_7(obj_t, obj_t);
static obj_t symbol2049___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2048___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2045___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2043___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2042___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2041___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2039___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2040___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2038___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2037___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2036___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2035___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2034___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2033___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2032___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2031___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2029___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2030___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2028___r4_strings_6_7 = BUNSPEC;
extern bool_t string_gt(obj_t, obj_t);
static obj_t symbol2027___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2026___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2025___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2024___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2023___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2022___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2021___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2020___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2018___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2017___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2016___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2015___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2012___r4_strings_6_7 = BUNSPEC;
extern bool_t string_ge(obj_t, obj_t);
static obj_t symbol2011___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2009___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2010___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2008___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2007___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2006___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2005___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2004___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2003___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2002___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2001___r4_strings_6_7 = BUNSPEC;
static obj_t symbol2000___r4_strings_6_7 = BUNSPEC;
extern obj_t string_upcase__158___r4_strings_6_7(obj_t);
static obj_t _list__string_5___r4_strings_6_7(obj_t, obj_t);
static obj_t imported_modules_init_94___r4_strings_6_7();
extern obj_t string_append_106___r4_strings_6_7(obj_t);
extern obj_t string_downcase_77___r4_strings_6_7(obj_t);
static obj_t require_initialization_114___r4_strings_6_7 = BUNSPEC;
extern obj_t string__list_125___r4_strings_6_7(obj_t);
extern obj_t string_downcase__42___r4_strings_6_7(obj_t);
static obj_t _string_downcase1301_196___r4_strings_6_7(obj_t, obj_t);
static obj_t _string_append_156___r4_strings_6_7(obj_t, obj_t);
extern obj_t string_for_read(obj_t);
static obj_t _blit_string_ur_1307_184___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern unsigned char string_ref_239___r4_strings_6_7(obj_t, long);
extern obj_t blit_string__141___r4_strings_6_7(obj_t, obj_t, obj_t, obj_t, obj_t);
static obj_t cnst_init_137___r4_strings_6_7();
extern obj_t blit_string(obj_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t string_upcase_71___r4_strings_6_7(obj_t);
static obj_t _string_ref_ur1281_204___r4_strings_6_7(obj_t, obj_t, obj_t);
static obj_t *__cnst;

DEFINE_EXPORT_PROCEDURE( string_downcase_env_169___r4_strings_6_7, _string_downcase1301_196___r4_strings_6_72051, _string_downcase1301_196___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_upcase__env_48___r4_strings_6_7, _string_upcase_1302_80___r4_strings_6_72052, _string_upcase_1302_80___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( blit_string_ur__env_52___r4_strings_6_7, _blit_string_ur_1307_184___r4_strings_6_72053, _blit_string_ur_1307_184___r4_strings_6_7, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( substring_ur_env_69___r4_strings_6_7, _substring_ur1296_110___r4_strings_6_72054, _substring_ur1296_110___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_set_ur__env_0___r4_strings_6_7, _string_set_ur_1282_29___r4_strings_6_72055, _string_set_ur_1282_29___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_length_env_217___r4_strings_6_7, _string_length1278_26___r4_strings_6_72056, _string_length1278_26___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( substring_ci___env_184___r4_strings_6_7, _substring_ci__1285_242___r4_strings_6_72057, _substring_ci__1285_242___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_ci____env_38___r4_strings_6_7, _string_ci___1293_227___r4_strings_6_72058, _string_ci___1293_227___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci____env_37___r4_strings_6_7, _string_ci___1294_117___r4_strings_6_72059, _string_ci___1294_117___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_fill__env_181___r4_strings_6_7, _string_fill_1299_168___r4_strings_6_72060, _string_fill_1299_168___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_downcase__env_73___r4_strings_6_7, _string_downcase_1303_160___r4_strings_6_72061, _string_downcase_1303_160___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_for_read_env_47___r4_strings_6_7, _string_for_read1306_207___r4_strings_6_72062, _string_for_read1306_207___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_env_246___r4_strings_6_7, _string___r4_strings_6_72063, va_generic_entry, _string___r4_strings_6_7, -1 );
DEFINE_EXPORT_PROCEDURE( string___env_245___r4_strings_6_7, _string__1287_201___r4_strings_6_72064, _string__1287_201___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( list__string_env_249___r4_strings_6_7, _list__string_5___r4_strings_6_72065, _list__string_5___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_env_251___r4_strings_6_7, _string_ref1279_174___r4_strings_6_72066, _string_ref1279_174___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_29___r4_strings_6_7, _string_ci__1291_191___r4_strings_6_72067, _string_ci__1291_191___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__list_env_217___r4_strings_6_7, _string__list1297_184___r4_strings_6_72068, _string__list1297_184___r4_strings_6_7, 0L, 1 );
DEFINE_STRING( string1982___r4_strings_6_7, string1982___r4_strings_6_72069, "string-set!", 11 );
DEFINE_STRING( string1980___r4_strings_6_7, string1980___r4_strings_6_72070, "LONG", 4 );
DEFINE_STRING( string1978___r4_strings_6_7, string1978___r4_strings_6_72071, "/home/tahoe/serrano/trashcan/bigloo/runtime/Llib/error.scm", 58 );
DEFINE_STRING( string1977___r4_strings_6_7, string1977___r4_strings_6_72072, "index out of range", 18 );
DEFINE_STRING( string1976___r4_strings_6_7, string1976___r4_strings_6_72073, "string-ref", 10 );
DEFINE_STRING( string1974___r4_strings_6_7, string1974___r4_strings_6_72074, "BSTRING", 7 );
DEFINE_STRING( string1970___r4_strings_6_7, string1970___r4_strings_6_72075, "INT", 3 );
DEFINE_STRING( string1968___r4_strings_6_7, string1968___r4_strings_6_72076, "UCHAR", 5 );
DEFINE_STRING( string1967___r4_strings_6_7, string1967___r4_strings_6_72077, "/home/tahoe/serrano/trashcan/bigloo/runtime/Ieee/string.scm", 59 );
DEFINE_STRING( string1966___r4_strings_6_7, string1966___r4_strings_6_72078, "PAIR", 4 );
DEFINE_EXPORT_PROCEDURE( string_copy_env_8___r4_strings_6_7, _string_copy1298_57___r4_strings_6_72079, _string_copy1298_57___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string___env_211___r4_strings_6_7, _string__1283_116___r4_strings_6_72080, _string__1283_116___r4_strings_6_7, 0L, 2 );
DEFINE_STRING( string2047___r4_strings_6_7, string2047___r4_strings_6_72081, "Index and length out of range", 29 );
DEFINE_STRING( string2046___r4_strings_6_7, string2046___r4_strings_6_72082, "blit-string!", 12 );
DEFINE_STRING( string2044___r4_strings_6_7, string2044___r4_strings_6_72083, "BINT", 4 );
DEFINE_STRING( string2019___r4_strings_6_7, string2019___r4_strings_6_72084, "", 0 );
DEFINE_STRING( string2014___r4_strings_6_7, string2014___r4_strings_6_72085, "Illegal index", 13 );
DEFINE_STRING( string2013___r4_strings_6_7, string2013___r4_strings_6_72086, "substring", 9 );
DEFINE_EXPORT_PROCEDURE( string_set__env_239___r4_strings_6_7, _string_set_1280_177___r4_strings_6_72087, _string_set_1280_177___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_ref_ur_env_171___r4_strings_6_7, _string_ref_ur1281_204___r4_strings_6_72088, _string_ref_ur1281_204___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_62___r4_strings_6_7, _string_ci__1286_73___r4_strings_6_72089, _string_ci__1286_73___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( substring___env_12___r4_strings_6_7, _substring__1284_146___r4_strings_6_72090, _substring__1284_146___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string____env_63___r4_strings_6_7, _string___1289_193___r4_strings_6_72091, _string___1289_193___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string____env_18___r4_strings_6_7, _string___1290_211___r4_strings_6_72092, _string___1290_211___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string___env_124___r4_strings_6_7, _string__1288_196___r4_strings_6_72093, _string__1288_196___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( make_string_env_55___r4_strings_6_7, _make_string1277_163___r4_strings_6_72094, va_generic_entry, _make_string1277_163___r4_strings_6_7, -2 );
DEFINE_EXPORT_PROCEDURE( string_capitalize__env_137___r4_strings_6_7, _string_capitalize_1304_183___r4_strings_6_72095, _string_capitalize_1304_183___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env_46___r4_strings_6_7, _string_ci__1292_186___r4_strings_6_72096, _string_ci__1292_186___r4_strings_6_7, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_capitalize_env_253___r4_strings_6_7, _string_capitalize1305_146___r4_strings_6_72097, _string_capitalize1305_146___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( substring_env_248___r4_strings_6_7, _substring1295___r4_strings_6_72098, _substring1295___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( blit_string__env_232___r4_strings_6_7, _blit_string_1308_192___r4_strings_6_72099, _blit_string_1308_192___r4_strings_6_7, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( string_append_env_17___r4_strings_6_7, _string_append_156___r4_strings_6_72100, va_generic_entry, _string_append_156___r4_strings_6_7, -1 );
DEFINE_EXPORT_PROCEDURE( string_upcase_env_136___r4_strings_6_7, _string_upcase1300_68___r4_strings_6_72101, _string_upcase1300_68___r4_strings_6_7, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string__env_22___r4_strings_6_7, _string__159___r4_strings_6_72102, _string__159___r4_strings_6_7, 0L, 1 );


/* module-initialization */obj_t module_initialization_70___r4_strings_6_7(long checksum_1614, char * from_1615)
{
if(CBOOL(require_initialization_114___r4_strings_6_7)){
require_initialization_114___r4_strings_6_7 = BBOOL(((bool_t)0));
cnst_init_137___r4_strings_6_7();
imported_modules_init_94___r4_strings_6_7();
return BUNSPEC;
}
 else {
return BUNSPEC;
}
}


/* cnst-init */obj_t cnst_init_137___r4_strings_6_7()
{
symbol1964___r4_strings_6_7 = string_to_symbol("STRING?");
symbol1965___r4_strings_6_7 = string_to_symbol("MAKE-STRING");
symbol1969___r4_strings_6_7 = string_to_symbol("_MAKE-STRING1277");
symbol1971___r4_strings_6_7 = string_to_symbol("STRING");
symbol1972___r4_strings_6_7 = string_to_symbol("STRING-LENGTH");
symbol1973___r4_strings_6_7 = string_to_symbol("_STRING-LENGTH1278");
symbol1975___r4_strings_6_7 = string_to_symbol("STRING-REF");
symbol1979___r4_strings_6_7 = string_to_symbol("_STRING-REF1279");
symbol1981___r4_strings_6_7 = string_to_symbol("STRING-SET!");
symbol1983___r4_strings_6_7 = string_to_symbol("_STRING-SET!1280");
symbol1984___r4_strings_6_7 = string_to_symbol("STRING-REF-UR");
symbol1985___r4_strings_6_7 = string_to_symbol("_STRING-REF-UR1281");
symbol1986___r4_strings_6_7 = string_to_symbol("STRING-SET-UR!");
symbol1987___r4_strings_6_7 = string_to_symbol("_STRING-SET-UR!1282");
symbol1988___r4_strings_6_7 = string_to_symbol("STRING=?");
symbol1989___r4_strings_6_7 = string_to_symbol("_STRING=?1283");
symbol1990___r4_strings_6_7 = string_to_symbol("SUBSTRING=?");
symbol1991___r4_strings_6_7 = string_to_symbol("_SUBSTRING=?1284");
symbol1992___r4_strings_6_7 = string_to_symbol("SUBSTRING-CI=?");
symbol1993___r4_strings_6_7 = string_to_symbol("_SUBSTRING-CI=?1285");
symbol1994___r4_strings_6_7 = string_to_symbol("STRING-CI=?");
symbol1995___r4_strings_6_7 = string_to_symbol("_STRING-CI=?1286");
symbol1996___r4_strings_6_7 = string_to_symbol("STRING<?");
symbol1997___r4_strings_6_7 = string_to_symbol("_STRING<?1287");
symbol1998___r4_strings_6_7 = string_to_symbol("STRING>?");
symbol1999___r4_strings_6_7 = string_to_symbol("_STRING>?1288");
symbol2000___r4_strings_6_7 = string_to_symbol("STRING<=?");
symbol2001___r4_strings_6_7 = string_to_symbol("_STRING<=?1289");
symbol2002___r4_strings_6_7 = string_to_symbol("STRING>=?");
symbol2003___r4_strings_6_7 = string_to_symbol("_STRING>=?1290");
symbol2004___r4_strings_6_7 = string_to_symbol("STRING-CI<?");
symbol2005___r4_strings_6_7 = string_to_symbol("_STRING-CI<?1291");
symbol2006___r4_strings_6_7 = string_to_symbol("STRING-CI>?");
symbol2007___r4_strings_6_7 = string_to_symbol("_STRING-CI>?1292");
symbol2008___r4_strings_6_7 = string_to_symbol("STRING-CI<=?");
symbol2009___r4_strings_6_7 = string_to_symbol("_STRING-CI<=?1293");
symbol2010___r4_strings_6_7 = string_to_symbol("STRING-CI>=?");
symbol2011___r4_strings_6_7 = string_to_symbol("_STRING-CI>=?1294");
symbol2012___r4_strings_6_7 = string_to_symbol("SUBSTRING");
symbol2015___r4_strings_6_7 = string_to_symbol("_SUBSTRING1295");
symbol2016___r4_strings_6_7 = string_to_symbol("SUBSTRING-UR");
symbol2017___r4_strings_6_7 = string_to_symbol("_SUBSTRING-UR1296");
symbol2018___r4_strings_6_7 = string_to_symbol("STRING-APPEND");
symbol2020___r4_strings_6_7 = string_to_symbol("LOOP");
symbol2021___r4_strings_6_7 = string_to_symbol("LIST->STRING");
symbol2022___r4_strings_6_7 = string_to_symbol("STRING->LIST");
symbol2023___r4_strings_6_7 = string_to_symbol("_STRING->LIST1297");
symbol2024___r4_strings_6_7 = string_to_symbol("STRING-COPY");
symbol2025___r4_strings_6_7 = string_to_symbol("_STRING-COPY1298");
symbol2026___r4_strings_6_7 = string_to_symbol("STRING-FILL!");
symbol2027___r4_strings_6_7 = string_to_symbol("_STRING-FILL!1299");
symbol2028___r4_strings_6_7 = string_to_symbol("STRING-UPCASE");
symbol2029___r4_strings_6_7 = string_to_symbol("_STRING-UPCASE1300");
symbol2030___r4_strings_6_7 = string_to_symbol("STRING-DOWNCASE");
symbol2031___r4_strings_6_7 = string_to_symbol("_STRING-DOWNCASE1301");
symbol2032___r4_strings_6_7 = string_to_symbol("STRING-UPCASE!");
symbol2033___r4_strings_6_7 = string_to_symbol("_STRING-UPCASE!1302");
symbol2034___r4_strings_6_7 = string_to_symbol("STRING-DOWNCASE!");
symbol2035___r4_strings_6_7 = string_to_symbol("_STRING-DOWNCASE!1303");
symbol2036___r4_strings_6_7 = string_to_symbol("STRING-CAPITALIZE!");
symbol2037___r4_strings_6_7 = string_to_symbol("_STRING-CAPITALIZE!1304");
symbol2038___r4_strings_6_7 = string_to_symbol("STRING-CAPITALIZE");
symbol2039___r4_strings_6_7 = string_to_symbol("_STRING-CAPITALIZE1305");
symbol2040___r4_strings_6_7 = string_to_symbol("STRING-FOR-READ");
symbol2041___r4_strings_6_7 = string_to_symbol("_STRING-FOR-READ1306");
symbol2042___r4_strings_6_7 = string_to_symbol("BLIT-STRING-UR!");
symbol2043___r4_strings_6_7 = string_to_symbol("_BLIT-STRING-UR!1307");
symbol2045___r4_strings_6_7 = string_to_symbol("BLIT-STRING!");
symbol2048___r4_strings_6_7 = string_to_symbol("_BLIT-STRING!1308");
return (symbol2049___r4_strings_6_7 = string_to_symbol("IMPORTED-MODULES-INIT"),
BUNSPEC);
}


/* string? */bool_t string__76___r4_strings_6_7(obj_t obj_1)
{
{
obj_t symbol1204_1450;
symbol1204_1450 = symbol1964___r4_strings_6_7;
{
PUSH_TRACE(symbol1204_1450);
BUNSPEC;
{
bool_t aux1203_1451;
aux1203_1451 = STRINGP(obj_1);
POP_TRACE();
return aux1203_1451;
}
}
}
}


/* _string? */obj_t _string__159___r4_strings_6_7(obj_t env_798, obj_t obj_799)
{
{
bool_t aux_1694;
{
obj_t obj_1452;
obj_1452 = obj_799;
{
obj_t symbol1204_1453;
symbol1204_1453 = symbol1964___r4_strings_6_7;
{
PUSH_TRACE(symbol1204_1453);
BUNSPEC;
{
bool_t aux1203_1454;
aux1203_1454 = STRINGP(obj_1452);
POP_TRACE();
aux_1694 = aux1203_1454;
}
}
}
}
return BBOOL(aux_1694);
}
}


/* make-string */obj_t make_string_124___r4_strings_6_7(int k_2, obj_t char_3)
{
{
obj_t symbol1206_1455;
symbol1206_1455 = symbol1965___r4_strings_6_7;
{
PUSH_TRACE(symbol1206_1455);
BUNSPEC;
{
obj_t aux1205_1456;
if(NULLP(char_3)){
long aux_1702;
aux_1702 = (long)(k_2);
aux1205_1456 = make_string(aux_1702, ((unsigned char)' '));
}
 else {
obj_t arg1007_1457;
{
obj_t pair_1458;
if(PAIRP(char_3)){
pair_1458 = char_3;
}
 else {
bigloo_type_error_location_103___error(symbol1965___r4_strings_6_7, string1966___r4_strings_6_7, char_3, string1967___r4_strings_6_7, BINT(((long)7278)));
exit( -1 );}
arg1007_1457 = CAR(pair_1458);
}
{
unsigned char aux_1713;
long aux_1711;
{
obj_t aux_1714;
if(CHARP(arg1007_1457)){
aux_1714 = arg1007_1457;
}
 else {
bigloo_type_error_location_103___error(symbol1965___r4_strings_6_7, string1968___r4_strings_6_7, arg1007_1457, string1967___r4_strings_6_7, BINT(((long)7260)));
exit( -1 );}
aux_1713 = (unsigned char)CCHAR(aux_1714);
}
aux_1711 = (long)(k_2);
aux1205_1456 = make_string(aux_1711, aux_1713);
}
}
POP_TRACE();
return aux1205_1456;
}
}
}
}


/* _make-string1277 */obj_t _make_string1277_163___r4_strings_6_7(obj_t env_800, obj_t k_801, obj_t char_802)
{
{
int k_1459;
obj_t char_166_1460;
{
obj_t aux_1723;
if(INTEGERP(k_801)){
aux_1723 = k_801;
}
 else {
bigloo_type_error_location_103___error(symbol1969___r4_strings_6_7, string1970___r4_strings_6_7, k_801, string1967___r4_strings_6_7, BINT(((long)7161)));
exit( -1 );}
k_1459 = CINT(aux_1723);
}
char_166_1460 = char_802;
{
obj_t symbol1206_1461;
symbol1206_1461 = symbol1965___r4_strings_6_7;
{
PUSH_TRACE(symbol1206_1461);
BUNSPEC;
{
obj_t aux1205_1462;
if(NULLP(char_166_1460)){
long aux_1733;
aux_1733 = (long)(k_1459);
aux1205_1462 = make_string(aux_1733, ((unsigned char)' '));
}
 else {
obj_t arg1007_1463;
{
obj_t pair_1464;
if(PAIRP(char_166_1460)){
pair_1464 = char_166_1460;
}
 else {
bigloo_type_error_location_103___error(symbol1965___r4_strings_6_7, string1966___r4_strings_6_7, char_166_1460, string1967___r4_strings_6_7, BINT(((long)7278)));
exit( -1 );}
arg1007_1463 = CAR(pair_1464);
}
{
unsigned char aux_1744;
long aux_1742;
{
obj_t aux_1745;
if(CHARP(arg1007_1463)){
aux_1745 = arg1007_1463;
}
 else {
bigloo_type_error_location_103___error(symbol1965___r4_strings_6_7, string1968___r4_strings_6_7, arg1007_1463, string1967___r4_strings_6_7, BINT(((long)7260)));
exit( -1 );}
aux_1744 = (unsigned char)CCHAR(aux_1745);
}
aux_1742 = (long)(k_1459);
aux1205_1462 = make_string(aux_1742, aux_1744);
}
}
POP_TRACE();
return aux1205_1462;
}
}
}
}
}


/* string */obj_t string___r4_strings_6_7(obj_t chars_4)
{
{
obj_t symbol1208_1465;
symbol1208_1465 = symbol1971___r4_strings_6_7;
{
PUSH_TRACE(symbol1208_1465);
BUNSPEC;
{
obj_t aux1207_1466;
aux1207_1466 = list__string_78___r4_strings_6_7(chars_4);
POP_TRACE();
return aux1207_1466;
}
}
}
}


/* _string */obj_t _string___r4_strings_6_7(obj_t env_803, obj_t chars_804)
{
{
obj_t chars_1467;
chars_1467 = chars_804;
{
obj_t symbol1208_1468;
symbol1208_1468 = symbol1971___r4_strings_6_7;
{
PUSH_TRACE(symbol1208_1468);
BUNSPEC;
{
obj_t aux1207_1469;
aux1207_1469 = list__string_78___r4_strings_6_7(chars_1467);
POP_TRACE();
return aux1207_1469;
}
}
}
}
}


/* string-length */long string_length_125___r4_strings_6_7(obj_t string_5)
{
{
obj_t symbol1210_1470;
symbol1210_1470 = symbol1972___r4_strings_6_7;
{
PUSH_TRACE(symbol1210_1470);
BUNSPEC;
{
long aux1209_1471;
aux1209_1471 = STRING_LENGTH(string_5);
POP_TRACE();
return aux1209_1471;
}
}
}
}


/* _string-length1278 */obj_t _string_length1278_26___r4_strings_6_7(obj_t env_805, obj_t string_806)
{
{
long aux_1763;
{
obj_t string_1472;
if(STRINGP(string_806)){
string_1472 = string_806;
}
 else {
bigloo_type_error_location_103___error(symbol1973___r4_strings_6_7, string1974___r4_strings_6_7, string_806, string1967___r4_strings_6_7, BINT(((long)7795)));
exit( -1 );}
{
obj_t symbol1210_1473;
symbol1210_1473 = symbol1972___r4_strings_6_7;
{
PUSH_TRACE(symbol1210_1473);
BUNSPEC;
{
long aux1209_1474;
aux1209_1474 = STRING_LENGTH(string_1472);
POP_TRACE();
aux_1763 = aux1209_1474;
}
}
}
}
return BINT(aux_1763);
}
}


/* string-ref */unsigned char string_ref_239___r4_strings_6_7(obj_t string_6, long k_7)
{
{
obj_t symbol1212_1475;
symbol1212_1475 = symbol1975___r4_strings_6_7;
{
PUSH_TRACE(symbol1212_1475);
BUNSPEC;
{
unsigned char aux1211_1476;
{
bool_t test_1774;
{
long aux_1775;
aux_1775 = STRING_LENGTH(string_6);
test_1774 = BOUND_CHECK(k_7, aux_1775);
}
if(test_1774){
aux1211_1476 = STRING_REF(string_6, k_7);
}
 else {
obj_t aux_1779;
{
obj_t aux1341_1477;
aux1341_1477 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(k_7), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1341_1477)){
aux_1779 = aux1341_1477;
}
 else {
bigloo_type_error_location_103___error(symbol1975___r4_strings_6_7, string1968___r4_strings_6_7, aux1341_1477, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
aux1211_1476 = (unsigned char)CCHAR(aux_1779);
}
}
POP_TRACE();
return aux1211_1476;
}
}
}
}


/* _string-ref1279 */obj_t _string_ref1279_174___r4_strings_6_7(obj_t env_807, obj_t string_808, obj_t k_809)
{
{
unsigned char aux_1790;
{
obj_t string_1478;
long k_1479;
if(STRINGP(string_808)){
string_1478 = string_808;
}
 else {
bigloo_type_error_location_103___error(symbol1979___r4_strings_6_7, string1974___r4_strings_6_7, string_808, string1967___r4_strings_6_7, BINT(((long)8085)));
exit( -1 );}
{
obj_t aux_1796;
if(INTEGERP(k_809)){
aux_1796 = k_809;
}
 else {
bigloo_type_error_location_103___error(symbol1979___r4_strings_6_7, string1980___r4_strings_6_7, k_809, string1967___r4_strings_6_7, BINT(((long)8085)));
exit( -1 );}
k_1479 = (long)CINT(aux_1796);
}
{
obj_t symbol1212_1480;
symbol1212_1480 = symbol1975___r4_strings_6_7;
{
PUSH_TRACE(symbol1212_1480);
BUNSPEC;
{
unsigned char aux1211_1481;
{
bool_t test_1804;
{
long aux_1805;
aux_1805 = STRING_LENGTH(string_1478);
test_1804 = BOUND_CHECK(k_1479, aux_1805);
}
if(test_1804){
aux1211_1481 = STRING_REF(string_1478, k_1479);
}
 else {
obj_t aux_1809;
{
obj_t aux1341_1482;
aux1341_1482 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(k_1479), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1341_1482)){
aux_1809 = aux1341_1482;
}
 else {
bigloo_type_error_location_103___error(symbol1975___r4_strings_6_7, string1968___r4_strings_6_7, aux1341_1482, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
aux1211_1481 = (unsigned char)CCHAR(aux_1809);
}
}
POP_TRACE();
aux_1790 = aux1211_1481;
}
}
}
}
return BCHAR(aux_1790);
}
}


/* string-set! */obj_t string_set__176___r4_strings_6_7(obj_t string_8, long k_9, unsigned char char_10)
{
{
obj_t symbol1214_1483;
symbol1214_1483 = symbol1981___r4_strings_6_7;
{
PUSH_TRACE(symbol1214_1483);
BUNSPEC;
{
obj_t aux1213_1484;
{
bool_t test_1822;
{
long aux_1823;
aux_1823 = STRING_LENGTH(string_8);
test_1822 = BOUND_CHECK(k_9, aux_1823);
}
if(test_1822){
aux1213_1484 = STRING_SET(string_8, k_9, char_10);
}
 else {
aux1213_1484 = debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(k_9), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
POP_TRACE();
return aux1213_1484;
}
}
}
}


/* _string-set!1280 */obj_t _string_set_1280_177___r4_strings_6_7(obj_t env_810, obj_t string_811, obj_t k_812, obj_t char_813)
{
{
obj_t string_1485;
long k_1486;
unsigned char char_166_1487;
if(STRINGP(string_811)){
string_1485 = string_811;
}
 else {
bigloo_type_error_location_103___error(symbol1983___r4_strings_6_7, string1974___r4_strings_6_7, string_811, string1967___r4_strings_6_7, BINT(((long)8484)));
exit( -1 );}
{
obj_t aux_1836;
if(INTEGERP(k_812)){
aux_1836 = k_812;
}
 else {
bigloo_type_error_location_103___error(symbol1983___r4_strings_6_7, string1980___r4_strings_6_7, k_812, string1967___r4_strings_6_7, BINT(((long)8484)));
exit( -1 );}
k_1486 = (long)CINT(aux_1836);
}
{
obj_t aux_1843;
if(CHARP(char_813)){
aux_1843 = char_813;
}
 else {
bigloo_type_error_location_103___error(symbol1983___r4_strings_6_7, string1968___r4_strings_6_7, char_813, string1967___r4_strings_6_7, BINT(((long)8484)));
exit( -1 );}
char_166_1487 = (unsigned char)CCHAR(aux_1843);
}
{
obj_t symbol1214_1488;
symbol1214_1488 = symbol1981___r4_strings_6_7;
{
PUSH_TRACE(symbol1214_1488);
BUNSPEC;
{
obj_t aux1213_1489;
{
bool_t test_1851;
{
long aux_1852;
aux_1852 = STRING_LENGTH(string_1485);
test_1851 = BOUND_CHECK(k_1486, aux_1852);
}
if(test_1851){
aux1213_1489 = STRING_SET(string_1485, k_1486, char_166_1487);
}
 else {
aux1213_1489 = debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(k_1486), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
POP_TRACE();
return aux1213_1489;
}
}
}
}
}


/* string-ref-ur */unsigned char string_ref_ur_85___r4_strings_6_7(obj_t string_11, long k_12)
{
{
obj_t symbol1216_1490;
symbol1216_1490 = symbol1984___r4_strings_6_7;
{
PUSH_TRACE(symbol1216_1490);
BUNSPEC;
{
unsigned char aux1215_1491;
aux1215_1491 = STRING_REF(string_11, k_12);
POP_TRACE();
return aux1215_1491;
}
}
}
}


/* _string-ref-ur1281 */obj_t _string_ref_ur1281_204___r4_strings_6_7(obj_t env_814, obj_t string_815, obj_t k_816)
{
{
unsigned char aux_1863;
{
obj_t string_1492;
long k_1493;
if(STRINGP(string_815)){
string_1492 = string_815;
}
 else {
bigloo_type_error_location_103___error(symbol1985___r4_strings_6_7, string1974___r4_strings_6_7, string_815, string1967___r4_strings_6_7, BINT(((long)8895)));
exit( -1 );}
{
obj_t aux_1869;
if(INTEGERP(k_816)){
aux_1869 = k_816;
}
 else {
bigloo_type_error_location_103___error(symbol1985___r4_strings_6_7, string1980___r4_strings_6_7, k_816, string1967___r4_strings_6_7, BINT(((long)8895)));
exit( -1 );}
k_1493 = (long)CINT(aux_1869);
}
{
obj_t symbol1216_1494;
symbol1216_1494 = symbol1984___r4_strings_6_7;
{
PUSH_TRACE(symbol1216_1494);
BUNSPEC;
{
unsigned char aux1215_1495;
aux1215_1495 = STRING_REF(string_1492, k_1493);
POP_TRACE();
aux_1863 = aux1215_1495;
}
}
}
}
return BCHAR(aux_1863);
}
}


/* string-set-ur! */obj_t string_set_ur__94___r4_strings_6_7(obj_t string_13, long k_14, unsigned char char_15)
{
{
obj_t symbol1218_1496;
symbol1218_1496 = symbol1986___r4_strings_6_7;
{
PUSH_TRACE(symbol1218_1496);
BUNSPEC;
{
obj_t aux1217_1497;
aux1217_1497 = STRING_SET(string_13, k_14, char_15);
POP_TRACE();
return aux1217_1497;
}
}
}
}


/* _string-set-ur!1282 */obj_t _string_set_ur_1282_29___r4_strings_6_7(obj_t env_817, obj_t string_818, obj_t k_819, obj_t char_820)
{
{
obj_t string_1498;
long k_1499;
unsigned char char_166_1500;
if(STRINGP(string_818)){
string_1498 = string_818;
}
 else {
bigloo_type_error_location_103___error(symbol1987___r4_strings_6_7, string1974___r4_strings_6_7, string_818, string1967___r4_strings_6_7, BINT(((long)9187)));
exit( -1 );}
{
obj_t aux_1888;
if(INTEGERP(k_819)){
aux_1888 = k_819;
}
 else {
bigloo_type_error_location_103___error(symbol1987___r4_strings_6_7, string1980___r4_strings_6_7, k_819, string1967___r4_strings_6_7, BINT(((long)9187)));
exit( -1 );}
k_1499 = (long)CINT(aux_1888);
}
{
obj_t aux_1895;
if(CHARP(char_820)){
aux_1895 = char_820;
}
 else {
bigloo_type_error_location_103___error(symbol1987___r4_strings_6_7, string1968___r4_strings_6_7, char_820, string1967___r4_strings_6_7, BINT(((long)9187)));
exit( -1 );}
char_166_1500 = (unsigned char)CCHAR(aux_1895);
}
{
obj_t symbol1218_1501;
symbol1218_1501 = symbol1986___r4_strings_6_7;
{
PUSH_TRACE(symbol1218_1501);
BUNSPEC;
{
obj_t aux1217_1502;
aux1217_1502 = STRING_SET(string_1498, k_1499, char_166_1500);
POP_TRACE();
return aux1217_1502;
}
}
}
}
}


/* string=? */bool_t string___146___r4_strings_6_7(obj_t string1_16, obj_t string2_17)
{
{
obj_t symbol1220_1503;
symbol1220_1503 = symbol1988___r4_strings_6_7;
{
PUSH_TRACE(symbol1220_1503);
BUNSPEC;
{
bool_t aux1219_1504;
aux1219_1504 = bigloo_strcmp(string1_16, string2_17);
POP_TRACE();
return aux1219_1504;
}
}
}
}


/* _string=?1283 */obj_t _string__1283_116___r4_strings_6_7(obj_t env_821, obj_t string1_822, obj_t string2_823)
{
{
bool_t aux_1908;
{
obj_t string1_1505;
obj_t string2_1506;
if(STRINGP(string1_822)){
string1_1505 = string1_822;
}
 else {
bigloo_type_error_location_103___error(symbol1989___r4_strings_6_7, string1974___r4_strings_6_7, string1_822, string1967___r4_strings_6_7, BINT(((long)9490)));
exit( -1 );}
if(STRINGP(string2_823)){
string2_1506 = string2_823;
}
 else {
bigloo_type_error_location_103___error(symbol1989___r4_strings_6_7, string1974___r4_strings_6_7, string2_823, string1967___r4_strings_6_7, BINT(((long)9490)));
exit( -1 );}
{
obj_t symbol1220_1507;
symbol1220_1507 = symbol1988___r4_strings_6_7;
{
PUSH_TRACE(symbol1220_1507);
BUNSPEC;
{
bool_t aux1219_1508;
aux1219_1508 = bigloo_strcmp(string1_1505, string2_1506);
POP_TRACE();
aux_1908 = aux1219_1508;
}
}
}
}
return BBOOL(aux_1908);
}
}


/* substring=? */bool_t substring___218___r4_strings_6_7(obj_t string1_18, obj_t string2_19, long len_20)
{
{
obj_t symbol1222_1509;
symbol1222_1509 = symbol1990___r4_strings_6_7;
{
PUSH_TRACE(symbol1222_1509);
BUNSPEC;
{
bool_t aux1221_1510;
aux1221_1510 = bigloo_strncmp(string1_18, string2_19, len_20);
POP_TRACE();
return aux1221_1510;
}
}
}
}


/* _substring=?1284 */obj_t _substring__1284_146___r4_strings_6_7(obj_t env_824, obj_t string1_825, obj_t string2_826, obj_t len_827)
{
{
bool_t aux_1926;
{
obj_t string1_1511;
obj_t string2_1512;
long len_1513;
if(STRINGP(string1_825)){
string1_1511 = string1_825;
}
 else {
bigloo_type_error_location_103___error(symbol1991___r4_strings_6_7, string1974___r4_strings_6_7, string1_825, string1967___r4_strings_6_7, BINT(((long)9788)));
exit( -1 );}
if(STRINGP(string2_826)){
string2_1512 = string2_826;
}
 else {
bigloo_type_error_location_103___error(symbol1991___r4_strings_6_7, string1974___r4_strings_6_7, string2_826, string1967___r4_strings_6_7, BINT(((long)9788)));
exit( -1 );}
{
obj_t aux_1937;
if(INTEGERP(len_827)){
aux_1937 = len_827;
}
 else {
bigloo_type_error_location_103___error(symbol1991___r4_strings_6_7, string1980___r4_strings_6_7, len_827, string1967___r4_strings_6_7, BINT(((long)9788)));
exit( -1 );}
len_1513 = (long)CINT(aux_1937);
}
{
obj_t symbol1222_1514;
symbol1222_1514 = symbol1990___r4_strings_6_7;
{
PUSH_TRACE(symbol1222_1514);
BUNSPEC;
{
bool_t aux1221_1515;
aux1221_1515 = bigloo_strncmp(string1_1511, string2_1512, len_1513);
POP_TRACE();
aux_1926 = aux1221_1515;
}
}
}
}
return BBOOL(aux_1926);
}
}


/* substring-ci=? */bool_t substring_ci___99___r4_strings_6_7(obj_t string1_21, obj_t string2_22, long len_23)
{
{
obj_t symbol1224_1516;
symbol1224_1516 = symbol1992___r4_strings_6_7;
{
PUSH_TRACE(symbol1224_1516);
BUNSPEC;
{
bool_t aux1223_1517;
aux1223_1517 = bigloo_strncmp_ci(string1_21, string2_22, len_23);
POP_TRACE();
return aux1223_1517;
}
}
}
}


/* _substring-ci=?1285 */obj_t _substring_ci__1285_242___r4_strings_6_7(obj_t env_828, obj_t string1_829, obj_t string2_830, obj_t len_831)
{
{
bool_t aux_1951;
{
obj_t string1_1518;
obj_t string2_1519;
long len_1520;
if(STRINGP(string1_829)){
string1_1518 = string1_829;
}
 else {
bigloo_type_error_location_103___error(symbol1993___r4_strings_6_7, string1974___r4_strings_6_7, string1_829, string1967___r4_strings_6_7, BINT(((long)10100)));
exit( -1 );}
if(STRINGP(string2_830)){
string2_1519 = string2_830;
}
 else {
bigloo_type_error_location_103___error(symbol1993___r4_strings_6_7, string1974___r4_strings_6_7, string2_830, string1967___r4_strings_6_7, BINT(((long)10100)));
exit( -1 );}
{
obj_t aux_1962;
if(INTEGERP(len_831)){
aux_1962 = len_831;
}
 else {
bigloo_type_error_location_103___error(symbol1993___r4_strings_6_7, string1980___r4_strings_6_7, len_831, string1967___r4_strings_6_7, BINT(((long)10100)));
exit( -1 );}
len_1520 = (long)CINT(aux_1962);
}
{
obj_t symbol1224_1521;
symbol1224_1521 = symbol1992___r4_strings_6_7;
{
PUSH_TRACE(symbol1224_1521);
BUNSPEC;
{
bool_t aux1223_1522;
aux1223_1522 = bigloo_strncmp_ci(string1_1518, string2_1519, len_1520);
POP_TRACE();
aux_1951 = aux1223_1522;
}
}
}
}
return BBOOL(aux_1951);
}
}


/* string-ci=? */bool_t string_ci___247___r4_strings_6_7(obj_t string1_24, obj_t string2_25)
{
{
obj_t symbol1226_1523;
symbol1226_1523 = symbol1994___r4_strings_6_7;
{
PUSH_TRACE(symbol1226_1523);
BUNSPEC;
{
bool_t aux1225_1524;
aux1225_1524 = strcicmp(string1_24, string2_25);
POP_TRACE();
return aux1225_1524;
}
}
}
}


/* _string-ci=?1286 */obj_t _string_ci__1286_73___r4_strings_6_7(obj_t env_832, obj_t string1_833, obj_t string2_834)
{
{
bool_t aux_1976;
{
obj_t string1_1525;
obj_t string2_1526;
if(STRINGP(string1_833)){
string1_1525 = string1_833;
}
 else {
bigloo_type_error_location_103___error(symbol1995___r4_strings_6_7, string1974___r4_strings_6_7, string1_833, string1967___r4_strings_6_7, BINT(((long)10418)));
exit( -1 );}
if(STRINGP(string2_834)){
string2_1526 = string2_834;
}
 else {
bigloo_type_error_location_103___error(symbol1995___r4_strings_6_7, string1974___r4_strings_6_7, string2_834, string1967___r4_strings_6_7, BINT(((long)10418)));
exit( -1 );}
{
obj_t symbol1226_1527;
symbol1226_1527 = symbol1994___r4_strings_6_7;
{
PUSH_TRACE(symbol1226_1527);
BUNSPEC;
{
bool_t aux1225_1528;
aux1225_1528 = strcicmp(string1_1525, string2_1526);
POP_TRACE();
aux_1976 = aux1225_1528;
}
}
}
}
return BBOOL(aux_1976);
}
}


/* string<? */bool_t string___83___r4_strings_6_7(obj_t string1_26, obj_t string2_27)
{
{
obj_t symbol1228_1529;
symbol1228_1529 = symbol1996___r4_strings_6_7;
{
PUSH_TRACE(symbol1228_1529);
BUNSPEC;
{
bool_t aux1227_1530;
aux1227_1530 = string_lt(string1_26, string2_27);
POP_TRACE();
return aux1227_1530;
}
}
}
}


/* _string<?1287 */obj_t _string__1287_201___r4_strings_6_7(obj_t env_835, obj_t string1_836, obj_t string2_837)
{
{
bool_t aux_1994;
{
obj_t string1_1531;
obj_t string2_1532;
if(STRINGP(string1_836)){
string1_1531 = string1_836;
}
 else {
bigloo_type_error_location_103___error(symbol1997___r4_strings_6_7, string1974___r4_strings_6_7, string1_836, string1967___r4_strings_6_7, BINT(((long)10717)));
exit( -1 );}
if(STRINGP(string2_837)){
string2_1532 = string2_837;
}
 else {
bigloo_type_error_location_103___error(symbol1997___r4_strings_6_7, string1974___r4_strings_6_7, string2_837, string1967___r4_strings_6_7, BINT(((long)10717)));
exit( -1 );}
{
obj_t symbol1228_1533;
symbol1228_1533 = symbol1996___r4_strings_6_7;
{
PUSH_TRACE(symbol1228_1533);
BUNSPEC;
{
bool_t aux1227_1534;
aux1227_1534 = string_lt(string1_1531, string2_1532);
POP_TRACE();
aux_1994 = aux1227_1534;
}
}
}
}
return BBOOL(aux_1994);
}
}


/* string>? */bool_t string___248___r4_strings_6_7(obj_t string1_28, obj_t string2_29)
{
{
obj_t symbol1230_1535;
symbol1230_1535 = symbol1998___r4_strings_6_7;
{
PUSH_TRACE(symbol1230_1535);
BUNSPEC;
{
bool_t aux1229_1536;
aux1229_1536 = string_gt(string1_28, string2_29);
POP_TRACE();
return aux1229_1536;
}
}
}
}


/* _string>?1288 */obj_t _string__1288_196___r4_strings_6_7(obj_t env_838, obj_t string1_839, obj_t string2_840)
{
{
bool_t aux_2012;
{
obj_t string1_1537;
obj_t string2_1538;
if(STRINGP(string1_839)){
string1_1537 = string1_839;
}
 else {
bigloo_type_error_location_103___error(symbol1999___r4_strings_6_7, string1974___r4_strings_6_7, string1_839, string1967___r4_strings_6_7, BINT(((long)11014)));
exit( -1 );}
if(STRINGP(string2_840)){
string2_1538 = string2_840;
}
 else {
bigloo_type_error_location_103___error(symbol1999___r4_strings_6_7, string1974___r4_strings_6_7, string2_840, string1967___r4_strings_6_7, BINT(((long)11014)));
exit( -1 );}
{
obj_t symbol1230_1539;
symbol1230_1539 = symbol1998___r4_strings_6_7;
{
PUSH_TRACE(symbol1230_1539);
BUNSPEC;
{
bool_t aux1229_1540;
aux1229_1540 = string_gt(string1_1537, string2_1538);
POP_TRACE();
aux_2012 = aux1229_1540;
}
}
}
}
return BBOOL(aux_2012);
}
}


/* string<=? */bool_t string____33___r4_strings_6_7(obj_t string1_30, obj_t string2_31)
{
{
obj_t symbol1232_1541;
symbol1232_1541 = symbol2000___r4_strings_6_7;
{
PUSH_TRACE(symbol1232_1541);
BUNSPEC;
{
bool_t aux1231_1542;
aux1231_1542 = string_le(string1_30, string2_31);
POP_TRACE();
return aux1231_1542;
}
}
}
}


/* _string<=?1289 */obj_t _string___1289_193___r4_strings_6_7(obj_t env_841, obj_t string1_842, obj_t string2_843)
{
{
bool_t aux_2030;
{
obj_t string1_1543;
obj_t string2_1544;
if(STRINGP(string1_842)){
string1_1543 = string1_842;
}
 else {
bigloo_type_error_location_103___error(symbol2001___r4_strings_6_7, string1974___r4_strings_6_7, string1_842, string1967___r4_strings_6_7, BINT(((long)11311)));
exit( -1 );}
if(STRINGP(string2_843)){
string2_1544 = string2_843;
}
 else {
bigloo_type_error_location_103___error(symbol2001___r4_strings_6_7, string1974___r4_strings_6_7, string2_843, string1967___r4_strings_6_7, BINT(((long)11311)));
exit( -1 );}
{
obj_t symbol1232_1545;
symbol1232_1545 = symbol2000___r4_strings_6_7;
{
PUSH_TRACE(symbol1232_1545);
BUNSPEC;
{
bool_t aux1231_1546;
aux1231_1546 = string_le(string1_1543, string2_1544);
POP_TRACE();
aux_2030 = aux1231_1546;
}
}
}
}
return BBOOL(aux_2030);
}
}


/* string>=? */bool_t string____135___r4_strings_6_7(obj_t string1_32, obj_t string2_33)
{
{
obj_t symbol1234_1547;
symbol1234_1547 = symbol2002___r4_strings_6_7;
{
PUSH_TRACE(symbol1234_1547);
BUNSPEC;
{
bool_t aux1233_1548;
aux1233_1548 = string_ge(string1_32, string2_33);
POP_TRACE();
return aux1233_1548;
}
}
}
}


/* _string>=?1290 */obj_t _string___1290_211___r4_strings_6_7(obj_t env_844, obj_t string1_845, obj_t string2_846)
{
{
bool_t aux_2048;
{
obj_t string1_1549;
obj_t string2_1550;
if(STRINGP(string1_845)){
string1_1549 = string1_845;
}
 else {
bigloo_type_error_location_103___error(symbol2003___r4_strings_6_7, string1974___r4_strings_6_7, string1_845, string1967___r4_strings_6_7, BINT(((long)11609)));
exit( -1 );}
if(STRINGP(string2_846)){
string2_1550 = string2_846;
}
 else {
bigloo_type_error_location_103___error(symbol2003___r4_strings_6_7, string1974___r4_strings_6_7, string2_846, string1967___r4_strings_6_7, BINT(((long)11609)));
exit( -1 );}
{
obj_t symbol1234_1551;
symbol1234_1551 = symbol2002___r4_strings_6_7;
{
PUSH_TRACE(symbol1234_1551);
BUNSPEC;
{
bool_t aux1233_1552;
aux1233_1552 = string_ge(string1_1549, string2_1550);
POP_TRACE();
aux_2048 = aux1233_1552;
}
}
}
}
return BBOOL(aux_2048);
}
}


/* string-ci<? */bool_t string_ci___92___r4_strings_6_7(obj_t string1_34, obj_t string2_35)
{
{
obj_t symbol1236_1553;
symbol1236_1553 = symbol2004___r4_strings_6_7;
{
PUSH_TRACE(symbol1236_1553);
BUNSPEC;
{
bool_t aux1235_1554;
aux1235_1554 = string_cilt(string1_34, string2_35);
POP_TRACE();
return aux1235_1554;
}
}
}
}


/* _string-ci<?1291 */obj_t _string_ci__1291_191___r4_strings_6_7(obj_t env_847, obj_t string1_848, obj_t string2_849)
{
{
bool_t aux_2066;
{
obj_t string1_1555;
obj_t string2_1556;
if(STRINGP(string1_848)){
string1_1555 = string1_848;
}
 else {
bigloo_type_error_location_103___error(symbol2005___r4_strings_6_7, string1974___r4_strings_6_7, string1_848, string1967___r4_strings_6_7, BINT(((long)11907)));
exit( -1 );}
if(STRINGP(string2_849)){
string2_1556 = string2_849;
}
 else {
bigloo_type_error_location_103___error(symbol2005___r4_strings_6_7, string1974___r4_strings_6_7, string2_849, string1967___r4_strings_6_7, BINT(((long)11907)));
exit( -1 );}
{
obj_t symbol1236_1557;
symbol1236_1557 = symbol2004___r4_strings_6_7;
{
PUSH_TRACE(symbol1236_1557);
BUNSPEC;
{
bool_t aux1235_1558;
aux1235_1558 = string_cilt(string1_1555, string2_1556);
POP_TRACE();
aux_2066 = aux1235_1558;
}
}
}
}
return BBOOL(aux_2066);
}
}


/* string-ci>? */bool_t string_ci___60___r4_strings_6_7(obj_t string1_36, obj_t string2_37)
{
{
obj_t symbol1238_1559;
symbol1238_1559 = symbol2006___r4_strings_6_7;
{
PUSH_TRACE(symbol1238_1559);
BUNSPEC;
{
bool_t aux1237_1560;
aux1237_1560 = string_cigt(string1_36, string2_37);
POP_TRACE();
return aux1237_1560;
}
}
}
}


/* _string-ci>?1292 */obj_t _string_ci__1292_186___r4_strings_6_7(obj_t env_850, obj_t string1_851, obj_t string2_852)
{
{
bool_t aux_2084;
{
obj_t string1_1561;
obj_t string2_1562;
if(STRINGP(string1_851)){
string1_1561 = string1_851;
}
 else {
bigloo_type_error_location_103___error(symbol2007___r4_strings_6_7, string1974___r4_strings_6_7, string1_851, string1967___r4_strings_6_7, BINT(((long)12209)));
exit( -1 );}
if(STRINGP(string2_852)){
string2_1562 = string2_852;
}
 else {
bigloo_type_error_location_103___error(symbol2007___r4_strings_6_7, string1974___r4_strings_6_7, string2_852, string1967___r4_strings_6_7, BINT(((long)12209)));
exit( -1 );}
{
obj_t symbol1238_1563;
symbol1238_1563 = symbol2006___r4_strings_6_7;
{
PUSH_TRACE(symbol1238_1563);
BUNSPEC;
{
bool_t aux1237_1564;
aux1237_1564 = string_cigt(string1_1561, string2_1562);
POP_TRACE();
aux_2084 = aux1237_1564;
}
}
}
}
return BBOOL(aux_2084);
}
}


/* string-ci<=? */bool_t string_ci____210___r4_strings_6_7(obj_t string1_38, obj_t string2_39)
{
{
obj_t symbol1240_1565;
symbol1240_1565 = symbol2008___r4_strings_6_7;
{
PUSH_TRACE(symbol1240_1565);
BUNSPEC;
{
bool_t aux1239_1566;
aux1239_1566 = string_cile(string1_38, string2_39);
POP_TRACE();
return aux1239_1566;
}
}
}
}


/* _string-ci<=?1293 */obj_t _string_ci___1293_227___r4_strings_6_7(obj_t env_853, obj_t string1_854, obj_t string2_855)
{
{
bool_t aux_2102;
{
obj_t string1_1567;
obj_t string2_1568;
if(STRINGP(string1_854)){
string1_1567 = string1_854;
}
 else {
bigloo_type_error_location_103___error(symbol2009___r4_strings_6_7, string1974___r4_strings_6_7, string1_854, string1967___r4_strings_6_7, BINT(((long)12511)));
exit( -1 );}
if(STRINGP(string2_855)){
string2_1568 = string2_855;
}
 else {
bigloo_type_error_location_103___error(symbol2009___r4_strings_6_7, string1974___r4_strings_6_7, string2_855, string1967___r4_strings_6_7, BINT(((long)12511)));
exit( -1 );}
{
obj_t symbol1240_1569;
symbol1240_1569 = symbol2008___r4_strings_6_7;
{
PUSH_TRACE(symbol1240_1569);
BUNSPEC;
{
bool_t aux1239_1570;
aux1239_1570 = string_cile(string1_1567, string2_1568);
POP_TRACE();
aux_2102 = aux1239_1570;
}
}
}
}
return BBOOL(aux_2102);
}
}


/* string-ci>=? */bool_t string_ci____43___r4_strings_6_7(obj_t string1_40, obj_t string2_41)
{
{
obj_t symbol1242_1571;
symbol1242_1571 = symbol2010___r4_strings_6_7;
{
PUSH_TRACE(symbol1242_1571);
BUNSPEC;
{
bool_t aux1241_1572;
aux1241_1572 = string_cige(string1_40, string2_41);
POP_TRACE();
return aux1241_1572;
}
}
}
}


/* _string-ci>=?1294 */obj_t _string_ci___1294_117___r4_strings_6_7(obj_t env_856, obj_t string1_857, obj_t string2_858)
{
{
bool_t aux_2120;
{
obj_t string1_1573;
obj_t string2_1574;
if(STRINGP(string1_857)){
string1_1573 = string1_857;
}
 else {
bigloo_type_error_location_103___error(symbol2011___r4_strings_6_7, string1974___r4_strings_6_7, string1_857, string1967___r4_strings_6_7, BINT(((long)12814)));
exit( -1 );}
if(STRINGP(string2_858)){
string2_1574 = string2_858;
}
 else {
bigloo_type_error_location_103___error(symbol2011___r4_strings_6_7, string1974___r4_strings_6_7, string2_858, string1967___r4_strings_6_7, BINT(((long)12814)));
exit( -1 );}
{
obj_t symbol1242_1575;
symbol1242_1575 = symbol2010___r4_strings_6_7;
{
PUSH_TRACE(symbol1242_1575);
BUNSPEC;
{
bool_t aux1241_1576;
aux1241_1576 = string_cige(string1_1573, string2_1574);
POP_TRACE();
aux_2120 = aux1241_1576;
}
}
}
}
return BBOOL(aux_2120);
}
}


/* substring */obj_t substring___r4_strings_6_7(obj_t string_42, long start_43, long end_44)
{
{
obj_t symbol1244_1577;
symbol1244_1577 = symbol2012___r4_strings_6_7;
{
PUSH_TRACE(symbol1244_1577);
BUNSPEC;
{
obj_t aux1243_1578;
{
bool_t test_2136;
if((end_44>=start_43)){
bool_t test_2139;
{
long aux_2140;
{
long aux_2141;
aux_2141 = STRING_LENGTH(string_42);
aux_2140 = (aux_2141+((long)1));
}
test_2139 = BOUND_CHECK(start_43, aux_2140);
}
if(test_2139){
long aux_2145;
{
long aux_2146;
aux_2146 = STRING_LENGTH(string_42);
aux_2145 = (aux_2146+((long)1));
}
test_2136 = BOUND_CHECK(end_44, aux_2145);
}
 else {
test_2136 = ((bool_t)0);
}
}
 else {
test_2136 = ((bool_t)0);
}
if(test_2136){
aux1243_1578 = c_substring(string_42, start_43, end_44);
}
 else {
obj_t arg1015_1579;
{
obj_t aux_2153;
obj_t aux_2151;
aux_2153 = BINT(end_44);
aux_2151 = BINT(start_43);
arg1015_1579 = MAKE_PAIR(aux_2151, aux_2153);
}
{
obj_t aux1618_1580;
aux1618_1580 = debug_error_location_199___error(string2013___r4_strings_6_7, string2014___r4_strings_6_7, arg1015_1579, string1978___r4_strings_6_7, BINT(((long)7610)));
if(STRINGP(aux1618_1580)){
aux1243_1578 = aux1618_1580;
}
 else {
bigloo_type_error_location_103___error(symbol2012___r4_strings_6_7, string1974___r4_strings_6_7, aux1618_1580, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
}
}
POP_TRACE();
return aux1243_1578;
}
}
}
}


/* _substring1295 */obj_t _substring1295___r4_strings_6_7(obj_t env_859, obj_t string_860, obj_t start_861, obj_t end_862)
{
{
obj_t string_1581;
long start_1582;
long end_1583;
if(STRINGP(string_860)){
string_1581 = string_860;
}
 else {
bigloo_type_error_location_103___error(symbol2015___r4_strings_6_7, string1974___r4_strings_6_7, string_860, string1967___r4_strings_6_7, BINT(((long)13117)));
exit( -1 );}
{
obj_t aux_2169;
if(INTEGERP(start_861)){
aux_2169 = start_861;
}
 else {
bigloo_type_error_location_103___error(symbol2015___r4_strings_6_7, string1980___r4_strings_6_7, start_861, string1967___r4_strings_6_7, BINT(((long)13117)));
exit( -1 );}
start_1582 = (long)CINT(aux_2169);
}
{
obj_t aux_2176;
if(INTEGERP(end_862)){
aux_2176 = end_862;
}
 else {
bigloo_type_error_location_103___error(symbol2015___r4_strings_6_7, string1980___r4_strings_6_7, end_862, string1967___r4_strings_6_7, BINT(((long)13117)));
exit( -1 );}
end_1583 = (long)CINT(aux_2176);
}
{
obj_t symbol1244_1584;
symbol1244_1584 = symbol2012___r4_strings_6_7;
{
PUSH_TRACE(symbol1244_1584);
BUNSPEC;
{
obj_t aux1243_1585;
{
bool_t test_2184;
if((end_1583>=start_1582)){
bool_t test_2187;
{
long aux_2188;
{
long aux_2189;
aux_2189 = STRING_LENGTH(string_1581);
aux_2188 = (aux_2189+((long)1));
}
test_2187 = BOUND_CHECK(start_1582, aux_2188);
}
if(test_2187){
long aux_2193;
{
long aux_2194;
aux_2194 = STRING_LENGTH(string_1581);
aux_2193 = (aux_2194+((long)1));
}
test_2184 = BOUND_CHECK(end_1583, aux_2193);
}
 else {
test_2184 = ((bool_t)0);
}
}
 else {
test_2184 = ((bool_t)0);
}
if(test_2184){
aux1243_1585 = c_substring(string_1581, start_1582, end_1583);
}
 else {
obj_t arg1015_1586;
{
obj_t aux_2201;
obj_t aux_2199;
aux_2201 = BINT(end_1583);
aux_2199 = BINT(start_1582);
arg1015_1586 = MAKE_PAIR(aux_2199, aux_2201);
}
{
obj_t aux1618_1587;
aux1618_1587 = debug_error_location_199___error(string2013___r4_strings_6_7, string2014___r4_strings_6_7, arg1015_1586, string1978___r4_strings_6_7, BINT(((long)7610)));
if(STRINGP(aux1618_1587)){
aux1243_1585 = aux1618_1587;
}
 else {
bigloo_type_error_location_103___error(symbol2012___r4_strings_6_7, string1974___r4_strings_6_7, aux1618_1587, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
}
}
POP_TRACE();
return aux1243_1585;
}
}
}
}
}


/* substring-ur */obj_t substring_ur_202___r4_strings_6_7(obj_t string_45, long start_46, long end_47)
{
{
obj_t symbol1246_1588;
symbol1246_1588 = symbol2016___r4_strings_6_7;
{
PUSH_TRACE(symbol1246_1588);
BUNSPEC;
{
obj_t aux1245_1589;
aux1245_1589 = c_substring(string_45, start_46, end_47);
POP_TRACE();
return aux1245_1589;
}
}
}
}


/* _substring-ur1296 */obj_t _substring_ur1296_110___r4_strings_6_7(obj_t env_863, obj_t string_864, obj_t start_865, obj_t end_866)
{
{
obj_t string_1590;
long start_1591;
long end_1592;
if(STRINGP(string_864)){
string_1590 = string_864;
}
 else {
bigloo_type_error_location_103___error(symbol2017___r4_strings_6_7, string1974___r4_strings_6_7, string_864, string1967___r4_strings_6_7, BINT(((long)13711)));
exit( -1 );}
{
obj_t aux_2220;
if(INTEGERP(start_865)){
aux_2220 = start_865;
}
 else {
bigloo_type_error_location_103___error(symbol2017___r4_strings_6_7, string1980___r4_strings_6_7, start_865, string1967___r4_strings_6_7, BINT(((long)13711)));
exit( -1 );}
start_1591 = (long)CINT(aux_2220);
}
{
obj_t aux_2227;
if(INTEGERP(end_866)){
aux_2227 = end_866;
}
 else {
bigloo_type_error_location_103___error(symbol2017___r4_strings_6_7, string1980___r4_strings_6_7, end_866, string1967___r4_strings_6_7, BINT(((long)13711)));
exit( -1 );}
end_1592 = (long)CINT(aux_2227);
}
{
obj_t symbol1246_1593;
symbol1246_1593 = symbol2016___r4_strings_6_7;
{
PUSH_TRACE(symbol1246_1593);
BUNSPEC;
{
obj_t aux1245_1594;
aux1245_1594 = c_substring(string_1590, start_1591, end_1592);
POP_TRACE();
return aux1245_1594;
}
}
}
}
}


/* string-append */obj_t string_append_106___r4_strings_6_7(obj_t list_48)
{
{
obj_t symbol1248_768;
symbol1248_768 = symbol2018___r4_strings_6_7;
{
PUSH_TRACE(symbol1248_768);
BUNSPEC;
{
obj_t aux1247_769;
if(NULLP(list_48)){
aux1247_769 = string2019___r4_strings_6_7;
}
 else {
obj_t aux1670_1192;
aux1670_1192 = loop___r4_strings_6_7(list_48);
if(STRINGP(aux1670_1192)){
aux1247_769 = aux1670_1192;
}
 else {
bigloo_type_error_location_103___error(symbol2018___r4_strings_6_7, string1974___r4_strings_6_7, aux1670_1192, string1967___r4_strings_6_7, BINT(((long)14084)));
exit( -1 );}
}
POP_TRACE();
return aux1247_769;
}
}
}
}


/* loop */obj_t loop___r4_strings_6_7(obj_t list_245)
{
{
bool_t test1025_247;
{
obj_t arg1029_251;
{
obj_t pair_487;
if(PAIRP(list_245)){
pair_487 = list_245;
}
 else {
bigloo_type_error_location_103___error(symbol2020___r4_strings_6_7, string1966___r4_strings_6_7, list_245, string1967___r4_strings_6_7, BINT(((long)14123)));
exit( -1 );}
arg1029_251 = CDR(pair_487);
}
test1025_247 = NULLP(arg1029_251);
}
if(test1025_247){
obj_t pair_489;
if(PAIRP(list_245)){
pair_489 = list_245;
}
 else {
bigloo_type_error_location_103___error(symbol2020___r4_strings_6_7, string1966___r4_strings_6_7, list_245, string1967___r4_strings_6_7, BINT(((long)14142)));
exit( -1 );}
return CAR(pair_489);
}
 else {
obj_t arg1026_248;
obj_t arg1027_249;
{
obj_t pair_490;
if(PAIRP(list_245)){
pair_490 = list_245;
}
 else {
bigloo_type_error_location_103___error(symbol2020___r4_strings_6_7, string1966___r4_strings_6_7, list_245, string1967___r4_strings_6_7, BINT(((long)14177)));
exit( -1 );}
arg1026_248 = CAR(pair_490);
}
{
obj_t arg1028_250;
{
obj_t pair_491;
if(PAIRP(list_245)){
pair_491 = list_245;
}
 else {
bigloo_type_error_location_103___error(symbol2020___r4_strings_6_7, string1966___r4_strings_6_7, list_245, string1967___r4_strings_6_7, BINT(((long)14194)));
exit( -1 );}
arg1028_250 = CDR(pair_491);
}
arg1027_249 = loop___r4_strings_6_7(arg1028_250);
}
{
obj_t aux_2280;
obj_t aux_2274;
if(STRINGP(arg1027_249)){
aux_2280 = arg1027_249;
}
 else {
bigloo_type_error_location_103___error(symbol2020___r4_strings_6_7, string1974___r4_strings_6_7, arg1027_249, string1967___r4_strings_6_7, BINT(((long)14159)));
exit( -1 );}
if(STRINGP(arg1026_248)){
aux_2274 = arg1026_248;
}
 else {
bigloo_type_error_location_103___error(symbol2020___r4_strings_6_7, string1974___r4_strings_6_7, arg1026_248, string1967___r4_strings_6_7, BINT(((long)14159)));
exit( -1 );}
return string_append(aux_2274, aux_2280);
}
}
}
}


/* _string-append */obj_t _string_append_156___r4_strings_6_7(obj_t env_867, obj_t list_868)
{
return string_append_106___r4_strings_6_7(list_868);
}


/* list->string */obj_t list__string_78___r4_strings_6_7(obj_t list_49)
{
{
obj_t symbol1250_770;
symbol1250_770 = symbol2021___r4_strings_6_7;
{
PUSH_TRACE(symbol1250_770);
BUNSPEC;
{
obj_t aux1249_771;
{
long len_252;
len_252 = list_length(list_49);
{
obj_t string_253;
{
obj_t res1193_498;
{
long aux_2290;
{
int aux_2291;
aux_2291 = (int)(len_252);
aux_2290 = (long)(aux_2291);
}
res1193_498 = make_string(aux_2290, ((unsigned char)' '));
}
string_253 = res1193_498;
}
{
{
long i_254;
obj_t l_255;
i_254 = ((long)0);
l_255 = list_49;
loop_256:
if((i_254==len_252)){
aux1249_771 = string_253;
}
 else {
{
obj_t arg1031_258;
{
obj_t pair_501;
if(PAIRP(l_255)){
pair_501 = l_255;
}
 else {
bigloo_type_error_location_103___error(symbol2021___r4_strings_6_7, string1966___r4_strings_6_7, l_255, string1967___r4_strings_6_7, BINT(((long)14630)));
exit( -1 );}
arg1031_258 = CAR(pair_501);
}
{
unsigned char char_166_504;
{
obj_t aux_2303;
if(CHARP(arg1031_258)){
aux_2303 = arg1031_258;
}
 else {
bigloo_type_error_location_103___error(symbol2021___r4_strings_6_7, string1968___r4_strings_6_7, arg1031_258, string1967___r4_strings_6_7, BINT(((long)14607)));
exit( -1 );}
char_166_504 = (unsigned char)CCHAR(aux_2303);
}
{
bool_t test_2310;
{
long aux_2311;
aux_2311 = STRING_LENGTH(string_253);
test_2310 = BOUND_CHECK(i_254, aux_2311);
}
if(test_2310){
STRING_SET(string_253, i_254, char_166_504);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_254), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
}
}
{
long arg1032_259;
obj_t arg1033_260;
arg1032_259 = (i_254+((long)1));
{
obj_t pair_513;
if(PAIRP(l_255)){
pair_513 = l_255;
}
 else {
bigloo_type_error_location_103___error(symbol2021___r4_strings_6_7, string1966___r4_strings_6_7, l_255, string1967___r4_strings_6_7, BINT(((long)14657)));
exit( -1 );}
arg1033_260 = CDR(pair_513);
}
{
obj_t l_2326;
long i_2325;
i_2325 = arg1032_259;
l_2326 = arg1033_260;
l_255 = l_2326;
i_254 = i_2325;
goto loop_256;
}
}
}
}
}
}
}
POP_TRACE();
return aux1249_771;
}
}
}
}


/* _list->string */obj_t _list__string_5___r4_strings_6_7(obj_t env_869, obj_t list_870)
{
return list__string_78___r4_strings_6_7(list_870);
}


/* string->list */obj_t string__list_125___r4_strings_6_7(obj_t string_50)
{
{
obj_t symbol1252_772;
symbol1252_772 = symbol2022___r4_strings_6_7;
{
PUSH_TRACE(symbol1252_772);
BUNSPEC;
{
obj_t aux1251_773;
{
long i_263;
obj_t res_264;
{
long aux_2353;
aux_2353 = STRING_LENGTH(string_50);
i_263 = (aux_2353-((long)1));
}
res_264 = BNIL;
loop_265:
if((i_263==((long)-1))){
aux1251_773 = res_264;
}
 else {
long arg1039_269;
obj_t arg1040_270;
arg1039_269 = (i_263-((long)1));
{
unsigned char arg1041_271;
{
unsigned char res1194_529;
{
bool_t test_2333;
{
long aux_2334;
aux_2334 = STRING_LENGTH(string_50);
test_2333 = BOUND_CHECK(i_263, aux_2334);
}
if(test_2333){
res1194_529 = STRING_REF(string_50, i_263);
}
 else {
obj_t aux_2338;
{
obj_t aux1750_1264;
aux1750_1264 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_263), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1750_1264)){
aux_2338 = aux1750_1264;
}
 else {
bigloo_type_error_location_103___error(symbol2022___r4_strings_6_7, string1968___r4_strings_6_7, aux1750_1264, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
res1194_529 = (unsigned char)CCHAR(aux_2338);
}
}
arg1041_271 = res1194_529;
}
{
obj_t aux_2348;
aux_2348 = BCHAR(arg1041_271);
arg1040_270 = MAKE_PAIR(aux_2348, res_264);
}
}
{
obj_t res_2352;
long i_2351;
i_2351 = arg1039_269;
res_2352 = arg1040_270;
res_264 = res_2352;
i_263 = i_2351;
goto loop_265;
}
}
}
POP_TRACE();
return aux1251_773;
}
}
}
}


/* _string->list1297 */obj_t _string__list1297_184___r4_strings_6_7(obj_t env_871, obj_t string_872)
{
{
obj_t aux_2357;
if(STRINGP(string_872)){
aux_2357 = string_872;
}
 else {
bigloo_type_error_location_103___error(symbol2023___r4_strings_6_7, string1974___r4_strings_6_7, string_872, string1967___r4_strings_6_7, BINT(((long)14893)));
exit( -1 );}
return string__list_125___r4_strings_6_7(aux_2357);
}
}


/* string-copy */obj_t string_copy_207___r4_strings_6_7(obj_t string_51)
{
{
obj_t symbol1254_1595;
symbol1254_1595 = symbol2024___r4_strings_6_7;
{
PUSH_TRACE(symbol1254_1595);
BUNSPEC;
{
obj_t aux1253_1596;
{
char * aux_2365;
aux_2365 = BSTRING_TO_STRING(string_51);
aux1253_1596 = string_to_bstring(aux_2365);
}
POP_TRACE();
return aux1253_1596;
}
}
}
}


/* _string-copy1298 */obj_t _string_copy1298_57___r4_strings_6_7(obj_t env_873, obj_t string_874)
{
{
obj_t string_1597;
if(STRINGP(string_874)){
string_1597 = string_874;
}
 else {
bigloo_type_error_location_103___error(symbol2025___r4_strings_6_7, string1974___r4_strings_6_7, string_874, string1967___r4_strings_6_7, BINT(((long)15326)));
exit( -1 );}
{
obj_t symbol1254_1598;
symbol1254_1598 = symbol2024___r4_strings_6_7;
{
PUSH_TRACE(symbol1254_1598);
BUNSPEC;
{
obj_t aux1253_1599;
{
char * aux_2375;
aux_2375 = BSTRING_TO_STRING(string_1597);
aux1253_1599 = string_to_bstring(aux_2375);
}
POP_TRACE();
return aux1253_1599;
}
}
}
}
}


/* string-fill! */obj_t string_fill__51___r4_strings_6_7(obj_t string_52, unsigned char char_53)
{
{
obj_t symbol1256_776;
symbol1256_776 = symbol2026___r4_strings_6_7;
{
PUSH_TRACE(symbol1256_776);
BUNSPEC;
{
obj_t aux1255_777;
{
long len_272;
len_272 = STRING_LENGTH(string_52);
{
long i_273;
i_273 = ((long)0);
loop_274:
if((i_273==len_272)){
aux1255_777 = string_52;
}
 else {
{
bool_t test_2383;
{
long aux_2384;
aux_2384 = STRING_LENGTH(string_52);
test_2383 = BOUND_CHECK(i_273, aux_2384);
}
if(test_2383){
STRING_SET(string_52, i_273, char_53);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_273), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
{
long i_2391;
i_2391 = (i_273+((long)1));
i_273 = i_2391;
goto loop_274;
}
}
}
}
POP_TRACE();
return aux1255_777;
}
}
}
}


/* _string-fill!1299 */obj_t _string_fill_1299_168___r4_strings_6_7(obj_t env_875, obj_t string_876, obj_t char_877)
{
{
unsigned char aux_2400;
obj_t aux_2394;
{
obj_t aux_2401;
if(CHARP(char_877)){
aux_2401 = char_877;
}
 else {
bigloo_type_error_location_103___error(symbol2027___r4_strings_6_7, string1968___r4_strings_6_7, char_877, string1967___r4_strings_6_7, BINT(((long)15612)));
exit( -1 );}
aux_2400 = (unsigned char)CCHAR(aux_2401);
}
if(STRINGP(string_876)){
aux_2394 = string_876;
}
 else {
bigloo_type_error_location_103___error(symbol2027___r4_strings_6_7, string1974___r4_strings_6_7, string_876, string1967___r4_strings_6_7, BINT(((long)15612)));
exit( -1 );}
return string_fill__51___r4_strings_6_7(aux_2394, aux_2400);
}
}


/* string-upcase */obj_t string_upcase_71___r4_strings_6_7(obj_t string_54)
{
{
obj_t symbol1258_778;
symbol1258_778 = symbol2028___r4_strings_6_7;
{
PUSH_TRACE(symbol1258_778);
BUNSPEC;
{
obj_t aux1257_779;
{
long len_277;
len_277 = STRING_LENGTH(string_54);
{
obj_t res_278;
{
obj_t res1195_553;
{
long aux_2411;
{
int aux_2412;
aux_2412 = (int)(len_277);
aux_2411 = (long)(aux_2412);
}
res1195_553 = make_string(aux_2411, ((unsigned char)' '));
}
res_278 = res1195_553;
}
{
{
long i_279;
i_279 = ((long)0);
loop_280:
if((i_279==len_277)){
aux1257_779 = res_278;
}
 else {
{
unsigned char arg1045_282;
{
unsigned char arg1046_283;
{
unsigned char res1196_564;
{
bool_t test_2418;
{
long aux_2419;
aux_2419 = STRING_LENGTH(string_54);
test_2418 = BOUND_CHECK(i_279, aux_2419);
}
if(test_2418){
res1196_564 = STRING_REF(string_54, i_279);
}
 else {
obj_t aux_2423;
{
obj_t aux1804_1306;
aux1804_1306 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_279), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1804_1306)){
aux_2423 = aux1804_1306;
}
 else {
bigloo_type_error_location_103___error(symbol2028___r4_strings_6_7, string1968___r4_strings_6_7, aux1804_1306, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
res1196_564 = (unsigned char)CCHAR(aux_2423);
}
}
arg1046_283 = res1196_564;
}
arg1045_282 = toupper(arg1046_283);
}
{
bool_t test_2434;
{
long aux_2435;
aux_2435 = STRING_LENGTH(res_278);
test_2434 = BOUND_CHECK(i_279, aux_2435);
}
if(test_2434){
STRING_SET(res_278, i_279, arg1045_282);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_279), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
}
{
long i_2442;
i_2442 = (i_279+((long)1));
i_279 = i_2442;
goto loop_280;
}
}
}
}
}
}
POP_TRACE();
return aux1257_779;
}
}
}
}


/* _string-upcase1300 */obj_t _string_upcase1300_68___r4_strings_6_7(obj_t env_878, obj_t string_879)
{
{
obj_t aux_2445;
if(STRINGP(string_879)){
aux_2445 = string_879;
}
 else {
bigloo_type_error_location_103___error(symbol2029___r4_strings_6_7, string1974___r4_strings_6_7, string_879, string1967___r4_strings_6_7, BINT(((long)16031)));
exit( -1 );}
return string_upcase_71___r4_strings_6_7(aux_2445);
}
}


/* string-downcase */obj_t string_downcase_77___r4_strings_6_7(obj_t string_55)
{
{
obj_t symbol1260_780;
symbol1260_780 = symbol2030___r4_strings_6_7;
{
PUSH_TRACE(symbol1260_780);
BUNSPEC;
{
obj_t aux1259_781;
{
long len_286;
len_286 = STRING_LENGTH(string_55);
{
obj_t res_287;
{
obj_t res1197_584;
{
long aux_2454;
{
int aux_2455;
aux_2455 = (int)(len_286);
aux_2454 = (long)(aux_2455);
}
res1197_584 = make_string(aux_2454, ((unsigned char)' '));
}
res_287 = res1197_584;
}
{
{
long i_288;
i_288 = ((long)0);
loop_289:
if((i_288==len_286)){
aux1259_781 = res_287;
}
 else {
{
unsigned char arg1050_291;
{
unsigned char arg1051_292;
{
unsigned char res1198_595;
{
bool_t test_2461;
{
long aux_2462;
aux_2462 = STRING_LENGTH(string_55);
test_2461 = BOUND_CHECK(i_288, aux_2462);
}
if(test_2461){
res1198_595 = STRING_REF(string_55, i_288);
}
 else {
obj_t aux_2466;
{
obj_t aux1831_1330;
aux1831_1330 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_288), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1831_1330)){
aux_2466 = aux1831_1330;
}
 else {
bigloo_type_error_location_103___error(symbol2030___r4_strings_6_7, string1968___r4_strings_6_7, aux1831_1330, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
res1198_595 = (unsigned char)CCHAR(aux_2466);
}
}
arg1051_292 = res1198_595;
}
arg1050_291 = tolower(arg1051_292);
}
{
bool_t test_2477;
{
long aux_2478;
aux_2478 = STRING_LENGTH(res_287);
test_2477 = BOUND_CHECK(i_288, aux_2478);
}
if(test_2477){
STRING_SET(res_287, i_288, arg1050_291);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_288), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
}
{
long i_2485;
i_2485 = (i_288+((long)1));
i_288 = i_2485;
goto loop_289;
}
}
}
}
}
}
POP_TRACE();
return aux1259_781;
}
}
}
}


/* _string-downcase1301 */obj_t _string_downcase1301_196___r4_strings_6_7(obj_t env_880, obj_t string_881)
{
{
obj_t aux_2488;
if(STRINGP(string_881)){
aux_2488 = string_881;
}
 else {
bigloo_type_error_location_103___error(symbol2031___r4_strings_6_7, string1974___r4_strings_6_7, string_881, string1967___r4_strings_6_7, BINT(((long)16499)));
exit( -1 );}
return string_downcase_77___r4_strings_6_7(aux_2488);
}
}


/* string-upcase! */obj_t string_upcase__158___r4_strings_6_7(obj_t string_56)
{
{
obj_t symbol1262_782;
symbol1262_782 = symbol2032___r4_strings_6_7;
{
PUSH_TRACE(symbol1262_782);
BUNSPEC;
{
obj_t aux1261_783;
{
long len_295;
len_295 = STRING_LENGTH(string_56);
{
{
long i_297;
i_297 = ((long)0);
loop_298:
if((i_297==len_295)){
aux1261_783 = string_56;
}
 else {
{
unsigned char arg1056_300;
{
unsigned char arg1057_301;
{
unsigned char res1199_619;
{
bool_t test_2499;
{
long aux_2500;
aux_2500 = STRING_LENGTH(string_56);
test_2499 = BOUND_CHECK(i_297, aux_2500);
}
if(test_2499){
res1199_619 = STRING_REF(string_56, i_297);
}
 else {
obj_t aux_2504;
{
obj_t aux1848_1342;
aux1848_1342 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_297), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1848_1342)){
aux_2504 = aux1848_1342;
}
 else {
bigloo_type_error_location_103___error(symbol2032___r4_strings_6_7, string1968___r4_strings_6_7, aux1848_1342, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
res1199_619 = (unsigned char)CCHAR(aux_2504);
}
}
arg1057_301 = res1199_619;
}
arg1056_300 = toupper(arg1057_301);
}
{
bool_t test_2515;
{
long aux_2516;
aux_2516 = STRING_LENGTH(string_56);
test_2515 = BOUND_CHECK(i_297, aux_2516);
}
if(test_2515){
STRING_SET(string_56, i_297, arg1056_300);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_297), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
}
{
long i_2523;
i_2523 = (i_297+((long)1));
i_297 = i_2523;
goto loop_298;
}
}
}
}
}
POP_TRACE();
return aux1261_783;
}
}
}
}


/* _string-upcase!1302 */obj_t _string_upcase_1302_80___r4_strings_6_7(obj_t env_882, obj_t string_883)
{
{
obj_t aux_2526;
if(STRINGP(string_883)){
aux_2526 = string_883;
}
 else {
bigloo_type_error_location_103___error(symbol2033___r4_strings_6_7, string1974___r4_strings_6_7, string_883, string1967___r4_strings_6_7, BINT(((long)16971)));
exit( -1 );}
return string_upcase__158___r4_strings_6_7(aux_2526);
}
}


/* string-downcase! */obj_t string_downcase__42___r4_strings_6_7(obj_t string_57)
{
{
obj_t symbol1264_784;
symbol1264_784 = symbol2034___r4_strings_6_7;
{
PUSH_TRACE(symbol1264_784);
BUNSPEC;
{
obj_t aux1263_785;
{
long len_303;
len_303 = STRING_LENGTH(string_57);
{
{
long i_305;
i_305 = ((long)0);
loop_306:
if((i_305==len_303)){
aux1263_785 = string_57;
}
 else {
{
unsigned char arg1060_308;
{
unsigned char arg1061_309;
{
unsigned char res1200_643;
{
bool_t test_2537;
{
long aux_2538;
aux_2538 = STRING_LENGTH(string_57);
test_2537 = BOUND_CHECK(i_305, aux_2538);
}
if(test_2537){
res1200_643 = STRING_REF(string_57, i_305);
}
 else {
obj_t aux_2542;
{
obj_t aux1860_1354;
aux1860_1354 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_305), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1860_1354)){
aux_2542 = aux1860_1354;
}
 else {
bigloo_type_error_location_103___error(symbol2034___r4_strings_6_7, string1968___r4_strings_6_7, aux1860_1354, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
res1200_643 = (unsigned char)CCHAR(aux_2542);
}
}
arg1061_309 = res1200_643;
}
arg1060_308 = tolower(arg1061_309);
}
{
bool_t test_2553;
{
long aux_2554;
aux_2554 = STRING_LENGTH(string_57);
test_2553 = BOUND_CHECK(i_305, aux_2554);
}
if(test_2553){
STRING_SET(string_57, i_305, arg1060_308);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_305), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
}
{
long i_2561;
i_2561 = (i_305+((long)1));
i_305 = i_2561;
goto loop_306;
}
}
}
}
}
POP_TRACE();
return aux1263_785;
}
}
}
}


/* _string-downcase!1303 */obj_t _string_downcase_1303_160___r4_strings_6_7(obj_t env_884, obj_t string_885)
{
{
obj_t aux_2564;
if(STRINGP(string_885)){
aux_2564 = string_885;
}
 else {
bigloo_type_error_location_103___error(symbol2035___r4_strings_6_7, string1974___r4_strings_6_7, string_885, string1967___r4_strings_6_7, BINT(((long)17429)));
exit( -1 );}
return string_downcase__42___r4_strings_6_7(aux_2564);
}
}


/* string-capitalize! */obj_t string_capitalize__136___r4_strings_6_7(obj_t string_58)
{
{
obj_t symbol1266_786;
symbol1266_786 = symbol2036___r4_strings_6_7;
{
PUSH_TRACE(symbol1266_786);
BUNSPEC;
{
obj_t aux1265_787;
{
bool_t non_first_alpha_60_311;
long string_len_173_312;
non_first_alpha_60_311 = ((bool_t)0);
string_len_173_312 = STRING_LENGTH(string_58);
{
long i_314;
i_314 = ((long)0);
do_loop__1002_81_322:
if((i_314==string_len_173_312)){
aux1265_787 = string_58;
}
 else {
{
unsigned char c_317;
{
unsigned char res1201_667;
{
bool_t test_2575;
{
long aux_2576;
aux_2576 = STRING_LENGTH(string_58);
test_2575 = BOUND_CHECK(i_314, aux_2576);
}
if(test_2575){
res1201_667 = STRING_REF(string_58, i_314);
}
 else {
obj_t aux_2580;
{
obj_t aux1872_1366;
aux1872_1366 = debug_error_location_199___error(string1976___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_314), string1978___r4_strings_6_7, BINT(((long)7610)));
if(CHARP(aux1872_1366)){
aux_2580 = aux1872_1366;
}
 else {
bigloo_type_error_location_103___error(symbol2036___r4_strings_6_7, string1968___r4_strings_6_7, aux1872_1366, string1978___r4_strings_6_7, BINT(((long)7610)));
exit( -1 );}
}
res1201_667 = (unsigned char)CCHAR(aux_2580);
}
}
c_317 = res1201_667;
}
{
bool_t test_2590;
{
unsigned char c_669;
c_669 = toupper(c_317);
if((c_669>=((unsigned char)'A'))){
test_2590 = (c_669<=((unsigned char)'Z'));
}
 else {
test_2590 = ((bool_t)0);
}
}
if(test_2590){
if(non_first_alpha_60_311){
bool_t test_2596;
{
long aux_2597;
aux_2597 = STRING_LENGTH(string_58);
test_2596 = BOUND_CHECK(i_314, aux_2597);
}
if(test_2596){
unsigned char aux_2600;
aux_2600 = tolower(c_317);
STRING_SET(string_58, i_314, aux_2600);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_314), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
 else {
non_first_alpha_60_311 = ((bool_t)1);
{
bool_t test_2606;
{
long aux_2607;
aux_2607 = STRING_LENGTH(string_58);
test_2606 = BOUND_CHECK(i_314, aux_2607);
}
if(test_2606){
unsigned char aux_2610;
aux_2610 = toupper(c_317);
STRING_SET(string_58, i_314, aux_2610);
}
 else {
debug_error_location_199___error(string1982___r4_strings_6_7, string1977___r4_strings_6_7, BINT(i_314), string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
}
}
 else {
non_first_alpha_60_311 = ((bool_t)0);
}
}
}
{
long i_2616;
i_2616 = (i_314+((long)1));
i_314 = i_2616;
goto do_loop__1002_81_322;
}
}
}
}
POP_TRACE();
return aux1265_787;
}
}
}
}


/* _string-capitalize!1304 */obj_t _string_capitalize_1304_183___r4_strings_6_7(obj_t env_886, obj_t string_887)
{
{
obj_t aux_2619;
if(STRINGP(string_887)){
aux_2619 = string_887;
}
 else {
bigloo_type_error_location_103___error(symbol2037___r4_strings_6_7, string1974___r4_strings_6_7, string_887, string1967___r4_strings_6_7, BINT(((long)18187)));
exit( -1 );}
return string_capitalize__136___r4_strings_6_7(aux_2619);
}
}


/* string-capitalize */obj_t string_capitalize_230___r4_strings_6_7(obj_t string_59)
{
{
obj_t symbol1268_788;
symbol1268_788 = symbol2038___r4_strings_6_7;
{
PUSH_TRACE(symbol1268_788);
BUNSPEC;
{
obj_t aux1267_789;
{
obj_t arg1069_699;
{
char * aux_2627;
aux_2627 = BSTRING_TO_STRING(string_59);
arg1069_699 = string_to_bstring(aux_2627);
}
aux1267_789 = string_capitalize__136___r4_strings_6_7(arg1069_699);
}
POP_TRACE();
return aux1267_789;
}
}
}
}


/* _string-capitalize1305 */obj_t _string_capitalize1305_146___r4_strings_6_7(obj_t env_888, obj_t string_889)
{
{
obj_t aux_2632;
if(STRINGP(string_889)){
aux_2632 = string_889;
}
 else {
bigloo_type_error_location_103___error(symbol2039___r4_strings_6_7, string1974___r4_strings_6_7, string_889, string1967___r4_strings_6_7, BINT(((long)18850)));
exit( -1 );}
return string_capitalize_230___r4_strings_6_7(aux_2632);
}
}


/* string-for-read */obj_t string_for_read_25___r4_strings_6_7(obj_t string_60)
{
{
obj_t symbol1270_1600;
symbol1270_1600 = symbol2040___r4_strings_6_7;
{
PUSH_TRACE(symbol1270_1600);
BUNSPEC;
{
obj_t aux1269_1601;
aux1269_1601 = string_for_read(string_60);
POP_TRACE();
return aux1269_1601;
}
}
}
}


/* _string-for-read1306 */obj_t _string_for_read1306_207___r4_strings_6_7(obj_t env_890, obj_t string_891)
{
{
obj_t string_1602;
if(STRINGP(string_891)){
string_1602 = string_891;
}
 else {
bigloo_type_error_location_103___error(symbol2041___r4_strings_6_7, string1974___r4_strings_6_7, string_891, string1967___r4_strings_6_7, BINT(((long)19154)));
exit( -1 );}
{
obj_t symbol1270_1603;
symbol1270_1603 = symbol2040___r4_strings_6_7;
{
PUSH_TRACE(symbol1270_1603);
BUNSPEC;
{
obj_t aux1269_1604;
aux1269_1604 = string_for_read(string_1602);
POP_TRACE();
return aux1269_1604;
}
}
}
}
}


/* blit-string-ur! */obj_t blit_string_ur__74___r4_strings_6_7(obj_t s1_61, obj_t o1_62, obj_t s2_63, obj_t o2_64, obj_t l_65)
{
{
obj_t symbol1272_1605;
symbol1272_1605 = symbol2042___r4_strings_6_7;
{
PUSH_TRACE(symbol1272_1605);
BUNSPEC;
{
obj_t aux1271_1606;
aux1271_1606 = blit_string(s1_61, o1_62, s2_63, o2_64, l_65);
POP_TRACE();
return aux1271_1606;
}
}
}
}


/* _blit-string-ur!1307 */obj_t _blit_string_ur_1307_184___r4_strings_6_7(obj_t env_892, obj_t s1_893, obj_t o1_894, obj_t s2_895, obj_t o2_896, obj_t l_897)
{
{
obj_t s1_1607;
obj_t o1_1608;
obj_t s2_1609;
obj_t o2_1610;
obj_t l_1611;
if(STRINGP(s1_893)){
s1_1607 = s1_893;
}
 else {
bigloo_type_error_location_103___error(symbol2043___r4_strings_6_7, string1974___r4_strings_6_7, s1_893, string1967___r4_strings_6_7, BINT(((long)19448)));
exit( -1 );}
if(INTEGERP(o1_894)){
o1_1608 = o1_894;
}
 else {
bigloo_type_error_location_103___error(symbol2043___r4_strings_6_7, string2044___r4_strings_6_7, o1_894, string1967___r4_strings_6_7, BINT(((long)19448)));
exit( -1 );}
if(STRINGP(s2_895)){
s2_1609 = s2_895;
}
 else {
bigloo_type_error_location_103___error(symbol2043___r4_strings_6_7, string1974___r4_strings_6_7, s2_895, string1967___r4_strings_6_7, BINT(((long)19448)));
exit( -1 );}
if(INTEGERP(o2_896)){
o2_1610 = o2_896;
}
 else {
bigloo_type_error_location_103___error(symbol2043___r4_strings_6_7, string2044___r4_strings_6_7, o2_896, string1967___r4_strings_6_7, BINT(((long)19448)));
exit( -1 );}
if(INTEGERP(l_897)){
l_1611 = l_897;
}
 else {
bigloo_type_error_location_103___error(symbol2043___r4_strings_6_7, string2044___r4_strings_6_7, l_897, string1967___r4_strings_6_7, BINT(((long)19448)));
exit( -1 );}
{
obj_t symbol1272_1612;
symbol1272_1612 = symbol2042___r4_strings_6_7;
{
PUSH_TRACE(symbol1272_1612);
BUNSPEC;
{
obj_t aux1271_1613;
aux1271_1613 = blit_string(s1_1607, o1_1608, s2_1609, o2_1610, l_1611);
POP_TRACE();
return aux1271_1613;
}
}
}
}
}


/* blit-string! */obj_t blit_string__141___r4_strings_6_7(obj_t s1_66, obj_t o1_67, obj_t s2_68, obj_t o2_69, obj_t l_70)
{
{
obj_t symbol1274_794;
symbol1274_794 = symbol2045___r4_strings_6_7;
{
PUSH_TRACE(symbol1274_794);
BUNSPEC;
{
obj_t aux1273_795;
{
bool_t test_2682;
{
bool_t test_2683;
{
long aux_2690;
long aux_2684;
{
long aux_2691;
aux_2691 = STRING_LENGTH(s1_66);
aux_2690 = (aux_2691+((long)1));
}
{
long aux_2687;
long aux_2685;
aux_2687 = (long)CINT(o1_67);
aux_2685 = (long)CINT(l_70);
aux_2684 = (aux_2685+aux_2687);
}
test_2683 = BOUND_CHECK(aux_2684, aux_2690);
}
if(test_2683){
long aux_2701;
long aux_2695;
{
long aux_2702;
aux_2702 = STRING_LENGTH(s2_68);
aux_2701 = (aux_2702+((long)1));
}
{
long aux_2698;
long aux_2696;
aux_2698 = (long)CINT(o2_69);
aux_2696 = (long)CINT(l_70);
aux_2695 = (aux_2696+aux_2698);
}
test_2682 = BOUND_CHECK(aux_2695, aux_2701);
}
 else {
test_2682 = ((bool_t)0);
}
}
if(test_2682){
aux1273_795 = blit_string(s1_66, o1_67, s2_68, o2_69, l_70);
}
 else {
obj_t arg1076_327;
{
long arg1077_328;
long arg1078_329;
arg1077_328 = STRING_LENGTH(s1_66);
arg1078_329 = STRING_LENGTH(s2_68);
{
obj_t list1079_330;
{
obj_t arg1080_331;
{
obj_t arg1081_332;
{
obj_t arg1082_333;
{
obj_t arg1083_334;
arg1083_334 = MAKE_PAIR(l_70, BNIL);
arg1082_333 = MAKE_PAIR(o2_69, arg1083_334);
}
{
obj_t aux_2711;
aux_2711 = BINT(arg1078_329);
arg1081_332 = MAKE_PAIR(aux_2711, arg1082_333);
}
}
arg1080_331 = MAKE_PAIR(o1_67, arg1081_332);
}
{
obj_t aux_2715;
aux_2715 = BINT(arg1077_328);
list1079_330 = MAKE_PAIR(aux_2715, arg1080_331);
}
}
arg1076_327 = list1079_330;
}
}
aux1273_795 = debug_error_location_199___error(string2046___r4_strings_6_7, string2047___r4_strings_6_7, arg1076_327, string1978___r4_strings_6_7, BINT(((long)7610)));
}
}
POP_TRACE();
return aux1273_795;
}
}
}
}


/* _blit-string!1308 */obj_t _blit_string_1308_192___r4_strings_6_7(obj_t env_898, obj_t s1_899, obj_t o1_900, obj_t s2_901, obj_t o2_902, obj_t l_903)
{
{
obj_t aux_2745;
obj_t aux_2739;
obj_t aux_2733;
obj_t aux_2727;
obj_t aux_2721;
if(INTEGERP(l_903)){
aux_2745 = l_903;
}
 else {
bigloo_type_error_location_103___error(symbol2048___r4_strings_6_7, string2044___r4_strings_6_7, l_903, string1967___r4_strings_6_7, BINT(((long)19752)));
exit( -1 );}
if(INTEGERP(o2_902)){
aux_2739 = o2_902;
}
 else {
bigloo_type_error_location_103___error(symbol2048___r4_strings_6_7, string2044___r4_strings_6_7, o2_902, string1967___r4_strings_6_7, BINT(((long)19752)));
exit( -1 );}
if(STRINGP(s2_901)){
aux_2733 = s2_901;
}
 else {
bigloo_type_error_location_103___error(symbol2048___r4_strings_6_7, string1974___r4_strings_6_7, s2_901, string1967___r4_strings_6_7, BINT(((long)19752)));
exit( -1 );}
if(INTEGERP(o1_900)){
aux_2727 = o1_900;
}
 else {
bigloo_type_error_location_103___error(symbol2048___r4_strings_6_7, string2044___r4_strings_6_7, o1_900, string1967___r4_strings_6_7, BINT(((long)19752)));
exit( -1 );}
if(STRINGP(s1_899)){
aux_2721 = s1_899;
}
 else {
bigloo_type_error_location_103___error(symbol2048___r4_strings_6_7, string1974___r4_strings_6_7, s1_899, string1967___r4_strings_6_7, BINT(((long)19752)));
exit( -1 );}
return blit_string__141___r4_strings_6_7(aux_2721, aux_2727, aux_2733, aux_2739, aux_2745);
}
}


/* imported-modules-init */obj_t imported_modules_init_94___r4_strings_6_7()
{
{
obj_t symbol1276_796;
symbol1276_796 = symbol2049___r4_strings_6_7;
{
PUSH_TRACE(symbol1276_796);
BUNSPEC;
{
obj_t aux1275_797;
aux1275_797 = module_initialization_70___error(((long)0), "__R4_STRINGS_6_7");
POP_TRACE();
return aux1275_797;
}
}
}
}

