;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/wind.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar  8 19:31:00 1998                          */
;*    Last change :  Wed Apr  1 14:11:23 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Wind test (dynamic-wind and unwind-protect).                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module wind
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-wind)))

;*---------------------------------------------------------------------*/
;*    A global variable                                                */
;*---------------------------------------------------------------------*/
(define *kont* #unspecified)

;*---------------------------------------------------------------------*/
;*    test-wind ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-wind)
   (test-module "wind" "wind.scm")
   (let ((exg *exitd-top*))
      (test "unwind-protect"
	    (let ((x 3))
	       (call/cc (lambda (exit)
			   (unwind-protect
			      (begin
				 (set! x (+ 1 x))
				 (exit (begin (set! x (+ 1 x)) x))
				 (set! x (+ 1 x)))
			      (set! x (+ 1 x)))))
	       x)
	    6)
      (let ((ex *exitd-top*))
	 (test "unwind-protect"
	       (let* ((x     10)
		      (value (unwind-protect
				(call/cc (lambda (exit)
					    (begin
					       (set! x (+ 1 x))
					       (set! *kont* exit)
					       (set! x (+ 1 x)))))
				(set! x (+ 1 x)))))
		  (if (not (eq? value 4))
		      (*kont* 4)
		      x))
	       14)
	 (test "unwind-protect" ex *exitd-top*)
	 (test "unwind-protect"
	       (let* ((x     10)
		      (value (unwind-protect
				(call/cc (lambda (exit)
					    (begin
					       (set! x (+ 1 x))
					       (set! *kont* exit)
					       (set! x (+ 1 x)))))
				(set! x (+ 1 x)))))
		  (if (not (eq? value 4))
		      (*kont* 4)
		      x))
	       14)
	 (test "unwind-protect" ex *exitd-top*))
      (test "dynamic-wind"
	    (let ((path '())
		  (c    #f))
	       (let ((add (lambda (s) (set! path (cons s path)))))
		  (dynamic-wind
		   (lambda () (add 'connect))
		   (lambda ()
		      (add (call/cc
			    (lambda (c0)
			       (set! c c0)
			       'talk1))))
		   (lambda ()
		      (add 'disconnect)))
		  (if (< (length path) 4)
		      (c 'talk2)
		      (reverse path))))
	    (let ((path '())
		  (c    #f))
	       (let ((add (lambda (s) (set! path (cons s path)))))
		  (dynamic-wind
		   (lambda () (add 'connect))
		   (lambda ()
		      (add (call/cc
			    (lambda (c0)
			       (set! c c0)
			       'talk1))))
		   (lambda ()
		      (add 'disconnect)))
		  (if (< (length path) 4)
		      (c 'talk2)
		      (reverse path)))))
      (test "dynamic-wind"
	    (let ((path '())
		  (c    #f))
	       (let ((add (lambda (s) (set! path (cons s path)))))
		  (dynamic-wind
		   (lambda () (add 'connect))
		   (lambda ()
		      (add (call/cc
			    (lambda (c0)
			       (set! c c0)
			       'talk1))))
		   (lambda ()
		      (add 'disconnect)))
		  (if (< (length path) 4)
		      (c 'talk2)
		      (reverse path))))
	    '(CONNECT TALK1 DISCONNECT CONNECT TALK2 DISCONNECT))
      (test "dynamic-wind" exg *exitd-top*)))

