;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/vital.scm                    */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov  2 17:35:36 1992                          */
;*    Last change :  Mon Sep 21 16:39:20 1998 (serrano)                */
;*                                                                     */
;*    On tests les choses qui sont vraiment vital et sans lesquelles   */
;*    on ne peut rien faire du tout.                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module vital
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-vital))
   (static  var))

;*---------------------------------------------------------------------*/
;*    var ...                                                          */
;*---------------------------------------------------------------------*/
(define var var)

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define (bar . l)
   l)

(set! bar 'toto)

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define (foo x)
   (if (integer? x)
       (begin
	  (set! x #f)
	  (integer? x))
       #t))

;*---------------------------------------------------------------------*/
;*    vital:write ...                                                  */
;*---------------------------------------------------------------------*/
(define (vital:write s)
   (let ((p (open-output-string)))
      (write s p)
      (let* ((s (close-output-port p))
	     (p (open-input-string s)))
	 (let ((res (read p)))
	    (close-input-port p)
	    res))))

;*---------------------------------------------------------------------*/
;*    vital:hoist ...                                                  */
;*---------------------------------------------------------------------*/
(define cur_ref (make-cell 0))

(define (vital:hoist)
   (let ((x1 (let ((x2 (cell-ref cur_ref)))
		(begin
		   (cell-set! cur_ref (+fx x2 1))
		   x2)))
	 (x2 (let ((x2 (cell-ref cur_ref)))
		(begin
		   (cell-set! cur_ref (+fx x2 1))
		   x2))))
      (eq? x1 x2)))

;*---------------------------------------------------------------------*/
;*    Un bug dans le soft-typing (un truc qui ne se compilait pas).    */
;*---------------------------------------------------------------------*/
(let ((revtype2
       (labels ((revtype (parent t flag)
                         (let ((rev (lambda (q)
                                       (revtype t q #f))))
                            (if flag (rev 1)))))
          revtype)))
   (revtype2 1 2 #f))

;*---------------------------------------------------------------------*/
;*    producer ...                                                     */
;*---------------------------------------------------------------------*/
(define (producer a b)
   (values (+ a 1) (+ b 1)))
   
;*---------------------------------------------------------------------*/
;*    Top level definition orders                                      */
;*---------------------------------------------------------------------*/
(define order_foo 0)
(define order_foo1 (begin (set! order_foo (+fx order_foo 1)) order_foo))
(define order_foo2 (begin (set! order_foo (+fx order_foo 1)) order_foo))
(begin
   (define order_foo3 (begin (set! order_foo (+fx order_foo 1)) order_foo))
   (define order_foo4 (begin (set! order_foo (+fx order_foo 1)) order_foo)))
(define order_foo5 (begin (set! order_foo (+fx order_foo 1)) order_foo))

(define order_bar 0)
(define order_bar1 1)
(define order_bar2 1)
(define order_bar3 1)
(define order_bar4 1)
(define order_bar5 1)
(define order_bar6 1)
(define order_bar7 1)
(define order_bar8 1)

(begin
   (begin
      (begin
	 (set! order_bar (+fx order_bar 1))
	 (set! order_bar1 order_bar)
	 (set! order_bar (+fx order_bar 1))
	 (set! order_bar2 order_bar))
      (begin
	 (set! order_bar (+fx order_bar 1))
	 (set! order_bar3 order_bar)
	 (set! order_bar (+fx order_bar 1))
	 (set! order_bar4 order_bar))
      (set! order_bar (+fx order_bar 1))
      (set! order_bar5 order_bar)
      (set! order_bar (+fx order_bar 1))
      (set! order_bar6 order_bar))
   (set! order_bar (+fx order_bar 1))
   (set! order_bar7 order_bar)
   (set! order_bar (+fx order_bar 1))
   (set! order_bar8 order_bar))

;*---------------------------------------------------------------------*/
;*    point                                                            */
;*---------------------------------------------------------------------*/
(define-struct point x y)

;*---------------------------------------------------------------------*/
;*    inline/class/generic                                             */
;*---------------------------------------------------------------------*/
(define-inline (inline x) x)
(define-inline (class x) x)
(define-inline (generic x) x)

;*---------------------------------------------------------------------*/
;*    test-vital ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-vital)
   (test-module "vital" "vital.scm")
   (test "true" #t (not #f))
   (test "true" #t (not (not 4)))
   (test "true" (not (eq? #t #f)) (not #f))
   (test "false" #f (not #t))
   (test "begin" (begin 4 5) 5)
   (test "eq?" 1 1)
   (test "< 0" -1 -1)
   (test "-" (- 2) -2)
   (test "*" (* 2 -1) -2)
   (test "eq? char" (eq? #\a #\a) #t)
   (test "eq? char" (eq? #\a #\A) #F)
   (test "eq? char" (char->integer #\') 39)
   (test "eq? symbol" (eq? 'a 'a) #t)
   (test "eq? symbol" (eq? 'a 'A) #t)
   (test "eq? symbol" (eq? 'a 'b) #f)
   (test "define" bar 'toto)
   (test "application" ((lambda args 2)) 2)
   (test "application" ((lambda args 2) 1 2 3 4) 2)
   (test "set!" (foo 5) #f)
   (test "set!" (let ((v (integer? var))) (set! var 4) v) #f)
   (test "symbol" 't (string->symbol "T"))
   (let ((s "toto\"\\\ntiti"))
      (test "write" (vital:write s) s))
   (test "flonum" (real? (string->obj (obj->string 0.5))) #t)
   (let* ((append! (lambda (x y)
		      (if (null? x)
			  y
			  (do ((a x b)
			       (b (cdr x) (cdr b)))
				((null? b)
				 (set-cdr! a y)
				 x)))))
	  (l1      '(1 2 3))
	  (l2      '(4 5 6)))
      (test "do" (append! l1 l2) '(1 2 3 4 5 6)))
   (test "let" (let ((x (begin 1 2 3))) x) 3)
   (test "hoist" (vital:hoist) #f)
   (let* ((s (make-string 3 #\a))
	  (l (list s s)))
      (test "string->obj" (string->obj (obj->string l)) l))
   (let* ((s    "toto n'est pas content")
	  (sp   "titi non plus")
	  (l    (list s s s sp sp s sp sp 'toto 'toto '#(1 2 3) #\a #\a #t #f))
	  (v    `#(,l ,l ,l () ,(unspecified) 1.13 1.13 #a123
		      (point 1 2) (point 2 1) #<0010> #<0011>))
	  (vec  (make-vector 3 v))
	  (rep  (obj->string v)))
      (test "intext" (string->obj rep) v))
   (test "top level forms" (list order_foo1
				 order_foo2
				 order_foo3
				 order_foo4
				 order_foo5)
	 '(1 2 3 4 5))
   (test "top level forms" (list order_bar1
				 order_bar2
				 order_bar3
				 order_bar4
				 order_bar5
				 order_bar6
				 order_bar7
				 order_bar8)
	 '(1 2 3 4 5 6 7 8))
   (test "multive-value-bind" (multiple-value-bind (a b c d)
				 (values 1 2 3 4)
				 (- a b c d))
	 -8)
   (test "multiple-value-bind"
	 (multiple-value-bind (x y) (producer 1 2) (+ x y))
	 5)
   (test "call-with-values" (call-with-values (lambda () (values 1 2 3 4))
					      (lambda (a b c d) (+ a b c d)))
	 10)
   (test "call-with-values" (call-with-values * -) -1)
   (let ((b (let ((ptr-align (pragma::long "PTR_ALIGNMENT")))
	       (-fx (bit-lsh 1 (+fx ptr-align 3)) ptr-align))))
      (test "<< >>"  (let ((n (bit-lsh 1 b))
			   (n-1 (bit-lsh 1 (-fx b 1)))
			   (n-2 (bit-lsh 1 (-fx b 2))))
			(and (>fx n n-1) (>fx n-1 n-2)))
	    #t)))
   
			     
		     


