;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/tail.scm                     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Sep  1 17:44:12 1992                          */
;*    Last change :  Wed Apr  1 14:10:56 1998 (serrano)                */
;*                                                                     */
;*    On test la facon de gerer les appels recursifs terminaux.        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    le module                                                        */
;*---------------------------------------------------------------------*/
(module tail
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-tail)))


;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1)
   (letrec ((loop (lambda (x y)
		     (if (eq? x 0)
			 y
			 (loop (- x 1) x)))))
      (loop 2 2)))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 x)
   (let* ((a   hux)
	  (fun (lambda (c) c)))
      (a (if x (fun 1) (fun 2)))))

(define (hux x)
   x)

;*---------------------------------------------------------------------*/
;*    test-tail ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-tail)
   (test-module "tail" "tail.scm")
   (test "tail" (test1) 1)
   (test "tail" (test2 #f) 2))

