;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/struct.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 09:42:44 1992                          */
;*    Last change :  Wed Apr  1 14:10:48 1998 (serrano)                */
;*                                                                     */
;*    On test le fonctionnement des structures                         */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module struct
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-struct)))

;*---------------------------------------------------------------------*/
;*    La structure ...                                                 */
;*---------------------------------------------------------------------*/
(define-struct structure x lambda y res)
(define-struct point x y z)

;*---------------------------------------------------------------------*/
;*    test-struct ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-struct)
   (test-module "struct" "struct.scm")
   (test "struct" (let ((s (make-structure '())))
		     (if (not (struct? s))
			 #f)
		     (structure-lambda-set! s (lambda (x y) (+ x y)))
		     (structure-x-set! s 1)
		     (structure-y-set! s 2)
		     (structure-res-set! s ((structure-lambda s)
					    (structure-x s)
					    (structure-y s)))
		     (structure-res s))
	 3)
   (let ((p1 (point 1 2 3))
	 (p2 (point 4 5 6)))
      (test "update!" (begin
			 (struct-update! p1 p2)
			 p1)
	    p2)))


