;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/rgc.scm                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Sep  8 11:03:03 1994                          */
;*    Last change :  Mon Sep 21 13:51:44 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Quelques tests d'rgc                                             */
;*=====================================================================*/


;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc)))

;; cette grammaire plante tous les bigloo (a la compilation)
;; jusqu'a la version 1.6c
(regular-grammar
      ((sign (in #\+ #\-))
       (optsign (>= 1 sign))
       (octdigit (in ("07"))))
   ((: #\0 optsign octdigit)
    0))

(regular-grammar ()
   ((: #\a (? #\b) #\c)
    0))

(regular-grammar ()
   ((: (? #\a) #\b #\c)
    0))

(regular-grammar ()
   ((: #\a #\b (? #\c))
    0))

;; une grammaire qui ne se compilait pas lors du permier boot de bigloo1.8
(define *std-grammar*
   (regular-grammar ((chiffre (in ("09")))
		     (lettre  (in ("azAZ") #a128 #a255))
		     (special (in "!@~$%^&*></.-_+\|=?:"))
		     (id      (: (or lettre chiffre special)
				 (* (or lettre chiffre special #\, #\' #\`)))))
      ((: #\# #\a chiffre chiffre chiffre)
       ;; character ascii forms
       0)
      ((: ";" (* all))
       ;; commets
       (ignore))
      ((: #\# (or id (: #\. (+ #\.))) #\()
       ;; typed vectors beginning
       1)
      (else
       2)))

(define *number*
   (regular-grammar ()
      ((: (submatch (+ digit)) "." (submatch (+ digit)))
       (cons (string->integer (the-submatch 1))
	     (string->integer (the-submatch 2))))))

(define (recette-suffix string)
   (string-case string
      ((: (* all) "." (submatch (+ (out "."))))
       (the-submatch 1))
      (else
       "")))

;*---------------------------------------------------------------------*/
;*    test-rgc ...                                                     */
;*---------------------------------------------------------------------*/
(define (test-rgc)
   (test-module "rgc" "rgc.scm")
   (test "submatch"
	 (read/rp *number* (open-input-string "3.1415"))
	 '(3 . 1415))
   (test "string-case" (recette-suffix "toto.org.scm") "scm"))
