;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/rgc-trap.scm                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May 24 14:24:02 1992                          */
;*    Last change :  Mon Sep 21 14:14:27 1998 (serrano)                */
;*                                                                     */
;*    Un essai de grammaire qui trappe                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc-trap
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc-trap)))

;*---------------------------------------------------------------------*/
;*    rgc-test ...                                                     */
;*---------------------------------------------------------------------*/
(define (rgc-test)
   (let ((ncontext      0)
	 (ntiti         0)
	 (neol          0)
	 (nbol          0)
	 (neof          0) 
	 (n             0))
      (let ((grammar (regular-grammar ((lettre  (in ("az"))))
			((+ (in #\space #\newline))
			 (set! n (+ (the-length) n))
			 (ignore))
			((when (rgc-context? 'titi) "titi")
			 (rgc-context)
			 (set! n (+ (the-length) n))
			 (set! ncontext (+ 1 ncontext))
			 (ignore))
			("titi"
			 (set! ntiti (+ 1 ntiti))
			 (set! n (+ (the-length) n)) 
			 (rgc-context 'titi)
			 (ignore))
			((eof "toto")
			 (set! n (+ (the-length) n))
			 (set! neof (+ 1 neof))
			 (ignore))
			((eol "toto")
			 (set! n (+ (the-length) n))
			 (set! neol (+ 1 neol))
			 (ignore))
			((bol "toto")
			 (set! nbol (+ 1 nbol))
			 (ignore))
			("toto"
			 (set! n (+ (the-length) n)) 
			 (ignore))
			((+ lettre)
			 (set! n (+ (the-length) n)) 
			 (ignore))
			(else
			 (the-failure)))))
	 (labels ((foo (port)
		       (let loop ((r (read/rp grammar port)))
			  (if (eof-object? r)
			      (list ncontext ntiti neol nbol neof n)
			      (loop (read/rp grammar port))))))
	    (call-with-input-file "misc/trap.txt" foo)))))
      
;*---------------------------------------------------------------------*/
;*    test-rgc-trap ...                                                */
;*---------------------------------------------------------------------*/
(define (test-rgc-trap)
   (test-module "rgc-trap" "rgc-trap.scm")
   (test "test" (rgc-test) '(3 3 3 3 1 66)))
