;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/rgc-jm.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 12:14:43 1992                          */
;*    Last change :  Mon Sep 21 14:14:21 1998 (serrano)                */
;*                                                                     */
;*    Un essai de grammaire de Jean-Marie qui faisait planter          */
;*    bigloov1.0                                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc-jm
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc-jm)))

;*---------------------------------------------------------------------*/
;*    test-rgc-jm ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-rgc-jm)
   (test-module "rgc-jm" "rgc-jm.scm")
   (test "rgc-jm" (let* ((level 0)
			 (my-grammar
			  (regular-grammar ((lpar (in #\( #\[ #\{))
					    (rpar (in #\) #\] #\})) )
			     (lpar
			      (the-string)
			      (set! level (+ level 1)))
			     (rpar
			      (the-string)
			      (set! level (- level 1))
			      'paren)
			     ((+ (out  #\( #\[ #\{ #\) #\] #\}))
			      (the-string))
			     (else (the-failure)))))
		     (with-input-from-file "misc/jm.txt"
			(lambda ()
			   (labels ((loop ()
			       (let ((c (read/rp my-grammar
						 (current-input-port))))
				  (if (eof-object? c)
				      level
				      (if (eq? c 'paren)
					  (loop)
					  (loop))))))
			      (loop)))))
	 7))



