;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/rgc-eval.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 28 08:54:00 1994                          */
;*    Last change :  Mon Sep 21 14:14:14 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On test rgc sous eval                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc-eval
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc-eval)))

;*---------------------------------------------------------------------*/
;*    Le test                                                          */
;*---------------------------------------------------------------------*/
(eval '(begin (define *char* 0)
	      (define *line* 0)
	      (define *word* 0)
	      (define g (regular-grammar ()
			   ((+ #\Newline)
			    (set! *char* (+fx *char* (the-length)))
			    (set! *line* (+fx *line* (the-length)))
			    'keep)
			   ((+ (in #\space #\tab))
			    (set! *char* (+fx *char* (the-length)))
			    'keep)
			   ((+ (out #\newline #\space #\tab))
			    (set! *char* (+fx *char* (the-length)))
			    (set! *word* (+fx 1 *word*))
			    'keep)
			   (else
			    (the-failure))))))

;*---------------------------------------------------------------------*/
;*    test-rgc-eval ...                                                */
;*---------------------------------------------------------------------*/
(define (test-rgc-eval)
   (test-module "rgc-eval" "rgc-eval.scm")
   (test "rgc-eval"
	 (eval '(let ((p (open-input-string #"toto \ntiti \ntutu")))
		   (let loop ((exp (read/rp g p)))
		      (if (eof-object? exp)
			  (list *char* *line* *word*)
			  (loop (read/rp g p))))))
	 '(16 2 3)))
 
 
