;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/read.scm                     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 22 16:17:03 1992                          */
;*    Last change :  Fri Sep 18 18:24:19 1998 (serrano)                */
;*                                                                     */
;*    Un essai de reader                                               */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-read)))
 
;*---------------------------------------------------------------------*/
;*    read-test ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-test port)
   (let ((npair   0)
	 (nint    0)
	 (nstring 0)
	 (nvector 0)
	 (nchar   0)
	 (nsymbol 0))
      (let loop ((sexp   (read port))
		 (n      0))
	 (if (eof-object? sexp)
	     (list nsymbol nchar nvector nstring nint npair n)
	     (begin
		(cond
		   ((pair? sexp)
		    (set! npair (+ 1 npair)))
		   ((integer? sexp)
		    (set! nint (+ 1 nint)))
		   ((string? sexp)
		    (set! nstring (+ 1 nstring)))
		   ((vector? sexp)
		    (set! nvector (+ 1 nvector)))
		   ((char? sexp)
		    (set! nchar (+ 1 nchar)))
		   (else
		    (set! nsymbol (+ 1 nsymbol))))
		(loop (read port)
		      (+ 1 n)))))))

;*---------------------------------------------------------------------*/
;*    test-read ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-read)
   (test-module "read" "read.scm")
   (test "test" (call-with-input-file "misc/input.txt" read-test)
	 '(16 2 2 5 2 6 33))
   (test "read" (cdr '((foo . bar) . hux)) 'hux))
		   

