;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/port.scm                     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May 24 10:56:01 1992                          */
;*    Last change :  Thu Oct 22 09:15:01 1998 (serrano)                */
;*                                                                     */
;*    On test les operations simples sur les ports                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module input-port
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-input-port)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1 port)
   (labels ((get-char (n)
		      (let loop ((i 1)
				 (r (read-char port)))
			 (if (= i n)
			     r
			     (loop (+ 1 i)
				   (read-char port)))))
	    (stole-char (n)
			(let loop ((i 1)
				   (r (peek-char port)))
			   (if (= i n)
			       r
			       (loop (+ 1 i)
				     (peek-char port))))))
      (get-char 10)
      (stole-char 10)
      (get-char 30)
      (stole-char 1) 
      (get-char 33)))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 string len)
   (let ((port (open-input-file string len)))
      (if (not (input-port? port))
	  #f
	  (labels ((get-char (n)
			     (let loop ((i 1)
					(r (read-char port)))
				(if (= i n)
				    r
				    (loop (+ 1 i)
					  (read-char port)))))
		   (stole-char (n)
			       (let loop ((i 1)
					  (r (peek-char port)))
				  (if (= i n)
				      r
				      (loop (+ 1 i)
					    (peek-char port))))))
	     (get-char 10)
	     (stole-char 10)
	     (get-char 30)
	     (stole-char 1)
	     (let ((res (get-char 33)))
		(close-input-port port)
		res)))))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test3 string)
   (let ((port (open-input-string string)))
      (let ((exp (read port)))
	 exp)))

;*---------------------------------------------------------------------*/
;*    test-input-port ...                                              */
;*---------------------------------------------------------------------*/
(define (test-input-port)
   (test-module "test-input-port" "port.scm")
   (test "input" (open-input-file "wrong") (input-port? #\space))
   (test "input" (call-with-input-file "misc/input.txt" test1) #\.)
   (test "input" (test2 "misc/input.txt" 10) #\.)
   (test "input-string" (test3 "(4 5 (3) #(1 2 3) \"toto\" titi)")
	 '(4 5 (3) #(1 2 3) "toto" titi))
   (let ((p (open-output-string)))
      (write #a012 p)
      (test "char" (close-output-port p) "#a012"))
   (let ((p (open-output-string)))
      (write #a179 p)
      (test "char" (close-output-port p) "#a179"))
   (let* ((stringa (make-string 1020 #\a))
	  (stringb (make-string 1020 #\b))
	  (stringc (make-string 1020 #\c))
	  (stringd (make-string 234 #\d))
	  (string  (string-append stringa stringb stringc stringd))
	  (port    (open-output-string))
	  (res     (begin (display string port) (close-output-port port))))
      (test "long write" res string))
   (let ((p (open-output-string)))
      (close-output-port p)
      (test "close port"
	    (try (write "stupid" p) (lambda (a b c d) (a #t)))
	    #t)))
