;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/object.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul 17 07:59:51 1996                          */
;*    Last change :  Sun May 17 15:49:49 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The object system tests                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module object
   (import  (main "main.scm")
	    (object2 "object2.scm")
	    (object1 "object1.scm"))
   (include "test.sch")
   (export  (test-object))
   (static  (final-class foo
	       x::long
	       (+ 3 y::string (default "yoyo"))
	       (* z::string (default "zozo")))
	    (class gee
	       x y)
	    (wide-class fool::foo (dummy (default 'dummy)))
	    (class titi
	       (x::int (default 666)))
	    (class toto::titi
	       y::char
	       (yy::char read-only)
	       (* z)
	       (+ 4 t)))
   (export (class value)
	   (class fin::value x)
	   (class sfin::fin y)
	   (class cfin::fin z))
   (static (final-class point (x (default 0)) (y (default 0)))
           (wide-class pointc::point (color (default 'black)))
           (wide-class point3::point (z (default 0)))
	   (class readc (* x read-only))))
 
;*---------------------------------------------------------------------*/
;*    access ...                                                       */
;*---------------------------------------------------------------------*/
(define (access)
   (let ((p (instantiate::point (x 1) (y 2))))
      (with-access::point p (x y)
	 (-fx y x))))

;*---------------------------------------------------------------------*/
;*    wide-dispatch ...                                                */
;*---------------------------------------------------------------------*/
(define (wide-dispatch)
   (let ((p (instantiate::point (x 1) (y 2))))
      (let ((r1 (do-point p)))
	 (widen!::pointc p)
	 (let ((r2 (do-point p)))
	    (shrink! p)
	    (widen!::point3 p (z 4))
	    (let ((r3 (do-point p)))
	       (shrink! p)
	       (let ((r4 (do-point p)))
		  (list r1 r2 r3 r4)))))))

(define-generic (do-point p)
   (error "do-point" "Argument not a point" p))

(define-method (do-point p::point)
   1)

(define-method (do-point p::pointc)
   (cons 2 (call-next-method)))

(define-method (do-point p::point3)
   (cons 3 (call-next-method)))

;*---------------------------------------------------------------------*/
;*    predicat ...                                                     */
;*---------------------------------------------------------------------*/
(define (predicat)
   (let ((val (instantiate::value))
	 (fin (instantiate::fin (x 1)))
	 (sfin (instantiate::sfin (x -1) (y 2)))
	 (cfin (instantiate::cfin (x -1) (z 3))))
      (list (value? val)
	    (value? fin) 
	    (value? sfin)
	    (value? cfin)
	    (fin? val)
	    (fin? fin)
	    (fin? sfin)
	    (fin? cfin)
	    (sfin? val)
	    (sfin? fin)
	    (sfin? sfin)
	    (sfin? cfin))))

;*---------------------------------------------------------------------*/
;*    intern ...                                                       */
;*---------------------------------------------------------------------*/
(define (intern)
   (let* ((f1 (make-foo 1 "yuyu" 4 "zuzu"))
	  (f2 (instantiate::foo (x 2) (z-len 5)))
	  (f3 (duplicate::foo f2 (x 3) (z "zaza")))
	  (p  (cons 1 f3))
	  (f4 (make-gee p p))
	  (f5 (instantiate::foo (x 3) (z-len 2)))
	  (r  (instantiate::readc (x 10 5))))
      (widen!::fool f5 (dummy f4))
      (let ((obj (make-vector 7 f2)))
	 (vector-set! obj 0 (cons f1 f1))
	 (vector-set! obj 3 f4)
	 (vector-set! obj 4 f5)
	 (vector-set! obj 5 f5)
	 (vector-set! obj 6 r)
	 (let ((bis (string->obj (obj->string obj))))
	    ;; each test must be true
	    (and (eq? (car (vector-ref bis 0)) (cdr (vector-ref bis 0)))
		 (eq? (vector-ref bis 1) (vector-ref bis 2))
		 (eq? (gee-x (vector-ref bis 3)) (gee-y (vector-ref bis 3)))
		 (foo? (cdr (gee-x (vector-ref bis 3))))
		 (eq? (cdr (gee-x (vector-ref bis 3)))
		      (cdr (gee-y (vector-ref bis 3))))
		 (eq? (fool-dummy (vector-ref bis 5))
		      (vector-ref bis 3))
		 (eq? (vector-ref bis 4) (vector-ref bis 5))
		 (eq? (readc-x-ref (vector-ref obj 6) 4)
		      (readc-x-ref (vector-ref bis 6) 4)))))))

;*---------------------------------------------------------------------*/
;*    test-equal? ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-equal?)
   (let ((o (instantiate::toto
	       (y #\a)
	       (yy #\b)
	       (z 10 'toto)
	       (t 'tata)))
	 (o2 (instantiate::toto
		(y #\a)
		(yy #\b)
		(z 10 'toto)
		(t 'tata)))
	 (o3 (instantiate::toto
		(x 4)
		(y #\a)
		(yy #\b)
		(z 10 'toto)
		(t 'tata)))
	 (o4 (instantiate::toto
		(y #\a)
		(yy #\b)
		(z 9 'toto)
		(t 'tata))))
      (and (equal? o o2) (not (equal? o o3)) (not (equal? o o4)))))

;*---------------------------------------------------------------------*/
;*    test-with-access ...                                             */
;*---------------------------------------------------------------------*/
(define (test-with-access g u)
   (with-access::gee u (x y)
      (define (hux x::bool)
	 x)
      (hux g)))
	 
;*---------------------------------------------------------------------*/
;*    test-object ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-object)
   (test-module "object" "object.scm")
   (test "access" (access) 1)
   (test "wide-dispatch" (wide-dispatch) '(1 (2 . 1) (3 . 1) 1))
   (test "predicat" (predicat) '(#t #t #t #t #f #t #t #t #f #f #t #f))
   (test "intern" (intern) #t)
   (test "with-access" (test-with-access #t (instantiate::gee (x 4) (y 6))) #t)
   (test "equal?" (test-equal?) #t)
   (test "import" (let ((f (instantiate::foo2
			      (x 4)
			      (y 6))))
		     (with-access::foo2 f (x y)
			(+fx x y)))
	 10)
   (test "import" (let ((f (instantiate::bar2
			      (a 4)
			      (b 6))))
		     (with-access::bar2 f (a b)
			(+fx a b)))
	 10))

