;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/number.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 28 10:52:56 1992                          */
;*    Last change :  Wed Apr  1 14:09:46 1998 (serrano)                */
;*                                                                     */
;*    On test les operateurs generiques sur les nombres                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module number
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-number)))

;*---------------------------------------------------------------------*/
;*    test-number ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-number)
   (test-module "number" "number.scm")
   (test "=" (= 1 1) #t)
   (test "=" (= 1 1 1) #t)
   (test "=" (= 1 2 1) #f)
   (test "=" (= 1.0 1.0 1.0) #t)
   (test "=" (= 1.0 2.0 1.0) #f)
   (test "<" (< 1 2) #t)
   (test "<" (< 1 1) #f) 
   (test "<" (< 2 1) #f)
   (test "<" (< 1 2 3) #t)
   (test "<" (< 1 2 1 3) #f)
   (test ">" (> 1 2) #f)
   (test ">" (> 1 1) #f)
   (test ">" (> 2 1) #t)
   (test ">" (> 3 2 1) #t)
   (test ">" (> 3 1 2 1) #f)
   (test ">=" (>= 1 2) #f)
   (test ">=" (>= 1 1) #t)
   (test ">=" (>= 2 1) #t)
   (test ">=" (>= 3 2 1) #t)
   (test ">=" (>= 3 1 2 1) #f)
   (test "<=" (<= 1 2) #t)
   (test "<=" (<= 1 1) #t)
   (test "<=" (<= 2 1) #f)
   (test "<=" (<= 1 2 3) #t)
   (test "<=" (<= 1 2 1 3) #f)
   (test "+" (+ 1 2 3 4) 10)
   (test "-" (- 1 2 3 4) -8)
   (test "-" (let ((x 4.0)) (- x)) -4.0)
   (test "*" (* 1 2 3 4) 24)
   (test "/" (/ 12 3 2 1) 2)
   (test "/" (/ (/ 4)) 4.0)
   (test "/fx" (/fx 5 4) 1)
   (test "/fx" (integer? (/fx 5 4)) #t)
   (test "zero?" (zero? 3) #f)
   (test "zero?" (zero? 0) #t)
   (test "zero?" (zero? 3.0) #f)
   (test "zero?" (zero? 0.0) #t)
   (test "positive?" (positive? 5.0) #t)
   (test "positive?" (positive? -5.0) #f)
   (test "positive?" (positive? 5) #t)
   (test "positive?" (positive? -5) #f)
   (test "negative?" (negative? 5.0) #f)
   (test "negative?" (negative? -5.0) #t)
   (test "negative?" (negative? 5) #f)
   (test "negative?" (negative? -5) #t)
   (test "odd?" (odd? 4) #f)
   (test "odd?" (odd? 3) #t)
   (test "even?" (even? 4) #t)
   (test "even?" (even? 3) #f)
   (test "max" (max 3 4) 4)
   (test "max" (max 3.9 4) 4)
   (test "min" (min 3 4) 3) 
   (test "min" (min 3.9 4) 3.9)
   (test "modulo" (modulo 13 4) 1)
   (test "remainder" (remainder 13 4) 1)
   (test "modulo" (modulo -13 4) 3)
   (test "remainder" (remainder -13 4) -1)
   (test "modulo" (modulo 13 -4) -3)
   (test "remainder" (remainder 13 -4) 1)
   (test "modulo" (modulo -13 -4) -1)
   (test "remainder" (remainder -13 -4) -1)
   (test "gcd" (gcd 32 -36) 4)
   (test "gcd" (gcd) 0)
   (test "lcm" (lcm 32 -36) 288)
   (test "lcm" (lcm) 1)
   (test "flonum->fixnum" (flonum->fixnum (cosfl 0.0)) 1)
   (test "atan" (tan (atan 1)) (fixnum->flonum 1))
   (test "flofix.<" (< 3.0 3) #f)
   (test "flofix.<" (< 3.1 3) #f)
   (test "flofix.<" (< 3.1 4) #t)
   (test "flofix.>" (> 3 3.0) #f)
   (test "flofix.>" (> 3 3.1) #f)
   (test "flofix.>" (> 4 3.1) #t)
   (test "flofix.<=" (<= 3 3.0) #t)
   (test "flofix.<=" (<= 3 3.1) #t)
   (test "flofix.<=" (<= 3 2.0) #f)
   (test "flofix.>=" (>= 3.0 3) #t)
   (test "flofix.>=" (>= 3.1 3) #t)
   (test "flofix.>=" (>= 3.1 4) #f)
   (let ((x 3.0) (y 3))
      (test "flofix.<" (< x y) #f))
   (let ((x 3.1) (y 3))
      (test "flofix.<" (< x y) #f))
   (let ((x 3.1) (y 4))
      (test "flofix.<" (< x y) #t))
   (let ((x 3) (y 3.0))
      (test "flofix.>" (> x y) #f))
   (let ((x 3) (y 3.1))
      (test "flofix.>" (> x y) #f))
   (let ((x 4) (y 3.1))
      (test "flofix.>" (> x y) #t))
   (let ((x 3) (y 3.0))
      (test "flofix.<=" (<= x y) #t))
   (let ((x 3) (y 3.1))
      (test "flofix.<=" (<= x y) #t))
   (let ((x 3) (y 2.0))
      (test "flofix.<=" (<= x y) #f))
   (let ((x 3.0) (y 3))
      (test "flofix.>=" (>= x y) #t))
   (let ((x 3.1) (y 3))
      (test "flofix.>=" (>= 3.1 3) #t))
   (let ((x 3.1) (y 4))
      (test "flofix.>=" (>= 3.1 4) #f))
   (let ((x -0.2) (y 0))
      (test "flofix.<" (< x y) #t))
   (test "string->number" (string->number "7F" 16) 127))
   
   
   
