;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/module.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan 29 10:56:02 1995                          */
;*    Last change :  Thu Apr  2 09:36:04 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les tests d'exportations                                         */
;*=====================================================================*/

(module module
   (include "test.sch")
   (import  (x import1 "import1.scm")
	    (y import1 "import1.scm")
	    (z import1 "import1.scm")
	    (import2 "import2.scm")
	    (main "main.scm"))
   (extern  (macro c-dummy1 (::string) "printf"))
   (export  fun
	    (test-modulel)
	    c-dummy1
	    c-dummy2)
   (extern  (macro c-dummy2 (::string) "printf")))

;*---------------------------------------------------------------------*/
;*    Le bug signale par David Gurr                                    */
;*---------------------------------------------------------------------*/
(define (foo x)
   x)

(define fun foo)

;*---------------------------------------------------------------------*/
;*    Bug pointed out by David Fox                                     */
;*---------------------------------------------------------------------*/
(define c-dummy1 #f)
(define c-dummy2 #f)

;*---------------------------------------------------------------------*/
;*    Le pbm de l'init avec le lecteur                                 */
;*---------------------------------------------------------------------*/
(define read 'bogus)
(set! read "re-bogus")

(define (init/read-test)
   (cons 'init '(1 2 3 4)))
 
;*---------------------------------------------------------------------*/
;*    test-modulel ...                                                 */
;*---------------------------------------------------------------------*/
(define (test-modulel)
   (test-module "module" "module.scm")
   (test "@" (@ x import1) 1)
   (test "@" (@ x import2) 2)
   (test "@" (or (eq? x (@ x import1)) (eq? x (@ x import2))) #t)
   (test "inline/type" (z) 1)
   (test "init/read" (init/read-test) '(init . (1 2 3 4))))
