;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/match.scm                    */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 10 16:37:46 1992                          */
;*    Last change :  Wed Apr  1 14:09:22 1998 (serrano)                */
;*                                                                     */
;*    Un essai de match-case                                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module match
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-match)
            (uncompilable x)))

;*---------------------------------------------------------------------*/
;*    match-test ...                                                   */
;*---------------------------------------------------------------------*/
(define (match-test)
   (let ((l '(let ((x 6))
		(+ x 5))))
      (match-case l
	 ((let ?bindings . ?body)
	  'ok)
	 (else
	  (print 'error)))))

;*---------------------------------------------------------------------*/
;*    match-test-2 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-2 x)
   (match-case x
      ;; 1- on definit une lambda typee
      ((?- ((?type ?name) . ?args) . ?body)
       'do-define-lambda)
      ;; 1- on definit une lambda non typee
      ((or (?- (?name . ?args) . ?body)
	   (?- ?name (lambda ?args . ?body)))
       'do-define-lambda)
      ;; 2- on definit une valeur non typee
      ((?- ?name . (?value . ()))
       'do-define-value)
      ;; 2b- on definit une valeur typee
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    match-test-3 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-3 x)
   (match-case x
      ((foo bar)
       x))
   #t)

;*---------------------------------------------------------------------*/
;*    match-test-4 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-4 x)
   (match-case x
      (((and ?let-part (let ?- ?body)) . ?args)
       'let)
      (((and ?x (labels ?- ?body)) . ?args)
       'app)
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    match-test-5 ...                                                 */
;*---------------------------------------------------------------------*/
(define (match-test-5 x)
   (match-case x
      ((atom ?-)
       'atom)
      (else
       'else)))

;*---------------------------------------------------------------------*/
;*    Une structure pour tester atom                                   */
;*---------------------------------------------------------------------*/
(define-struct s x)

;*---------------------------------------------------------------------*/
;*    Des tests sur le filtrage des structures                         */
;*---------------------------------------------------------------------*/
(define-struct int-point x y)
(define-struct real-point x y)

(define (is-in-circle? r p)
   (match-case p
      (#{int-point ?x ?y}
       (<=fx (+fx (*fx x x) (*fx y y)) (*fx r r)))
      (#{real-point ?x ?y}
       (<= (+fl (*fl x x) (*fl y y)) (* r r)))
      (else
       (error "is-in-circle?" "argument not a point" p))))

(define p-int (make-int-point))

(int-point-x-set! p-int 4)
(int-point-y-set! p-int -4)

(define p-real (make-real-point))

(real-point-x-set! p-real 4.4)
(real-point-y-set! p-real -4.4)

;; fonction non compilable avec bigloo1.6
(define (uncompilable exp)
   exp)
;*    (match-case exp                                                  */
;*       ((toto ??- ti ti . ?-)                                        */
;*        1)))                                                         */

;*---------------------------------------------------------------------*/
;*    test-match ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-match)
   (test-module "match" "match.scm")
   (test "let" (match-test) 'ok)
   (test "expand-define" (match-test-2 '(define (foo x) x)) 'do-define-lambda)
   (test "expand-define" (match-test-2 '(define foo (lambda (x) x)))
	 'do-define-lambda)
   (test "expand-define" (match-test-2 '(define foo 3))
	 'do-define-value)
   (test "expand-define" (match-test-2 '(define foo))
	 'else)
   (test "expand" (match-test-3 8) #t)
   (test "match-test-4" (match-test-4 '((labels ((gee (x) x)) gee) 1)) 'app)
   (test "atom" (match-test-5 '(1 2 3)) 'else)
   (test "atom" (match-test-5 '#(1 2 3)) 'atom)
   (test "atom" (match-test-5 (make-s)) 'atom)
   (test "structure" (is-in-circle? 10 p-int) #t)
   (test "structure" (is-in-circle? 10 p-real) #t)
   (test "structure" (begin (match-lambda (#{int-point} 'toto)) #t) #t)
   (test "??- vs trigraph" (pair? (expand '(match-case x ((??- . ?x) 1)))) #t))
	
