;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/macro.scm                    */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov 23 15:13:19 1992                          */
;*    Last change :  Wed Apr  1 14:09:16 1998 (serrano)                */
;*                                                                     */
;*    Des tests d'expanseurs.                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module macro
   (import  (main "main.scm"))
   (include "test.sch")
   (static  (integer->char))
   (export  (test-macro)))

;*---------------------------------------------------------------------*/
;*    defun ...                                                        */
;*---------------------------------------------------------------------*/
(define-expander defun 
   (lambda (f e)
      (e `(define ,(cadr f) 
	     (begin
		,@(cddr f)
		1))
	 e)))

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(defun (foo x y)
   (+ x y))

;*---------------------------------------------------------------------*/
;*    integer->char ...                                                */
;*---------------------------------------------------------------------*/
(define (integer->char)
   1)

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*    -------------------------------------------------------------    */
;*    On verifie que les O-macros sont ecrasables par des variables    */
;*    locales                                                          */
;*---------------------------------------------------------------------*/
(define (bar read)
   (read))

;*---------------------------------------------------------------------*/
;*    Les formes interpretees                                          */
;*---------------------------------------------------------------------*/
(define-expander put
   (define a 4)
   (define b 6)
   (lambda (x e) ''dummy))

(put)

(define-macro (get)
   (+ a b))

(define eval-macro (get))

;*---------------------------------------------------------------------*/
;*    Une macro dans un case sur des integers (ca plantait jusqu'a     */
;*    la premiere version 1.6)                                         */
;*---------------------------------------------------------------------*/
(define-macro (case-test-macro x)
   x)

(define (case-macro x)
   (case (case-test-macro x)
      ((1) 1)
      ((2) 2)
      (else 3)))

;*---------------------------------------------------------------------*/
;*    test-macro ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-macro)
   (test-module "macro" "macro.scm")
   (test "expander" (foo 1 2) 1)
   (test "O-macro" (integer->char) 1)
   (test "O-macro" (bar (lambda () 1)) 1)
   (test "eval" eval-macro 10)
   (test "case-macro" (case-macro 2) 2))

 
