;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/inline.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Nov  6 10:40:50 1992                          */
;*    Last change :  Wed Apr  1 14:08:53 1998 (serrano)                */
;*                                                                     */
;*    Des petits tests qui verifie que l'inlining se fait              */
;*    convenablement.                                                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module inline
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-inline)
	    (link-with x)
	    (gee-inline a b c d e f)
	    (foo-inline x)
	    (type-hux x)))

;*---------------------------------------------------------------------*/
;*    link-with ...                                                    */
;*    -------------------------------------------------------------    */
;*    A compilation bug introduced when optimization var, var          */
;*    let bindings (see file Inline/inline.scm, let-var construction). */
;*---------------------------------------------------------------------*/
(define (link-with scm-files)
   (let ((exp '(8)))
      (let ((foo exp))
	 (let ((p foo))
	    (if p
		(letrec ((try-120
			  (lambda (g-119)
			     (let ((res (if 8
					    (try-120 8)
					    p)))
				5
				res))))
		   (try-120 9))
		6)
	    6))))

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define (foo a)
   (define (hux x)
      (let* ((formal (cadr x)))
	 formal))
   hux)
 
;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define bar
   (let ((a 1))
      (lambda ()
	 (set! a (+ 1 a))
	 (list a a a a))))
 
;*---------------------------------------------------------------------*/
;*    hux ...                                                          */
;*---------------------------------------------------------------------*/
(define (hux)
   (cadr (bar)))

;*---------------------------------------------------------------------*/
;*    loop ...                                                         */
;*---------------------------------------------------------------------*/
(define (loop x . y)
   (if (>fx x 1)
       (loop 1 y)
       y))

;*---------------------------------------------------------------------*/
;*    loop2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (loop2 n s1 s2 test)
   (if (=fx n 0)
       'done
       (loop2 (-fx n 1) s1 s2 (equal? s1 s2))))

;*---------------------------------------------------------------------*/
;*    Inline of exported recursive functions                           */
;*---------------------------------------------------------------------*/
(define (gee-inline a b c d e f)
   (gee-inline a b c d e f))

(define (foo-inline x)
   (gee-inline 1 2 3 4 5 6)
   (gee-inline 1 2 3 4 5 6))

;*---------------------------------------------------------------------*/
;*    Type result                                                      */
;*---------------------------------------------------------------------*/
(define (type-hux x) x)

(define-inline (type-foo::char x)
   (type-hux x))

(define (type-gee x)
   ;; the inlining of (foo x) must produce a type error
   (try (type-foo x)
	(lambda (a b c d)
	   (a (+fx x 1)))))

;*---------------------------------------------------------------------*/
;*    test-inline ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-inline)
   (test-module "inline" "inline.scm")
   (test "inline" ((foo 1) '(1 2 3 4)) 2)
   (test "type-rq" (hux) 2)
   (test "loop" (loop 2 2) '((2)))
   (test "loop" (loop2 10 2 2 #f) 'done)
   (test "type" (type-gee 4) 5))
