;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/hygien.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Feb 27 12:52:59 1998                          */
;*    Last change :  Wed Apr  1 14:08:37 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Hygienic macro tests                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module hygien
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-hygien))
   (option  (set! *hygien?* #t)))

;*---------------------------------------------------------------------*/
;*    global syntax                                                    */
;*---------------------------------------------------------------------*/
(define-syntax funcall
  (syntax-rules ()
     ((funcall function arguments ...)
      (function arguments ...) ) ) )

(define-syntax unless
   (syntax-rules ()
      ((unless condition form ...)
       (if (not condition) (begin form ...)) ) ) )

(define-syntax when
  (syntax-rules ()
    ((when condition form ...)
     (if condition (begin form ...)) ) ) )

(define-syntax progn
  (syntax-rules ()
    ((progn body ...)
     (begin body ...) ) ) )

(define (test1)
  (list
   (let ((f (lambda (x) (funcall cons x x))))
     (funcall f (+ 2 3)) )
   (let ((x 'a))
     (unless 1 (set! x 'b) 3)
     x )
   (unless #f 2 3)
   (let ((x 'a))
     (unless #f (set! x 'b) 3)
     x )
   (progn (when #f 2 3) (when 1 2 3))
   (let ((x 'a))
     (when #f (set! x 'b) 3)
     x )
   ) )

(define (test1-eval)
   (eval '(set! *hygien?* #t))
	     
   (eval '(define-syntax funcall
	     (syntax-rules ()
		((funcall function arguments ...)
		 (function arguments ...) ) ) ) )

   (eval '(define-syntax unless
	     (syntax-rules ()
		((unless condition form ...)
		 (if (not condition) (begin form ...)) ) ) ) )

   (eval '(define-syntax when
	     (syntax-rules ()
		((when condition form ...)
		 (if condition (begin form ...)) ) ) ) )

   (eval '(define-syntax progn
	     (syntax-rules ()
		((progn body ...) 
		 (begin body ...) ) ) ) )

   (eval '(define (test1)
	     (list
	      (let ((f (lambda (x) (funcall cons x x))))
		 (funcall f (+ 2 3)) )
	      (let ((x 'a))
		 (unless 1 (set! x 'b) 3)
		 x )
	      (unless #f 2 3)
	      (let ((x 'a))
		 (unless #f (set! x 'b) 3)
		 x )
	      (progn (when #f 2 3) (when 1 2 3))
	      (let ((x 'a))
		 (when #f (set! x 'b) 3)
		 x )
	      ) ) )
   (eval '(test1)))

;*---------------------------------------------------------------------*/
;*    test-hygien ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-hygien)
   (test-module "hygien" "hygien.scm")
   (test "let-syntax"
	 (let-syntax ((when (syntax-rules ()
			       ((when test stmt1 stmt2 ...)
				(if test
				    (begin stmt1 stmt2 ...))))))
	    (let ((if #t))
	       (when if (set! if 'now))
	       if))
	 'now)
   (test "let-syntax"
	 (let ((x 'outer))
	    (let-syntax ((m (syntax-rules () ((m) x))))
	       (let ((x 'inner))
		  (m))))
	 'outer)
   (test "letrec-syntax"
	 (letrec-syntax ((my-or (syntax-rules ()
				   ((my-or) #f)
				   ((my-or e) e)
				   ((my-or e1 e2 ...)
				    (let ((temp e1))
				       (if temp
					   temp
					   (my-or e2 ...)))))))
	    (let ((x #f)
		  (y 7)
		  (temp 8)
		  (let odd?)
		  (if even?))
	       (my-or x
		      (let temp)
		      (if y)
		      y)))
	 7)
   (test "define-syntax" (test1) '((5 . 5) a 3 b 3 a))
   (test "eval" (test1-eval) '((5 . 5) a 3 b 3 a)))


