;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/hash.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 26 11:50:50 1994                          */
;*    Last change :  Wed Apr  1 14:08:32 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On test les tables de hash                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module hash
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-hash)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1)
   (let ((table (make-hash-table 256 string->0..255 car string=?)))
      ;; on remplis la table
      (let loop ((i 1024))
	 (if (=fx i 0)
	     (and (eq? (cdr (get-hash "object834" table)) 834)
		  (eq? (cdr (get-hash "object835" table)) 835)
		  (eq? (cdr (get-hash "object836" table)) 836)
		  (eq? (cdr (get-hash "object837" table)) 837)
		  (not (eq? (cdr (get-hash "object134" table)) 834))
		  (not (eq? (cdr (get-hash "object135" table)) 835))
		  (not (eq? (cdr (get-hash "object136" table)) 836))
		  (not (eq? (cdr (get-hash "object137" table)) 837)))
	     (begin
		(put-hash! (cons (string-append "object"
						(number->string i))
				 i)
			   table)
		(loop (-fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2)
   (let ((table (make-hash-table 4096 (lambda (o)
					 (string->0..2^x-1 o 12))
				 car string=? 256)))
      ;; on remplis la table
      (let loop ((i 10024))
	 (if (=fx i 0)
	     (and (eq? (cdr (get-hash "object5834" table)) 5834)
		  (eq? (cdr (get-hash "object5835" table)) 5835)
		  (eq? (cdr (get-hash "object5836" table)) 5836)
		  (eq? (cdr (get-hash "object5837" table)) 5837)
		  (not (eq? (cdr (get-hash "object9134" table)) 5834))
		  (not (eq? (cdr (get-hash "object9135" table)) 5835))
		  (not (eq? (cdr (get-hash "object9136" table)) 5836))
		  (not (eq? (cdr (get-hash "object9137" table)) 5837)))
	     (begin
		(put-hash! (cons (string-append "object"
						(number->string i))
				 i)
			   table)
		(loop (-fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test3)
   (let ((table (make-hash-table 256 obj->0..255 (lambda (x) x) eq?)))
      (put-hash! 123 table)
      (if (eq? (get-hash 123 table) 123)
	  (begin
	     (rem-obj-hash! 123 table)
	     (if (not (get-hash 123 table))
		 #t
		 #f))
	  #f)))
      
;*---------------------------------------------------------------------*/
;*    test-hash ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-hash)
   (test-module "hash" "hash.scm")
   (test "hash" (test1) #t)
   (test "hash" (test2) #t)
   (test "hash" (test3) #t))

