;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/flonum.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 26 11:59:37 1992                          */
;*    Last change :  Wed Apr  1 14:07:07 1998 (serrano)                */
;*                                                                     */
;*    On test un peu les flotants (il le faut bien).                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module flonum
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-flonum)))

;*---------------------------------------------------------------------*/
;*    fact ...                                                         */
;*---------------------------------------------------------------------*/
(define (fact x)
   (if (< x 2)
       1
       (* (fact (- x 1)) x)))

;*---------------------------------------------------------------------*/
;*    sqrt-test ...                                                    */
;*---------------------------------------------------------------------*/
(define (sqrt-test x::double)
   (sqrt x))

;*---------------------------------------------------------------------*/
;*    test-flonum ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-flonum)
   (test-module "flonum" "flonum.scm")
   (test "flonum"   3.141592 3.141592)
   (test "flonum"   (/ (inexact->exact (cos 0)) 2) 0.5)
   (test "flonum"   (/ 1 2) 0.5)
   (test "flonum"   23.56 (+fl 23.0 0.56))
   (test "cos"      (sin 0) 0.0)
   (test "cos"      (acos (cos 2.0)) 2.0)
   (test "round"    (round 4.3) 4.0)
   (test "exact"    (exact? 5) #t)
   (test "exact"    (exact? 5.0) #f)
   (test "inexact"  (inexact? 5) #f)
   (test "inexact"  (inexact? 5.0) #t)
   (test "exact"    (inexact->exact 4.3) 4)
   (test "fact"     (fact 5) 120)
   (test "fact"     (fact 5.0) 120.0)
   (test "floor"    (floor -4.3) -5.0)
   (test "ceiling"  (ceiling -4.3) -4.0)
   (test "truncate" (truncate -4.3) -4.0)
   (test "round"    (round -4.3) -4.0)
   (test "floor"    (floor 3.5) 3.0)
   (test "ceiling"  (ceiling 3.5) 4.0)
   (test "truncate" (truncate 3.5) 3.0)
   (test "round"    (round 3.5) 4.0)
   (test "sqrt"     (sqrt-test 4.0) 2.0)
   (test "atan"     (let ((r (atan 1.0 1.0))) (> r 0)) #t)
   (test "prec"     (let ((num (+ 1e-6 1e-12)))
		       (=fl (string->number (number->string num)) num))
	            #t))

