;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/error.scm                    */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 16 15:41:47 1993                          */
;*    Last change :  Tue Jun  9 09:53:50 1998 (serrano)                */
;*                                                                     */
;*    On test le fonctionnement des `error-handler'                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module error
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-error)))

;*---------------------------------------------------------------------*/
;*    gee ...                                                          */
;*---------------------------------------------------------------------*/
(define (gee x)
   (if x
       '()
       1))

;*---------------------------------------------------------------------*/
;*    handler ...                                                      */
;*---------------------------------------------------------------------*/
(define (handler a b c d)
   (a #f))

;*---------------------------------------------------------------------*/
;*    try-test ...                                                     */
;*---------------------------------------------------------------------*/
(define (try-test)
   (let ((handler1
	  (lambda (w x y z) (w #t)))
	 (handler2
	  (lambda (w x y z) (w #f))))
      (try
       (begin
	  (try
	   (error 'error 1 1)
	   handler2)
	  (error 'error 2 2))
       handler1)))

;*---------------------------------------------------------------------*/
;*    try-test-2 ...                                                   */
;*---------------------------------------------------------------------*/
(define (try-test-2)
   (try (try (car 1)
	     (lambda (escape obj proc msg)
		(error obj proc msg)))
	(lambda (escape obj proc msg)
	   (escape #t))))

;*---------------------------------------------------------------------*/
;*    side-effect ...                                                  */
;*---------------------------------------------------------------------*/
(define (side-effect x)
   (let ((y x))
      (try (begin
	      (set! y 7)
	      (error 1 2 3)
	      4)
	   (lambda (a b c d)
	      (a 3)))))

;*---------------------------------------------------------------------*/
;*    error-port ...                                                   */
;*---------------------------------------------------------------------*/
(define (error-port)
   (let ((p (open-output-string)))
      (with-error-to-port p
			  (lambda ()
			     (display 5 (current-error-port))))
      (close-output-port p)))
 
;*---------------------------------------------------------------------*/
;*    test-error ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-error)
   (test-module "error" "error.scm")
   (test "type error (car)" (try (car (gee #f)) handler) #f)
   (test "type error (integer)" (try (=fx (gee #f) 7) handler) #f)
   (test "type error (string)" (try (string-ref (gee #f) (gee #f)) handler) #f)
   (test "type error" (try (integer? (string-length (gee #f))) handler) #f)
   (test "type error" (try (pair? (string-length (gee #f))) handler) #f)
   (test "try" (try-test) #t)
   (test "try-2" (try-test-2) #t)
   (test "side effect" (side-effect 3) 3)
   (test "error port" (error-port) "5"))
