;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/define.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan  7 16:20:22 1993                          */
;*    Last change :  Sun May 24 06:50:09 1998 (serrano)                */
;*                                                                     */
;*    On test les `define's internes                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module define
   (import  (main "main.scm")
	    (fun  module "module.scm"))
   (include "test.sch")
   (export  (test-define)))

;*---------------------------------------------------------------------*/
;*    aliasing                                                         */
;*---------------------------------------------------------------------*/
(define (foo1 x) (+fx x 1))
(define gee1 foo1)

(define (foo2 . x) (+fx (car x) 1))
(define gee2 foo2)

(define (foo3 x . y) (apply + (cons x y)))
(define gee3 foo3)

(define (foo4) 5)
(define gee4 foo4)

(define (foo5 x) (+fx x 1))
(define gee5 foo5)
(set! foo5 (lambda (y) 9))

(define-inline (foo6 x)
   (define (foo-inner x)
      x)
   (foo-inner x))

;*---------------------------------------------------------------------*/
;*    typed inner define                                               */
;*---------------------------------------------------------------------*/
(define (typed-define y)
   (define (inner::int x) x)
   (inner y))

;*---------------------------------------------------------------------*/
;*    n-ary inner define                                               */
;*---------------------------------------------------------------------*/
(define (n-ary-define y)
   (define (inner x . y) (cons x y))
   (inner y y))

;*---------------------------------------------------------------------*/
;*    n-ary typed inner define                                         */
;*---------------------------------------------------------------------*/
(define (n-ary-typed-define y)
   (define (inner::pair x . y) (cons x y))
   (inner y y))

;*---------------------------------------------------------------------*/
;*    untyped inner define ...                                         */
;*---------------------------------------------------------------------*/
(define (set-derives)
  (define dset  (make-vector 10 -1))
  dset)

;*---------------------------------------------------------------------*/
;*    test-define ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-define)
   (test-module "define" "define.scm")
   (test "internal" (test1 1) 1)
   (test "internal" (test3 1) 1)
   (test "internal" (test4 1) 1)
   (test "internal" (test5 (lambda (x)
			      (define (bar x)
				 (define (hux x)
				    x)
				 (hux x))
			      (bar x))) 1)
   (test "internal" (test5 (lambda (x)
			      (define (bar x)
				 x)
			      (bar x))) 1)
   (test "function" (procedure? fun) #t)
   (test "alias" (gee1 5) 6)
   (test "alias" (gee2 5) 6)
   (test "alias" (gee3 5 6) 11)
   (test "alias" (gee4) 5)
   (test "alias" (gee5 5) 6)
   (test "alias" (foo5 5) 9)
   (test "inline" (foo6 6) 6)
   (test "inner"  (typed-define 5) 5)
   (test "inner"  (n-ary-define 5) '(5 5))
   (test "inner"  (n-ary-typed-define 5) '(5 5))
   (test "inner"  (vector? (set-derives)) #t))

;*---------------------------------------------------------------------*/
;*    Une forme top-level                                              */
;*---------------------------------------------------------------------*/
(lambda (x)
   (define (bar x)
      x)
   (bar x))
 
(lambda (x)
   (define (bar x)
      (define (hux x)
	 x)
      (hux x))
   (bar x))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define test1
   (lambda (x)
      (define (bar x)
	 x)
      (bar x)))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test3 x)
   (define (bar x)
      x)
   (bar x))

;*---------------------------------------------------------------------*/
;*    test4 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test4 x)
   (define (bar x)
      (define (hux x)
	 x)
      (hux x))
   (bar x))

;*---------------------------------------------------------------------*/
;*    test5 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test5 f)
   (f 1))


