;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/cse.scm                      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 29 17:25:53 1993                          */
;*    Last change :  Wed Apr  1 14:06:24 1998 (serrano)                */
;*                                                                     */
;*    On test l'elimination de sous expression commune.                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cse
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-cse)))

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define (foo x)
   (let ((y (car x)))
      (set-car! x 3)
      (let ((z (car x)))
	 z)))

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define (bar x)
   (let ((y (car x)))
      (foo x)
      (let ((z (car x)))
	 z)))

;*---------------------------------------------------------------------*/
;*    gee ...                                                          */
;*---------------------------------------------------------------------*/
(define (gee l::pair)
   ;; this function was badly compiled due to a bug in the cse
   ;; that propagate the binding (a (c-car l)) into the loop.
   (let ((a (c-car l)))
      (let loop ((a a))
	 (if (c-pair? a)
	     (begin
		(c-set-car! l '(3))
		(loop (c-cdr a)))
	     (let ((a (c-car l)))
		(c-set-cdr! a 4)
		a))))) 

;*---------------------------------------------------------------------*/
;*    test-cse ...                                                     */
;*---------------------------------------------------------------------*/
(define (test-cse)
   (test-module "cse" "cse.scm")
   (test "cse" (foo '(1 2)) 3)
   (test "cse" (bar '(1 2)) 3)
   (test "cse" (gee '((1))) '(3 . 4)))

