;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/cell.scm                     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 29 17:16:25 1992                          */
;*    Last change :  Wed Apr  1 14:20:02 1998 (serrano)                */
;*                                                                     */
;*    Un essai de fonction qui kapture des variables qui doivent       */
;*    etre placees dans des variables d'indirection.                   */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    le module                                                        */
;*---------------------------------------------------------------------*/
(module glo_cell
   (import  (main "main.scm"))
   (static  (test1 a b)
	    (test2 a b . c)
	    (test3 . c))
   (include "test.sch")
   (export  (test-cell)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1 a b)
   (labels ((foo (x) (set! x b) x))
      foo))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 a b . c)
   (labels ((foo (x y) (set! c y) y)
	    (bar (z)   (foo 2 1))
	    (hux (t)   (set! a (foo t t)) c))
      hux))

;*---------------------------------------------------------------------*/
;*    test3                                                            */
;*---------------------------------------------------------------------*/
(define (test3 . c)
   (let ((a 0)
	 (b 0))
      (labels ((foo (x) (set! a x) a)
	       (bar (y) (set! b y) (foo b)))
	 (bar 1)
	 foo)))
      
;*---------------------------------------------------------------------*/
;*    test-cell ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-cell)
   (test-module "glo_cell" "cell.scm")
   (test "cell" ((test1 1 2) 3) 2)
   (test "cell" ((test2 1 2 3 4) 2) 2)
   (test "cell" ((test3 1 2 3 4) 2) 2))
   
