/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/recette/c-file.c                     */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue May 19 15:37:20 1992                          */
/*    Last change :  Thu Dec  7 10:26:23 1995 (serrano)                */
/*                                                                     */
/*    Le fichier C du foreign-test                                     */
/*---------------------------------------------------------------------*/
#include "c-file.h"

/*---------------------------------------------------------------------*/
/*    Une variable globale                                             */
/*---------------------------------------------------------------------*/
int var = 9;

/*---------------------------------------------------------------------*/
/*    Un pointeur vers une fonction                                    */
/*---------------------------------------------------------------------*/
static int lolo( int x )
{
   return 4 + x;
}

int (*f1)(int) = &lolo;

/*---------------------------------------------------------------------*/
/*    Une recuperation externe                                         */
/*---------------------------------------------------------------------*/
extern struct el *malloc();

/*---------------------------------------------------------------------*/
/*    bar ...                                                          */
/*---------------------------------------------------------------------*/
bar( x )
int x;
{
   return x+1;
}

/*---------------------------------------------------------------------*/
/*    hux ...                                                          */
/*---------------------------------------------------------------------*/
char *
hux( s )
char *s;
{
   static char string[ 500 ];

   strcpy( string, "TOTO EST CONTENT" );

   return string;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    sum_el ...                                                       */
/*---------------------------------------------------------------------*/
int
sum_el( head )
struct el *head;
{
	int val = 0;

	while( head )
	   val += head->key, head = head->next;

	return val;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    sum_tab ...                                                      */
/*---------------------------------------------------------------------*/
double
sum_tab( tab, max )
int tab[];
int max;
{
	double res;
	int    i;

	for( i = 0, res = 0.0; i< max; res = res + (double)(tab[ i ]), i++ )
	   ;
	
	return res;
}

/*---------------------------------------------------------------------*/
/*    struct el*                                                       */
/*    define_el ...                                                    */
/*---------------------------------------------------------------------*/
struct el*
define_el( key )
int key;
{
	struct el* res;
	
	res = malloc( sizeof( struct el) );

	res->key = key;

	return res;
}

/*---------------------------------------------------------------------*/
/*    make_dummy_el ...                                                */
/*---------------------------------------------------------------------*/
struct el *
make_dummy_el()
{
	static struct el *_truc_ = 0L;
	
	if( _truc_ )
	   return _truc_;
	else
	{
		_truc_ = malloc( sizeof( struct el ) );

		_truc_->next = 0L;
		_truc_->key  = -2;

		return _truc_;
	}
}


	
